package main

import (
	"fmt"
	"html/template"
	"log"
	"os"
)

func main() {
	log.SetFlags(0)

	base := `
{{ define "base" -}}
	<title>{{ template "title" . -}}</title>
{{ end -}}

{{ define "title" }}{{ end -}}
`[1:]

	page := `
{{ template "base" . }}
{{ define "title" }}OK{{ end -}}
`[1:]

	t1 := template.New("")
	t1 = t1.Funcs(template.FuncMap{})
	t1 = template.Must(t1.New("base").Parse(base))

	for i := 0; i < 2; i++ {
		t2 := template.Must(t1.Clone())
		t2 = template.Must(t2.New(fmt.Sprintf("%d", i)).Parse(page))

		err := t2.Execute(os.Stdout, nil)
		if err != nil {
			log.Fatalf("err=%q", err)
		}
	}
}
