// https://github.com/golang/go/issues/15658

package main

/* stdlib includes */
//line golang.org/issue/15658/2016-05-11.go:4
import (
	"fmt"
	"os/exec"
)

func run(done chan struct{}) {
	cmd := exec.Command("true")
	if err := cmd.Start(); err != nil {
		goto finished
	}

	cmd.Wait()

finished:
	done <- struct{}{}
	return
}

func main() {
	fmt.Println("Starting a bunch of goroutines...")

	// 8 & 16 are arbitrary
	done := make(chan struct{}, 16)

	for i := 0; i < 8; i++ {
		go run(done)
	}

	for {
		select {
		case <-done:
			go run(done)
		}
	}
}
