package main

import (
	"os/exec"
	"runtime"
	"sync"
)

func init() {
	runtime.LockOSThread()
	// growMs(3 * runtime.GOMAXPROCS(0))
}

func main() {
	for i := 0; i < 8; i++ {
		go run()
	}
	select {}
}

func run() {
	for {
		cmd := exec.Command("true")
		err := cmd.Start()
		if err != nil {
			continue
		}
		cmd.Wait()
	}
}

func growMs(count int) {
	var wg sync.WaitGroup
	done := make(chan struct{})
	for i := 0; i < count; i++ {
		wg.Add(1)
		go func() {
			defer wg.Done()
			runtime.LockOSThread()
			defer runtime.UnlockOSThread()
			<-done
		}()
	}
	close(done)
	wg.Wait()
}
