// +build gofuzz

package fuzz

import (
	"html/template"
	"io/ioutil"
)

func Fuzz(data []byte) int {
	tmpl, err := template.New("").Parse(string(data))
	if err != nil {
		return 0
	}

	input := struct {
		A interface{}
		B interface{}
	}{
		A: (*int)(nil),
		B: nil,
	}

	tmpl.Execute(ioutil.Discard, input)

	return 1
}
