package main

import (
	"log"
	"net"
	"time"
)

func main() {
	d := &net.Dialer{
		Timeout: 6400 * time.Millisecond,
	}

	for {
		go func() {
			start := time.Now().UTC()
			c, err := d.Dial("udp", "tmi.twitch.tv:80")
			if err != nil {
				log.Printf("dial err=%q", err)
				return
			}
			err = c.Close()
			if err != nil {
				log.Printf("close err=%q", err)
			}
			dur := time.Since(start)
			log.Printf("duration=%dms", dur/time.Millisecond)
		}()
		time.Sleep(100 * time.Millisecond)
	}
}
