// +build ignore

package main

import (
	"flag"
	"log"
	"time"

	"code.justin.tv/common/chitin"
	"code.justin.tv/release/trace/api"
	"golang.org/x/net/context"
	"google.golang.org/grpc"
)

func main() {
	target := flag.String("target", "trace-api.prod.us-west2.justin.tv:11143", "Host and port of gRPC server")
	flag.Parse()

	ctx := context.Background()

	err := chitin.ExperimentalTraceProcessOptIn()
	if err != nil {
		log.Fatalf("chitin err=%q", err)
	}

	cc, err := grpc.Dial(*target, grpc.WithInsecure())
	if err != nil {
		log.Fatalf("Dial err=%q", err)
	}
	go func() {
		state := grpc.Idle
		for i := 0; i < 10; i++ {
			var err error
			state, err = cc.WaitForStateChange(context.Background(), state)
			if err != nil {
				log.Fatalf("state err=%q", err)
			}
			log.Printf("state=%q", state)
		}
	}()

	cl := api.NewTraceClient(cc)

	for i := 0; ; i++ {
		t := 1 * time.Second
		ctx, cancel := context.WithTimeout(ctx, t)
		fire, err := cl.Firehose(ctx, &api.FirehoseRequest{
			Sampling: 1,
		})
		if err != nil {
			log.Fatalf("fire err=%q", err)
		}

		j := 0
		for ; j < 2; j++ {
			_, err := fire.Recv()
			if err != nil {
				break
			}
		}
		log.Printf("i=%d j=%d", i, j)
		if true {
			cancel()
		}
		<-ctx.Done()
	}
}
