package repro

import (
	"context"
	"crypto/tls"
	"net/http"
	"net/http/httptest"
	"testing"
	"time"
	// "code.justin.tv/video/timeoutheaders"
)

func BenchmarkHelloWorld(b *testing.B) {
	b.ReportAllocs()

	var h http.Handler
	h = http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {

	})

	// h = timeoutheaders.Handler(h)

	s := httptest.NewUnstartedServer(h)
	s.TLS = &tls.Config{NextProtos: []string{"h2"}}
	s.StartTLS()
	s.Client().Transport.(*http.Transport).ForceAttemptHTTP2 = true
	defer s.Close()

	c := &http.Client{
		Transport: s.Client().Transport,
	}
	// c.Transport = &timeoutheaders.RoundTripper{Base: c.Transport}

	ctx := context.Background()
	ctx, cancel := context.WithTimeout(ctx, 1*time.Hour)
	defer cancel()

	for i := 0; i < b.N; i++ {
		req, err := http.NewRequest("GET", s.URL, nil)
		if err != nil {
			b.Errorf("NewRequest: %v", err)
			return
		}
		req = req.WithContext(ctx)
		resp, err := c.Do(req)
		if err != nil {
			b.Errorf("GET: %v", err)
			return
		}
		resp.Body.Close()
	}
}
