package maphack

import (
	"reflect"
	"unsafe"
)

const (
	bucketCnt = 8
)

type hmapA struct {
	count int
	flags uint32
	hash0 uint32
	B     uint8

	buckets    unsafe.Pointer
	oldbuckets unsafe.Pointer
	nevacuate  uintptr
}

type bmapA struct {
	tophash  [bucketCnt]uint8
	overflow *bmapA
}

type stats struct {
	nbucket   int
	noverflow int
}

func statsA(m interface{}) stats {
	var s stats

	mv := reflect.ValueOf(m)
	hm := (*hmapA)(unsafe.Pointer(mv.Pointer()))

	var siz uintptr
	// TODO: calculate bucket size
	siz += 8 + 8
	siz += 8*8 + 8*0

	for i := uintptr(0); i < 1<<hm.B; i++ {
		var bucket *bmapA
		bucket = (*bmapA)(unsafe.Pointer(uintptr(hm.buckets) + siz*i))

		s.noverflow--
		for ; bucket != nil; bucket = bucket.overflow {
			s.noverflow++
		}
	}

	s.nbucket = 1 << hm.B

	return s
}
