//line sql.y:6
package pgparse

import __yyfmt__ "fmt"

//line sql.y:6
import "bytes"

func SetParseTree(yylex interface{}, stmt Statement) {
	yylex.(*Tokenizer).ParseTree = stmt
}

func SetAllowComments(yylex interface{}, allow bool) {
	yylex.(*Tokenizer).AllowComments = allow
}

func ForceEOF(yylex interface{}) {
	yylex.(*Tokenizer).ForceEOF = true
}

var (
	SHARE        = []byte("share")
	MODE         = []byte("mode")
	IF_BYTES     = []byte("if")
	VALUES_BYTES = []byte("values")
)

//line sql.y:31
type yySymType struct {
	yys         int
	empty       struct{}
	statement   Statement
	selStmt     SelectStatement
	byt         byte
	bytes       []byte
	bytes2      [][]byte
	str         string
	selectExprs SelectExprs
	selectExpr  SelectExpr
	columns     Columns
	colName     *ColName
	tableExprs  TableExprs
	tableExpr   TableExpr
	smTableExpr SimpleTableExpr
	tableName   *TableName
	indexHints  *IndexHints
	expr        Expr
	boolExpr    BoolExpr
	valExpr     ValExpr
	colTuple    ColTuple
	valExprs    ValExprs
	values      Values
	rowTuple    RowTuple
	subquery    *Subquery
	caseExpr    *CaseExpr
	whens       []*When
	when        *When
	orderBy     OrderBy
	order       *Order
	limit       *Limit
	insRows     InsertRows
	updateExprs UpdateExprs
	updateExpr  *UpdateExpr
}

const LEX_ERROR = 57346
const SELECT = 57347
const INSERT = 57348
const UPDATE = 57349
const DELETE = 57350
const FROM = 57351
const WHERE = 57352
const GROUP = 57353
const HAVING = 57354
const ORDER = 57355
const BY = 57356
const NULLS = 57357
const FIRST = 57358
const LAST = 57359
const LIMIT = 57360
const OFFSET = 57361
const FOR = 57362
const ALL = 57363
const DISTINCT = 57364
const AS = 57365
const EXISTS = 57366
const IN = 57367
const IS = 57368
const LIKE = 57369
const BETWEEN = 57370
const NULL = 57371
const ASC = 57372
const DESC = 57373
const VALUES = 57374
const INTO = 57375
const DUPLICATE = 57376
const KEY = 57377
const DEFAULT = 57378
const SET = 57379
const LOCK = 57380
const FALSE_P = 57381
const TRUE_P = 57382
const ID = 57383
const STRING = 57384
const NUMBER = 57385
const VALUE_ARG = 57386
const LIST_ARG = 57387
const COMMENT = 57388
const TIME = 57389
const ZONE = 57390
const LE = 57391
const GE = 57392
const NE = 57393
const NULL_SAFE_EQUAL = 57394
const UNION = 57395
const MINUS = 57396
const EXCEPT = 57397
const INTERSECT = 57398
const JOIN = 57399
const STRAIGHT_JOIN = 57400
const LEFT = 57401
const RIGHT = 57402
const INNER = 57403
const OUTER = 57404
const CROSS = 57405
const NATURAL = 57406
const USE = 57407
const FORCE = 57408
const ON = 57409
const OR = 57410
const AND = 57411
const NOT = 57412
const AT = 57413
const UNARY = 57414
const CASE = 57415
const WHEN = 57416
const THEN = 57417
const ELSE = 57418
const END = 57419
const CREATE = 57420
const ALTER = 57421
const DROP = 57422
const RENAME = 57423
const ANALYZE = 57424
const TABLE = 57425
const INDEX = 57426
const VIEW = 57427
const TO = 57428
const IGNORE = 57429
const IF = 57430
const UNIQUE = 57431
const USING = 57432
const SHOW = 57433
const DESCRIBE = 57434
const EXPLAIN = 57435

var yyToknames = []string{
	"LEX_ERROR",
	"SELECT",
	"INSERT",
	"UPDATE",
	"DELETE",
	"FROM",
	"WHERE",
	"GROUP",
	"HAVING",
	"ORDER",
	"BY",
	"NULLS",
	"FIRST",
	"LAST",
	"LIMIT",
	"OFFSET",
	"FOR",
	"ALL",
	"DISTINCT",
	"AS",
	"EXISTS",
	"IN",
	"IS",
	"LIKE",
	"BETWEEN",
	"NULL",
	"ASC",
	"DESC",
	"VALUES",
	"INTO",
	"DUPLICATE",
	"KEY",
	"DEFAULT",
	"SET",
	"LOCK",
	"FALSE_P",
	"TRUE_P",
	"ID",
	"STRING",
	"NUMBER",
	"VALUE_ARG",
	"LIST_ARG",
	"COMMENT",
	"TIME",
	"ZONE",
	"LE",
	"GE",
	"NE",
	"NULL_SAFE_EQUAL",
	"'('",
	"'='",
	"'<'",
	"'>'",
	"'~'",
	"UNION",
	"MINUS",
	"EXCEPT",
	"INTERSECT",
	"','",
	"JOIN",
	"STRAIGHT_JOIN",
	"LEFT",
	"RIGHT",
	"INNER",
	"OUTER",
	"CROSS",
	"NATURAL",
	"USE",
	"FORCE",
	"ON",
	"OR",
	"AND",
	"NOT",
	"'&'",
	"'|'",
	"'^'",
	"'+'",
	"'-'",
	"'*'",
	"'/'",
	"'%'",
	"AT",
	"'.'",
	"UNARY",
	"CASE",
	"WHEN",
	"THEN",
	"ELSE",
	"END",
	"CREATE",
	"ALTER",
	"DROP",
	"RENAME",
	"ANALYZE",
	"TABLE",
	"INDEX",
	"VIEW",
	"TO",
	"IGNORE",
	"IF",
	"UNIQUE",
	"USING",
	"SHOW",
	"DESCRIBE",
	"EXPLAIN",
}
var yyStatenames = []string{}

const yyEofCode = 1
const yyErrCode = 2
const yyMaxDepth = 200

//line yacctab:1
var yyExca = []int{
	-1, 1,
	1, -1,
	-2, 0,
}

const yyNprod = 212
const yyPrivate = 57344

var yyTokenNames []string
var yyStates []string

const yyLast = 647

var yyAct = []int{

	94, 299, 161, 376, 91, 85, 339, 252, 62, 164,
	92, 372, 291, 243, 199, 210, 63, 387, 179, 163,
	3, 80, 387, 81, 137, 136, 50, 104, 187, 76,
	263, 264, 265, 266, 267, 387, 268, 269, 65, 131,
	235, 70, 64, 297, 73, 68, 131, 53, 77, 259,
	125, 131, 51, 52, 28, 29, 30, 31, 86, 233,
	235, 38, 72, 40, 389, 244, 43, 41, 44, 388,
	121, 350, 14, 15, 16, 17, 321, 317, 319, 129,
	329, 349, 386, 49, 133, 348, 328, 323, 274, 69,
	296, 45, 165, 286, 160, 162, 166, 122, 284, 135,
	124, 46, 47, 48, 18, 234, 118, 236, 318, 114,
	137, 136, 152, 173, 65, 120, 71, 65, 64, 183,
	182, 64, 177, 137, 136, 170, 331, 244, 136, 289,
	345, 292, 255, 181, 86, 205, 183, 149, 150, 151,
	152, 209, 207, 208, 217, 218, 184, 224, 225, 226,
	227, 228, 229, 230, 231, 204, 197, 206, 203, 128,
	19, 20, 22, 21, 23, 347, 346, 212, 116, 130,
	237, 86, 86, 24, 25, 26, 65, 65, 311, 292,
	64, 250, 309, 312, 248, 315, 254, 310, 256, 314,
	239, 241, 313, 116, 247, 235, 251, 147, 148, 149,
	150, 151, 152, 357, 333, 193, 219, 28, 29, 30,
	31, 180, 180, 220, 237, 257, 273, 260, 277, 278,
	117, 275, 131, 223, 222, 175, 213, 202, 191, 203,
	276, 14, 59, 194, 211, 71, 14, 282, 283, 201,
	367, 176, 212, 86, 366, 263, 264, 265, 266, 267,
	290, 268, 269, 365, 232, 101, 288, 294, 109, 298,
	221, 295, 285, 261, 116, 103, 102, 66, 98, 99,
	100, 167, 202, 171, 169, 168, 307, 308, 111, 167,
	66, 272, 325, 107, 201, 327, 190, 192, 189, 203,
	203, 112, 330, 134, 115, 322, 75, 320, 65, 271,
	335, 304, 334, 336, 337, 340, 105, 106, 303, 196,
	195, 71, 178, 126, 110, 123, 119, 60, 79, 74,
	326, 240, 113, 97, 353, 332, 58, 351, 101, 108,
	341, 109, 281, 391, 352, 384, 185, 127, 103, 102,
	84, 98, 99, 100, 354, 78, 56, 237, 54, 362,
	361, 364, 89, 385, 363, 14, 107, 373, 369, 370,
	340, 300, 301, 375, 371, 344, 377, 377, 377, 65,
	378, 379, 374, 64, 302, 88, 253, 380, 343, 105,
	106, 82, 246, 214, 180, 215, 216, 110, 392, 381,
	382, 306, 393, 280, 394, 97, 61, 390, 368, 14,
	101, 32, 108, 109, 33, 186, 14, 39, 238, 258,
	103, 102, 84, 98, 99, 100, 188, 34, 35, 36,
	37, 42, 67, 249, 89, 97, 174, 383, 107, 358,
	101, 338, 342, 109, 305, 287, 172, 242, 96, 93,
	103, 102, 66, 98, 99, 100, 95, 88, 293, 90,
	245, 105, 106, 82, 89, 138, 87, 316, 107, 110,
	200, 262, 198, 83, 270, 132, 55, 27, 97, 57,
	13, 12, 11, 101, 108, 10, 109, 88, 9, 8,
	7, 105, 106, 103, 102, 66, 98, 99, 100, 110,
	6, 5, 4, 2, 1, 0, 0, 89, 0, 101,
	0, 107, 109, 0, 108, 0, 0, 0, 0, 103,
	102, 66, 98, 99, 100, 0, 0, 0, 0, 0,
	88, 0, 0, 167, 105, 106, 0, 107, 359, 360,
	0, 0, 110, 0, 0, 139, 143, 141, 142, 356,
	0, 0, 0, 0, 0, 0, 0, 108, 0, 355,
	105, 106, 0, 0, 0, 0, 0, 0, 110, 156,
	157, 158, 159, 0, 153, 154, 155, 0, 0, 0,
	0, 0, 0, 108, 0, 144, 145, 146, 147, 148,
	149, 150, 151, 152, 0, 0, 140, 144, 145, 146,
	147, 148, 149, 150, 151, 152, 0, 0, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 144, 145, 146,
	147, 148, 149, 150, 151, 152, 324, 0, 144, 145,
	146, 147, 148, 149, 150, 151, 152, 279, 0, 144,
	145, 146, 147, 148, 149, 150, 151, 152, 144, 145,
	146, 147, 148, 149, 150, 151, 152,
}
var yyPact = []int{

	67, -1000, -1000, 149, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -37,
	-34, -7, 3, -15, -1000, -1000, -1000, 394, 327, -1000,
	-1000, -1000, 324, -1000, 293, 276, 387, 239, -58, -10,
	194, -1000, -36, 194, -1000, 278, -74, 194, -74, 277,
	-1000, -1000, -1000, -1000, -1000, 371, -1000, 232, 276, 285,
	23, 276, 131, -1000, 166, -1000, 20, 275, 39, 194,
	-1000, -1000, 274, -1000, -51, 272, 313, 86, 194, -1000,
	160, -1000, -1000, 270, 13, 49, 510, -1000, 444, 401,
	-1000, -1000, -1000, 470, 222, 221, -1000, 220, -1000, -1000,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	470, -1000, 188, 239, 271, 374, 239, 470, 194, -1000,
	312, -77, -1000, 192, -1000, 269, -1000, -1000, 268, -1000,
	186, 371, -1000, -1000, 194, 75, 444, 444, 470, 181,
	358, 470, 470, 184, 470, 470, 470, 470, 470, 470,
	470, 470, 207, -1000, -1000, -1000, -1000, -1000, -1000, -1000,
	-1000, 510, -50, -4, -2, 510, -1000, 226, 299, 371,
	-1000, 394, -24, 561, 350, 239, 239, 202, -1000, 363,
	444, -1000, 561, -1000, -1000, -1000, 59, 194, -1000, -52,
	-1000, -1000, -1000, -1000, -1000, -1000, -1000, -1000, 201, 182,
	258, 231, 2, -1000, -1000, -1000, -1000, -1000, 53, 561,
	-1000, 226, -1000, -1000, 181, 470, 470, 561, 552, 384,
	-1000, 303, -1000, -1000, 117, 117, 117, 55, 55, 27,
	27, 27, 189, -1000, -1000, 470, -1000, 561, -1000, -11,
	371, -16, 38, -1000, 444, 58, 218, 149, 106, -19,
	-1000, 363, 343, 360, 49, 267, -1000, -1000, 260, -1000,
	380, 186, 186, -1000, -1000, 119, 115, 129, 126, 122,
	6, -1000, 256, -33, 254, -22, -1000, 561, 541, 470,
	280, -1000, 470, 561, -1000, -23, -1000, -12, -1000, 470,
	36, -1000, 291, 142, -1000, -1000, -1000, 239, 343, -1000,
	470, 470, 470, -1000, -1000, 366, 351, 182, 57, -1000,
	103, -1000, 102, -1000, -1000, -1000, -1000, -14, -18, -28,
	-1000, -1000, -1000, -1000, 470, 561, -1000, -1000, -1000, -1000,
	561, 470, 289, 218, -1000, -1000, 530, 521, 141, -1000,
	498, -1000, 363, 444, 470, 444, -1000, -1000, 200, 191,
	187, 561, 561, 391, -1000, 470, 470, 470, -1000, 342,
	342, 343, 49, 133, 49, 194, 194, 194, 239, 561,
	561, -1000, -1000, 373, -1000, 315, -27, -1000, -40, -45,
	131, -1000, -1000, -1000, 390, 308, -1000, 194, -1000, -1000,
	-1000, 194, -1000, 194, -1000,
}
var yyPgo = []int{

	0, 494, 493, 19, 492, 491, 490, 480, 479, 478,
	475, 472, 471, 470, 401, 469, 467, 466, 21, 23,
	465, 464, 463, 462, 14, 461, 460, 232, 457, 3,
	18, 5, 456, 455, 450, 449, 2, 15, 9, 448,
	10, 446, 27, 439, 4, 438, 437, 13, 436, 435,
	434, 432, 7, 431, 6, 429, 1, 427, 426, 423,
	12, 8, 16, 296, 422, 421, 416, 409, 407, 405,
	0, 26, 404, 11,
}
var yyR1 = []int{

	0, 1, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 3, 3, 4, 4, 5, 6, 7,
	8, 8, 8, 9, 9, 9, 10, 11, 11, 11,
	12, 13, 13, 13, 72, 14, 15, 15, 16, 16,
	16, 16, 16, 17, 17, 18, 18, 19, 19, 19,
	22, 22, 20, 20, 20, 23, 23, 24, 24, 24,
	24, 21, 21, 21, 25, 25, 25, 25, 25, 25,
	25, 25, 25, 26, 26, 26, 27, 27, 28, 28,
	28, 28, 29, 29, 30, 30, 31, 31, 31, 31,
	31, 32, 32, 32, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 33, 33, 33, 33, 33, 33,
	33, 37, 37, 37, 42, 38, 38, 36, 36, 36,
	36, 36, 36, 36, 36, 36, 36, 36, 36, 36,
	36, 36, 36, 36, 36, 41, 41, 43, 43, 43,
	45, 48, 48, 46, 46, 47, 49, 49, 44, 44,
	35, 35, 35, 35, 35, 35, 50, 50, 51, 51,
	52, 52, 53, 53, 54, 55, 55, 55, 73, 73,
	73, 56, 56, 56, 56, 57, 57, 57, 58, 58,
	59, 59, 60, 60, 34, 34, 39, 39, 40, 40,
	61, 61, 62, 63, 63, 64, 64, 65, 65, 66,
	66, 66, 66, 66, 67, 67, 68, 68, 69, 69,
	70, 71,
}
var yyR2 = []int{

	0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 12, 3, 7, 7, 8, 7, 3,
	5, 8, 4, 6, 7, 4, 5, 4, 5, 5,
	3, 2, 2, 2, 0, 2, 0, 2, 1, 2,
	1, 1, 1, 0, 1, 1, 3, 1, 2, 3,
	1, 1, 0, 1, 2, 1, 3, 3, 3, 3,
	5, 0, 1, 2, 1, 1, 2, 3, 2, 3,
	2, 2, 2, 1, 3, 1, 1, 3, 0, 5,
	5, 5, 1, 3, 0, 2, 1, 3, 3, 2,
	3, 3, 3, 4, 3, 4, 5, 6, 5, 3,
	4, 3, 3, 2, 1, 1, 1, 1, 1, 1,
	1, 3, 1, 1, 3, 1, 3, 1, 1, 1,
	3, 3, 3, 3, 3, 3, 3, 3, 5, 2,
	3, 4, 5, 4, 1, 1, 1, 1, 1, 1,
	5, 0, 1, 1, 2, 4, 0, 2, 1, 3,
	1, 1, 1, 1, 1, 1, 0, 3, 0, 2,
	0, 3, 1, 3, 2, 0, 2, 2, 0, 2,
	2, 0, 4, 4, 2, 0, 2, 4, 0, 3,
	1, 3, 0, 5, 2, 1, 1, 3, 3, 1,
	1, 3, 3, 0, 2, 0, 3, 0, 1, 1,
	1, 1, 1, 1, 0, 1, 0, 1, 0, 2,
	1, 0,
}
var yyChk = []int{

	-1000, -1, -2, -3, -4, -5, -6, -7, -8, -9,
	-10, -11, -12, -13, 5, 6, 7, 8, 37, 93,
	94, 96, 95, 97, 106, 107, 108, -16, 58, 59,
	60, 61, -14, -72, -14, -14, -14, -14, 98, -68,
	100, 104, -65, 100, 102, 98, 98, 99, 100, 98,
	-71, -71, -71, -3, 21, -17, 22, -15, 33, -27,
	41, 9, -61, -62, -44, -70, 41, -64, 103, 99,
	-70, 41, 98, -70, 41, -63, 103, -70, -63, 41,
	-18, -19, 82, -22, 41, -31, -36, -32, 76, 53,
	-35, -44, -40, -43, -70, -41, -45, 24, 42, 43,
	44, 29, 40, 39, -42, 80, 81, 57, 103, 32,
	88, 46, -27, 37, 86, -27, 62, 54, 86, 41,
	76, -70, -71, 41, -71, 101, 41, 24, 73, -70,
	9, 62, -20, -70, 23, 86, 75, 74, -33, 25,
	76, 27, 28, 26, 77, 78, 79, 80, 81, 82,
	83, 84, 85, 54, 55, 56, 49, 50, 51, 52,
	-31, -36, -31, -3, -38, -36, -36, 53, 53, 53,
	-42, 53, -48, -36, -58, 37, 53, -61, 41, -30,
	10, -62, -36, -70, -71, 24, -69, 105, -66, 96,
	94, 36, 95, 13, 41, 41, 41, -71, -23, -24,
	-26, 53, 41, -42, -19, -70, 82, -31, -31, -36,
	-37, 53, -42, 45, 25, 27, 28, -36, -36, 22,
	29, 76, 40, 39, -36, -36, -36, -36, -36, -36,
	-36, -36, 47, 109, 109, 62, 109, -36, 109, -18,
	22, -18, -46, -47, 89, -34, 32, -3, -61, -59,
	-44, -30, -52, 13, -31, 73, -70, -71, -67, 101,
	-30, 62, -25, 63, 64, 65, 66, 67, 69, 70,
	-21, 41, 23, -24, 86, -38, -37, -36, -36, 75,
	9, 29, 48, -36, 109, -18, 109, -49, -47, 91,
	-31, -60, 73, -39, -40, -60, 109, 62, -52, -56,
	18, 19, 14, 41, 41, -50, 11, -24, -24, 63,
	68, 63, 68, 63, 63, 63, -28, 71, 102, 72,
	41, 109, 41, 109, 75, -36, 40, -36, 109, 92,
	-36, 90, 34, 62, -44, -56, -36, -36, -53, -54,
	-36, -71, -51, 12, 14, 73, 63, 63, 99, 99,
	99, -36, -36, 35, -40, 19, 18, 62, -55, 30,
	31, -52, -31, -38, -31, 53, 53, 53, 7, -36,
	-36, -54, -73, 15, -73, -56, -29, -70, -29, -29,
	-61, 16, 17, -57, 20, 38, 109, 62, 109, 109,
	7, 25, -70, -70, -70,
}
var yyDef = []int{

	0, -2, 1, 2, 3, 4, 5, 6, 7, 8,
	9, 10, 11, 12, 34, 34, 34, 34, 34, 206,
	197, 0, 0, 0, 211, 211, 211, 0, 38, 40,
	41, 42, 43, 36, 0, 0, 0, 0, 195, 0,
	0, 207, 0, 0, 198, 0, 193, 0, 193, 0,
	31, 32, 33, 14, 39, 0, 44, 35, 0, 0,
	76, 0, 19, 190, 0, 148, 210, 0, 0, 0,
	211, 210, 0, 211, 0, 0, 0, 0, 0, 30,
	0, 45, 47, 52, 210, 50, 51, 86, 0, 0,
	117, 118, 119, 0, 148, 0, 134, 0, 150, 151,
	152, 153, 154, 155, 189, 137, 138, 139, 135, 136,
	141, 37, 178, 0, 0, 84, 0, 0, 0, 211,
	0, 208, 22, 0, 25, 0, 27, 194, 0, 211,
	0, 0, 48, 53, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	0, 0, 0, 104, 105, 106, 107, 108, 109, 110,
	89, 0, 0, 0, 0, 115, 129, 0, 0, 0,
	103, 0, 0, 142, 0, 0, 0, 84, 77, 160,
	0, 191, 192, 149, 20, 196, 0, 0, 211, 204,
	199, 200, 201, 202, 203, 26, 28, 29, 84, 55,
	61, 0, 73, 75, 46, 54, 49, 87, 88, 91,
	92, 0, 112, 113, 0, 0, 0, 94, 0, 0,
	99, 0, 101, 102, 120, 121, 122, 123, 124, 125,
	126, 127, 0, 90, 114, 0, 188, 115, 130, 0,
	0, 0, 146, 143, 0, 182, 0, 185, 182, 0,
	180, 160, 171, 0, 85, 0, 209, 23, 0, 205,
	156, 0, 0, 64, 65, 0, 0, 0, 0, 0,
	78, 62, 0, 0, 0, 0, 93, 95, 0, 0,
	0, 100, 0, 116, 131, 0, 133, 0, 144, 0,
	0, 15, 0, 184, 186, 16, 179, 0, 171, 18,
	0, 0, 0, 211, 24, 158, 0, 56, 59, 66,
	0, 68, 0, 70, 71, 72, 57, 0, 0, 0,
	63, 58, 74, 111, 0, 96, 98, 128, 132, 140,
	147, 0, 0, 0, 181, 17, 174, 0, 161, 162,
	165, 21, 160, 0, 0, 0, 67, 69, 0, 0,
	0, 97, 145, 0, 187, 0, 0, 0, 164, 168,
	168, 171, 159, 157, 60, 0, 0, 0, 0, 172,
	173, 163, 166, 0, 167, 175, 0, 82, 0, 0,
	183, 169, 170, 13, 0, 0, 79, 0, 80, 81,
	176, 0, 83, 0, 177,
}
var yyTok1 = []int{

	1, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 84, 77, 3,
	53, 109, 82, 80, 62, 81, 86, 83, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	55, 54, 56, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 79, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 78, 3, 57,
}
var yyTok2 = []int{

	2, 3, 4, 5, 6, 7, 8, 9, 10, 11,
	12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
	22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
	32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
	42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
	52, 58, 59, 60, 61, 63, 64, 65, 66, 67,
	68, 69, 70, 71, 72, 73, 74, 75, 76, 85,
	87, 88, 89, 90, 91, 92, 93, 94, 95, 96,
	97, 98, 99, 100, 101, 102, 103, 104, 105, 106,
	107, 108,
}
var yyTok3 = []int{
	0,
}

//line yaccpar:1

/*	parser for yacc output	*/

var yyDebug = 0

type yyLexer interface {
	Lex(lval *yySymType) int
	Error(s string)
}

const yyFlag = -1000

func yyTokname(c int) string {
	// 4 is TOKSTART above
	if c >= 4 && c-4 < len(yyToknames) {
		if yyToknames[c-4] != "" {
			return yyToknames[c-4]
		}
	}
	return __yyfmt__.Sprintf("tok-%v", c)
}

func yyStatname(s int) string {
	if s >= 0 && s < len(yyStatenames) {
		if yyStatenames[s] != "" {
			return yyStatenames[s]
		}
	}
	return __yyfmt__.Sprintf("state-%v", s)
}

func yylex1(lex yyLexer, lval *yySymType) int {
	c := 0
	char := lex.Lex(lval)
	if char <= 0 {
		c = yyTok1[0]
		goto out
	}
	if char < len(yyTok1) {
		c = yyTok1[char]
		goto out
	}
	if char >= yyPrivate {
		if char < yyPrivate+len(yyTok2) {
			c = yyTok2[char-yyPrivate]
			goto out
		}
	}
	for i := 0; i < len(yyTok3); i += 2 {
		c = yyTok3[i+0]
		if c == char {
			c = yyTok3[i+1]
			goto out
		}
	}

out:
	if c == 0 {
		c = yyTok2[1] /* unknown char */
	}
	if yyDebug >= 3 {
		__yyfmt__.Printf("lex %s(%d)\n", yyTokname(c), uint(char))
	}
	return c
}

func yyParse(yylex yyLexer) int {
	var yyn int
	var yylval yySymType
	var yyVAL yySymType
	yyS := make([]yySymType, yyMaxDepth)

	Nerrs := 0   /* number of errors */
	Errflag := 0 /* error recovery flag */
	yystate := 0
	yychar := -1
	yyp := -1
	goto yystack

ret0:
	return 0

ret1:
	return 1

yystack:
	/* put a state and value onto the stack */
	if yyDebug >= 4 {
		__yyfmt__.Printf("char %v in %v\n", yyTokname(yychar), yyStatname(yystate))
	}

	yyp++
	if yyp >= len(yyS) {
		nyys := make([]yySymType, len(yyS)*2)
		copy(nyys, yyS)
		yyS = nyys
	}
	yyS[yyp] = yyVAL
	yyS[yyp].yys = yystate

yynewstate:
	yyn = yyPact[yystate]
	if yyn <= yyFlag {
		goto yydefault /* simple state */
	}
	if yychar < 0 {
		yychar = yylex1(yylex, &yylval)
	}
	yyn += yychar
	if yyn < 0 || yyn >= yyLast {
		goto yydefault
	}
	yyn = yyAct[yyn]
	if yyChk[yyn] == yychar { /* valid shift */
		yychar = -1
		yyVAL = yylval
		yystate = yyn
		if Errflag > 0 {
			Errflag--
		}
		goto yystack
	}

yydefault:
	/* default state action */
	yyn = yyDef[yystate]
	if yyn == -2 {
		if yychar < 0 {
			yychar = yylex1(yylex, &yylval)
		}

		/* look through exception table */
		xi := 0
		for {
			if yyExca[xi+0] == -1 && yyExca[xi+1] == yystate {
				break
			}
			xi += 2
		}
		for xi += 2; ; xi += 2 {
			yyn = yyExca[xi+0]
			if yyn < 0 || yyn == yychar {
				break
			}
		}
		yyn = yyExca[xi+1]
		if yyn < 0 {
			goto ret0
		}
	}
	if yyn == 0 {
		/* error ... attempt to resume parsing */
		switch Errflag {
		case 0: /* brand new error */
			yylex.Error("syntax error")
			Nerrs++
			if yyDebug >= 1 {
				__yyfmt__.Printf("%s", yyStatname(yystate))
				__yyfmt__.Printf(" saw %s\n", yyTokname(yychar))
			}
			fallthrough

		case 1, 2: /* incompletely recovered error ... try again */
			Errflag = 3

			/* find a state where "error" is a legal shift action */
			for yyp >= 0 {
				yyn = yyPact[yyS[yyp].yys] + yyErrCode
				if yyn >= 0 && yyn < yyLast {
					yystate = yyAct[yyn] /* simulate a shift of "error" */
					if yyChk[yystate] == yyErrCode {
						goto yystack
					}
				}

				/* the current p has no shift on "error", pop stack */
				if yyDebug >= 2 {
					__yyfmt__.Printf("error recovery pops state %d\n", yyS[yyp].yys)
				}
				yyp--
			}
			/* there is no state on the stack with an error shift ... abort */
			goto ret1

		case 3: /* no shift yet; clobber input char */
			if yyDebug >= 2 {
				__yyfmt__.Printf("error recovery discards %s\n", yyTokname(yychar))
			}
			if yychar == yyEofCode {
				goto ret1
			}
			yychar = -1
			goto yynewstate /* try again in the same state */
		}
	}

	/* reduction by production yyn */
	if yyDebug >= 2 {
		__yyfmt__.Printf("reduce %v in:\n\t%v\n", yyn, yyStatname(yystate))
	}

	yynt := yyn
	yypt := yyp
	_ = yypt // guard against "declared and not used"

	yyp -= yyR2[yyn]
	yyVAL = yyS[yyp+1]

	/* consult goto table to find next state */
	yyn = yyR1[yyn]
	yyg := yyPgo[yyn]
	yyj := yyg + yyS[yyp].yys + 1

	if yyj >= yyLast {
		yystate = yyAct[yyg]
	} else {
		yystate = yyAct[yyj]
		if yyChk[yystate] != -yyn {
			yystate = yyAct[yyg]
		}
	}
	// dummy call; replaced with literal code
	switch yynt {

	case 1:
		//line sql.y:152
		{
			SetParseTree(yylex, yyS[yypt-0].statement)
		}
	case 2:
		//line sql.y:158
		{
			yyVAL.statement = yyS[yypt-0].selStmt
		}
	case 3:
		yyVAL.statement = yyS[yypt-0].statement
	case 4:
		yyVAL.statement = yyS[yypt-0].statement
	case 5:
		yyVAL.statement = yyS[yypt-0].statement
	case 6:
		yyVAL.statement = yyS[yypt-0].statement
	case 7:
		yyVAL.statement = yyS[yypt-0].statement
	case 8:
		yyVAL.statement = yyS[yypt-0].statement
	case 9:
		yyVAL.statement = yyS[yypt-0].statement
	case 10:
		yyVAL.statement = yyS[yypt-0].statement
	case 11:
		yyVAL.statement = yyS[yypt-0].statement
	case 12:
		yyVAL.statement = yyS[yypt-0].statement
	case 13:
		//line sql.y:174
		{
			yyVAL.selStmt = &Select{Comments: Comments(yyS[yypt-10].bytes2), Distinct: yyS[yypt-9].str, SelectExprs: yyS[yypt-8].selectExprs, From: yyS[yypt-6].tableExprs, Where: NewWhere(AST_WHERE, yyS[yypt-5].boolExpr), GroupBy: GroupBy(yyS[yypt-4].valExprs), Having: NewWhere(AST_HAVING, yyS[yypt-3].boolExpr), OrderBy: yyS[yypt-2].orderBy, Limit: yyS[yypt-1].limit, Lock: yyS[yypt-0].str}
		}
	case 14:
		//line sql.y:178
		{
			yyVAL.selStmt = &Union{Type: yyS[yypt-1].str, Left: yyS[yypt-2].selStmt, Right: yyS[yypt-0].selStmt}
		}
	case 15:
		//line sql.y:184
		{
			yyVAL.statement = &Insert{Comments: Comments(yyS[yypt-5].bytes2), Table: yyS[yypt-3].tableName, Columns: yyS[yypt-2].columns, Rows: yyS[yypt-1].insRows, OnDup: OnDup(yyS[yypt-0].updateExprs)}
		}
	case 16:
		//line sql.y:188
		{
			cols := make(Columns, 0, len(yyS[yypt-1].updateExprs))
			vals := make(ValTuple, 0, len(yyS[yypt-1].updateExprs))
			for _, col := range yyS[yypt-1].updateExprs {
				cols = append(cols, &NonStarExpr{Expr: col.Name})
				vals = append(vals, col.Expr)
			}
			yyVAL.statement = &Insert{Comments: Comments(yyS[yypt-5].bytes2), Table: yyS[yypt-3].tableName, Columns: cols, Rows: Values{vals}, OnDup: OnDup(yyS[yypt-0].updateExprs)}
		}
	case 17:
		//line sql.y:200
		{
			yyVAL.statement = &Update{Comments: Comments(yyS[yypt-6].bytes2), Table: yyS[yypt-5].tableName, Exprs: yyS[yypt-3].updateExprs, Where: NewWhere(AST_WHERE, yyS[yypt-2].boolExpr), OrderBy: yyS[yypt-1].orderBy, Limit: yyS[yypt-0].limit}
		}
	case 18:
		//line sql.y:206
		{
			yyVAL.statement = &Delete{Comments: Comments(yyS[yypt-5].bytes2), Table: yyS[yypt-3].tableName, Where: NewWhere(AST_WHERE, yyS[yypt-2].boolExpr), OrderBy: yyS[yypt-1].orderBy, Limit: yyS[yypt-0].limit}
		}
	case 19:
		//line sql.y:212
		{
			yyVAL.statement = &Set{Comments: Comments(yyS[yypt-1].bytes2), Exprs: yyS[yypt-0].updateExprs}
		}
	case 20:
		//line sql.y:218
		{
			yyVAL.statement = &DDL{Action: AST_CREATE, NewName: yyS[yypt-1].bytes}
		}
	case 21:
		//line sql.y:222
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyS[yypt-1].bytes, NewName: yyS[yypt-1].bytes}
		}
	case 22:
		//line sql.y:227
		{
			yyVAL.statement = &DDL{Action: AST_CREATE, NewName: yyS[yypt-1].bytes}
		}
	case 23:
		//line sql.y:233
		{
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyS[yypt-2].bytes, NewName: yyS[yypt-2].bytes}
		}
	case 24:
		//line sql.y:237
		{
			// Change this to a rename statement
			yyVAL.statement = &DDL{Action: AST_RENAME, Table: yyS[yypt-3].bytes, NewName: yyS[yypt-0].bytes}
		}
	case 25:
		//line sql.y:242
		{
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyS[yypt-1].bytes, NewName: yyS[yypt-1].bytes}
		}
	case 26:
		//line sql.y:248
		{
			yyVAL.statement = &DDL{Action: AST_RENAME, Table: yyS[yypt-2].bytes, NewName: yyS[yypt-0].bytes}
		}
	case 27:
		//line sql.y:254
		{
			yyVAL.statement = &DDL{Action: AST_DROP, Table: yyS[yypt-0].bytes}
		}
	case 28:
		//line sql.y:258
		{
			// Change this to an alter statement
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyS[yypt-0].bytes, NewName: yyS[yypt-0].bytes}
		}
	case 29:
		//line sql.y:263
		{
			yyVAL.statement = &DDL{Action: AST_DROP, Table: yyS[yypt-1].bytes}
		}
	case 30:
		//line sql.y:269
		{
			yyVAL.statement = &DDL{Action: AST_ALTER, Table: yyS[yypt-0].bytes, NewName: yyS[yypt-0].bytes}
		}
	case 31:
		//line sql.y:275
		{
			yyVAL.statement = &Other{}
		}
	case 32:
		//line sql.y:279
		{
			yyVAL.statement = &Other{}
		}
	case 33:
		//line sql.y:283
		{
			yyVAL.statement = &Other{}
		}
	case 34:
		//line sql.y:288
		{
			SetAllowComments(yylex, true)
		}
	case 35:
		//line sql.y:292
		{
			yyVAL.bytes2 = yyS[yypt-0].bytes2
			SetAllowComments(yylex, false)
		}
	case 36:
		//line sql.y:298
		{
			yyVAL.bytes2 = nil
		}
	case 37:
		//line sql.y:302
		{
			yyVAL.bytes2 = append(yyS[yypt-1].bytes2, yyS[yypt-0].bytes)
		}
	case 38:
		//line sql.y:308
		{
			yyVAL.str = AST_UNION
		}
	case 39:
		//line sql.y:312
		{
			yyVAL.str = AST_UNION_ALL
		}
	case 40:
		//line sql.y:316
		{
			yyVAL.str = AST_SET_MINUS
		}
	case 41:
		//line sql.y:320
		{
			yyVAL.str = AST_EXCEPT
		}
	case 42:
		//line sql.y:324
		{
			yyVAL.str = AST_INTERSECT
		}
	case 43:
		//line sql.y:329
		{
			yyVAL.str = ""
		}
	case 44:
		//line sql.y:333
		{
			yyVAL.str = AST_DISTINCT
		}
	case 45:
		//line sql.y:339
		{
			yyVAL.selectExprs = SelectExprs{yyS[yypt-0].selectExpr}
		}
	case 46:
		//line sql.y:343
		{
			yyVAL.selectExprs = append(yyVAL.selectExprs, yyS[yypt-0].selectExpr)
		}
	case 47:
		//line sql.y:349
		{
			yyVAL.selectExpr = &StarExpr{}
		}
	case 48:
		//line sql.y:353
		{
			yyVAL.selectExpr = &NonStarExpr{Expr: yyS[yypt-1].expr, As: yyS[yypt-0].bytes}
		}
	case 49:
		//line sql.y:357
		{
			yyVAL.selectExpr = &StarExpr{TableName: yyS[yypt-2].bytes}
		}
	case 50:
		//line sql.y:363
		{
			yyVAL.expr = yyS[yypt-0].boolExpr
		}
	case 51:
		//line sql.y:367
		{
			yyVAL.expr = yyS[yypt-0].valExpr
		}
	case 52:
		//line sql.y:372
		{
			yyVAL.bytes = nil
		}
	case 53:
		//line sql.y:376
		{
			yyVAL.bytes = yyS[yypt-0].bytes
		}
	case 54:
		//line sql.y:380
		{
			yyVAL.bytes = yyS[yypt-0].bytes
		}
	case 55:
		//line sql.y:386
		{
			yyVAL.tableExprs = TableExprs{yyS[yypt-0].tableExpr}
		}
	case 56:
		//line sql.y:390
		{
			yyVAL.tableExprs = append(yyVAL.tableExprs, yyS[yypt-0].tableExpr)
		}
	case 57:
		//line sql.y:396
		{
			yyVAL.tableExpr = &AliasedTableExpr{Expr: yyS[yypt-2].smTableExpr, As: yyS[yypt-1].bytes, Hints: yyS[yypt-0].indexHints}
		}
	case 58:
		//line sql.y:400
		{
			yyVAL.tableExpr = &ParenTableExpr{Expr: yyS[yypt-1].tableExpr}
		}
	case 59:
		//line sql.y:404
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyS[yypt-2].tableExpr, Join: yyS[yypt-1].str, RightExpr: yyS[yypt-0].tableExpr}
		}
	case 60:
		//line sql.y:408
		{
			yyVAL.tableExpr = &JoinTableExpr{LeftExpr: yyS[yypt-4].tableExpr, Join: yyS[yypt-3].str, RightExpr: yyS[yypt-2].tableExpr, On: yyS[yypt-0].boolExpr}
		}
	case 61:
		//line sql.y:413
		{
			yyVAL.bytes = nil
		}
	case 62:
		//line sql.y:417
		{
			yyVAL.bytes = yyS[yypt-0].bytes
		}
	case 63:
		//line sql.y:421
		{
			yyVAL.bytes = yyS[yypt-0].bytes
		}
	case 64:
		//line sql.y:427
		{
			yyVAL.str = AST_JOIN
		}
	case 65:
		//line sql.y:431
		{
			yyVAL.str = AST_STRAIGHT_JOIN
		}
	case 66:
		//line sql.y:435
		{
			yyVAL.str = AST_LEFT_JOIN
		}
	case 67:
		//line sql.y:439
		{
			yyVAL.str = AST_LEFT_JOIN
		}
	case 68:
		//line sql.y:443
		{
			yyVAL.str = AST_RIGHT_JOIN
		}
	case 69:
		//line sql.y:447
		{
			yyVAL.str = AST_RIGHT_JOIN
		}
	case 70:
		//line sql.y:451
		{
			yyVAL.str = AST_JOIN
		}
	case 71:
		//line sql.y:455
		{
			yyVAL.str = AST_CROSS_JOIN
		}
	case 72:
		//line sql.y:459
		{
			yyVAL.str = AST_NATURAL_JOIN
		}
	case 73:
		//line sql.y:465
		{
			yyVAL.smTableExpr = &TableName{Name: yyS[yypt-0].bytes}
		}
	case 74:
		//line sql.y:469
		{
			yyVAL.smTableExpr = &TableName{Qualifier: yyS[yypt-2].bytes, Name: yyS[yypt-0].bytes}
		}
	case 75:
		//line sql.y:473
		{
			yyVAL.smTableExpr = yyS[yypt-0].subquery
		}
	case 76:
		//line sql.y:479
		{
			yyVAL.tableName = &TableName{Name: yyS[yypt-0].bytes}
		}
	case 77:
		//line sql.y:483
		{
			yyVAL.tableName = &TableName{Qualifier: yyS[yypt-2].bytes, Name: yyS[yypt-0].bytes}
		}
	case 78:
		//line sql.y:488
		{
			yyVAL.indexHints = nil
		}
	case 79:
		//line sql.y:492
		{
			yyVAL.indexHints = &IndexHints{Type: AST_USE, Indexes: yyS[yypt-1].bytes2}
		}
	case 80:
		//line sql.y:496
		{
			yyVAL.indexHints = &IndexHints{Type: AST_IGNORE, Indexes: yyS[yypt-1].bytes2}
		}
	case 81:
		//line sql.y:500
		{
			yyVAL.indexHints = &IndexHints{Type: AST_FORCE, Indexes: yyS[yypt-1].bytes2}
		}
	case 82:
		//line sql.y:506
		{
			yyVAL.bytes2 = [][]byte{yyS[yypt-0].bytes}
		}
	case 83:
		//line sql.y:510
		{
			yyVAL.bytes2 = append(yyS[yypt-2].bytes2, yyS[yypt-0].bytes)
		}
	case 84:
		//line sql.y:515
		{
			yyVAL.boolExpr = nil
		}
	case 85:
		//line sql.y:519
		{
			yyVAL.boolExpr = yyS[yypt-0].boolExpr
		}
	case 86:
		yyVAL.boolExpr = yyS[yypt-0].boolExpr
	case 87:
		//line sql.y:526
		{
			yyVAL.boolExpr = &AndExpr{Left: yyS[yypt-2].boolExpr, Right: yyS[yypt-0].boolExpr}
		}
	case 88:
		//line sql.y:530
		{
			yyVAL.boolExpr = &OrExpr{Left: yyS[yypt-2].boolExpr, Right: yyS[yypt-0].boolExpr}
		}
	case 89:
		//line sql.y:534
		{
			yyVAL.boolExpr = &NotExpr{Expr: yyS[yypt-0].boolExpr}
		}
	case 90:
		//line sql.y:538
		{
			yyVAL.boolExpr = &ParenBoolExpr{Expr: yyS[yypt-1].boolExpr}
		}
	case 91:
		//line sql.y:544
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyS[yypt-2].valExpr, Operator: yyS[yypt-1].str, Right: yyS[yypt-0].valExpr}
		}
	case 92:
		//line sql.y:548
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyS[yypt-2].valExpr, Operator: AST_IN, Right: yyS[yypt-0].colTuple}
		}
	case 93:
		//line sql.y:552
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyS[yypt-3].valExpr, Operator: AST_NOT_IN, Right: yyS[yypt-0].colTuple}
		}
	case 94:
		//line sql.y:556
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyS[yypt-2].valExpr, Operator: AST_LIKE, Right: yyS[yypt-0].valExpr}
		}
	case 95:
		//line sql.y:560
		{
			yyVAL.boolExpr = &ComparisonExpr{Left: yyS[yypt-3].valExpr, Operator: AST_NOT_LIKE, Right: yyS[yypt-0].valExpr}
		}
	case 96:
		//line sql.y:564
		{
			yyVAL.boolExpr = &RangeCond{Left: yyS[yypt-4].valExpr, Operator: AST_BETWEEN, From: yyS[yypt-2].valExpr, To: yyS[yypt-0].valExpr}
		}
	case 97:
		//line sql.y:568
		{
			yyVAL.boolExpr = &RangeCond{Left: yyS[yypt-5].valExpr, Operator: AST_NOT_BETWEEN, From: yyS[yypt-2].valExpr, To: yyS[yypt-0].valExpr}
		}
	case 98:
		//line sql.y:572
		{
			// TODO(rhys): custom type
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyS[yypt-4].valExpr}
		}
	case 99:
		//line sql.y:577
		{
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyS[yypt-2].valExpr}
		}
	case 100:
		//line sql.y:581
		{
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NOT_NULL, Expr: yyS[yypt-3].valExpr}
		}
	case 101:
		//line sql.y:585
		{
			// TODO(rhys): custom type
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyS[yypt-2].valExpr}
		}
	case 102:
		//line sql.y:590
		{
			// TODO(rhys): custom type
			yyVAL.boolExpr = &NullCheck{Operator: AST_IS_NULL, Expr: yyS[yypt-2].valExpr}
		}
	case 103:
		//line sql.y:595
		{
			yyVAL.boolExpr = &ExistsExpr{Subquery: yyS[yypt-0].subquery}
		}
	case 104:
		//line sql.y:601
		{
			yyVAL.str = AST_EQ
		}
	case 105:
		//line sql.y:605
		{
			yyVAL.str = AST_LT
		}
	case 106:
		//line sql.y:609
		{
			yyVAL.str = AST_GT
		}
	case 107:
		//line sql.y:613
		{
			yyVAL.str = AST_LE
		}
	case 108:
		//line sql.y:617
		{
			yyVAL.str = AST_GE
		}
	case 109:
		//line sql.y:621
		{
			yyVAL.str = AST_NE
		}
	case 110:
		//line sql.y:625
		{
			yyVAL.str = AST_NSE
		}
	case 111:
		//line sql.y:631
		{
			yyVAL.colTuple = ValTuple(yyS[yypt-1].valExprs)
		}
	case 112:
		//line sql.y:635
		{
			yyVAL.colTuple = yyS[yypt-0].subquery
		}
	case 113:
		//line sql.y:639
		{
			yyVAL.colTuple = ListArg(yyS[yypt-0].bytes)
		}
	case 114:
		//line sql.y:645
		{
			yyVAL.subquery = &Subquery{yyS[yypt-1].selStmt}
		}
	case 115:
		//line sql.y:651
		{
			yyVAL.valExprs = ValExprs{yyS[yypt-0].valExpr}
		}
	case 116:
		//line sql.y:655
		{
			yyVAL.valExprs = append(yyS[yypt-2].valExprs, yyS[yypt-0].valExpr)
		}
	case 117:
		//line sql.y:661
		{
			yyVAL.valExpr = yyS[yypt-0].valExpr
		}
	case 118:
		//line sql.y:665
		{
			yyVAL.valExpr = yyS[yypt-0].colName
		}
	case 119:
		//line sql.y:669
		{
			yyVAL.valExpr = yyS[yypt-0].rowTuple
		}
	case 120:
		//line sql.y:673
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_BITAND, Right: yyS[yypt-0].valExpr}
		}
	case 121:
		//line sql.y:677
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_BITOR, Right: yyS[yypt-0].valExpr}
		}
	case 122:
		//line sql.y:681
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_BITXOR, Right: yyS[yypt-0].valExpr}
		}
	case 123:
		//line sql.y:685
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_PLUS, Right: yyS[yypt-0].valExpr}
		}
	case 124:
		//line sql.y:689
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_MINUS, Right: yyS[yypt-0].valExpr}
		}
	case 125:
		//line sql.y:693
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_MULT, Right: yyS[yypt-0].valExpr}
		}
	case 126:
		//line sql.y:697
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_DIV, Right: yyS[yypt-0].valExpr}
		}
	case 127:
		//line sql.y:701
		{
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-2].valExpr, Operator: AST_MOD, Right: yyS[yypt-0].valExpr}
		}
	case 128:
		//line sql.y:705
		{
			// TODO(rhys): custom type
			yyVAL.valExpr = &BinaryExpr{Left: yyS[yypt-4].valExpr, Operator: AST_MOD, Right: yyS[yypt-0].valExpr}
		}
	case 129:
		//line sql.y:710
		{
			if num, ok := yyS[yypt-0].valExpr.(NumVal); ok {
				switch yyS[yypt-1].byt {
				case '-':
					yyVAL.valExpr = append(NumVal("-"), num...)
				case '+':
					yyVAL.valExpr = num
				default:
					yyVAL.valExpr = &UnaryExpr{Operator: yyS[yypt-1].byt, Expr: yyS[yypt-0].valExpr}
				}
			} else {
				yyVAL.valExpr = &UnaryExpr{Operator: yyS[yypt-1].byt, Expr: yyS[yypt-0].valExpr}
			}
		}
	case 130:
		//line sql.y:725
		{
			yyVAL.valExpr = &FuncExpr{Name: yyS[yypt-2].bytes}
		}
	case 131:
		//line sql.y:729
		{
			yyVAL.valExpr = &FuncExpr{Name: yyS[yypt-3].bytes, Exprs: yyS[yypt-1].selectExprs}
		}
	case 132:
		//line sql.y:733
		{
			yyVAL.valExpr = &FuncExpr{Name: yyS[yypt-4].bytes, Distinct: true, Exprs: yyS[yypt-1].selectExprs}
		}
	case 133:
		//line sql.y:737
		{
			yyVAL.valExpr = &FuncExpr{Name: yyS[yypt-3].bytes, Exprs: yyS[yypt-1].selectExprs}
		}
	case 134:
		//line sql.y:741
		{
			yyVAL.valExpr = yyS[yypt-0].caseExpr
		}
	case 135:
		//line sql.y:747
		{
			yyVAL.bytes = IF_BYTES
		}
	case 136:
		//line sql.y:751
		{
			yyVAL.bytes = VALUES_BYTES
		}
	case 137:
		//line sql.y:757
		{
			yyVAL.byt = AST_UPLUS
		}
	case 138:
		//line sql.y:761
		{
			yyVAL.byt = AST_UMINUS
		}
	case 139:
		//line sql.y:765
		{
			yyVAL.byt = AST_TILDA
		}
	case 140:
		//line sql.y:771
		{
			yyVAL.caseExpr = &CaseExpr{Expr: yyS[yypt-3].valExpr, Whens: yyS[yypt-2].whens, Else: yyS[yypt-1].valExpr}
		}
	case 141:
		//line sql.y:776
		{
			yyVAL.valExpr = nil
		}
	case 142:
		//line sql.y:780
		{
			yyVAL.valExpr = yyS[yypt-0].valExpr
		}
	case 143:
		//line sql.y:786
		{
			yyVAL.whens = []*When{yyS[yypt-0].when}
		}
	case 144:
		//line sql.y:790
		{
			yyVAL.whens = append(yyS[yypt-1].whens, yyS[yypt-0].when)
		}
	case 145:
		//line sql.y:796
		{
			yyVAL.when = &When{Cond: yyS[yypt-2].boolExpr, Val: yyS[yypt-0].valExpr}
		}
	case 146:
		//line sql.y:801
		{
			yyVAL.valExpr = nil
		}
	case 147:
		//line sql.y:805
		{
			yyVAL.valExpr = yyS[yypt-0].valExpr
		}
	case 148:
		//line sql.y:811
		{
			yyVAL.colName = &ColName{Name: yyS[yypt-0].bytes}
		}
	case 149:
		//line sql.y:815
		{
			yyVAL.colName = &ColName{Qualifier: yyS[yypt-2].bytes, Name: yyS[yypt-0].bytes}
		}
	case 150:
		//line sql.y:821
		{
			yyVAL.valExpr = StrVal(yyS[yypt-0].bytes)
		}
	case 151:
		//line sql.y:825
		{
			yyVAL.valExpr = NumVal(yyS[yypt-0].bytes)
		}
	case 152:
		//line sql.y:829
		{
			yyVAL.valExpr = ValArg(yyS[yypt-0].bytes)
		}
	case 153:
		//line sql.y:833
		{
			yyVAL.valExpr = &NullVal{}
		}
	case 154:
		//line sql.y:837
		{
			// TODO(rhys): custom type
			yyVAL.valExpr = &NullVal{}
		}
	case 155:
		//line sql.y:842
		{
			// TODO(rhys): custom type
			yyVAL.valExpr = &NullVal{}
		}
	case 156:
		//line sql.y:848
		{
			yyVAL.valExprs = nil
		}
	case 157:
		//line sql.y:852
		{
			yyVAL.valExprs = yyS[yypt-0].valExprs
		}
	case 158:
		//line sql.y:857
		{
			yyVAL.boolExpr = nil
		}
	case 159:
		//line sql.y:861
		{
			yyVAL.boolExpr = yyS[yypt-0].boolExpr
		}
	case 160:
		//line sql.y:866
		{
			yyVAL.orderBy = nil
		}
	case 161:
		//line sql.y:870
		{
			yyVAL.orderBy = yyS[yypt-0].orderBy
		}
	case 162:
		//line sql.y:876
		{
			yyVAL.orderBy = OrderBy{yyS[yypt-0].order}
		}
	case 163:
		//line sql.y:880
		{
			yyVAL.orderBy = append(yyS[yypt-2].orderBy, yyS[yypt-0].order)
		}
	case 164:
		//line sql.y:886
		{
			yyVAL.order = &Order{Expr: yyS[yypt-1].valExpr, Direction: yyS[yypt-0].str}
		}
	case 165:
		//line sql.y:891
		{
			yyVAL.str = AST_ASC
		}
	case 166:
		//line sql.y:895
		{
			// TODO(rhys): custom type
			yyVAL.str = AST_ASC
		}
	case 167:
		//line sql.y:900
		{
			// TODO(rhys): custom type
			yyVAL.str = AST_DESC
		}
	case 171:
		//line sql.y:910
		{
			yyVAL.limit = nil
		}
	case 172:
		//line sql.y:914
		{
			yyVAL.limit = &Limit{Offset: yyS[yypt-0].valExpr, Rowcount: yyS[yypt-2].valExpr}
		}
	case 173:
		//line sql.y:918
		{
			yyVAL.limit = &Limit{Offset: yyS[yypt-2].valExpr, Rowcount: yyS[yypt-0].valExpr}
		}
	case 174:
		//line sql.y:922
		{
			yyVAL.limit = &Limit{Rowcount: yyS[yypt-0].valExpr}
		}
	case 175:
		//line sql.y:927
		{
			yyVAL.str = ""
		}
	case 176:
		//line sql.y:931
		{
			yyVAL.str = AST_FOR_UPDATE
		}
	case 177:
		//line sql.y:935
		{
			if !bytes.Equal(yyS[yypt-1].bytes, SHARE) {
				yylex.Error("expecting share")
				return 1
			}
			if !bytes.Equal(yyS[yypt-0].bytes, MODE) {
				yylex.Error("expecting mode")
				return 1
			}
			yyVAL.str = AST_SHARE_MODE
		}
	case 178:
		//line sql.y:948
		{
			yyVAL.columns = nil
		}
	case 179:
		//line sql.y:952
		{
			yyVAL.columns = yyS[yypt-1].columns
		}
	case 180:
		//line sql.y:958
		{
			yyVAL.columns = Columns{&NonStarExpr{Expr: yyS[yypt-0].colName}}
		}
	case 181:
		//line sql.y:962
		{
			yyVAL.columns = append(yyVAL.columns, &NonStarExpr{Expr: yyS[yypt-0].colName})
		}
	case 182:
		//line sql.y:967
		{
			yyVAL.updateExprs = nil
		}
	case 183:
		//line sql.y:971
		{
			yyVAL.updateExprs = yyS[yypt-0].updateExprs
		}
	case 184:
		//line sql.y:977
		{
			yyVAL.insRows = yyS[yypt-0].values
		}
	case 185:
		//line sql.y:981
		{
			yyVAL.insRows = yyS[yypt-0].selStmt
		}
	case 186:
		//line sql.y:987
		{
			yyVAL.values = Values{yyS[yypt-0].rowTuple}
		}
	case 187:
		//line sql.y:991
		{
			yyVAL.values = append(yyS[yypt-2].values, yyS[yypt-0].rowTuple)
		}
	case 188:
		//line sql.y:997
		{
			yyVAL.rowTuple = ValTuple(yyS[yypt-1].valExprs)
		}
	case 189:
		//line sql.y:1001
		{
			yyVAL.rowTuple = yyS[yypt-0].subquery
		}
	case 190:
		//line sql.y:1007
		{
			yyVAL.updateExprs = UpdateExprs{yyS[yypt-0].updateExpr}
		}
	case 191:
		//line sql.y:1011
		{
			yyVAL.updateExprs = append(yyS[yypt-2].updateExprs, yyS[yypt-0].updateExpr)
		}
	case 192:
		//line sql.y:1017
		{
			yyVAL.updateExpr = &UpdateExpr{Name: yyS[yypt-2].colName, Expr: yyS[yypt-0].valExpr}
		}
	case 193:
		//line sql.y:1022
		{
			yyVAL.empty = struct{}{}
		}
	case 194:
		//line sql.y:1024
		{
			yyVAL.empty = struct{}{}
		}
	case 195:
		//line sql.y:1027
		{
			yyVAL.empty = struct{}{}
		}
	case 196:
		//line sql.y:1029
		{
			yyVAL.empty = struct{}{}
		}
	case 197:
		//line sql.y:1032
		{
			yyVAL.empty = struct{}{}
		}
	case 198:
		//line sql.y:1034
		{
			yyVAL.empty = struct{}{}
		}
	case 199:
		//line sql.y:1038
		{
			yyVAL.empty = struct{}{}
		}
	case 200:
		//line sql.y:1040
		{
			yyVAL.empty = struct{}{}
		}
	case 201:
		//line sql.y:1042
		{
			yyVAL.empty = struct{}{}
		}
	case 202:
		//line sql.y:1044
		{
			yyVAL.empty = struct{}{}
		}
	case 203:
		//line sql.y:1046
		{
			yyVAL.empty = struct{}{}
		}
	case 204:
		//line sql.y:1049
		{
			yyVAL.empty = struct{}{}
		}
	case 205:
		//line sql.y:1051
		{
			yyVAL.empty = struct{}{}
		}
	case 206:
		//line sql.y:1054
		{
			yyVAL.empty = struct{}{}
		}
	case 207:
		//line sql.y:1056
		{
			yyVAL.empty = struct{}{}
		}
	case 208:
		//line sql.y:1059
		{
			yyVAL.empty = struct{}{}
		}
	case 209:
		//line sql.y:1061
		{
			yyVAL.empty = struct{}{}
		}
	case 210:
		//line sql.y:1065
		{
			yyVAL.bytes = bytes.ToLower(yyS[yypt-0].bytes)
		}
	case 211:
		//line sql.y:1070
		{
			ForceEOF(yylex)
		}
	}
	goto yystack /* stack new state and value */
}
