package serialize

import "time"

var (
	golden = &talGolden{
		Kind:       3,
		Time:       uint64(time.Date(2006, 1, 2, 15, 4, 5, 0, time.UTC).UnixNano()),
		Service:    "git.internal.justin.tv/rhys/nursery/serialize?golden",
		Machine:    "localhost-001.test.sts01.justin.tv",
		PID:        23456,
		TraceID:    0x1122334455667788,
		SubTraceID: ".22.33",
		Desc: map[string]string{
			"ip": "127.0.0.1",
			"db": "mock db",
			"sql": `
SELECT * FROM users
WHERE users.id IN ($1, $2, $3)
AND users.game IN ($4, $5, $6)
LIMIT 1
OFFSET 1
`[1:],
			"thumb": `
SELECT * FROM users
WHERE users.id IN ($1, $2, $3)
AND users.game IN ($4, $5, $6)
LIMIT 1
OFFSET 1
`[1:],
		},
	}
)

type talGolden struct {
	Kind       uint
	Time       uint64
	Service    string
	Machine    string
	PID        int
	TraceID    uint64
	SubTraceID string
	Desc       map[string]string
}
