package serialize

type talJson struct {
	Kind       uint              `json:"K"`
	Time       uint64            `json:"T"`
	Service    string            `json:"S,omitempty"`
	Machine    string            `json:"M,omitempty"`
	PID        int               `json:"P"`
	TraceID    uint64            `json:"I,omitempty"`
	SubTraceID string            `json:"R,omitempty"`
	Desc       map[string]string `json:"D,omitempty"`
}

func toJson(out *talJson, in *talGolden) error {
	*out = talJson{
		Kind:       in.Kind,
		Time:       in.Time,
		Service:    in.Service,
		Machine:    in.Machine,
		PID:        in.PID,
		TraceID:    in.TraceID,
		SubTraceID: in.SubTraceID,
	}
	out.Desc = make(map[string]string, len(in.Desc))
	for k, v := range in.Desc {
		out.Desc[k] = v
	}
	return nil
}

func fromJson(out *talGolden, in *talJson) error {
	*out = talGolden{
		Kind:       in.Kind,
		Time:       in.Time,
		Service:    in.Service,
		Machine:    in.Machine,
		PID:        in.PID,
		TraceID:    in.TraceID,
		SubTraceID: in.SubTraceID,
	}
	out.Desc = make(map[string]string, len(in.Desc))
	for k, v := range in.Desc {
		out.Desc[k] = v
	}
	return nil
}
