resource "aws_iam_role" "ecs_dev" {
  name = "ecs_dev"

  assume_role_policy = "${file("policies/ec2_assume_role.json")}"
}

resource "aws_iam_role_policy" "ecs_dev" {
  name = "ecs_dev"
  role = "${aws_iam_role.ecs_dev.id}"

  policy = "${file("policies/ecs_instance_role.json")}"
}

resource "aws_iam_instance_profile" "ecs_dev" {
  name = "ecs_dev"
  roles = ["${aws_iam_role.ecs_dev.name}"]
}

resource "aws_launch_configuration" "ecs_dev" {
  image_id = "${var.ami["us-west-2.blue"]}"
  instance_type = "${var.instances["ecs_dev.type"]}"
  iam_instance_profile = "${aws_iam_instance_profile.ecs_dev.name}"
  security_groups = [
    "${aws_security_group.ecs_dev.id}",
  ]
  root_block_device {
    volume_size = "64"  // gigabytes
    volume_type = "gp2" // ssd
  }

  lifecycle {
    create_before_destroy = true
  }

  user_data = <<EOF
#!/bin/bash
echo ECS_CLUSTER=ecs_dev >> /etc/ecs/ecs.config
EOF

}

resource "aws_autoscaling_group" "ecs_dev" {
  name = "ecs_dev"
  min_size = "${var.instances["ecs_dev.mincount"]}"
  max_size = "${var.instances["ecs_dev.maxcount"]}"
  desired_capacity = "${var.instances["ecs_dev.mincount"]}"
  vpc_zone_identifier = [
    "${aws_subnet.private_a1.id}",
    "${aws_subnet.private_b1.id}",
    "${aws_subnet.private_c1.id}",
  ]
  launch_configuration = "${aws_launch_configuration.ecs_dev.name}"
  health_check_type = "EC2"
  health_check_grace_period = 300

  lifecycle {
    create_before_destroy = true
  }

  tag {
    key = "Name"
    value = "ecs_dev"
    propagate_at_launch = true
  }

  tag {
    key = "Service"
    value = "${var.service_tag_prefix}/ecs_dev"
    propagate_at_launch = true
  }
  tag {
    key = "Owner"
    value = "${var.owner_tag}"
    propagate_at_launch = true
  }
  tag {
    key = "Environment"
    value = "dev"
    propagate_at_launch = true
  }
}

resource "aws_ecs_cluster" "ecs_dev" {
  name = "ecs_dev"
}

resource "aws_ecr_repository" "ecs_dev" {
  name = "ecs_dev"
}
