resource "aws_vpc" "main" {
  cidr_block = "172.23.0.0/16"
  enable_dns_support = true
  enable_dns_hostnames = false
}

resource "aws_subnet" "public_a1" {
  vpc_id = "${aws_vpc.main.id}"
  availability_zone = "us-west-2a"
  cidr_block = "172.23.101.0/24"
  map_public_ip_on_launch = true
}

resource "aws_subnet" "public_b1" {
  vpc_id = "${aws_vpc.main.id}"
  availability_zone = "us-west-2b"
  cidr_block = "172.23.102.0/24"
  map_public_ip_on_launch = true
}

resource "aws_subnet" "public_c1" {
  vpc_id = "${aws_vpc.main.id}"
  availability_zone = "us-west-2c"
  cidr_block = "172.23.103.0/24"
  map_public_ip_on_launch = true
}

resource "aws_subnet" "private_a1" {
  vpc_id = "${aws_vpc.main.id}"
  availability_zone = "us-west-2a"
  cidr_block = "172.23.201.0/24"
  map_public_ip_on_launch = false
}

resource "aws_subnet" "private_b1" {
  vpc_id = "${aws_vpc.main.id}"
  availability_zone = "us-west-2b"
  cidr_block = "172.23.202.0/24"
  map_public_ip_on_launch = false
}

resource "aws_subnet" "private_c1" {
  vpc_id = "${aws_vpc.main.id}"
  availability_zone = "us-west-2c"
  cidr_block = "172.23.203.0/24"
  map_public_ip_on_launch = false
}

resource "aws_internet_gateway" "main" {
  vpc_id = "${aws_vpc.main.id}"
}

resource "aws_route_table" "public" {
  vpc_id = "${aws_vpc.main.id}"
}

resource "aws_route" "public_gateway" {
  route_table_id = "${aws_route_table.public.id}"
  destination_cidr_block = "0.0.0.0/0"
  gateway_id = "${aws_internet_gateway.main.id}"
  depends_on = ["aws_route_table.public"]
}

resource "aws_eip" "nat_a1" {
  vpc = true
  depends_on = ["aws_internet_gateway.main"]
}

resource "aws_eip" "nat_b1" {
  vpc = true
  depends_on = ["aws_internet_gateway.main"]
}

resource "aws_eip" "nat_c1" {
  vpc = true
  depends_on = ["aws_internet_gateway.main"]
}

resource "aws_nat_gateway" "a1" {
  allocation_id = "${aws_eip.nat_a1.id}"
  subnet_id = "${aws_subnet.public_a1.id}"
  depends_on = ["aws_internet_gateway.main"]
}

resource "aws_nat_gateway" "b1" {
  allocation_id = "${aws_eip.nat_b1.id}"
  subnet_id = "${aws_subnet.public_b1.id}"
  depends_on = ["aws_internet_gateway.main"]
}

resource "aws_nat_gateway" "c1" {
  allocation_id = "${aws_eip.nat_c1.id}"
  subnet_id = "${aws_subnet.public_c1.id}"
  depends_on = ["aws_internet_gateway.main"]
}

resource "aws_route_table" "private_a1" {
  vpc_id = "${aws_vpc.main.id}"
}

resource "aws_route_table" "private_b1" {
  vpc_id = "${aws_vpc.main.id}"
}

resource "aws_route_table" "private_c1" {
  vpc_id = "${aws_vpc.main.id}"
}

resource "aws_route" "private_nat_gateway_a1" {
  route_table_id = "${aws_route_table.private_a1.id}"
  destination_cidr_block = "0.0.0.0/0"
  nat_gateway_id = "${aws_nat_gateway.a1.id}"
  depends_on = ["aws_route_table.private_a1"]
}

resource "aws_route" "private_nat_gateway_b1" {
  route_table_id = "${aws_route_table.private_b1.id}"
  destination_cidr_block = "0.0.0.0/0"
  nat_gateway_id = "${aws_nat_gateway.b1.id}"
  depends_on = ["aws_route_table.private_b1"]
}

resource "aws_route" "private_nat_gateway_c1" {
  route_table_id = "${aws_route_table.private_c1.id}"
  destination_cidr_block = "0.0.0.0/0"
  nat_gateway_id = "${aws_nat_gateway.c1.id}"
  depends_on = ["aws_route_table.private_c1"]
}

resource "aws_route_table_association" "public_a1" {
  route_table_id = "${aws_route_table.public.id}"
  subnet_id = "${aws_subnet.public_a1.id}"
}

resource "aws_route_table_association" "public_b1" {
  route_table_id = "${aws_route_table.public.id}"
  subnet_id = "${aws_subnet.public_b1.id}"
}

resource "aws_route_table_association" "public_c1" {
  route_table_id = "${aws_route_table.public.id}"
  subnet_id = "${aws_subnet.public_c1.id}"
}

resource "aws_route_table_association" "private_a1" {
  route_table_id = "${aws_route_table.private_a1.id}"
  subnet_id = "${aws_subnet.private_a1.id}"
}

resource "aws_route_table_association" "private_b1" {
  route_table_id = "${aws_route_table.private_b1.id}"
  subnet_id = "${aws_subnet.private_b1.id}"
}

resource "aws_route_table_association" "private_c1" {
  route_table_id = "${aws_route_table.private_c1.id}"
  subnet_id = "${aws_subnet.private_c1.id}"
}
