package txstore

import (
	"code.justin.tv/release/trace/analysis/routes"
	"code.justin.tv/release/trace/api"
)

// CleanTx removes potentially sensitive information from transaction
// structures.
func CleanTx(tx *api.Transaction) {
	CleanCall(tx.GetRoot())
}

// CleanCall removes potentially sensitive information from call structures.
// This involves removing the URI path (which for some REST-like APIs can
// include parameters) and replacing it with the name of the involved RPC.
func CleanCall(call *api.Call) {
	if call == nil {
		return
	}
	for _, sub := range call.Subcalls {
		CleanCall(sub)
	}

	if hp := call.GetParams().GetHttp(); hp != nil {
		path := hp.UriPath
		hp.UriPath = ""

		if svc := call.GetSvc(); svc != nil && hp.Route == "" {
			rm := routes.Routes[svc.Name]
			hp.Route = rm.LookupTrimSlash(path, hp.Method.String())
		}
	}
}
