package txstore

import (
	"code.justin.tv/release/trace/api"
	"code.justin.tv/release/trace/scanproto"
	"github.com/syndtr/goleveldb/leveldb/iterator"
)

func NewReaderLevelDB(it iterator.Iterator, workers int) scanproto.TransactionSource {
	return &byteSource{
		workers: workers,

		txSet:    false,
		nextFn:   it.Next,
		bytesFn:  it.Value,
		endErrFn: it.Error,

		ch:   make(chan *api.Transaction, 1<<10),
		errs: make(chan error),
		stop: make(chan struct{}),
	}
}
