package txstore

import (
	"io"

	"code.justin.tv/release/trace/api"
	"code.justin.tv/release/trace/scanproto"
)

const (
	maxTxSize = 1 << 20
)

func NewReaderSource(r io.Reader, workers int) scanproto.TransactionSource {
	sc := scanproto.NewEventSetScanner(r)
	sc.Buffer(nil, maxTxSize)

	return &byteSource{
		workers: workers,

		txSet:    true,
		nextFn:   sc.Scan,
		bytesFn:  sc.Bytes,
		endErrFn: sc.Err,

		ch:   make(chan *api.Transaction, 1<<10),
		errs: make(chan error),
		stop: make(chan struct{}),
	}
}
