package scanproto

import "code.justin.tv/release/trace/api"

// TransactionSource provides a channel of *api.Transactions. The channel is
// accessible immediately, but the TransactionSource doesn't start populating
// it with data until the Run() function is called.
type TransactionSource interface {
	// Run is a blocking call which writes data into the
	// TransactionSource's channel
	Run()
	Transactions() <-chan *api.Transaction
	Errors() <-chan error
	Stop() // a blocking call which closes inputs and its events channel
}
