package autoprofclient

import (
	"bytes"

	rpc "code.justin.tv/amzn/TwitchAutoprofLambdaTwirp"

	"code.justin.tv/video/amzncorp"
)

// ProdURL is the URL of the prod Autoprof API behind TrivEA.
const ProdURL = "https://autoprof.video.xarth.tv"

// NewBundleCollectionMidwayClient builds a BundleCollection protobuf client that uses cookies from the given Midway cookie file
// when making requests. This client is intended to be used by humans (with Midway credentials) when making requests to the Autoprof API that is exposed by
// TrivEA.
func NewBundleCollectionMidwayClient(url string, client rpc.HTTPClient, cookieFile []byte) (rpc.BundleCollection, error) {
	// build an http.Client that uses the midway cookie
	client, err := amzncorp.MidwayClient(bytes.NewReader(cookieFile))
	if err != nil {
		return nil, err
	}

	// wrapper around http.Client as a trick to prevent Twirp from not following redirects
	type clientWrapper struct {
		rpc.HTTPClient
	}
	wrapper := &clientWrapper{client}

	return rpc.NewBundleCollectionProtobufClient(url, wrapper), nil
}
