package xarth

import (
	"time"

	"golang.org/x/net/context"
)

type key int

var (
	keyArrivalTime = new(key)
	keyRecorder    = new(key)
)

func markArrivalTime(ctx context.Context, val time.Time) context.Context {
	return context.WithValue(ctx, keyArrivalTime, val)
}

func getArrivalTime(ctx context.Context) time.Time {
	return ctx.Value(keyArrivalTime).(time.Time)
}

func setRecorder(parent context.Context, val recorder) context.Context {
	return context.WithValue(parent, keyRecorder, val)
}
