# manage a single, cross-account, versioned, replicated bucket for tfstate.
# this particular iteration of a bucket only replicates in the same account.
resource "aws_s3_bucket" "royberg-dev-tfstate" {
  bucket = "com.twitch.royberg.tfstate.gamma"
  acl    = "private"
  region = "us-west-2"

  versioning {
    enabled = true
  }

  lifecycle_rule {
    id      = "expire_7"
    enabled = "true"

    noncurrent_version_expiration {
      days = 7
    }
  }
}
