# rockpaperscissors-jenkins
Jenkins Plugin reporting into RPS

This is a Jenkins plugin, written in Java, that runs an action after every
build in Jenkins to collect statistics and other information about the build
and publish one or more events into the
[RockPaperScissors](http://link.twitch.tv/rps) system for aggregation.

The plugin publishes `JenkinsBuildStats`, `JenkinsTestResults`, and
`JenkinsTestCoverage` events to RockPaperScissors ([event format
documentation](https://git-aws.internal.justin.tv/dta/rockpaperscissors/blob/master/doc/events.md)).

## Building

[Maven](https://maven.apache.org/) is used to manage the build of the plugin.
It is available in Homebrew for macOS and can be installed by doing
`brew install maven`. For Ubuntu, the brew available in the default apt-get
repository is a bit old so I recommend installing it from an alternative PPA
repository that has Maven 3.3 like so:

```shell
add-apt-repository -y ppa:andrei-pozolotin/maven3 && apt-get update && apt-get -y install maven3
```

Maven and the Jenkins dependencies will require Java SDK 7.

Running `mvn clean package` will download required dependencies, build the
plugin, and then put it at `target/rockpaperscissors-jenkins.hpi`.

## Local Testing

Running `mvn hpi:run` will download required Jenkins dependencies to build and
then locally run a Jenkins master preconfigured with the plugin. Log messages
will be printed to the terminal and you can go to http://localhost:8080/jenkins/
to use it.

## Installing and Configuring

Get the `rockpaperscissors-jenkins.hpi` file and use the Jenkins "Upload Plugin"
interface to upload and install the plugin; you can find it under
"Manage Jenkins -> Manage Plugins -> Advanced" menu ([direct link to production
Jenkins master](https://jenkins.internal.justin.tv/pluginManager/advanced)).

![Advanced tab of Manage Plugins](doc/images/plugin_upload.png)

After installing the plugin and rebooting the Jenkins master, the plugin will
need to be configured. It will be safely disabled until it's configured. Go to
"Manage Jenkins -> Configure System" ([direct link to production Jenkins
master](https://jenkins.internal.justin.tv/configure)) and find the
`RockPaperScissors` section.

![RockPaperScissors section in global config](doc/images/global_config.png)

This screen shot shows the default settings. On the right of each field is a
blue question mark that will reveal a section of help text about that field.

The plugin will need AWS credentials for the `twitch-core-services` account
which should already have the permissions to write to the Kinesis stream that
RockPaperScissors uses to receive events.

The "credentials file" drop down menu will allow you to choose a secret file
type credential from the Jenkins credential store that has AWS credentials for
that AWS account.

By default, it will send events to the "production" instance of
RockPaperScissors which is configured with the Kinesis stream name. To send
events to the development instance, use `rockpaperscissors-development-events`.

This plugin has 3 types of events it may publish. Build stats are sent for every
build. Test results and coverage are only collected and sent if the particular
build conforms to QE's documentation on how to properly report
[test results](https://twitchtv.atlassian.net/wiki/display/QE/Reporting+Test+Results)
and
[test coverage](https://twitchtv.atlassian.net/wiki/display/QE/Reporting+Code+Coverage+Results).

Unchecking all of the check boxes effectively disables the plugin.

After making changes, click "Save" or "Apply" and the settings will immediately
take effect.

## Using and Debugging

The plugin makes informational logs in the Jenkins system log ([direct link to
production Jenkins master](https://jenkins.internal.justin.tv/log/all)).

After installing [rpstool](http://link.twitch.tv/rpstool-install), you can
query RockPaperScissors to make sure that build events are being sent and
stored:

```shell
rpstool events query --type JenkinsBuildStats
```

That should print one or more recent events (past 2 hours by default). The
body may not be human readable but the timestamp, type, and attributes can be
compared to recent builds.

If you have the event UUID (e.g. "4jLD3JtPTiiSMpb+/1DfSQ==", from the Jenkins
system log), you can query for an individual event:

```shell
rpstool events get 4jLD3JtPTiiSMpb+/1DfSQ==
```

If you have the
[Google Protobuffer](https://developers.google.com/protocol-buffers/) compiler
installed (`brew install protoc` if you use Homebrew on macOS or
[from their github](https://github.com/google/protobuf)) and the source to the
plugin cloned locally, you can use protoc to decode the bodies of the events:

```shell
rpstool events query --type GitHub-Stats --body-only | protoc --decode=rockpaperscissors.events.JenkinsBuildStats -I src/main/proto src/main/proto/jenkins_build.proto
```
