mavenJob('rps-rockpaperscissors-jenkins-build') {
  concurrentBuild true

  configure { project ->
    // Set build status to "pending" on GitHub commit.
		project / prebuilders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
    // "Universal" set GitHub commit status after the build.
		project / publishers / 'org.jenkinsci.plugins.github.status.GitHubCommitStatusSetter' {
			commitShaSource(class: "org.jenkinsci.plugins.github.status.sources.BuildDataRevisionShaSource")
			reposSource(class: "org.jenkinsci.plugins.github.status.sources.AnyDefinedRepositorySource")
			contextSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultCommitContextSource")
			statusResultSource(class: "org.jenkinsci.plugins.github.status.sources.DefaultStatusResultSource")
		}
	}

  triggers {
    // GitHub hook trigger fro GITScm polling
    githubPush()
  }

  scm {
    git {
      remote {
        github 'rps/rockpaperscissors-jenkins', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
		sshAgent 'git-aws-read-key'
  }

  goals "clean install"
}
