'use strict';

const express = require('express');
const ExpressHTTPServer = require('fastboot-app-server/src/express-http-server');
const FastBootAppServer = require('fastboot-app-server');

class CustomExpressHTTPServer extends ExpressHTTPServer {
  serve(middleware) {
    let app = this.app;
    let router = express.Router();

    if (this.distPath) {
      router.get('/', middleware);
      router.use(express.static(this.distPath));
    }

    router.get('/*', middleware);

    app.use('/ember', router);

    return new Promise(resolve => {
      let listener = app.listen(process.env.PORT || 3000, () => {
        let host = listener.address().address;
        let port = listener.address().port;

        this.ui.writeLine('HTTP server started; url=http://%s:%s', host, port);

        resolve();
      });
    });
  }
};

let server = new FastBootAppServer({
  distPath: 'dist',
  httpServer: new CustomExpressHTTPServer(),
  gzip: true
});

server.start();
