import Route from 'ember-route';
import injectService from 'ember-service/inject';

export default Route.extend({
  ajax: injectService(),
  badges: injectService(),
  fastboot: injectService(),

  model(params) {
    return this.get('ajax').request(`https://api.twitch.tv/api/channels/${params.channel_name.toLowerCase()}`);
  },

  afterModel(model) {
    if (this.get('fastboot.isFastBoot')) {
      return this.get('badges').loadBadges(model._id);
    }
  }
});
