import Service from 'ember-service';
import RSVP from 'rsvp';
import injectService from 'ember-service/inject';
import fetch from 'ember-network/fetch';

const { Promise } = RSVP;

export default Service.extend({
  fastboot: injectService(),

  init() {
    this._super(...arguments);

    let shoebox = this.get('fastboot.shoebox');

    if (this.get('fastboot.isFastBoot')) {
      this.shoeboxStore = {};
      shoebox.put('ajax-responses', this.shoeboxStore);
    } else {
      this.shoeboxStore = shoebox.retrieve('ajax-responses') || {};
    }
  },

  putIntoShoebox(url, json) {
    if (this.get('fastboot.isFastBoot')) {
      this.shoeboxStore[url] = json;
    }
  },

  getFromShoebox(url) {
    if (!this.get('fastboot.isFastBoot')) {
      return this.shoeboxStore[url];
    }
  },

  request(url, options, shouldCache = true) {
    return Promise.resolve()
      .then(() => {
        let shoeboxValue = shouldCache && this.getFromShoebox(url);

        if (shoeboxValue) {
          return shoeboxValue;
        }

        return fetch(...arguments)
          .then((response) => {
            return response.json();
          })
          .then((json) => {
            shouldCache && this.putIntoShoebox(url, json);

            return json;
          });
      });
  }
});
