import Ember from 'ember';

const { propertyDidChange } = Ember;

function ListNode(value) {
  this.prev = null;
  this.next = null;
  this.value = value;
}

export default function DoublyLinkedList() {
  this.length = 0;
  this.first = null;
  this.last = null;
}

DoublyLinkedList.prototype = {
  append(value) {
    var node = new ListNode(value);

    if (this.first === null) {
      node.prev = node;
      node.next = node;
      this.first = node;
      this.last = node;
    } else {
      node.prev = this.last;
      node.next = this.first;
      this.first.prev = node;
      this.last.next = node;
      this.last = node;
    }

    this.length++;

    return node;
  },

  removeFirst() {
    this.first = this.first.next;
    this.first.prev = this.last;
    this.last.next = this.first;

    this.length--;
  },

  forEach(callback) {
    var current = this.first;
    do {
      if (!current) { continue; }

      callback(current.value);
      current = current.next;
    } while (current !== this.first);
  },

  toArray() {
    var array = [];
    var current = this.first;

    do {
      if (!current) { continue; }

      array.push(current.value);
      current = current.next;
    } while (current !== this.first);

    return array;
  },

  arrayContentDidChange() {
    propertyDidChange(this, '[]');
    propertyDidChange(this, 'length');
  }
};
