/*eslint-env node*/

var EmberApp = require('ember-cli/lib/broccoli/ember-app');
var concat = require('broccoli-concat');
var mergeTrees = require('broccoli-merge-trees');
var Funnel = require('broccoli-funnel');

module.exports = function(defaults) {
  var app = new EmberApp(defaults, {
    fingerprint: false,
    vendorFiles: {
      'jquery.js': null,
      'ember.js': {
        development: 'vendor/ember/ember.debug.js',
        production: 'vendor/ember/ember.prod.js'
      }
    }
  });

  // Use `app.import` to add additional libraries to the generated
  // output files.
  //
  // If you need to use different assets in different
  // environments, specify an object as the first parameter. That
  // object's keys should be the environment name and the values
  // should be the asset to use in that environment.
  //
  // If the library that you are including contains AMD or ES6
  // modules that you would like to import into your application
  // please specify an object with the list of modules as keys
  // along with the exports of each module as its value.
  app.import('vendor/polyfills.js');

  if (!process.env.EMBER_CLI_FASTBOOT) {
    // This will only be included in the browser build
    app.import('vendor/tmi/tmi.js');
  }

  var appTree = app.toTree();

  if (process.env.EMBER_CLI_FASTBOOT) {
    return appTree;
  } else {
    var concattedJSTree = concat(appTree, {
      headerFiles: ['assets/vendor.js', 'assets/mobile-web-client.js'],
      outputFile: 'assets/fullapp.js',
      footerFiles: ['assets/js-end.js'],
      sourceMapConfig: { enabled: false }
    });

    var filteredJSFilteredAppTree = new Funnel(appTree, {
      exclude: ['assets/vendor.js', 'assets/mobile-web-client.js', 'assets/js-end.js']
    });

    return mergeTrees([filteredJSFilteredAppTree, concattedJSTree]);
  }
};
