job {
  name 'rwjblue-mobile-web-client'
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'rwjblue/mobile-web-client', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  steps {
    shell 'rm -rf .manta/'
    shell 'manta -v -proxy'
    saveDeployArtifact 'rwjblue/mobile-web-client', '.manta/dist'
  }

  publishers {
    // from https://git-aws.internal.justin.tv/release/jenkins-jobs/blob/3018d18f578c13d02985ea507d709f07efd48b73/templates/autobuild.groovy#L18-L20
    githubCommitNotifier()

    //*********** Test Results ******************
    archiveJunit('.manta/test-results/*.xml') {
      allowEmptyResults()
      retainLongStdout()
    }

    //*********** Code Coverage ******************
    cobertura('.manta/coverage/cobertura-coverage.xml') {
      failNoReports(false)
      sourceEncoding('ASCII')
      onlyStable(true)
    }

    publishHtml {
      report('.manta/coverage') {
        allowMissing(true)
        keepAll(true)
        reportName('Code Coverage Output')
      }
    }
  }
}
