import { PROJECT_REVISION, VERSION, addFetchListener } from 'ember-service-worker/service-worker';

const CACHE_KEY_PREFIX = 'twitch-player-cache-';
const CACHE_NAME = `${CACHE_KEY_PREFIX}${PROJECT_REVISION}-${VERSION}`;

function shouldCache(request) {
  return request.url.includes('player.twitch.tv');
}

addFetchListener(function(event) {
  if (event.request.method !== 'GET' || !shouldCache(event.request)) {
    return Promise.resolve(undefined);
  }

  return caches.open(CACHE_NAME).then(function(cache) {
    return cache.match(event.request).then(function(response) {
      if (response) { return response; }

      return fetch(event.request, { mode: 'no-cors' })
        .then(function(response) {
          cache.put(event.request, response.clone());
          return response;
        });
    });
  });
});

// clear previous caches
self.addEventListener('activate', function(event) {
  event.waitUntil(
    caches.keys().then(function(cacheNames) {
      cacheNames.forEach(function(cacheName) {
        if (cacheName.indexOf(CACHE_KEY_PREFIX) === 0 && cacheName !== CACHE_NAME) {
          caches.delete(cacheName);
        }
      });
    })
  );
});
