import AjaxService from 'mobile-web-client/services/ajax';
import RSVP from 'rsvp';

export default AjaxService.extend({
  _invocations: null,

  init() {
    this._super(...arguments);
    this._invocations = [];
  },

  request(url, options) {
    this._invocations.push({ url, options });
    return RSVP.resolve({});
  },

  resetInvocations() {
    this._invocations = [];
  }
});
