import Ember from 'ember';
import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import MockAjaxService from 'mobile-web-client/tests/helpers/mock-ajax-service';

const { getOwner } = Ember;

moduleForComponent('chat-room', 'Integration | Component | chat room', {
  integration: true,

  beforeEach() {
    this.owner = getOwner(this);
    this.owner.register('service:ajax', MockAjaxService);
  },

  afterEach() {
    this.owner.lookup('service:ajax').resetInvocations();
  }
});

test('it renders', function (assert) {
  // Set any properties with this.set('myProperty', 'value');
  // Handle any actions with this.on('myAction', function(val) { ... });

  this.render(hbs`{{chat-room channelName='Twitch'}}`);

  assert.equal(this._element.textContent, '');
});
