/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2016 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   2.9.0-alpha+20de5413
 */
if (typeof Ember === 'undefined') { Em = Ember = {}; }
Em.__global = this
Em._eager = ["ember-metal/debug","ember-metal/testing","ember-environment/global","ember-environment/utils","ember-environment/index","ember-console/index","ember-metal/error_handler","ember-metal/utils","ember-metal/assign","ember/features","ember-metal/features","ember-metal/meta_listeners","ember-metal/empty_object","ember-metal/symbol","ember-metal/meta","ember-metal/events","require","ember-metal/tags","ember-metal/observer_set","ember-metal/transaction","ember-metal/property_events","backburner/utils","backburner/platform","backburner/binary-search","backburner/queue","backburner/deferred-action-queues","backburner","ember-metal/run_loop","ember-metal/cache","ember-metal/path_cache","ember-metal/property_get","ember-metal/error","ember-metal/property_set","ember-metal/set_properties","htmlbars-util/morph-utils","htmlbars-runtime/expression-visitor","htmlbars-runtime/node-visitor","morph-range/utils","morph-range","htmlbars-runtime/morph","htmlbars-util/template-utils","htmlbars-util/array-utils","htmlbars-util/void-tag-names","htmlbars-runtime/render","morph-range/morph-list","htmlbars-util/object-utils","htmlbars-runtime/hooks","htmlbars-runtime","ember-metal/properties","ember-metal/watch_key","ember-metal/watch_path","ember-metal/chains","ember-metal/watching","ember-metal/observer","ember-htmlbars/streams/subscriber","ember-htmlbars/streams/dependency","ember-htmlbars/streams/stream","ember-metal/expand_properties","ember-metal/dependent_keys","ember-metal/computed","ember-metal/binding","ember-metal/mixin","ember-metal/alias","ember-runtime/mixins/action_handler","ember-runtime/mixins/controller_content_model_alias_deprecation","ember-runtime/mixins/controller","ember-htmlbars/streams/utils","ember-views/compat/attrs-proxy","ember-htmlbars/hooks/get-value","ember-htmlbars/system/build-component-template","container/owner","ember-metal/injected_property","ember-runtime/inject","ember-runtime/system/core_object","ember-metal/get_properties","ember-metal/is_none","ember-runtime/mixins/observable","ember-runtime/system/object","ember-htmlbars/streams/proxy-stream","ember-htmlbars/system/lookup-helper","ember-htmlbars/streams/helper-instance","ember-htmlbars/streams/helper-factory","ember-htmlbars/streams/built-in-helper","ember-htmlbars/system/invoke-helper","ember-htmlbars/utils/subscribe","ember-metal/core","ember-runtime/mixins/comparable","ember-runtime/compare","ember-runtime/mixins/enumerable","ember-runtime/system/each_proxy","ember-runtime/mixins/array","ember-runtime/utils","ember-metal/is_empty","ember-htmlbars/utils/extract-positional-params","ember-views/utils/lookup-component","ember-htmlbars/keywords/closure-component","ember-htmlbars/hooks/link-render-node","ember-htmlbars/hooks/subexpr","ember-metal/instrumentation","ember-htmlbars/keywords/closure-action","ember-htmlbars/keywords/mut","ember-htmlbars/hooks/get-cell-or-value","ember-htmlbars/system/instrumentation-support","ember-runtime/mixins/target_action_support","ember-views/mixins/action_support","ember-views/system/ext","ember-runtime/mixins/evented","ember-views/views/states/default","ember-views/views/states/pre_render","ember-views/system/jquery","ember-views/views/states/has_element","ember-views/views/states/in_dom","ember-views/views/states/destroying","ember-views/views/states","ember-views/views/core_view","ember-views/mixins/child_views_support","ember-views/mixins/view_state_support","ember-metal/replace","ember-runtime/mixins/mutable_enumerable","ember-runtime/mixins/mutable_array","ember-runtime/mixins/freezable","ember-runtime/mixins/copyable","ember-runtime/copy","ember-runtime/system/native_array","ember-views/mixins/class_names_support","ember-views/mixins/instrumentation_support","ember-views/mixins/aria_role_support","ember-views/mixins/visibility_support","ember-views/system/utils","ember-views/mixins/view_support","ember-views/views/view","ember-htmlbars/component","ember-htmlbars/node-managers/component-node-manager","ember-htmlbars/node-managers/view-node-manager","ember-htmlbars/streams/concat","ember-htmlbars/hooks/concat","ember-htmlbars/hooks/create-fresh-scope","ember-htmlbars/hooks/bind-shadow-scope","ember-htmlbars/hooks/bind-self","ember-htmlbars/hooks/bind-scope","ember-htmlbars/hooks/bind-local","ember-htmlbars/hooks/bind-block","ember-htmlbars/hooks/update-self","ember-htmlbars/hooks/get-root","ember-htmlbars/hooks/get-child","ember-htmlbars/hooks/get-block","ember-htmlbars/hooks/cleanup-render-node","ember-htmlbars/hooks/destroy-render-node","ember-htmlbars/hooks/did-render-node","ember-htmlbars/hooks/will-cleanup-tree","ember-htmlbars/hooks/did-cleanup-tree","ember-htmlbars/utils/is-component","ember-htmlbars/hooks/classify","ember-htmlbars/hooks/component","ember-htmlbars/hooks/lookup-helper","ember-htmlbars/hooks/has-helper","ember-htmlbars/hooks/invoke-helper","ember-htmlbars/hooks/element","ember-htmlbars/helpers","ember-htmlbars/keywords","morph-attr/sanitize-attribute-value","dom-helper/prop","dom-helper/build-html-dom","htmlbars-util/handlebars/safe-string","htmlbars-util/safe-string","htmlbars-util/handlebars/utils","htmlbars-util/namespaces","htmlbars-util","morph-attr","dom-helper/classes","dom-helper","ember-htmlbars/morphs/morph","ember-htmlbars/morphs/attr-morph","ember-htmlbars/system/dom-helper","ember-htmlbars/keywords/debugger","ember-htmlbars/keywords/with","ember-htmlbars/streams/should_display","ember-htmlbars/helpers/if_unless","ember-htmlbars/helpers/with","ember-htmlbars/helper","ember-runtime/string_registry","ember-runtime/system/string","ember-htmlbars/helpers/loc","ember-htmlbars/helpers/log","ember-htmlbars/utils/decode-each-key","ember-htmlbars/helpers/each","ember-htmlbars/helpers/each-in","ember-htmlbars/helpers/-normalize-class","ember-htmlbars/helpers/concat","ember-htmlbars/helpers/-join-classes","ember-htmlbars/helpers/-html-safe","ember-htmlbars/helpers/hash","ember-routing/system/query_params","ember-htmlbars/helpers/query-params","ember-htmlbars/system/template","ember-htmlbars/index","ember-htmlbars/templates/top-level-view","ember/version","ember-htmlbars/keywords/outlet","ember-htmlbars/keywords/unbound","ember-htmlbars/keywords/component","ember-htmlbars/keywords/element-component","ember-routing/system/generate_controller","ember-htmlbars/keywords/render","ember-htmlbars/keywords/mount","ember-views/system/lookup_partial","ember-htmlbars/keywords/partial","ember-htmlbars/keywords/input","ember-htmlbars/keywords/textarea","ember-htmlbars/keywords/yield","ember-htmlbars/keywords/readonly","ember-htmlbars/keywords/get","ember-htmlbars/keywords/action","ember-views/system/action_manager","ember-htmlbars/keywords/element-action","ember-htmlbars/env","ember-htmlbars/system/render-env","ember-htmlbars/system/render-view","ember-metal/dictionary","ember-views/compat/fallback-view-registry","ember-htmlbars/renderer","ember-htmlbars/components/checkbox","ember-views/mixins/text_support","ember-htmlbars/components/text_field","ember-htmlbars/components/text_area","ember-runtime/computed/computed_macros","ember-runtime/system/service","ember-htmlbars/templates/link-to","ember-htmlbars/components/link-to","ember-htmlbars/utils/string","ember-htmlbars/make-bound-helper","ember-views/mixins/template_support","ember-htmlbars/views/outlet","ember-htmlbars/setup-registry","ember-htmlbars/streams/key-stream","ember-runtime/mixins/-proxy","ember-metal/merge","ember-metal/weak_map","ember-metal/map","ember-metal/libraries","ember-metal/is_blank","ember-metal/is_present","ember-metal/index","ember-runtime/is-equal","ember-runtime/system/namespace","ember-runtime/mixins/container_proxy","container/container","container/registry","ember-runtime/system/container","ember-runtime/system/array_proxy","ember-runtime/system/object_proxy","ember-runtime/system/lazy_load","ember-runtime/mixins/promise_proxy","ember-runtime/computed/reduce_computed_macros","ember-runtime/controllers/controller","rsvp/events","rsvp/config","rsvp/utils","rsvp/instrument","rsvp/-internal","rsvp/enumerator","rsvp/promise/all","rsvp/promise/race","rsvp/promise/resolve","rsvp/promise/reject","rsvp/promise","rsvp/node","rsvp/all","rsvp/all-settled","rsvp/race","rsvp/promise-hash","rsvp/hash","rsvp/hash-settled","rsvp/rethrow","rsvp/defer","rsvp/map","rsvp/resolve","rsvp/reject","rsvp/filter","rsvp/asap","rsvp","ember-runtime/ext/rsvp","ember-runtime/ext/string","ember-runtime/ext/function","ember-runtime/mixins/registry_proxy","ember-runtime/index","ember-views/system/event_dispatcher","ember-views/mixins/view_target_action_support","ember-views/component_lookup","ember-views/index","ember-routing/ext/run_loop","ember-routing/ext/controller","ember-routing/location/util","ember-routing/location/api","ember-routing/location/none_location","ember-routing/location/hash_location","ember-routing/location/history_location","ember-routing/location/auto_location","ember-routing/system/controller_for","ember-routing/system/dsl","ember-routing/utils","ember-routing/system/route","ember-routing/system/router_state","route-recognizer/dsl","route-recognizer/normalizer","route-recognizer","router/utils","router/handler-info","router/transition-state","router/transition","router/transition-intent","router/handler-info/resolved-handler-info","router/handler-info/unresolved-handler-info-by-object","router/handler-info/unresolved-handler-info-by-param","router/handler-info/factory","router/transition-intent/named-transition-intent","router/unrecognized-url-error","router/transition-intent/url-transition-intent","router/router","router","ember-routing/system/router","ember-routing/index","ember-application/utils/validate-type","ember-templates/template_registry","ember-application/system/resolver","ember-routing/system/cache","ember-application/system/engine-parent","ember-application/system/engine-instance","ember-application/system/application-instance","vertex","visit","dag-map","ember-routing/services/routing","ember-extension-support/container_debug_adapter","ember-application/system/engine","ember-application/system/application","ember-application/initializers/dom-templates","ember-application/index","ember-extension-support/data_adapter","ember-extension-support/index","ember-templates/renderer","ember-templates/component","ember-templates/helper","ember-templates/components/checkbox","ember-templates/components/text_field","ember-templates/components/text_area","ember-templates/components/link-to","ember-templates/string","ember-templates/template","ember-templates/make-bound-helper","ember-templates/compat","ember-templates/index","ember/index"];
(function() {
  'use strict';
  var seen = {};
  var registry = {};
  var empty = {
    deps: [],
    callback: function () {}
  };
  // eager load
  var names = Em._eager;
  var exports = Em._e = new Array(names.length);
  for (var i = 0; i < names.length; i++) {
    var name = names[i];
    exports[i] = seen[name] = { default: undefined };
    // use an empty entry for checks if a module exists
    registry[name] = empty;
  }

  var loader = {
    registry: registry,
    seen: seen,
    define: function define(name, deps, callback) {
      loader._define(name, deps, callback);
    },
    _define: function define(name, deps, callback) {
      if (this.registry[name]) {
        return;
      }
      this.registry[name] = {
        deps: deps,
        callback: callback
      };
    },
    require: function (name) {
      return loader._require(name, undefined);
    },
    _require: function require(_name, referrerName) {
      var exports = this.seen[_name];
      if (exports !== undefined) {
        return exports;
      }

      var name = _name;
      var mod = this.registry[_name];
      if (!mod) {
        name = _name + '/index';
        exports = this.seen[name];
        if (exports !== undefined) {
          return exports;
        }
        mod = registry[name];
      }

      if (mod === undefined) {
        if (referrerName) {
          throw new Error('Could not find module ' + _name + ' required by: ' + referrerName);
        } else {
          throw new Error('Could not find module ' + _name);
        }
      }

      this.seen[name] = exports = { default: undefined };

      var deps = mod.deps;
      var reified = new Array(deps.length);
      for (var i = 0; i < reified.length; i++) {
        if (deps[i] === 'exports') {
          reified[i] = exports;
        } else if (deps[i] === 'require'){
          reified[i] = this.require;
        } else {
          reified[i] = this._require(deps[i], name);
        }
      }

      mod.callback.apply(undefined, reified);

      return exports;
    }
  };

  loader.require['default'] = loader.require;
  loader.require.has = function(name) {
    var registry = loader.registry;
    return !!registry[name] || !!registry[name + '/index'];
  };

  Em.__loader = loader;
})();

Em.__loader.define("container/index", ["exports","container/registry","container/container","container/owner"], function (exports, _containerRegistry, _containerContainer, _containerOwner) {
  /*
  Public API for the container is still in flux.
  The public API, specified on the application namespace should be considered the stable API.
  // @module container
    @private
  */

  'use strict';

  exports.Registry = _containerRegistry.default;
  exports.Container = _containerContainer.default;
  exports.getOwner = _containerOwner.getOwner;
  exports.setOwner = _containerOwner.setOwner;
});
Em.__loader.define("dag-map/platform", ["exports"], function (exports) {
  'use strict';

  var platform;

  /* global self */
  if (typeof self === 'object') {
    platform = self;

    /* global global */
  } else if (typeof global === 'object') {
      platform = global;
    } else {
      throw new Error('no global: `self` or `global` found');
    }

  exports.default = platform;
});
Em.__loader.define("ember-htmlbars/streams/class_name_binding", ["exports","ember-metal/debug","ember-metal/property_get","ember-metal/utils","ember-htmlbars/streams/utils","ember-runtime/system/string"], function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalUtils, _emberHtmlbarsStreamsUtils, _emberRuntimeSystemString) {
  'use strict';

  exports.parsePropertyPath = parsePropertyPath;
  exports.classStringForValue = classStringForValue;
  exports.streamifyClassNameBinding = streamifyClassNameBinding;

  /**
    Parse a path and return an object which holds the parsed properties.
  
    For example a path like "content.isEnabled:enabled:disabled" will return the
    following object:
  
    ```javascript
    {
      path: "content.isEnabled",
      className: "enabled",
      falsyClassName: "disabled",
      classNames: ":enabled:disabled"
    }
    ```
  
    @method parsePropertyPath
    @static
    @private
  */

  function parsePropertyPath(path) {
    var split = path.split(':');
    var propertyPath = split[0];
    var classNames = '';
    var className = undefined,
        falsyClassName = undefined;

    // check if the property is defined as prop:class or prop:trueClass:falseClass
    if (split.length > 1) {
      className = split[1];
      if (split.length === 3) {
        falsyClassName = split[2];
      }

      classNames = ':' + className;
      if (falsyClassName) {
        classNames += ':' + falsyClassName;
      }
    }

    return {
      path: propertyPath,
      classNames: classNames,
      className: className === '' ? undefined : className,
      falsyClassName: falsyClassName
    };
  }

  /**
    Get the class name for a given value, based on the path, optional
    `className` and optional `falsyClassName`.
  
    - if a `className` or `falsyClassName` has been specified:
      - if the value is truthy and `className` has been specified,
        `className` is returned
      - if the value is falsy and `falsyClassName` has been specified,
        `falsyClassName` is returned
      - otherwise `null` is returned
    - if the value is `true`, the dasherized last part of the supplied path
      is returned
    - if the value is not `false`, `undefined` or `null`, the `value`
      is returned
    - if none of the above rules apply, `null` is returned
  
    @method classStringForValue
    @param path
    @param val
    @param className
    @param falsyClassName
    @static
    @private
  */

  function classStringForValue(path, val, className, falsyClassName) {
    if (_emberMetalUtils.isArray(val)) {
      val = _emberMetalProperty_get.get(val, 'length') !== 0;
    }

    // When using the colon syntax, evaluate the truthiness or falsiness
    // of the value to determine which className to return
    if (className || falsyClassName) {
      if (className && !!val) {
        return className;
      } else if (falsyClassName && !val) {
        return falsyClassName;
      } else {
        return null;
      }

      // If value is a Boolean and true, return the dasherized property
      // name.
    } else if (val === true) {
        // Normalize property path to be suitable for use
        // as a class name. For exaple, content.foo.barBaz
        // becomes bar-baz.
        var parts = path.split('.');
        return _emberRuntimeSystemString.dasherize(parts[parts.length - 1]);

        // If the value is not false, undefined, or null, return the current
        // value of the property.
      } else if (val !== false && val != null) {
          return val;

          // Nothing to display. Return null so that the old class is removed
          // but no new class is added.
        } else {
            return null;
          }
  }

  function streamifyClassNameBinding(view, classNameBinding, prefix) {
    prefix = prefix || '';

    var parsedPath = parsePropertyPath(classNameBinding);
    if (parsedPath.path === '') {
      return classStringForValue(parsedPath.path, true, parsedPath.className, parsedPath.falsyClassName);
    } else {
      var _ret = (function () {
        var pathValue = view.getStream(prefix + parsedPath.path);
        return {
          v: _emberHtmlbarsStreamsUtils.chain(pathValue, function () {
            return classStringForValue(parsedPath.path, _emberHtmlbarsStreamsUtils.read(pathValue), parsedPath.className, parsedPath.falsyClassName);
          })
        };
      })();

      if (typeof _ret === 'object') return _ret.v;
    }
  }
});
Em.__loader.define("ember-htmlbars/templates/component", ["exports","ember-htmlbars/index"], function (exports, _emberHtmlbars) {
  "use strict";

  exports.default = _emberHtmlbars.template((function () {
    return {
      meta: {},
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "yield", ["loc", [null, [1, 0], [1, 9]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
});
Em.__loader.define("ember-htmlbars/templates/empty", ["exports","ember-htmlbars/index"], function (exports, _emberHtmlbars) {
  "use strict";

  exports.default = _emberHtmlbars.template((function () {
    return {
      meta: {},
      isEmpty: true,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        return el0;
      },
      buildRenderNodes: function buildRenderNodes() {
        return [];
      },
      statements: [],
      locals: [],
      templates: []
    };
  })());
});
Em.__loader.define("ember-htmlbars/utils/new-stream", ["exports","ember-htmlbars/streams/proxy-stream","ember-htmlbars/utils/subscribe"], function (exports, _emberHtmlbarsStreamsProxyStream, _emberHtmlbarsUtilsSubscribe) {
  'use strict';

  exports.default = newStream;

  function newStream(scope, key, newValue, renderNode, isSelf) {
    var stream = new _emberHtmlbarsStreamsProxyStream.default(newValue, isSelf ? '' : key);
    if (renderNode) {
      _emberHtmlbarsUtilsSubscribe.default(renderNode, scope, stream);
    }
    scope[key] = stream;
  }
});
Em.__loader.define("ember-htmlbars/utils/normalize-self", ["exports"], function (exports) {
  "use strict";

  exports.default = normalizeSelf;

  function normalizeSelf(self) {
    if (self === undefined) {
      return null;
    } else {
      return self;
    }
  }
});
Em.__loader.define("ember-htmlbars/utils/update-scope", ["exports","ember-htmlbars/streams/proxy-stream","ember-htmlbars/utils/subscribe"], function (exports, _emberHtmlbarsStreamsProxyStream, _emberHtmlbarsUtilsSubscribe) {
  'use strict';

  exports.default = updateScope;

  function updateScope(scope, key, newValue, renderNode, isSelf) {
    var existing = scope[key];

    if (existing) {
      existing.setSource(newValue);
    } else {
      var stream = new _emberHtmlbarsStreamsProxyStream.default(newValue, isSelf ? null : key);
      if (renderNode) {
        _emberHtmlbarsUtilsSubscribe.default(renderNode, scope, stream);
      }
      scope[key] = stream;
    }
  }
});
Em.__loader.define("ember-metal/deprecate_property", ["exports","ember-metal/debug","ember-metal/property_get","ember-metal/property_set"], function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set) {
  /**
  @module ember
  @submodule ember-metal
  */

  'use strict';

  exports.deprecateProperty = deprecateProperty;

  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.
  
    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */

  function deprecateProperty(object, deprecatedKey, newKey, options) {
    function _deprecate() {}

    Object.defineProperty(object, deprecatedKey, {
      configurable: true,
      enumerable: false,
      set: function (value) {
        _deprecate();
        _emberMetalProperty_set.set(this, newKey, value);
      },
      get: function () {
        _deprecate();
        return _emberMetalProperty_get.get(this, newKey);
      }
    });
  }
});
Em.__loader.define("ember-runtime/system/application", ["exports","ember-runtime/system/namespace"], function (exports, _emberRuntimeSystemNamespace) {
  'use strict';

  exports.default = _emberRuntimeSystemNamespace.default.extend();
});
Em.__loader.define("ember-views/system/platform", ["exports","ember-environment/index"], function (exports, _emberEnvironment) {
  'use strict';

  // IE 6/7 have bugs around setting names on inputs during creation.
  // From http://msdn.microsoft.com/en-us/library/ie/ms536389(v=vs.85).aspx:
  // "To include the NAME attribute at run time on objects created with the createElement method, use the eTag."
  var canSetNameOnInputs = _emberEnvironment.environment.hasDOM && (function () {
    var div = document.createElement('div');
    var el = document.createElement('input');

    el.setAttribute('name', 'foo');
    div.appendChild(el);

    return !!div.innerHTML.match('foo');
  })();
  exports.canSetNameOnInputs = canSetNameOnInputs;
});
Em.__loader.define("htmlbars-util/quoting", ["exports"], function (exports) {
  "use strict";

  exports.hash = hash;
  exports.repeat = repeat;
  function escapeString(str) {
    str = str.replace(/\\/g, "\\\\");
    str = str.replace(/"/g, '\\"');
    str = str.replace(/\n/g, "\\n");
    return str;
  }

  exports.escapeString = escapeString;

  function string(str) {
    return '"' + escapeString(str) + '"';
  }

  exports.string = string;

  function array(a) {
    return "[" + a + "]";
  }

  exports.array = array;

  function hash(pairs) {
    return "{" + pairs.join(", ") + "}";
  }

  function repeat(chars, times) {
    var str = "";
    while (times--) {
      str += chars;
    }
    return str;
  }
});
Em.__loader.define("rsvp/platform", ["exports"], function (exports) {
  'use strict';

  var platform;

  /* global self */
  if (typeof self === 'object') {
    platform = self;

    /* global global */
  } else if (typeof global === 'object') {
      platform = global;
    } else {
      throw new Error('no global: `self` or `global` found');
    }

  exports.default = platform;
});
(function (exports) {
  "use strict";

  exports.getDebugFunction = getDebugFunction;
  exports.setDebugFunction = setDebugFunction;
  exports.assert = assert;
  exports.info = info;
  exports.warn = warn;
  exports.debug = debug;
  exports.deprecate = deprecate;
  exports.deprecateFunc = deprecateFunc;
  exports.runInDebug = runInDebug;
  exports.debugSeal = debugSeal;
  var debugFunctions = {
    assert: function () {},
    info: function () {},
    warn: function () {},
    debug: function () {},
    deprecate: function () {},
    deprecateFunc: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return args[args.length - 1];
    },
    runInDebug: function () {},
    debugSeal: function () {}
  };

  exports.debugFunctions = debugFunctions;

  function getDebugFunction(name) {
    return debugFunctions[name];
  }

  function setDebugFunction(name, fn) {
    debugFunctions[name] = fn;
  }

  function assert() {
    return debugFunctions.assert.apply(undefined, arguments);
  }

  function info() {
    return debugFunctions.info.apply(undefined, arguments);
  }

  function warn() {
    return debugFunctions.warn.apply(undefined, arguments);
  }

  function debug() {
    return debugFunctions.debug.apply(undefined, arguments);
  }

  function deprecate() {
    return debugFunctions.deprecate.apply(undefined, arguments);
  }

  function deprecateFunc() {
    return debugFunctions.deprecateFunc.apply(undefined, arguments);
  }

  function runInDebug() {
    return debugFunctions.runInDebug.apply(undefined, arguments);
  }

  function debugSeal() {
    return debugFunctions.debugSeal.apply(undefined, arguments);
  }
})(Em._e[0]);
(function (exports) {
  "use strict";

  exports.isTesting = isTesting;
  exports.setTesting = setTesting;
  var testing = false;

  function isTesting() {
    return testing;
  }

  function setTesting(value) {
    testing = !!value;
  }
})(Em._e[1]);
(function (exports) {
  /* globals global, window, self, Em.__global */

  // from lodash to catch fake globals
  'use strict';

  function checkGlobal(value) {
    return value && value.Object === Object ? value : undefined;
  }

  // element ids can ruin global miss checks
  function checkElementIdShadowing(value) {
    return value && value.nodeType === undefined ? value : undefined;
  }

  // export real global
  exports.default = checkGlobal(checkElementIdShadowing(typeof global === 'object' && global)) || checkGlobal(typeof self === 'object' && self) || checkGlobal(typeof window === 'object' && window) || Em.__global || // set before strict mode in Ember loader/wrapper
  new Function('return this')();
  // eval outside of strict mode
})(Em._e[2]);
(function (exports) {
  "use strict";

  exports.defaultTrue = defaultTrue;
  exports.defaultFalse = defaultFalse;
  exports.normalizeExtendPrototypes = normalizeExtendPrototypes;

  function defaultTrue(v) {
    return v === false ? false : true;
  }

  function defaultFalse(v) {
    return v === true ? true : false;
  }

  function normalizeExtendPrototypes(obj) {
    if (obj === false) {
      return { String: false, Array: false, Function: false };
    } else if (!obj || obj === true) {
      return { String: true, Array: true, Function: true };
    } else {
      return {
        String: defaultTrue(obj.String),
        Array: defaultTrue(obj.Array),
        Function: defaultTrue(obj.Function)
      };
    }
  }
})(Em._e[3]);
(function (exports, _emberEnvironmentGlobal, _emberEnvironmentUtils) {
  /* globals module */
  'use strict';

  /**
    The hash of environment variables used to control various configuration
    settings. To specify your own or override default settings, add the
    desired properties to a global hash named `EmberENV` (or `ENV` for
    backwards compatibility with earlier versions of Ember). The `EmberENV`
    hash must be created before loading Ember.
  
    @class EmberENV
    @type Object
    @public
  */
  var ENV = typeof _emberEnvironmentGlobal.default.EmberENV === 'object' && _emberEnvironmentGlobal.default.EmberENV || typeof _emberEnvironmentGlobal.default.ENV === 'object' && _emberEnvironmentGlobal.default.ENV || {};

  exports.ENV = ENV;
  // ENABLE_ALL_FEATURES was documented, but you can't actually enable non optional features.
  if (ENV.ENABLE_ALL_FEATURES) {
    ENV.ENABLE_OPTIONAL_FEATURES = true;
  }

  /**
    Determines whether Ember should add to `Array`, `Function`, and `String`
    native object prototypes, a few extra methods in order to provide a more
    friendly API.
  
    We generally recommend leaving this option set to true however, if you need
    to turn it off, you can add the configuration property
    `EXTEND_PROTOTYPES` to `EmberENV` and set it to `false`.
  
    Note, when disabled (the default configuration for Ember Addons), you will
    instead have to access all methods and functions from the Ember
    namespace.
  
    @property EXTEND_PROTOTYPES
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.EXTEND_PROTOTYPES = _emberEnvironmentUtils.normalizeExtendPrototypes(ENV.EXTEND_PROTOTYPES);

  /**
    The `LOG_STACKTRACE_ON_DEPRECATION` property, when true, tells Ember to log
    a full stack trace during deprecation warnings.
  
    @property LOG_STACKTRACE_ON_DEPRECATION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_STACKTRACE_ON_DEPRECATION = _emberEnvironmentUtils.defaultTrue(ENV.LOG_STACKTRACE_ON_DEPRECATION);

  /**
    The `LOG_VERSION` property, when true, tells Ember to log versions of all
    dependent libraries in use.
  
    @property LOG_VERSION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_VERSION = _emberEnvironmentUtils.defaultTrue(ENV.LOG_VERSION);

  // default false
  ENV.MODEL_FACTORY_INJECTIONS = _emberEnvironmentUtils.defaultFalse(ENV.MODEL_FACTORY_INJECTIONS);

  /**
    Debug parameter you can turn on. This will log all bindings that fire to
    the console. This should be disabled in production code. Note that you
    can also enable this from the console or temporarily.
  
    @property LOG_BINDINGS
    @for EmberENV
    @type Boolean
    @default false
    @public
  */
  ENV.LOG_BINDINGS = _emberEnvironmentUtils.defaultFalse(ENV.LOG_BINDINGS);

  ENV.RAISE_ON_DEPRECATION = _emberEnvironmentUtils.defaultFalse(ENV.RAISE_ON_DEPRECATION);

  // check if window exists and actually is the global
  var hasDOM = typeof window !== 'undefined' && window === _emberEnvironmentGlobal.default && window.document && window.document.createElement && !ENV.disableBrowserEnvironment; // is this a public thing?

  // legacy imports/exports/lookup stuff (should we keep this??)
  var originalContext = _emberEnvironmentGlobal.default.Ember || {};

  var context = {
    // import jQuery
    imports: originalContext.imports || _emberEnvironmentGlobal.default,
    // export Ember
    exports: originalContext.exports || _emberEnvironmentGlobal.default,
    // search for Namespaces
    lookup: originalContext.lookup || _emberEnvironmentGlobal.default
  };

  exports.context = context;
  // TODO: cleanup single source of truth issues with this stuff
  var environment = hasDOM ? {
    hasDOM: true,
    isChrome: !!window.chrome && !window.opera,
    isFirefox: typeof InstallTrigger !== 'undefined',
    isPhantom: !!window.callPhantom,
    location: window.location,
    history: window.history,
    userAgent: window.navigator.userAgent,
    window: window
  } : {
    hasDOM: false,
    isChrome: false,
    isFirefox: false,
    isPhantom: false,
    location: null,
    history: null,
    userAgent: 'Lynx (textmode)',
    window: null
  };
  exports.environment = environment;
})(Em._e[4],Em._e[2],Em._e[3]);
(function (exports, _emberEnvironment) {
  'use strict';

  function K() {}

  function consoleMethod(name) {
    var consoleObj = undefined;
    if (_emberEnvironment.context.imports.console) {
      consoleObj = _emberEnvironment.context.imports.console;
    } else if (typeof console !== 'undefined') {
      consoleObj = console;
    }

    var method = typeof consoleObj === 'object' ? consoleObj[name] : null;

    if (typeof method !== 'function') {
      return;
    }

    if (typeof method.bind === 'function') {
      return method.bind(consoleObj);
    }

    return function () {
      method.apply(consoleObj, arguments);
    };
  }

  function assertPolyfill(test, message) {
    if (!test) {
      try {
        // attempt to preserve the stack
        throw new Error('assertion failed: ' + message);
      } catch (error) {
        setTimeout(function () {
          throw error;
        }, 0);
      }
    }
  }

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.
  
    @class Logger
    @namespace Ember
    @public
  */
  exports.default = {
    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    log: consoleMethod('log') || K,

    /**
     Prints the arguments to the console with a warning icon.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    warn: consoleMethod('warn') || K,

    /**
     Prints the arguments to the console with an error icon, red text and a stack trace.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    error: consoleMethod('error') || K,

    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    info: consoleMethod('info') || K,

    /**
     Logs the arguments to the console in blue text.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    debug: consoleMethod('debug') || consoleMethod('info') || K,

    /**
     If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      Ember.Logger.assert(true === false, 'Something invalid'); // Throws an Assertion failed error with message.
      ```
      @method assert
     @for Ember.Logger
     @param {Boolean} bool Value to test
     @param {String} message Assertion message on failed
     @public
    */
    assert: consoleMethod('assert') || assertPolyfill
  };
})(Em._e[5],Em._e[4]);
(function (exports, _emberConsole, _emberMetalTesting) {
  'use strict';

  exports.getOnerror = getOnerror;
  exports.setOnerror = setOnerror;
  exports.dispatchError = dispatchError;
  exports.setDispatchOverride = setDispatchOverride;

  // To maintain stacktrace consistency across browsers
  var getStack = function (error) {
    var stack = error.stack;
    var message = error.message;

    if (stack.indexOf(message) === -1) {
      stack = message + '\n' + stack;
    }

    return stack;
  };

  var onerror = undefined;
  // Ember.onerror getter

  function getOnerror() {
    return onerror;
  }

  // Ember.onerror setter

  function setOnerror(handler) {
    onerror = handler;
  }

  var dispatchOverride = undefined;
  // dispatch error

  function dispatchError(error) {
    if (dispatchOverride) {
      dispatchOverride(error);
    } else {
      defaultDispatch(error);
    }
  }

  // allows testing adapter to override dispatch

  function setDispatchOverride(handler) {
    dispatchOverride = handler;
  }

  function defaultDispatch(error) {
    if (_emberMetalTesting.isTesting()) {
      throw error;
    }
    if (onerror) {
      onerror(error);
    } else {
      _emberConsole.default.error(getStack(error));
    }
  }
})(Em._e[6],Em._e[5],Em._e[1]);
(function (exports) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  /**
  @module ember-metal
  */

  /**
    Previously we used `Ember.$.uuid`, however `$.uuid` has been removed from
    jQuery master. We'll just bootstrap our own uuid now.
  
    @private
    @return {Number} the uuid
  */
  exports.uuid = uuid;
  exports.intern = intern;
  exports.generateGuid = generateGuid;
  exports.guidFor = guidFor;
  exports.wrap = wrap;
  exports.tryInvoke = tryInvoke;
  exports.makeArray = makeArray;
  exports.inspect = inspect;
  exports.applyStr = applyStr;
  exports.lookupDescriptor = lookupDescriptor;
  exports.toString = toString;
  var _uuid = 0;

  /**
    Generates a universally unique identifier. This method
    is used internally by Ember for assisting with
    the generation of GUID's and other unique identifiers.
  
    @public
    @return {Number} [description]
   */

  function uuid() {
    return ++_uuid;
  }

  /**
    Prefix used for guids through out Ember.
    @private
    @property GUID_PREFIX
    @for Ember
    @type String
    @final
  */
  var GUID_PREFIX = 'ember';

  // Used for guid generation...
  var numberCache = [];
  var stringCache = {};

  /**
    Strongly hint runtimes to intern the provided string.
  
    When do I need to use this function?
  
    For the most part, never. Pre-mature optimization is bad, and often the
    runtime does exactly what you need it to, and more often the trade-off isn't
    worth it.
  
    Why?
  
    Runtimes store strings in at least 2 different representations:
    Ropes and Symbols (interned strings). The Rope provides a memory efficient
    data-structure for strings created from concatenation or some other string
    manipulation like splitting.
  
    Unfortunately checking equality of different ropes can be quite costly as
    runtimes must resort to clever string comparison algorithms. These
    algorithms typically cost in proportion to the length of the string.
    Luckily, this is where the Symbols (interned strings) shine. As Symbols are
    unique by their string content, equality checks can be done by pointer
    comparison.
  
    How do I know if my string is a rope or symbol?
  
    Typically (warning general sweeping statement, but truthy in runtimes at
    present) static strings created as part of the JS source are interned.
    Strings often used for comparisons can be interned at runtime if some
    criteria are met.  One of these criteria can be the size of the entire rope.
    For example, in chrome 38 a rope longer then 12 characters will not
    intern, nor will segments of that rope.
  
    Some numbers: http://jsperf.com/eval-vs-keys/8
  
    Known Trick™
  
    @private
    @return {String} interned version of the provided string
  */

  function intern(str) {
    var obj = {};
    obj[str] = 1;
    for (var key in obj) {
      if (key === str) {
        return key;
      }
    }
    return str;
  }

  /**
    A unique key used to assign guids and other private metadata to objects.
    If you inspect an object in your browser debugger you will often see these.
    They can be safely ignored.
  
    On browsers that support it, these properties are added with enumeration
    disabled so they won't show up when you iterate over your properties.
  
    @private
    @property GUID_KEY
    @for Ember
    @type String
    @final
  */
  var GUID_KEY = intern('__ember' + +new Date());

  var GUID_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  exports.GUID_DESC = GUID_DESC;
  var nullDescriptor = {
    configurable: true,
    writable: true,
    enumerable: false,
    value: null
  };

  var GUID_KEY_PROPERTY = {
    name: GUID_KEY,
    descriptor: nullDescriptor
  };

  exports.GUID_KEY_PROPERTY = GUID_KEY_PROPERTY;
  /**
    Generates a new guid, optionally saving the guid to the object that you
    pass in. You will rarely need to use this method. Instead you should
    call `Ember.guidFor(obj)`, which return an existing guid if available.
  
    @private
    @method generateGuid
    @for Ember
    @param {Object} [obj] Object the guid will be used for. If passed in, the guid will
      be saved on the object and reused whenever you pass the same object
      again.
  
      If no object is passed, just generate a new guid.
    @param {String} [prefix] Prefix to place in front of the guid. Useful when you want to
      separate the guid into separate namespaces.
    @return {String} the guid
  */

  function generateGuid(obj, prefix) {
    if (!prefix) {
      prefix = GUID_PREFIX;
    }

    var ret = prefix + uuid();
    if (obj) {
      if (obj[GUID_KEY] === null) {
        obj[GUID_KEY] = ret;
      } else {
        GUID_DESC.value = ret;
        if (obj.__defineNonEnumerable) {
          obj.__defineNonEnumerable(GUID_KEY_PROPERTY);
        } else {
          Object.defineProperty(obj, GUID_KEY, GUID_DESC);
        }
      }
    }
    return ret;
  }

  /**
    Returns a unique id for the object. If the object does not yet have a guid,
    one will be assigned to it. You can call this on any object,
    `Ember.Object`-based or not, but be aware that it will add a `_guid`
    property.
  
    You can also use this method on DOM Element objects.
  
    @public
    @method guidFor
    @for Ember
    @param {Object} obj any object, string, number, Element, or primitive
    @return {String} the unique guid for this instance.
  */

  function guidFor(obj) {
    var type = typeof obj;
    var isObject = type === 'object' && obj !== null;
    var isFunction = type === 'function';

    if ((isObject || isFunction) && obj[GUID_KEY]) {
      return obj[GUID_KEY];
    }

    // special cases where we don't want to add a key to object
    if (obj === undefined) {
      return '(undefined)';
    }

    if (obj === null) {
      return '(null)';
    }

    var ret = undefined;

    // Don't allow prototype changes to String etc. to change the guidFor
    switch (type) {
      case 'number':
        ret = numberCache[obj];

        if (!ret) {
          ret = numberCache[obj] = 'nu' + obj;
        }

        return ret;

      case 'string':
        ret = stringCache[obj];

        if (!ret) {
          ret = stringCache[obj] = 'st' + uuid();
        }

        return ret;

      case 'boolean':
        return obj ? '(true)' : '(false)';

      default:
        if (obj === Object) {
          return '(Object)';
        }

        if (obj === Array) {
          return '(Array)';
        }

        ret = GUID_PREFIX + uuid();

        if (obj[GUID_KEY] === null) {
          obj[GUID_KEY] = ret;
        } else {
          GUID_DESC.value = ret;

          if (obj.__defineNonEnumerable) {
            obj.__defineNonEnumerable(GUID_KEY_PROPERTY);
          } else {
            Object.defineProperty(obj, GUID_KEY, GUID_DESC);
          }
        }
        return ret;
    }
  }

  var HAS_SUPER_PATTERN = /\.(_super|call\(this|apply\(this)/;
  var fnToString = Function.prototype.toString;

  var checkHasSuper = (function () {
    var sourceAvailable = fnToString.call(function () {
      return this;
    }).indexOf('return this') > -1;

    if (sourceAvailable) {
      return function checkHasSuper(func) {
        return HAS_SUPER_PATTERN.test(fnToString.call(func));
      };
    }

    return function checkHasSuper() {
      return true;
    };
  })();

  exports.checkHasSuper = checkHasSuper;
  function ROOT() {}
  ROOT.__hasSuper = false;

  function hasSuper(func) {
    if (func.__hasSuper === undefined) {
      func.__hasSuper = checkHasSuper(func);
    }
    return func.__hasSuper;
  }

  /**
    Wraps the passed function so that `this._super` will point to the superFunc
    when the function is invoked. This is the primitive we use to implement
    calls to super.
  
    @private
    @method wrap
    @for Ember
    @param {Function} func The function to call
    @param {Function} superFunc The super function.
    @return {Function} wrapped function.
  */

  function wrap(func, superFunc) {
    if (!hasSuper(func)) {
      return func;
    }
    // ensure an unwrapped super that calls _super is wrapped with a terminal _super
    if (!superFunc.wrappedFunction && hasSuper(superFunc)) {
      return _wrap(func, _wrap(superFunc, ROOT));
    }
    return _wrap(func, superFunc);
  }

  function _wrap(func, superFunc) {
    function superWrapper() {
      var orig = this._super;
      this._super = superFunc;
      var ret = func.apply(this, arguments);
      this._super = orig;
      return ret;
    }

    superWrapper.wrappedFunction = func;
    superWrapper.__ember_observes__ = func.__ember_observes__;
    superWrapper.__ember_observesBefore__ = func.__ember_observesBefore__;
    superWrapper.__ember_listens__ = func.__ember_listens__;

    return superWrapper;
  }

  /**
    Checks to see if the `methodName` exists on the `obj`.
  
    ```javascript
    let foo = { bar: function() { return 'bar'; }, baz: null };
  
    Ember.canInvoke(foo, 'bar'); // true
    Ember.canInvoke(foo, 'baz'); // false
    Ember.canInvoke(foo, 'bat'); // false
    ```
  
    @method canInvoke
    @for Ember
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @return {Boolean}
    @private
  */
  function canInvoke(obj, methodName) {
    return !!(obj && typeof obj[methodName] === 'function');
  }

  /**
    Checks to see if the `methodName` exists on the `obj`,
    and if it does, invokes it with the arguments passed.
  
    ```javascript
    let d = new Date('03/15/2013');
  
    Ember.tryInvoke(d, 'getTime');              // 1363320000000
    Ember.tryInvoke(d, 'setFullYear', [2014]);  // 1394856000000
    Ember.tryInvoke(d, 'noSuchMethod', [2014]); // undefined
    ```
  
    @method tryInvoke
    @for Ember
    @param {Object} obj The object to check for the method
    @param {String} methodName The method name to check for
    @param {Array} [args] The arguments to pass to the method
    @return {*} the return value of the invoked method or undefined if it cannot be invoked
    @public
  */

  function tryInvoke(obj, methodName, args) {
    if (canInvoke(obj, methodName)) {
      return args ? applyStr(obj, methodName, args) : applyStr(obj, methodName);
    }
  }

  // ........................................
  // TYPING & ARRAY MESSAGING
  //

  var objectToString = Object.prototype.toString;

  /**
    Forces the passed object to be part of an array. If the object is already
    an array, it will return the object. Otherwise, it will add the object to
    an array. If obj is `null` or `undefined`, it will return an empty array.
  
    ```javascript
    Ember.makeArray();            // []
    Ember.makeArray(null);        // []
    Ember.makeArray(undefined);   // []
    Ember.makeArray('lindsay');   // ['lindsay']
    Ember.makeArray([1, 2, 42]);  // [1, 2, 42]
  
    let controller = Ember.ArrayProxy.create({ content: [] });
  
    Ember.makeArray(controller) === controller;  // true
    ```
  
    @method makeArray
    @for Ember
    @param {Object} obj the object
    @return {Array}
    @private
  */

  function makeArray(obj) {
    if (obj === null || obj === undefined) {
      return [];
    }
    return Array.isArray(obj) ? obj : [obj];
  }

  /**
    Convenience method to inspect an object. This method will attempt to
    convert the object into a useful string description.
  
    It is a pretty simple implementation. If you want something more robust,
    use something like JSDump: https://github.com/NV/jsDump
  
    @method inspect
    @for Ember
    @param {Object} obj The object you want to inspect.
    @return {String} A description of the object
    @since 1.4.0
    @private
  */

  function inspect(obj) {
    if (obj === null) {
      return 'null';
    }
    if (obj === undefined) {
      return 'undefined';
    }
    if (Array.isArray(obj)) {
      return '[' + obj + ']';
    }
    // for non objects
    var type = typeof obj;
    if (type !== 'object' && type !== 'symbol') {
      return '' + obj;
    }
    // overridden toString
    if (typeof obj.toString === 'function' && obj.toString !== objectToString) {
      return obj.toString();
    }

    // Object.prototype.toString === {}.toString
    var v = undefined;
    var ret = [];
    for (var key in obj) {
      if (obj.hasOwnProperty(key)) {
        v = obj[key];
        if (v === 'toString') {
          continue;
        } // ignore useless items
        if (typeof v === 'function') {
          v = 'function() { ... }';
        }

        if (v && typeof v.toString !== 'function') {
          ret.push(key + ': ' + objectToString.call(v));
        } else {
          ret.push(key + ': ' + v);
        }
      }
    }
    return '{' + ret.join(', ') + '}';
  }

  /**
    @param {Object} t target
    @param {String} m method
    @param {Array} a args
    @private
  */

  function applyStr(t, m, a) {
    var l = a && a.length;
    if (!a || !l) {
      return t[m]();
    }
    switch (l) {
      case 1:
        return t[m](a[0]);
      case 2:
        return t[m](a[0], a[1]);
      case 3:
        return t[m](a[0], a[1], a[2]);
      case 4:
        return t[m](a[0], a[1], a[2], a[3]);
      case 5:
        return t[m](a[0], a[1], a[2], a[3], a[4]);
      default:
        return t[m].apply(t, a);
    }
  }

  function lookupDescriptor(obj, keyName) {
    var current = obj;
    while (current) {
      var descriptor = Object.getOwnPropertyDescriptor(current, keyName);

      if (descriptor) {
        return descriptor;
      }

      current = Object.getPrototypeOf(current);
    }

    return null;
  }

  // A `toString` util function that supports objects without a `toString`
  // method, e.g. an object created with `Object.create(null)`.

  function toString(obj) {
    if (obj && obj.toString) {
      return obj.toString();
    } else {
      return objectToString.call(obj);
    }
  }

  exports.GUID_KEY = GUID_KEY;
  exports.makeArray = makeArray;
  exports.canInvoke = canInvoke;
})(Em._e[7]);
(function (exports) {
  /**
    Copy properties from a source object to a target object.
  
    ```javascript
    var a = { first: 'Yehuda' };
    var b = { last: 'Katz' };
    var c = { company: 'Tilde Inc.' };
    Ember.assign(a, b, c); // a === { first: 'Yehuda', last: 'Katz', company: 'Tilde Inc.' }, b === { last: 'Katz' }, c === { company: 'Tilde Inc.' }
    ```
  
    @method assign
    @for Ember
    @param {Object} original The object to assign into
    @param {Object} ...args The objects to copy properties from
    @return {Object}
    @public
  */
  "use strict";

  exports.default = assign;

  function assign(original) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    for (var i = 0; i < args.length; i++) {
      var arg = args[i];
      if (!arg) {
        continue;
      }

      var updates = Object.keys(arg);

      for (var _i = 0; _i < updates.length; _i++) {
        var prop = updates[_i];
        original[prop] = arg[prop];
      }
    }

    return original;
  }
})(Em._e[8]);
(function (exports) {
  "use strict";

  exports.default = { "features-stripped-test": false, "ember-routing-route-configured-query-params": false, "ember-libraries-isregistered": false, "ember-application-engines": true, "ember-glimmer": false, "ember-runtime-computed-uniq-by": true, "ember-improved-instrumentation": false, "ember-runtime-enumerable-includes": true, "ember-string-ishtmlsafe": true, "ember-testing-check-waiters": true, "ember-metal-weakmap": false, "ember-glimmer-allow-backtracking-rerender": false, "mandatory-setter": false, "ember-glimmer-detect-backtracking-rerender": false };
})(Em._e[9]);
(function (exports, _emberEnvironment, _emberMetalAssign, _emberFeatures) {
  'use strict';

  exports.default = isEnabled;

  /**
    The hash of enabled Canary features. Add to this, any canary features
    before creating your application.
  
    Alternatively (and recommended), you can also define `EmberENV.FEATURES`
    if you need to enable features flagged at runtime.
  
    @class FEATURES
    @namespace Ember
    @static
    @since 1.1.0
    @public
  */
  var FEATURES = _emberMetalAssign.default(_emberFeatures.default, _emberEnvironment.ENV.FEATURES);

  exports.FEATURES = FEATURES;
  /**
    Determine whether the specified `feature` is enabled. Used by Ember's
    build tools to exclude experimental features from beta/stable builds.
  
    You can define the following configuration options:
  
    * `EmberENV.ENABLE_OPTIONAL_FEATURES` - enable any features that have not been explicitly
      enabled/disabled.
  
    @method isEnabled
    @param {String} feature The feature to check
    @return {Boolean}
    @for Ember.FEATURES
    @since 1.1.0
    @public
  */

  function isEnabled(feature) {
    var featureValue = FEATURES[feature];

    if (featureValue === true || featureValue === false || featureValue === undefined) {
      return featureValue;
    } else if (_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES) {
      return true;
    } else {
      return false;
    }
  }

  exports.DEFAULT_FEATURES = _emberFeatures.default;
})(Em._e[10],Em._e[4],Em._e[8],Em._e[9]);
(function (exports) {
  /*
   When we render a rich template hierarchy, the set of events that
   *might* happen tends to be much larger than the set of events that
   actually happen. This implies that we should make listener creation &
   destruction cheap, even at the cost of making event dispatch more
   expensive.
  
   Thus we store a new listener with a single push and no new
   allocations, without even bothering to do deduplication -- we can
   save that for dispatch time, if an event actually happens.
   */

  /* listener flags */
  'use strict';

  var ONCE = 1;
  exports.ONCE = ONCE;
  var SUSPENDED = 2;

  exports.SUSPENDED = SUSPENDED;
  var protoMethods = {

    addToListeners: function (eventName, target, method, flags) {
      if (!this._listeners) {
        this._listeners = [];
      }
      this._listeners.push(eventName, target, method, flags);
    },

    _finalizeListeners: function () {
      if (this._listenersFinalized) {
        return;
      }
      if (!this._listeners) {
        this._listeners = [];
      }
      var pointer = this.parent;
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          this._listeners = this._listeners.concat(listeners);
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      this._listenersFinalized = true;
    },

    removeFromListeners: function (eventName, target, method, didRemove) {
      var pointer = this;
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = listeners.length - 4; index >= 0; index -= 4) {
            if (listeners[index] === eventName && (!method || listeners[index + 1] === target && listeners[index + 2] === method)) {
              if (pointer === this) {
                // we are modifying our own list, so we edit directly
                if (typeof didRemove === 'function') {
                  didRemove(eventName, target, listeners[index + 2]);
                }
                listeners.splice(index, 4);
              } else {
                // we are trying to remove an inherited listener, so we do
                // just-in-time copying to detach our own listeners from
                // our inheritance chain.
                this._finalizeListeners();
                return this.removeFromListeners(eventName, target, method);
              }
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
    },

    matchingListeners: function (eventName) {
      var pointer = this;
      var result = [];
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = 0; index < listeners.length - 3; index += 4) {
            if (listeners[index] === eventName) {
              pushUniqueListener(result, listeners, index);
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      var sus = this._suspendedListeners;
      if (sus) {
        for (var susIndex = 0; susIndex < sus.length - 2; susIndex += 3) {
          if (eventName === sus[susIndex]) {
            for (var resultIndex = 0; resultIndex < result.length - 2; resultIndex += 3) {
              if (result[resultIndex] === sus[susIndex + 1] && result[resultIndex + 1] === sus[susIndex + 2]) {
                result[resultIndex + 2] |= SUSPENDED;
              }
            }
          }
        }
      }
      return result;
    },

    suspendListeners: function (eventNames, target, method, callback) {
      var sus = this._suspendedListeners;
      if (!sus) {
        sus = this._suspendedListeners = [];
      }
      for (var i = 0; i < eventNames.length; i++) {
        sus.push(eventNames[i], target, method);
      }
      try {
        return callback.call(target);
      } finally {
        if (sus.length === eventNames.length) {
          this._suspendedListeners = undefined;
        } else {
          for (var i = sus.length - 3; i >= 0; i -= 3) {
            if (sus[i + 1] === target && sus[i + 2] === method && eventNames.indexOf(sus[i]) !== -1) {
              sus.splice(i, 3);
            }
          }
        }
      }
    },

    watchedEvents: function () {
      var pointer = this;
      var names = {};
      while (pointer) {
        var listeners = pointer._listeners;
        if (listeners) {
          for (var index = 0; index < listeners.length - 3; index += 4) {
            names[listeners[index]] = true;
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      return Object.keys(names);
    },

    _initializeListeners: function () {
      this._listeners = undefined;
      this._listenersFinalized = undefined;
      this._suspendedListeners = undefined;
    }
  };

  exports.protoMethods = protoMethods;
  function pushUniqueListener(destination, source, index) {
    var target = source[index + 1];
    var method = source[index + 2];
    for (var destinationIndex = 0; destinationIndex < destination.length - 2; destinationIndex += 3) {
      if (destination[destinationIndex] === target && destination[destinationIndex + 1] === method) {
        return;
      }
    }
    destination.push(target, method, source[index + 3]);
  }
})(Em._e[11]);
(function (exports) {
  // This exists because `Object.create(null)` is absurdly slow compared
  // to `new EmptyObject()`. In either case, you want a null prototype
  // when you're treating the object instances as arbitrary dictionaries
  // and don't want your keys colliding with build-in methods on the
  // default object prototype.

  "use strict";

  var proto = Object.create(null, {
    // without this, we will always still end up with (new
    // EmptyObject()).constructor === Object
    constructor: {
      value: undefined,
      enumerable: false,
      writable: true
    }
  });

  function EmptyObject() {}
  EmptyObject.prototype = proto;
  exports.default = EmptyObject;
})(Em._e[12]);
(function (exports, _emberMetalUtils) {
  'use strict';

  exports.default = symbol;

  function symbol(debugName) {
    // TODO: Investigate using platform symbols, but we do not
    // want to require non-enumerability for this API, which
    // would introduce a large cost.

    return _emberMetalUtils.intern(debugName + ' [id=' + _emberMetalUtils.GUID_KEY + Math.floor(Math.random() * new Date()) + ']');
  }
})(Em._e[13],Em._e[7]);
(function (exports, _emberMetalFeatures, _emberMetalMeta_listeners, _emberMetalEmpty_object, _emberMetalUtils, _emberMetalSymbol) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  exports.meta = meta;
  exports.peekMeta = peekMeta;
  exports.deleteMeta = deleteMeta;

  /**
  @module ember-metal
  */

  /*
   This declares several meta-programmed members on the Meta class. Such
   meta!
  
   In general, the `readable` variants will give you an object (if it
   already exists) that you can read but should not modify. The
   `writable` variants will give you a mutable object, and they will
   create it if it didn't already exist.
  
   The following methods will get generated metaprogrammatically, and
   I'm including them here for greppability:
  
   writableCache, readableCache, writeWatching,
   peekWatching, clearWatching, writeMixins,
   peekMixins, clearMixins, writeBindings,
   peekBindings, clearBindings, writeValues,
   peekValues, clearValues, writeDeps, forEachInDeps
   writableChainWatchers, readableChainWatchers, writableChains,
   readableChains, writableTag, readableTag
  
  */
  var members = {
    cache: ownMap,
    weak: ownMap,
    watching: inheritedMap,
    mixins: inheritedMap,
    bindings: inheritedMap,
    values: inheritedMap,
    deps: inheritedMapOfMaps,
    chainWatchers: ownCustomObject,
    chains: inheritedCustomObject,
    tag: ownCustomObject
  };

  if (false || false) {
    members.lastRendered = ownMap;
    members.lastRenderedFrom = ownMap; // FIXME: not used in production, remove me from prod builds
  }

  var memberNames = Object.keys(members);
  var META_FIELD = '__ember_meta__';

  function Meta(obj, parentMeta) {
    this._cache = undefined;
    this._weak = undefined;
    this._watching = undefined;
    this._mixins = undefined;
    this._bindings = undefined;
    this._values = undefined;
    this._deps = undefined;
    this._chainWatchers = undefined;
    this._chains = undefined;
    this._tag = undefined;

    // used only internally
    this.source = obj;

    // when meta(obj).proto === obj, the object is intended to be only a
    // prototype and doesn't need to actually be observable itself
    this.proto = undefined;

    // The next meta in our inheritance chain. We (will) track this
    // explicitly instead of using prototypical inheritance because we
    // have detailed knowledge of how each property should really be
    // inherited, and we can optimize it much better than JS runtimes.
    this.parent = parentMeta;

    if (false || false) {
      this._lastRendered = undefined;
      this._lastRenderedFrom = undefined; // FIXME: not used in production, remove me from prod builds
    }

    this._initializeListeners();
  }

  Meta.prototype.isInitialized = function (obj) {
    return this.proto !== obj;
  };

  for (var _name in _emberMetalMeta_listeners.protoMethods) {
    Meta.prototype[_name] = _emberMetalMeta_listeners.protoMethods[_name];
  }
  memberNames.forEach(function (name) {
    return members[name](name, Meta);
  });

  // Implements a member that is a lazily created, non-inheritable
  // POJO.
  function ownMap(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function () {
      return this._getOrCreateOwnMap(key);
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this[key];
    };
  }

  Meta.prototype._getOrCreateOwnMap = function (key) {
    var ret = this[key];
    if (!ret) {
      ret = this[key] = new _emberMetalEmpty_object.default();
    }
    return ret;
  };

  // Implements a member that is a lazily created POJO with inheritable
  // values.
  function inheritedMap(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);

    Meta.prototype['write' + capitalized] = function (subkey, value) {
      var map = this._getOrCreateOwnMap(key);
      map[subkey] = value;
    };

    Meta.prototype['peek' + capitalized] = function (subkey) {
      return this._findInherited(key, subkey);
    };

    Meta.prototype['forEach' + capitalized] = function (fn) {
      var pointer = this;
      var seen = new _emberMetalEmpty_object.default();
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          for (var _key in map) {
            if (!seen[_key]) {
              seen[_key] = true;
              fn(_key, map[_key]);
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype['clear' + capitalized] = function () {
      this[key] = undefined;
    };

    Meta.prototype['deleteFrom' + capitalized] = function (subkey) {
      delete this._getOrCreateOwnMap(key)[subkey];
    };

    Meta.prototype['hasIn' + capitalized] = function (subkey) {
      return this._findInherited(key, subkey) !== undefined;
    };
  }

  Meta.prototype._getInherited = function (key) {
    var pointer = this;
    while (pointer !== undefined) {
      if (pointer[key]) {
        return pointer[key];
      }
      pointer = pointer.parent;
    }
  };

  Meta.prototype._findInherited = function (key, subkey) {
    var pointer = this;
    while (pointer !== undefined) {
      var map = pointer[key];
      if (map) {
        var value = map[subkey];
        if (value !== undefined) {
          return value;
        }
      }
      pointer = pointer.parent;
    }
  };

  var UNDEFINED = _emberMetalSymbol.default('undefined');

  exports.UNDEFINED = UNDEFINED;
  // Implements a member that provides a lazily created map of maps,
  // with inheritance at both levels.
  function inheritedMapOfMaps(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);

    Meta.prototype['write' + capitalized] = function (subkey, itemkey, value) {
      var outerMap = this._getOrCreateOwnMap(key);
      var innerMap = outerMap[subkey];
      if (!innerMap) {
        innerMap = outerMap[subkey] = new _emberMetalEmpty_object.default();
      }
      innerMap[itemkey] = value;
    };

    Meta.prototype['peek' + capitalized] = function (subkey, itemkey) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map) {
          var value = map[subkey];
          if (value) {
            if (value[itemkey] !== undefined) {
              return value[itemkey];
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype['has' + capitalized] = function (subkey) {
      var pointer = this;
      while (pointer !== undefined) {
        if (pointer[key] && pointer[key][subkey]) {
          return true;
        }
        pointer = pointer.parent;
      }
      return false;
    };

    Meta.prototype['forEachIn' + capitalized] = function (subkey, fn) {
      return this._forEachIn(key, subkey, fn);
    };
  }

  Meta.prototype._forEachIn = function (key, subkey, fn) {
    var pointer = this;
    var seen = new _emberMetalEmpty_object.default();
    var calls = [];
    while (pointer !== undefined) {
      var map = pointer[key];
      if (map) {
        var innerMap = map[subkey];
        if (innerMap) {
          for (var innerKey in innerMap) {
            if (!seen[innerKey]) {
              seen[innerKey] = true;
              calls.push([innerKey, innerMap[innerKey]]);
            }
          }
        }
      }
      pointer = pointer.parent;
    }
    for (var i = 0; i < calls.length; i++) {
      var _calls$i = calls[i];
      var innerKey = _calls$i[0];
      var value = _calls$i[1];

      fn(innerKey, value);
    }
  };

  // Implements a member that provides a non-heritable, lazily-created
  // object using the method you provide.
  function ownCustomObject(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function (create) {
      var ret = this[key];
      if (!ret) {
        ret = this[key] = create(this.source);
      }
      return ret;
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this[key];
    };
  }

  // Implements a member that provides an inheritable, lazily-created
  // object using the method you provide. We will derived children from
  // their parents by calling your object's `copy()` method.
  function inheritedCustomObject(name, Meta) {
    var key = memberProperty(name);
    var capitalized = capitalize(name);
    Meta.prototype['writable' + capitalized] = function (create) {
      var ret = this[key];
      if (!ret) {
        if (this.parent) {
          ret = this[key] = this.parent['writable' + capitalized](create).copy(this.source);
        } else {
          ret = this[key] = create(this.source);
        }
      }
      return ret;
    };
    Meta.prototype['readable' + capitalized] = function () {
      return this._getInherited(key);
    };
  }

  function memberProperty(name) {
    return '_' + name;
  }

  // there's a more general-purpose capitalize in ember-runtime, but we
  // don't want to make ember-metal depend on ember-runtime.
  function capitalize(name) {
    return name.replace(/^\w/, function (m) {
      return m.toUpperCase();
    });
  }

  var META_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  exports.META_DESC = META_DESC;
  var EMBER_META_PROPERTY = {
    name: META_FIELD,
    descriptor: META_DESC
  };

  if (false) {
    Meta.prototype.readInheritedValue = function (key, subkey) {
      var internalKey = '_' + key;

      var pointer = this;

      while (pointer !== undefined) {
        var map = pointer[internalKey];
        if (map) {
          var value = map[subkey];
          if (value !== undefined || subkey in map) {
            return map[subkey];
          }
        }
        pointer = pointer.parent;
      }

      return UNDEFINED;
    };

    Meta.prototype.writeValue = function (obj, key, value) {
      var descriptor = _emberMetalUtils.lookupDescriptor(obj, key);
      var isMandatorySetter = descriptor && descriptor.set && descriptor.set.isMandatorySetter;

      if (isMandatorySetter) {
        this.writeValues(key, value);
      } else {
        obj[key] = value;
      }
    };
  }

  // choose the one appropriate for given platform
  var setMeta = function (obj, meta) {
    // if `null` already, just set it to the new value
    // otherwise define property first
    if (obj[META_FIELD] !== null) {
      if (obj.__defineNonEnumerable) {
        obj.__defineNonEnumerable(EMBER_META_PROPERTY);
      } else {
        Object.defineProperty(obj, META_FIELD, META_DESC);
      }
    }

    obj[META_FIELD] = meta;
  };

  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.
  
    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.
  
    @method meta
    @for Ember
    @private
  
    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */

  function meta(obj) {
    var maybeMeta = peekMeta(obj);
    var parent = undefined;

    // remove this code, in-favor of explicit parent
    if (maybeMeta) {
      if (maybeMeta.source === obj) {
        return maybeMeta;
      }
      parent = maybeMeta;
    }

    var newMeta = new Meta(obj, parent);
    setMeta(obj, newMeta);
    return newMeta;
  }

  function peekMeta(obj) {
    return obj[META_FIELD];
  }

  function deleteMeta(obj) {
    if (typeof obj[META_FIELD] !== 'object') {
      return;
    }
    obj[META_FIELD] = null;
  }
})(Em._e[14],Em._e[10],Em._e[11],Em._e[12],Em._e[7],Em._e[13]);
(function (exports, _emberMetalDebug, _emberMetalUtils, _emberMetalMeta, _emberMetalMeta_listeners) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  /**
  @module ember
  @submodule ember-metal
  */
  exports.accumulateListeners = accumulateListeners;
  exports.addListener = addListener;
  exports.removeListener = removeListener;
  exports.suspendListener = suspendListener;
  exports.suspendListeners = suspendListeners;
  exports.watchedEvents = watchedEvents;
  exports.sendEvent = sendEvent;
  exports.hasListeners = hasListeners;
  exports.listenersFor = listenersFor;
  exports.on = on;

  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.
  
    The hashes are stored in the object's meta hash, and look like this:
  
        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:changed": [ // variable name: `actions`
              target, method, flags
            ]
          }
        }
  
  */

  function indexOf(array, target, method) {
    var index = -1;
    // hashes are added to the end of the event array
    // so it makes sense to start searching at the end
    // of the array and search in reverse
    for (var i = array.length - 3; i >= 0; i -= 3) {
      if (target === array[i] && method === array[i + 1]) {
        index = i;
        break;
      }
    }
    return index;
  }

  function accumulateListeners(obj, eventName, otherActions) {
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return;
    }
    var actions = meta.matchingListeners(eventName);
    var newActions = [];

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];
      var actionIndex = indexOf(otherActions, target, method);

      if (actionIndex === -1) {
        otherActions.push(target, method, flags);
        newActions.push(target, method, flags);
      }
    }

    return newActions;
  }

  /**
    Add an event listener
  
    @method addListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Boolean} once A flag whether a function should only be called once
    @public
  */

  function addListener(obj, eventName, target, method, once) {

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    var flags = 0;
    if (once) {
      flags |= _emberMetalMeta_listeners.ONCE;
    }

    _emberMetalMeta.meta(obj).addToListeners(eventName, target, method, flags);

    if ('function' === typeof obj.didAddListener) {
      obj.didAddListener(eventName, target, method);
    }
  }

  /**
    Remove an event listener
  
    Arguments should match those passed to `Ember.addListener`.
  
    @method removeListener
    @for Ember
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @public
  */

  function removeListener(obj, eventName, target, method) {

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    _emberMetalMeta.meta(obj).removeFromListeners(eventName, target, method, function () {
      if ('function' === typeof obj.didRemoveListener) {
        obj.didRemoveListener.apply(obj, arguments);
      }
    });
  }

  /**
    Suspend listener during callback.
  
    This should only be used by the target of the event listener
    when it is taking an action that would cause the event, e.g.
    an object might suspend its property change listener while it is
    setting that property.
  
    @method suspendListener
    @for Ember
  
    @private
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */

  function suspendListener(obj, eventName, target, method, callback) {
    return suspendListeners(obj, [eventName], target, method, callback);
  }

  /**
    Suspends multiple listeners during a callback.
  
    @method suspendListeners
    @for Ember
  
    @private
    @param obj
    @param {Array} eventNames Array of event names
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */

  function suspendListeners(obj, eventNames, target, method, callback) {
    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }
    return _emberMetalMeta.meta(obj).suspendListeners(eventNames, target, method, callback);
  }

  /**
    Return a list of currently watched events
  
    @private
    @method watchedEvents
    @for Ember
    @param obj
  */

  function watchedEvents(obj) {
    return _emberMetalMeta.meta(obj).watchedEvents();
  }

  /**
    Send an event. The execution of suspended listeners
    is skipped, and once listeners are removed. A listener without
    a target is executed on the passed object. If an array of actions
    is not passed, the actions stored on the passed object are invoked.
  
    @method sendEvent
    @for Ember
    @param obj
    @param {String} eventName
    @param {Array} params Optional parameters for each listener.
    @param {Array} actions Optional array of actions (listeners).
    @return true
    @public
  */

  function sendEvent(obj, eventName, params, actions) {
    if (!actions) {
      var meta = _emberMetalMeta.peekMeta(obj);
      actions = meta && meta.matchingListeners(eventName);
    }

    if (!actions || actions.length === 0) {
      return;
    }

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];

      if (!method) {
        continue;
      }
      if (flags & _emberMetalMeta_listeners.SUSPENDED) {
        continue;
      }
      if (flags & _emberMetalMeta_listeners.ONCE) {
        removeListener(obj, eventName, target, method);
      }
      if (!target) {
        target = obj;
      }
      if ('string' === typeof method) {
        if (params) {
          _emberMetalUtils.applyStr(target, method, params);
        } else {
          target[method]();
        }
      } else {
        if (params) {
          method.apply(target, params);
        } else {
          method.call(target);
        }
      }
    }
    return true;
  }

  /**
    @private
    @method hasListeners
    @for Ember
    @param obj
    @param {String} eventName
  */

  function hasListeners(obj, eventName) {
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta) {
      return false;
    }
    return meta.matchingListeners(eventName).length > 0;
  }

  /**
    @private
    @method listenersFor
    @for Ember
    @param obj
    @param {String} eventName
  */

  function listenersFor(obj, eventName) {
    var ret = [];
    var meta = _emberMetalMeta.peekMeta(obj);
    var actions = meta && meta.matchingListeners(eventName);

    if (!actions) {
      return ret;
    }

    for (var i = 0; i < actions.length; i += 3) {
      var target = actions[i];
      var method = actions[i + 1];
      ret.push([target, method]);
    }

    return ret;
  }

  /**
    Define a property as a function that should be executed when
    a specified event or events are triggered.
  
  
    ``` javascript
    let Job = Ember.Object.extend({
      logCompleted: Ember.on('completed', function() {
        console.log('Job completed!');
      })
    });
  
    let job = Job.create();
  
    Ember.sendEvent(job, 'completed'); // Logs 'Job completed!'
   ```
  
    @method on
    @for Ember
    @param {String} eventNames*
    @param {Function} func
    @return func
    @public
  */

  function on() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var func = args.pop();
    var events = args;
    func.__ember_listens__ = events;
    return func;
  }
})(Em._e[15],Em._e[0],Em._e[7],Em._e[14],Em._e[11]);
(function (exports, _emberMetalMeta, _require2) {
  'use strict';

  exports.setHasViews = setHasViews;
  exports.tagFor = tagFor;

  var hasGlimmer = _require2.has('glimmer-reference');
  var CONSTANT_TAG = undefined,
      CURRENT_TAG = undefined,
      DirtyableTag = undefined,
      makeTag = undefined,
      run = undefined;

  var hasViews = function () {
    return false;
  };

  function setHasViews(fn) {
    hasViews = fn;
  }

  var markObjectAsDirty = undefined;

  exports.markObjectAsDirty = markObjectAsDirty;

  function tagFor(object, _meta) {
    if (!hasGlimmer) {
      throw new Error('Cannot call tagFor without Glimmer');
    }

    if (typeof object === 'object' && object) {
      var meta = _meta || _emberMetalMeta.meta(object);
      return meta.writableTag(makeTag);
    } else {
      return CONSTANT_TAG;
    }
  }

  function K() {}
  function ensureRunloop() {
    if (!run) {
      run = _require2.default('ember-metal/run_loop').default;
    }

    if (hasViews() && !run.backburner.currentInstance) {
      run.schedule('actions', K);
    }
  }

  if (hasGlimmer) {
    var _require = _require2.default('glimmer-reference');

    DirtyableTag = _require.DirtyableTag;
    CONSTANT_TAG = _require.CONSTANT_TAG;
    CURRENT_TAG = _require.CURRENT_TAG;

    makeTag = function () {
      return new DirtyableTag();
    };

    exports.markObjectAsDirty = markObjectAsDirty = function (meta) {
      ensureRunloop();
      var tag = meta && meta.readableTag() || CURRENT_TAG;
      tag.dirty();
    };
  } else {
    exports.markObjectAsDirty = markObjectAsDirty = function () {};
  }
})(Em._e[17],Em._e[14],Em.__loader.require);
(function (exports, _emberMetalUtils, _emberMetalEvents) {
  'use strict';

  exports.default = ObserverSet;

  /*
    this.observerSet = {
      [senderGuid]: { // variable name: `keySet`
        [keyName]: listIndex
      }
    },
    this.observers = [
      {
        sender: obj,
        keyName: keyName,
        eventName: eventName,
        listeners: [
          [target, method, flags]
        ]
      },
      ...
    ]
  */

  function ObserverSet() {
    this.clear();
  }

  ObserverSet.prototype.add = function (sender, keyName, eventName) {
    var observerSet = this.observerSet;
    var observers = this.observers;
    var senderGuid = _emberMetalUtils.guidFor(sender);
    var keySet = observerSet[senderGuid];
    var index = undefined;

    if (!keySet) {
      observerSet[senderGuid] = keySet = {};
    }
    index = keySet[keyName];
    if (index === undefined) {
      index = observers.push({
        sender: sender,
        keyName: keyName,
        eventName: eventName,
        listeners: []
      }) - 1;
      keySet[keyName] = index;
    }
    return observers[index].listeners;
  };

  ObserverSet.prototype.flush = function () {
    var observers = this.observers;
    var i = undefined,
        observer = undefined,
        sender = undefined;
    this.clear();
    for (i = 0; i < observers.length; ++i) {
      observer = observers[i];
      sender = observer.sender;
      if (sender.isDestroying || sender.isDestroyed) {
        continue;
      }
      _emberMetalEvents.sendEvent(sender, observer.eventName, [sender, observer.keyName], observer.listeners);
    }
  };

  ObserverSet.prototype.clear = function () {
    this.observerSet = {};
    this.observers = [];
  };
})(Em._e[18],Em._e[7],Em._e[15]);
(function (exports, _emberMetalMeta, _emberMetalDebug, _emberMetalFeatures) {
  'use strict';

  var runInTransaction = undefined,
      didRender = undefined,
      assertNotRendered = undefined;

  if (false || false) {}

  var raise = _emberMetalDebug.assert;
  if (false) {
    raise = function (message, test) {};
  }

  var implication = undefined;
  if (false) {
    implication = 'will be removed in Ember 3.0.';
  } else if (false) {
    implication = 'is no longer supported. See https://github.com/emberjs/ember.js/issues/13948 for more details.';
  }

  if (false || false) {
    (function () {
      var counter = 0;
      var inTransaction = false;
      var shouldReflush = undefined;

      exports.default = runInTransaction = function (callback) {
        shouldReflush = false;
        inTransaction = true;
        callback();
        inTransaction = false;
        counter++;
        return shouldReflush;
      };

      exports.didRender = didRender = function (object, key, reference) {
        if (!inTransaction) {
          return;
        }
        var meta = _emberMetalMeta.meta(object);
        var lastRendered = meta.writableLastRendered();
        lastRendered[key] = counter;
      };

      exports.assertNotRendered = assertNotRendered = function (object, key, _meta) {
        var meta = _meta || _emberMetalMeta.meta(object);
        var lastRendered = meta.readableLastRendered();

        if (lastRendered && lastRendered[key] === counter) {
          raise((function () {
            var ref = meta.readableLastRenderedFrom();
            var parts = [];
            var lastRef = ref[key];

            var label = undefined;

            if (lastRef) {
              while (lastRef && lastRef._propertyKey && lastRef._parentReference) {
                parts.unshift(lastRef._propertyKey);
                lastRef = lastRef._parentReference;
              }

              label = parts.join();
            } else {
              label = 'the same value';
            }

            return 'You modified ' + parts.join('.') + ' twice in a single render. This was unreliable and slow in Ember 1.x and ' + implication;
          })(), false);

          shouldReflush = true;
        }
      };
    })();
  } else {
    exports.default = runInTransaction = function () {
      throw new Error('Cannot call runInTransaction without Glimmer');
    };

    exports.didRender = didRender = function () {
      throw new Error('Cannot call didRender without Glimmer');
    };

    exports.assertNotRendered = assertNotRendered = function () {
      throw new Error('Cannot call assertNotRendered without Glimmer');
    };
  }

  exports.default = runInTransaction;
  exports.didRender = didRender;
  exports.assertNotRendered = assertNotRendered;
})(Em._e[19],Em._e[14],Em._e[0],Em._e[10]);
(function (exports, _emberMetalUtils, _emberMetalMeta, _emberMetalEvents, _emberMetalTags, _emberMetalObserver_set, _emberMetalSymbol, _emberMetalFeatures, _emberMetalTransaction) {
  'use strict';

  var PROPERTY_DID_CHANGE = _emberMetalSymbol.default('PROPERTY_DID_CHANGE');

  exports.PROPERTY_DID_CHANGE = PROPERTY_DID_CHANGE;
  var beforeObserverSet = new _emberMetalObserver_set.default();
  var observerSet = new _emberMetalObserver_set.default();
  var deferred = 0;

  // ..........................................................
  // PROPERTY CHANGES
  //

  /**
    This function is called just before an object property is about to change.
    It will notify any before observers and prepare caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyDidChange()` which you should call just
    after the property value changes.
  
    @method propertyWillChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
    @private
  */
  function propertyWillChange(obj, keyName) {
    var m = _emberMetalMeta.peekMeta(obj);

    if (m && !m.isInitialized(obj)) {
      return;
    }

    var watching = m && m.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    if (desc && desc.willChange) {
      desc.willChange(obj, keyName);
    }

    if (watching) {
      dependentKeysWillChange(obj, keyName, m);
      chainsWillChange(obj, keyName, m);
      notifyBeforeObservers(obj, keyName);
    }
  }

  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyWillChange()` which you should call just
    before the property value changes.
  
    @method propertyDidChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
    @private
  */
  function propertyDidChange(obj, keyName) {
    var m = _emberMetalMeta.peekMeta(obj);

    if (m && !m.isInitialized(obj)) {
      return;
    }

    var watching = m && m.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    // shouldn't this mean that we're watching this key?
    if (desc && desc.didChange) {
      desc.didChange(obj, keyName);
    }

    if (watching) {
      if (m.hasDeps(keyName)) {
        dependentKeysDidChange(obj, keyName, m);
      }

      chainsDidChange(obj, keyName, m, false);
      notifyObservers(obj, keyName);
    }

    if (obj[PROPERTY_DID_CHANGE]) {
      obj[PROPERTY_DID_CHANGE](keyName);
    }

    if (obj.isDestroying) {
      return;
    }
    _emberMetalTags.markObjectAsDirty(m);

    if (false || false) {
      _emberMetalTransaction.assertNotRendered(obj, keyName, m);
    }
  }

  var WILL_SEEN = undefined,
      DID_SEEN = undefined;
  // called whenever a property is about to change to clear the cache of any dependent keys (and notify those properties of changes, etc...)
  function dependentKeysWillChange(obj, depKey, meta) {
    if (obj.isDestroying) {
      return;
    }

    if (meta && meta.hasDeps(depKey)) {
      var seen = WILL_SEEN;
      var _top = !seen;

      if (_top) {
        seen = WILL_SEEN = {};
      }

      iterDeps(propertyWillChange, obj, depKey, seen, meta);

      if (_top) {
        WILL_SEEN = null;
      }
    }
  }

  // called whenever a property has just changed to update dependent keys
  function dependentKeysDidChange(obj, depKey, meta) {
    if (obj.isDestroying) {
      return;
    }

    if (meta && meta.hasDeps(depKey)) {
      var seen = DID_SEEN;
      var _top2 = !seen;

      if (_top2) {
        seen = DID_SEEN = {};
      }

      iterDeps(propertyDidChange, obj, depKey, seen, meta);

      if (_top2) {
        DID_SEEN = null;
      }
    }
  }

  function iterDeps(method, obj, depKey, seen, meta) {
    var possibleDesc = undefined,
        desc = undefined;
    var guid = _emberMetalUtils.guidFor(obj);
    var current = seen[guid];

    if (!current) {
      current = seen[guid] = {};
    }

    if (current[depKey]) {
      return;
    }

    current[depKey] = true;

    meta.forEachInDeps(depKey, function (key, value) {
      if (!value) {
        return;
      }

      possibleDesc = obj[key];
      desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      if (desc && desc._suspended === obj) {
        return;
      }

      method(obj, key);
    });
  }

  function chainsWillChange(obj, keyName, m) {
    var c = m.readableChainWatchers();
    if (c) {
      c.notify(keyName, false, propertyWillChange);
    }
  }

  function chainsDidChange(obj, keyName, m) {
    var c = m.readableChainWatchers();
    if (c) {
      c.notify(keyName, true, propertyDidChange);
    }
  }

  function overrideChains(obj, keyName, m) {
    var c = m.readableChainWatchers();
    if (c) {
      c.revalidate(keyName);
    }
  }

  /**
    @method beginPropertyChanges
    @chainable
    @private
  */
  function beginPropertyChanges() {
    deferred++;
  }

  /**
    @method endPropertyChanges
    @private
  */
  function endPropertyChanges() {
    deferred--;
    if (deferred <= 0) {
      beforeObserverSet.clear();
      observerSet.flush();
    }
  }

  /**
    Make a series of property changes together in an
    exception-safe way.
  
    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```
  
    @method changeProperties
    @param {Function} callback
    @param [binding]
    @private
  */
  function changeProperties(callback, binding) {
    beginPropertyChanges();
    try {
      callback.call(binding);
    } finally {
      endPropertyChanges.call(binding);
    }
  }

  function notifyBeforeObservers(obj, keyName) {
    if (obj.isDestroying) {
      return;
    }

    var eventName = keyName + ':before';
    var listeners = undefined,
        added = undefined;
    if (deferred) {
      listeners = beforeObserverSet.add(obj, keyName, eventName);
      added = _emberMetalEvents.accumulateListeners(obj, eventName, listeners);
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName], added);
    } else {
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  function notifyObservers(obj, keyName) {
    if (obj.isDestroying) {
      return;
    }

    var eventName = keyName + ':change';
    var listeners = undefined;
    if (deferred) {
      listeners = observerSet.add(obj, keyName, eventName);
      _emberMetalEvents.accumulateListeners(obj, eventName, listeners);
    } else {
      _emberMetalEvents.sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  exports.propertyWillChange = propertyWillChange;
  exports.propertyDidChange = propertyDidChange;
  exports.overrideChains = overrideChains;
  exports.beginPropertyChanges = beginPropertyChanges;
  exports.endPropertyChanges = endPropertyChanges;
  exports.changeProperties = changeProperties;
})(Em._e[20],Em._e[7],Em._e[14],Em._e[15],Em._e[17],Em._e[18],Em._e[13],Em._e[10],Em._e[19]);
(function (exports) {
  'use strict';

  exports.each = each;
  exports.isString = isString;
  exports.isFunction = isFunction;
  exports.isNumber = isNumber;
  exports.isCoercableNumber = isCoercableNumber;
  var NUMBER = /\d+/;

  function each(collection, callback) {
    for (var i = 0; i < collection.length; i++) {
      callback(collection[i]);
    }
  }

  function isString(suspect) {
    return typeof suspect === 'string';
  }

  function isFunction(suspect) {
    return typeof suspect === 'function';
  }

  function isNumber(suspect) {
    return typeof suspect === 'number';
  }

  function isCoercableNumber(number) {
    return isNumber(number) || NUMBER.test(number);
  }
})(Em._e[21]);
(function (exports) {
  'use strict';

  var GlobalContext;

  /* global self */
  if (typeof self === 'object') {
    GlobalContext = self;

    /* global global */
  } else if (typeof global === 'object') {
      GlobalContext = global;

      /* global window */
    } else if (typeof window === 'object') {
        GlobalContext = window;
      } else {
        throw new Error('no global: `self`, `global` nor `window` was found');
      }

  exports.default = GlobalContext;
})(Em._e[22]);
(function (exports) {
  "use strict";

  exports.default = binarySearch;

  function binarySearch(time, timers) {
    var start = 0;
    var end = timers.length - 2;
    var middle, l;

    while (start < end) {
      // since timers is an array of pairs 'l' will always
      // be an integer
      l = (end - start) / 2;

      // compensate for the index in case even number
      // of pairs inside timers
      middle = start + l - l % 2;

      if (time >= timers[middle]) {
        start = middle + 2;
      } else {
        end = middle;
      }
    }

    return time >= timers[start] ? start + 2 : start;
  }
})(Em._e[23]);
(function (exports, _backburnerUtils) {
  'use strict';

  exports.default = Queue;

  function Queue(name, options, globalOptions) {
    this.name = name;
    this.globalOptions = globalOptions || {};
    this.options = options;
    this._queue = [];
    this.targetQueues = {};
    this._queueBeingFlushed = undefined;
  }

  Queue.prototype = {
    push: function (target, method, args, stack) {
      var queue = this._queue;
      queue.push(target, method, args, stack);

      return {
        queue: this,
        target: target,
        method: method
      };
    },

    pushUniqueWithoutGuid: function (target, method, args, stack) {
      var queue = this._queue;

      for (var i = 0, l = queue.length; i < l; i += 4) {
        var currentTarget = queue[i];
        var currentMethod = queue[i + 1];

        if (currentTarget === target && currentMethod === method) {
          queue[i + 2] = args; // replace args
          queue[i + 3] = stack; // replace stack
          return;
        }
      }

      queue.push(target, method, args, stack);
    },

    targetQueue: function (targetQueue, target, method, args, stack) {
      var queue = this._queue;

      for (var i = 0, l = targetQueue.length; i < l; i += 2) {
        var currentMethod = targetQueue[i];
        var currentIndex = targetQueue[i + 1];

        if (currentMethod === method) {
          queue[currentIndex + 2] = args; // replace args
          queue[currentIndex + 3] = stack; // replace stack
          return;
        }
      }

      targetQueue.push(method, queue.push(target, method, args, stack) - 4);
    },

    pushUniqueWithGuid: function (guid, target, method, args, stack) {
      var hasLocalQueue = this.targetQueues[guid];

      if (hasLocalQueue) {
        this.targetQueue(hasLocalQueue, target, method, args, stack);
      } else {
        this.targetQueues[guid] = [method, this._queue.push(target, method, args, stack) - 4];
      }

      return {
        queue: this,
        target: target,
        method: method
      };
    },

    pushUnique: function (target, method, args, stack) {
      var KEY = this.globalOptions.GUID_KEY;

      if (target && KEY) {
        var guid = target[KEY];
        if (guid) {
          return this.pushUniqueWithGuid(guid, target, method, args, stack);
        }
      }

      this.pushUniqueWithoutGuid(target, method, args, stack);

      return {
        queue: this,
        target: target,
        method: method
      };
    },

    invoke: function (target, method, args, _, _errorRecordedForStack) {
      if (args && args.length > 0) {
        method.apply(target, args);
      } else {
        method.call(target);
      }
    },

    invokeWithOnError: function (target, method, args, onError, errorRecordedForStack) {
      try {
        if (args && args.length > 0) {
          method.apply(target, args);
        } else {
          method.call(target);
        }
      } catch (error) {
        onError(error, errorRecordedForStack);
      }
    },

    flush: function (sync) {
      var queue = this._queue;
      var length = queue.length;

      if (length === 0) {
        return;
      }

      var globalOptions = this.globalOptions;
      var options = this.options;
      var before = options && options.before;
      var after = options && options.after;
      var onError = globalOptions.onError || globalOptions.onErrorTarget && globalOptions.onErrorTarget[globalOptions.onErrorMethod];
      var target, method, args, errorRecordedForStack;
      var invoke = onError ? this.invokeWithOnError : this.invoke;

      this.targetQueues = Object.create(null);
      var queueItems = this._queueBeingFlushed = this._queue.slice();
      this._queue = [];

      if (before) {
        before();
      }

      for (var i = 0; i < length; i += 4) {
        target = queueItems[i];
        method = queueItems[i + 1];
        args = queueItems[i + 2];
        errorRecordedForStack = queueItems[i + 3]; // Debugging assistance

        if (_backburnerUtils.isString(method)) {
          method = target[method];
        }

        // method could have been nullified / canceled during flush
        if (method) {
          //
          //    ** Attention intrepid developer **
          //
          //    To find out the stack of this task when it was scheduled onto
          //    the run loop, add the following to your app.js:
          //
          //    Ember.run.backburner.DEBUG = true; // NOTE: This slows your app, don't leave it on in production.
          //
          //    Once that is in place, when you are at a breakpoint and navigate
          //    here in the stack explorer, you can look at `errorRecordedForStack.stack`,
          //    which will be the captured stack when this job was scheduled.
          //
          invoke(target, method, args, onError, errorRecordedForStack);
        }
      }

      if (after) {
        after();
      }

      this._queueBeingFlushed = undefined;

      if (sync !== false && this._queue.length > 0) {
        // check if new items have been added
        this.flush(true);
      }
    },

    cancel: function (actionToCancel) {
      var queue = this._queue,
          currentTarget,
          currentMethod,
          i,
          l;
      var target = actionToCancel.target;
      var method = actionToCancel.method;
      var GUID_KEY = this.globalOptions.GUID_KEY;

      if (GUID_KEY && this.targetQueues && target) {
        var targetQueue = this.targetQueues[target[GUID_KEY]];

        if (targetQueue) {
          for (i = 0, l = targetQueue.length; i < l; i++) {
            if (targetQueue[i] === method) {
              targetQueue.splice(i, 1);
            }
          }
        }
      }

      for (i = 0, l = queue.length; i < l; i += 4) {
        currentTarget = queue[i];
        currentMethod = queue[i + 1];

        if (currentTarget === target && currentMethod === method) {
          queue.splice(i, 4);
          return true;
        }
      }

      // if not found in current queue
      // could be in the queue that is being flushed
      queue = this._queueBeingFlushed;

      if (!queue) {
        return;
      }

      for (i = 0, l = queue.length; i < l; i += 4) {
        currentTarget = queue[i];
        currentMethod = queue[i + 1];

        if (currentTarget === target && currentMethod === method) {
          // don't mess with array during flush
          // just nullify the method
          queue[i + 1] = null;
          return true;
        }
      }
    }
  };
})(Em._e[24],Em._e[21]);
(function (exports, _backburnerUtils, _backburnerQueue) {
  'use strict';

  exports.default = DeferredActionQueues;

  function DeferredActionQueues(queueNames, options) {
    var queues = this.queues = {};
    this.queueNames = queueNames = queueNames || [];

    this.options = options;

    _backburnerUtils.each(queueNames, function (queueName) {
      queues[queueName] = new _backburnerQueue.default(queueName, options[queueName], options);
    });
  }

  function noSuchQueue(name) {
    throw new Error('You attempted to schedule an action in a queue (' + name + ') that doesn\'t exist');
  }

  function noSuchMethod(name) {
    throw new Error('You attempted to schedule an action in a queue (' + name + ') for a method that doesn\'t exist');
  }

  DeferredActionQueues.prototype = {
    schedule: function (name, target, method, args, onceFlag, stack) {
      var queues = this.queues;
      var queue = queues[name];

      if (!queue) {
        noSuchQueue(name);
      }

      if (!method) {
        noSuchMethod(name);
      }

      if (onceFlag) {
        return queue.pushUnique(target, method, args, stack);
      } else {
        return queue.push(target, method, args, stack);
      }
    },

    flush: function () {
      var queues = this.queues;
      var queueNames = this.queueNames;
      var queueName, queue;
      var queueNameIndex = 0;
      var numberOfQueues = queueNames.length;

      while (queueNameIndex < numberOfQueues) {
        queueName = queueNames[queueNameIndex];
        queue = queues[queueName];

        var numberOfQueueItems = queue._queue.length;

        if (numberOfQueueItems === 0) {
          queueNameIndex++;
        } else {
          queue.flush(false /* async */);
          queueNameIndex = 0;
        }
      }
    }
  };
})(Em._e[25],Em._e[21],Em._e[24]);
(function (exports, _backburnerUtils, _backburnerPlatform, _backburnerBinarySearch, _backburnerDeferredActionQueues) {
  'use strict';

  exports.default = Backburner;

  function Backburner(queueNames, options) {
    this.queueNames = queueNames;
    this.options = options || {};
    if (!this.options.defaultQueue) {
      this.options.defaultQueue = queueNames[0];
    }
    this.instanceStack = [];
    this._debouncees = [];
    this._throttlers = [];
    this._eventCallbacks = {
      end: [],
      begin: []
    };

    var _this = this;
    this._boundClearItems = function () {
      clearItems();
    };

    this._timerTimeoutId = undefined;
    this._timers = [];

    this._platform = this.options._platform || _backburnerPlatform.default;

    this._boundRunExpiredTimers = function () {
      _this._runExpiredTimers();
    };
  }

  Backburner.prototype = {
    begin: function () {
      var options = this.options;
      var onBegin = options && options.onBegin;
      var previousInstance = this.currentInstance;

      if (previousInstance) {
        this.instanceStack.push(previousInstance);
      }

      this.currentInstance = new _backburnerDeferredActionQueues.default(this.queueNames, options);
      this._trigger('begin', this.currentInstance, previousInstance);
      if (onBegin) {
        onBegin(this.currentInstance, previousInstance);
      }
    },

    end: function () {
      var options = this.options;
      var onEnd = options && options.onEnd;
      var currentInstance = this.currentInstance;
      var nextInstance = null;

      // Prevent double-finally bug in Safari 6.0.2 and iOS 6
      // This bug appears to be resolved in Safari 6.0.5 and iOS 7
      var finallyAlreadyCalled = false;
      try {
        currentInstance.flush();
      } finally {
        if (!finallyAlreadyCalled) {
          finallyAlreadyCalled = true;

          this.currentInstance = null;

          if (this.instanceStack.length) {
            nextInstance = this.instanceStack.pop();
            this.currentInstance = nextInstance;
          }
          this._trigger('end', currentInstance, nextInstance);
          if (onEnd) {
            onEnd(currentInstance, nextInstance);
          }
        }
      }
    },

    /**
     Trigger an event. Supports up to two arguments. Designed around
     triggering transition events from one run loop instance to the
     next, which requires an argument for the first instance and then
     an argument for the next instance.
      @private
     @method _trigger
     @param {String} eventName
     @param {any} arg1
     @param {any} arg2
     */
    _trigger: function (eventName, arg1, arg2) {
      var callbacks = this._eventCallbacks[eventName];
      if (callbacks) {
        for (var i = 0; i < callbacks.length; i++) {
          callbacks[i](arg1, arg2);
        }
      }
    },

    on: function (eventName, callback) {
      if (typeof callback !== 'function') {
        throw new TypeError('Callback must be a function');
      }
      var callbacks = this._eventCallbacks[eventName];
      if (callbacks) {
        callbacks.push(callback);
      } else {
        throw new TypeError('Cannot on() event "' + eventName + '" because it does not exist');
      }
    },

    off: function (eventName, callback) {
      if (eventName) {
        var callbacks = this._eventCallbacks[eventName];
        var callbackFound = false;
        if (!callbacks) return;
        if (callback) {
          for (var i = 0; i < callbacks.length; i++) {
            if (callbacks[i] === callback) {
              callbackFound = true;
              callbacks.splice(i, 1);
              i--;
            }
          }
        }
        if (!callbackFound) {
          throw new TypeError('Cannot off() callback that does not exist');
        }
      } else {
        throw new TypeError('Cannot off() event "' + eventName + '" because it does not exist');
      }
    },

    run: function () /* target, method, args */{
      var length = arguments.length;
      var method, target, args;

      if (length === 1) {
        method = arguments[0];
        target = null;
      } else {
        target = arguments[0];
        method = arguments[1];
      }

      if (_backburnerUtils.isString(method)) {
        method = target[method];
      }

      if (length > 2) {
        args = new Array(length - 2);
        for (var i = 0, l = length - 2; i < l; i++) {
          args[i] = arguments[i + 2];
        }
      } else {
        args = [];
      }

      var onError = getOnError(this.options);

      this.begin();

      // guard against Safari 6's double-finally bug
      var didFinally = false;

      if (onError) {
        try {
          return method.apply(target, args);
        } catch (error) {
          onError(error);
        } finally {
          if (!didFinally) {
            didFinally = true;
            this.end();
          }
        }
      } else {
        try {
          return method.apply(target, args);
        } finally {
          if (!didFinally) {
            didFinally = true;
            this.end();
          }
        }
      }
    },

    /*
      Join the passed method with an existing queue and execute immediately,
      if there isn't one use `Backburner#run`.
       The join method is like the run method except that it will schedule into
      an existing queue if one already exists. In either case, the join method will
      immediately execute the passed in function and return its result.
       @method join
      @param {Object} target
      @param {Function} method The method to be executed
      @param {any} args The method arguments
      @return method result
    */
    join: function () /* target, method, args */{
      if (!this.currentInstance) {
        return this.run.apply(this, arguments);
      }

      var length = arguments.length;
      var method, target;

      if (length === 1) {
        method = arguments[0];
        target = null;
      } else {
        target = arguments[0];
        method = arguments[1];
      }

      if (_backburnerUtils.isString(method)) {
        method = target[method];
      }

      if (length === 1) {
        return method();
      } else if (length === 2) {
        return method.call(target);
      } else {
        var args = new Array(length - 2);
        for (var i = 0, l = length - 2; i < l; i++) {
          args[i] = arguments[i + 2];
        }
        return method.apply(target, args);
      }
    },

    /*
      Defer the passed function to run inside the specified queue.
       @method defer
      @param {String} queueName
      @param {Object} target
      @param {Function|String} method The method or method name to be executed
      @param {any} args The method arguments
      @return method result
    */
    defer: function (queueName /* , target, method, args */) {
      var length = arguments.length;
      var method, target, args;

      if (length === 2) {
        method = arguments[1];
        target = null;
      } else {
        target = arguments[1];
        method = arguments[2];
      }

      if (_backburnerUtils.isString(method)) {
        method = target[method];
      }

      var stack = this.DEBUG ? new Error() : undefined;

      if (length > 3) {
        args = new Array(length - 3);
        for (var i = 3; i < length; i++) {
          args[i - 3] = arguments[i];
        }
      } else {
        args = undefined;
      }

      if (!this.currentInstance) {
        createAutorun(this);
      }
      return this.currentInstance.schedule(queueName, target, method, args, false, stack);
    },

    deferOnce: function (queueName /* , target, method, args */) {
      var length = arguments.length;
      var method, target, args;

      if (length === 2) {
        method = arguments[1];
        target = null;
      } else {
        target = arguments[1];
        method = arguments[2];
      }

      if (_backburnerUtils.isString(method)) {
        method = target[method];
      }

      var stack = this.DEBUG ? new Error() : undefined;

      if (length > 3) {
        args = new Array(length - 3);
        for (var i = 3; i < length; i++) {
          args[i - 3] = arguments[i];
        }
      } else {
        args = undefined;
      }

      if (!this.currentInstance) {
        createAutorun(this);
      }
      return this.currentInstance.schedule(queueName, target, method, args, true, stack);
    },

    setTimeout: function () {
      var l = arguments.length;
      var args = new Array(l);

      for (var x = 0; x < l; x++) {
        args[x] = arguments[x];
      }

      var length = args.length,
          method,
          wait,
          target,
          methodOrTarget,
          methodOrWait,
          methodOrArgs;

      if (length === 0) {
        return;
      } else if (length === 1) {
        method = args.shift();
        wait = 0;
      } else if (length === 2) {
        methodOrTarget = args[0];
        methodOrWait = args[1];

        if (_backburnerUtils.isFunction(methodOrWait) || _backburnerUtils.isFunction(methodOrTarget[methodOrWait])) {
          target = args.shift();
          method = args.shift();
          wait = 0;
        } else if (_backburnerUtils.isCoercableNumber(methodOrWait)) {
          method = args.shift();
          wait = args.shift();
        } else {
          method = args.shift();
          wait = 0;
        }
      } else {
        var last = args[args.length - 1];

        if (_backburnerUtils.isCoercableNumber(last)) {
          wait = args.pop();
        } else {
          wait = 0;
        }

        methodOrTarget = args[0];
        methodOrArgs = args[1];

        if (_backburnerUtils.isFunction(methodOrArgs) || _backburnerUtils.isString(methodOrArgs) && methodOrTarget !== null && methodOrArgs in methodOrTarget) {
          target = args.shift();
          method = args.shift();
        } else {
          method = args.shift();
        }
      }

      var executeAt = Date.now() + parseInt(wait !== wait ? 0 : wait, 10);

      if (_backburnerUtils.isString(method)) {
        method = target[method];
      }

      var onError = getOnError(this.options);

      function fn() {
        if (onError) {
          try {
            method.apply(target, args);
          } catch (e) {
            onError(e);
          }
        } else {
          method.apply(target, args);
        }
      }

      return this._setTimeout(fn, executeAt);
    },

    _setTimeout: function (fn, executeAt) {
      if (this._timers.length === 0) {
        this._timers.push(executeAt, fn);
        this._installTimerTimeout();
        return fn;
      }

      // find position to insert
      var i = _backburnerBinarySearch.default(executeAt, this._timers);

      this._timers.splice(i, 0, executeAt, fn);

      // we should be the new earliest timer if i == 0
      if (i === 0) {
        this._reinstallTimerTimeout();
      }

      return fn;
    },

    throttle: function (target, method /* , args, wait, [immediate] */) {
      var backburner = this;
      var args = new Array(arguments.length);
      for (var i = 0; i < arguments.length; i++) {
        args[i] = arguments[i];
      }
      var immediate = args.pop();
      var wait, throttler, index, timer;

      if (_backburnerUtils.isNumber(immediate) || _backburnerUtils.isString(immediate)) {
        wait = immediate;
        immediate = true;
      } else {
        wait = args.pop();
      }

      wait = parseInt(wait, 10);

      index = findThrottler(target, method, this._throttlers);
      if (index > -1) {
        return this._throttlers[index];
      } // throttled

      timer = this._platform.setTimeout(function () {
        if (!immediate) {
          backburner.run.apply(backburner, args);
        }
        var index = findThrottler(target, method, backburner._throttlers);
        if (index > -1) {
          backburner._throttlers.splice(index, 1);
        }
      }, wait);

      if (immediate) {
        this.run.apply(this, args);
      }

      throttler = [target, method, timer];

      this._throttlers.push(throttler);

      return throttler;
    },

    debounce: function (target, method /* , args, wait, [immediate] */) {
      var backburner = this;
      var args = new Array(arguments.length);
      for (var i = 0; i < arguments.length; i++) {
        args[i] = arguments[i];
      }

      var immediate = args.pop();
      var wait, index, debouncee, timer;

      if (_backburnerUtils.isNumber(immediate) || _backburnerUtils.isString(immediate)) {
        wait = immediate;
        immediate = false;
      } else {
        wait = args.pop();
      }

      wait = parseInt(wait, 10);
      // Remove debouncee
      index = findDebouncee(target, method, this._debouncees);

      if (index > -1) {
        debouncee = this._debouncees[index];
        this._debouncees.splice(index, 1);
        this._platform.clearTimeout(debouncee[2]);
      }

      timer = this._platform.setTimeout(function () {
        if (!immediate) {
          backburner.run.apply(backburner, args);
        }
        var index = findDebouncee(target, method, backburner._debouncees);
        if (index > -1) {
          backburner._debouncees.splice(index, 1);
        }
      }, wait);

      if (immediate && index === -1) {
        backburner.run.apply(backburner, args);
      }

      debouncee = [target, method, timer];

      backburner._debouncees.push(debouncee);

      return debouncee;
    },

    cancelTimers: function () {
      _backburnerUtils.each(this._throttlers, this._boundClearItems);
      this._throttlers = [];

      _backburnerUtils.each(this._debouncees, this._boundClearItems);
      this._debouncees = [];

      this._clearTimerTimeout();
      this._timers = [];

      if (this._autorun) {
        this._platform.clearTimeout(this._autorun);
        this._autorun = null;
      }
    },

    hasTimers: function () {
      return !!this._timers.length || !!this._debouncees.length || !!this._throttlers.length || this._autorun;
    },

    cancel: function (timer) {
      var timerType = typeof timer;

      if (timer && timerType === 'object' && timer.queue && timer.method) {
        // we're cancelling a deferOnce
        return timer.queue.cancel(timer);
      } else if (timerType === 'function') {
        // we're cancelling a setTimeout
        for (var i = 0, l = this._timers.length; i < l; i += 2) {
          if (this._timers[i + 1] === timer) {
            this._timers.splice(i, 2); // remove the two elements
            if (i === 0) {
              this._reinstallTimerTimeout();
            }
            return true;
          }
        }
      } else if (Object.prototype.toString.call(timer) === '[object Array]') {
        // we're cancelling a throttle or debounce
        return this._cancelItem(findThrottler, this._throttlers, timer) || this._cancelItem(findDebouncee, this._debouncees, timer);
      } else {
        return; // timer was null or not a timer
      }
    },

    _cancelItem: function (findMethod, array, timer) {
      var item, index;

      if (timer.length < 3) {
        return false;
      }

      index = findMethod(timer[0], timer[1], array);

      if (index > -1) {

        item = array[index];

        if (item[2] === timer[2]) {
          array.splice(index, 1);
          this._platform.clearTimeout(timer[2]);
          return true;
        }
      }

      return false;
    },

    _runExpiredTimers: function () {
      this._timerTimeoutId = undefined;
      this.run(this, this._scheduleExpiredTimers);
    },

    _scheduleExpiredTimers: function () {
      var n = Date.now();
      var timers = this._timers;
      var i = 0;
      var l = timers.length;
      for (; i < l; i += 2) {
        var executeAt = timers[i];
        var fn = timers[i + 1];
        if (executeAt <= n) {
          this.schedule(this.options.defaultQueue, null, fn);
        } else {
          break;
        }
      }
      timers.splice(0, i);
      this._installTimerTimeout();
    },

    _reinstallTimerTimeout: function () {
      this._clearTimerTimeout();
      this._installTimerTimeout();
    },

    _clearTimerTimeout: function () {
      if (!this._timerTimeoutId) {
        return;
      }
      this._platform.clearTimeout(this._timerTimeoutId);
      this._timerTimeoutId = undefined;
    },

    _installTimerTimeout: function () {
      if (!this._timers.length) {
        return;
      }
      var minExpiresAt = this._timers[0];
      var n = Date.now();
      var wait = Math.max(0, minExpiresAt - n);
      this._timerTimeoutId = this._platform.setTimeout(this._boundRunExpiredTimers, wait);
    }
  };

  Backburner.prototype.schedule = Backburner.prototype.defer;
  Backburner.prototype.scheduleOnce = Backburner.prototype.deferOnce;
  Backburner.prototype.later = Backburner.prototype.setTimeout;

  function getOnError(options) {
    return options.onError || options.onErrorTarget && options.onErrorTarget[options.onErrorMethod];
  }

  function createAutorun(backburner) {
    backburner.begin();
    backburner._autorun = backburner._platform.setTimeout(function () {
      backburner._autorun = null;
      backburner.end();
    });
  }

  function findDebouncee(target, method, debouncees) {
    return findItem(target, method, debouncees);
  }

  function findThrottler(target, method, throttlers) {
    return findItem(target, method, throttlers);
  }

  function findItem(target, method, collection) {
    var item;
    var index = -1;

    for (var i = 0, l = collection.length; i < l; i++) {
      item = collection[i];
      if (item[0] === target && item[1] === method) {
        index = i;
        break;
      }
    }

    return index;
  }

  function clearItems(item) {
    this._platform.clearTimeout(item[2]);
  }
})(Em._e[26],Em._e[21],Em._e[22],Em._e[23],Em._e[25]);
(function (exports, _emberMetalDebug, _emberMetalTesting, _emberMetalError_handler, _emberMetalUtils, _emberMetalProperty_events, _backburner) {
  'use strict';

  exports.default = run;

  function onBegin(current) {
    run.currentRunLoop = current;
  }

  function onEnd(current, next) {
    run.currentRunLoop = next;
  }

  var onErrorTarget = {
    get onerror() {
      return _emberMetalError_handler.getOnerror();
    },
    set onerror(handler) {
      return _emberMetalError_handler.setOnerror(handler);
    }
  };

  var backburner = new _backburner.default(['sync', 'actions', 'destroy'], {
    GUID_KEY: _emberMetalUtils.GUID_KEY,
    sync: {
      before: _emberMetalProperty_events.beginPropertyChanges,
      after: _emberMetalProperty_events.endPropertyChanges
    },
    defaultQueue: 'actions',
    onBegin: onBegin,
    onEnd: onEnd,
    onErrorTarget: onErrorTarget,
    onErrorMethod: 'onerror'
  });

  // ..........................................................
  // run - this is ideally the only public API the dev sees
  //

  /**
    Runs the passed target and method inside of a RunLoop, ensuring any
    deferred actions including bindings and views updates are flushed at the
    end.
  
    Normally you should not need to invoke this method yourself. However if
    you are implementing raw event handlers when interfacing with other
    libraries or plugins, you should probably wrap all of your code inside this
    call.
  
    ```javascript
    run(function() {
      // code to be executed within a RunLoop
    });
    ```
  
    @class run
    @namespace Ember
    @static
    @constructor
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} return value from invoking the passed function.
    @public
  */

  function run() {
    return backburner.run.apply(backburner, arguments);
  }

  /**
    If no run-loop is present, it creates a new one. If a run loop is
    present it will queue itself to run on the existing run-loops action
    queue.
  
    Please note: This is not for normal usage, and should be used sparingly.
  
    If invoked when not within a run loop:
  
    ```javascript
    run.join(function() {
      // creates a new run-loop
    });
    ```
  
    Alternatively, if called within an existing run loop:
  
    ```javascript
    run(function() {
      // creates a new run-loop
      run.join(function() {
        // joins with the existing run-loop, and queues for invocation on
        // the existing run-loops action queue.
      });
    });
    ```
  
    @method join
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} Return value from invoking the passed function. Please note,
    when called within an existing loop, no return value is possible.
    @public
  */
  run.join = function () {
    return backburner.join.apply(backburner, arguments);
  };

  /**
    Allows you to specify which context to call the specified function in while
    adding the execution of that function to the Ember run loop. This ability
    makes this method a great way to asynchronously integrate third-party libraries
    into your Ember application.
  
    `run.bind` takes two main arguments, the desired context and the function to
    invoke in that context. Any additional arguments will be supplied as arguments
    to the function that is passed in.
  
    Let's use the creation of a TinyMCE component as an example. Currently,
    TinyMCE provides a setup configuration option we can use to do some processing
    after the TinyMCE instance is initialized but before it is actually rendered.
    We can use that setup option to do some additional setup for our component.
    The component itself could look something like the following:
  
    ```javascript
    App.RichTextEditorComponent = Ember.Component.extend({
      initializeTinyMCE: Ember.on('didInsertElement', function() {
        tinymce.init({
          selector: '#' + this.$().prop('id'),
          setup: Ember.run.bind(this, this.setupEditor)
        });
      }),
  
      setupEditor: function(editor) {
        this.set('editor', editor);
  
        editor.on('change', function() {
          console.log('content changed!');
        });
      }
    });
    ```
  
    In this example, we use Ember.run.bind to bind the setupEditor method to the
    context of the App.RichTextEditorComponent and to have the invocation of that
    method be safely handled and executed by the Ember run loop.
  
    @method bind
    @namespace Ember
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Function} returns a new function that will always have a particular context
    @since 1.4.0
    @public
  */
  run.bind = function () {
    for (var _len = arguments.length, curried = Array(_len), _key = 0; _key < _len; _key++) {
      curried[_key] = arguments[_key];
    }

    return function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return run.join.apply(run, curried.concat(args));
    };
  };

  run.backburner = backburner;
  run.currentRunLoop = null;
  run.queues = backburner.queueNames;

  /**
    Begins a new RunLoop. Any deferred actions invoked after the begin will
    be buffered until you invoke a matching call to `run.end()`. This is
    a lower-level way to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method begin
    @return {void}
    @public
  */
  run.begin = function () {
    backburner.begin();
  };

  /**
    Ends a RunLoop. This must be called sometime after you call
    `run.begin()` to flush any deferred actions. This is a lower-level way
    to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method end
    @return {void}
    @public
  */
  run.end = function () {
    backburner.end();
  };

  /**
    Array of named queues. This array determines the order in which queues
    are flushed at the end of the RunLoop. You can define your own queues by
    simply adding the queue name to this array. Normally you should not need
    to inspect or modify this property.
  
    @property queues
    @type Array
    @default ['sync', 'actions', 'destroy']
    @private
  */

  /**
    Adds the passed target/method and any optional arguments to the named
    queue to be executed at the end of the RunLoop. If you have not already
    started a RunLoop when calling this method one will be started for you
    automatically.
  
    At the end of a RunLoop, any methods scheduled in this way will be invoked.
    Methods will be invoked in an order matching the named queues defined in
    the `run.queues` property.
  
    ```javascript
    run.schedule('sync', this, function() {
      // this will be executed in the first RunLoop queue, when bindings are synced
      console.log('scheduled on sync queue');
    });
  
    run.schedule('actions', this, function() {
      // this will be executed in the 'actions' queue, after bindings have synced.
      console.log('scheduled on actions queue');
    });
  
    // Note the functions will be run in order based on the run queues order.
    // Output would be:
    //   scheduled on sync queue
    //   scheduled on actions queue
    ```
  
    @method schedule
    @param {String} queue The name of the queue to schedule against.
      Default queues are 'sync' and 'actions'
    @param {Object} [target] target object to use as the context when invoking a method.
    @param {String|Function} method The method to invoke. If you pass a string it
      will be resolved on the target object at the time the scheduled item is
      invoked allowing you to change the target function.
    @param {Object} [arguments*] Optional arguments to be passed to the queued method.
    @return {void}
    @public
  */
  run.schedule = function () /* queue, target, method */{
    backburner.schedule.apply(backburner, arguments);
  };

  // Used by global test teardown
  run.hasScheduledTimers = function () {
    return backburner.hasTimers();
  };

  // Used by global test teardown
  run.cancelTimers = function () {
    backburner.cancelTimers();
  };

  /**
    Immediately flushes any events scheduled in the 'sync' queue. Bindings
    use this queue so this method is a useful way to immediately force all
    bindings in the application to sync.
  
    You should call this method anytime you need any changed state to propagate
    throughout the app immediately without repainting the UI (which happens
    in the later 'render' queue added by the `ember-views` package).
  
    ```javascript
    run.sync();
    ```
  
    @method sync
    @return {void}
    @private
  */
  run.sync = function () {
    if (backburner.currentInstance) {
      backburner.currentInstance.queues.sync.flush();
    }
  };

  /**
    Invokes the passed target/method and optional arguments after a specified
    period of time. The last parameter of this method must always be a number
    of milliseconds.
  
    You should use this method whenever you need to run some action after a
    period of time instead of using `setTimeout()`. This method will ensure that
    items that expire during the same script execution cycle all execute
    together, which is often more efficient than using a real setTimeout.
  
    ```javascript
    run.later(myContext, function() {
      // code here will execute within a RunLoop in about 500ms with this == myContext
    }, 500);
    ```
  
    @method later
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @return {*} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.later = function () /*target, method*/{
    return backburner.later.apply(backburner, arguments);
  };

  /**
    Schedule a function to run one time during the current RunLoop. This is equivalent
    to calling `scheduleOnce` with the "actions" queue.
  
    @method once
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.once = function () {
    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    args.unshift('actions');
    return backburner.scheduleOnce.apply(backburner, args);
  };

  /**
    Schedules a function to run one time in a given queue of the current RunLoop.
    Calling this method with the same queue/target/method combination will have
    no effect (past the initial call).
  
    Note that although you can pass optional arguments these will not be
    considered when looking for duplicates. New arguments will replace previous
    calls.
  
    ```javascript
    function sayHi() {
      console.log('hi');
    }
  
    run(function() {
      run.scheduleOnce('afterRender', myContext, sayHi);
      run.scheduleOnce('afterRender', myContext, sayHi);
      // sayHi will only be executed once, in the afterRender queue of the RunLoop
    });
    ```
  
    Also note that passing an anonymous function to `run.scheduleOnce` will
    not prevent additional calls with an identical anonymous function from
    scheduling the items multiple times, e.g.:
  
    ```javascript
    function scheduleIt() {
      run.scheduleOnce('actions', myContext, function() {
        console.log('Closure');
      });
    }
  
    scheduleIt();
    scheduleIt();
  
    // "Closure" will print twice, even though we're using `run.scheduleOnce`,
    // because the function we pass to it is anonymous and won't match the
    // previously scheduled operation.
    ```
  
    Available queues, and their order, can be found at `run.queues`
  
    @method scheduleOnce
    @param {String} [queue] The name of the queue to schedule against. Default queues are 'sync' and 'actions'.
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.scheduleOnce = function () /*queue, target, method*/{
    return backburner.scheduleOnce.apply(backburner, arguments);
  };

  /**
    Schedules an item to run from within a separate run loop, after
    control has been returned to the system. This is equivalent to calling
    `run.later` with a wait time of 1ms.
  
    ```javascript
    run.next(myContext, function() {
      // code to be executed in the next run loop,
      // which will be scheduled after the current one
    });
    ```
  
    Multiple operations scheduled with `run.next` will coalesce
    into the same later run loop, along with any other operations
    scheduled by `run.later` that expire right around the same
    time that `run.next` operations will fire.
  
    Note that there are often alternatives to using `run.next`.
    For instance, if you'd like to schedule an operation to happen
    after all DOM element operations have completed within the current
    run loop, you can make use of the `afterRender` run loop queue (added
    by the `ember-views` package, along with the preceding `render` queue
    where all the DOM element operations happen).
  
    Example:
  
    ```javascript
    export default Ember.Component.extend({
      didInsertElement() {
        this._super(...arguments);
        run.scheduleOnce('afterRender', this, 'processChildElements');
      },
  
      processChildElements() {
        // ... do something with component's child component
        // elements after they've finished rendering, which
        // can't be done within this component's
        // `didInsertElement` hook because that gets run
        // before the child elements have been added to the DOM.
      }
    });
    ```
  
    One benefit of the above approach compared to using `run.next` is
    that you will be able to perform DOM/CSS operations before unprocessed
    elements are rendered to the screen, which may prevent flickering or
    other artifacts caused by delaying processing until after rendering.
  
    The other major benefit to the above approach is that `run.next`
    introduces an element of non-determinism, which can make things much
    harder to test, due to its reliance on `setTimeout`; it's much harder
    to guarantee the order of scheduled operations when they are scheduled
    outside of the current run loop, i.e. with `run.next`.
  
    @method next
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.next = function () {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    args.push(1);
    return backburner.later.apply(backburner, args);
  };

  /**
    Cancels a scheduled item. Must be a value returned by `run.later()`,
    `run.once()`, `run.scheduleOnce()`, `run.next()`, `run.debounce()`, or
    `run.throttle()`.
  
    ```javascript
    let runNext = run.next(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runNext);
  
    let runLater = run.later(myContext, function() {
      // will not be executed
    }, 500);
  
    run.cancel(runLater);
  
    let runScheduleOnce = run.scheduleOnce('afterRender', myContext, function() {
      // will not be executed
    });
  
    run.cancel(runScheduleOnce);
  
    let runOnce = run.once(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runOnce);
  
    let throttle = run.throttle(myContext, function() {
      // will not be executed
    }, 1, false);
  
    run.cancel(throttle);
  
    let debounce = run.debounce(myContext, function() {
      // will not be executed
    }, 1);
  
    run.cancel(debounce);
  
    let debounceImmediate = run.debounce(myContext, function() {
      // will be executed since we passed in true (immediate)
    }, 100, true);
  
    // the 100ms delay until this method can be called again will be cancelled
    run.cancel(debounceImmediate);
    ```
  
    @method cancel
    @param {Object} timer Timer object to cancel
    @return {Boolean} true if cancelled or false/undefined if it wasn't found
    @public
  */
  run.cancel = function (timer) {
    return backburner.cancel(timer);
  };

  /**
    Delay calling the target method until the debounce period has elapsed
    with no additional debounce calls. If `debounce` is called again before
    the specified time has elapsed, the timer is reset and the entire period
    must pass again before the target method is called.
  
    This method should be used when an event may be called multiple times
    but the action should only be called once when the event is done firing.
    A common example is for scroll events where you only want updates to
    happen once scrolling has ceased.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150);
  
    // less than 150ms passes
    run.debounce(myContext, whoRan, 150);
  
    // 150ms passes
    // whoRan is invoked with context myContext
    // console logs 'debounce ran.' one time.
    ```
  
    Immediate allows you to run the function immediately, but debounce
    other calls for this function until the wait time has elapsed. If
    `debounce` is called again before the specified time has elapsed,
    the timer is reset and the entire period must pass again before
    the method can be called again.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 100ms passes
    run.debounce(myContext, whoRan, 150, true);
  
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
  
    ```
  
    @method debounce
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to false.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.debounce = function () {
    return backburner.debounce.apply(backburner, arguments);
  };

  /**
    Ensure that the target method is never called more frequently than
    the specified spacing period. The target method is called immediately.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'throttle' };
  
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 150ms passes
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
    ```
  
    @method throttle
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} spacing Number of milliseconds to space out requests.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to true.
    @return {Array} Timer information for use in cancelling, see `run.cancel`.
    @public
  */
  run.throttle = function () {
    return backburner.throttle.apply(backburner, arguments);
  };

  /**
    Add a new named queue after the specified queue.
  
    The queue to add will only be added once.
  
    @method _addQueue
    @param {String} name the name of the queue to add.
    @param {String} after the name of the queue to add after.
    @private
  */
  run._addQueue = function (name, after) {
    if (run.queues.indexOf(name) === -1) {
      run.queues.splice(run.queues.indexOf(after) + 1, 0, name);
    }
  };
})(Em._e[27],Em._e[0],Em._e[1],Em._e[6],Em._e[7],Em._e[20],Em._e[26]);
(function (exports, _emberMetalEmpty_object) {
  'use strict';

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

  var Cache = (function () {
    function Cache(limit, func, key, store) {
      _classCallCheck(this, Cache);

      this.size = 0;
      this.misses = 0;
      this.hits = 0;
      this.limit = limit;
      this.func = func;
      this.key = key;
      this.store = store || new DefaultStore();
    }

    Cache.prototype.get = function get(obj) {
      var key = this.key === undefined ? obj : this.key(obj);
      var value = this.store.get(key);
      if (value === undefined) {
        this.misses++;
        value = this._set(key, this.func(obj));
      } else if (value === UNDEFINED) {
        this.hits++;
        value = undefined;
      } else {
        this.hits++;
        // nothing to translate
      }

      return value;
    };

    Cache.prototype.set = function set(obj, value) {
      var key = this.key === undefined ? obj : this.key(obj);
      return this._set(key, value);
    };

    Cache.prototype._set = function _set(key, value) {
      if (this.limit > this.size) {
        this.size++;
        if (value === undefined) {
          this.store.set(key, UNDEFINED);
        } else {
          this.store.set(key, value);
        }
      }

      return value;
    };

    Cache.prototype.purge = function purge() {
      this.store.clear();
      this.size = 0;
      this.hits = 0;
      this.misses = 0;
    };

    return Cache;
  })();

  exports.default = Cache;

  function UNDEFINED() {}

  var DefaultStore = (function () {
    function DefaultStore() {
      _classCallCheck(this, DefaultStore);

      this.data = new _emberMetalEmpty_object.default();
    }

    DefaultStore.prototype.get = function get(key) {
      return this.data[key];
    };

    DefaultStore.prototype.set = function set(key, value) {
      this.data[key] = value;
    };

    DefaultStore.prototype.clear = function clear() {
      this.data = new _emberMetalEmpty_object.default();
    };

    return DefaultStore;
  })();
})(Em._e[28],Em._e[12]);
(function (exports, _emberMetalCache) {
  'use strict';

  exports.isGlobal = isGlobal;
  exports.isGlobalPath = isGlobalPath;
  exports.hasThis = hasThis;
  exports.isPath = isPath;
  exports.getFirstKey = getFirstKey;
  exports.getTailPath = getTailPath;

  var IS_GLOBAL = /^[A-Z$]/;
  var IS_GLOBAL_PATH = /^[A-Z$].*[\.]/;
  var HAS_THIS = 'this.';

  var isGlobalCache = new _emberMetalCache.default(1000, function (key) {
    return IS_GLOBAL.test(key);
  });
  var isGlobalPathCache = new _emberMetalCache.default(1000, function (key) {
    return IS_GLOBAL_PATH.test(key);
  });
  var hasThisCache = new _emberMetalCache.default(1000, function (key) {
    return key.lastIndexOf(HAS_THIS, 0) === 0;
  });
  var firstDotIndexCache = new _emberMetalCache.default(1000, function (key) {
    return key.indexOf('.');
  });

  var firstKeyCache = new _emberMetalCache.default(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index === -1) {
      return path;
    } else {
      return path.slice(0, index);
    }
  });

  var tailPathCache = new _emberMetalCache.default(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    if (index !== -1) {
      return path.slice(index + 1);
    }
  });

  var caches = {
    isGlobalCache: isGlobalCache,
    isGlobalPathCache: isGlobalPathCache,
    hasThisCache: hasThisCache,
    firstDotIndexCache: firstDotIndexCache,
    firstKeyCache: firstKeyCache,
    tailPathCache: tailPathCache
  };

  exports.caches = caches;

  function isGlobal(path) {
    return isGlobalCache.get(path);
  }

  function isGlobalPath(path) {
    return isGlobalPathCache.get(path);
  }

  function hasThis(path) {
    return hasThisCache.get(path);
  }

  function isPath(path) {
    return firstDotIndexCache.get(path) !== -1;
  }

  function getFirstKey(path) {
    return firstKeyCache.get(path);
  }

  function getTailPath(path) {
    return tailPathCache.get(path);
  }
})(Em._e[29],Em._e[28]);
(function (exports, _emberMetalDebug, _emberMetalPath_cache) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.get = get;
  exports._getPath = _getPath;
  exports.getWithDefault = getWithDefault;

  var ALLOWABLE_TYPES = {
    object: true,
    function: true,
    string: true
  };

  // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.
  
    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)
  
    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.
  
    Note that if the object itself is `undefined`, this method will throw
    an error.
  
    @method get
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
    @public
  */

  function get(obj, keyName) {

    // Helpers that operate with 'this' within an #each
    if (keyName === '') {
      return obj;
    }

    var value = obj[keyName];
    var desc = value !== null && typeof value === 'object' && value.isDescriptor ? value : undefined;
    var ret = undefined;

    if (desc === undefined && _emberMetalPath_cache.isPath(keyName)) {
      return _getPath(obj, keyName);
    }

    if (desc) {
      return desc.get(obj, keyName);
    } else {
      ret = value;

      if (ret === undefined && 'object' === typeof obj && !(keyName in obj) && 'function' === typeof obj.unknownProperty) {
        return obj.unknownProperty(keyName);
      }

      return ret;
    }
  }

  function _getPath(root, path) {
    var obj = root;
    var parts = path.split('.');

    for (var i = 0; i < parts.length; i++) {
      if (!isGettable(obj)) {
        return undefined;
      }

      obj = get(obj, parts[i]);

      if (obj && obj.isDestroyed) {
        return undefined;
      }
    }

    return obj;
  }

  function isGettable(obj) {
    if (obj == null) {
      return false;
    }

    return ALLOWABLE_TYPES[typeof obj];
  }

  /**
    Retrieves the value of a property from an Object, or a default value in the
    case that the property returns `undefined`.
  
    ```javascript
    Ember.getWithDefault(person, 'lastName', 'Doe');
    ```
  
    @method getWithDefault
    @for Ember
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The name of the property to retrieve
    @param {Object} defaultValue The value to return if the property value is undefined
    @return {Object} The property value or the defaultValue.
    @public
  */

  function getWithDefault(root, key, defaultValue) {
    var value = get(root, key);

    if (value === undefined) {
      return defaultValue;
    }
    return value;
  }

  exports.default = get;
})(Em._e[30],Em._e[0],Em._e[29]);
(function (exports) {

  /**
    A subclass of the JavaScript Error object for use in Ember.
  
    @class Error
    @namespace Ember
    @extends Error
    @constructor
    @public
  */
  "use strict";

  exports.default = EmberError;

  function EmberError(message) {
    if (!(this instanceof EmberError)) {
      return new EmberError(message);
    }

    var error = Error.call(this, message);

    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, EmberError);
    } else {
      this.stack = error.stack;
    }

    this.description = error.description;
    this.fileName = error.fileName;
    this.lineNumber = error.lineNumber;
    this.message = error.message;
    this.name = error.name;
    this.number = error.number;
    this.code = error.code;
  }

  EmberError.prototype = Object.create(Error.prototype);
})(Em._e[31]);
(function (exports, _emberMetalDebug, _emberMetalFeatures, _emberMetalProperty_get, _emberMetalProperty_events, _emberMetalError, _emberMetalPath_cache, _emberMetalMeta, _emberMetalUtils) {
  'use strict';

  exports.set = set;
  exports.trySet = trySet;

  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change. If the
    property is not defined but the object implements the `setUnknownProperty`
    method then that will be invoked as well.
  
    @method set
    @for Ember
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
    @public
  */

  function set(obj, keyName, value, tolerant) {

    if (_emberMetalPath_cache.isPath(keyName)) {
      return setPath(obj, keyName, value, tolerant);
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    var possibleDesc = obj[keyName];

    var desc = undefined,
        currentValue = undefined;
    if (possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
    } else {
      currentValue = possibleDesc;
    }

    if (desc) {
      /* computed property */
      desc.set(obj, keyName, value);
    } else if (obj.setUnknownProperty && currentValue === undefined && !(keyName in obj)) {
      obj.setUnknownProperty(keyName, value);
      /* unknown property */
    } else if (currentValue === value) {
      /* no change */
      return value;
    } else {
      _emberMetalProperty_events.propertyWillChange(obj, keyName);

      if (false) {
        setWithMandatorySetter(meta, obj, keyName, value);
      } else {
        obj[keyName] = value;
      }

      _emberMetalProperty_events.propertyDidChange(obj, keyName);
    }

    return value;
  }

  if (false) {
    var setWithMandatorySetter = function (meta, obj, keyName, value) {
      if (meta && meta.peekWatching(keyName) > 0) {
        makeEnumerable(obj, keyName);
        meta.writeValue(obj, keyName, value);
      } else {
        obj[keyName] = value;
      }
    };

    var makeEnumerable = function (obj, key) {
      var desc = Object.getOwnPropertyDescriptor(obj, key);

      if (desc && desc.set && desc.set.isMandatorySetter) {
        desc.enumerable = true;
        Object.defineProperty(obj, key, desc);
      }
    };
  }

  function setPath(root, path, value, tolerant) {
    // get the last part of the path
    var keyName = path.slice(path.lastIndexOf('.') + 1);

    // get the first part of the part
    path = path === keyName ? keyName : path.slice(0, path.length - (keyName.length + 1));

    // unless the path is this, look up the first part to
    // get the root
    if (path !== 'this') {
      root = _emberMetalProperty_get._getPath(root, path);
    }

    if (!keyName || keyName.length === 0) {
      throw new _emberMetalError.default('Property set failed: You passed an empty path');
    }

    if (!root) {
      if (tolerant) {
        return;
      } else {
        throw new _emberMetalError.default('Property set failed: object in path "' + path + '" could not be found or was destroyed.');
      }
    }

    return set(root, keyName, value);
  }

  /**
    Error-tolerant form of `Ember.set`. Will not blow up if any part of the
    chain is `undefined`, `null`, or destroyed.
  
    This is primarily used when syncing bindings, which may try to update after
    an object has been destroyed.
  
    @method trySet
    @for Ember
    @param {Object} root The object to modify.
    @param {String} path The property path to set
    @param {Object} value The value to set
    @public
  */

  function trySet(root, path, value) {
    return set(root, path, value, true);
  }
})(Em._e[32],Em._e[0],Em._e[10],Em._e[30],Em._e[20],Em._e[31],Em._e[29],Em._e[14],Em._e[7]);
(function (exports, _emberMetalProperty_events, _emberMetalProperty_set) {
  'use strict';

  exports.default = setProperties;

  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.
  
    ```javascript
    let anObject = Ember.Object.create();
  
    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```
  
    @method setProperties
    @param obj
    @param {Object} properties
    @return properties
    @public
  */

  function setProperties(obj, properties) {
    if (!properties || typeof properties !== 'object') {
      return properties;
    }
    _emberMetalProperty_events.changeProperties(function () {
      var props = Object.keys(properties);
      var propertyName = undefined;

      for (var i = 0; i < props.length; i++) {
        propertyName = props[i];

        _emberMetalProperty_set.set(obj, propertyName, properties[propertyName]);
      }
    });
    return properties;
  }
})(Em._e[33],Em._e[20],Em._e[32]);
(function (exports) {
  /*globals console*/

  "use strict";

  exports.visitChildren = visitChildren;
  exports.validateChildMorphs = validateChildMorphs;
  exports.linkParams = linkParams;
  exports.dump = dump;

  function visitChildren(nodes, callback) {
    if (!nodes || nodes.length === 0) {
      return;
    }

    nodes = nodes.slice();

    while (nodes.length) {
      var node = nodes.pop();
      callback(node);

      if (node.childNodes) {
        nodes.push.apply(nodes, node.childNodes);
      } else if (node.firstChildMorph) {
        var current = node.firstChildMorph;

        while (current) {
          nodes.push(current);
          current = current.nextMorph;
        }
      } else if (node.morphList) {
        var current = node.morphList.firstChildMorph;

        while (current) {
          nodes.push(current);
          current = current.nextMorph;
        }
      }
    }
  }

  function validateChildMorphs(env, morph, visitor) {
    var morphList = morph.morphList;
    if (morph.morphList) {
      var current = morphList.firstChildMorph;

      while (current) {
        var next = current.nextMorph;
        validateChildMorphs(env, current, visitor);
        current = next;
      }
    } else if (morph.lastResult) {
      morph.lastResult.revalidateWith(env, undefined, undefined, undefined, visitor);
    } else if (morph.childNodes) {
      // This means that the childNodes were wired up manually
      for (var i = 0, l = morph.childNodes.length; i < l; i++) {
        validateChildMorphs(env, morph.childNodes[i], visitor);
      }
    }
  }

  function linkParams(env, scope, morph, path, params, hash) {
    if (morph.linkedParams) {
      return;
    }

    if (env.hooks.linkRenderNode(morph, env, scope, path, params, hash)) {
      morph.linkedParams = { params: params, hash: hash };
    }
  }

  function dump(node) {
    console.group(node, node.isDirty);

    if (node.childNodes) {
      map(node.childNodes, dump);
    } else if (node.firstChildMorph) {
      var current = node.firstChildMorph;

      while (current) {
        dump(current);
        current = current.nextMorph;
      }
    } else if (node.morphList) {
      dump(node.morphList);
    }

    console.groupEnd();
  }

  function map(nodes, cb) {
    for (var i = 0, l = nodes.length; i < l; i++) {
      cb(nodes[i]);
    }
  }
})(Em._e[34]);
(function (exports) {
  /**
    # Expression Nodes:
  
    These nodes are not directly responsible for any part of the DOM, but are
    eventually passed to a Statement Node.
  
    * get
    * subexpr
    * concat
  */

  'use strict';

  exports.acceptParams = acceptParams;
  exports.acceptHash = acceptHash;

  function acceptParams(nodes, env, scope) {
    var array = [];

    for (var i = 0, l = nodes.length; i < l; i++) {
      array.push(acceptExpression(nodes[i], env, scope).value);
    }

    return array;
  }

  function acceptHash(pairs, env, scope) {
    var object = {};

    for (var i = 0, l = pairs.length; i < l; i += 2) {
      var key = pairs[i];
      var value = pairs[i + 1];
      object[key] = acceptExpression(value, env, scope).value;
    }

    return object;
  }

  function acceptExpression(node, env, scope) {
    var ret = { value: null };

    // Primitive literals are unambiguously non-array representations of
    // themselves.
    if (Array.isArray(node)) {
      // if (node.length !== 7) { throw new Error('FIXME: Invalid statement length!'); }

      ret.value = evaluateNode(node, env, scope);
    } else {
      ret.value = node;
    }

    return ret;
  }

  function evaluateNode(node, env, scope) {
    switch (node[0]) {
      // can be used by manualElement
      case 'value':
        return node[1];
      case 'get':
        return evaluateGet(node, env, scope);
      case 'subexpr':
        return evaluateSubexpr(node, env, scope);
      case 'concat':
        return evaluateConcat(node, env, scope);
    }
  }

  function evaluateGet(node, env, scope) {
    var path = node[1];

    return env.hooks.get(env, scope, path);
  }

  function evaluateSubexpr(node, env, scope) {
    var path = node[1];
    var rawParams = node[2];
    var rawHash = node[3];

    var params = acceptParams(rawParams, env, scope);
    var hash = acceptHash(rawHash, env, scope);

    return env.hooks.subexpr(env, scope, path, params, hash);
  }

  function evaluateConcat(node, env, scope) {
    var rawParts = node[1];

    var parts = acceptParams(rawParts, env, scope);

    return env.hooks.concat(env, parts);
  }
})(Em._e[35]);
(function (exports, _htmlbarsUtilMorphUtils, _htmlbarsRuntimeExpressionVisitor) {
  "use strict";

  /**
    Node classification:
  
    # Primary Statement Nodes:
  
    These nodes are responsible for a render node that represents a morph-range.
  
    * block
    * inline
    * content
    * element
    * component
  
    # Leaf Statement Nodes:
  
    This node is responsible for a render node that represents a morph-attr.
  
    * attribute
  */

  function linkParamsAndHash(env, scope, morph, path, params, hash) {
    if (morph.linkedParams) {
      params = morph.linkedParams.params;
      hash = morph.linkedParams.hash;
    } else {
      params = params && _htmlbarsRuntimeExpressionVisitor.acceptParams(params, env, scope);
      hash = hash && _htmlbarsRuntimeExpressionVisitor.acceptHash(hash, env, scope);
    }

    _htmlbarsUtilMorphUtils.linkParams(env, scope, morph, path, params, hash);
    return [params, hash];
  }

  var AlwaysDirtyVisitor = {

    block: function (node, morph, env, scope, template, visitor) {
      var path = node[1];
      var params = node[2];
      var hash = node[3];
      var templateId = node[4];
      var inverseId = node[5];

      var paramsAndHash = linkParamsAndHash(env, scope, morph, path, params, hash);

      morph.isDirty = morph.isSubtreeDirty = false;
      env.hooks.block(morph, env, scope, path, paramsAndHash[0], paramsAndHash[1], templateId === null ? null : template.templates[templateId], inverseId === null ? null : template.templates[inverseId], visitor);
    },

    inline: function (node, morph, env, scope, visitor) {
      var path = node[1];
      var params = node[2];
      var hash = node[3];

      var paramsAndHash = linkParamsAndHash(env, scope, morph, path, params, hash);

      morph.isDirty = morph.isSubtreeDirty = false;
      env.hooks.inline(morph, env, scope, path, paramsAndHash[0], paramsAndHash[1], visitor);
    },

    content: function (node, morph, env, scope, visitor) {
      var path = node[1];

      morph.isDirty = morph.isSubtreeDirty = false;

      if (isHelper(env, scope, path)) {
        env.hooks.inline(morph, env, scope, path, [], {}, visitor);
        if (morph.linkedResult) {
          _htmlbarsUtilMorphUtils.linkParams(env, scope, morph, '@content-helper', [morph.linkedResult], null);
        }
        return;
      }

      var params = undefined;
      if (morph.linkedParams) {
        params = morph.linkedParams.params;
      } else {
        params = [env.hooks.get(env, scope, path)];
      }

      _htmlbarsUtilMorphUtils.linkParams(env, scope, morph, '@range', params, null);
      env.hooks.range(morph, env, scope, path, params[0], visitor);
    },

    element: function (node, morph, env, scope, visitor) {
      var path = node[1];
      var params = node[2];
      var hash = node[3];

      var paramsAndHash = linkParamsAndHash(env, scope, morph, path, params, hash);

      morph.isDirty = morph.isSubtreeDirty = false;
      env.hooks.element(morph, env, scope, path, paramsAndHash[0], paramsAndHash[1], visitor);
    },

    attribute: function (node, morph, env, scope) {
      var name = node[1];
      var value = node[2];

      var paramsAndHash = linkParamsAndHash(env, scope, morph, '@attribute', [value], null);

      morph.isDirty = morph.isSubtreeDirty = false;
      env.hooks.attribute(morph, env, scope, name, paramsAndHash[0][0]);
    },

    component: function (node, morph, env, scope, template, visitor) {
      var path = node[1];
      var attrs = node[2];
      var templateId = node[3];
      var inverseId = node[4];

      var paramsAndHash = linkParamsAndHash(env, scope, morph, path, [], attrs);
      var templates = {
        default: template.templates[templateId],
        inverse: template.templates[inverseId]
      };

      morph.isDirty = morph.isSubtreeDirty = false;
      env.hooks.component(morph, env, scope, path, paramsAndHash[0], paramsAndHash[1], templates, visitor);
    },

    attributes: function (node, morph, env, scope, parentMorph, visitor) {
      var template = node[1];

      env.hooks.attributes(morph, env, scope, template, parentMorph, visitor);
    }

  };

  exports.AlwaysDirtyVisitor = AlwaysDirtyVisitor;
  exports.default = {
    block: function (node, morph, env, scope, template, visitor) {
      dirtyCheck(env, morph, visitor, function (visitor) {
        AlwaysDirtyVisitor.block(node, morph, env, scope, template, visitor);
      });
    },

    inline: function (node, morph, env, scope, visitor) {
      dirtyCheck(env, morph, visitor, function (visitor) {
        AlwaysDirtyVisitor.inline(node, morph, env, scope, visitor);
      });
    },

    content: function (node, morph, env, scope, visitor) {
      dirtyCheck(env, morph, visitor, function (visitor) {
        AlwaysDirtyVisitor.content(node, morph, env, scope, visitor);
      });
    },

    element: function (node, morph, env, scope, template, visitor) {
      dirtyCheck(env, morph, visitor, function (visitor) {
        AlwaysDirtyVisitor.element(node, morph, env, scope, template, visitor);
      });
    },

    attribute: function (node, morph, env, scope, template) {
      dirtyCheck(env, morph, null, function () {
        AlwaysDirtyVisitor.attribute(node, morph, env, scope, template);
      });
    },

    component: function (node, morph, env, scope, template, visitor) {
      dirtyCheck(env, morph, visitor, function (visitor) {
        AlwaysDirtyVisitor.component(node, morph, env, scope, template, visitor);
      });
    },

    attributes: function (node, morph, env, scope, parentMorph, visitor) {
      AlwaysDirtyVisitor.attributes(node, morph, env, scope, parentMorph, visitor);
    }
  };

  function dirtyCheck(_env, morph, visitor, callback) {
    var isDirty = morph.isDirty;
    var isSubtreeDirty = morph.isSubtreeDirty;
    var env = _env;

    if (isSubtreeDirty) {
      visitor = AlwaysDirtyVisitor;
    }

    if (isDirty || isSubtreeDirty) {
      callback(visitor);
    } else {
      if (morph.buildChildEnv) {
        env = morph.buildChildEnv(morph.getState(), env);
      }
      _htmlbarsUtilMorphUtils.validateChildMorphs(env, morph, visitor);
    }
  }

  function isHelper(env, scope, path) {
    return env.hooks.keywords[path] !== undefined || env.hooks.hasHelper(env, scope, path);
  }
})(Em._e[36],Em._e[34],Em._e[35]);
(function (exports) {
  // inclusive of both nodes
  "use strict";

  exports.clear = clear;
  exports.insertBefore = insertBefore;

  function clear(parentNode, firstNode, lastNode) {
    if (!parentNode) {
      return;
    }

    var node = firstNode;
    var nextNode;
    do {
      nextNode = node.nextSibling;
      parentNode.removeChild(node);
      if (node === lastNode) {
        break;
      }
      node = nextNode;
    } while (node);
  }

  function insertBefore(parentNode, firstNode, lastNode, refNode) {
    var node = firstNode;
    var nextNode;
    do {
      nextNode = node.nextSibling;
      parentNode.insertBefore(node, refNode);
      if (node === lastNode) {
        break;
      }
      node = nextNode;
    } while (node);
  }
})(Em._e[37]);
(function (exports, _morphRangeUtils) {
  'use strict';

  // constructor just initializes the fields
  // use one of the static initializers to create a valid morph.
  function Morph(domHelper, contextualElement) {
    this.domHelper = domHelper;
    // context if content if current content is detached
    this.contextualElement = contextualElement;
    // inclusive range of morph
    // these should be nodeType 1, 3, or 8
    this.firstNode = null;
    this.lastNode = null;

    // flag to force text to setContent to be treated as html
    this.parseTextAsHTML = false;

    // morph list graph
    this.parentMorphList = null;
    this.previousMorph = null;
    this.nextMorph = null;
  }

  Morph.empty = function (domHelper, contextualElement) {
    var morph = new Morph(domHelper, contextualElement);
    morph.clear();
    return morph;
  };

  Morph.create = function (domHelper, contextualElement, node) {
    var morph = new Morph(domHelper, contextualElement);
    morph.setNode(node);
    return morph;
  };

  Morph.attach = function (domHelper, contextualElement, firstNode, lastNode) {
    var morph = new Morph(domHelper, contextualElement);
    morph.setRange(firstNode, lastNode);
    return morph;
  };

  Morph.prototype.setContent = function Morph$setContent(content) {
    if (content === null || content === undefined) {
      return this.clear();
    }

    var type = typeof content;
    switch (type) {
      case 'string':
        if (this.parseTextAsHTML) {
          return this.domHelper.setMorphHTML(this, content);
        }
        return this.setText(content);
      case 'object':
        if (typeof content.nodeType === 'number') {
          return this.setNode(content);
        }
        /* Handlebars.SafeString */
        if (typeof content.toHTML === 'function') {
          return this.setHTML(content.toHTML());
        }
        if (this.parseTextAsHTML) {
          return this.setHTML(content.toString());
        }
      /* falls through */
      case 'boolean':
      case 'number':
        return this.setText(content.toString());
      case 'function':
        raiseCannotBindToFunction(content);
      default:
        throw new TypeError('unsupported content');
    }
  };

  function raiseCannotBindToFunction(content) {
    var functionName = content.name;
    var message;

    if (functionName) {
      message = 'Unsupported Content: Cannot bind to function `' + functionName + '`';
    } else {
      message = 'Unsupported Content: Cannot bind to function';
    }

    throw new TypeError(message);
  }

  Morph.prototype.clear = function Morph$clear() {
    var node = this.setNode(this.domHelper.createComment(''));
    return node;
  };

  Morph.prototype.setText = function Morph$setText(text) {
    var firstNode = this.firstNode;
    var lastNode = this.lastNode;

    if (firstNode && lastNode === firstNode && firstNode.nodeType === 3) {
      firstNode.nodeValue = text;
      return firstNode;
    }

    return this.setNode(text ? this.domHelper.createTextNode(text) : this.domHelper.createComment(''));
  };

  Morph.prototype.setNode = function Morph$setNode(newNode) {
    var firstNode, lastNode;
    switch (newNode.nodeType) {
      case 3:
        firstNode = newNode;
        lastNode = newNode;
        break;
      case 11:
        firstNode = newNode.firstChild;
        lastNode = newNode.lastChild;
        if (firstNode === null) {
          firstNode = this.domHelper.createComment('');
          newNode.appendChild(firstNode);
          lastNode = firstNode;
        }
        break;
      default:
        firstNode = newNode;
        lastNode = newNode;
        break;
    }

    this.setRange(firstNode, lastNode);

    return newNode;
  };

  Morph.prototype.setRange = function (firstNode, lastNode) {
    var previousFirstNode = this.firstNode;
    if (previousFirstNode !== null) {

      var parentNode = previousFirstNode.parentNode;
      if (parentNode !== null) {
        _morphRangeUtils.insertBefore(parentNode, firstNode, lastNode, previousFirstNode);
        _morphRangeUtils.clear(parentNode, previousFirstNode, this.lastNode);
      }
    }

    this.firstNode = firstNode;
    this.lastNode = lastNode;

    if (this.parentMorphList) {
      this._syncFirstNode();
      this._syncLastNode();
    }
  };

  Morph.prototype.destroy = function Morph$destroy() {
    this.unlink();

    var firstNode = this.firstNode;
    var lastNode = this.lastNode;
    var parentNode = firstNode && firstNode.parentNode;

    this.firstNode = null;
    this.lastNode = null;

    _morphRangeUtils.clear(parentNode, firstNode, lastNode);
  };

  Morph.prototype.unlink = function Morph$unlink() {
    var parentMorphList = this.parentMorphList;
    var previousMorph = this.previousMorph;
    var nextMorph = this.nextMorph;

    if (previousMorph) {
      if (nextMorph) {
        previousMorph.nextMorph = nextMorph;
        nextMorph.previousMorph = previousMorph;
      } else {
        previousMorph.nextMorph = null;
        parentMorphList.lastChildMorph = previousMorph;
      }
    } else {
      if (nextMorph) {
        nextMorph.previousMorph = null;
        parentMorphList.firstChildMorph = nextMorph;
      } else if (parentMorphList) {
        parentMorphList.lastChildMorph = parentMorphList.firstChildMorph = null;
      }
    }

    this.parentMorphList = null;
    this.nextMorph = null;
    this.previousMorph = null;

    if (parentMorphList && parentMorphList.mountedMorph) {
      if (!parentMorphList.firstChildMorph) {
        // list is empty
        parentMorphList.mountedMorph.clear();
        return;
      } else {
        parentMorphList.firstChildMorph._syncFirstNode();
        parentMorphList.lastChildMorph._syncLastNode();
      }
    }
  };

  Morph.prototype.setHTML = function (text) {
    var fragment = this.domHelper.parseHTML(text, this.contextualElement);
    return this.setNode(fragment);
  };

  Morph.prototype.setMorphList = function Morph$appendMorphList(morphList) {
    morphList.mountedMorph = this;
    this.clear();

    var originalFirstNode = this.firstNode;

    if (morphList.firstChildMorph) {
      this.firstNode = morphList.firstChildMorph.firstNode;
      this.lastNode = morphList.lastChildMorph.lastNode;

      var current = morphList.firstChildMorph;

      while (current) {
        var next = current.nextMorph;
        current.insertBeforeNode(originalFirstNode, null);
        current = next;
      }
      originalFirstNode.parentNode.removeChild(originalFirstNode);
    }
  };

  Morph.prototype._syncFirstNode = function Morph$syncFirstNode() {
    var morph = this;
    var parentMorphList;
    while (parentMorphList = morph.parentMorphList) {
      if (parentMorphList.mountedMorph === null) {
        break;
      }
      if (morph !== parentMorphList.firstChildMorph) {
        break;
      }
      if (morph.firstNode === parentMorphList.mountedMorph.firstNode) {
        break;
      }

      parentMorphList.mountedMorph.firstNode = morph.firstNode;

      morph = parentMorphList.mountedMorph;
    }
  };

  Morph.prototype._syncLastNode = function Morph$syncLastNode() {
    var morph = this;
    var parentMorphList;
    while (parentMorphList = morph.parentMorphList) {
      if (parentMorphList.mountedMorph === null) {
        break;
      }
      if (morph !== parentMorphList.lastChildMorph) {
        break;
      }
      if (morph.lastNode === parentMorphList.mountedMorph.lastNode) {
        break;
      }

      parentMorphList.mountedMorph.lastNode = morph.lastNode;

      morph = parentMorphList.mountedMorph;
    }
  };

  Morph.prototype.insertBeforeNode = function Morph$insertBeforeNode(parentNode, refNode) {
    _morphRangeUtils.insertBefore(parentNode, this.firstNode, this.lastNode, refNode);
  };

  Morph.prototype.appendToNode = function Morph$appendToNode(parentNode) {
    _morphRangeUtils.insertBefore(parentNode, this.firstNode, this.lastNode, null);
  };

  exports.default = Morph;
})(Em._e[38],Em._e[37]);
(function (exports, _morphRange) {
  "use strict";

  var guid = 1;

  function HTMLBarsMorph(domHelper, contextualElement) {
    this.super$constructor(domHelper, contextualElement);

    this._state = undefined;
    this.ownerNode = null;
    this.isDirty = false;
    this.isSubtreeDirty = false;
    this.lastYielded = null;
    this.lastResult = null;
    this.lastValue = null;
    this.buildChildEnv = null;
    this.morphList = null;
    this.morphMap = null;
    this.key = null;
    this.linkedParams = null;
    this.linkedResult = null;
    this.childNodes = null;
    this.rendered = false;
    this.guid = "range" + guid++;
    this.seen = false;
  }

  HTMLBarsMorph.empty = function (domHelper, contextualElement) {
    var morph = new HTMLBarsMorph(domHelper, contextualElement);
    morph.clear();
    return morph;
  };

  HTMLBarsMorph.create = function (domHelper, contextualElement, node) {
    var morph = new HTMLBarsMorph(domHelper, contextualElement);
    morph.setNode(node);
    return morph;
  };

  HTMLBarsMorph.attach = function (domHelper, contextualElement, firstNode, lastNode) {
    var morph = new HTMLBarsMorph(domHelper, contextualElement);
    morph.setRange(firstNode, lastNode);
    return morph;
  };

  var prototype = HTMLBarsMorph.prototype = Object.create(_morphRange.default.prototype);
  prototype.constructor = HTMLBarsMorph;
  prototype.super$constructor = _morphRange.default;

  prototype.getState = function () {
    if (!this._state) {
      this._state = {};
    }

    return this._state;
  };

  prototype.setState = function (newState) {
    /*jshint -W093 */

    return this._state = newState;
  };

  exports.default = HTMLBarsMorph;
})(Em._e[39],Em._e[38]);
(function (exports, _htmlbarsUtilMorphUtils, _htmlbarsRuntimeRender) {
  "use strict";

  var _slice = Array.prototype.slice;
  exports.RenderState = RenderState;
  exports.blockFor = blockFor;
  exports.renderAndCleanup = renderAndCleanup;
  exports.clearMorph = clearMorph;
  exports.clearMorphList = clearMorphList;
  exports.buildStatement = buildStatement;

  function RenderState(renderNode, morphList) {
    // The morph list that is no longer needed and can be
    // destroyed.
    this.morphListToClear = morphList;

    // The morph list that needs to be pruned of any items
    // that were not yielded on a subsequent render.
    this.morphListToPrune = null;

    // A map of morphs for each item yielded in during this
    // rendering pass. Any morphs in the DOM but not in this map
    // will be pruned during cleanup.
    this.handledMorphs = {};
    this.collisions = undefined;

    // The morph to clear once rendering is complete. By
    // default, we set this to the previous morph (to catch
    // the case where nothing is yielded; in that case, we
    // should just clear the morph). Otherwise this gets set
    // to null if anything is rendered.
    this.morphToClear = renderNode;

    this.shadowOptions = null;
  }

  function Block(render, template, blockOptions) {
    this.render = render;
    this.template = template;
    this.blockOptions = blockOptions;
    this.arity = template.arity;
  }

  Block.prototype.invoke = function (env, blockArguments, _self, renderNode, parentScope, visitor) {
    if (renderNode.lastResult) {
      renderNode.lastResult.revalidateWith(env, undefined, _self, blockArguments, visitor);
    } else {
      this._firstRender(env, blockArguments, _self, renderNode, parentScope);
    }
  };

  Block.prototype._firstRender = function (env, blockArguments, _self, renderNode, parentScope) {
    var options = { renderState: new RenderState(renderNode) };
    var render = this.render;
    var template = this.template;
    var scope = this.blockOptions.scope;

    var shadowScope = scope ? env.hooks.createChildScope(scope) : env.hooks.createFreshScope();

    env.hooks.bindShadowScope(env, parentScope, shadowScope, this.blockOptions.options);

    if (_self !== undefined) {
      env.hooks.bindSelf(env, shadowScope, _self);
    } else if (this.blockOptions.self !== undefined) {
      env.hooks.bindSelf(env, shadowScope, this.blockOptions.self);
    }

    bindBlocks(env, shadowScope, this.blockOptions.yieldTo);

    renderAndCleanup(renderNode, env, options, null, function () {
      options.renderState.morphToClear = null;
      var renderOptions = new _htmlbarsRuntimeRender.RenderOptions(renderNode, undefined, blockArguments);
      render(template, env, shadowScope, renderOptions);
    });
  };

  function blockFor(render, template, blockOptions) {
    return new Block(render, template, blockOptions);
  }

  function bindBlocks(env, shadowScope, blocks) {
    if (!blocks) {
      return;
    }
    if (blocks instanceof Block) {
      env.hooks.bindBlock(env, shadowScope, blocks);
    } else {
      for (var name in blocks) {
        if (blocks.hasOwnProperty(name)) {
          env.hooks.bindBlock(env, shadowScope, blocks[name], name);
        }
      }
    }
  }

  function renderAndCleanup(morph, env, options, shadowOptions, callback) {
    // The RenderState object is used to collect information about what the
    // helper or hook being invoked has yielded. Once it has finished either
    // yielding multiple items (via yieldItem) or a single template (via
    // yieldTemplate), we detect what was rendered and how it differs from
    // the previous render, cleaning up old state in DOM as appropriate.
    var renderState = options.renderState;
    renderState.collisions = undefined;
    renderState.shadowOptions = shadowOptions;

    // Invoke the callback, instructing it to save information about what it
    // renders into RenderState.
    var result = callback(options);

    // The hook can opt-out of cleanup if it handled cleanup itself.
    if (result && result.handled) {
      return;
    }

    var morphMap = morph.morphMap;

    // Walk the morph list, clearing any items that were yielded in a previous
    // render but were not yielded during this render.
    var morphList = renderState.morphListToPrune;
    if (morphList) {
      var handledMorphs = renderState.handledMorphs;
      var item = morphList.firstChildMorph;

      while (item) {
        var next = item.nextMorph;

        // If we don't see the key in handledMorphs, it wasn't
        // yielded in and we can safely remove it from DOM.
        if (!(item.key in handledMorphs)) {
          morphMap[item.key] = undefined;
          clearMorph(item, env, true);
          item.destroy();
        }

        item = next;
      }
    }

    morphList = renderState.morphListToClear;
    if (morphList) {
      clearMorphList(morphList, morph, env);
    }

    var toClear = renderState.morphToClear;
    if (toClear) {
      clearMorph(toClear, env);
    }
  }

  function clearMorph(morph, env, destroySelf) {
    var cleanup = env.hooks.cleanupRenderNode;
    var destroy = env.hooks.destroyRenderNode;
    var willCleanup = env.hooks.willCleanupTree;
    var didCleanup = env.hooks.didCleanupTree;

    function destroyNode(node) {
      if (cleanup) {
        cleanup(node);
      }
      if (destroy) {
        destroy(node);
      }
    }

    if (willCleanup) {
      willCleanup(env, morph, destroySelf);
    }
    if (cleanup) {
      cleanup(morph);
    }
    if (destroySelf && destroy) {
      destroy(morph);
    }

    _htmlbarsUtilMorphUtils.visitChildren(morph.childNodes, destroyNode);

    // TODO: Deal with logical children that are not in the DOM tree
    morph.clear();
    if (didCleanup) {
      didCleanup(env, morph, destroySelf);
    }

    morph.lastResult = null;
    morph.lastYielded = null;
    morph.childNodes = null;
  }

  function clearMorphList(morphList, morph, env) {
    var item = morphList.firstChildMorph;

    while (item) {
      var next = item.nextMorph;
      morph.morphMap[item.key] = undefined;
      clearMorph(item, env, true);
      item.destroy();

      item = next;
    }

    // Remove the MorphList from the morph.
    morphList.clear();
    morph.morphList = null;
  }

  function buildStatement() {
    var statement = [].concat(_slice.call(arguments));

    // ensure array length is 7 by padding with 0
    for (var i = arguments.length; i < 7; i++) {
      statement[i] = 0;
    }

    return statement;
  }
})(Em._e[40],Em._e[34],Em._e[43]);
(function (exports) {
  'use strict';

  exports.forEach = forEach;
  exports.map = map;

  function forEach(array, callback, binding) {
    var i, l;
    if (binding === undefined) {
      for (i = 0, l = array.length; i < l; i++) {
        callback(array[i], i, array);
      }
    } else {
      for (i = 0, l = array.length; i < l; i++) {
        callback.call(binding, array[i], i, array);
      }
    }
  }

  function map(array, callback) {
    var output = [];
    var i, l;

    for (i = 0, l = array.length; i < l; i++) {
      output.push(callback(array[i], i, array));
    }

    return output;
  }

  var getIdx;
  if (Array.prototype.indexOf) {
    getIdx = function (array, obj, from) {
      return array.indexOf(obj, from);
    };
  } else {
    getIdx = function (array, obj, from) {
      if (from === undefined || from === null) {
        from = 0;
      } else if (from < 0) {
        from = Math.max(0, array.length + from);
      }
      for (var i = from, l = array.length; i < l; i++) {
        if (array[i] === obj) {
          return i;
        }
      }
      return -1;
    };
  }

  var isArray = Array.isArray || function (array) {
    return Object.prototype.toString.call(array) === '[object Array]';
  };

  exports.isArray = isArray;
  var indexOfArray = getIdx;
  exports.indexOfArray = indexOfArray;
})(Em._e[41]);
(function (exports, _htmlbarsUtilArrayUtils) {
  "use strict";

  // The HTML elements in this list are speced by
  // http://www.w3.org/TR/html-markup/syntax.html#syntax-elements,
  // and will be forced to close regardless of if they have a
  // self-closing /> at the end.
  var voidTagNames = "area base br col command embed hr img input keygen link meta param source track wbr";
  var voidMap = {};

  _htmlbarsUtilArrayUtils.forEach(voidTagNames.split(" "), function (tagName) {
    voidMap[tagName] = true;
  });

  exports.default = voidMap;
})(Em._e[42],Em._e[41]);
(function (exports, _htmlbarsUtilMorphUtils, _htmlbarsRuntimeNodeVisitor, _htmlbarsRuntimeMorph, _htmlbarsUtilTemplateUtils, _htmlbarsUtilVoidTagNames) {
  "use strict";

  exports.default = render;
  exports.RenderOptions = RenderOptions;
  exports.manualElement = manualElement;
  exports.attachAttributes = attachAttributes;
  exports.createChildMorph = createChildMorph;
  exports.getCachedFragment = getCachedFragment;

  var svgNamespace = "http://www.w3.org/2000/svg";

  function render(template, env, scope, options) {
    var dom = env.dom;
    var contextualElement;

    if (options) {
      if (options.renderNode) {
        contextualElement = options.renderNode.contextualElement;
      } else if (options.contextualElement) {
        contextualElement = options.contextualElement;
      }
    }

    dom.detectNamespace(contextualElement);

    var renderResult = RenderResult.build(env, scope, template, options, contextualElement);
    renderResult.render();

    return renderResult;
  }

  function RenderOptions(renderNode, self, blockArguments, contextualElement) {
    this.renderNode = renderNode || null;
    this.self = self;
    this.blockArguments = blockArguments || null;
    this.contextualElement = contextualElement || null;
  }

  function RenderResult(env, scope, options, rootNode, ownerNode, nodes, fragment, template, shouldSetContent) {
    this.root = rootNode;
    this.fragment = fragment;

    this.nodes = nodes;
    this.template = template;
    this.statements = template.statements.slice();
    this.env = env;
    this.scope = scope;
    this.shouldSetContent = shouldSetContent;

    if (options.self !== undefined) {
      this.bindSelf(options.self);
    }
    if (options.blockArguments !== undefined) {
      this.bindLocals(options.blockArguments);
    }

    this.initializeNodes(ownerNode);
  }

  RenderResult.build = function (env, scope, template, options, contextualElement) {
    var dom = env.dom;
    var fragment = getCachedFragment(template, env);
    var nodes = template.buildRenderNodes(dom, fragment, contextualElement);

    var rootNode, ownerNode, shouldSetContent;

    if (options && options.renderNode) {
      rootNode = options.renderNode;
      ownerNode = rootNode.ownerNode;
      shouldSetContent = true;
    } else {
      rootNode = dom.createMorph(null, fragment.firstChild, fragment.lastChild, contextualElement);
      ownerNode = rootNode;
      rootNode.ownerNode = ownerNode;
      shouldSetContent = false;
    }

    if (rootNode.childNodes) {
      _htmlbarsUtilMorphUtils.visitChildren(rootNode.childNodes, function (node) {
        _htmlbarsUtilTemplateUtils.clearMorph(node, env, true);
      });
    }

    rootNode.childNodes = nodes;
    return new RenderResult(env, scope, options, rootNode, ownerNode, nodes, fragment, template, shouldSetContent);
  };

  function manualElement(tagName, attributes, _isEmpty) {
    var statements = [];

    for (var key in attributes) {
      if (typeof attributes[key] === 'string') {
        continue;
      }

      statements.push(_htmlbarsUtilTemplateUtils.buildStatement("attribute", key, attributes[key]));
    }

    var isEmpty = _isEmpty || _htmlbarsUtilVoidTagNames.default[tagName];

    if (!isEmpty) {
      statements.push(_htmlbarsUtilTemplateUtils.buildStatement('content', 'yield'));
    }

    var template = {
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        if (tagName === 'svg') {
          dom.setNamespace(svgNamespace);
        }
        var el1 = dom.createElement(tagName);

        for (var key in attributes) {
          if (typeof attributes[key] !== 'string') {
            continue;
          }
          dom.setAttribute(el1, key, attributes[key]);
        }

        if (!isEmpty) {
          var el2 = dom.createComment("");
          dom.appendChild(el1, el2);
        }

        dom.appendChild(el0, el1);

        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment) {
        var element = dom.childAt(fragment, [0]);
        var morphs = [];

        for (var key in attributes) {
          if (typeof attributes[key] === 'string') {
            continue;
          }
          morphs.push(dom.createAttrMorph(element, key));
        }

        if (!isEmpty) {
          morphs.push(dom.createMorphAt(element, 0, 0));
        }

        return morphs;
      },
      statements: statements,
      locals: [],
      templates: []
    };

    return template;
  }

  function attachAttributes(attributes) {
    var statements = [];

    for (var key in attributes) {
      if (typeof attributes[key] === 'string') {
        continue;
      }
      statements.push(_htmlbarsUtilTemplateUtils.buildStatement("attribute", key, attributes[key]));
    }

    var template = {
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = this.element;
        if (el0.namespaceURI === "http://www.w3.org/2000/svg") {
          dom.setNamespace(svgNamespace);
        }
        for (var key in attributes) {
          if (typeof attributes[key] !== 'string') {
            continue;
          }
          dom.setAttribute(el0, key, attributes[key]);
        }

        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom) {
        var element = this.element;
        var morphs = [];

        for (var key in attributes) {
          if (typeof attributes[key] === 'string') {
            continue;
          }
          morphs.push(dom.createAttrMorph(element, key));
        }

        return morphs;
      },
      statements: statements,
      locals: [],
      templates: [],
      element: null
    };

    return template;
  }

  RenderResult.prototype.initializeNodes = function (ownerNode) {
    var childNodes = this.root.childNodes;

    for (var i = 0, l = childNodes.length; i < l; i++) {
      childNodes[i].ownerNode = ownerNode;
    }
  };

  RenderResult.prototype.render = function () {
    this.root.lastResult = this;
    this.root.rendered = true;
    this.populateNodes(_htmlbarsRuntimeNodeVisitor.AlwaysDirtyVisitor);

    if (this.shouldSetContent && this.root.setContent) {
      this.root.setContent(this.fragment);
    }
  };

  RenderResult.prototype.dirty = function () {
    _htmlbarsUtilMorphUtils.visitChildren([this.root], function (node) {
      node.isDirty = true;
    });
  };

  RenderResult.prototype.revalidate = function (env, self, blockArguments, scope) {
    this.revalidateWith(env, scope, self, blockArguments, _htmlbarsRuntimeNodeVisitor.default);
  };

  RenderResult.prototype.rerender = function (env, self, blockArguments, scope) {
    this.revalidateWith(env, scope, self, blockArguments, _htmlbarsRuntimeNodeVisitor.AlwaysDirtyVisitor);
  };

  RenderResult.prototype.revalidateWith = function (env, scope, self, blockArguments, visitor) {
    if (env !== undefined) {
      this.env = env;
    }
    if (scope !== undefined) {
      this.scope = scope;
    }
    this.updateScope();

    if (self !== undefined) {
      this.updateSelf(self);
    }
    if (blockArguments !== undefined) {
      this.updateLocals(blockArguments);
    }

    this.populateNodes(visitor);
  };

  RenderResult.prototype.destroy = function () {
    var rootNode = this.root;
    _htmlbarsUtilTemplateUtils.clearMorph(rootNode, this.env, true);
  };

  RenderResult.prototype.populateNodes = function (visitor) {
    var env = this.env;
    var scope = this.scope;
    var template = this.template;
    var nodes = this.nodes;
    var statements = this.statements;
    var i, l;

    for (i = 0, l = statements.length; i < l; i++) {
      var statement = statements[i];
      var morph = nodes[i];

      if (env.hooks.willRenderNode) {
        env.hooks.willRenderNode(morph, env, scope);
      }

      switch (statement[0]) {
        case 'block':
          visitor.block(statement, morph, env, scope, template, visitor);break;
        case 'inline':
          visitor.inline(statement, morph, env, scope, visitor);break;
        case 'content':
          visitor.content(statement, morph, env, scope, visitor);break;
        case 'element':
          visitor.element(statement, morph, env, scope, template, visitor);break;
        case 'attribute':
          visitor.attribute(statement, morph, env, scope);break;
        case 'component':
          visitor.component(statement, morph, env, scope, template, visitor);break;
      }

      if (env.hooks.didRenderNode) {
        env.hooks.didRenderNode(morph, env, scope);
      }
    }
  };

  RenderResult.prototype.bindScope = function () {
    this.env.hooks.bindScope(this.env, this.scope);
  };

  RenderResult.prototype.updateScope = function () {
    this.env.hooks.updateScope(this.env, this.scope);
  };

  RenderResult.prototype.bindSelf = function (self) {
    this.env.hooks.bindSelf(this.env, this.scope, self);
  };

  RenderResult.prototype.updateSelf = function (self) {
    this.env.hooks.updateSelf(this.env, this.scope, self);
  };

  RenderResult.prototype.bindLocals = function (blockArguments) {
    var localNames = this.template.locals;

    for (var i = 0, l = localNames.length; i < l; i++) {
      this.env.hooks.bindLocal(this.env, this.scope, localNames[i], blockArguments[i]);
    }
  };

  RenderResult.prototype.updateLocals = function (blockArguments) {
    var localNames = this.template.locals;

    for (var i = 0, l = localNames.length; i < l; i++) {
      this.env.hooks.updateLocal(this.env, this.scope, localNames[i], blockArguments[i]);
    }
  };

  function initializeNode(node, owner) {
    node.ownerNode = owner;
  }

  function createChildMorph(dom, parentMorph, contextualElement) {
    var morph = _htmlbarsRuntimeMorph.default.empty(dom, contextualElement || parentMorph.contextualElement);
    initializeNode(morph, parentMorph.ownerNode);
    return morph;
  }

  function getCachedFragment(template, env) {
    var dom = env.dom,
        fragment;
    if (env.useFragmentCache && dom.canClone) {
      if (template.cachedFragment === null) {
        fragment = template.buildFragment(dom);
        if (template.hasRendered) {
          template.cachedFragment = fragment;
        } else {
          template.hasRendered = true;
        }
      }
      if (template.cachedFragment) {
        fragment = dom.cloneNode(template.cachedFragment, true);
      }
    } else if (!fragment) {
      fragment = template.buildFragment(dom);
    }

    return fragment;
  }
})(Em._e[43],Em._e[34],Em._e[36],Em._e[39],Em._e[40],Em._e[42]);
(function (exports, _morphRangeUtils) {
  'use strict';

  function MorphList() {
    // morph graph
    this.firstChildMorph = null;
    this.lastChildMorph = null;

    this.mountedMorph = null;
  }

  var prototype = MorphList.prototype;

  prototype.clear = function MorphList$clear() {
    var current = this.firstChildMorph;

    while (current) {
      var next = current.nextMorph;
      current.previousMorph = null;
      current.nextMorph = null;
      current.parentMorphList = null;
      current = next;
    }

    this.firstChildMorph = this.lastChildMorph = null;
  };

  prototype.destroy = function MorphList$destroy() {};

  prototype.appendMorph = function MorphList$appendMorph(morph) {
    this.insertBeforeMorph(morph, null);
  };

  prototype.insertBeforeMorph = function MorphList$insertBeforeMorph(morph, referenceMorph) {
    if (morph.parentMorphList !== null) {
      morph.unlink();
    }
    if (referenceMorph && referenceMorph.parentMorphList !== this) {
      throw new Error('The morph before which the new morph is to be inserted is not a child of this morph.');
    }

    var mountedMorph = this.mountedMorph;

    if (mountedMorph) {

      var parentNode = mountedMorph.firstNode.parentNode;
      var referenceNode = referenceMorph ? referenceMorph.firstNode : mountedMorph.lastNode.nextSibling;

      _morphRangeUtils.insertBefore(parentNode, morph.firstNode, morph.lastNode, referenceNode);

      // was not in list mode replace current content
      if (!this.firstChildMorph) {
        _morphRangeUtils.clear(this.mountedMorph.firstNode.parentNode, this.mountedMorph.firstNode, this.mountedMorph.lastNode);
      }
    }

    morph.parentMorphList = this;

    var previousMorph = referenceMorph ? referenceMorph.previousMorph : this.lastChildMorph;
    if (previousMorph) {
      previousMorph.nextMorph = morph;
      morph.previousMorph = previousMorph;
    } else {
      this.firstChildMorph = morph;
    }

    if (referenceMorph) {
      referenceMorph.previousMorph = morph;
      morph.nextMorph = referenceMorph;
    } else {
      this.lastChildMorph = morph;
    }

    this.firstChildMorph._syncFirstNode();
    this.lastChildMorph._syncLastNode();
  };

  prototype.removeChildMorph = function MorphList$removeChildMorph(morph) {
    if (morph.parentMorphList !== this) {
      throw new Error("Cannot remove a morph from a parent it is not inside of");
    }

    morph.destroy();
  };

  exports.default = MorphList;
})(Em._e[44],Em._e[37]);
(function (exports) {
  "use strict";

  exports.merge = merge;
  exports.shallowCopy = shallowCopy;
  exports.keySet = keySet;
  exports.keyLength = keyLength;

  function merge(options, defaults) {
    for (var prop in defaults) {
      if (options.hasOwnProperty(prop)) {
        continue;
      }
      options[prop] = defaults[prop];
    }
    return options;
  }

  function shallowCopy(obj) {
    return merge({}, obj);
  }

  function keySet(obj) {
    var set = {};

    for (var prop in obj) {
      if (obj.hasOwnProperty(prop)) {
        set[prop] = true;
      }
    }

    return set;
  }

  function keyLength(obj) {
    var count = 0;

    for (var prop in obj) {
      if (obj.hasOwnProperty(prop)) {
        count++;
      }
    }

    return count;
  }
})(Em._e[45]);
(function (exports, _htmlbarsRuntimeRender, _morphRangeMorphList, _htmlbarsUtilObjectUtils, _htmlbarsUtilMorphUtils, _htmlbarsUtilTemplateUtils) {
  "use strict";

  exports.wrap = wrap;
  exports.wrapForHelper = wrapForHelper;
  exports.createScope = createScope;
  exports.createFreshScope = createFreshScope;
  exports.bindShadowScope = bindShadowScope;
  exports.createChildScope = createChildScope;
  exports.bindSelf = bindSelf;
  exports.updateSelf = updateSelf;
  exports.bindLocal = bindLocal;
  exports.updateLocal = updateLocal;
  exports.bindBlock = bindBlock;
  exports.block = block;
  exports.continueBlock = continueBlock;
  exports.hostBlock = hostBlock;
  exports.handleRedirect = handleRedirect;
  exports.handleKeyword = handleKeyword;
  exports.linkRenderNode = linkRenderNode;
  exports.inline = inline;
  exports.keyword = keyword;
  exports.invokeHelper = invokeHelper;
  exports.classify = classify;
  exports.partial = partial;
  exports.range = range;
  exports.element = element;
  exports.attribute = attribute;
  exports.subexpr = subexpr;
  exports.get = get;
  exports.getRoot = getRoot;
  exports.getBlock = getBlock;
  exports.getChild = getChild;
  exports.getValue = getValue;
  exports.getCellOrValue = getCellOrValue;
  exports.component = component;
  exports.concat = concat;
  exports.hasHelper = hasHelper;
  exports.lookupHelper = lookupHelper;
  exports.bindScope = bindScope;
  exports.updateScope = updateScope;

  /**
    HTMLBars delegates the runtime behavior of a template to
    hooks provided by the host environment. These hooks explain
    the lexical environment of a Handlebars template, the internal
    representation of references, and the interaction between an
    HTMLBars template and the DOM it is managing.
  
    While HTMLBars host hooks have access to all of this internal
    machinery, templates and helpers have access to the abstraction
    provided by the host hooks.
  
    ## The Lexical Environment
  
    The default lexical environment of an HTMLBars template includes:
  
    * Any local variables, provided by *block arguments*
    * The current value of `self`
  
    ## Simple Nesting
  
    Let's look at a simple template with a nested block:
  
    ```hbs
    <h1>{{title}}</h1>
  
    {{#if author}}
      <p class="byline">{{author}}</p>
    {{/if}}
    ```
  
    In this case, the lexical environment at the top-level of the
    template does not change inside of the `if` block. This is
    achieved via an implementation of `if` that looks like this:
  
    ```js
    registerHelper('if', function(params) {
      if (!!params[0]) {
        return this.yield();
      }
    });
    ```
  
    A call to `this.yield` invokes the child template using the
    current lexical environment.
  
    ## Block Arguments
  
    It is possible for nested blocks to introduce new local
    variables:
  
    ```hbs
    {{#count-calls as |i|}}
    <h1>{{title}}</h1>
    <p>Called {{i}} times</p>
    {{/count}}
    ```
  
    In this example, the child block inherits its surrounding
    lexical environment, but augments it with a single new
    variable binding.
  
    The implementation of `count-calls` supplies the value of
    `i`, but does not otherwise alter the environment:
  
    ```js
    var count = 0;
    registerHelper('count-calls', function() {
      return this.yield([ ++count ]);
    });
    ```
  */

  function wrap(template) {
    if (template === null) {
      return null;
    }

    return {
      meta: template.meta,
      arity: template.arity,
      raw: template,
      render: function (self, env, options, blockArguments) {
        var scope = env.hooks.createFreshScope();

        var contextualElement = options && options.contextualElement;
        var renderOptions = new _htmlbarsRuntimeRender.RenderOptions(null, self, blockArguments, contextualElement);

        return _htmlbarsRuntimeRender.default(template, env, scope, renderOptions);
      }
    };
  }

  function wrapForHelper(template, env, scope, morph, renderState, visitor) {
    if (!template) {
      return {};
    }

    var yieldArgs = yieldTemplate(template, env, scope, morph, renderState, visitor);

    return {
      meta: template.meta,
      arity: template.arity,
      'yield': yieldArgs, // quoted since it's a reserved word, see issue #420
      yieldItem: yieldItem(template, env, scope, morph, renderState, visitor),
      raw: template,

      render: function (self, blockArguments) {
        yieldArgs(blockArguments, self);
      }
    };
  }

  // Called by a user-land helper to render a template.
  function yieldTemplate(template, env, parentScope, morph, renderState, visitor) {
    return function (blockArguments, self) {
      // Render state is used to track the progress of the helper (since it
      // may call into us multiple times). As the user-land helper calls
      // into library code, we track what needs to be cleaned up after the
      // helper has returned.
      //
      // Here, we remember that a template has been yielded and so we do not
      // need to remove the previous template. (If no template is yielded
      // this render by the helper, we assume nothing should be shown and
      // remove any previous rendered templates.)
      renderState.morphToClear = null;

      // In this conditional is true, it means that on the previous rendering pass
      // the helper yielded multiple items via `yieldItem()`, but this time they
      // are yielding a single template. In that case, we mark the morph list for
      // cleanup so it is removed from the DOM.
      if (morph.morphList) {
        _htmlbarsUtilTemplateUtils.clearMorphList(morph.morphList, morph, env);
        renderState.morphListToClear = null;
      }

      var scope = parentScope;

      if (morph.lastYielded && isStableTemplate(template, morph.lastYielded)) {
        return morph.lastResult.revalidateWith(env, undefined, self, blockArguments, visitor);
      }

      // Check to make sure that we actually **need** a new scope, and can't
      // share the parent scope. Note that we need to move this check into
      // a host hook, because the host's notion of scope may require a new
      // scope in more cases than the ones we can determine statically.
      if (self !== undefined || parentScope === null || template.arity) {
        scope = env.hooks.createChildScope(parentScope);
      }

      morph.lastYielded = { self: self, template: template, shadowTemplate: null };

      // Render the template that was selected by the helper
      var renderOptions = new _htmlbarsRuntimeRender.RenderOptions(morph, self, blockArguments);
      _htmlbarsRuntimeRender.default(template, env, scope, renderOptions);
    };
  }

  function yieldItem(template, env, parentScope, morph, renderState, visitor) {
    // Initialize state that tracks multiple items being
    // yielded in.
    var currentMorph = null;

    // Candidate morphs for deletion.
    var candidates = {};

    // Reuse existing MorphList if this is not a first-time
    // render.
    var morphList = morph.morphList;
    if (morphList) {
      currentMorph = morphList.firstChildMorph;
    }

    // Advances the currentMorph pointer to the morph in the previously-rendered
    // list that matches the yielded key. While doing so, it marks any morphs
    // that it advances past as candidates for deletion. Assuming those morphs
    // are not yielded in later, they will be removed in the prune step during
    // cleanup.
    // Note that this helper function assumes that the morph being seeked to is
    // guaranteed to exist in the previous MorphList; if this is called and the
    // morph does not exist, it will result in an infinite loop
    function advanceToKey(key) {
      var seek = currentMorph;

      while (seek.key !== key) {
        candidates[seek.key] = seek;
        seek = seek.nextMorph;
      }

      currentMorph = seek.nextMorph;
      return seek;
    }

    return function (_key, blockArguments, self) {
      if (typeof _key !== 'string') {
        throw new Error("You must provide a string key when calling `yieldItem`; you provided " + _key);
      }

      // At least one item has been yielded, so we do not wholesale
      // clear the last MorphList but instead apply a prune operation.
      renderState.morphListToClear = null;
      morph.lastYielded = null;

      var morphList, morphMap;

      if (!morph.morphList) {
        morph.morphList = new _morphRangeMorphList.default();
        morph.morphMap = {};
        morph.setMorphList(morph.morphList);
      }

      morphList = morph.morphList;
      morphMap = morph.morphMap;

      // A map of morphs that have been yielded in on this
      // rendering pass. Any morphs that do not make it into
      // this list will be pruned from the MorphList during the cleanup
      // process.
      var handledMorphs = renderState.handledMorphs;
      var key = undefined;

      if (_key in handledMorphs) {
        // In this branch we are dealing with a duplicate key. The strategy
        // is to take the original key and append a counter to it that is
        // incremented every time the key is reused. In order to greatly
        // reduce the chance of colliding with another valid key we also add
        // an extra string "--z8mS2hvDW0A--" to the new key.
        var collisions = renderState.collisions;
        if (collisions === undefined) {
          collisions = renderState.collisions = {};
        }
        var count = collisions[_key] | 0;
        collisions[_key] = ++count;

        key = _key + '--z8mS2hvDW0A--' + count;
      } else {
        key = _key;
      }

      if (currentMorph && currentMorph.key === key) {
        yieldTemplate(template, env, parentScope, currentMorph, renderState, visitor)(blockArguments, self);
        currentMorph = currentMorph.nextMorph;
        handledMorphs[key] = currentMorph;
      } else if (morphMap[key] !== undefined) {
        var foundMorph = morphMap[key];

        if (key in candidates) {
          // If we already saw this morph, move it forward to this position
          morphList.insertBeforeMorph(foundMorph, currentMorph);
        } else {
          // Otherwise, move the pointer forward to the existing morph for this key
          advanceToKey(key);
        }

        handledMorphs[foundMorph.key] = foundMorph;
        yieldTemplate(template, env, parentScope, foundMorph, renderState, visitor)(blockArguments, self);
      } else {
        var childMorph = _htmlbarsRuntimeRender.createChildMorph(env.dom, morph);
        childMorph.key = key;
        morphMap[key] = handledMorphs[key] = childMorph;
        morphList.insertBeforeMorph(childMorph, currentMorph);
        yieldTemplate(template, env, parentScope, childMorph, renderState, visitor)(blockArguments, self);
      }

      renderState.morphListToPrune = morphList;
      morph.childNodes = null;
    };
  }

  function isStableTemplate(template, lastYielded) {
    return !lastYielded.shadowTemplate && template === lastYielded.template;
  }
  function optionsFor(template, inverse, env, scope, morph, visitor) {
    // If there was a template yielded last time, set morphToClear so it will be cleared
    // if no template is yielded on this render.
    var morphToClear = morph.lastResult ? morph : null;
    var renderState = new _htmlbarsUtilTemplateUtils.RenderState(morphToClear, morph.morphList || null);

    return {
      templates: {
        template: wrapForHelper(template, env, scope, morph, renderState, visitor),
        inverse: wrapForHelper(inverse, env, scope, morph, renderState, visitor)
      },
      renderState: renderState
    };
  }

  function thisFor(options) {
    return {
      arity: options.template.arity,
      'yield': options.template.yield, // quoted since it's a reserved word, see issue #420
      yieldItem: options.template.yieldItem,
      yieldIn: options.template.yieldIn
    };
  }

  /**
    Host Hook: createScope
  
    @param {Scope?} parentScope
    @return Scope
  
    Corresponds to entering a new HTMLBars block.
  
    This hook is invoked when a block is entered with
    a new `self` or additional local variables.
  
    When invoked for a top-level template, the
    `parentScope` is `null`, and this hook should return
    a fresh Scope.
  
    When invoked for a child template, the `parentScope`
    is the scope for the parent environment.
  
    Note that the `Scope` is an opaque value that is
    passed to other host hooks. For example, the `get`
    hook uses the scope to retrieve a value for a given
    scope and variable name.
  */

  function createScope(env, parentScope) {
    if (parentScope) {
      return env.hooks.createChildScope(parentScope);
    } else {
      return env.hooks.createFreshScope();
    }
  }

  function createFreshScope() {
    // because `in` checks have unpredictable performance, keep a
    // separate dictionary to track whether a local was bound.
    // See `bindLocal` for more information.
    return { self: null, blocks: {}, locals: {}, localPresent: {} };
  }

  /**
    Host Hook: bindShadowScope
  
    @param {Scope?} parentScope
    @return Scope
  
    Corresponds to rendering a new template into an existing
    render tree, but with a new top-level lexical scope. This
    template is called the "shadow root".
  
    If a shadow template invokes `{{yield}}`, it will render
    the block provided to the shadow root in the original
    lexical scope.
  
    ```hbs
    {{!-- post template --}}
    <p>{{props.title}}</p>
    {{yield}}
  
    {{!-- blog template --}}
    {{#post title="Hello world"}}
      <p>by {{byline}}</p>
      <article>This is my first post</article>
    {{/post}}
  
    {{#post title="Goodbye world"}}
      <p>by {{byline}}</p>
      <article>This is my last post</article>
    {{/post}}
    ```
  
    ```js
    helpers.post = function(params, hash, options) {
      options.template.yieldIn(postTemplate, { props: hash });
    };
  
    blog.render({ byline: "Yehuda Katz" });
    ```
  
    Produces:
  
    ```html
    <p>Hello world</p>
    <p>by Yehuda Katz</p>
    <article>This is my first post</article>
  
    <p>Goodbye world</p>
    <p>by Yehuda Katz</p>
    <article>This is my last post</article>
    ```
  
    In short, `yieldIn` creates a new top-level scope for the
    provided template and renders it, making the original block
    available to `{{yield}}` in that template.
  */

  function bindShadowScope(env /*, parentScope, shadowScope */) {
    return env.hooks.createFreshScope();
  }

  function createChildScope(parent) {
    var scope = Object.create(parent);
    scope.locals = Object.create(parent.locals);
    scope.localPresent = Object.create(parent.localPresent);
    scope.blocks = Object.create(parent.blocks);
    return scope;
  }

  /**
    Host Hook: bindSelf
  
    @param {Scope} scope
    @param {any} self
  
    Corresponds to entering a template.
  
    This hook is invoked when the `self` value for a scope is ready to be bound.
  
    The host must ensure that child scopes reflect the change to the `self` in
    future calls to the `get` hook.
  */

  function bindSelf(env, scope, self) {
    scope.self = self;
  }

  function updateSelf(env, scope, self) {
    env.hooks.bindSelf(env, scope, self);
  }

  /**
    Host Hook: bindLocal
  
    @param {Environment} env
    @param {Scope} scope
    @param {String} name
    @param {any} value
  
    Corresponds to entering a template with block arguments.
  
    This hook is invoked when a local variable for a scope has been provided.
  
    The host must ensure that child scopes reflect the change in future calls
    to the `get` hook.
  */

  function bindLocal(env, scope, name, value) {
    scope.localPresent[name] = true;
    scope.locals[name] = value;
  }

  function updateLocal(env, scope, name, value) {
    env.hooks.bindLocal(env, scope, name, value);
  }

  /**
    Host Hook: bindBlock
  
    @param {Environment} env
    @param {Scope} scope
    @param {Function} block
  
    Corresponds to entering a shadow template that was invoked by a block helper with
    `yieldIn`.
  
    This hook is invoked with an opaque block that will be passed along
    to the shadow template, and inserted into the shadow template when
    `{{yield}}` is used. Optionally provide a non-default block name
    that can be targeted by `{{yield to=blockName}}`.
  */

  function bindBlock(env, scope, block) {
    var name = arguments.length <= 3 || arguments[3] === undefined ? 'default' : arguments[3];

    scope.blocks[name] = block;
  }

  /**
    Host Hook: block
  
    @param {RenderNode} renderNode
    @param {Environment} env
    @param {Scope} scope
    @param {String} path
    @param {Array} params
    @param {Object} hash
    @param {Block} block
    @param {Block} elseBlock
  
    Corresponds to:
  
    ```hbs
    {{#helper param1 param2 key1=val1 key2=val2}}
      {{!-- child template --}}
    {{/helper}}
    ```
  
    This host hook is a workhorse of the system. It is invoked
    whenever a block is encountered, and is responsible for
    resolving the helper to call, and then invoke it.
  
    The helper should be invoked with:
  
    - `{Array} params`: the parameters passed to the helper
      in the template.
    - `{Object} hash`: an object containing the keys and values passed
      in the hash position in the template.
  
    The values in `params` and `hash` will already be resolved
    through a previous call to the `get` host hook.
  
    The helper should be invoked with a `this` value that is
    an object with one field:
  
    `{Function} yield`: when invoked, this function executes the
    block with the current scope. It takes an optional array of
    block parameters. If block parameters are supplied, HTMLBars
    will invoke the `bindLocal` host hook to bind the supplied
    values to the block arguments provided by the template.
  
    In general, the default implementation of `block` should work
    for most host environments. It delegates to other host hooks
    where appropriate, and properly invokes the helper with the
    appropriate arguments.
  */

  function block(morph, env, scope, path, params, hash, template, inverse, visitor) {
    if (handleRedirect(morph, env, scope, path, params, hash, template, inverse, visitor)) {
      return;
    }

    continueBlock(morph, env, scope, path, params, hash, template, inverse, visitor);
  }

  function continueBlock(morph, env, scope, path, params, hash, template, inverse, visitor) {
    hostBlock(morph, env, scope, template, inverse, null, visitor, function (options) {
      var helper = env.hooks.lookupHelper(env, scope, path);
      return env.hooks.invokeHelper(morph, env, scope, visitor, params, hash, helper, options.templates, thisFor(options.templates));
    });
  }

  function hostBlock(morph, env, scope, template, inverse, shadowOptions, visitor, callback) {
    var options = optionsFor(template, inverse, env, scope, morph, visitor);
    _htmlbarsUtilTemplateUtils.renderAndCleanup(morph, env, options, shadowOptions, callback);
  }

  function handleRedirect(morph, env, scope, path, params, hash, template, inverse, visitor) {
    if (!path) {
      return false;
    }

    var redirect = env.hooks.classify(env, scope, path);
    if (redirect) {
      switch (redirect) {
        case 'component':
          env.hooks.component(morph, env, scope, path, params, hash, { default: template, inverse: inverse }, visitor);break;
        case 'inline':
          env.hooks.inline(morph, env, scope, path, params, hash, visitor);break;
        case 'block':
          env.hooks.block(morph, env, scope, path, params, hash, template, inverse, visitor);break;
        default:
          throw new Error("Internal HTMLBars redirection to " + redirect + " not supported");
      }
      return true;
    }

    if (handleKeyword(path, morph, env, scope, params, hash, template, inverse, visitor)) {
      return true;
    }

    return false;
  }

  function handleKeyword(path, morph, env, scope, params, hash, template, inverse, visitor) {
    var keyword = env.hooks.keywords[path];
    if (!keyword) {
      return false;
    }

    if (typeof keyword === 'function') {
      return keyword(morph, env, scope, params, hash, template, inverse, visitor);
    }

    if (keyword.willRender) {
      keyword.willRender(morph, env);
    }

    var lastState, newState;
    if (keyword.setupState) {
      lastState = _htmlbarsUtilObjectUtils.shallowCopy(morph.getState());
      newState = morph.setState(keyword.setupState(lastState, env, scope, params, hash));
    }

    if (keyword.childEnv) {
      // Build the child environment...
      env = keyword.childEnv(morph.getState(), env);

      // ..then save off the child env builder on the render node. If the render
      // node tree is re-rendered and this node is not dirty, the child env
      // builder will still be invoked so that child dirty render nodes still get
      // the correct child env.
      morph.buildChildEnv = keyword.childEnv;
    }

    var firstTime = !morph.rendered;

    if (keyword.isEmpty) {
      var isEmpty = keyword.isEmpty(morph.getState(), env, scope, params, hash);

      if (isEmpty) {
        if (!firstTime) {
          _htmlbarsUtilTemplateUtils.clearMorph(morph, env, false);
        }
        return true;
      }
    }

    if (firstTime) {
      if (keyword.render) {
        keyword.render(morph, env, scope, params, hash, template, inverse, visitor);
      }
      morph.rendered = true;
      return true;
    }

    var isStable;
    if (keyword.isStable) {
      isStable = keyword.isStable(lastState, newState);
    } else {
      isStable = stableState(lastState, newState);
    }

    if (isStable) {
      if (keyword.rerender) {
        var newEnv = keyword.rerender(morph, env, scope, params, hash, template, inverse, visitor);
        env = newEnv || env;
      }
      _htmlbarsUtilMorphUtils.validateChildMorphs(env, morph, visitor);
      return true;
    } else {
      _htmlbarsUtilTemplateUtils.clearMorph(morph, env, false);
    }

    // If the node is unstable, re-render from scratch
    if (keyword.render) {
      keyword.render(morph, env, scope, params, hash, template, inverse, visitor);
      morph.rendered = true;
      return true;
    }
  }

  function stableState(oldState, newState) {
    if (_htmlbarsUtilObjectUtils.keyLength(oldState) !== _htmlbarsUtilObjectUtils.keyLength(newState)) {
      return false;
    }

    for (var prop in oldState) {
      if (oldState[prop] !== newState[prop]) {
        return false;
      }
    }

    return true;
  }

  function linkRenderNode() /* morph, env, scope, params, hash */{
    return;
  }

  /**
    Host Hook: inline
  
    @param {RenderNode} renderNode
    @param {Environment} env
    @param {Scope} scope
    @param {String} path
    @param {Array} params
    @param {Hash} hash
  
    Corresponds to:
  
    ```hbs
    {{helper param1 param2 key1=val1 key2=val2}}
    ```
  
    This host hook is similar to the `block` host hook, but it
    invokes helpers that do not supply an attached block.
  
    Like the `block` hook, the helper should be invoked with:
  
    - `{Array} params`: the parameters passed to the helper
      in the template.
    - `{Object} hash`: an object containing the keys and values passed
      in the hash position in the template.
  
    The values in `params` and `hash` will already be resolved
    through a previous call to the `get` host hook.
  
    In general, the default implementation of `inline` should work
    for most host environments. It delegates to other host hooks
    where appropriate, and properly invokes the helper with the
    appropriate arguments.
  
    The default implementation of `inline` also makes `partial`
    a keyword. Instead of invoking a helper named `partial`,
    it invokes the `partial` host hook.
  */

  function inline(morph, env, scope, path, params, hash, visitor) {
    if (handleRedirect(morph, env, scope, path, params, hash, null, null, visitor)) {
      return;
    }

    var value = undefined,
        hasValue = undefined;
    if (morph.linkedResult) {
      value = env.hooks.getValue(morph.linkedResult);
      hasValue = true;
    } else {
      var options = optionsFor(null, null, env, scope, morph);

      var helper = env.hooks.lookupHelper(env, scope, path);
      var result = env.hooks.invokeHelper(morph, env, scope, visitor, params, hash, helper, options.templates, thisFor(options.templates));

      if (result && result.link) {
        morph.linkedResult = result.value;
        _htmlbarsUtilMorphUtils.linkParams(env, scope, morph, '@content-helper', [morph.linkedResult], null);
      }

      if (result && 'value' in result) {
        value = env.hooks.getValue(result.value);
        hasValue = true;
      }
    }

    if (hasValue) {
      if (morph.lastValue !== value) {
        morph.setContent(value);
      }
      morph.lastValue = value;
    }
  }

  function keyword(path, morph, env, scope, params, hash, template, inverse, visitor) {
    handleKeyword(path, morph, env, scope, params, hash, template, inverse, visitor);
  }

  function invokeHelper(morph, env, scope, visitor, _params, _hash, helper, templates, context) {
    var params = normalizeArray(env, _params);
    var hash = normalizeObject(env, _hash);
    return { value: helper.call(context, params, hash, templates) };
  }

  function normalizeArray(env, array) {
    var out = new Array(array.length);

    for (var i = 0, l = array.length; i < l; i++) {
      out[i] = env.hooks.getCellOrValue(array[i]);
    }

    return out;
  }

  function normalizeObject(env, object) {
    var out = {};

    for (var prop in object) {
      out[prop] = env.hooks.getCellOrValue(object[prop]);
    }

    return out;
  }

  function classify() /* env, scope, path */{
    return null;
  }

  var keywords = {
    partial: function (morph, env, scope, params) {
      var value = env.hooks.partial(morph, env, scope, params[0]);
      morph.setContent(value);
      return true;
    },

    // quoted since it's a reserved word, see issue #420
    'yield': function (morph, env, scope, params, hash, template, inverse, visitor) {
      // the current scope is provided purely for the creation of shadow
      // scopes; it should not be provided to user code.

      var to = env.hooks.getValue(hash.to) || 'default';
      var block = env.hooks.getBlock(scope, to);

      if (block) {
        block.invoke(env, params, hash.self, morph, scope, visitor);
      }
      return true;
    },

    hasBlock: function (morph, env, scope, params) {
      var name = env.hooks.getValue(params[0]) || 'default';
      return !!env.hooks.getBlock(scope, name);
    },

    hasBlockParams: function (morph, env, scope, params) {
      var name = env.hooks.getValue(params[0]) || 'default';
      var block = env.hooks.getBlock(scope, name);
      return !!(block && block.arity);
    }

  };

  exports.keywords = keywords;
  /**
    Host Hook: partial
  
    @param {RenderNode} renderNode
    @param {Environment} env
    @param {Scope} scope
    @param {String} path
  
    Corresponds to:
  
    ```hbs
    {{partial "location"}}
    ```
  
    This host hook is invoked by the default implementation of
    the `inline` hook. This makes `partial` a keyword in an
    HTMLBars environment using the default `inline` host hook.
  
    It is implemented as a host hook so that it can retrieve
    the named partial out of the `Environment`. Helpers, in
    contrast, only have access to the values passed in to them,
    and not to the ambient lexical environment.
  
    The host hook should invoke the referenced partial with
    the ambient `self`.
  */

  function partial(renderNode, env, scope, path) {
    var template = env.partials[path];
    return template.render(scope.self, env, {}).fragment;
  }

  /**
    Host hook: range
  
    @param {RenderNode} renderNode
    @param {Environment} env
    @param {Scope} scope
    @param {any} value
  
    Corresponds to:
  
    ```hbs
    {{content}}
    {{{unescaped}}}
    ```
  
    This hook is responsible for updating a render node
    that represents a range of content with a value.
  */

  function range(morph, env, scope, path, value, visitor) {
    if (handleRedirect(morph, env, scope, path, [], {}, null, null, visitor)) {
      return;
    }

    value = env.hooks.getValue(value);

    if (morph.lastValue !== value) {
      morph.setContent(value);
    }

    morph.lastValue = value;
  }

  /**
    Host hook: element
  
    @param {RenderNode} renderNode
    @param {Environment} env
    @param {Scope} scope
    @param {String} path
    @param {Array} params
    @param {Hash} hash
  
    Corresponds to:
  
    ```hbs
    <div {{bind-attr foo=bar}}></div>
    ```
  
    This hook is responsible for invoking a helper that
    modifies an element.
  
    Its purpose is largely legacy support for awkward
    idioms that became common when using the string-based
    Handlebars engine.
  
    Most of the uses of the `element` hook are expected
    to be superseded by component syntax and the
    `attribute` hook.
  */

  function element(morph, env, scope, path, params, hash, visitor) {
    if (handleRedirect(morph, env, scope, path, params, hash, null, null, visitor)) {
      return;
    }

    var helper = env.hooks.lookupHelper(env, scope, path);
    if (helper) {
      env.hooks.invokeHelper(null, env, scope, null, params, hash, helper, { element: morph.element });
    }
  }

  /**
    Host hook: attribute
  
    @param {RenderNode} renderNode
    @param {Environment} env
    @param {String} name
    @param {any} value
  
    Corresponds to:
  
    ```hbs
    <div foo={{bar}}></div>
    ```
  
    This hook is responsible for updating a render node
    that represents an element's attribute with a value.
  
    It receives the name of the attribute as well as an
    already-resolved value, and should update the render
    node with the value if appropriate.
  */

  function attribute(morph, env, scope, name, value) {
    value = env.hooks.getValue(value);

    if (morph.lastValue !== value) {
      morph.setContent(value);
    }

    morph.lastValue = value;
  }

  function subexpr(env, scope, helperName, params, hash) {
    var helper = env.hooks.lookupHelper(env, scope, helperName);
    var result = env.hooks.invokeHelper(null, env, scope, null, params, hash, helper, {});
    if (result && 'value' in result) {
      return env.hooks.getValue(result.value);
    }
  }

  /**
    Host Hook: get
  
    @param {Environment} env
    @param {Scope} scope
    @param {String} path
  
    Corresponds to:
  
    ```hbs
    {{foo.bar}}
      ^
  
    {{helper foo.bar key=value}}
             ^           ^
    ```
  
    This hook is the "leaf" hook of the system. It is used to
    resolve a path relative to the current scope.
  */

  function get(env, scope, path) {
    if (path === '') {
      return scope.self;
    }

    var keys = path.split('.');
    var value = env.hooks.getRoot(scope, keys[0])[0];

    for (var i = 1; i < keys.length; i++) {
      if (value) {
        value = env.hooks.getChild(value, keys[i]);
      } else {
        break;
      }
    }

    return value;
  }

  function getRoot(scope, key) {
    if (scope.localPresent[key]) {
      return [scope.locals[key]];
    } else if (scope.self) {
      return [scope.self[key]];
    } else {
      return [undefined];
    }
  }

  function getBlock(scope, key) {
    return scope.blocks[key];
  }

  function getChild(value, key) {
    return value[key];
  }

  function getValue(reference) {
    return reference;
  }

  function getCellOrValue(reference) {
    return reference;
  }

  function component(morph, env, scope, tagName, params, attrs, templates, visitor) {
    if (env.hooks.hasHelper(env, scope, tagName)) {
      return env.hooks.block(morph, env, scope, tagName, params, attrs, templates.default, templates.inverse, visitor);
    }

    componentFallback(morph, env, scope, tagName, attrs, templates.default);
  }

  function concat(env, params) {
    var value = "";
    for (var i = 0, l = params.length; i < l; i++) {
      value += env.hooks.getValue(params[i]);
    }
    return value;
  }

  function componentFallback(morph, env, scope, tagName, attrs, template) {
    var element = env.dom.createElement(tagName);
    for (var name in attrs) {
      element.setAttribute(name, env.hooks.getValue(attrs[name]));
    }
    var fragment = _htmlbarsRuntimeRender.default(template, env, scope, {}).fragment;
    element.appendChild(fragment);
    morph.setNode(element);
  }

  function hasHelper(env, scope, helperName) {
    return env.helpers[helperName] !== undefined;
  }

  function lookupHelper(env, scope, helperName) {
    return env.helpers[helperName];
  }

  function bindScope() /* env, scope */{
    // this function is used to handle host-specified extensions to scope
    // other than `self`, `locals` and `block`.
  }

  function updateScope(env, scope) {
    env.hooks.bindScope(env, scope);
  }

  exports.default = {
    // fundamental hooks that you will likely want to override
    bindLocal: bindLocal,
    bindSelf: bindSelf,
    bindScope: bindScope,
    classify: classify,
    component: component,
    concat: concat,
    createFreshScope: createFreshScope,
    getChild: getChild,
    getRoot: getRoot,
    getBlock: getBlock,
    getValue: getValue,
    getCellOrValue: getCellOrValue,
    keywords: keywords,
    linkRenderNode: linkRenderNode,
    partial: partial,
    subexpr: subexpr,

    // fundamental hooks with good default behavior
    bindBlock: bindBlock,
    bindShadowScope: bindShadowScope,
    updateLocal: updateLocal,
    updateSelf: updateSelf,
    updateScope: updateScope,
    createChildScope: createChildScope,
    hasHelper: hasHelper,
    lookupHelper: lookupHelper,
    invokeHelper: invokeHelper,
    cleanupRenderNode: null,
    destroyRenderNode: null,
    willCleanupTree: null,
    didCleanupTree: null,
    willRenderNode: null,
    didRenderNode: null,

    // derived hooks
    attribute: attribute,
    block: block,
    createScope: createScope,
    element: element,
    get: get,
    inline: inline,
    range: range,
    keyword: keyword
  };
})(Em._e[46],Em._e[43],Em._e[44],Em._e[45],Em._e[34],Em._e[40]);
(function (exports, _htmlbarsRuntimeHooks, _htmlbarsRuntimeRender, _htmlbarsUtilMorphUtils, _htmlbarsUtilTemplateUtils) {
  'use strict';

  var internal = {
    blockFor: _htmlbarsUtilTemplateUtils.blockFor,
    manualElement: _htmlbarsRuntimeRender.manualElement,
    hostBlock: _htmlbarsRuntimeHooks.hostBlock,
    continueBlock: _htmlbarsRuntimeHooks.continueBlock,
    hostYieldWithShadowTemplate: _htmlbarsRuntimeHooks.hostYieldWithShadowTemplate,
    visitChildren: _htmlbarsUtilMorphUtils.visitChildren,
    validateChildMorphs: _htmlbarsUtilMorphUtils.validateChildMorphs,
    clearMorph: _htmlbarsUtilTemplateUtils.clearMorph
  };

  exports.hooks = _htmlbarsRuntimeHooks.default;
  exports.render = _htmlbarsRuntimeRender.default;
  exports.internal = internal;
})(Em._e[47],Em._e[46],Em._e[43],Em._e[34],Em._e[40]);
(function (exports, _emberMetalDebug, _emberMetalFeatures, _emberMetalMeta, _emberMetalProperty_events) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.Descriptor = Descriptor;
  exports.MANDATORY_SETTER_FUNCTION = MANDATORY_SETTER_FUNCTION;
  exports.DEFAULT_GETTER_FUNCTION = DEFAULT_GETTER_FUNCTION;
  exports.INHERITING_GETTER_FUNCTION = INHERITING_GETTER_FUNCTION;
  exports.defineProperty = defineProperty;

  // ..........................................................
  // DESCRIPTOR
  //

  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  
    @class Descriptor
    @private
  */

  function Descriptor() {
    this.isDescriptor = true;
  }

  var REDEFINE_SUPPORTED = (function () {
    // https://github.com/spalger/kibana/commit/b7e35e6737df585585332857a4c397dc206e7ff9
    var a = Object.create(Object.prototype, {
      prop: {
        configurable: true,
        value: 1
      }
    });

    Object.defineProperty(a, 'prop', {
      configurable: true,
      value: 2
    });

    return a.prop === 2;
  })();
  // ..........................................................
  // DEFINING PROPERTIES API
  //

  function MANDATORY_SETTER_FUNCTION(name) {
    function SETTER_FUNCTION(value) {
      var m = _emberMetalMeta.peekMeta(this);
      if (!m.isInitialized(this)) {
        m.writeValues(name, value);
      } else {}
    }

    SETTER_FUNCTION.isMandatorySetter = true;
    return SETTER_FUNCTION;
  }

  function DEFAULT_GETTER_FUNCTION(name) {
    return function GETTER_FUNCTION() {
      var meta = _emberMetalMeta.peekMeta(this);
      return meta && meta.peekValues(name);
    };
  }

  function INHERITING_GETTER_FUNCTION(name) {
    function IGETTER_FUNCTION() {
      var meta = _emberMetalMeta.peekMeta(this);
      var val = meta && meta.readInheritedValue('values', name);

      if (val === _emberMetalMeta.UNDEFINED) {
        var proto = Object.getPrototypeOf(this);
        return proto && proto[name];
      } else {
        return val;
      }
    }

    IGETTER_FUNCTION.isInheritingGetter = true;
    return IGETTER_FUNCTION;
  }

  /**
    NOTE: This is a low-level method used by other parts of the API. You almost
    never want to call this method directly. Instead you should use
    `Ember.mixin()` to define new properties.
  
    Defines a property on an object. This method works much like the ES5
    `Object.defineProperty()` method except that it can also accept computed
    properties and other special descriptors.
  
    Normally this method takes only three parameters. However if you pass an
    instance of `Descriptor` as the third param then you can pass an
    optional value as the fourth parameter. This is often more efficient than
    creating new descriptor hashes for each property.
  
    ## Examples
  
    ```javascript
    // ES5 compatible mode
    Ember.defineProperty(contact, 'firstName', {
      writable: true,
      configurable: false,
      enumerable: true,
      value: 'Charles'
    });
  
    // define a simple property
    Ember.defineProperty(contact, 'lastName', undefined, 'Jolley');
  
    // define a computed property
    Ember.defineProperty(contact, 'fullName', Ember.computed('firstName', 'lastName', function() {
      return this.firstName+' '+this.lastName;
    }));
    ```
  
    @private
    @method defineProperty
    @for Ember
    @param {Object} obj the object to define this property on. This may be a prototype.
    @param {String} keyName the name of the property
    @param {Descriptor} [desc] an instance of `Descriptor` (typically a
      computed property) or an ES5 descriptor.
      You must provide this or `data` but not both.
    @param {*} [data] something other than a descriptor, that will
      become the explicit value of this property.
  */

  function defineProperty(obj, keyName, desc, data, meta) {
    var possibleDesc = undefined,
        existingDesc = undefined,
        watching = undefined,
        value = undefined;

    if (!meta) {
      meta = _emberMetalMeta.meta(obj);
    }
    var watchEntry = meta.peekWatching(keyName);
    possibleDesc = obj[keyName];
    existingDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

    watching = watchEntry !== undefined && watchEntry > 0;

    if (existingDesc) {
      existingDesc.teardown(obj, keyName);
    }

    if (desc instanceof Descriptor) {
      value = desc;
      if (false) {
        if (watching) {
          Object.defineProperty(obj, keyName, {
            configurable: true,
            enumerable: true,
            writable: true,
            value: value
          });
        } else {
          obj[keyName] = value;
        }
      } else {
        obj[keyName] = value;
      }
      if (desc.setup) {
        desc.setup(obj, keyName);
      }
    } else {
      if (desc == null) {
        value = data;

        if (false) {
          if (watching) {
            meta.writeValues(keyName, data);

            var defaultDescriptor = {
              configurable: true,
              enumerable: true,
              set: MANDATORY_SETTER_FUNCTION(keyName),
              get: DEFAULT_GETTER_FUNCTION(keyName)
            };

            if (REDEFINE_SUPPORTED) {
              Object.defineProperty(obj, keyName, defaultDescriptor);
            } else {
              handleBrokenPhantomDefineProperty(obj, keyName, defaultDescriptor);
            }
          } else {
            obj[keyName] = data;
          }
        } else {
          obj[keyName] = data;
        }
      } else {
        value = desc;

        // fallback to ES5
        Object.defineProperty(obj, keyName, desc);
      }
    }

    // if key is being watched, override chains that
    // were initialized with the prototype
    if (watching) {
      _emberMetalProperty_events.overrideChains(obj, keyName, meta);
    }

    // The `value` passed to the `didDefineProperty` hook is
    // either the descriptor or data, whichever was passed.
    if (obj.didDefineProperty) {
      obj.didDefineProperty(obj, keyName, value);
    }

    return this;
  }

  function handleBrokenPhantomDefineProperty(obj, keyName, desc) {
    // https://github.com/ariya/phantomjs/issues/11856
    Object.defineProperty(obj, keyName, { configurable: true, writable: true, value: 'iCry' });
    Object.defineProperty(obj, keyName, desc);
  }
})(Em._e[48],Em._e[0],Em._e[10],Em._e[14],Em._e[20]);
(function (exports, _emberMetalFeatures, _emberMetalMeta, _emberMetalProperties, _emberMetalUtils) {
  'use strict';

  exports.watchKey = watchKey;
  exports.unwatchKey = unwatchKey;

  var handleMandatorySetter = undefined;

  function watchKey(obj, keyName, meta) {
    var m = meta || _emberMetalMeta.meta(obj);

    // activate watching first time
    if (!m.peekWatching(keyName)) {
      m.writeWatching(keyName, 1);

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;
      if (desc && desc.willWatch) {
        desc.willWatch(obj, keyName);
      }

      if ('function' === typeof obj.willWatchProperty) {
        obj.willWatchProperty(keyName);
      }

      if (false) {
        // NOTE: this is dropped for prod + minified builds
        handleMandatorySetter(m, obj, keyName);
      }
    } else {
      m.writeWatching(keyName, (m.peekWatching(keyName) || 0) + 1);
    }
  }

  if (false) {
    (function () {
      var hasOwnProperty = function (obj, key) {
        return Object.prototype.hasOwnProperty.call(obj, key);
      };

      var propertyIsEnumerable = function (obj, key) {
        return Object.prototype.propertyIsEnumerable.call(obj, key);
      };

      // Future traveler, although this code looks scary. It merely exists in
      // development to aid in development asertions. Production builds of
      // ember strip this entire block out
      handleMandatorySetter = function handleMandatorySetter(m, obj, keyName) {
        var descriptor = _emberMetalUtils.lookupDescriptor(obj, keyName);
        var configurable = descriptor ? descriptor.configurable : true;
        var isWritable = descriptor ? descriptor.writable : true;
        var hasValue = descriptor ? 'value' in descriptor : true;
        var possibleDesc = descriptor && descriptor.value;
        var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

        if (isDescriptor) {
          return;
        }

        // this x in Y deopts, so keeping it in this function is better;
        if (configurable && isWritable && hasValue && keyName in obj) {
          var desc = {
            configurable: true,
            set: _emberMetalProperties.MANDATORY_SETTER_FUNCTION(keyName),
            enumerable: propertyIsEnumerable(obj, keyName),
            get: undefined
          };

          if (hasOwnProperty(obj, keyName)) {
            m.writeValues(keyName, obj[keyName]);
            desc.get = _emberMetalProperties.DEFAULT_GETTER_FUNCTION(keyName);
          } else {
            desc.get = _emberMetalProperties.INHERITING_GETTER_FUNCTION(keyName);
          }

          Object.defineProperty(obj, keyName, desc);
        }
      };
    })();
  }

  function unwatchKey(obj, keyName, meta) {
    var m = meta || _emberMetalMeta.meta(obj);
    var count = m.peekWatching(keyName);
    if (count === 1) {
      m.writeWatching(keyName, 0);

      var possibleDesc = obj[keyName];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      if (desc && desc.didUnwatch) {
        desc.didUnwatch(obj, keyName);
      }

      if ('function' === typeof obj.didUnwatchProperty) {
        obj.didUnwatchProperty(keyName);
      }

      if (false) {
        // It is true, the following code looks quite WAT. But have no fear, It
        // exists purely to improve development ergonomics and is removed from
        // ember.min.js and ember.prod.js builds.
        //
        // Some further context: Once a property is watched by ember, bypassing `set`
        // for mutation, will bypass observation. This code exists to assert when
        // that occurs, and attempt to provide more helpful feedback. The alternative
        // is tricky to debug partially observable properties.
        if (!desc && keyName in obj) {
          var maybeMandatoryDescriptor = _emberMetalUtils.lookupDescriptor(obj, keyName);

          if (maybeMandatoryDescriptor.set && maybeMandatoryDescriptor.set.isMandatorySetter) {
            if (maybeMandatoryDescriptor.get && maybeMandatoryDescriptor.get.isInheritingGetter) {
              var possibleValue = m.readInheritedValue('values', keyName);
              if (possibleValue === _emberMetalMeta.UNDEFINED) {
                delete obj[keyName];
                return;
              }
            }

            Object.defineProperty(obj, keyName, {
              configurable: true,
              enumerable: Object.prototype.propertyIsEnumerable.call(obj, keyName),
              writable: true,
              value: m.peekValues(keyName)
            });
            m.deleteFromValues(keyName);
          }
        }
      }
    } else if (count > 1) {
      m.writeWatching(keyName, count - 1);
    }
  }
})(Em._e[49],Em._e[10],Em._e[14],Em._e[48],Em._e[7]);
(function (exports, _emberMetalMeta, _emberMetalChains) {
  'use strict';

  exports.makeChainNode = makeChainNode;
  exports.watchPath = watchPath;
  exports.unwatchPath = unwatchPath;

  // get the chains for the current object. If the current object has
  // chains inherited from the proto they will be cloned and reconfigured for
  // the current object.
  function chainsFor(obj, meta) {
    return (meta || _emberMetalMeta.meta(obj)).writableChains(makeChainNode);
  }

  function makeChainNode(obj) {
    return new _emberMetalChains.ChainNode(null, null, obj);
  }

  function watchPath(obj, keyPath, meta) {
    var m = meta || _emberMetalMeta.meta(obj);
    var counter = m.peekWatching(keyPath) || 0;
    if (!counter) {
      // activate watching first time
      m.writeWatching(keyPath, 1);
      chainsFor(obj, m).add(keyPath);
    } else {
      m.writeWatching(keyPath, counter + 1);
    }
  }

  function unwatchPath(obj, keyPath, meta) {
    var m = meta || _emberMetalMeta.meta(obj);
    var counter = m.peekWatching(keyPath) || 0;

    if (counter === 1) {
      m.writeWatching(keyPath, 0);
      chainsFor(obj, m).remove(keyPath);
    } else if (counter > 1) {
      m.writeWatching(keyPath, counter - 1);
    }
  }
})(Em._e[50],Em._e[14],Em._e[51]);
(function (exports, _emberMetalProperty_get, _emberMetalMeta, _emberMetalWatch_key, _emberMetalEmpty_object, _emberMetalWatch_path) {
  'use strict';

  exports.finishChains = finishChains;

  var FIRST_KEY = /^([^\.]+)/;

  function firstKey(path) {
    return path.match(FIRST_KEY)[0];
  }

  function isObject(obj) {
    return obj && typeof obj === 'object';
  }

  function isVolatile(obj) {
    return !(isObject(obj) && obj.isDescriptor && obj._volatile === false);
  }

  function ChainWatchers() {
    // chain nodes that reference a key in this obj by key
    // we only create ChainWatchers when we are going to add them
    // so create this upfront
    this.chains = new _emberMetalEmpty_object.default();
  }

  ChainWatchers.prototype = {
    add: function (key, node) {
      var nodes = this.chains[key];
      if (nodes === undefined) {
        this.chains[key] = [node];
      } else {
        nodes.push(node);
      }
    },

    remove: function (key, node) {
      var nodes = this.chains[key];
      if (nodes) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            nodes.splice(i, 1);
            break;
          }
        }
      }
    },

    has: function (key, node) {
      var nodes = this.chains[key];
      if (nodes) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            return true;
          }
        }
      }
      return false;
    },

    revalidateAll: function () {
      for (var key in this.chains) {
        this.notify(key, true, undefined);
      }
    },

    revalidate: function (key) {
      this.notify(key, true, undefined);
    },

    // key: the string key that is part of a path changed
    // revalidate: boolean; the chains that are watching this value should revalidate
    // callback: function that will be called with the object and path that
    //           will be/are invalidated by this key change, depending on
    //           whether the revalidate flag is passed
    notify: function (key, revalidate, callback) {
      var nodes = this.chains[key];
      if (nodes === undefined || nodes.length === 0) {
        return;
      }

      var affected = undefined;

      if (callback) {
        affected = [];
      }

      for (var i = 0; i < nodes.length; i++) {
        nodes[i].notify(revalidate, affected);
      }

      if (callback === undefined) {
        return;
      }

      // we gather callbacks so we don't notify them during revalidation
      for (var i = 0; i < affected.length; i += 2) {
        var obj = affected[i];
        var path = affected[i + 1];
        callback(obj, path);
      }
    }
  };

  function makeChainWatcher() {
    return new ChainWatchers();
  }

  function addChainWatcher(obj, keyName, node) {
    if (!isObject(obj)) {
      return;
    }

    var m = _emberMetalMeta.meta(obj);
    m.writableChainWatchers(makeChainWatcher).add(keyName, node);
    _emberMetalWatch_key.watchKey(obj, keyName, m);
  }

  function removeChainWatcher(obj, keyName, node) {
    if (!isObject(obj)) {
      return;
    }

    var m = _emberMetalMeta.peekMeta(obj);

    if (!m || !m.readableChainWatchers()) {
      return;
    }

    // make meta writable
    m = _emberMetalMeta.meta(obj);

    m.readableChainWatchers().remove(keyName, node);

    _emberMetalWatch_key.unwatchKey(obj, keyName, m);
  }

  // A ChainNode watches a single key on an object. If you provide a starting
  // value for the key then the node won't actually watch it. For a root node
  // pass null for parent and key and object for value.
  function ChainNode(parent, key, value) {
    this._parent = parent;
    this._key = key;

    // _watching is true when calling get(this._parent, this._key) will
    // return the value of this node.
    //
    // It is false for the root of a chain (because we have no parent)
    // and for global paths (because the parent node is the object with
    // the observer on it)
    this._watching = value === undefined;

    this._chains = undefined;
    this._object = undefined;
    this.count = 0;

    this._value = value;
    this._paths = {};
    if (this._watching) {
      this._object = parent.value();
      if (this._object) {
        addChainWatcher(this._object, this._key, this);
      }
    }
  }

  function lazyGet(obj, key) {
    if (!obj) {
      return;
    }

    var meta = _emberMetalMeta.peekMeta(obj);

    // check if object meant only to be a prototype
    if (meta && meta.proto === obj) {
      return;
    }

    // Use `get` if the return value is an EachProxy or an uncacheable value.
    if (isVolatile(obj[key])) {
      return _emberMetalProperty_get.get(obj, key);
      // Otherwise attempt to get the cached value of the computed property
    } else {
        var cache = meta.readableCache();
        if (cache && key in cache) {
          return cache[key];
        }
      }
  }

  ChainNode.prototype = {
    value: function () {
      if (this._value === undefined && this._watching) {
        var obj = this._parent.value();
        this._value = lazyGet(obj, this._key);
      }
      return this._value;
    },

    destroy: function () {
      if (this._watching) {
        var obj = this._object;
        if (obj) {
          removeChainWatcher(obj, this._key, this);
        }
        this._watching = false; // so future calls do nothing
      }
    },

    // copies a top level object only
    copy: function (obj) {
      var ret = new ChainNode(null, null, obj);
      var paths = this._paths;
      var path = undefined;

      for (path in paths) {
        // this check will also catch non-number vals.
        if (paths[path] <= 0) {
          continue;
        }
        ret.add(path);
      }
      return ret;
    },

    // called on the root node of a chain to setup watchers on the specified
    // path.
    add: function (path) {
      var paths = this._paths;
      paths[path] = (paths[path] || 0) + 1;

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.chain(key, tail);
    },

    // called on the root node of a chain to teardown watcher on the specified
    // path
    remove: function (path) {
      var paths = this._paths;
      if (paths[path] > 0) {
        paths[path]--;
      }

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.unchain(key, tail);
    },

    chain: function (key, path) {
      var chains = this._chains;
      var node = undefined;
      if (chains === undefined) {
        chains = this._chains = new _emberMetalEmpty_object.default();
      } else {
        node = chains[key];
      }

      if (node === undefined) {
        node = chains[key] = new ChainNode(this, key, undefined);
      }

      node.count++; // count chains...

      // chain rest of path if there is one
      if (path) {
        key = firstKey(path);
        path = path.slice(key.length + 1);
        node.chain(key, path);
      }
    },

    unchain: function (key, path) {
      var chains = this._chains;
      var node = chains[key];

      // unchain rest of path first...
      if (path && path.length > 1) {
        var nextKey = firstKey(path);
        var nextPath = path.slice(nextKey.length + 1);
        node.unchain(nextKey, nextPath);
      }

      // delete node if needed.
      node.count--;
      if (node.count <= 0) {
        chains[node._key] = undefined;
        node.destroy();
      }
    },

    notify: function (revalidate, affected) {
      if (revalidate && this._watching) {
        var obj = this._parent.value();
        if (obj !== this._object) {
          removeChainWatcher(this._object, this._key, this);
          this._object = obj;
          addChainWatcher(obj, this._key, this);
        }
        this._value = undefined;
      }

      // then notify chains...
      var chains = this._chains;
      var node = undefined;
      if (chains) {
        for (var key in chains) {
          node = chains[key];
          if (node !== undefined) {
            node.notify(revalidate, affected);
          }
        }
      }

      if (affected && this._parent) {
        this._parent.populateAffected(this._key, 1, affected);
      }
    },

    populateAffected: function (path, depth, affected) {
      if (this._key) {
        path = this._key + '.' + path;
      }

      if (this._parent) {
        this._parent.populateAffected(path, depth + 1, affected);
      } else {
        if (depth > 1) {
          affected.push(this.value(), path);
        }
      }
    }
  };

  function finishChains(obj) {
    // We only create meta if we really have to
    var m = _emberMetalMeta.peekMeta(obj);
    if (m) {
      m = _emberMetalMeta.meta(obj);

      // finish any current chains node watchers that reference obj
      var chainWatchers = m.readableChainWatchers();
      if (chainWatchers) {
        chainWatchers.revalidateAll();
      }
      // ensure that if we have inherited any chains they have been
      // copied onto our own meta.
      if (m.readableChains()) {
        m.writableChains(_emberMetalWatch_path.makeChainNode);
      }
    }
  }

  exports.removeChainWatcher = removeChainWatcher;
  exports.ChainNode = ChainNode;
})(Em._e[51],Em._e[30],Em._e[14],Em._e[49],Em._e[12],Em._e[50]);
(function (exports, _emberMetalChains, _emberMetalWatch_key, _emberMetalWatch_path, _emberMetalPath_cache, _emberMetalMeta) {
  /**
  @module ember-metal
  */

  'use strict';

  exports.isWatching = isWatching;
  exports.watcherCount = watcherCount;
  exports.unwatch = unwatch;
  exports.destroy = destroy;

  /**
    Starts watching a property on an object. Whenever the property changes,
    invokes `Ember.propertyWillChange` and `Ember.propertyDidChange`. This is the
    primitive used by observers and dependent keys; usually you will never call
    this method directly but instead use higher level methods like
    `Ember.addObserver()`
  
    @private
    @method watch
    @for Ember
    @param obj
    @param {String} _keyPath
  */
  function watch(obj, _keyPath, m) {
    if (!_emberMetalPath_cache.isPath(_keyPath)) {
      _emberMetalWatch_key.watchKey(obj, _keyPath, m);
    } else {
      _emberMetalWatch_path.watchPath(obj, _keyPath, m);
    }
  }

  exports.watch = watch;

  function isWatching(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    return (meta && meta.peekWatching(key)) > 0;
  }

  function watcherCount(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    return meta && meta.peekWatching(key) || 0;
  }

  function unwatch(obj, _keyPath, m) {
    if (!_emberMetalPath_cache.isPath(_keyPath)) {
      _emberMetalWatch_key.unwatchKey(obj, _keyPath, m);
    } else {
      _emberMetalWatch_path.unwatchPath(obj, _keyPath, m);
    }
  }

  var NODE_STACK = [];

  /**
    Tears down the meta on an object so that it can be garbage collected.
    Multiple calls will have no effect.
  
    @method destroy
    @for Ember
    @param {Object} obj  the object to destroy
    @return {void}
    @private
  */

  function destroy(obj) {
    var meta = _emberMetalMeta.peekMeta(obj);
    var node = undefined,
        nodes = undefined,
        key = undefined,
        nodeObject = undefined;

    if (meta) {
      _emberMetalMeta.deleteMeta(obj);
      // remove chainWatchers to remove circular references that would prevent GC
      node = meta.readableChains();
      if (node) {
        NODE_STACK.push(node);
        // process tree
        while (NODE_STACK.length > 0) {
          node = NODE_STACK.pop();
          // push children
          nodes = node._chains;
          if (nodes) {
            for (key in nodes) {
              if (nodes[key] !== undefined) {
                NODE_STACK.push(nodes[key]);
              }
            }
          }
          // remove chainWatcher in node object
          if (node._watching) {
            nodeObject = node._object;
            if (nodeObject) {
              _emberMetalChains.removeChainWatcher(nodeObject, node._key, node);
            }
          }
        }
      }
    }
  }
})(Em._e[52],Em._e[51],Em._e[49],Em._e[50],Em._e[29],Em._e[14]);
(function (exports, _emberMetalWatching, _emberMetalEvents) {
  'use strict';

  exports.addObserver = addObserver;
  exports.observersFor = observersFor;
  exports.removeObserver = removeObserver;
  exports._addBeforeObserver = _addBeforeObserver;
  exports._suspendObserver = _suspendObserver;
  exports._suspendObservers = _suspendObservers;
  exports._removeBeforeObserver = _removeBeforeObserver;

  /**
  @module ember-metal
  */

  var AFTER_OBSERVERS = ':change';
  var BEFORE_OBSERVERS = ':before';

  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }

  function beforeEvent(keyName) {
    return keyName + BEFORE_OBSERVERS;
  }

  /**
    @method addObserver
    @for Ember
    @param obj
    @param {String} _path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function addObserver(obj, _path, target, method) {
    _emberMetalEvents.addListener(obj, changeEvent(_path), target, method);
    _emberMetalWatching.watch(obj, _path);

    return this;
  }

  function observersFor(obj, path) {
    return _emberMetalEvents.listenersFor(obj, changeEvent(path));
  }

  /**
    @method removeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */

  function removeObserver(obj, path, target, method) {
    _emberMetalWatching.unwatch(obj, path);
    _emberMetalEvents.removeListener(obj, changeEvent(path), target, method);

    return this;
  }

  /**
    @method _addBeforeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */

  function _addBeforeObserver(obj, path, target, method) {
    _emberMetalEvents.addListener(obj, beforeEvent(path), target, method);
    _emberMetalWatching.watch(obj, path);

    return this;
  }

  // Suspend observer during callback.
  //
  // This should only be used by the target of the observer
  // while it is setting the observed path.

  function _suspendObserver(obj, path, target, method, callback) {
    return _emberMetalEvents.suspendListener(obj, changeEvent(path), target, method, callback);
  }

  function _suspendObservers(obj, paths, target, method, callback) {
    var events = paths.map(changeEvent);
    return _emberMetalEvents.suspendListeners(obj, events, target, method, callback);
  }

  /**
    @method removeBeforeObserver
    @for Ember
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */

  function _removeBeforeObserver(obj, path, target, method) {
    _emberMetalWatching.unwatch(obj, path);
    _emberMetalEvents.removeListener(obj, beforeEvent(path), target, method);

    return this;
  }
})(Em._e[53],Em._e[52],Em._e[15]);
(function (exports, _emberMetalAssign) {
  'use strict';

  exports.default = Subscriber;

  /**
    @module ember-metal
  */

  /**
    @private
    @class Subscriber
    @namespace Ember.streams
    @constructor
  */

  function Subscriber(callback, context) {
    this.next = null;
    this.prev = null;
    this.callback = callback;
    this.context = context;
  }

  _emberMetalAssign.default(Subscriber.prototype, {
    removeFrom: function (stream) {
      var next = this.next;
      var prev = this.prev;

      if (prev) {
        prev.next = next;
      } else {
        stream.subscriberHead = next;
      }

      if (next) {
        next.prev = prev;
      } else {
        stream.subscriberTail = prev;
      }

      stream.maybeDeactivate();
    }
  });
})(Em._e[54],Em._e[8]);
(function (exports, _emberMetalDebug, _emberMetalAssign, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = Dependency;

  /**
    @module ember-metal
  */

  /**
    @private
    @class Dependency
    @namespace Ember.streams
    @constructor
  */

  function Dependency(depender, dependee) {

    this.next = null;
    this.prev = null;
    this.depender = depender;
    this.dependee = dependee;
    this.unsubscription = null;
  }

  _emberMetalAssign.default(Dependency.prototype, {
    subscribe: function () {

      this.unsubscription = _emberHtmlbarsStreamsUtils.subscribe(this.dependee, this.depender.notify, this.depender);
    },

    unsubscribe: function () {
      if (this.unsubscription) {
        this.unsubscription();
        this.unsubscription = null;
      }
    },

    replace: function (dependee) {
      if (this.dependee !== dependee) {
        this.dependee = dependee;

        if (this.unsubscription) {
          this.unsubscribe();
          this.subscribe();
        }
        return true;
      }
      return false;
    },

    getValue: function () {
      return _emberHtmlbarsStreamsUtils.read(this.dependee);
    },

    setValue: function (value) {
      return _emberHtmlbarsStreamsUtils.setValue(this.dependee, value);
    }

    // destroy() {
    //   var next = this.next;
    //   var prev = this.prev;

    //   if (prev) {
    //     prev.next = next;
    //   } else {
    //     this.depender.dependencyHead = next;
    //   }

    //   if (next) {
    //     next.prev = prev;
    //   } else {
    //     this.depender.dependencyTail = prev;
    //   }

    //   this.unsubscribe();
    // }
  });
})(Em._e[55],Em._e[0],Em._e[8],Em._e[66]);
(function (exports, _emberMetalAssign, _emberMetalDebug, _emberMetalPath_cache, _emberMetalObserver, _emberHtmlbarsStreamsUtils, _emberMetalEmpty_object, _emberHtmlbarsStreamsSubscriber, _emberHtmlbarsStreamsDependency, _emberMetalUtils, _require, _emberMetalSymbol) {
  'use strict';

  exports.default = BasicStream;
  exports.wrap = wrap;
  var IS_STREAM = _emberMetalSymbol.default('IS_STREAM');

  exports.IS_STREAM = IS_STREAM;
  /**
    @module ember-metal
  */

  /**
    @private
    @class Stream
    @namespace Ember.stream
    @constructor
  */

  function BasicStream(label) {
    this._init(label);
  }

  // lazy
  var KeyStream = undefined;
  var ProxyMixin = undefined;

  BasicStream.prototype = {
    _init: function (label) {
      this[IS_STREAM] = true;
      this.label = makeLabel(label);
      this.isActive = false;
      this.isDirty = true;
      this.isDestroyed = false;
      this.cache = undefined;
      this.children = undefined;
      this.subscriberHead = null;
      this.subscriberTail = null;
      this.dependencyHead = null;
      this.dependencyTail = null;
      this.observedProxy = null;
      this.__ember_meta__ = null;
      this[_emberMetalUtils.GUID_KEY] = null;
    },

    _makeChildStream: function (key) {
      KeyStream = KeyStream || _require.default('ember-htmlbars/streams/key-stream').default;
      return new KeyStream(this, key);
    },

    removeChild: function (key) {
      delete this.children[key];
    },

    getKey: function (key) {
      if (this.children === undefined) {
        this.children = new _emberMetalEmpty_object.default();
      }

      var keyStream = this.children[key];

      if (keyStream === undefined) {
        keyStream = this._makeChildStream(key);
        this.children[key] = keyStream;
      }

      return keyStream;
    },

    get: function (path) {
      var firstKey = _emberMetalPath_cache.getFirstKey(path);
      var tailPath = _emberMetalPath_cache.getTailPath(path);

      if (this.children === undefined) {
        this.children = new _emberMetalEmpty_object.default();
      }

      var keyStream = this.children[firstKey];

      if (keyStream === undefined) {
        keyStream = this._makeChildStream(firstKey, path);
        this.children[firstKey] = keyStream;
      }

      if (tailPath === undefined) {
        return keyStream;
      } else {
        return keyStream.get(tailPath);
      }
    },

    value: function () {
      // TODO: Ensure value is never called on a destroyed stream
      // so that we can uncomment this assertion.
      //
      // assert("Stream error: value was called after the stream was destroyed", !this.isDestroyed);

      // TODO: Remove this block. This will require ensuring we are
      // not treating streams as "volatile" anywhere.
      if (!this.isActive) {
        this.isDirty = true;
      }

      var willRevalidate = false;

      if (!this.isActive && this.subscriberHead) {
        this.activate();
        willRevalidate = true;
      }

      if (this.isDirty) {
        if (this.isActive) {
          willRevalidate = true;
        }

        this.cache = this.compute();
        this.isDirty = false;
      }

      if (willRevalidate) {
        this.revalidate(this.cache);
      }

      return this.cache;
    },

    addMutableDependency: function (object) {
      var dependency = new _emberHtmlbarsStreamsDependency.default(this, object);

      if (this.isActive) {
        dependency.subscribe();
      }

      if (this.dependencyHead === null) {
        this.dependencyHead = this.dependencyTail = dependency;
      } else {
        var tail = this.dependencyTail;
        tail.next = dependency;
        dependency.prev = tail;
        this.dependencyTail = dependency;
      }

      return dependency;
    },

    addDependency: function (object) {
      if (_emberHtmlbarsStreamsUtils.isStream(object)) {
        this.addMutableDependency(object);
      }
    },

    subscribeDependencies: function () {
      var dependency = this.dependencyHead;
      while (dependency) {
        var next = dependency.next;
        dependency.subscribe();
        dependency = next;
      }
    },

    unsubscribeDependencies: function () {
      var dependency = this.dependencyHead;
      while (dependency) {
        var next = dependency.next;
        dependency.unsubscribe();
        dependency = next;
      }
    },

    maybeDeactivate: function () {
      if (!this.subscriberHead && this.isActive) {
        this.isActive = false;
        this.unsubscribeDependencies();
        this.deactivate();
      }
    },

    activate: function () {
      this.isActive = true;
      this.subscribeDependencies();
    },

    revalidate: function (value) {
      if (value !== this.observedProxy) {
        this._clearObservedProxy();

        ProxyMixin = ProxyMixin || _require.default('ember-runtime/mixins/-proxy').default;

        if (ProxyMixin.detect(value)) {
          _emberMetalObserver.addObserver(value, 'content', this, this.notify);
          this.observedProxy = value;
        }
      }
    },

    _clearObservedProxy: function () {
      if (this.observedProxy) {
        _emberMetalObserver.removeObserver(this.observedProxy, 'content', this, this.notify);
        this.observedProxy = null;
      }
    },

    deactivate: function () {
      this._clearObservedProxy();
    },

    compute: function () {
      throw new Error('Stream error: compute not implemented');
    },

    setValue: function () {
      throw new Error('Stream error: setValue not implemented');
    },

    notify: function () {
      this.notifyExcept();
    },

    notifyExcept: function (callbackToSkip, contextToSkip) {
      if (!this.isDirty) {
        this.isDirty = true;
        this.notifySubscribers(callbackToSkip, contextToSkip);
      }
    },

    subscribe: function (callback, context) {

      var subscriber = new _emberHtmlbarsStreamsSubscriber.default(callback, context, this);
      if (this.subscriberHead === null) {
        this.subscriberHead = this.subscriberTail = subscriber;
      } else {
        var tail = this.subscriberTail;
        tail.next = subscriber;
        subscriber.prev = tail;
        this.subscriberTail = subscriber;
      }

      var stream = this;
      return function (prune) {
        subscriber.removeFrom(stream);
        if (prune) {
          stream.prune();
        }
      };
    },

    prune: function () {
      if (this.subscriberHead === null) {
        this.destroy(true);
      }
    },

    unsubscribe: function (callback, context) {
      var subscriber = this.subscriberHead;

      while (subscriber) {
        var next = subscriber.next;
        if (subscriber.callback === callback && subscriber.context === context) {
          subscriber.removeFrom(this);
        }
        subscriber = next;
      }
    },

    notifySubscribers: function (callbackToSkip, contextToSkip) {
      var subscriber = this.subscriberHead;

      while (subscriber) {
        var next = subscriber.next;

        var callback = subscriber.callback;
        var context = subscriber.context;

        subscriber = next;

        if (callback === callbackToSkip && context === contextToSkip) {
          continue;
        }

        if (context === undefined) {
          callback(this);
        } else {
          callback.call(context, this);
        }
      }
    },

    destroy: function (prune) {
      if (!this.isDestroyed) {
        this.isDestroyed = true;

        this.subscriberHead = this.subscriberTail = null;
        this.maybeDeactivate();

        var dependencies = this.dependencies;

        if (dependencies) {
          for (var i = 0; i < dependencies.length; i++) {
            dependencies[i](prune);
          }
        }

        return true;
      }
    }
  };

  BasicStream.extend = function (object) {
    var Child = function () {
      this._init();
      this.init.apply(this, arguments);
    };

    Child.prototype = Object.create(this.prototype);

    _emberMetalAssign.default(Child.prototype, object);
    Child.extend = BasicStream.extend;
    return Child;
  };

  var Stream = BasicStream.extend({
    init: function (fn, label) {
      this._compute = fn;
      this.label = label;
    },

    compute: function () {
      return this._compute();
    }
  });

  exports.Stream = Stream;

  function wrap(value, Kind, param) {
    if (_emberHtmlbarsStreamsUtils.isStream(value)) {
      return value;
    } else {
      return new Kind(value, param);
    }
  }

  function makeLabel(label) {
    if (label === undefined) {
      return '(no label)';
    } else {
      return label;
    }
  }
})(Em._e[56],Em._e[8],Em._e[0],Em._e[29],Em._e[53],Em._e[66],Em._e[12],Em._e[54],Em._e[55],Em._e[7],Em.__loader.require,Em._e[13]);
(function (exports, _emberMetalDebug) {
  'use strict';

  exports.default = expandProperties;

  /**
  @module ember
  @submodule ember-metal
  */

  var SPLIT_REGEX = /\{|\}/;
  var END_WITH_EACH_REGEX = /\.@each$/;

  /**
    Expands `pattern`, invoking `callback` for each expansion.
  
    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.
  
    Example
  
    ```js
    function echo(arg){ console.log(arg); }
  
    Ember.expandProperties('foo.bar', echo);              //=> 'foo.bar'
    Ember.expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    Ember.expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    Ember.expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    Ember.expandProperties('foo.{bar,baz}.[]', echo)      //=> 'foo.bar.[]', 'foo.baz.[]'
    Ember.expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    Ember.expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```
  
    @method expandProperties
    @for Ember
    @private
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
  */

  function expandProperties(pattern, callback) {

    var parts = pattern.split(SPLIT_REGEX);
    var properties = [parts];

    for (var i = 0; i < parts.length; i++) {
      var part = parts[i];
      if (part.indexOf(',') >= 0) {
        properties = duplicateAndReplace(properties, part.split(','), i);
      }
    }

    for (var i = 0; i < properties.length; i++) {
      callback(properties[i].join('').replace(END_WITH_EACH_REGEX, '.[]'));
    }
  }

  function duplicateAndReplace(properties, currentParts, index) {
    var all = [];

    properties.forEach(function (property) {
      currentParts.forEach(function (part) {
        var current = property.slice(0);
        current[index] = part;
        all.push(current);
      });
    });

    return all;
  }
})(Em._e[57],Em._e[0]);
(function (exports, _emberMetalWatching) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  exports.addDependentKeys = addDependentKeys;
  exports.removeDependentKeys = removeDependentKeys;

  /**
  @module ember
  @submodule ember-metal
  */

  // ..........................................................
  // DEPENDENT KEYS
  //

  function addDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // add all of its dependent keys.
    var idx = undefined,
        depKey = undefined;
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    for (idx = 0; idx < depKeys.length; idx++) {
      depKey = depKeys[idx];
      // Increment the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) + 1);
      // Watch the depKey
      _emberMetalWatching.watch(obj, depKey, meta);
    }
  }

  function removeDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // remove all of its dependent keys.
    var depKeys = desc._dependentKeys;
    if (!depKeys) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx];
      // Decrement the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) - 1);
      // Unwatch the depKey
      _emberMetalWatching.unwatch(obj, depKey, meta);
    }
  }
})(Em._e[58],Em._e[52]);
(function (exports, _emberMetalDebug, _emberMetalProperty_set, _emberMetalUtils, _emberMetalMeta, _emberMetalExpand_properties, _emberMetalError, _emberMetalProperties, _emberMetalProperty_events, _emberMetalDependent_keys) {
  'use strict';

  exports.default = computed;

  /**
  @module ember
  @submodule ember-metal
  */

  function UNDEFINED() {}

  var DEEP_EACH_REGEX = /\.@each\.[^.]+\./;

  /**
    A computed property transforms an object literal with object's accessor function(s) into a property.
  
    By default the function backing the computed property will only be called
    once and the result will be cached. You can specify various properties
    that your computed property depends on. This will force the cached
    result to be recomputed if the dependencies are modified.
  
    In the following example we declare a computed property - `fullName` - by calling
    `.Ember.computed()` with property dependencies (`firstName` and `lastName`) as leading arguments and getter accessor function. The `fullName` getter function
    will be called once (regardless of how many times it is accessed) as long
    as its dependencies have not changed. Once `firstName` or `lastName` are updated
    any future calls (or anything bound) to `fullName` will incorporate the new
    values.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', function() {
        let firstName = this.get('firstName'),
            lastName  = this.get('lastName');
  
        return firstName + ' ' + lastName;
      })
    });
  
    let tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });
  
    tom.get('fullName') // 'Tom Dale'
    ```
  
    You can also define what Ember should do when setting a computed property by providing additional function (`set`) in hash argument.
    If you try to set a computed property, it will try to invoke setter accessor function with the key and
    value you want to set it to as arguments.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName'),
              lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          this.set('firstName', firstName);
          this.set('lastName', lastName);
  
          return value;
        }
      })
    });
  
    let person = Person.create();
  
    person.set('fullName', 'Peter Wagenet');
    person.get('firstName'); // 'Peter'
    person.get('lastName');  // 'Wagenet'
    ```
  
    You can overwrite computed property with normal property (no longer computed), that won't change if dependencies change, if you set computed property and it won't have setter accessor function defined.
  
    You can also mark computed property as `.readOnly()` and block all attempts to set it.
  
    ```javascript
    let Person = Ember.Object.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName');
          let lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        }
      }).readOnly()
    });
  
    let person = Person.create();
    person.set('fullName', 'Peter Wagenet'); // Uncaught Error: Cannot set read-only property "fullName" on object: <(...):emberXXX>
    ```
  
    Additional resources:
    - [New CP syntax RFC](https://github.com/emberjs/rfcs/blob/master/text/0011-improved-cp-syntax.md)
    - [New computed syntax explained in "Ember 1.12 released" ](http://emberjs.com/blog/2015/05/13/ember-1-12-released.html#toc_new-computed-syntax)
  
    @class ComputedProperty
    @namespace Ember
    @public
  */
  function ComputedProperty(config, opts) {
    this.isDescriptor = true;
    if (typeof config === 'function') {
      this._getter = config;
    } else {
      this._getter = config.get;
      this._setter = config.set;
    }

    this._dependentKeys = undefined;
    this._suspended = undefined;
    this._meta = undefined;
    this._volatile = false;
    this._dependentKeys = opts && opts.dependentKeys;
    this._readOnly = false;
  }

  ComputedProperty.prototype = new _emberMetalProperties.Descriptor();

  var ComputedPropertyPrototype = ComputedProperty.prototype;

  /**
    Call on a computed property to set it into non-cached mode. When in this
    mode the computed property will not automatically cache the return value.
  
    It also does not automatically fire any change events. You must manually notify
    any changes if you want to observe this property.
  
    Dependency keys have no effect on volatile properties as they are for cache
    invalidation and notification when cached value is invalidated.
  
    ```javascript
    let outsideService = Ember.Object.extend({
      value: Ember.computed(function() {
        return OutsideService.getValue();
      }).volatile()
    }).create();
    ```
  
    @method volatile
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.volatile = function () {
    this._volatile = true;
    return this;
  };

  /**
    Call on a computed property to set it into read-only mode. When in this
    mode the computed property will throw an error when set.
  
    ```javascript
    let Person = Ember.Object.extend({
      guid: Ember.computed(function() {
        return 'guid-guid-guid';
      }).readOnly()
    });
  
    let person = Person.create();
  
    person.set('guid', 'new-guid'); // will throw an exception
    ```
  
    @method readOnly
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.readOnly = function () {
    this._readOnly = true;

    return this;
  };

  /**
    Sets the dependent keys on this computed property. Pass any number of
    arguments containing key paths that this computed property depends on.
  
    ```javascript
    let President = Ember.Object.extend({
      fullName: Ember.computed(function() {
        return this.get('firstName') + ' ' + this.get('lastName');
  
        // Tell Ember that this computed property depends on firstName
        // and lastName
      }).property('firstName', 'lastName')
    });
  
    let president = President.create({
      firstName: 'Barack',
      lastName: 'Obama'
    });
  
    president.get('fullName'); // 'Barack Obama'
    ```
  
    @method property
    @param {String} path* zero or more property paths
    @return {Ember.ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.property = function () {
    var args = [];

    function addArg(property) {
      args.push(property);
    }

    for (var i = 0; i < arguments.length; i++) {
      _emberMetalExpand_properties.default(arguments[i], addArg);
    }

    this._dependentKeys = args;
    return this;
  };

  /**
    In some cases, you may want to annotate computed properties with additional
    metadata about how they function or what values they operate on. For example,
    computed property functions may close over variables that are then no longer
    available for introspection.
  
    You can pass a hash of these values to a computed property like this:
  
    ```
    person: Ember.computed(function() {
      let personId = this.get('personId');
      return App.Person.create({ id: personId });
    }).meta({ type: App.Person })
    ```
  
    The hash that you pass to the `meta()` function will be saved on the
    computed property descriptor under the `_meta` key. Ember runtime
    exposes a public API for retrieving these values from classes,
    via the `metaForProperty()` function.
  
    @method meta
    @param {Object} meta
    @chainable
    @public
  */
  ComputedPropertyPrototype.meta = function (meta) {
    if (arguments.length === 0) {
      return this._meta || {};
    } else {
      this._meta = meta;
      return this;
    }
  };

  // invalidate cache when CP key changes
  ComputedPropertyPrototype.didChange = function (obj, keyName) {
    // _suspended is set via a CP.set to ensure we don't clear
    // the cached value set by the setter
    if (this._volatile || this._suspended === obj) {
      return;
    }

    // don't create objects just to invalidate
    var meta = _emberMetalMeta.peekMeta(obj);
    if (!meta || meta.source !== obj) {
      return;
    }

    var cache = meta.readableCache();
    if (cache && cache[keyName] !== undefined) {
      cache[keyName] = undefined;
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
    }
  };

  ComputedPropertyPrototype.get = function (obj, keyName) {
    if (this._volatile) {
      return this._getter.call(obj, keyName);
    }

    var meta = _emberMetalMeta.meta(obj);
    var cache = meta.writableCache();

    var result = cache[keyName];
    if (result === UNDEFINED) {
      return undefined;
    } else if (result !== undefined) {
      return result;
    }

    var ret = this._getter.call(obj, keyName);
    if (ret === undefined) {
      cache[keyName] = UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    var chainWatchers = meta.readableChainWatchers();
    if (chainWatchers) {
      chainWatchers.revalidate(keyName);
    }
    _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);

    return ret;
  };

  ComputedPropertyPrototype.set = function computedPropertySetEntry(obj, keyName, value) {
    if (this._readOnly) {
      this._throwReadOnlyError(obj, keyName);
    }

    if (!this._setter) {
      return this.clobberSet(obj, keyName, value);
    }

    if (this._volatile) {
      return this.volatileSet(obj, keyName, value);
    }

    return this.setWithSuspend(obj, keyName, value);
  };

  ComputedPropertyPrototype._throwReadOnlyError = function computedPropertyThrowReadOnlyError(obj, keyName) {
    throw new _emberMetalError.default('Cannot set read-only property "' + keyName + '" on object: ' + _emberMetalUtils.inspect(obj));
  };

  ComputedPropertyPrototype.clobberSet = function computedPropertyClobberSet(obj, keyName, value) {
    var cachedValue = cacheFor(obj, keyName);
    _emberMetalProperties.defineProperty(obj, keyName, null, cachedValue);
    _emberMetalProperty_set.set(obj, keyName, value);
    return value;
  };

  ComputedPropertyPrototype.volatileSet = function computedPropertyVolatileSet(obj, keyName, value) {
    return this._setter.call(obj, keyName, value);
  };

  ComputedPropertyPrototype.setWithSuspend = function computedPropertySetWithSuspend(obj, keyName, value) {
    var oldSuspended = this._suspended;
    this._suspended = obj;
    try {
      return this._set(obj, keyName, value);
    } finally {
      this._suspended = oldSuspended;
    }
  };

  ComputedPropertyPrototype._set = function computedPropertySet(obj, keyName, value) {
    // cache requires own meta
    var meta = _emberMetalMeta.meta(obj);
    // either there is a writable cache or we need one to update
    var cache = meta.writableCache();
    var hadCachedValue = false;
    var cachedValue = undefined;
    if (cache[keyName] !== undefined) {
      if (cache[keyName] !== UNDEFINED) {
        cachedValue = cache[keyName];
      }
      hadCachedValue = true;
    }

    var ret = this._setter.call(obj, keyName, value, cachedValue);

    // allows setter to return the same value that is cached already
    if (hadCachedValue && cachedValue === ret) {
      return ret;
    }

    _emberMetalProperty_events.propertyWillChange(obj, keyName);

    if (hadCachedValue) {
      cache[keyName] = undefined;
    }

    if (!hadCachedValue) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, meta);
    }

    if (ret === undefined) {
      cache[keyName] = UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    _emberMetalProperty_events.propertyDidChange(obj, keyName);

    return ret;
  };

  /* called before property is overridden */
  ComputedPropertyPrototype.teardown = function (obj, keyName) {
    if (this._volatile) {
      return;
    }
    var meta = _emberMetalMeta.meta(obj);
    var cache = meta.readableCache();
    if (cache && cache[keyName] !== undefined) {
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, meta);
      cache[keyName] = undefined;
    }
  };

  /**
    This helper returns a new property descriptor that wraps the passed
    computed property function. You can use this helper to define properties
    with mixins or via `Ember.defineProperty()`.
  
    If you pass a function as an argument, it will be used as a getter. A computed
    property defined in this way might look like this:
  
    ```js
    let Person = Ember.Object.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: Ember.computed('firstName', 'lastName', function() {
        return `${this.get('firstName')} ${this.get('lastName')}`;
      })
    });
  
    let client = Person.create();
  
    client.get('fullName'); // 'Betty Jones'
  
    client.set('lastName', 'Fuller');
    client.get('fullName'); // 'Betty Fuller'
    ```
  
    You can pass a hash with two functions, `get` and `set`, as an
    argument to provide both a getter and setter:
  
    ```js
    let Person = Ember.Object.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: Ember.computed('firstName', 'lastName', {
        get(key) {
          return `${this.get('firstName')} ${this.get('lastName')}`;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(/\s+/);
          this.setProperties({ firstName, lastName });
          return value;
        }
      });
    })
  
    let client = Person.create();
    client.get('firstName'); // 'Betty'
  
    client.set('fullName', 'Carroll Fuller');
    client.get('firstName'); // 'Carroll'
    ```
  
    The `set` function should accept two parameters, `key` and `value`. The value
    returned from `set` will be the new value of the property.
  
    _Note: This is the preferred way to define computed properties when writing third-party
    libraries that depend on or use Ember, since there is no guarantee that the user
    will have [prototype Extensions](http://emberjs.com/guides/configuring-ember/disabling-prototype-extensions/) enabled._
  
    The alternative syntax, with prototype extensions, might look like:
  
    ```js
    fullName: function() {
      return this.get('firstName') + ' ' + this.get('lastName');
    }.property('firstName', 'lastName')
    ```
  
    @class computed
    @namespace Ember
    @constructor
    @static
    @param {String} [dependentKeys*] Optional dependent keys that trigger this computed property.
    @param {Function} func The computed property function.
    @return {Ember.ComputedProperty} property descriptor instance
    @public
  */

  function computed(func) {
    var args = undefined;

    if (arguments.length > 1) {
      args = [].slice.call(arguments);
      func = args.pop();
    }

    var cp = new ComputedProperty(func);

    if (args) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

  /**
    Returns the cached value for a property, if one exists.
    This can be useful for peeking at the value of a computed
    property that is generated lazily, without accidentally causing
    it to be created.
  
    @method cacheFor
    @for Ember
    @param {Object} obj the object whose property you want to check
    @param {String} key the name of the property whose cached value you want
      to return
    @return {Object} the cached value
    @public
  */
  function cacheFor(obj, key) {
    var meta = _emberMetalMeta.peekMeta(obj);
    var cache = meta && meta.source === obj && meta.readableCache();
    var ret = cache && cache[key];

    if (ret === UNDEFINED) {
      return undefined;
    }
    return ret;
  }

  cacheFor.set = function (cache, key, value) {
    if (value === undefined) {
      cache[key] = UNDEFINED;
    } else {
      cache[key] = value;
    }
  };

  cacheFor.get = function (cache, key) {
    var ret = cache[key];
    if (ret === UNDEFINED) {
      return undefined;
    }
    return ret;
  };

  cacheFor.remove = function (cache, key) {
    cache[key] = undefined;
  };

  exports.ComputedProperty = ComputedProperty;
  exports.computed = computed;
  exports.cacheFor = cacheFor;
})(Em._e[59],Em._e[0],Em._e[32],Em._e[7],Em._e[14],Em._e[57],Em._e[31],Em._e[48],Em._e[20],Em._e[58]);
(function (exports, _emberConsole, _emberEnvironment, _emberMetalRun_loop, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalUtils, _emberMetalEvents, _emberMetalObserver, _emberMetalPath_cache) {
  'use strict';

  exports.bind = bind;

  /**
  @module ember
  @submodule ember-metal
  */

  // ..........................................................
  // BINDING
  //

  function Binding(toPath, fromPath) {
    // Configuration
    this._from = fromPath;
    this._to = toPath;
    this._oneWay = undefined;

    // State
    this._direction = undefined;
    this._readyToSync = undefined;
    this._fromObj = undefined;
    this._fromPath = undefined;
    this._toObj = undefined;
  }

  /**
    @class Binding
    @namespace Ember
    @deprecated See http://emberjs.com/deprecations/v2.x#toc_ember-binding
    @public
  */

  Binding.prototype = {
    /**
      This copies the Binding so it can be connected to another object.
       @method copy
      @return {Ember.Binding} `this`
      @public
    */
    copy: function () {
      var copy = new Binding(this._to, this._from);
      if (this._oneWay) {
        copy._oneWay = true;
      }
      return copy;
    },

    // ..........................................................
    // CONFIG
    //

    /**
      This will set `from` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method from
      @param {String} path The property path to connect to.
      @return {Ember.Binding} `this`
      @public
    */
    from: function (path) {
      this._from = path;
      return this;
    },

    /**
      This will set the `to` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method to
      @param {String|Tuple} path A property path or tuple.
      @return {Ember.Binding} `this`
      @public
    */
    to: function (path) {
      this._to = path;
      return this;
    },

    /**
      Configures the binding as one way. A one-way binding will relay changes
      on the `from` side to the `to` side, but not the other way around. This
      means that if you change the `to` side directly, the `from` side may have
      a different value.
       @method oneWay
      @return {Ember.Binding} `this`
      @public
    */
    oneWay: function () {
      this._oneWay = true;
      return this;
    },

    /**
      @method toString
      @return {String} string representation of binding
      @public
    */
    toString: function () {
      var oneWay = this._oneWay ? '[oneWay]' : '';
      return 'Ember.Binding<' + _emberMetalUtils.guidFor(this) + '>(' + this._from + ' -> ' + this._to + ')' + oneWay;
    },

    // ..........................................................
    // CONNECT AND SYNC
    //

    /**
      Attempts to connect this binding instance so that it can receive and relay
      changes. This method will raise an exception if you have not set the
      from/to properties yet.
       @method connect
      @param {Object} obj The root object for this binding.
      @return {Ember.Binding} `this`
      @public
    */
    connect: function (obj) {

      var fromObj = undefined,
          fromPath = undefined,
          possibleGlobal = undefined;

      // If the binding's "from" path could be interpreted as a global, verify
      // whether the path refers to a global or not by consulting `Ember.lookup`.
      if (_emberMetalPath_cache.isGlobalPath(this._from)) {
        var _name = _emberMetalPath_cache.getFirstKey(this._from);
        possibleGlobal = _emberEnvironment.context.lookup[_name];

        if (possibleGlobal) {
          fromObj = possibleGlobal;
          fromPath = _emberMetalPath_cache.getTailPath(this._from);
        }
      }

      if (fromObj === undefined) {
        fromObj = obj;
        fromPath = this._from;
      }

      _emberMetalProperty_set.trySet(obj, this._to, _emberMetalProperty_get.get(fromObj, fromPath));

      // Add an observer on the object to be notified when the binding should be updated.
      _emberMetalObserver.addObserver(fromObj, fromPath, this, 'fromDidChange');

      // If the binding is a two-way binding, also set up an observer on the target.
      if (!this._oneWay) {
        _emberMetalObserver.addObserver(obj, this._to, this, 'toDidChange');
      }

      _emberMetalEvents.addListener(obj, 'willDestroy', this, 'disconnect');

      fireDeprecations(obj, this._to, this._from, possibleGlobal, this._oneWay, !possibleGlobal && !this._oneWay);

      this._readyToSync = true;
      this._fromObj = fromObj;
      this._fromPath = fromPath;
      this._toObj = obj;

      return this;
    },

    /**
      Disconnects the binding instance. Changes will no longer be relayed. You
      will not usually need to call this method.
       @method disconnect
      @return {Ember.Binding} `this`
      @public
    */
    disconnect: function () {

      // Remove an observer on the object so we're no longer notified of
      // changes that should update bindings.
      _emberMetalObserver.removeObserver(this._fromObj, this._fromPath, this, 'fromDidChange');

      // If the binding is two-way, remove the observer from the target as well.
      if (!this._oneWay) {
        _emberMetalObserver.removeObserver(this._toObj, this._to, this, 'toDidChange');
      }

      this._readyToSync = false; // Disable scheduled syncs...
      return this;
    },

    // ..........................................................
    // PRIVATE
    //

    /* Called when the from side changes. */
    fromDidChange: function (target) {
      this._scheduleSync('fwd');
    },

    /* Called when the to side changes. */
    toDidChange: function (target) {
      this._scheduleSync('back');
    },

    _scheduleSync: function (dir) {
      var existingDir = this._direction;

      // If we haven't scheduled the binding yet, schedule it.
      if (existingDir === undefined) {
        _emberMetalRun_loop.default.schedule('sync', this, '_sync');
        this._direction = dir;
      }

      // If both a 'back' and 'fwd' sync have been scheduled on the same object,
      // default to a 'fwd' sync so that it remains deterministic.
      if (existingDir === 'back' && dir === 'fwd') {
        this._direction = 'fwd';
      }
    },

    _sync: function () {
      var log = _emberEnvironment.ENV.LOG_BINDINGS;

      var toObj = this._toObj;

      // Don't synchronize destroyed objects or disconnected bindings.
      if (toObj.isDestroyed || !this._readyToSync) {
        return;
      }

      // Get the direction of the binding for the object we are
      // synchronizing from.
      var direction = this._direction;

      var fromObj = this._fromObj;
      var fromPath = this._fromPath;

      this._direction = undefined;

      // If we're synchronizing from the remote object...
      if (direction === 'fwd') {
        var fromValue = _emberMetalProperty_get.get(fromObj, fromPath);
        if (log) {
          _emberConsole.default.log(' ', this.toString(), '->', fromValue, fromObj);
        }
        if (this._oneWay) {
          _emberMetalProperty_set.trySet(toObj, this._to, fromValue);
        } else {
          _emberMetalObserver._suspendObserver(toObj, this._to, this, 'toDidChange', function () {
            _emberMetalProperty_set.trySet(toObj, this._to, fromValue);
          });
        }
        // If we're synchronizing *to* the remote object.
      } else if (direction === 'back') {
          var toValue = _emberMetalProperty_get.get(toObj, this._to);
          if (log) {
            _emberConsole.default.log(' ', this.toString(), '<-', toValue, toObj);
          }
          _emberMetalObserver._suspendObserver(fromObj, fromPath, this, 'fromDidChange', function () {
            _emberMetalProperty_set.trySet(fromObj, fromPath, toValue);
          });
        }
    }

  };

  function fireDeprecations(obj, toPath, fromPath, deprecateGlobal, deprecateOneWay, deprecateAlias) {
    var deprecateGlobalMessage = '`Ember.Binding` is deprecated. Since you' + ' are binding to a global consider using a service instead.';
    var deprecateOneWayMessage = '`Ember.Binding` is deprecated. Since you' + ' are using a `oneWay` binding consider using a `readOnly` computed' + ' property instead.';
    var deprecateAliasMessage = '`Ember.Binding` is deprecated. Consider' + ' using an `alias` computed property instead.';

    var objectInfo = 'The `' + toPath + '` property of `' + obj + '` is an `Ember.Binding` connected to `' + fromPath + '`, but ';
  }

  function mixinProperties(to, from) {
    for (var key in from) {
      if (from.hasOwnProperty(key)) {
        to[key] = from[key];
      }
    }
  }

  mixinProperties(Binding, {

    /*
      See `Ember.Binding.from`.
       @method from
      @static
    */
    from: function (from) {
      var C = this;
      return new C(undefined, from);
    },

    /*
      See `Ember.Binding.to`.
       @method to
      @static
    */
    to: function (to) {
      var C = this;
      return new C(to, undefined);
    }
  });
  /**
    An `Ember.Binding` connects the properties of two objects so that whenever
    the value of one property changes, the other property will be changed also.
  
    ## Automatic Creation of Bindings with `/^*Binding/`-named Properties.
  
    You do not usually create Binding objects directly but instead describe
    bindings in your class or object definition using automatic binding
    detection.
  
    Properties ending in a `Binding` suffix will be converted to `Ember.Binding`
    instances. The value of this property should be a string representing a path
    to another object or a custom binding instance created using Binding helpers
    (see "One Way Bindings"):
  
    ```
    valueBinding: "MyApp.someController.title"
    ```
  
    This will create a binding from `MyApp.someController.title` to the `value`
    property of your object instance automatically. Now the two values will be
    kept in sync.
  
    ## One Way Bindings
  
    One especially useful binding customization you can use is the `oneWay()`
    helper. This helper tells Ember that you are only interested in
    receiving changes on the object you are binding from. For example, if you
    are binding to a preference and you want to be notified if the preference
    has changed, but your object will not be changing the preference itself, you
    could do:
  
    ```
    bigTitlesBinding: Ember.Binding.oneWay("MyApp.preferencesController.bigTitles")
    ```
  
    This way if the value of `MyApp.preferencesController.bigTitles` changes the
    `bigTitles` property of your object will change also. However, if you
    change the value of your `bigTitles` property, it will not update the
    `preferencesController`.
  
    One way bindings are almost twice as fast to setup and twice as fast to
    execute because the binding only has to worry about changes to one side.
  
    You should consider using one way bindings anytime you have an object that
    may be created frequently and you do not intend to change a property; only
    to monitor it for changes (such as in the example above).
  
    ## Adding Bindings Manually
  
    All of the examples above show you how to configure a custom binding, but the
    result of these customizations will be a binding template, not a fully active
    Binding instance. The binding will actually become active only when you
    instantiate the object the binding belongs to. It is useful, however, to
    understand what actually happens when the binding is activated.
  
    For a binding to function it must have at least a `from` property and a `to`
    property. The `from` property path points to the object/key that you want to
    bind from while the `to` path points to the object/key you want to bind to.
  
    When you define a custom binding, you are usually describing the property
    you want to bind from (such as `MyApp.someController.value` in the examples
    above). When your object is created, it will automatically assign the value
    you want to bind `to` based on the name of your binding key. In the
    examples above, during init, Ember objects will effectively call
    something like this on your binding:
  
    ```javascript
    binding = Ember.Binding.from("valueBinding").to("value");
    ```
  
    This creates a new binding instance based on the template you provide, and
    sets the to path to the `value` property of the new object. Now that the
    binding is fully configured with a `from` and a `to`, it simply needs to be
    connected to become active. This is done through the `connect()` method:
  
    ```javascript
    binding.connect(this);
    ```
  
    Note that when you connect a binding you pass the object you want it to be
    connected to. This object will be used as the root for both the from and
    to side of the binding when inspecting relative paths. This allows the
    binding to be automatically inherited by subclassed objects as well.
  
    This also allows you to bind between objects using the paths you declare in
    `from` and `to`:
  
    ```javascript
    // Example 1
    binding = Ember.Binding.from("App.someObject.value").to("value");
    binding.connect(this);
  
    // Example 2
    binding = Ember.Binding.from("parentView.value").to("App.someObject.value");
    binding.connect(this);
    ```
  
    Now that the binding is connected, it will observe both the from and to side
    and relay changes.
  
    If you ever needed to do so (you almost never will, but it is useful to
    understand this anyway), you could manually create an active binding by
    using the `Ember.bind()` helper method. (This is the same method used by
    to setup your bindings on objects):
  
    ```javascript
    Ember.bind(MyApp.anotherObject, "value", "MyApp.someController.value");
    ```
  
    Both of these code fragments have the same effect as doing the most friendly
    form of binding creation like so:
  
    ```javascript
    MyApp.anotherObject = Ember.Object.create({
      valueBinding: "MyApp.someController.value",
  
      // OTHER CODE FOR THIS OBJECT...
    });
    ```
  
    Ember's built in binding creation method makes it easy to automatically
    create bindings for you. You should always use the highest-level APIs
    available, even if you understand how it works underneath.
  
    @class Binding
    @namespace Ember
    @since Ember 0.9
    @public
  */
  // Ember.Binding = Binding; ES6TODO: where to put this?

  /**
    Global helper method to create a new binding. Just pass the root object
    along with a `to` and `from` path to create and connect the binding.
  
    @method bind
    @for Ember
    @param {Object} obj The root object of the transform.
    @param {String} to The path to the 'to' side of the binding.
      Must be relative to obj.
    @param {String} from The path to the 'from' side of the binding.
      Must be relative to obj or a global path.
    @return {Ember.Binding} binding instance
    @public
  */

  function bind(obj, to, from) {
    return new Binding(to, from).connect(obj);
  }

  exports.Binding = Binding;
})(Em._e[60],Em._e[5],Em._e[4],Em._e[27],Em._e[0],Em._e[30],Em._e[32],Em._e[7],Em._e[15],Em._e[53],Em._e[29]);
(function (exports, _emberMetalError, _emberMetalDebug, _emberMetalAssign, _emberMetalUtils, _emberMetalMeta, _emberMetalExpand_properties, _emberMetalProperties, _emberMetalComputed, _emberMetalBinding, _emberMetalObserver, _emberMetalEvents) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  /**
  @module ember
  @submodule ember-metal
  */
  exports.detectBinding = detectBinding;
  exports.mixin = mixin;
  exports.default = Mixin;
  exports.hasUnprocessedMixins = hasUnprocessedMixins;
  exports.clearUnprocessedMixins = clearUnprocessedMixins;
  exports.required = required;
  exports.aliasMethod = aliasMethod;
  exports.observer = observer;
  exports._immediateObserver = _immediateObserver;
  exports._beforeObserver = _beforeObserver;

  function ROOT() {}
  ROOT.__hasSuper = false;

  var a_slice = [].slice;

  function isMethod(obj) {
    return 'function' === typeof obj && obj.isMethod !== false && obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
  }

  var CONTINUE = {};

  function mixinProperties(mixinsMeta, mixin) {
    var guid = undefined;

    if (mixin instanceof Mixin) {
      guid = _emberMetalUtils.guidFor(mixin);
      if (mixinsMeta.peekMixins(guid)) {
        return CONTINUE;
      }
      mixinsMeta.writeMixins(guid, mixin);
      return mixin.properties;
    } else {
      return mixin; // apply anonymous mixin properties
    }
  }

  function concatenatedMixinProperties(concatProp, props, values, base) {
    var concats = undefined;

    // reset before adding each new mixin to pickup concats from previous
    concats = values[concatProp] || base[concatProp];
    if (props[concatProp]) {
      concats = concats ? concats.concat(props[concatProp]) : props[concatProp];
    }

    return concats;
  }

  function giveDescriptorSuper(meta, key, property, values, descs, base) {
    var superProperty = undefined;

    // Computed properties override methods, and do not call super to them
    if (values[key] === undefined) {
      // Find the original descriptor in a parent mixin
      superProperty = descs[key];
    }

    // If we didn't find the original descriptor in a parent mixin, find
    // it on the original object.
    if (!superProperty) {
      var possibleDesc = base[key];
      var superDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      superProperty = superDesc;
    }

    if (superProperty === undefined || !(superProperty instanceof _emberMetalComputed.ComputedProperty)) {
      return property;
    }

    // Since multiple mixins may inherit from the same parent, we need
    // to clone the computed property so that other mixins do not receive
    // the wrapped version.
    property = Object.create(property);
    property._getter = _emberMetalUtils.wrap(property._getter, superProperty._getter);
    if (superProperty._setter) {
      if (property._setter) {
        property._setter = _emberMetalUtils.wrap(property._setter, superProperty._setter);
      } else {
        property._setter = superProperty._setter;
      }
    }

    return property;
  }

  function giveMethodSuper(obj, key, method, values, descs) {
    var superMethod = undefined;

    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] === undefined) {
      // Find the original method in a parent mixin
      superMethod = values[key];
    }

    // If we didn't find the original value in a parent mixin, find it in
    // the original object
    superMethod = superMethod || obj[key];

    // Only wrap the new method if the original method was a function
    if (superMethod === undefined || 'function' !== typeof superMethod) {
      return method;
    }

    return _emberMetalUtils.wrap(method, superMethod);
  }

  function applyConcatenatedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    if (baseValue) {
      if ('function' === typeof baseValue.concat) {
        if (value === null || value === undefined) {
          return baseValue;
        } else {
          return baseValue.concat(value);
        }
      } else {
        return _emberMetalUtils.makeArray(baseValue).concat(value);
      }
    } else {
      return _emberMetalUtils.makeArray(value);
    }
  }

  function applyMergedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    if (!baseValue) {
      return value;
    }

    var newBase = _emberMetalAssign.default({}, baseValue);
    var hasFunction = false;

    for (var prop in value) {
      if (!value.hasOwnProperty(prop)) {
        continue;
      }

      var propValue = value[prop];
      if (isMethod(propValue)) {
        // TODO: support for Computed Properties, etc?
        hasFunction = true;
        newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }

    if (hasFunction) {
      newBase._super = ROOT;
    }

    return newBase;
  }

  function addNormalizedProperty(base, key, value, meta, descs, values, concats, mergings) {
    if (value instanceof _emberMetalProperties.Descriptor) {
      if (value === REQUIRED && descs[key]) {
        return CONTINUE;
      }

      // Wrap descriptor function to implement
      // _super() if needed
      if (value._getter) {
        value = giveDescriptorSuper(meta, key, value, values, descs, base);
      }

      descs[key] = value;
      values[key] = undefined;
    } else {
      if (concats && concats.indexOf(key) >= 0 || key === 'concatenatedProperties' || key === 'mergedProperties') {
        value = applyConcatenatedProperties(base, key, value, values);
      } else if (mergings && mergings.indexOf(key) >= 0) {
        value = applyMergedProperties(base, key, value, values);
      } else if (isMethod(value)) {
        value = giveMethodSuper(base, key, value, values, descs);
      }

      descs[key] = undefined;
      values[key] = value;
    }
  }

  function mergeMixins(mixins, m, descs, values, base, keys) {
    var currentMixin = undefined,
        props = undefined,
        key = undefined,
        concats = undefined,
        mergings = undefined,
        meta = undefined;

    function removeKeys(keyName) {
      delete descs[keyName];
      delete values[keyName];
    }

    for (var i = 0; i < mixins.length; i++) {
      currentMixin = mixins[i];

      props = mixinProperties(m, currentMixin);
      if (props === CONTINUE) {
        continue;
      }

      if (props) {
        meta = _emberMetalMeta.meta(base);
        if (base.willMergeMixin) {
          base.willMergeMixin(props);
        }
        concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
        mergings = concatenatedMixinProperties('mergedProperties', props, values, base);

        for (key in props) {
          if (!props.hasOwnProperty(key)) {
            continue;
          }
          keys.push(key);
          addNormalizedProperty(base, key, props[key], meta, descs, values, concats, mergings);
        }

        // manually copy toString() because some JS engines do not enumerate it
        if (props.hasOwnProperty('toString')) {
          base.toString = props.toString;
        }
      } else if (currentMixin.mixins) {
        mergeMixins(currentMixin.mixins, m, descs, values, base, keys);
        if (currentMixin._without) {
          currentMixin._without.forEach(removeKeys);
        }
      }
    }
  }

  function detectBinding(key) {
    var length = key.length;

    return length > 7 && key.charCodeAt(length - 7) === 66 && key.indexOf('inding', length - 6) !== -1;
  }

  // warm both paths of above function
  detectBinding('notbound');
  detectBinding('fooBinding');

  function connectBindings(obj, m) {
    // TODO Mixin.apply(instance) should disconnect binding if exists
    m.forEachBindings(function (key, binding) {
      if (binding) {
        var to = key.slice(0, -7); // strip Binding off end
        if (binding instanceof _emberMetalBinding.Binding) {
          binding = binding.copy(); // copy prototypes' instance
          binding.to(to);
        } else {
          // binding is string path
          binding = new _emberMetalBinding.Binding(to, binding);
        }
        binding.connect(obj);
        obj[key] = binding;
      }
    });
    // mark as applied
    m.clearBindings();
  }

  function finishPartial(obj, m) {
    connectBindings(obj, m || _emberMetalMeta.meta(obj));
    return obj;
  }

  function followAlias(obj, desc, m, descs, values) {
    var altKey = desc.methodName;
    var value = undefined;
    var possibleDesc = undefined;
    if (descs[altKey] || values[altKey]) {
      value = values[altKey];
      desc = descs[altKey];
    } else if ((possibleDesc = obj[altKey]) && possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
      value = undefined;
    } else {
      desc = undefined;
      value = obj[altKey];
    }

    return { desc: desc, value: value };
  }

  function updateObserversAndListeners(obj, key, observerOrListener, pathsKey, updateMethod) {
    var paths = observerOrListener[pathsKey];

    if (paths) {
      for (var i = 0; i < paths.length; i++) {
        updateMethod(obj, paths[i], null, key);
      }
    }
  }

  function replaceObserversAndListeners(obj, key, observerOrListener) {
    var prev = obj[key];

    if ('function' === typeof prev) {
      updateObserversAndListeners(obj, key, prev, '__ember_observesBefore__', _emberMetalObserver._removeBeforeObserver);
      updateObserversAndListeners(obj, key, prev, '__ember_observes__', _emberMetalObserver.removeObserver);
      updateObserversAndListeners(obj, key, prev, '__ember_listens__', _emberMetalEvents.removeListener);
    }

    if ('function' === typeof observerOrListener) {
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_observesBefore__', _emberMetalObserver._addBeforeObserver);
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_observes__', _emberMetalObserver.addObserver);
      updateObserversAndListeners(obj, key, observerOrListener, '__ember_listens__', _emberMetalEvents.addListener);
    }
  }

  function applyMixin(obj, mixins, partial) {
    var descs = {};
    var values = {};
    var m = _emberMetalMeta.meta(obj);
    var keys = [];
    var key = undefined,
        value = undefined,
        desc = undefined;

    obj._super = ROOT;

    // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers
    mergeMixins(mixins, m, descs, values, obj, keys);

    for (var i = 0; i < keys.length; i++) {
      key = keys[i];
      if (key === 'constructor' || !values.hasOwnProperty(key)) {
        continue;
      }

      desc = descs[key];
      value = values[key];

      if (desc === REQUIRED) {
        continue;
      }

      while (desc && desc instanceof Alias) {
        var followed = followAlias(obj, desc, m, descs, values);
        desc = followed.desc;
        value = followed.value;
      }

      if (desc === undefined && value === undefined) {
        continue;
      }

      replaceObserversAndListeners(obj, key, value);

      if (detectBinding(key)) {
        m.writeBindings(key, value);
      }

      _emberMetalProperties.defineProperty(obj, key, desc, value, m);
    }

    if (!partial) {
      // don't apply to prototype
      finishPartial(obj, m);
    }

    return obj;
  }

  /**
    @method mixin
    @for Ember
    @param obj
    @param mixins*
    @return obj
    @private
  */

  function mixin(obj) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    applyMixin(obj, args, false);
    return obj;
  }

  var NAME_KEY = _emberMetalUtils.GUID_KEY + '_name';

  exports.NAME_KEY = NAME_KEY;
  /**
    The `Ember.Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,
  
    ```javascript
    App.Editable = Ember.Mixin.create({
      edit: function() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });
  
    // Mix mixins into classes by passing them as the first arguments to
    // .extend.
    App.CommentView = Ember.View.extend(App.Editable, {
      template: Ember.Handlebars.compile('{{#if view.isEditing}}...{{else}}...{{/if}}')
    });
  
    commentView = App.CommentView.create();
    commentView.edit(); // outputs 'starting to edit'
    ```
  
    Note that Mixins are created with `Ember.Mixin.create`, not
    `Ember.Mixin.extend`.
  
    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.
  
    ```javascript
    //filters array will be shared amongst any object implementing mixin
    App.Filterable = Ember.Mixin.create({
      filters: Ember.A()
    });
  
    //filters will be a separate  array for every object implementing the mixin
    App.Filterable = Ember.Mixin.create({
      filters: Ember.computed(function() {return Ember.A();})
    });
  
    //filters will be created as a separate array during the object's initialization
    App.Filterable = Ember.Mixin.create({
      init: function() {
        this._super(...arguments);
        this.set("filters", Ember.A());
      }
    });
    ```
  
    @class Mixin
    @namespace Ember
    @public
  */

  function Mixin(args, properties) {
    this.properties = properties;

    var length = args && args.length;

    if (length > 0) {
      var m = new Array(length);

      for (var i = 0; i < length; i++) {
        var x = args[i];
        if (x instanceof Mixin) {
          m[i] = x;
        } else {
          m[i] = new Mixin(undefined, x);
        }
      }

      this.mixins = m;
    } else {
      this.mixins = undefined;
    }
    this.ownerConstructor = undefined;
    this._without = undefined;
    this[_emberMetalUtils.GUID_KEY] = null;
    this[NAME_KEY] = null;
  }

  Mixin._apply = applyMixin;

  Mixin.applyPartial = function (obj) {
    var args = a_slice.call(arguments, 1);
    return applyMixin(obj, args, true);
  };

  Mixin.finishPartial = finishPartial;

  var unprocessedFlag = false;

  function hasUnprocessedMixins() {
    return unprocessedFlag;
  }

  function clearUnprocessedMixins() {
    unprocessedFlag = false;
  }

  /**
    @method create
    @static
    @param arguments*
    @public
  */
  Mixin.create = function () {
    // ES6TODO: this relies on a global state?
    unprocessedFlag = true;
    var M = this;

    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return new M(args, undefined);
  };

  var MixinPrototype = Mixin.prototype;

  /**
    @method reopen
    @param arguments*
    @private
  */
  MixinPrototype.reopen = function () {
    var currentMixin = undefined;

    if (this.properties) {
      currentMixin = new Mixin(undefined, this.properties);
      this.properties = undefined;
      this.mixins = [currentMixin];
    } else if (!this.mixins) {
      this.mixins = [];
    }

    var mixins = this.mixins;
    var idx = undefined;

    for (idx = 0; idx < arguments.length; idx++) {
      currentMixin = arguments[idx];

      if (currentMixin instanceof Mixin) {
        mixins.push(currentMixin);
      } else {
        mixins.push(new Mixin(undefined, currentMixin));
      }
    }

    return this;
  };

  /**
    @method apply
    @param obj
    @return applied object
    @private
  */
  MixinPrototype.apply = function (obj) {
    return applyMixin(obj, [this], false);
  };

  MixinPrototype.applyPartial = function (obj) {
    return applyMixin(obj, [this], true);
  };

  MixinPrototype.toString = Object.toString;

  function _detect(curMixin, targetMixin, seen) {
    var guid = _emberMetalUtils.guidFor(curMixin);

    if (seen[guid]) {
      return false;
    }
    seen[guid] = true;

    if (curMixin === targetMixin) {
      return true;
    }
    var mixins = curMixin.mixins;
    var loc = mixins ? mixins.length : 0;
    while (--loc >= 0) {
      if (_detect(mixins[loc], targetMixin, seen)) {
        return true;
      }
    }
    return false;
  }

  /**
    @method detect
    @param obj
    @return {Boolean}
    @private
  */
  MixinPrototype.detect = function (obj) {
    if (typeof obj !== 'object' || obj === null) {
      return false;
    }
    if (obj instanceof Mixin) {
      return _detect(obj, this, {});
    }
    var m = _emberMetalMeta.peekMeta(obj);
    if (!m) {
      return false;
    }
    return !!m.peekMixins(_emberMetalUtils.guidFor(this));
  };

  MixinPrototype.without = function () {
    var ret = new Mixin([this]);

    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    ret._without = args;
    return ret;
  };

  function _keys(ret, mixin, seen) {
    if (seen[_emberMetalUtils.guidFor(mixin)]) {
      return;
    }
    seen[_emberMetalUtils.guidFor(mixin)] = true;

    if (mixin.properties) {
      var props = Object.keys(mixin.properties);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        ret[key] = true;
      }
    } else if (mixin.mixins) {
      mixin.mixins.forEach(function (x) {
        return _keys(ret, x, seen);
      });
    }
  }

  MixinPrototype.keys = function () {
    var keys = {};
    var seen = {};

    _keys(keys, this, seen);
    var ret = Object.keys(keys);
    return ret;
  };

  // returns the mixins currently applied to the specified object
  // TODO: Make Ember.mixin
  Mixin.mixins = function (obj) {
    var m = _emberMetalMeta.peekMeta(obj);
    var ret = [];
    if (!m) {
      return ret;
    }

    m.forEachMixins(function (key, currentMixin) {
      // skip primitive mixins since these are always anonymous
      if (!currentMixin.properties) {
        ret.push(currentMixin);
      }
    });

    return ret;
  };

  var REQUIRED = new _emberMetalProperties.Descriptor();
  REQUIRED.toString = function () {
    return '(Required Property)';
  };

  /**
    Denotes a required property for a mixin
  
    @method required
    @for Ember
    @private
  */

  function required() {
    return REQUIRED;
  }

  function Alias(methodName) {
    this.isDescriptor = true;
    this.methodName = methodName;
  }

  Alias.prototype = new _emberMetalProperties.Descriptor();

  /**
    Makes a method available via an additional name.
  
    ```javascript
    App.Person = Ember.Object.extend({
      name: function() {
        return 'Tomhuda Katzdale';
      },
      moniker: Ember.aliasMethod('name')
    });
  
    let goodGuy = App.Person.create();
  
    goodGuy.name();    // 'Tomhuda Katzdale'
    goodGuy.moniker(); // 'Tomhuda Katzdale'
    ```
  
    @method aliasMethod
    @for Ember
    @param {String} methodName name of the method to alias
    @public
  */

  function aliasMethod(methodName) {
    return new Alias(methodName);
  }

  // ..........................................................
  // OBSERVER HELPER
  //

  /**
    Specify a method that observes property changes.
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.observer('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    Also available as `Function.prototype.observes` if prototype extensions are
    enabled.
  
    @method observer
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @public
  */

  function observer() {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    var func = args.slice(-1)[0];
    var paths = undefined;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };
    var _paths = args.slice(0, -1);

    if (typeof func !== 'function') {

      func = args[0];

      // revert to old, soft-deprecated argument ordering
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      _emberMetalExpand_properties.default(_paths[i], addWatchedProperty);
    }

    if (typeof func !== 'function') {
      throw new _emberMetalError.default('Ember.observer called without a function');
    }

    func.__ember_observes__ = paths;
    return func;
  }

  /**
    Specify a method that observes property changes.
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.immediateObserver('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    In the future, `Ember.observer` may become asynchronous. In this event,
    `Ember.immediateObserver` will maintain the synchronous behavior.
  
    Also available as `Function.prototype.observesImmediately` if prototype extensions are
    enabled.
  
    @method _immediateObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @deprecated Use `Ember.observer` instead.
    @return func
    @private
  */

  function _immediateObserver() {

    for (var i = 0; i < arguments.length; i++) {
      var arg = arguments[i];
    }

    return observer.apply(this, arguments);
  }

  /**
    When observers fire, they are called with the arguments `obj`, `keyName`.
  
    Note, `@each.property` observer is called per each add or replace of an element
    and it's not called with a specific enumeration item.
  
    A `_beforeObserver` fires before a property changes.
  
    A `_beforeObserver` is an alternative form of `.observesBefore()`.
  
    ```javascript
    App.PersonView = Ember.View.extend({
      friends: [{ name: 'Tom' }, { name: 'Stefan' }, { name: 'Kris' }],
  
      valueDidChange: Ember.observer('content.value', function(obj, keyName) {
          // only run if updating a value already in the DOM
          if (this.get('state') === 'inDOM') {
            let color = obj.get(keyName) > this.changingFrom ? 'green' : 'red';
            // logic
          }
      }),
  
      friendsDidChange: Ember.observer('friends.@each.name', function(obj, keyName) {
        // some logic
        // obj.get(keyName) returns friends array
      })
    });
    ```
  
    Also available as `Function.prototype.observesBefore` if prototype extensions are
    enabled.
  
    @method beforeObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @deprecated
    @private
  */

  function _beforeObserver() {
    for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    var func = args.slice(-1)[0];
    var paths = undefined;

    var addWatchedProperty = function (path) {
      paths.push(path);
    };

    var _paths = args.slice(0, -1);

    if (typeof func !== 'function') {
      // revert to old, soft-deprecated argument ordering

      func = args[0];
      _paths = args.slice(1);
    }

    paths = [];

    for (var i = 0; i < _paths.length; ++i) {
      _emberMetalExpand_properties.default(_paths[i], addWatchedProperty);
    }

    if (typeof func !== 'function') {
      throw new _emberMetalError.default('Ember.beforeObserver called without a function');
    }

    func.__ember_observesBefore__ = paths;
    return func;
  }

  exports.Mixin = Mixin;
  exports.required = required;
  exports.REQUIRED = REQUIRED;
})(Em._e[61],Em._e[31],Em._e[0],Em._e[8],Em._e[7],Em._e[14],Em._e[57],Em._e[48],Em._e[59],Em._e[60],Em._e[53],Em._e[15]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalError, _emberMetalProperties, _emberMetalComputed, _emberMetalUtils, _emberMetalMeta, _emberMetalDependent_keys) {
  'use strict';

  exports.default = alias;
  exports.AliasedProperty = AliasedProperty;

  function alias(altKey) {
    return new AliasedProperty(altKey);
  }

  function AliasedProperty(altKey) {
    this.isDescriptor = true;
    this.altKey = altKey;
    this._dependentKeys = [altKey];
  }

  AliasedProperty.prototype = Object.create(_emberMetalProperties.Descriptor.prototype);

  AliasedProperty.prototype.get = function AliasedProperty_get(obj, keyName) {
    return _emberMetalProperty_get.get(obj, this.altKey);
  };

  AliasedProperty.prototype.set = function AliasedProperty_set(obj, keyName, value) {
    return _emberMetalProperty_set.set(obj, this.altKey, value);
  };

  AliasedProperty.prototype.willWatch = function (obj, keyName) {
    _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, _emberMetalMeta.meta(obj));
  };

  AliasedProperty.prototype.didUnwatch = function (obj, keyName) {
    _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, _emberMetalMeta.meta(obj));
  };

  AliasedProperty.prototype.setup = function (obj, keyName) {
    var m = _emberMetalMeta.meta(obj);
    if (m.peekWatching(keyName)) {
      _emberMetalDependent_keys.addDependentKeys(this, obj, keyName, m);
    }
  };

  AliasedProperty.prototype.teardown = function (obj, keyName) {
    var m = _emberMetalMeta.meta(obj);
    if (m.peekWatching(keyName)) {
      _emberMetalDependent_keys.removeDependentKeys(this, obj, keyName, m);
    }
  };

  AliasedProperty.prototype.readOnly = function () {
    this.set = AliasedProperty_readOnlySet;
    return this;
  };

  function AliasedProperty_readOnlySet(obj, keyName, value) {
    throw new _emberMetalError.default('Cannot set read-only property \'' + keyName + '\' on object: ' + _emberMetalUtils.inspect(obj));
  }

  AliasedProperty.prototype.oneWay = function () {
    this.set = AliasedProperty_oneWaySet;
    return this;
  };

  function AliasedProperty_oneWaySet(obj, keyName, value) {
    _emberMetalProperties.defineProperty(obj, keyName, null);
    return _emberMetalProperty_set.set(obj, keyName, value);
  }

  // Backwards compatibility with Ember Data.
  AliasedProperty.prototype._meta = undefined;
  AliasedProperty.prototype.meta = _emberMetalComputed.ComputedProperty.prototype.meta;
})(Em._e[62],Em._e[0],Em._e[30],Em._e[32],Em._e[31],Em._e[48],Em._e[59],Em._e[7],Em._e[14],Em._e[58]);
(function (exports, _emberMetalDebug, _emberMetalMixin, _emberMetalProperty_get) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  exports.deprecateUnderscoreActions = deprecateUnderscoreActions;

  /**
    `Ember.ActionHandler` is available on some familiar classes including
    `Ember.Route`, `Ember.View`, `Ember.Component`, and `Ember.Controller`.
    (Internally the mixin is used by `Ember.CoreView`, `Ember.ControllerMixin`,
    and `Ember.Route` and available to the above classes through
    inheritance.)
  
    @class ActionHandler
    @namespace Ember
    @private
  */
  var ActionHandler = _emberMetalMixin.Mixin.create({
    mergedProperties: ['actions'],

    /**
      The collection of functions, keyed by name, available on this
      `ActionHandler` as action targets.
       These functions will be invoked when a matching `{{action}}` is triggered
      from within a template and the application's current route is this route.
       Actions can also be invoked from other parts of your application
      via `ActionHandler#send`.
       The `actions` hash will inherit action handlers from
      the `actions` hash defined on extended parent classes
      or mixins rather than just replace the entire hash, e.g.:
       ```js
      App.CanDisplayBanner = Ember.Mixin.create({
        actions: {
          displayBanner(msg) {
            // ...
          }
        }
      });
       App.WelcomeRoute = Ember.Route.extend(App.CanDisplayBanner, {
        actions: {
          playMusic() {
            // ...
          }
        }
      });
       // `WelcomeRoute`, when active, will be able to respond
      // to both actions, since the actions hash is merged rather
      // then replaced when extending mixins / parent classes.
      this.send('displayBanner');
      this.send('playMusic');
      ```
       Within a Controller, Route, View or Component's action handler,
      the value of the `this` context is the Controller, Route, View or
      Component object:
       ```js
      App.SongRoute = Ember.Route.extend({
        actions: {
          myAction() {
            this.controllerFor("song");
            this.transitionTo("other.route");
            ...
          }
        }
      });
      ```
       It is also possible to call `this._super(...arguments)` from within an
      action handler if it overrides a handler defined on a parent
      class or mixin:
       Take for example the following routes:
       ```js
      App.DebugRoute = Ember.Mixin.create({
        actions: {
          debugRouteInformation() {
            console.debug("trololo");
          }
        }
      });
       App.AnnoyingDebugRoute = Ember.Route.extend(App.DebugRoute, {
        actions: {
          debugRouteInformation() {
            // also call the debugRouteInformation of mixed in App.DebugRoute
            this._super(...arguments);
             // show additional annoyance
            window.alert(...);
          }
        }
      });
      ```
       ## Bubbling
       By default, an action will stop bubbling once a handler defined
      on the `actions` hash handles it. To continue bubbling the action,
      you must return `true` from the handler:
       ```js
      App.Router.map(function() {
        this.route("album", function() {
          this.route("song");
        });
      });
       App.AlbumRoute = Ember.Route.extend({
        actions: {
          startPlaying: function() {
          }
        }
      });
       App.AlbumSongRoute = Ember.Route.extend({
        actions: {
          startPlaying() {
            // ...
             if (actionShouldAlsoBeTriggeredOnParentRoute) {
              return true;
            }
          }
        }
      });
      ```
       @property actions
      @type Object
      @default null
      @public
    */

    /**
      Triggers a named action on the `ActionHandler`. Any parameters
      supplied after the `actionName` string will be passed as arguments
      to the action target function.
       If the `ActionHandler` has its `target` property set, actions may
      bubble to the `target`. Bubbling happens when an `actionName` can
      not be found in the `ActionHandler`'s `actions` hash or if the
      action target function returns `true`.
       Example
       ```js
      App.WelcomeRoute = Ember.Route.extend({
        actions: {
          playTheme() {
             this.send('playMusic', 'theme.mp3');
          },
          playMusic(track) {
            // ...
          }
        }
      });
      ```
       @method send
      @param {String} actionName The action to trigger
      @param {*} context a context to send with the action
      @public
    */
    send: function (actionName) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var target = undefined;

      if (this.actions && this.actions[actionName]) {
        var shouldBubble = this.actions[actionName].apply(this, args) === true;
        if (!shouldBubble) {
          return;
        }
      }

      if (target = _emberMetalProperty_get.get(this, 'target')) {
        var _target;

        (_target = target).send.apply(_target, arguments);
      }
    },

    willMergeMixin: function (props) {

      if (props._actions) {

        props.actions = props._actions;
        delete props._actions;
      }
    }
  });

  exports.default = ActionHandler;

  function deprecateUnderscoreActions(factory) {
    Object.defineProperty(factory.prototype, '_actions', {
      configurable: true,
      enumerable: false,
      set: function (value) {},
      get: function () {
        return _emberMetalProperty_get.get(this, 'actions');
      }
    });
  }
})(Em._e[63],Em._e[0],Em._e[61],Em._e[30]);
(function (exports, _emberMetalDebug, _emberMetalMixin) {
  'use strict';

  /*
    The ControllerContentModelAliasDeprecation mixin is used to provide a useful
    deprecation warning when specifying `content` directly on a `Ember.Controller`
    (without also specifying `model`).
  
    Ember versions prior to 1.7 used `model` as an alias of `content`, but due to
    much confusion this alias was reversed (so `content` is now an alias of `model).
  
    This change reduces many caveats with model/content, and also sets a
    simple ground rule: Never set a controllers content, rather always set
    its model and ember will do the right thing.
  
    Used internally by Ember in `Ember.Controller`.
  */
  exports.default = _emberMetalMixin.Mixin.create({
    /**
      @private
       Moves `content` to `model`  at extend time if a `model` is not also specified.
       Note that this currently modifies the mixin themselves, which is technically
      dubious but is practically of little consequence. This may change in the
      future.
       @method willMergeMixin
      @since 1.4.0
    */
    willMergeMixin: function (props) {
      // Calling super is only OK here since we KNOW that
      // there is another Mixin loaded first.
      this._super.apply(this, arguments);

      var modelSpecified = !!props.model;

      if (props.content && !modelSpecified) {
        props.model = props.content;
        delete props['content'];
      }
    }
  });
})(Em._e[64],Em._e[0],Em._e[61]);
(function (exports, _emberMetalMixin, _emberMetalAlias, _emberRuntimeMixinsAction_handler, _emberRuntimeMixinsController_content_model_alias_deprecation) {
  'use strict';

  /**
    @class ControllerMixin
    @namespace Ember
    @uses Ember.ActionHandler
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create(_emberRuntimeMixinsAction_handler.default, _emberRuntimeMixinsController_content_model_alias_deprecation.default, {
    /* ducktype as a controller */
    isController: true,

    /**
      The object to which actions from the view should be sent.
       For example, when a Handlebars template uses the `{{action}}` helper,
      it will attempt to send the action to the view's controller's `target`.
       By default, the value of the target property is set to the router, and
      is injected when a controller is instantiated. This injection is applied
      as part of the application's initialization process. In most cases the
      `target` property will automatically be set to the logical consumer of
      actions for the controller.
       @property target
      @default null
      @public
    */
    target: null,

    store: null,

    /**
      The controller's current model. When retrieving or modifying a controller's
      model, this property should be used instead of the `content` property.
       @property model
      @public
     */
    model: null,

    /**
      @private
    */
    content: _emberMetalAlias.default('model')

  });
})(Em._e[65],Em._e[61],Em._e[62],Em._e[63],Em._e[64]);
(function (exports, _emberHtmlbarsHooksGetValue, _emberMetalDebug, _emberHtmlbarsStreamsStream, _emberMetalProperty_get, _emberRuntimeMixinsController) {
  'use strict';

  exports.getArrayValues = getArrayValues;
  exports.getHashValues = getHashValues;
  exports.isStream = isStream;
  exports.subscribe = subscribe;
  exports.unsubscribe = unsubscribe;
  exports.read = read;
  exports.readArray = readArray;
  exports.readHash = readHash;
  exports.scanArray = scanArray;
  exports.scanHash = scanHash;
  exports.labelsFor = labelsFor;
  exports.labelsForObject = labelsForObject;
  exports.labelFor = labelFor;
  exports.or = or;
  exports.addDependency = addDependency;
  exports.zip = zip;
  exports.zipHash = zipHash;
  exports.chain = chain;
  exports.setValue = setValue;
  exports.readViewFactory = readViewFactory;
  exports.readUnwrappedModel = readUnwrappedModel;

  // We don't want to leak mutable cells into helpers, which
  // are pure functions that can only work with values.

  function getArrayValues(params) {
    var out = new Array(params.length);

    for (var i = 0; i < params.length; i++) {
      out[i] = _emberHtmlbarsHooksGetValue.default(params[i]);
    }

    return out;
  }

  function getHashValues(hash) {
    var out = {};

    for (var prop in hash) {
      out[prop] = _emberHtmlbarsHooksGetValue.default(hash[prop]);
    }

    return out;
  }

  /*
   Check whether an object is a stream or not.
  
   @private
   @for Ember.stream
   @function isStream
   @param {Object|Stream} object Object to check whether it is a stream.
   @return {Boolean} `true` if the object is a stream, `false` otherwise.
  */

  function isStream(object) {
    return object && object[_emberHtmlbarsStreamsStream.IS_STREAM];
  }

  /*
   A method of subscribing to a stream which is safe for use with a non-stream
   object. If a non-stream object is passed, the function does nothing.
  
   @public
   @for Ember.stream
   @function subscribe
   @param {Object|Stream} object Object or stream to potentially subscribe to.
   @param {Function} callback Function to run when stream value changes.
   @param {Object} [context] the callback will be executed with this context if it
                             is provided.
   */

  function subscribe(object, callback, context) {
    if (object && object[_emberHtmlbarsStreamsStream.IS_STREAM]) {
      return object.subscribe(callback, context);
    }
  }

  /*
   A method of unsubscribing from a stream which is safe for use with a non-stream
   object. If a non-stream object is passed, the function does nothing.
  
   @private
   @for Ember.stream
   @function unsubscribe
   @param {Object|Stream} object Object or stream to potentially unsubscribe from.
   @param {Function} callback Function originally passed to `subscribe()`.
   @param {Object} [context] Object originally passed to `subscribe()`.
   */

  function unsubscribe(object, callback, context) {
    if (object && object[_emberHtmlbarsStreamsStream.IS_STREAM]) {
      object.unsubscribe(callback, context);
    }
  }

  /*
   Retrieve the value of a stream, or in the case where a non-stream object is passed,
   return the object itself.
  
   @private
   @for Ember.stream
   @function read
   @param {Object|Stream} object Object to return the value of.
   @return The stream's current value, or the non-stream object itself.
   */

  function read(object) {
    if (object && object[_emberHtmlbarsStreamsStream.IS_STREAM]) {
      return object.value();
    } else {
      return object;
    }
  }

  /*
   Map an array, replacing any streams with their values.
  
   @private
   @for Ember.stream
   @function readArray
   @param {Array} array The array to read values from
   @return {Array} A new array of the same length with the values of non-stream
                   objects mapped from their original positions untouched, and
                   the values of stream objects retaining their original position
                   and replaced with the stream's current value.
   */

  function readArray(array) {
    var ret = new Array(array.length);
    for (var i = 0; i < array.length; i++) {
      ret[i] = read(array[i]);
    }
    return ret;
  }

  /*
   Map a hash, replacing any stream property values with the current value of that
   stream.
  
   @private
   @for Ember.stream
   @function readHash
   @param {Object} object The hash to read keys and values from.
   @return {Object} A new object with the same keys as the passed object. The
                    property values in the new object are the original values in
                    the case of non-stream objects, and the streams' current
                    values in the case of stream objects.
   */

  function readHash(object) {
    var ret = {};
    for (var key in object) {
      ret[key] = read(object[key]);
    }
    return ret;
  }

  /*
   Check whether an array contains any stream values.
  
   @private
   @for Ember.stream
   @function scanArray
   @param {Array} array Array given to a handlebars helper.
   @return {Boolean} `true` if the array contains a stream/bound value, `false`
                     otherwise.
  */

  function scanArray(array) {
    var containsStream = false;

    for (var i = 0; i < array.length; i++) {
      if (isStream(array[i])) {
        containsStream = true;
        break;
      }
    }

    return containsStream;
  }

  /*
   Check whether a hash has any stream property values.
  
   @private
   @for Ember.stream
   @function scanHash
   @param {Object} hash "hash" argument given to a handlebars helper.
   @return {Boolean} `true` if the object contains a stream/bound value, `false`
                     otherwise.
   */

  function scanHash(hash) {
    var containsStream = false;

    for (var prop in hash) {
      if (isStream(hash[prop])) {
        containsStream = true;
        break;
      }
    }

    return containsStream;
  }

  function labelsFor(streams) {
    var labels = [];

    for (var i = 0; i < streams.length; i++) {
      var stream = streams[i];
      labels.push(labelFor(stream));
    }

    return labels;
  }

  function labelsForObject(streams) {
    var labels = [];

    for (var prop in streams) {
      labels.push(prop + ': ' + inspect(streams[prop]));
    }

    return labels.length ? '{ ' + labels.join(', ') + ' }' : '{}';
  }

  function labelFor(maybeStream) {
    if (isStream(maybeStream)) {
      var stream = maybeStream;
      return typeof stream.label === 'function' ? stream.label() : stream.label;
    } else {
      return inspect(maybeStream);
    }
  }

  function inspect(value) {
    switch (typeof value) {
      case 'string':
        return '"' + value + '"';
      case 'object':
        return '{ ... }';
      case 'function':
        return 'function() { ... }';
      default:
        return String(value);
    }
  }

  function or(first, second) {
    var stream = new _emberHtmlbarsStreamsStream.Stream(function () {
      return first.value() || second.value();
    }, function () {
      return labelFor(first) + ' || ' + labelFor(second);
    });

    stream.addDependency(first);
    stream.addDependency(second);

    return stream;
  }

  function addDependency(stream, dependency) {
    if (isStream(stream)) {
      stream.addDependency(dependency);
    }
  }

  function zip(streams, callback, label) {

    var stream = new _emberHtmlbarsStreamsStream.Stream(function () {
      var array = readArray(streams);
      return callback ? callback(array) : array;
    }, function () {
      return label + '(' + labelsFor(streams) + ')';
    });

    for (var i = 0; i < streams.length; i++) {
      stream.addDependency(streams[i]);
    }

    return stream;
  }

  function zipHash(object, callback, label) {

    var stream = new _emberHtmlbarsStreamsStream.Stream(function () {
      var hash = readHash(object);
      return callback ? callback(hash) : hash;
    }, function () {
      return label + '(' + labelsForObject(object) + ')';
    });

    for (var prop in object) {
      stream.addDependency(object[prop]);
    }

    return stream;
  }

  /**
   Generate a new stream by providing a source stream and a function that can
   be used to transform the stream's value. In the case of a non-stream object,
   returns the result of the function.
  
   The value to transform would typically be available to the function you pass
   to `chain()` via scope. For example:
  
   ```javascript
       let source = ...;  // stream returning a number
                              // or a numeric (non-stream) object
       let result = chain(source, function() {
         let currentValue = read(source);
         return currentValue + 1;
       });
   ```
  
   In the example, result is a stream if source is a stream, or a number of
   source was numeric.
  
   @private
   @for Ember.stream
   @function chain
   @param {Object|Stream} value A stream or non-stream object.
   @param {Function} fn Function to be run when the stream value changes, or to
                        be run once in the case of a non-stream object.
   @return {Object|Stream} In the case of a stream `value` parameter, a new
                           stream that will be updated with the return value of
                           the provided function `fn`. In the case of a
                           non-stream object, the return value of the provided
                           function `fn`.
   */

  function chain(value, fn, label) {
    if (isStream(value)) {
      var stream = new _emberHtmlbarsStreamsStream.Stream(fn, function () {
        return label + '(' + labelFor(value) + ')';
      });
      stream.addDependency(value);
      return stream;
    } else {
      return fn();
    }
  }

  function setValue(object, value) {
    if (object && object[_emberHtmlbarsStreamsStream.IS_STREAM]) {
      object.setValue(value);
    }
  }

  function readViewFactory(object, owner) {
    var value = read(object);
    var viewClass = undefined;

    if (typeof value === 'string') {
      viewClass = owner._lookupFactory('view:' + value);
    } else {
      viewClass = value;
    }

    return viewClass;
  }

  function readUnwrappedModel(object) {
    if (isStream(object)) {
      var result = object.value();

      // If the path is exactly `controller` then we don't unwrap it.
      if (object.label !== 'controller') {
        while (_emberRuntimeMixinsController.default.detect(result)) {
          result = _emberMetalProperty_get.get(result, 'model');
        }
      }

      return result;
    } else {
      return object;
    }
  }
})(Em._e[66],Em._e[68],Em._e[0],Em._e[56],Em._e[30],Em._e[65]);
(function (exports, _emberMetalMixin, _emberMetalSymbol, _emberMetalProperty_events) {
  'use strict';

  exports.deprecation = deprecation;
  exports.getAttrFor = getAttrFor;

  function deprecation(key) {
    return 'You tried to look up an attribute directly on the component. This is deprecated. Use attrs.' + key + ' instead.';
  }

  var MUTABLE_CELL = _emberMetalSymbol.default('MUTABLE_CELL');

  exports.MUTABLE_CELL = MUTABLE_CELL;
  function isCell(val) {
    return val && val[MUTABLE_CELL];
  }

  function getAttrFor(attrs, key) {
    var val = attrs[key];
    return isCell(val) ? val.value : val;
  }

  var AttrsProxyMixin = {
    attrs: null,

    getAttr: function (key) {
      var attrs = this.attrs;
      if (!attrs) {
        return;
      }
      return getAttrFor(attrs, key);
    },

    setAttr: function (key, value) {
      var attrs = this.attrs;
      var val = attrs[key];

      if (!isCell(val)) {
        throw new Error('You can\'t update attrs.' + key + ', because it\'s not mutable');
      }

      val.update(value);
    },

    _propagateAttrsToThis: function (attrs) {
      this._isDispatchingAttrs = true;
      this.setProperties(attrs);
      this._isDispatchingAttrs = false;
    }
  };

  AttrsProxyMixin[_emberMetalProperty_events.PROPERTY_DID_CHANGE] = function (key) {
    if (this._isDispatchingAttrs) {
      return;
    }

    if (this._currentState) {
      this._currentState.legacyPropertyDidChange(this, key);
    }
  };

  exports.default = _emberMetalMixin.Mixin.create(AttrsProxyMixin);
})(Em._e[67],Em._e[61],Em._e[13],Em._e[20]);
(function (exports, _emberHtmlbarsStreamsUtils, _emberViewsCompatAttrsProxy) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = getValue;

  function getValue(ref) {
    var value = _emberHtmlbarsStreamsUtils.read(ref);

    if (value && value[_emberViewsCompatAttrsProxy.MUTABLE_CELL]) {
      return value.value;
    }

    return value;
  }
})(Em._e[68],Em._e[66],Em._e[67]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _htmlbarsRuntime, _htmlbarsUtilTemplateUtils, _emberHtmlbarsHooksGetValue, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = buildComponentTemplate;
  exports.buildHTMLTemplate = buildHTMLTemplate;

  function buildComponentTemplate(_ref, attrs, content) {
    var component = _ref.component;
    var tagName = _ref.tagName;
    var layout = _ref.layout;
    var outerAttrs = _ref.outerAttrs;

    if (component === undefined) {
      component = null;
    }

    var blockToRender = undefined,
        meta = undefined;
    if (layout && layout.raw) {
      var yieldTo = createContentBlocks(content.templates, content.scope, content.self, component);
      blockToRender = createLayoutBlock(layout.raw, yieldTo, content.self, component, attrs);
      meta = layout.raw.meta;
    } else if (content.templates && content.templates.default) {
      blockToRender = createContentBlock(content.templates.default, content.scope, content.self, component);
      meta = content.templates.default.meta;
    }

    if (component) {
      tagName = tagName || tagNameFor(component);

      // If this is not a tagless component, we need to create the wrapping
      // element. We use `manualElement` to create a template that represents
      // the wrapping element and yields to the previous block.
      if (tagName !== '') {
        var attributes = normalizeComponentAttributes(component, attrs);
        var elementTemplate = _htmlbarsRuntime.internal.manualElement(tagName, attributes);
        elementTemplate.meta = meta;

        blockToRender = createElementBlock(elementTemplate, blockToRender, component);
      }
    }

    // tagName is one of:
    //   * `undefined` if no component is present
    //   * the falsy value "" if set explicitly on the component
    //   * an actual tagName set explicitly on the component
    return { createdElement: !!tagName, block: blockToRender };
  }

  function buildHTMLTemplate(tagName, _attrs, content) {
    var attrs = {};

    for (var prop in _attrs) {
      var val = _attrs[prop];

      if (typeof val === 'string') {
        attrs[prop] = val;
      } else {
        attrs[prop] = _htmlbarsUtilTemplateUtils.buildStatement('value', val);
      }
    }

    var childTemplate = content.templates.default;
    var elementTemplate = _htmlbarsRuntime.internal.manualElement(tagName, attrs, childTemplate.isEmpty);

    if (childTemplate.isEmpty) {
      return blockFor(elementTemplate, { scope: content.scope });
    } else {
      var blockToRender = blockFor(content.templates.default, content);
      return blockFor(elementTemplate, { yieldTo: blockToRender, scope: content.scope });
    }
  }

  function blockFor(template, options) {
    return _htmlbarsRuntime.internal.blockFor(_htmlbarsRuntime.render, template, options);
  }

  function createContentBlock(template, scope, self, component) {
    return blockFor(template, {
      scope: scope,
      self: self,
      options: { view: component }
    });
  }

  function createContentBlocks(templates, scope, self, component) {
    if (!templates) {
      return;
    }
    var output = {};
    for (var _name in templates) {
      if (templates.hasOwnProperty(_name)) {
        var template = templates[_name];
        if (template) {
          output[_name] = createContentBlock(templates[_name], scope, self, component);
        }
      }
    }
    return output;
  }

  function createLayoutBlock(template, yieldTo, self, component, attrs) {
    return blockFor(template, {
      yieldTo: yieldTo,

      // If we have an old-style Controller with a template it will be
      // passed as our `self` argument, and it should be the context for
      // the template. Otherwise, we must have a real Component and it
      // should be its own template context.
      self: self || component,

      options: { view: component, attrs: attrs }
    });
  }

  function createElementBlock(template, yieldTo, component) {
    return blockFor(template, {
      yieldTo: yieldTo,
      self: component,
      options: { view: component }
    });
  }

  function tagNameFor(view) {
    var tagName = view.tagName;

    if (tagName === null || tagName === undefined) {
      tagName = 'div';
    }

    return tagName;
  }

  // Takes a component and builds a normalized set of attribute
  // bindings consumable by HTMLBars' `attribute` hook.
  function normalizeComponentAttributes(component, attrs) {
    var normalized = {};
    var attributeBindings = component.attributeBindings;

    if (attrs.id && _emberHtmlbarsHooksGetValue.default(attrs.id)) {
      // Do not allow binding to the `id`
      normalized.id = _emberHtmlbarsHooksGetValue.default(attrs.id);
      component.elementId = normalized.id;
    } else {
      normalized.id = component.elementId;
    }

    if (attributeBindings) {
      for (var i = 0; i < attributeBindings.length; i++) {
        var attr = attributeBindings[i];
        var colonIndex = attr.indexOf(':');

        var attrName = undefined,
            expression = undefined;
        if (colonIndex !== -1) {
          var attrProperty = attr.substring(0, colonIndex);
          attrName = attr.substring(colonIndex + 1);
          expression = _htmlbarsUtilTemplateUtils.buildStatement('get', attrProperty);
        } else if (attrs[attr]) {
          // TODO: For compatibility with 1.x, we probably need to `set`
          // the component's attribute here if it is a CP, but we also
          // probably want to suspend observers and allow the
          // willUpdateAttrs logic to trigger observers at the correct time.
          attrName = attr;
          expression = _htmlbarsUtilTemplateUtils.buildStatement('value', attrs[attr]);
        } else {
          attrName = attr;
          expression = _htmlbarsUtilTemplateUtils.buildStatement('get', attr);
        }

        normalized[attrName] = expression;
      }
    }

    normalized.role = _htmlbarsUtilTemplateUtils.buildStatement('get', 'ariaRole');

    if (attrs.tagName) {
      component.tagName = attrs.tagName;
    }

    var normalizedClass = normalizeClass(component, attrs);
    if (normalizedClass) {
      normalized.class = normalizedClass;
    }

    if (_emberMetalProperty_get.get(component, 'isVisible') === false) {
      var hiddenStyle = _htmlbarsUtilTemplateUtils.buildStatement('subexpr', '-html-safe', ['display: none;'], []);
      var existingStyle = normalized.style;

      if (existingStyle) {
        normalized.style = _htmlbarsUtilTemplateUtils.buildStatement('subexpr', 'concat', [existingStyle, ' ', hiddenStyle], []);
      } else {
        normalized.style = hiddenStyle;
      }
    }

    return normalized;
  }

  function normalizeClass(component, attrs) {
    var normalizedClass = [];
    var classNames = _emberMetalProperty_get.get(component, 'classNames');
    var classNameBindings = _emberMetalProperty_get.get(component, 'classNameBindings');

    if (attrs.class) {
      if (_emberHtmlbarsStreamsUtils.isStream(attrs.class)) {
        normalizedClass.push(_htmlbarsUtilTemplateUtils.buildStatement('subexpr', '-normalize-class', [_htmlbarsUtilTemplateUtils.buildStatement('value', attrs.class.path), _htmlbarsUtilTemplateUtils.buildStatement('value', attrs.class)], []));
      } else {
        normalizedClass.push(attrs.class);
      }
    }

    if (attrs.classBinding) {
      normalizeClasses(attrs.classBinding.split(' '), normalizedClass);
    }

    if (classNames) {
      for (var i = 0; i < classNames.length; i++) {
        normalizedClass.push(classNames[i]);
      }
    }

    if (classNameBindings) {
      normalizeClasses(classNameBindings, normalizedClass);
    }

    if (normalizeClass.length) {
      return _htmlbarsUtilTemplateUtils.buildStatement('subexpr', '-join-classes', normalizedClass, []);
    }
  }

  function normalizeClasses(classes, output, streamBasePath) {
    for (var i = 0; i < classes.length; i++) {
      var className = classes[i];

      var _className$split = className.split(':');

      var propName = _className$split[0];
      var activeClass = _className$split[1];
      var inactiveClass = _className$split[2];

      // Legacy :class microsyntax for static class names
      if (propName === '') {
        output.push(activeClass);
        continue;
      }

      output.push(_htmlbarsUtilTemplateUtils.buildStatement('subexpr', '-normalize-class', [
      // params
      _htmlbarsUtilTemplateUtils.buildStatement('value', propName), _htmlbarsUtilTemplateUtils.buildStatement('get', propName)], [
      // hash
      'activeClass', activeClass, 'inactiveClass', inactiveClass]));
    }
  }
})(Em._e[69],Em._e[0],Em._e[30],Em._e[47],Em._e[40],Em._e[68],Em._e[66]);
(function (exports, _emberMetalSymbol) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  exports.getOwner = getOwner;
  exports.setOwner = setOwner;
  var OWNER = _emberMetalSymbol.default('OWNER');

  exports.OWNER = OWNER;
  /**
    Framework objects in an Ember application (components, services, routes, etc.)
    are created via a factory and dependency injection system. Each of these
    objects is the responsibility of an "owner", which handled its
    instantiation and manages its lifetime.
  
    `getOwner` fetches the owner object responsible for an instance. This can
    be used to lookup or resolve other class instances, or register new factories
    into the owner.
  
    For example, this component dynamically looks up a service based on the
    `audioType` passed as an attribute:
  
    ```
    // app/components/play-audio.js
    import Ember from 'ember';
  
    // Usage:
    //
    //   {{play-audio audioType=model.audioType audioFile=model.file}}
    //
    export default Ember.Component.extend({
      audioService: Ember.computed('audioType', function() {
        let owner = Ember.getOwner(this);
        return owner.lookup(`service:${this.get('audioType')}`);
      }),
      click() {
        let player = this.get('audioService');
        player.play(this.get('audioFile'));
      }
    });
    ```
  
    @method getOwner
    @for Ember
    @param {Object} object An object with an owner.
    @return {Object} An owner object.
    @since 2.3.0
    @public
  */

  function getOwner(object) {
    return object[OWNER];
  }

  /**
    `setOwner` forces a new owner on a given object instance. This is primarily
    useful in some testing cases.
  
    @method setOwner
    @for Ember
    @param {Object} object An object with an owner.
    @return {Object} An owner object.
    @since 2.3.0
    @public
  */

  function setOwner(object, owner) {
    object[OWNER] = owner;
  }
})(Em._e[70],Em._e[13]);
(function (exports, _emberMetalDebug, _emberMetalComputed, _emberMetalAlias, _emberMetalProperties, _containerOwner) {
  'use strict';

  exports.default = InjectedProperty;

  /**
    Read-only property that returns the result of a container lookup.
  
    @class InjectedProperty
    @namespace Ember
    @constructor
    @param {String} type The container type the property will lookup
    @param {String} name (optional) The name the property will lookup, defaults
           to the property's name
    @private
  */

  function InjectedProperty(type, name) {
    this.type = type;
    this.name = name;

    this._super$Constructor(injectedPropertyGet);
    AliasedPropertyPrototype.oneWay.call(this);
  }

  function injectedPropertyGet(keyName) {
    var desc = this[keyName];
    var owner = _containerOwner.getOwner(this) || this.container; // fallback to `container` for backwards compat

    return owner.lookup(desc.type + ':' + (desc.name || keyName));
  }

  InjectedProperty.prototype = Object.create(_emberMetalProperties.Descriptor.prototype);

  var InjectedPropertyPrototype = InjectedProperty.prototype;
  var ComputedPropertyPrototype = _emberMetalComputed.ComputedProperty.prototype;
  var AliasedPropertyPrototype = _emberMetalAlias.AliasedProperty.prototype;

  InjectedPropertyPrototype._super$Constructor = _emberMetalComputed.ComputedProperty;

  InjectedPropertyPrototype.get = ComputedPropertyPrototype.get;
  InjectedPropertyPrototype.readOnly = ComputedPropertyPrototype.readOnly;
  InjectedPropertyPrototype.teardown = ComputedPropertyPrototype.teardown;
})(Em._e[71],Em._e[0],Em._e[59],Em._e[62],Em._e[48],Em._e[70]);
(function (exports, _emberMetalDebug, _emberMetalInjected_property) {
  'use strict';

  exports.default = inject;
  exports.createInjectionHelper = createInjectionHelper;
  exports.validatePropertyInjections = validatePropertyInjections;

  /**
    Namespace for injection helper methods.
  
    @class inject
    @namespace Ember
    @static
    @public
  */

  function inject() {}

  // Dictionary of injection validations by type, added to by `createInjectionHelper`
  var typeValidators = {};

  /**
    This method allows other Ember modules to register injection helpers for a
    given container type. Helpers are exported to the `inject` namespace as the
    container type itself.
  
    @private
    @method createInjectionHelper
    @since 1.10.0
    @for Ember
    @param {String} type The container type the helper will inject
    @param {Function} validator A validation callback that is executed at mixin-time
  */

  function createInjectionHelper(type, validator) {
    typeValidators[type] = validator;

    inject[type] = function (name) {
      return new _emberMetalInjected_property.default(type, name);
    };
  }

  /**
    Validation function that runs per-type validation functions once for each
    injected type encountered.
  
    @private
    @method validatePropertyInjections
    @since 1.10.0
    @for Ember
    @param {Object} factory The factory object
  */

  function validatePropertyInjections(factory) {
    var proto = factory.proto();
    var types = [];

    for (var key in proto) {
      var desc = proto[key];
      if (desc instanceof _emberMetalInjected_property.default && types.indexOf(desc.type) === -1) {
        types.push(desc.type);
      }
    }

    if (types.length) {
      for (var i = 0; i < types.length; i++) {
        var validator = typeValidators[types[i]];

        if (typeof validator === 'function') {
          validator(factory);
        }
      }
    }

    return true;
  }
})(Em._e[72],Em._e[0],Em._e[71]);
(function (exports, _emberMetalDebug, _emberMetalFeatures, _emberMetalAssign, _emberMetalProperty_get, _emberMetalUtils, _emberMetalMeta, _emberMetalChains, _emberMetalEvents, _emberMetalMixin, _emberMetalError, _emberRuntimeMixinsAction_handler, _emberMetalProperties, _emberMetalBinding, _emberMetalComputed, _emberMetalInjected_property, _emberMetalRun_loop, _emberMetalWatching, _emberRuntimeInject, _emberMetalSymbol) {
  'no use strict';
  // Remove "use strict"; from transpiled module until
  // https://bugs.webkit.org/show_bug.cgi?id=138038 is fixed

  /**
    @module ember
    @submodule ember-runtime
  */

  // using ember-metal/lib/main here to ensure that ember-debug is setup
  // if present

  var _Mixin$create;

  var POST_INIT = _emberMetalSymbol.default('POST_INIT');
  exports.POST_INIT = POST_INIT;
  var schedule = _emberMetalRun_loop.default.schedule;
  var applyMixin = _emberMetalMixin.Mixin._apply;
  var finishPartial = _emberMetalMixin.Mixin.finishPartial;
  var reopen = _emberMetalMixin.Mixin.prototype.reopen;
  var hasCachedComputedProperties = false;

  function makeCtor() {
    // Note: avoid accessing any properties on the object since it makes the
    // method a lot faster. This is glue code so we want it to be as fast as
    // possible.

    var wasApplied = false;
    var initProperties;

    var Class = function () {
      if (!wasApplied) {
        Class.proto(); // prepare prototype...
      }

      if (arguments.length > 0) {
        initProperties = [arguments[0]];
      }

      this.__defineNonEnumerable(_emberMetalUtils.GUID_KEY_PROPERTY);
      var m = _emberMetalMeta.meta(this);
      var proto = m.proto;
      m.proto = this;
      if (initProperties) {
        // capture locally so we can clear the closed over variable
        var props = initProperties;
        initProperties = null;

        var concatenatedProperties = this.concatenatedProperties;
        var mergedProperties = this.mergedProperties;

        for (var i = 0; i < props.length; i++) {
          var properties = props[i];

          if (typeof properties !== 'object' && properties !== undefined) {
            throw new _emberMetalError.default('Ember.Object.create only accepts objects.');
          }

          if (!properties) {
            continue;
          }

          var keyNames = Object.keys(properties);

          for (var j = 0; j < keyNames.length; j++) {
            var keyName = keyNames[j];
            var value = properties[keyName];

            if (_emberMetalMixin.detectBinding(keyName)) {
              m.writeBindings(keyName, value);
            }

            var possibleDesc = this[keyName];
            var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

            if (concatenatedProperties && concatenatedProperties.length > 0 && concatenatedProperties.indexOf(keyName) >= 0) {
              var baseValue = this[keyName];

              if (baseValue) {
                if ('function' === typeof baseValue.concat) {
                  value = baseValue.concat(value);
                } else {
                  value = _emberMetalUtils.makeArray(baseValue).concat(value);
                }
              } else {
                value = _emberMetalUtils.makeArray(value);
              }
            }

            if (mergedProperties && mergedProperties.length && mergedProperties.indexOf(keyName) >= 0) {
              var originalValue = this[keyName];

              value = _emberMetalAssign.default({}, originalValue, value);
            }

            if (desc) {
              desc.set(this, keyName, value);
            } else {
              if (typeof this.setUnknownProperty === 'function' && !(keyName in this)) {
                this.setUnknownProperty(keyName, value);
              } else {
                if (false) {
                  _emberMetalProperties.defineProperty(this, keyName, null, value); // setup mandatory setter
                } else {
                    this[keyName] = value;
                  }
              }
            }
          }
        }
      }

      finishPartial(this, m);

      if (arguments.length === 0) {
        this.init();
      } else if (arguments.length === 1) {
        this.init(arguments[0]);
      } else {
        // v8 bug potentially incorrectly deopts this function: https://code.google.com/p/v8/issues/detail?id=3709
        // we may want to keep this around till this ages out on mobile
        var args = new Array(arguments.length);
        for (var x = 0; x < arguments.length; x++) {
          args[x] = arguments[x];
        }
        this.init.apply(this, args);
      }

      this[POST_INIT]();

      m.proto = proto;
      _emberMetalChains.finishChains(this);
      _emberMetalEvents.sendEvent(this, 'init');
    };

    Class.toString = _emberMetalMixin.Mixin.prototype.toString;
    Class.willReopen = function () {
      if (wasApplied) {
        Class.PrototypeMixin = _emberMetalMixin.Mixin.create(Class.PrototypeMixin);
      }

      wasApplied = false;
    };

    Class._initProperties = function (args) {
      initProperties = args;
    };

    Class.proto = function () {
      var superclass = Class.superclass;
      if (superclass) {
        superclass.proto();
      }

      if (!wasApplied) {
        wasApplied = true;
        Class.PrototypeMixin.applyPartial(Class.prototype);
      }

      return this.prototype;
    };

    return Class;
  }

  /**
    @class CoreObject
    @namespace Ember
    @public
  */
  var CoreObject = makeCtor();
  CoreObject.toString = function () {
    return 'Ember.CoreObject';
  };
  CoreObject.PrototypeMixin = _emberMetalMixin.Mixin.create((_Mixin$create = {
    reopen: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      applyMixin(this, args, true);
      return this;
    },

    /**
      An overridable method called when objects are instantiated. By default,
      does nothing unless it is overridden during class definition.
       Example:
       ```javascript
      App.Person = Ember.Object.extend({
        init: function() {
          alert('Name is ' + this.get('name'));
        }
      });
       var steve = App.Person.create({
        name: "Steve"
      });
       // alerts 'Name is Steve'.
      ```
       NOTE: If you do override `init` for a framework class like `Ember.View`,
      be sure to call `this._super(...arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
      @public
    */
    init: function () {}

  }, _Mixin$create[POST_INIT] = function () {}, _Mixin$create.__defineNonEnumerable = function (property) {
    Object.defineProperty(this, property.name, property.descriptor);
    //this[property.name] = property.descriptor.value;
  }, _Mixin$create.concatenatedProperties = null, _Mixin$create.mergedProperties = null, _Mixin$create.isDestroyed = false, _Mixin$create.isDestroying = false, _Mixin$create.destroy = function () {
    if (this.isDestroying) {
      return;
    }
    this.isDestroying = true;

    schedule('actions', this, this.willDestroy);
    schedule('destroy', this, this._scheduledDestroy);
    return this;
  }, _Mixin$create.willDestroy = function () {}, _Mixin$create._scheduledDestroy = function () {
    if (this.isDestroyed) {
      return;
    }
    _emberMetalWatching.destroy(this);
    this.isDestroyed = true;
  }, _Mixin$create.bind = function (to, from) {
    if (!(from instanceof _emberMetalBinding.Binding)) {
      from = _emberMetalBinding.Binding.from(from);
    }
    from.to(to).connect(this);
    return from;
  }, _Mixin$create.toString = function () {
    var hasToStringExtension = typeof this.toStringExtension === 'function';
    var extension = hasToStringExtension ? ':' + this.toStringExtension() : '';
    var ret = '<' + this.constructor.toString() + ':' + _emberMetalUtils.guidFor(this) + extension + '>';

    return ret;
  }, _Mixin$create));

  CoreObject.PrototypeMixin.ownerConstructor = CoreObject;

  CoreObject.__super__ = null;

  var ClassMixinProps = {

    ClassMixin: _emberMetalMixin.REQUIRED,

    PrototypeMixin: _emberMetalMixin.REQUIRED,

    isClass: true,

    isMethod: false,

    /**
      Creates a new subclass.
       ```javascript
      App.Person = Ember.Object.extend({
        say: function(thing) {
          alert(thing);
         }
      });
      ```
       This defines a new subclass of Ember.Object: `App.Person`. It contains one method: `say()`.
       You can also create a subclass from any existing class by calling its `extend()` method.
      For example, you might want to create a subclass of Ember's built-in `Ember.View` class:
       ```javascript
      App.PersonView = Ember.View.extend({
        tagName: 'li',
        classNameBindings: ['isAdministrator']
      });
      ```
       When defining a subclass, you can override methods but still access the
      implementation of your parent class by calling the special `_super()` method:
       ```javascript
      App.Person = Ember.Object.extend({
        say: function(thing) {
          var name = this.get('name');
          alert(name + ' says: ' + thing);
        }
      });
       App.Soldier = App.Person.extend({
        say: function(thing) {
          this._super(thing + ", sir!");
        },
        march: function(numberOfHours) {
          alert(this.get('name') + ' marches for ' + numberOfHours + ' hours.');
        }
      });
       var yehuda = App.Soldier.create({
        name: "Yehuda Katz"
      });
       yehuda.say("Yes");  // alerts "Yehuda Katz says: Yes, sir!"
      ```
       The `create()` on line #17 creates an *instance* of the `App.Soldier` class.
      The `extend()` on line #8 creates a *subclass* of `App.Person`. Any instance
      of the `App.Person` class will *not* have the `march()` method.
       You can also pass `Mixin` classes to add additional properties to the subclass.
       ```javascript
      App.Person = Ember.Object.extend({
        say: function(thing) {
          alert(this.get('name') + ' says: ' + thing);
        }
      });
       App.SingingMixin = Mixin.create({
        sing: function(thing){
          alert(this.get('name') + ' sings: la la la ' + thing);
        }
      });
       App.BroadwayStar = App.Person.extend(App.SingingMixin, {
        dance: function() {
          alert(this.get('name') + ' dances: tap tap tap tap ');
        }
      });
      ```
       The `App.BroadwayStar` class contains three methods: `say()`, `sing()`, and `dance()`.
       @method extend
      @static
       @param {Mixin} [mixins]* One or more Mixin classes
      @param {Object} [arguments]* Object containing values to use within the new class
      @public
    */
    extend: function () {
      var Class = makeCtor();
      var proto;
      Class.ClassMixin = _emberMetalMixin.Mixin.create(this.ClassMixin);
      Class.PrototypeMixin = _emberMetalMixin.Mixin.create(this.PrototypeMixin);

      Class.ClassMixin.ownerConstructor = Class;
      Class.PrototypeMixin.ownerConstructor = Class;

      reopen.apply(Class.PrototypeMixin, arguments);

      Class.superclass = this;
      Class.__super__ = this.prototype;

      proto = Class.prototype = Object.create(this.prototype);
      proto.constructor = Class;
      _emberMetalUtils.generateGuid(proto);
      _emberMetalMeta.meta(proto).proto = proto; // this will disable observers on prototype

      Class.ClassMixin.apply(Class);
      return Class;
    },

    /**
      Creates an instance of a class. Accepts either no arguments, or an object
      containing values to initialize the newly instantiated object with.
       ```javascript
      App.Person = Ember.Object.extend({
        helloWorld: function() {
          alert("Hi, my name is " + this.get('name'));
        }
      });
       var tom = App.Person.create({
        name: 'Tom Dale'
      });
       tom.helloWorld(); // alerts "Hi, my name is Tom Dale".
      ```
       `create` will call the `init` function if defined during
      `Ember.AnyObject.extend`
       If no arguments are passed to `create`, it will not set values to the new
      instance during initialization:
       ```javascript
      var noName = App.Person.create();
      noName.helloWorld(); // alerts undefined
      ```
       NOTE: For performance reasons, you cannot declare methods or computed
      properties during `create`. You should instead declare methods and computed
      properties when using `extend`.
       @method create
      @static
      @param [arguments]*
      @public
    */
    create: function () {
      var C = this;

      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      if (args.length > 0) {
        this._initProperties(args);
      }
      return new C();
    },

    /**
      Augments a constructor's prototype with additional
      properties and functions:
       ```javascript
      MyObject = Ember.Object.extend({
        name: 'an object'
      });
       o = MyObject.create();
      o.get('name'); // 'an object'
       MyObject.reopen({
        say: function(msg){
          console.log(msg);
        }
      })
       o2 = MyObject.create();
      o2.say("hello"); // logs "hello"
       o.say("goodbye"); // logs "goodbye"
      ```
       To add functions and properties to the constructor itself,
      see `reopenClass`
       @method reopen
      @public
    */
    reopen: function () {
      this.willReopen();
      reopen.apply(this.PrototypeMixin, arguments);
      return this;
    },

    /**
      Augments a constructor's own properties and functions:
       ```javascript
      MyObject = Ember.Object.extend({
        name: 'an object'
      });
       MyObject.reopenClass({
        canBuild: false
      });
       MyObject.canBuild; // false
      o = MyObject.create();
      ```
       In other words, this creates static properties and functions for the class.
      These are only available on the class and not on any instance of that class.
       ```javascript
      App.Person = Ember.Object.extend({
        name : "",
        sayHello : function() {
          alert("Hello. My name is " + this.get('name'));
        }
      });
       App.Person.reopenClass({
        species : "Homo sapiens",
        createPerson: function(newPersonsName){
          return App.Person.create({
            name:newPersonsName
          });
        }
      });
       var tom = App.Person.create({
        name : "Tom Dale"
      });
      var yehuda = App.Person.createPerson("Yehuda Katz");
       tom.sayHello(); // "Hello. My name is Tom Dale"
      yehuda.sayHello(); // "Hello. My name is Yehuda Katz"
      alert(App.Person.species); // "Homo sapiens"
      ```
       Note that `species` and `createPerson` are *not* valid on the `tom` and `yehuda`
      variables. They are only valid on `App.Person`.
       To add functions and properties to instances of
      a constructor by extending the constructor's prototype
      see `reopen`
       @method reopenClass
      @public
    */
    reopenClass: function () {
      reopen.apply(this.ClassMixin, arguments);
      applyMixin(this, arguments, false);
      return this;
    },

    detect: function (obj) {
      if ('function' !== typeof obj) {
        return false;
      }
      while (obj) {
        if (obj === this) {
          return true;
        }
        obj = obj.superclass;
      }
      return false;
    },

    detectInstance: function (obj) {
      return obj instanceof this;
    },

    /**
      In some cases, you may want to annotate computed properties with additional
      metadata about how they function or what values they operate on. For
      example, computed property functions may close over variables that are then
      no longer available for introspection.
       You can pass a hash of these values to a computed property like this:
       ```javascript
      person: function() {
        var personId = this.get('personId');
        return App.Person.create({ id: personId });
      }.property().meta({ type: App.Person })
      ```
       Once you've done this, you can retrieve the values saved to the computed
      property from your class like this:
       ```javascript
      MyClass.metaForProperty('person');
      ```
       This will return the original hash that was passed to `meta()`.
       @static
      @method metaForProperty
      @param key {String} property name
      @private
    */
    metaForProperty: function (key) {
      var proto = this.proto();
      var possibleDesc = proto[key];
      var desc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      return desc._meta || {};
    },

    _computedProperties: _emberMetalComputed.computed(function () {
      hasCachedComputedProperties = true;
      var proto = this.proto();
      var property;
      var properties = [];

      for (var name in proto) {
        property = proto[name];

        if (property && property.isDescriptor) {
          properties.push({
            name: name,
            meta: property._meta
          });
        }
      }
      return properties;
    }).readOnly(),

    /**
      Iterate over each computed property for the class, passing its name
      and any associated metadata (see `metaForProperty`) to the callback.
       @static
      @method eachComputedProperty
      @param {Function} callback
      @param {Object} binding
      @private
    */
    eachComputedProperty: function (callback, binding) {
      var property;
      var empty = {};

      var properties = _emberMetalProperty_get.get(this, '_computedProperties');

      for (var i = 0; i < properties.length; i++) {
        property = properties[i];
        callback.call(binding || this, property.name, property.meta || empty);
      }
    }
  };

  function injectedPropertyAssertion() {}

  /**
    Returns a hash of property names and container names that injected
    properties will lookup on the container lazily.
  
    @method _lazyInjections
    @return {Object} Hash of all lazy injected property keys to container names
    @private
  */
  ClassMixinProps._lazyInjections = function () {
    var injections = {};
    var proto = this.proto();
    var key, desc;

    for (key in proto) {
      desc = proto[key];
      if (desc instanceof _emberMetalInjected_property.default) {
        injections[key] = desc.type + ':' + (desc.name || key);
      }
    }

    return injections;
  };

  var ClassMixin = _emberMetalMixin.Mixin.create(ClassMixinProps);

  ClassMixin.ownerConstructor = CoreObject;

  CoreObject.ClassMixin = ClassMixin;

  ClassMixin.apply(CoreObject);

  CoreObject.reopen({
    didDefineProperty: function (proto, key, value) {
      if (hasCachedComputedProperties === false) {
        return;
      }
      if (value instanceof _emberMetalComputed.ComputedProperty) {
        var cache = _emberMetalMeta.meta(this.constructor).readableCache();

        if (cache && cache._computedProperties !== undefined) {
          cache._computedProperties = undefined;
        }
      }
    }
  });

  exports.default = CoreObject;
})(Em._e[73],Em._e[0],Em._e[10],Em._e[8],Em._e[30],Em._e[7],Em._e[14],Em._e[51],Em._e[15],Em._e[61],Em._e[31],Em._e[63],Em._e[48],Em._e[60],Em._e[59],Em._e[71],Em._e[27],Em._e[52],Em._e[72],Em._e[13]);
(function (exports, _emberMetalProperty_get) {
  'use strict';

  exports.default = getProperties;

  /**
    To get multiple properties at once, call `Ember.getProperties`
    with an object followed by a list of strings or an array:
  
    ```javascript
    Ember.getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    is equivalent to:
  
    ```javascript
    Ember.getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    @method getProperties
    @for Ember
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
    @public
  */

  function getProperties(obj) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;

    if (arguments.length === 2 && Array.isArray(arguments[1])) {
      i = 0;
      propertyNames = arguments[1];
    }
    for (; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = _emberMetalProperty_get.get(obj, propertyNames[i]);
    }
    return ret;
  }
})(Em._e[74],Em._e[30]);
(function (exports) {
  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.
  
    ```javascript
    Ember.isNone();              // true
    Ember.isNone(null);          // true
    Ember.isNone(undefined);     // true
    Ember.isNone('');            // false
    Ember.isNone([]);            // false
    Ember.isNone(function() {}); // false
    ```
  
    @method isNone
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */
  "use strict";

  exports.default = isNone;

  function isNone(obj) {
    return obj === null || obj === undefined;
  }
})(Em._e[75]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalGet_properties, _emberMetalSet_properties, _emberMetalMixin, _emberMetalEvents, _emberMetalProperty_events, _emberMetalObserver, _emberMetalComputed, _emberMetalIs_none) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  /**
    ## Overview
  
    This mixin provides properties and property observing functionality, core
    features of the Ember object model.
  
    Properties and observers allow one object to observe changes to a
    property on another object. This is one of the fundamental ways that
    models, controllers and views communicate with each other in an Ember
    application.
  
    Any object that has this mixin applied can be used in observer
    operations. That includes `Ember.Object` and most objects you will
    interact with as you write your Ember application.
  
    Note that you will not generally apply this mixin to classes yourself,
    but you will use the features provided by this module frequently, so it
    is important to understand how to use it.
  
    ## Using `get()` and `set()`
  
    Because of Ember's support for bindings and observers, you will always
    access properties using the get method, and set properties using the
    set method. This allows the observing objects to be notified and
    computed properties to be handled properly.
  
    More documentation about `get` and `set` are below.
  
    ## Observing Property Changes
  
    You typically observe property changes simply by using the `Ember.observer`
    function in classes that you write.
  
    For example:
  
    ```javascript
    Ember.Object.extend({
      valueObserver: Ember.observer('value', function(sender, key, value, rev) {
        // Executes whenever the "value" property changes
        // See the addObserver method for more information about the callback arguments
      })
    });
    ```
  
    Although this is the most common way to add an observer, this capability
    is actually built into the `Ember.Object` class on top of two methods
    defined in this mixin: `addObserver` and `removeObserver`. You can use
    these two methods to add and remove observers yourself if you need to
    do so at runtime.
  
    To add an observer for a property, call:
  
    ```javascript
    object.addObserver('propertyKey', targetObject, targetAction)
    ```
  
    This will call the `targetAction` method on the `targetObject` whenever
    the value of the `propertyKey` changes.
  
    Note that if `propertyKey` is a computed property, the observer will be
    called when any of the property dependencies are changed, even if the
    resulting value of the computed property is unchanged. This is necessary
    because computed properties are not computed until `get` is called.
  
    @class Observable
    @namespace Ember
    @public
  */
  exports.default = _emberMetalMixin.Mixin.create({

    /**
      Retrieves the value of a property from the object.
       This method is usually similar to using `object[keyName]` or `object.keyName`,
      however it supports both computed properties and the unknownProperty
      handler.
       Because `get` unifies the syntax for accessing all these kinds
      of properties, it can make many refactorings easier, such as replacing a
      simple property with a computed property, or vice versa.
       ### Computed Properties
       Computed properties are methods defined with the `property` modifier
      declared at the end, such as:
       ```javascript
      fullName: function() {
        return this.get('firstName') + ' ' + this.get('lastName');
      }.property('firstName', 'lastName')
      ```
       When you call `get` on a computed property, the function will be
      called and the return value will be returned instead of the function
      itself.
       ### Unknown Properties
       Likewise, if you try to call `get` on a property whose value is
      `undefined`, the `unknownProperty()` method will be called on the object.
      If this method returns any value other than `undefined`, it will be returned
      instead. This allows you to implement "virtual" properties that are
      not defined upfront.
       @method get
      @param {String} keyName The property to retrieve
      @return {Object} The property value or undefined.
      @public
    */
    get: function (keyName) {
      return _emberMetalProperty_get.get(this, keyName);
    },

    /**
      To get the values of multiple properties at once, call `getProperties`
      with a list of strings or an array:
       ```javascript
      record.getProperties('firstName', 'lastName', 'zipCode');
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       is equivalent to:
       ```javascript
      record.getProperties(['firstName', 'lastName', 'zipCode']);
      // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
      ```
       @method getProperties
      @param {String...|Array} list of keys to get
      @return {Object}
      @public
    */
    getProperties: function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _emberMetalGet_properties.default.apply(null, [this].concat(args));
    },

    /**
      Sets the provided key or path to the value.
       This method is generally very similar to calling `object[key] = value` or
      `object.key = value`, except that it provides support for computed
      properties, the `setUnknownProperty()` method and property observers.
       ### Computed Properties
       If you try to set a value on a key that has a computed property handler
      defined (see the `get()` method for an example), then `set()` will call
      that method, passing both the value and key instead of simply changing
      the value itself. This is useful for those times when you need to
      implement a property that is composed of one or more member
      properties.
       ### Unknown Properties
       If you try to set a value on a key that is undefined in the target
      object, then the `setUnknownProperty()` handler will be called instead. This
      gives you an opportunity to implement complex "virtual" properties that
      are not predefined on the object. If `setUnknownProperty()` returns
      undefined, then `set()` will simply set the value on the object.
       ### Property Observers
       In addition to changing the property, `set()` will also register a property
      change with the object. Unless you have placed this call inside of a
      `beginPropertyChanges()` and `endPropertyChanges(),` any "local" observers
      (i.e. observer methods declared on the same object), will be called
      immediately. Any "remote" observers (i.e. observer methods declared on
      another object) will be placed in a queue and called at a later time in a
      coalesced manner.
       @method set
      @param {String} keyName The property to set
      @param {Object} value The value to set or `null`.
      @return {Object} The passed value
      @public
    */
    set: function (keyName, value) {
      return _emberMetalProperty_set.set(this, keyName, value);
    },

    /**
      Sets a list of properties at once. These properties are set inside
      a single `beginPropertyChanges` and `endPropertyChanges` batch, so
      observers will be buffered.
       ```javascript
      record.setProperties({ firstName: 'Charles', lastName: 'Jolley' });
      ```
       @method setProperties
      @param {Object} hash the hash of keys and values to set
      @return {Object} The passed in hash
      @public
    */
    setProperties: function (hash) {
      return _emberMetalSet_properties.default(this, hash);
    },

    /**
      Begins a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call this
      method at the beginning of the changes to begin deferring change
      notifications. When you are done making changes, call
      `endPropertyChanges()` to deliver the deferred change notifications and end
      deferring.
       @method beginPropertyChanges
      @return {Ember.Observable}
      @private
    */
    beginPropertyChanges: function () {
      _emberMetalProperty_events.beginPropertyChanges();
      return this;
    },

    /**
      Ends a grouping of property changes.
       You can use this method to group property changes so that notifications
      will not be sent until the changes are finished. If you plan to make a
      large number of changes to an object at one time, you should call
      `beginPropertyChanges()` at the beginning of the changes to defer change
      notifications. When you are done making changes, call this method to
      deliver the deferred change notifications and end deferring.
       @method endPropertyChanges
      @return {Ember.Observable}
      @private
    */
    endPropertyChanges: function () {
      _emberMetalProperty_events.endPropertyChanges();
      return this;
    },

    /**
      Notify the observer system that a property is about to change.
       Sometimes you need to change a value directly or indirectly without
      actually calling `get()` or `set()` on it. In this case, you can use this
      method and `propertyDidChange()` instead. Calling these two methods
      together will notify all observers that the property has potentially
      changed value.
       Note that you must always call `propertyWillChange` and `propertyDidChange`
      as a pair. If you do not, it may get the property change groups out of
      order and cause notifications to be delivered more often than you would
      like.
       @method propertyWillChange
      @param {String} keyName The property key that is about to change.
      @return {Ember.Observable}
      @private
    */
    propertyWillChange: function (keyName) {
      _emberMetalProperty_events.propertyWillChange(this, keyName);
      return this;
    },

    /**
      Notify the observer system that a property has just changed.
       Sometimes you need to change a value directly or indirectly without
      actually calling `get()` or `set()` on it. In this case, you can use this
      method and `propertyWillChange()` instead. Calling these two methods
      together will notify all observers that the property has potentially
      changed value.
       Note that you must always call `propertyWillChange` and `propertyDidChange`
      as a pair. If you do not, it may get the property change groups out of
      order and cause notifications to be delivered more often than you would
      like.
       @method propertyDidChange
      @param {String} keyName The property key that has just changed.
      @return {Ember.Observable}
      @private
    */
    propertyDidChange: function (keyName) {
      _emberMetalProperty_events.propertyDidChange(this, keyName);
      return this;
    },

    /**
      Convenience method to call `propertyWillChange` and `propertyDidChange` in
      succession.
       @method notifyPropertyChange
      @param {String} keyName The property key to be notified about.
      @return {Ember.Observable}
      @public
    */
    notifyPropertyChange: function (keyName) {
      this.propertyWillChange(keyName);
      this.propertyDidChange(keyName);
      return this;
    },

    /**
      Adds an observer on a property.
       This is the core method used to register an observer for a property.
       Once you call this method, any time the key's value is set, your observer
      will be notified. Note that the observers are triggered any time the
      value is set, regardless of whether it has actually changed. Your
      observer should be prepared to handle that.
       You can also pass an optional context parameter to this method. The
      context will be passed to your observer method whenever it is triggered.
      Note that if you add the same target/method pair on a key multiple times
      with different context parameters, your observer will only be called once
      with the last context you passed.
       ### Observer Methods
       Observer methods you pass should generally have the following signature if
      you do not pass a `context` parameter:
       ```javascript
      fooDidChange: function(sender, key, value, rev) { };
      ```
       The sender is the object that changed. The key is the property that
      changes. The value property is currently reserved and unused. The rev
      is the last property revision of the object when it changed, which you can
      use to detect if the key value has really changed or not.
       If you pass a `context` parameter, the context will be passed before the
      revision like so:
       ```javascript
      fooDidChange: function(sender, key, value, context, rev) { };
      ```
       Usually you will not need the value, context or revision parameters at
      the end. In this case, it is common to write observer methods that take
      only a sender and key value as parameters or, if you aren't interested in
      any of these values, to write an observer that has no parameters at all.
       @method addObserver
      @param {String} key The key to observer
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke.
      @public
    */
    addObserver: function (key, target, method) {
      _emberMetalObserver.addObserver(this, key, target, method);
    },

    /**
      Remove an observer you have previously registered on this object. Pass
      the same key, target, and method you passed to `addObserver()` and your
      target will no longer receive notifications.
       @method removeObserver
      @param {String} key The key to observer
      @param {Object} target The target object to invoke
      @param {String|Function} method The method to invoke.
      @public
    */
    removeObserver: function (key, target, method) {
      _emberMetalObserver.removeObserver(this, key, target, method);
    },

    /**
      Returns `true` if the object currently has observers registered for a
      particular key. You can use this method to potentially defer performing
      an expensive action until someone begins observing a particular property
      on the object.
       @method hasObserverFor
      @param {String} key Key to check
      @return {Boolean}
      @private
    */
    hasObserverFor: function (key) {
      return _emberMetalEvents.hasListeners(this, key + ':change');
    },

    /**
      Retrieves the value of a property, or a default value in the case that the
      property returns `undefined`.
       ```javascript
      person.getWithDefault('lastName', 'Doe');
      ```
       @method getWithDefault
      @param {String} keyName The name of the property to retrieve
      @param {Object} defaultValue The value to return if the property value is undefined
      @return {Object} The property value or the defaultValue.
      @public
    */
    getWithDefault: function (keyName, defaultValue) {
      return _emberMetalProperty_get.getWithDefault(this, keyName, defaultValue);
    },

    /**
      Set the value of a property to the current value plus some amount.
       ```javascript
      person.incrementProperty('age');
      team.incrementProperty('score', 2);
      ```
       @method incrementProperty
      @param {String} keyName The name of the property to increment
      @param {Number} increment The amount to increment by. Defaults to 1
      @return {Number} The new property value
      @public
    */
    incrementProperty: function (keyName, increment) {
      if (_emberMetalIs_none.default(increment)) {
        increment = 1;
      }

      return _emberMetalProperty_set.set(this, keyName, (parseFloat(_emberMetalProperty_get.get(this, keyName)) || 0) + increment);
    },

    /**
      Set the value of a property to the current value minus some amount.
       ```javascript
      player.decrementProperty('lives');
      orc.decrementProperty('health', 5);
      ```
       @method decrementProperty
      @param {String} keyName The name of the property to decrement
      @param {Number} decrement The amount to decrement by. Defaults to 1
      @return {Number} The new property value
      @public
    */
    decrementProperty: function (keyName, decrement) {
      if (_emberMetalIs_none.default(decrement)) {
        decrement = 1;
      }

      return _emberMetalProperty_set.set(this, keyName, (_emberMetalProperty_get.get(this, keyName) || 0) - decrement);
    },

    /**
      Set the value of a boolean property to the opposite of its
      current value.
       ```javascript
      starship.toggleProperty('warpDriveEngaged');
      ```
       @method toggleProperty
      @param {String} keyName The name of the property to toggle
      @return {Boolean} The new property value
      @public
    */
    toggleProperty: function (keyName) {
      return _emberMetalProperty_set.set(this, keyName, !_emberMetalProperty_get.get(this, keyName));
    },

    /**
      Returns the cached value of a computed property, if it exists.
      This allows you to inspect the value of a computed property
      without accidentally invoking it if it is intended to be
      generated lazily.
       @method cacheFor
      @param {String} keyName
      @return {Object} The cached value of the computed property, if any
      @public
    */
    cacheFor: function (keyName) {
      return _emberMetalComputed.cacheFor(this, keyName);
    },

    // intended for debugging purposes
    observersForKey: function (keyName) {
      return _emberMetalObserver.observersFor(this, keyName);
    }
  });
})(Em._e[76],Em._e[0],Em._e[30],Em._e[32],Em._e[74],Em._e[33],Em._e[61],Em._e[15],Em._e[20],Em._e[53],Em._e[59],Em._e[75]);
(function (exports, _emberRuntimeSystemCore_object, _emberRuntimeMixinsObservable) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  /**
    `Ember.Object` is the main base class for all Ember objects. It is a subclass
    of `Ember.CoreObject` with the `Ember.Observable` mixin applied. For details,
    see the documentation for each of these.
  
    @class Object
    @namespace Ember
    @extends Ember.CoreObject
    @uses Ember.Observable
    @public
  */
  var EmberObject = _emberRuntimeSystemCore_object.default.extend(_emberRuntimeMixinsObservable.default);
  EmberObject.toString = function () {
    return 'Ember.Object';
  };

  exports.default = EmberObject;
})(Em._e[77],Em._e[73],Em._e[76]);
(function (exports, _emberRuntimeSystemObject, _emberHtmlbarsStreamsStream) {
  'use strict';

  var ProxyStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (source, label) {
      this.label = label;
      this.sourceDep = this.addMutableDependency(source);
    },

    compute: function () {
      return this.sourceDep.getValue();
    },

    setValue: function (value) {
      this.sourceDep.setValue(value);
    },

    setSource: function (source) {
      var didChange = this.sourceDep.replace(source);
      if (didChange || !(source instanceof _emberRuntimeSystemObject.default)) {
        // If the source changed, we must notify. If the source is not
        // an Ember.Object, we must also notify, because it could have
        // interior mutability that is otherwise not being observed.
        this.notify();
      }
    }
  });

  ProxyStream.extend = _emberHtmlbarsStreamsStream.default.extend;

  exports.default = ProxyStream;
})(Em._e[78],Em._e[77],Em._e[56]);
(function (exports, _emberMetalDebug, _emberMetalCache) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.validateLazyHelperName = validateLazyHelperName;
  exports.findHelper = findHelper;
  exports.default = lookupHelper;
  var CONTAINS_DASH_CACHE = new _emberMetalCache.default(1000, function (key) {
    return key.indexOf('-') !== -1;
  });
  exports.CONTAINS_DASH_CACHE = CONTAINS_DASH_CACHE;
  var CONTAINS_DOT_CACHE = new _emberMetalCache.default(1000, function (key) {
    return key.indexOf('.') !== -1;
  });

  exports.CONTAINS_DOT_CACHE = CONTAINS_DOT_CACHE;

  function validateLazyHelperName(helperName, container, keywords) {
    return container && !(helperName in keywords);
  }

  /**
    Used to lookup/resolve handlebars helpers. The lookup order is:
  
    * Look for a registered helper
    * If a dash exists in the name:
      * Look for a helper registed in the container.
      * Use Ember.ComponentLookup to find an Ember.Component that resolves
        to the given name.
  
    @private
    @method resolveHelper
    @param {String} name The name of the helper to lookup.
    @return {Helper}
  */
  function _findHelper(name, view, env, options) {
    var helper = env.helpers[name];

    if (!helper) {
      var owner = env.owner;
      if (validateLazyHelperName(name, owner, env.hooks.keywords)) {
        var helperName = 'helper:' + name;
        // See https://github.com/emberjs/ember.js/issues/13071
        // See https://bugs.chromium.org/p/v8/issues/detail?id=4839
        var registered = owner.hasRegistration(helperName, options);
        if (registered) {
          helper = owner._lookupFactory(helperName, options);
        }
      }
    }

    return helper;
  }

  function findHelper(name, view, env) {
    var options = {};
    var moduleName = env.meta && env.meta.moduleName;
    if (moduleName) {
      options.source = 'template:' + moduleName;
    }

    var localHelper = _findHelper(name, view, env, options);

    // Local match found, use it.
    if (localHelper) {
      return localHelper;
    }

    // Fall back to global.
    return _findHelper(name, view, env);
  }

  function lookupHelper(name, view, env) {
    var helper = findHelper(name, view, env);

    return helper;
  }
})(Em._e[79],Em._e[0],Em._e[28]);
(function (exports, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = _emberHtmlbarsStreamsStream.default.extend({
    init: function (helper, params, hash, label) {
      this.helper = helper;
      this.params = params;
      this.hash = hash;
      this.linkable = true;
      this.label = label;
    },

    compute: function () {
      return this.helper.compute(_emberHtmlbarsStreamsUtils.getArrayValues(this.params), _emberHtmlbarsStreamsUtils.getHashValues(this.hash));
    }
  });
})(Em._e[80],Em._e[56],Em._e[66]);
(function (exports, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = _emberHtmlbarsStreamsStream.default.extend({
    init: function (helperFactory, params, hash, label) {
      this.helperFactory = helperFactory;
      this.params = params;
      this.hash = hash;
      this.linkable = true;
      this.helper = null;
      this.label = label;
    },

    compute: function () {
      if (!this.helper) {
        this.helper = this.helperFactory.create({ _stream: this });
      }
      return this.helper.compute(_emberHtmlbarsStreamsUtils.getArrayValues(this.params), _emberHtmlbarsStreamsUtils.getHashValues(this.hash));
    },

    deactivate: function () {
      this.super$deactivate();
      if (this.helper) {
        this.helper.destroy();
        this.helper = null;
      }
    },
    super$deactivate: _emberHtmlbarsStreamsStream.default.prototype.deactivate
  });
})(Em._e[81],Em._e[56],Em._e[66]);
(function (exports, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = _emberHtmlbarsStreamsStream.default.extend({
    init: function (helper, params, hash, templates, env, scope, label) {
      this.helper = helper;
      this.params = params;
      this.templates = templates;
      this._env = env;
      this.scope = scope;
      this.hash = hash;
      this.label = label;
    },

    compute: function () {
      return this.helper(_emberHtmlbarsStreamsUtils.getArrayValues(this.params), _emberHtmlbarsStreamsUtils.getHashValues(this.hash), this.templates, this._env, this.scope);
    }
  });
})(Em._e[82],Em._e[56],Em._e[66]);
(function (exports, _emberMetalDebug, _emberHtmlbarsStreamsHelperInstance, _emberHtmlbarsStreamsHelperFactory, _emberHtmlbarsStreamsBuiltInHelper) {
  'use strict';

  exports.buildHelperStream = buildHelperStream;

  function buildHelperStream(helper, params, hash, templates, env, scope, label) {
    var isAnyKindOfHelper = helper.isHelperInstance || helper.isHelperFactory;

    if (helper.isHelperFactory) {
      return new _emberHtmlbarsStreamsHelperFactory.default(helper, params, hash, label);
    } else if (helper.isHelperInstance) {
      return new _emberHtmlbarsStreamsHelperInstance.default(helper, params, hash, label);
    } else {
      templates = templates || { template: {}, inverse: {} };
      return new _emberHtmlbarsStreamsBuiltInHelper.default(helper, params, hash, templates, env, scope, label);
    }
  }
})(Em._e[83],Em._e[0],Em._e[80],Em._e[81],Em._e[82]);
(function (exports, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = subscribe;

  function subscribe(node, env, scope, stream) {
    if (!_emberHtmlbarsStreamsUtils.isStream(stream)) {
      return;
    }
    var component = scope.getComponent();
    var unsubscribers = node.streamUnsubscribers = node.streamUnsubscribers || [];

    unsubscribers.push(stream.subscribe(function () {
      node.isDirty = true;

      // Whenever a render node directly inside a component becomes
      // dirty, we want to invoke the willRenderElement and
      // didRenderElement lifecycle hooks. From the perspective of the
      // programming model, whenever anything in the DOM changes, a
      // "re-render" has occured.
      if (component && component._renderNode) {
        component._renderNode.isDirty = true;
      }

      if (node.getState().manager) {
        node.shouldReceiveAttrs = true;
      }

      node.ownerNode.emberView.scheduleRevalidate(node, _emberHtmlbarsStreamsUtils.labelFor(stream));
    }));
  }
})(Em._e[84],Em._e[66]);
(function (exports, _emberEnvironment) {
  'use strict';

  /**
  @module ember
  @submodule ember-metal
  */

  /**
    This namespace contains all Ember methods and functions. Future versions of
    Ember may overwrite this namespace and therefore, you should avoid adding any
    new properties.
  
    At the heart of Ember is Ember-Runtime, a set of core functions that provide
    cross-platform compatibility and object property observing.  Ember-Runtime is
    small and performance-focused so you can use it alongside other
    cross-platform libraries such as jQuery. For more details, see
    [Ember-Runtime](http://emberjs.com/api/modules/ember-runtime.html).
  
    @class Ember
    @static
    @public
  */
  var Ember = typeof _emberEnvironment.context.imports.Ember === 'object' && _emberEnvironment.context.imports.Ember || {};

  // Make sure these are set whether Ember was already defined or not
  Ember.isNamespace = true;

  Ember.toString = function () {
    return 'Ember';
  };

  // ..........................................................
  // BOOTSTRAP
  //

  exports.default = Ember;
})(Em._e[85],Em._e[4]);
(function (exports, _emberMetalMixin) {
  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  /**
    Implements some standard methods for comparing objects. Add this mixin to
    any class you create that can compare its instances.
  
    You should implement the `compare()` method.
  
    @class Comparable
    @namespace Ember
    @since Ember 0.9
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create({

    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return the result of the comparison of the two parameters. The
      compare method should return:
       - `-1` if `a < b`
      - `0` if `a == b`
      - `1` if `a > b`
       Default implementation raises an exception.
       @method compare
      @param a {Object} the first object to compare
      @param b {Object} the second object to compare
      @return {Number} the result of the comparison
      @private
    */
    compare: null
  });
})(Em._e[86],Em._e[61]);
(function (exports, _emberRuntimeUtils, _emberRuntimeMixinsComparable) {
  'use strict';

  exports.default = compare;

  var TYPE_ORDER = {
    'undefined': 0,
    'null': 1,
    'boolean': 2,
    'number': 3,
    'string': 4,
    'array': 5,
    'object': 6,
    'instance': 7,
    'function': 8,
    'class': 9,
    'date': 10
  };

  //
  // the spaceship operator
  //
  //                      `. ___
  //                     __,' __`.                _..----....____
  //         __...--.'``;.   ,.   ;``--..__     .'    ,-._    _.-'
  //   _..-''-------'   `'   `'   `'     O ``-''._   (,;') _,'
  // ,'________________                          \`-._`-','
  //  `._              ```````````------...___   '-.._'-:
  //     ```--.._      ,.                     ````--...__\-.
  //             `.--. `-` "INFINITY IS LESS     ____    |  |`
  //               `. `.   THAN BEYOND"        ,'`````.  ;  ;`
  //                 `._`.        __________   `.      \'__/`
  //                    `-:._____/______/___/____`.     \  `
  //                                |       `._    `.    \
  //                                `._________`-.   `.   `.___
  //                                              SSt  `------'`
  function spaceship(a, b) {
    var diff = a - b;
    return (diff > 0) - (diff < 0);
  }

  /**
   Compares two javascript values and returns:
  
    - -1 if the first is smaller than the second,
    - 0 if both are equal,
    - 1 if the first is greater than the second.
  
    ```javascript
    Ember.compare('hello', 'hello');  // 0
    Ember.compare('abc', 'dfg');      // -1
    Ember.compare(2, 1);              // 1
    ```
  
   If the types of the two objects are different precedence occurs in the
   following order, with types earlier in the list considered `<` types
   later in the list:
  
    - undefined
    - null
    - boolean
    - number
    - string
    - array
    - object
    - instance
    - function
    - class
    - date
  
    ```javascript
    Ember.compare('hello', 50);       // 1
    Ember.compare(50, 'hello');       // -1
    ```
  
   @method compare
   @for Ember
   @param {Object} v First value to compare
   @param {Object} w Second value to compare
   @return {Number} -1 if v < w, 0 if v = w and 1 if v > w.
   @public
  */

  function compare(v, w) {
    if (v === w) {
      return 0;
    }

    var type1 = _emberRuntimeUtils.typeOf(v);
    var type2 = _emberRuntimeUtils.typeOf(w);

    if (_emberRuntimeMixinsComparable.default) {
      if (type1 === 'instance' && _emberRuntimeMixinsComparable.default.detect(v) && v.constructor.compare) {
        return v.constructor.compare(v, w);
      }

      if (type2 === 'instance' && _emberRuntimeMixinsComparable.default.detect(w) && w.constructor.compare) {
        return w.constructor.compare(w, v) * -1;
      }
    }

    var res = spaceship(TYPE_ORDER[type1], TYPE_ORDER[type2]);

    if (res !== 0) {
      return res;
    }

    // types are equal - so we have to check values now
    switch (type1) {
      case 'boolean':
      case 'number':
        return spaceship(v, w);

      case 'string':
        return spaceship(v.localeCompare(w), 0);

      case 'array':
        var vLen = v.length;
        var wLen = w.length;
        var len = Math.min(vLen, wLen);

        for (var i = 0; i < len; i++) {
          var r = compare(v[i], w[i]);
          if (r !== 0) {
            return r;
          }
        }

        // all elements are equal now
        // shorter array should be ordered first
        return spaceship(vLen, wLen);

      case 'instance':
        if (_emberRuntimeMixinsComparable.default && _emberRuntimeMixinsComparable.default.detect(v)) {
          return v.compare(v, w);
        }
        return 0;

      case 'date':
        return spaceship(v.getTime(), w.getTime());

      default:
        return 0;
    }
  }
})(Em._e[87],Em._e[91],Em._e[86]);
(function (exports, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalMixin, _emberMetalUtils, _emberMetalComputed, _emberMetalEmpty_object, _emberMetalFeatures, _emberMetalProperty_events, _emberMetalEvents, _emberRuntimeCompare, _require, _emberMetalDebug) {
  /**
  @module ember
  @submodule ember-runtime
  */

  // ..........................................................
  // HELPERS
  //

  'use strict';

  var _emberA = undefined;

  function emberA() {
    return (_emberA || (_emberA = _require.default('ember-runtime/system/native_array').A))();
  }

  var contexts = [];

  function popCtx() {
    return contexts.length === 0 ? {} : contexts.pop();
  }

  function pushCtx(ctx) {
    contexts.push(ctx);
    return null;
  }

  function iter(key, value) {
    var valueProvided = arguments.length === 2;

    function i(item) {
      var cur = _emberMetalProperty_get.get(item, key);
      return valueProvided ? value === cur : !!cur;
    }

    return i;
  }

  /**
    This mixin defines the common interface implemented by enumerable objects
    in Ember. Most of these methods follow the standard Array iteration
    API defined up to JavaScript 1.8 (excluding language-specific features that
    cannot be emulated in older versions of JavaScript).
  
    This mixin is applied automatically to the Array class on page load, so you
    can use any of these methods on simple arrays. If Array already implements
    one of these methods, the mixin will not override them.
  
    ## Writing Your Own Enumerable
  
    To make your own custom class enumerable, you need two items:
  
    1. You must have a length property. This property should change whenever
       the number of items in your enumerable object changes. If you use this
       with an `Ember.Object` subclass, you should be sure to change the length
       property using `set().`
  
    2. You must implement `nextObject().` See documentation.
  
    Once you have these two methods implemented, apply the `Ember.Enumerable` mixin
    to your class and you will be able to enumerate the contents of your object
    like any other collection.
  
    ## Using Ember Enumeration with Other Libraries
  
    Many other libraries provide some kind of iterator or enumeration like
    facility. This is often where the most common API conflicts occur.
    Ember's API is designed to be as friendly as possible with other
    libraries by implementing only methods that mostly correspond to the
    JavaScript 1.8 API.
  
    @class Enumerable
    @namespace Ember
    @since Ember 0.9
    @private
  */
  var Enumerable = _emberMetalMixin.Mixin.create({

    /**
      __Required.__ You must implement this method to apply this mixin.
       Implement this method to make your class enumerable.
       This method will be called repeatedly during enumeration. The index value
      will always begin with 0 and increment monotonically. You don't have to
      rely on the index value to determine what object to return, but you should
      always check the value and start from the beginning when you see the
      requested index is 0.
       The `previousObject` is the object that was returned from the last call
      to `nextObject` for the current iteration. This is a useful way to
      manage iteration if you are tracing a linked list, for example.
       Finally the context parameter will always contain a hash you can use as
      a "scratchpad" to maintain any other state you need in order to iterate
      properly. The context object is reused and is not reset between
      iterations so make sure you setup the context with a fresh state whenever
      the index parameter is 0.
       Generally iterators will continue to call `nextObject` until the index
      reaches the current length-1. If you run out of data before this
      time for some reason, you should simply return undefined.
       The default implementation of this method simply looks up the index.
      This works great on any Array-like objects.
       @method nextObject
      @param {Number} index the current index of the iteration
      @param {Object} previousObject the value returned by the last call to
        `nextObject`.
      @param {Object} context a context object you can use to maintain state.
      @return {Object} the next object in the iteration or undefined
      @private
    */
    nextObject: null,

    /**
      Helper method returns the first object from a collection. This is usually
      used by bindings and other parts of the framework to extract a single
      object if the enumerable contains only one item.
       If you override this method, you should implement it so that it will
      always return the same value each time it is called. If your enumerable
      contains only one object, this method should always return that object.
      If your enumerable is empty, this method should return `undefined`.
       ```javascript
      let arr = ['a', 'b', 'c'];
      arr.get('firstObject');  // 'a'
       let arr = [];
      arr.get('firstObject');  // undefined
      ```
       @property firstObject
      @return {Object} the object or undefined
      @readOnly
      @public
    */
    firstObject: _emberMetalComputed.computed('[]', function () {
      if (_emberMetalProperty_get.get(this, 'length') === 0) {
        return undefined;
      }

      // handle generic enumerables
      var context = popCtx();
      var ret = this.nextObject(0, null, context);

      pushCtx(context);

      return ret;
    }).readOnly(),

    /**
      Helper method returns the last object from a collection. If your enumerable
      contains only one object, this method should always return that object.
      If your enumerable is empty, this method should return `undefined`.
       ```javascript
      let arr = ['a', 'b', 'c'];
      arr.get('lastObject');  // 'c'
       let arr = [];
      arr.get('lastObject');  // undefined
      ```
       @property lastObject
      @return {Object} the last object or undefined
      @readOnly
      @public
    */
    lastObject: _emberMetalComputed.computed('[]', function () {
      var len = _emberMetalProperty_get.get(this, 'length');

      if (len === 0) {
        return undefined;
      }

      var context = popCtx();
      var idx = 0;
      var last = null;
      var cur = undefined;

      do {
        last = cur;
        cur = this.nextObject(idx++, last, context);
      } while (cur !== undefined);

      pushCtx(context);

      return last;
    }).readOnly(),

    /**
      Returns `true` if the passed object can be found in the receiver. The
      default version will iterate through the enumerable until the object
      is found. You may want to override this with a more efficient version.
       ```javascript
      let arr = ['a', 'b', 'c'];
       arr.contains('a'); // true
      arr.contains('z'); // false
      ```
       @method contains
      @deprecated Use `Enumerable#includes` instead. See http://emberjs.com/deprecations/v2.x#toc_enumerable-contains
      @param {Object} obj The object to search for.
      @return {Boolean} `true` if object is found in enumerable.
      @public
    */
    contains: function (obj) {
      if (true) {}

      var found = this.find(function (item) {
        return item === obj;
      });

      return found !== undefined;
    },

    /**
      Iterates through the enumerable, calling the passed function on each
      item. This method corresponds to the `forEach()` method defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method forEach
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} receiver
      @public
    */
    forEach: function (callback, target) {
      if (typeof callback !== 'function') {
        throw new TypeError();
      }

      var context = popCtx();
      var len = _emberMetalProperty_get.get(this, 'length');
      var last = null;

      if (target === undefined) {
        target = null;
      }

      for (var idx = 0; idx < len; idx++) {
        var next = this.nextObject(idx, last, context);
        callback.call(target, next, idx, this);
        last = next;
      }

      last = null;
      context = pushCtx(context);

      return this;
    },

    /**
      Alias for `mapBy`
       @method getEach
      @param {String} key name of the property
      @return {Array} The mapped array.
      @public
    */
    getEach: _emberMetalMixin.aliasMethod('mapBy'),

    /**
      Sets the value on the named property for each member. This is more
      efficient than using other methods defined on this helper. If the object
      implements Ember.Observable, the value will be changed to `set(),` otherwise
      it will be set directly. `null` objects are skipped.
       @method setEach
      @param {String} key The key to set
      @param {Object} value The object to set
      @return {Object} receiver
      @public
    */
    setEach: function (key, value) {
      return this.forEach(function (item) {
        return _emberMetalProperty_set.set(item, key, value);
      });
    },

    /**
      Maps all of the items in the enumeration to another value, returning
      a new array. This method corresponds to `map()` defined in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the mapped value.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method map
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} The mapped array.
      @public
    */
    map: function (callback, target) {
      var ret = emberA();

      this.forEach(function (x, idx, i) {
        return ret[idx] = callback.call(target, x, idx, i);
      });

      return ret;
    },

    /**
      Similar to map, this specialized function returns the value of the named
      property on all items in the enumeration.
       @method mapBy
      @param {String} key name of the property
      @return {Array} The mapped array.
      @public
    */
    mapBy: function (key) {
      return this.map(function (next) {
        return _emberMetalProperty_get.get(next, key);
      });
    },

    /**
      Returns an array with all of the items in the enumeration that the passed
      function returns true for. This method corresponds to `filter()` defined in
      JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method filter
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A filtered array.
      @public
    */
    filter: function (callback, target) {
      var ret = emberA();

      this.forEach(function (x, idx, i) {
        if (callback.call(target, x, idx, i)) {
          ret.push(x);
        }
      });

      return ret;
    },

    /**
      Returns an array with all of the items in the enumeration where the passed
      function returns false. This method is the inverse of filter().
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - *item* is the current item in the iteration.
      - *index* is the current index in the iteration
      - *enumerable* is the enumerable object itself.
       It should return a falsey value to include the item in the results.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as "this" on the context. This is a good way
      to give your iterator function access to the current object.
       @method reject
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Array} A rejected array.
      @public
    */
    reject: function (callback, target) {
      return this.filter(function () {
        return !callback.apply(target, arguments);
      });
    },

    /**
      Returns an array with just the items with the matched property. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       @method filterBy
      @param {String} key the property to test
      @param {*} [value] optional value to test against.
      @return {Array} filtered array
      @public
    */
    filterBy: function (key, value) {
      return this.filter(iter.apply(this, arguments));
    },

    /**
      Returns an array with the items that do not have truthy values for
      key.  You can pass an optional second argument with the target value.  Otherwise
      this will match any property that evaluates to false.
       @method rejectBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Array} rejected array
      @public
    */
    rejectBy: function (key, value) {
      var exactValue = function (item) {
        return _emberMetalProperty_get.get(item, key) === value;
      };
      var hasValue = function (item) {
        return !!_emberMetalProperty_get.get(item, key);
      };
      var use = arguments.length === 2 ? exactValue : hasValue;

      return this.reject(use);
    },

    /**
      Returns the first item in the array for which the callback returns true.
      This method works similar to the `filter()` method defined in JavaScript 1.6
      except that it will stop working on the array once a match is found.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       @method find
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Object} Found item or `undefined`.
      @public
    */
    find: function (callback, target) {
      var len = _emberMetalProperty_get.get(this, 'length');

      if (target === undefined) {
        target = null;
      }

      var context = popCtx();
      var found = false;
      var last = null;
      var next = undefined,
          ret = undefined;

      for (var idx = 0; idx < len && !found; idx++) {
        next = this.nextObject(idx, last, context);

        if (found = callback.call(target, next, idx, this)) {
          ret = next;
        }

        last = next;
      }

      next = last = null;
      context = pushCtx(context);

      return ret;
    },

    /**
      Returns the first item with a property matching the passed value. You
      can pass an optional second argument with the target value. Otherwise
      this will match any property that evaluates to `true`.
       This method works much like the more generic `find()` method.
       @method findBy
      @param {String} key the property to test
      @param {String} [value] optional value to test against.
      @return {Object} found item or `undefined`
      @public
    */
    findBy: function (key, value) {
      return this.find(iter.apply(this, arguments));
    },

    /**
      Returns `true` if the passed function returns true for every item in the
      enumeration. This corresponds with the `every()` method in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` or `false`.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Example Usage:
       ```javascript
      if (people.every(isEngineer)) {
        Paychecks.addBigBonus();
      }
      ```
       @method every
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean}
      @public
    */
    every: function (callback, target) {
      return !this.find(function (x, idx, i) {
        return !callback.call(target, x, idx, i);
      });
    },

    /**
      Returns `true` if the passed property resolves to the value of the second
      argument for all items in the enumerable. This method is often simpler/faster
      than using a callback.
       @method isEvery
      @param {String} key the property to test
      @param {String} [value] optional value to test against. Defaults to `true`
      @return {Boolean}
      @since 1.3.0
      @public
    */
    isEvery: function (key, value) {
      return this.every(iter.apply(this, arguments));
    },

    /**
      Returns `true` if the passed function returns true for any item in the
      enumeration. This corresponds with the `some()` method in JavaScript 1.6.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(item, index, enumerable);
      ```
       - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       It should return the `true` to include the item in the results, `false`
      otherwise.
       Note that in addition to a callback, you can also pass an optional target
      object that will be set as `this` on the context. This is a good way
      to give your iterator function access to the current object.
       Usage Example:
       ```javascript
      if (people.any(isManager)) {
        Paychecks.addBiggerBonus();
      }
      ```
       @method any
      @param {Function} callback The callback to execute
      @param {Object} [target] The target object to use
      @return {Boolean} `true` if the passed function returns `true` for any item
      @public
    */
    any: function (callback, target) {
      var len = _emberMetalProperty_get.get(this, 'length');
      var context = popCtx();
      var found = false;
      var last = null;
      var next = undefined;

      if (target === undefined) {
        target = null;
      }

      for (var idx = 0; idx < len && !found; idx++) {
        next = this.nextObject(idx, last, context);
        found = callback.call(target, next, idx, this);
        last = next;
      }

      next = last = null;
      context = pushCtx(context);
      return found;
    },

    /**
      Returns `true` if the passed property resolves to the value of the second
      argument for any item in the enumerable. This method is often simpler/faster
      than using a callback.
       @method isAny
      @param {String} key the property to test
      @param {String} [value] optional value to test against. Defaults to `true`
      @return {Boolean}
      @since 1.3.0
      @public
    */
    isAny: function (key, value) {
      return this.any(iter.apply(this, arguments));
    },

    /**
      This will combine the values of the enumerator into a single value. It
      is a useful way to collect a summary value from an enumeration. This
      corresponds to the `reduce()` method defined in JavaScript 1.8.
       The callback method you provide should have the following signature (all
      parameters are optional):
       ```javascript
      function(previousValue, item, index, enumerable);
      ```
       - `previousValue` is the value returned by the last call to the iterator.
      - `item` is the current item in the iteration.
      - `index` is the current index in the iteration.
      - `enumerable` is the enumerable object itself.
       Return the new cumulative value.
       In addition to the callback you can also pass an `initialValue`. An error
      will be raised if you do not pass an initial value and the enumerator is
      empty.
       Note that unlike the other methods, this method does not allow you to
      pass a target object to set as this for the callback. It's part of the
      spec. Sorry.
       @method reduce
      @param {Function} callback The callback to execute
      @param {Object} initialValue Initial value for the reduce
      @param {String} reducerProperty internal use only.
      @return {Object} The reduced value.
      @public
    */
    reduce: function (callback, initialValue, reducerProperty) {
      if (typeof callback !== 'function') {
        throw new TypeError();
      }

      var ret = initialValue;

      this.forEach(function (item, i) {
        ret = callback(ret, item, i, this, reducerProperty);
      }, this);

      return ret;
    },

    /**
      Invokes the named method on every object in the receiver that
      implements it. This method corresponds to the implementation in
      Prototype 1.6.
       @method invoke
      @param {String} methodName the name of the method
      @param {Object...} args optional arguments to pass as well.
      @return {Array} return values from calling invoke.
      @public
    */
    invoke: function (methodName) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      var ret = emberA();

      this.forEach(function (x, idx) {
        var method = x && x[methodName];

        if ('function' === typeof method) {
          ret[idx] = args ? method.apply(x, args) : x[methodName]();
        }
      }, this);

      return ret;
    },

    /**
      Simply converts the enumerable into a genuine array. The order is not
      guaranteed. Corresponds to the method implemented by Prototype.
       @method toArray
      @return {Array} the enumerable as an array.
      @public
    */
    toArray: function () {
      var ret = emberA();

      this.forEach(function (o, idx) {
        return ret[idx] = o;
      });

      return ret;
    },

    /**
      Returns a copy of the array with all `null` and `undefined` elements removed.
       ```javascript
      let arr = ['a', null, 'c', undefined];
      arr.compact();  // ['a', 'c']
      ```
       @method compact
      @return {Array} the array without null and undefined elements.
      @public
    */
    compact: function () {
      return this.filter(function (value) {
        return value != null;
      });
    },

    /**
      Returns a new enumerable that excludes the passed value. The default
      implementation returns an array regardless of the receiver type.
      If the receiver does not contain the value it returns the original enumerable.
       ```javascript
      let arr = ['a', 'b', 'a', 'c'];
      arr.without('a');  // ['b', 'c']
      ```
       @method without
      @param {Object} value
      @return {Ember.Enumerable}
      @public
    */
    without: function (value) {
      if (!this.contains(value)) {
        return this; // nothing to do
      }

      var ret = emberA();

      this.forEach(function (k) {
        if (k !== value) {
          ret[ret.length] = k;
        }
      });

      return ret;
    },

    /**
      Returns a new enumerable that contains only unique values. The default
      implementation returns an array regardless of the receiver type.
       ```javascript
      let arr = ['a', 'a', 'b', 'b'];
      arr.uniq();  // ['a', 'b']
      ```
       This only works on primitive data types, e.g. Strings, Numbers, etc.
       @method uniq
      @return {Ember.Enumerable}
      @public
    */
    uniq: function () {
      var ret = emberA();

      this.forEach(function (k) {
        if (ret.indexOf(k) < 0) {
          ret.push(k);
        }
      });

      return ret;
    },

    /**
      This property will trigger anytime the enumerable's content changes.
      You can observe this property to be notified of changes to the enumerable's
      content.
       For plain enumerables, this property is read only. `Array` overrides
      this method.
       @property []
      @type Array
      @return this
      @private
    */
    '[]': _emberMetalComputed.computed({
      get: function (key) {
        return this;
      }
    }),

    // ..........................................................
    // ENUMERABLE OBSERVERS
    //

    /**
      Registers an enumerable observer. Must implement `Ember.EnumerableObserver`
      mixin.
       @method addEnumerableObserver
      @param {Object} target
      @param {Object} [opts]
      @return this
      @private
    */
    addEnumerableObserver: function (target, opts) {
      var willChange = opts && opts.willChange || 'enumerableWillChange';
      var didChange = opts && opts.didChange || 'enumerableDidChange';
      var hasObservers = _emberMetalProperty_get.get(this, 'hasEnumerableObservers');

      if (!hasObservers) {
        _emberMetalProperty_events.propertyWillChange(this, 'hasEnumerableObservers');
      }

      _emberMetalEvents.addListener(this, '@enumerable:before', target, willChange);
      _emberMetalEvents.addListener(this, '@enumerable:change', target, didChange);

      if (!hasObservers) {
        _emberMetalProperty_events.propertyDidChange(this, 'hasEnumerableObservers');
      }

      return this;
    },

    /**
      Removes a registered enumerable observer.
       @method removeEnumerableObserver
      @param {Object} target
      @param {Object} [opts]
      @return this
      @private
    */
    removeEnumerableObserver: function (target, opts) {
      var willChange = opts && opts.willChange || 'enumerableWillChange';
      var didChange = opts && opts.didChange || 'enumerableDidChange';
      var hasObservers = _emberMetalProperty_get.get(this, 'hasEnumerableObservers');

      if (hasObservers) {
        _emberMetalProperty_events.propertyWillChange(this, 'hasEnumerableObservers');
      }

      _emberMetalEvents.removeListener(this, '@enumerable:before', target, willChange);
      _emberMetalEvents.removeListener(this, '@enumerable:change', target, didChange);

      if (hasObservers) {
        _emberMetalProperty_events.propertyDidChange(this, 'hasEnumerableObservers');
      }

      return this;
    },

    /**
      Becomes true whenever the array currently has observers watching changes
      on the array.
       @property hasEnumerableObservers
      @type Boolean
      @private
    */
    hasEnumerableObservers: _emberMetalComputed.computed(function () {
      return _emberMetalEvents.hasListeners(this, '@enumerable:change') || _emberMetalEvents.hasListeners(this, '@enumerable:before');
    }),

    /**
      Invoke this method just before the contents of your enumerable will
      change. You can either omit the parameters completely or pass the objects
      to be removed or added if available or just a count.
       @method enumerableContentWillChange
      @param {Ember.Enumerable|Number} removing An enumerable of the objects to
        be removed or the number of items to be removed.
      @param {Ember.Enumerable|Number} adding An enumerable of the objects to be
        added or the number of items to be added.
      @chainable
      @private
    */
    enumerableContentWillChange: function (removing, adding) {
      var removeCnt = undefined,
          addCnt = undefined,
          hasDelta = undefined;

      if ('number' === typeof removing) {
        removeCnt = removing;
      } else if (removing) {
        removeCnt = _emberMetalProperty_get.get(removing, 'length');
      } else {
        removeCnt = removing = -1;
      }

      if ('number' === typeof adding) {
        addCnt = adding;
      } else if (adding) {
        addCnt = _emberMetalProperty_get.get(adding, 'length');
      } else {
        addCnt = adding = -1;
      }

      hasDelta = addCnt < 0 || removeCnt < 0 || addCnt - removeCnt !== 0;

      if (removing === -1) {
        removing = null;
      }

      if (adding === -1) {
        adding = null;
      }

      _emberMetalProperty_events.propertyWillChange(this, '[]');

      if (hasDelta) {
        _emberMetalProperty_events.propertyWillChange(this, 'length');
      }

      _emberMetalEvents.sendEvent(this, '@enumerable:before', [this, removing, adding]);

      return this;
    },

    /**
      Invoke this method when the contents of your enumerable has changed.
      This will notify any observers watching for content changes. If you are
      implementing an ordered enumerable (such as an array), also pass the
      start and end values where the content changed so that it can be used to
      notify range observers.
       @method enumerableContentDidChange
      @param {Ember.Enumerable|Number} removing An enumerable of the objects to
        be removed or the number of items to be removed.
      @param {Ember.Enumerable|Number} adding  An enumerable of the objects to
        be added or the number of items to be added.
      @chainable
      @private
    */
    enumerableContentDidChange: function (removing, adding) {
      var removeCnt = undefined,
          addCnt = undefined,
          hasDelta = undefined;

      if ('number' === typeof removing) {
        removeCnt = removing;
      } else if (removing) {
        removeCnt = _emberMetalProperty_get.get(removing, 'length');
      } else {
        removeCnt = removing = -1;
      }

      if ('number' === typeof adding) {
        addCnt = adding;
      } else if (adding) {
        addCnt = _emberMetalProperty_get.get(adding, 'length');
      } else {
        addCnt = adding = -1;
      }

      hasDelta = addCnt < 0 || removeCnt < 0 || addCnt - removeCnt !== 0;

      if (removing === -1) {
        removing = null;
      }

      if (adding === -1) {
        adding = null;
      }

      _emberMetalEvents.sendEvent(this, '@enumerable:change', [this, removing, adding]);

      if (hasDelta) {
        _emberMetalProperty_events.propertyDidChange(this, 'length');
      }

      _emberMetalProperty_events.propertyDidChange(this, '[]');

      return this;
    },

    /**
      Converts the enumerable into an array and sorts by the keys
      specified in the argument.
       You may provide multiple arguments to sort by multiple properties.
       @method sortBy
      @param {String} property name(s) to sort on
      @return {Array} The sorted array.
      @since 1.2.0
      @public
    */
    sortBy: function () {
      var sortKeys = arguments;

      return this.toArray().sort(function (a, b) {
        for (var i = 0; i < sortKeys.length; i++) {
          var key = sortKeys[i];
          var propA = _emberMetalProperty_get.get(a, key);
          var propB = _emberMetalProperty_get.get(b, key);
          // return 1 or -1 else continue to the next sortKey
          var compareValue = _emberRuntimeCompare.default(propA, propB);

          if (compareValue) {
            return compareValue;
          }
        }
        return 0;
      });
    }
  });

  if (true) {
    Enumerable.reopen({
      /**
        Returns a new enumerable that contains only items containing a unique property value.
        The default implementation returns an array regardless of the receiver type.
         ```javascript
        let arr = [{ value: 'a' }, { value: 'a' }, { value: 'b' }, { value: 'b' }];
        arr.uniqBy('value');  // [{ value: 'a' }, { value: 'b' }]
        ```
         @method uniqBy
        @return {Ember.Enumerable}
        @public
      */

      uniqBy: function (key) {
        var ret = emberA();
        var seen = new _emberMetalEmpty_object.default();

        this.forEach(function (item) {
          var guid = _emberMetalUtils.guidFor(_emberMetalProperty_get.get(item, key));
          if (!(guid in seen)) {
            seen[guid] = true;
            ret.push(item);
          }
        });

        return ret;
      }
    });
  }

  if (true) {
    Enumerable.reopen({
      /**
        Returns `true` if the passed object can be found in the enumerable.
        ```javascript
        [1, 2, 3].includes(2);                     // true
        [1, 2, 3].includes(4);                     // false
        [1, 2, undefined].includes(undefined);     // true
        [1, 2, null].includes(null);               // true
        [1, 2, NaN].includes(NaN);                 // true
        ```
        @method includes
        @param {Object} obj The object to search for.
        @return {Boolean} `true` if object is found in the enumerable.
        @public
      */
      includes: function (obj) {

        var len = _emberMetalProperty_get.get(this, 'length');
        var idx = undefined,
            next = undefined;
        var last = null;
        var found = false;

        var context = popCtx();

        for (idx = 0; idx < len && !found; idx++) {
          next = this.nextObject(idx, last, context);

          found = obj === next || obj !== obj && next !== next;

          last = next;
        }

        next = last = null;
        context = pushCtx(context);

        return found;
      },

      without: function (value) {
        if (!this.includes(value)) {
          return this; // nothing to do
        }

        var ret = emberA();

        this.forEach(function (k) {
          // SameValueZero comparison (NaN !== NaN)
          if (!(k === value || k !== k && value !== value)) {
            ret[ret.length] = k;
          }
        });

        return ret;
      }
    });
  }

  exports.default = Enumerable;
})(Em._e[88],Em._e[30],Em._e[32],Em._e[61],Em._e[7],Em._e[59],Em._e[12],Em._e[10],Em._e[20],Em._e[15],Em._e[87],Em.__loader.require,Em._e[0]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalObserver, _emberMetalProperty_events, _emberMetalEmpty_object, _emberRuntimeMixinsArray) {
  'use strict';

  exports.default = EachProxy;

  /**
    This is the object instance returned when you get the `@each` property on an
    array. It uses the unknownProperty handler to automatically create
    EachArray instances for property names.
    @class EachProxy
    @private
  */

  function EachProxy(content) {
    this._content = content;
    this._keys = undefined;
    this.__ember_meta__ = null;
  }

  EachProxy.prototype = {
    __defineNonEnumerable: function (property) {
      this[property.name] = property.descriptor.value;
    },

    // ..........................................................
    // ARRAY CHANGES
    // Invokes whenever the content array itself changes.

    arrayWillChange: function (content, idx, removedCnt, addedCnt) {
      var keys = this._keys;
      var lim = removedCnt > 0 ? idx + removedCnt : -1;
      for (var key in keys) {
        if (lim > 0) {
          removeObserverForContentKey(content, key, this, idx, lim);
        }
        _emberMetalProperty_events.propertyWillChange(this, key);
      }
    },

    arrayDidChange: function (content, idx, removedCnt, addedCnt) {
      var keys = this._keys;
      var lim = addedCnt > 0 ? idx + addedCnt : -1;
      for (var key in keys) {
        if (lim > 0) {
          addObserverForContentKey(content, key, this, idx, lim);
        }
        _emberMetalProperty_events.propertyDidChange(this, key);
      }
    },

    // ..........................................................
    // LISTEN FOR NEW OBSERVERS AND OTHER EVENT LISTENERS
    // Start monitoring keys based on who is listening...

    willWatchProperty: function (property) {
      this.beginObservingContentKey(property);
    },

    didUnwatchProperty: function (property) {
      this.stopObservingContentKey(property);
    },

    // ..........................................................
    // CONTENT KEY OBSERVING
    // Actual watch keys on the source content.

    beginObservingContentKey: function (keyName) {
      var keys = this._keys;
      if (!keys) {
        keys = this._keys = new _emberMetalEmpty_object.default();
      }

      if (!keys[keyName]) {
        keys[keyName] = 1;
        var content = this._content;
        var len = _emberMetalProperty_get.get(content, 'length');

        addObserverForContentKey(content, keyName, this, 0, len);
      } else {
        keys[keyName]++;
      }
    },

    stopObservingContentKey: function (keyName) {
      var keys = this._keys;
      if (keys && keys[keyName] > 0 && --keys[keyName] <= 0) {
        var content = this._content;
        var len = _emberMetalProperty_get.get(content, 'length');

        removeObserverForContentKey(content, keyName, this, 0, len);
      }
    },

    contentKeyWillChange: function (obj, keyName) {
      _emberMetalProperty_events.propertyWillChange(this, keyName);
    },

    contentKeyDidChange: function (obj, keyName) {
      _emberMetalProperty_events.propertyDidChange(this, keyName);
    }
  };

  function addObserverForContentKey(content, keyName, proxy, idx, loc) {
    while (--loc >= idx) {
      var item = _emberRuntimeMixinsArray.objectAt(content, loc);
      if (item) {
        _emberMetalObserver._addBeforeObserver(item, keyName, proxy, 'contentKeyWillChange');
        _emberMetalObserver.addObserver(item, keyName, proxy, 'contentKeyDidChange');
      }
    }
  }

  function removeObserverForContentKey(content, keyName, proxy, idx, loc) {
    while (--loc >= idx) {
      var item = _emberRuntimeMixinsArray.objectAt(content, loc);
      if (item) {
        _emberMetalObserver._removeBeforeObserver(item, keyName, proxy, 'contentKeyWillChange');
        _emberMetalObserver.removeObserver(item, keyName, proxy, 'contentKeyDidChange');
      }
    }
  }
})(Em._e[89],Em._e[0],Em._e[30],Em._e[53],Em._e[20],Em._e[12],Em._e[90]);
(function (exports, _emberMetalCore, _emberMetalSymbol, _emberMetalProperty_get, _emberMetalComputed, _emberMetalIs_none, _emberRuntimeMixinsEnumerable, _emberMetalMixin, _emberMetalProperty_events, _emberMetalEvents, _emberMetalMeta, _emberMetalTags, _emberRuntimeSystemEach_proxy, _emberMetalDebug, _emberMetalFeatures) {
  /**
  @module ember
  @submodule ember-runtime
  */

  // ..........................................................
  // HELPERS
  //
  'use strict';

  var _Mixin$create;

  exports.addArrayObserver = addArrayObserver;
  exports.removeArrayObserver = removeArrayObserver;
  exports.objectAt = objectAt;
  exports.arrayContentWillChange = arrayContentWillChange;
  exports.arrayContentDidChange = arrayContentDidChange;
  exports.isEmberArray = isEmberArray;

  function arrayObserversHelper(obj, target, opts, operation, notify) {
    var willChange = opts && opts.willChange || 'arrayWillChange';
    var didChange = opts && opts.didChange || 'arrayDidChange';
    var hasObservers = _emberMetalProperty_get.get(obj, 'hasArrayObservers');

    if (hasObservers === notify) {
      _emberMetalProperty_events.propertyWillChange(obj, 'hasArrayObservers');
    }

    operation(obj, '@array:before', target, willChange);
    operation(obj, '@array:change', target, didChange);

    if (hasObservers === notify) {
      _emberMetalProperty_events.propertyDidChange(obj, 'hasArrayObservers');
    }

    return obj;
  }

  function addArrayObserver(array, target, opts) {
    return arrayObserversHelper(array, target, opts, _emberMetalEvents.addListener, false);
  }

  function removeArrayObserver(array, target, opts) {
    return arrayObserversHelper(array, target, opts, _emberMetalEvents.removeListener, true);
  }

  function objectAt(content, idx) {
    if (content.objectAt) {
      return content.objectAt(idx);
    }

    return content[idx];
  }

  function arrayContentWillChange(array, startIdx, removeAmt, addAmt) {
    var removing = undefined,
        lim = undefined;

    // if no args are passed assume everything changes
    if (startIdx === undefined) {
      startIdx = 0;
      removeAmt = addAmt = -1;
    } else {
      if (removeAmt === undefined) {
        removeAmt = -1;
      }

      if (addAmt === undefined) {
        addAmt = -1;
      }
    }

    if (array.__each) {
      array.__each.arrayWillChange(array, startIdx, removeAmt, addAmt);
    }

    _emberMetalEvents.sendEvent(array, '@array:before', [array, startIdx, removeAmt, addAmt]);

    if (startIdx >= 0 && removeAmt >= 0 && _emberMetalProperty_get.get(array, 'hasEnumerableObservers')) {
      removing = [];
      lim = startIdx + removeAmt;

      for (var idx = startIdx; idx < lim; idx++) {
        removing.push(objectAt(array, idx));
      }
    } else {
      removing = removeAmt;
    }

    array.enumerableContentWillChange(removing, addAmt);

    return array;
  }

  function arrayContentDidChange(array, startIdx, removeAmt, addAmt) {
    _emberMetalTags.markObjectAsDirty(_emberMetalMeta.meta(array));

    // if no args are passed assume everything changes
    if (startIdx === undefined) {
      startIdx = 0;
      removeAmt = addAmt = -1;
    } else {
      if (removeAmt === undefined) {
        removeAmt = -1;
      }

      if (addAmt === undefined) {
        addAmt = -1;
      }
    }

    var adding = undefined;
    if (startIdx >= 0 && addAmt >= 0 && _emberMetalProperty_get.get(array, 'hasEnumerableObservers')) {
      adding = [];
      var lim = startIdx + addAmt;

      for (var idx = startIdx; idx < lim; idx++) {
        adding.push(objectAt(array, idx));
      }
    } else {
      adding = addAmt;
    }

    array.enumerableContentDidChange(removeAmt, adding);

    if (array.__each) {
      array.__each.arrayDidChange(array, startIdx, removeAmt, addAmt);
    }

    _emberMetalEvents.sendEvent(array, '@array:change', [array, startIdx, removeAmt, addAmt]);

    var length = _emberMetalProperty_get.get(array, 'length');
    var cachedFirst = _emberMetalComputed.cacheFor(array, 'firstObject');
    var cachedLast = _emberMetalComputed.cacheFor(array, 'lastObject');

    if (objectAt(array, 0) !== cachedFirst) {
      _emberMetalProperty_events.propertyWillChange(array, 'firstObject');
      _emberMetalProperty_events.propertyDidChange(array, 'firstObject');
    }

    if (objectAt(array, length - 1) !== cachedLast) {
      _emberMetalProperty_events.propertyWillChange(array, 'lastObject');
      _emberMetalProperty_events.propertyDidChange(array, 'lastObject');
    }

    return array;
  }

  var EMBER_ARRAY = _emberMetalSymbol.default('EMBER_ARRAY');

  function isEmberArray(obj) {
    return obj && !!obj[EMBER_ARRAY];
  }

  // ..........................................................
  // ARRAY
  //
  /**
    This mixin implements Observer-friendly Array-like behavior. It is not a
    concrete implementation, but it can be used up by other classes that want
    to appear like arrays.
  
    For example, ArrayProxy is a concrete classes that can
    be instantiated to implement array-like behavior. Both of these classes use
    the Array Mixin by way of the MutableArray mixin, which allows observable
    changes to be made to the underlying array.
  
    Unlike `Ember.Enumerable,` this mixin defines methods specifically for
    collections that provide index-ordered access to their contents. When you
    are designing code that needs to accept any kind of Array-like object, you
    should use these methods instead of Array primitives because these will
    properly notify observers of changes to the array.
  
    Although these methods are efficient, they do add a layer of indirection to
    your application so it is a good idea to use them only when you need the
    flexibility of using both true JavaScript arrays and "virtual" arrays such
    as controllers and collections.
  
    You can use the methods defined in this module to access and modify array
    contents in a KVO-friendly way. You can also be notified whenever the
    membership of an array changes by using `.observes('myArray.[]')`.
  
    To support `Ember.Array` in your own class, you must override two
    primitives to use it: `length()` and `objectAt()`.
  
    Note that the Ember.Array mixin also incorporates the `Ember.Enumerable`
    mixin. All `Ember.Array`-like objects are also enumerable.
  
    @class Array
    @namespace Ember
    @uses Ember.Enumerable
    @since Ember 0.9.0
    @public
  */
  var ArrayMixin = _emberMetalMixin.Mixin.create(_emberRuntimeMixinsEnumerable.default, (_Mixin$create = {}, _Mixin$create[EMBER_ARRAY] = true, _Mixin$create.length = null, _Mixin$create.objectAt = function (idx) {
    if (idx < 0 || idx >= _emberMetalProperty_get.get(this, 'length')) {
      return undefined;
    }

    return _emberMetalProperty_get.get(this, idx);
  }, _Mixin$create.objectsAt = function (indexes) {
    var _this = this;

    return indexes.map(function (idx) {
      return objectAt(_this, idx);
    });
  }, _Mixin$create.nextObject = function (idx) {
    return objectAt(this, idx);
  }, _Mixin$create['[]'] = _emberMetalComputed.computed({
    get: function (key) {
      return this;
    },
    set: function (key, value) {
      this.replace(0, _emberMetalProperty_get.get(this, 'length'), value);
      return this;
    }
  }), _Mixin$create.firstObject = _emberMetalComputed.computed(function () {
    return objectAt(this, 0);
  }).readOnly(), _Mixin$create.lastObject = _emberMetalComputed.computed(function () {
    return objectAt(this, _emberMetalProperty_get.get(this, 'length') - 1);
  }).readOnly(), _Mixin$create.contains = function (obj) {
    if (true) {}

    return this.indexOf(obj) >= 0;
  }, _Mixin$create.slice = function (beginIndex, endIndex) {
    var ret = _emberMetalCore.default.A();
    var length = _emberMetalProperty_get.get(this, 'length');

    if (_emberMetalIs_none.default(beginIndex)) {
      beginIndex = 0;
    }

    if (_emberMetalIs_none.default(endIndex) || endIndex > length) {
      endIndex = length;
    }

    if (beginIndex < 0) {
      beginIndex = length + beginIndex;
    }

    if (endIndex < 0) {
      endIndex = length + endIndex;
    }

    while (beginIndex < endIndex) {
      ret[ret.length] = objectAt(this, beginIndex++);
    }

    return ret;
  }, _Mixin$create.indexOf = function (object, startAt) {
    var len = _emberMetalProperty_get.get(this, 'length');

    if (startAt === undefined) {
      startAt = 0;
    }

    if (startAt < 0) {
      startAt += len;
    }

    for (var idx = startAt; idx < len; idx++) {
      if (objectAt(this, idx) === object) {
        return idx;
      }
    }

    return -1;
  }, _Mixin$create.lastIndexOf = function (object, startAt) {
    var len = _emberMetalProperty_get.get(this, 'length');

    if (startAt === undefined || startAt >= len) {
      startAt = len - 1;
    }

    if (startAt < 0) {
      startAt += len;
    }

    for (var idx = startAt; idx >= 0; idx--) {
      if (objectAt(this, idx) === object) {
        return idx;
      }
    }

    return -1;
  }, _Mixin$create.addArrayObserver = function (target, opts) {
    return addArrayObserver(this, target, opts);
  }, _Mixin$create.removeArrayObserver = function (target, opts) {
    return removeArrayObserver(this, target, opts);
  }, _Mixin$create.hasArrayObservers = _emberMetalComputed.computed(function () {
    return _emberMetalEvents.hasListeners(this, '@array:change') || _emberMetalEvents.hasListeners(this, '@array:before');
  }), _Mixin$create.arrayContentWillChange = function (startIdx, removeAmt, addAmt) {
    return arrayContentWillChange(this, startIdx, removeAmt, addAmt);
  }, _Mixin$create.arrayContentDidChange = function (startIdx, removeAmt, addAmt) {
    return arrayContentDidChange(this, startIdx, removeAmt, addAmt);
  }, _Mixin$create['@each'] = _emberMetalComputed.computed(function () {
    // TODO use Symbol or add to meta
    if (!this.__each) {
      this.__each = new _emberRuntimeSystemEach_proxy.default(this);
    }

    return this.__each;
  }).volatile(), _Mixin$create));

  if (true) {
    ArrayMixin.reopen({
      /**
        Returns `true` if the passed object can be found in the array.
        This method is a Polyfill for ES 2016 Array.includes.
        If no `startAt` argument is given, the starting location to
        search is 0. If it's negative, searches from the index of
        `this.length + startAt` by asc.
        ```javascript
        [1, 2, 3].includes(2);     // true
        [1, 2, 3].includes(4);     // false
        [1, 2, 3].includes(3, 2);  // true
        [1, 2, 3].includes(3, 3);  // false
        [1, 2, 3].includes(3, -1); // true
        [1, 2, 3].includes(1, -1); // false
        [1, 2, 3].includes(1, -4); // true
        [1, 2, NaN].includes(NaN); // true
        ```
        @method includes
        @param {Object} obj The object to search for.
        @param {Number} startAt optional starting location to search, default 0
        @return {Boolean} `true` if object is found in the array.
        @public
      */
      includes: function (obj, startAt) {
        var len = _emberMetalProperty_get.get(this, 'length');

        if (startAt === undefined) {
          startAt = 0;
        }

        if (startAt < 0) {
          startAt += len;
        }

        for (var idx = startAt; idx < len; idx++) {
          var currentObj = objectAt(this, idx);

          // SameValueZero comparison (NaN !== NaN)
          if (obj === currentObj || obj !== obj && currentObj !== currentObj) {
            return true;
          }
        }

        return false;
      }
    });
  }

  exports.default = ArrayMixin;
})(Em._e[90],Em._e[85],Em._e[13],Em._e[30],Em._e[59],Em._e[75],Em._e[88],Em._e[61],Em._e[20],Em._e[15],Em._e[14],Em._e[17],Em._e[89],Em._e[0],Em._e[10]);
(function (exports, _emberRuntimeMixinsArray, _emberRuntimeSystemObject) {
  'use strict';

  exports.isArray = isArray;
  exports.typeOf = typeOf;

  // ........................................
  // TYPING & ARRAY MESSAGING
  //
  var TYPE_MAP = {
    '[object Boolean]': 'boolean',
    '[object Number]': 'number',
    '[object String]': 'string',
    '[object Function]': 'function',
    '[object Array]': 'array',
    '[object Date]': 'date',
    '[object RegExp]': 'regexp',
    '[object Object]': 'object'
  };

  var toString = Object.prototype.toString;

  /**
    Returns true if the passed object is an array or Array-like.
  
    Objects are considered Array-like if any of the following are true:
  
      - the object is a native Array
      - the object has an objectAt property
      - the object is an Object, and has a length property
  
    Unlike `Ember.typeOf` this method returns true even if the passed object is
    not formally an array but appears to be array-like (i.e. implements `Ember.Array`)
  
    ```javascript
    Ember.isArray();                                          // false
    Ember.isArray([]);                                        // true
    Ember.isArray(Ember.ArrayProxy.create({ content: [] }));  // true
    ```
  
    @method isArray
    @for Ember
    @param {Object} obj The object to test
    @return {Boolean} true if the passed object is an array or Array-like
    @public
  */

  function isArray(obj) {
    if (!obj || obj.setInterval) {
      return false;
    }
    if (Array.isArray(obj)) {
      return true;
    }
    if (_emberRuntimeMixinsArray.default.detect(obj)) {
      return true;
    }

    var type = typeOf(obj);
    if ('array' === type) {
      return true;
    }
    if (obj.length !== undefined && 'object' === type) {
      return true;
    }
    return false;
  }

  /**
    Returns a consistent type for the passed object.
  
    Use this instead of the built-in `typeof` to get the type of an item.
    It will return the same result across all browsers and includes a bit
    more detail. Here is what will be returned:
  
        | Return Value  | Meaning                                              |
        |---------------|------------------------------------------------------|
        | 'string'      | String primitive or String object.                   |
        | 'number'      | Number primitive or Number object.                   |
        | 'boolean'     | Boolean primitive or Boolean object.                 |
        | 'null'        | Null value                                           |
        | 'undefined'   | Undefined value                                      |
        | 'function'    | A function                                           |
        | 'array'       | An instance of Array                                 |
        | 'regexp'      | An instance of RegExp                                |
        | 'date'        | An instance of Date                                  |
        | 'class'       | An Ember class (created using Ember.Object.extend()) |
        | 'instance'    | An Ember object instance                             |
        | 'error'       | An instance of the Error object                      |
        | 'object'      | A JavaScript object not inheriting from Ember.Object |
  
    Examples:
  
    ```javascript
    Ember.typeOf();                       // 'undefined'
    Ember.typeOf(null);                   // 'null'
    Ember.typeOf(undefined);              // 'undefined'
    Ember.typeOf('michael');              // 'string'
    Ember.typeOf(new String('michael'));  // 'string'
    Ember.typeOf(101);                    // 'number'
    Ember.typeOf(new Number(101));        // 'number'
    Ember.typeOf(true);                   // 'boolean'
    Ember.typeOf(new Boolean(true));      // 'boolean'
    Ember.typeOf(Ember.makeArray);        // 'function'
    Ember.typeOf([1, 2, 90]);             // 'array'
    Ember.typeOf(/abc/);                  // 'regexp'
    Ember.typeOf(new Date());             // 'date'
    Ember.typeOf(Ember.Object.extend());  // 'class'
    Ember.typeOf(Ember.Object.create());  // 'instance'
    Ember.typeOf(new Error('teamocil'));  // 'error'
  
    // 'normal' JavaScript object
    Ember.typeOf({ a: 'b' });             // 'object'
    ```
  
    @method typeOf
    @for Ember
    @param {Object} item the item to check
    @return {String} the type
    @public
  */

  function typeOf(item) {
    if (item === null) {
      return 'null';
    }
    if (item === undefined) {
      return 'undefined';
    }
    var ret = TYPE_MAP[toString.call(item)] || 'object';

    if (ret === 'function') {
      if (_emberRuntimeSystemObject.default.detect(item)) {
        ret = 'class';
      }
    } else if (ret === 'object') {
      if (item instanceof Error) {
        ret = 'error';
      } else if (item instanceof _emberRuntimeSystemObject.default) {
        ret = 'instance';
      } else if (item instanceof Date) {
        ret = 'date';
      }
    }

    return ret;
  }
})(Em._e[91],Em._e[90],Em._e[77]);
(function (exports, _emberMetalProperty_get, _emberMetalIs_none) {
  'use strict';

  exports.default = isEmpty;

  /**
    Verifies that a value is `null` or an empty string, empty array,
    or empty function.
  
    Constrains the rules on `Ember.isNone` by returning true for empty
    string and empty arrays.
  
    ```javascript
    Ember.isEmpty();                // true
    Ember.isEmpty(null);            // true
    Ember.isEmpty(undefined);       // true
    Ember.isEmpty('');              // true
    Ember.isEmpty([]);              // true
    Ember.isEmpty({});              // false
    Ember.isEmpty('Adam Hawkins');  // false
    Ember.isEmpty([0,1,2]);         // false
    Ember.isEmpty('\n\t');          // false
    Ember.isEmpty('  ');            // false
    ```
  
    @method isEmpty
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */

  function isEmpty(obj) {
    var none = _emberMetalIs_none.default(obj);
    if (none) {
      return none;
    }

    if (typeof obj.size === 'number') {
      return !obj.size;
    }

    var objectType = typeof obj;

    if (objectType === 'object') {
      var size = _emberMetalProperty_get.get(obj, 'size');
      if (typeof size === 'number') {
        return !size;
      }
    }

    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }

    if (objectType === 'object') {
      var _length = _emberMetalProperty_get.get(obj, 'length');
      if (typeof _length === 'number') {
        return !_length;
      }
    }

    return false;
  }
})(Em._e[92],Em._e[30],Em._e[75]);
(function (exports, _emberMetalDebug, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = extractPositionalParams;
  exports.isRestPositionalParams = isRestPositionalParams;
  exports.processPositionalParams = processPositionalParams;

  function extractPositionalParams(renderNode, component, params, attrs) {
    var raiseAssertions = arguments.length <= 4 || arguments[4] === undefined ? true : arguments[4];

    var positionalParams = component.positionalParams;

    if (positionalParams) {
      processPositionalParams(renderNode, positionalParams, params, attrs, raiseAssertions);
    }
  }

  function isRestPositionalParams(positionalParams) {
    return typeof positionalParams === 'string';
  }

  function processPositionalParams(renderNode, positionalParams, params, attrs) {
    var raiseAssertions = arguments.length <= 4 || arguments[4] === undefined ? true : arguments[4];

    var isRest = isRestPositionalParams(positionalParams);

    if (isRest) {
      processRestPositionalParameters(renderNode, positionalParams, params, attrs, raiseAssertions);
    } else {
      processNamedPositionalParameters(renderNode, positionalParams, params, attrs, raiseAssertions);
    }
  }

  function processNamedPositionalParameters(renderNode, positionalParams, params, attrs, raiseAssertions) {
    var limit = Math.min(params.length, positionalParams.length);

    for (var i = 0; i < limit; i++) {
      var param = params[i];

      attrs[positionalParams[i]] = param;
    }
  }

  function processRestPositionalParameters(renderNode, positionalParamsName, params, attrs, raiseAssertions) {
    var nameInAttrs = (positionalParamsName in attrs);

    // when no params are used, do not override the specified `attrs.stringParamName` value
    if (params.length === 0 && nameInAttrs) {
      return;
    }

    // If there is already an attribute for that variable, do nothing

    var paramsStream = new _emberHtmlbarsStreamsStream.Stream(function () {
      return _emberHtmlbarsStreamsUtils.readArray(params.slice(0));
    }, 'params');

    attrs[positionalParamsName] = paramsStream;

    for (var i = 0; i < params.length; i++) {
      var param = params[i];
      paramsStream.addDependency(param);
    }
  }
})(Em._e[93],Em._e[0],Em._e[56],Em._e[66]);
(function (exports) {
  'use strict';

  exports.default = lookupComponent;
  function lookupComponentPair(componentLookup, owner, name, options) {
    var component = componentLookup.componentFor(name, owner, options);
    var layout = componentLookup.layoutFor(name, owner, options);
    return {
      component: component,
      layout: layout
    };
  }

  function lookupComponent(owner, name, options) {
    var componentLookup = owner.lookup('component-lookup:main');

    var source = options && options.source;

    if (source) {
      var localResult = lookupComponentPair(componentLookup, owner, name, options);

      if (localResult.component || localResult.layout) {
        return localResult;
      }
    }

    return lookupComponentPair(componentLookup, owner, name);
  }
})(Em._e[94]);
(function (exports, _emberMetalDebug, _emberMetalIs_empty, _emberMetalIs_none, _emberMetalSymbol, _emberHtmlbarsStreamsStream, _emberMetalEmpty_object, _emberHtmlbarsStreamsUtils, _emberHtmlbarsHooksSubexpr, _emberMetalAssign, _emberHtmlbarsUtilsExtractPositionalParams, _emberViewsUtilsLookupComponent) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = closureComponent;
  exports.isComponentCell = isComponentCell;
  exports.processPositionalParamsFromCell = processPositionalParamsFromCell;
  exports.mergeInNewHash = mergeInNewHash;
  var COMPONENT_REFERENCE = _emberMetalSymbol.default('COMPONENT_REFERENCE');
  exports.COMPONENT_REFERENCE = COMPONENT_REFERENCE;
  var COMPONENT_CELL = _emberMetalSymbol.default('COMPONENT_CELL');
  exports.COMPONENT_CELL = COMPONENT_CELL;
  var COMPONENT_PATH = _emberMetalSymbol.default('COMPONENT_PATH');
  exports.COMPONENT_PATH = COMPONENT_PATH;
  var COMPONENT_POSITIONAL_PARAMS = _emberMetalSymbol.default('COMPONENT_POSITIONAL_PARAMS');
  exports.COMPONENT_POSITIONAL_PARAMS = COMPONENT_POSITIONAL_PARAMS;
  var COMPONENT_HASH = _emberMetalSymbol.default('COMPONENT_HASH');

  exports.COMPONENT_HASH = COMPONENT_HASH;
  var ClosureComponentStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (env, path, params, hash) {
      this._env = env;
      this._path = path;
      this._params = params;
      this._hash = hash;
      this.label = _emberHtmlbarsHooksSubexpr.labelForSubexpr([path].concat(params), hash, 'component');
      this[COMPONENT_REFERENCE] = true;
    },
    compute: function () {
      return createClosureComponentCell(this._env, this._path, this._params, this._hash, this.label);
    }
  });

  function closureComponent(env, _ref3, hash) {
    var path = _ref3[0];

    var params = _ref3.slice(1);

    var s = new ClosureComponentStream(env, path, params, hash);

    s.addDependency(path);

    // FIXME: If the stream invalidates on every params or hash change, then
    // the {{component helper will be forced to re-render the whole component
    // each time. Instead, these dependencies should not be required and the
    // element component keyword should add the params and hash as dependencies.
    params.forEach(function (item) {
      return s.addDependency(item);
    });
    Object.keys(hash).forEach(function (key) {
      return s.addDependency(hash[key]);
    });

    return s;
  }

  function createClosureComponentCell(env, originalComponentPath, params, hash, label) {
    var componentPath = _emberHtmlbarsStreamsUtils.read(originalComponentPath);

    var newHash = _emberMetalAssign.default(new _emberMetalEmpty_object.default(), hash);

    if (isComponentCell(componentPath)) {
      return createNestedClosureComponentCell(componentPath, params, newHash);
    } else {
      return createNewClosureComponentCell(env, componentPath, params, newHash);
    }
  }

  function isValidComponentPath(env, path) {
    var result = _emberViewsUtilsLookupComponent.default(env.owner, path);

    return !!(result.component || result.layout);
  }

  function isComponentCell(component) {
    return component && component[COMPONENT_CELL];
  }

  function createNestedClosureComponentCell(componentCell, params, hash) {
    var _ref;

    // This needs to be done in each nesting level to avoid raising assertions.
    processPositionalParamsFromCell(componentCell, params, hash);

    return _ref = {}, _ref[COMPONENT_PATH] = componentCell[COMPONENT_PATH], _ref[COMPONENT_HASH] = mergeInNewHash(componentCell[COMPONENT_HASH], hash, componentCell[COMPONENT_POSITIONAL_PARAMS], params), _ref[COMPONENT_POSITIONAL_PARAMS] = componentCell[COMPONENT_POSITIONAL_PARAMS], _ref[COMPONENT_CELL] = true, _ref;
  }

  function processPositionalParamsFromCell(componentCell, params, hash) {
    var positionalParams = componentCell[COMPONENT_POSITIONAL_PARAMS];

    _emberHtmlbarsUtilsExtractPositionalParams.processPositionalParams(null, positionalParams, params, hash);
  }

  function createNewClosureComponentCell(env, componentPath, params, hash) {
    var _ref2;

    var positionalParams = getPositionalParams(env.owner, componentPath);

    // This needs to be done in each nesting level to avoid raising assertions.
    _emberHtmlbarsUtilsExtractPositionalParams.processPositionalParams(null, positionalParams, params, hash);

    return _ref2 = {}, _ref2[COMPONENT_PATH] = componentPath, _ref2[COMPONENT_HASH] = hash, _ref2[COMPONENT_POSITIONAL_PARAMS] = positionalParams, _ref2[COMPONENT_CELL] = true, _ref2;
  }

  /*
   Returns the positional parameters for component `componentPath`.
   If it has no positional parameters, it returns the empty array.
   */
  function getPositionalParams(container, componentPath) {
    if (!componentPath) {
      return [];
    }
    var result = _emberViewsUtilsLookupComponent.default(container, componentPath);
    var component = result.component;

    if (component && component.positionalParams) {
      return component.positionalParams;
    } else {
      return [];
    }
  }

  /*
   * This function merges two hashes in a new one.
   * Furthermore this function deals with the issue expressed in #13742.
   *
   * ```hbs
   * {{component (component 'link-to' 'index')}}
   * ```
   *
   * results in the following error
   *
   * > You must provide one or more parameters to the link-to component.
   *
   * This is so because a naive merging would not take into account that the
   * invocation (the external `{{component}}`) would result in the following
   * attributes (before merging with the ones in the contextual component):
   *
   * ```js
   * let attrs = { params: [] };
   * ```
   *
   * Given that the contextual component has the following attributes:
   *
   * ```js
   * let attrs = { params: ['index'] };
   * ```
   *
   * Merging them would result in:
   *
   * ```js
   * let attrs = { params: [] };
   * ```
   *
   * Therefore, if there are no positional parameters and `positionalParams` is
   * a string (rest positional parameters), we keep the parameters from the
   * `original` hash.
   *
   */

  function mergeInNewHash(original, updates) {
    var positionalParams = arguments.length <= 2 || arguments[2] === undefined ? [] : arguments[2];
    var params = arguments.length <= 3 || arguments[3] === undefined ? [] : arguments[3];

    var newHash = _emberMetalAssign.default({}, original, updates);

    if (_emberHtmlbarsUtilsExtractPositionalParams.isRestPositionalParams(positionalParams) && _emberMetalIs_empty.default(params)) {
      var propName = positionalParams;
      newHash[propName] = original[propName];
    }

    return newHash;
  }
})(Em._e[95],Em._e[0],Em._e[92],Em._e[75],Em._e[13],Em._e[56],Em._e[12],Em._e[66],Em._e[97],Em._e[8],Em._e[93],Em._e[94]);
(function (exports, _emberHtmlbarsUtilsSubscribe, _emberRuntimeUtils, _emberHtmlbarsStreamsUtils, _emberHtmlbarsSystemLookupHelper, _emberHtmlbarsKeywordsClosureComponent) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = linkRenderNode;
  exports.linkParamsFor = linkParamsFor;

  function linkRenderNode(renderNode, env, scope, path, params, hash) {
    if (renderNode.streamUnsubscribers) {
      return true;
    }

    var keyword = env.hooks.keywords[path];
    if (keyword && keyword.link) {
      keyword.link(renderNode.getState(), params, hash);
    } else if (path === 'unbound') {
      return true;
    } else {
      linkParamsFor(path, params);
    }

    // If there is a dot in the path, we need to subscribe to the arguments in the
    // closure component as well.

    if (_emberHtmlbarsSystemLookupHelper.CONTAINS_DOT_CACHE.get(path)) {
      var stream = env.hooks.get(env, scope, path);
      var componentCell = stream.value();

      if (_emberHtmlbarsKeywordsClosureComponent.isComponentCell(componentCell)) {
        var closureAttrs = _emberHtmlbarsKeywordsClosureComponent.mergeInNewHash(componentCell[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_HASH], hash);

        for (var key in closureAttrs) {
          _emberHtmlbarsUtilsSubscribe.default(renderNode, env, scope, closureAttrs[key]);
        }
      }
    }

    if (params && params.length) {
      for (var i = 0; i < params.length; i++) {
        _emberHtmlbarsUtilsSubscribe.default(renderNode, env, scope, params[i]);
      }
    }

    if (hash) {
      for (var key in hash) {
        _emberHtmlbarsUtilsSubscribe.default(renderNode, env, scope, hash[key]);
      }
    }

    // The params and hash can be reused. They don't need to be
    // recomputed on subsequent re-renders because they are
    // streams.
    return true;
  }

  function linkParamsFor(path, params) {
    switch (path) {
      case 'unless':
      case 'if':
        params[0] = shouldDisplay(params[0], toBool);break;
      case 'each':
        params[0] = eachParam(params[0]);break;
      case 'with':
        params[0] = shouldDisplay(params[0], identity);break;
    }
  }

  function eachParam(list) {
    var listChange = getKey(list, '[]');

    var stream = _emberHtmlbarsStreamsUtils.chain(list, function () {
      _emberHtmlbarsStreamsUtils.read(listChange);
      return _emberHtmlbarsStreamsUtils.read(list);
    }, 'each');

    stream.addDependency(listChange);
    return stream;
  }

  function shouldDisplay(predicate, coercer) {
    var length = getKey(predicate, 'length');
    var isTruthy = getKey(predicate, 'isTruthy');

    var stream = _emberHtmlbarsStreamsUtils.chain(predicate, function () {
      var predicateVal = _emberHtmlbarsStreamsUtils.read(predicate);
      var lengthVal = _emberHtmlbarsStreamsUtils.read(length);
      var isTruthyVal = _emberHtmlbarsStreamsUtils.read(isTruthy);

      if (_emberRuntimeUtils.isArray(predicateVal)) {
        return lengthVal > 0 ? coercer(predicateVal) : false;
      }

      if (typeof isTruthyVal === 'boolean') {
        return isTruthyVal ? coercer(predicateVal) : false;
      }

      return coercer(predicateVal);
    }, 'ShouldDisplay');

    _emberHtmlbarsStreamsUtils.addDependency(stream, length);
    _emberHtmlbarsStreamsUtils.addDependency(stream, isTruthy);

    return stream;
  }

  function toBool(value) {
    return !!value;
  }

  function identity(value) {
    return value;
  }

  function getKey(obj, key) {
    if (_emberHtmlbarsStreamsUtils.isStream(obj)) {
      return obj.getKey(key);
    } else {
      return obj && obj[key];
    }
  }
})(Em._e[96],Em._e[84],Em._e[91],Em._e[66],Em._e[79],Em._e[95]);
(function (exports, _emberHtmlbarsSystemLookupHelper, _emberHtmlbarsSystemInvokeHelper, _emberHtmlbarsStreamsUtils, _emberHtmlbarsHooksLinkRenderNode) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = subexpr;
  exports.labelForSubexpr = labelForSubexpr;

  function subexpr(env, scope, helperName, params, hash) {
    // TODO: Keywords and helper invocation should be integrated into
    // the subexpr hook upstream in HTMLBars.
    var keyword = env.hooks.keywords[helperName];
    if (keyword) {
      return keyword(null, env, scope, params, hash, null, null);
    }

    _emberHtmlbarsHooksLinkRenderNode.linkParamsFor(helperName, params);

    var label = labelForSubexpr(params, hash, helperName);
    var helper = _emberHtmlbarsSystemLookupHelper.default(helperName, scope.getSelf(), env);

    var helperStream = _emberHtmlbarsSystemInvokeHelper.buildHelperStream(helper, params, hash, null, env, scope, label);

    for (var i = 0; i < params.length; i++) {
      helperStream.addDependency(params[i]);
    }

    for (var key in hash) {
      helperStream.addDependency(hash[key]);
    }

    return helperStream;
  }

  function labelForSubexpr(params, hash, helperName) {
    var paramsLabels = labelsForParams(params);
    var hashLabels = labelsForHash(hash);
    var label = '(' + helperName;

    if (paramsLabels) {
      label += ' ' + paramsLabels;
    }
    if (hashLabels) {
      label += ' ' + hashLabels;
    }

    return label + ')';
  }

  function labelsForParams(params) {
    return _emberHtmlbarsStreamsUtils.labelsFor(params).join(' ');
  }

  function labelsForHash(hash) {
    var out = [];

    for (var prop in hash) {
      out.push(prop + '=' + _emberHtmlbarsStreamsUtils.labelFor(hash[prop]));
    }

    return out.join(' ');
  }
})(Em._e[97],Em._e[79],Em._e[83],Em._e[66],Em._e[96]);
(function (exports, _emberEnvironment, _emberMetalFeatures) {
  'use strict';

  exports.instrument = instrument;
  exports._instrumentStart = _instrumentStart;
  exports.subscribe = subscribe;
  exports.unsubscribe = unsubscribe;
  exports.reset = reset;

  /**
    The purpose of the Ember Instrumentation module is
    to provide efficient, general-purpose instrumentation
    for Ember.
  
    Subscribe to a listener by using `Ember.subscribe`:
  
    ```javascript
    Ember.subscribe("render", {
      before(name, timestamp, payload) {
  
      },
  
      after(name, timestamp, payload) {
  
      }
    });
    ```
  
    If you return a value from the `before` callback, that same
    value will be passed as a fourth parameter to the `after`
    callback.
  
    Instrument a block of code by using `Ember.instrument`:
  
    ```javascript
    Ember.instrument("render.handlebars", payload, function() {
      // rendering logic
    }, binding);
    ```
  
    Event names passed to `Ember.instrument` are namespaced
    by periods, from more general to more specific. Subscribers
    can listen for events by whatever level of granularity they
    are interested in.
  
    In the above example, the event is `render.handlebars`,
    and the subscriber listened for all events beginning with
    `render`. It would receive callbacks for events named
    `render`, `render.handlebars`, `render.container`, or
    even `render.handlebars.layout`.
  
    @class Instrumentation
    @namespace Ember
    @static
    @private
  */
  var subscribers = [];
  exports.subscribers = subscribers;
  var cache = {};

  function populateListeners(name) {
    var listeners = [];
    var subscriber = undefined;

    for (var i = 0; i < subscribers.length; i++) {
      subscriber = subscribers[i];
      if (subscriber.regex.test(name)) {
        listeners.push(subscriber.object);
      }
    }

    cache[name] = listeners;
    return listeners;
  }

  var time = (function () {
    var perf = 'undefined' !== typeof window ? window.performance || {} : {};
    var fn = perf.now || perf.mozNow || perf.webkitNow || perf.msNow || perf.oNow;
    // fn.bind will be available in all the browsers that support the advanced window.performance... ;-)
    return fn ? fn.bind(perf) : function () {
      return +new Date();
    };
  })();

  /**
    Notifies event's subscribers, calls `before` and `after` hooks.
  
    @method instrument
    @namespace Ember.Instrumentation
  
    @param {String} [name] Namespaced event name.
    @param {Object} _payload
    @param {Function} callback Function that you're instrumenting.
    @param {Object} binding Context that instrument function is called with.
    @private
  */

  function instrument(name, _payload, callback, binding) {
    if (arguments.length <= 3 && typeof _payload === 'function') {
      binding = callback;
      callback = _payload;
      _payload = undefined;
    }
    if (subscribers.length === 0) {
      return callback.call(binding);
    }
    var payload = _payload || {};
    var finalizer = _instrumentStart(name, function () {
      return payload;
    });

    if (finalizer) {
      return withFinalizer(callback, finalizer, payload, binding);
    } else {
      return callback.call(binding);
    }
  }

  var flaggedInstrument = undefined;
  if (false) {
    exports.flaggedInstrument = flaggedInstrument = instrument;
  } else {
    exports.flaggedInstrument = flaggedInstrument = function (name, payload, callback) {
      return callback();
    };
  }
  exports.flaggedInstrument = flaggedInstrument;

  function withFinalizer(callback, finalizer, payload, binding) {
    var result = undefined;
    try {
      result = callback.call(binding);
    } catch (e) {
      payload.exception = e;
      result = payload;
    } finally {
      finalizer();
      return result;
    }
  }

  // private for now

  function _instrumentStart(name, _payload) {
    var listeners = cache[name];

    if (!listeners) {
      listeners = populateListeners(name);
    }

    if (listeners.length === 0) {
      return;
    }

    var payload = _payload();

    var STRUCTURED_PROFILE = _emberEnvironment.ENV.STRUCTURED_PROFILE;
    var timeName = undefined;
    if (STRUCTURED_PROFILE) {
      timeName = name + ': ' + payload.object;
      console.time(timeName);
    }

    var beforeValues = new Array(listeners.length);
    var i = undefined,
        listener = undefined;
    var timestamp = time();
    for (i = 0; i < listeners.length; i++) {
      listener = listeners[i];
      beforeValues[i] = listener.before(name, timestamp, payload);
    }

    return function _instrumentEnd() {
      var i = undefined,
          listener = undefined;
      var timestamp = time();
      for (i = 0; i < listeners.length; i++) {
        listener = listeners[i];
        if (typeof listener.after === 'function') {
          listener.after(name, timestamp, payload, beforeValues[i]);
        }
      }

      if (STRUCTURED_PROFILE) {
        console.timeEnd(timeName);
      }
    };
  }

  /**
    Subscribes to a particular event or instrumented block of code.
  
    @method subscribe
    @namespace Ember.Instrumentation
  
    @param {String} [pattern] Namespaced event name.
    @param {Object} [object] Before and After hooks.
  
    @return {Subscriber}
    @private
  */

  function subscribe(pattern, object) {
    var paths = pattern.split('.');
    var path = undefined;
    var regex = [];

    for (var i = 0; i < paths.length; i++) {
      path = paths[i];
      if (path === '*') {
        regex.push('[^\\.]*');
      } else {
        regex.push(path);
      }
    }

    regex = regex.join('\\.');
    regex = regex + '(\\..*)?';

    var subscriber = {
      pattern: pattern,
      regex: new RegExp('^' + regex + '$'),
      object: object
    };

    subscribers.push(subscriber);
    cache = {};

    return subscriber;
  }

  /**
    Unsubscribes from a particular event or instrumented block of code.
  
    @method unsubscribe
    @namespace Ember.Instrumentation
  
    @param {Object} [subscriber]
    @private
  */

  function unsubscribe(subscriber) {
    var index = undefined;

    for (var i = 0; i < subscribers.length; i++) {
      if (subscribers[i] === subscriber) {
        index = i;
      }
    }

    subscribers.splice(index, 1);
    cache = {};
  }

  /**
    Resets `Ember.Instrumentation` by flushing list of subscribers.
  
    @method reset
    @namespace Ember.Instrumentation
    @private
  */

  function reset() {
    subscribers.length = 0;
    cache = {};
  }
})(Em._e[98],Em._e[4],Em._e[10]);
(function (exports, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils, _emberMetalSymbol, _emberMetalProperty_get, _emberHtmlbarsHooksSubexpr, _emberMetalError, _emberMetalRun_loop, _emberMetalInstrumentation, _emberMetalIs_none) {
  'use strict';

  exports.default = closureAction;
  var INVOKE = _emberMetalSymbol.default('INVOKE');
  exports.INVOKE = INVOKE;
  var ACTION = _emberMetalSymbol.default('ACTION');

  exports.ACTION = ACTION;

  function closureAction(morph, env, scope, params, hash, template, inverse, visitor) {
    var _this = this;

    var s = new _emberHtmlbarsStreamsStream.Stream(function () {
      var rawAction = params[0];
      var actionArguments = _emberHtmlbarsStreamsUtils.readArray(params.slice(1, params.length));

      var target = undefined,
          action = undefined,
          valuePath = undefined;

      if (_emberMetalIs_none.default(rawAction)) {
        var label = _emberHtmlbarsHooksSubexpr.labelForSubexpr(params, hash, 'action');
        throw new _emberMetalError.default('Action passed is null or undefined in ' + label + ' from ' + _emberHtmlbarsStreamsUtils.read(scope.getSelf()) + '.');
      } else if (rawAction[INVOKE]) {
        // on-change={{action (mut name)}}
        target = rawAction;
        action = rawAction[INVOKE];
      } else {
        // on-change={{action setName}}
        // element-space actions look to "controller" then target. Here we only
        // look to "target".
        target = _emberHtmlbarsStreamsUtils.read(scope.getSelf());
        action = _emberHtmlbarsStreamsUtils.read(rawAction);
        var actionType = typeof action;

        if (actionType === 'string') {
          var actionName = action;
          action = null;
          // on-change={{action 'setName'}}
          if (hash.target) {
            // on-change={{action 'setName' target=alternativeComponent}}
            target = _emberHtmlbarsStreamsUtils.read(hash.target);
          }
          if (target.actions) {
            action = target.actions[actionName];
          }

          if (!action) {
            throw new _emberMetalError.default('An action named \'' + actionName + '\' was not found in ' + target + '.');
          }
        } else if (action && typeof action[INVOKE] === 'function') {
          target = action;
          action = action[INVOKE];
        } else if (actionType !== 'function') {
          throw new _emberMetalError.default('An action could not be made for `' + rawAction.label + '` in ' + target + '. Please confirm that you are using either a quoted action name (i.e. `(action \'' + rawAction.label + '\')`) or a function available in ' + target + '.');
        }
      }

      if (hash.value) {
        // <button on-keypress={{action (mut name) value="which"}}
        // on-keypress is not even an Ember feature yet
        valuePath = _emberHtmlbarsStreamsUtils.read(hash.value);
      }

      return createClosureAction(_this, target, action, valuePath, actionArguments);
    }, function () {
      return _emberHtmlbarsHooksSubexpr.labelForSubexpr(params, hash, 'action');
    });

    params.forEach(s.addDependency, s);
    Object.keys(hash).forEach(function (item) {
      return s.addDependency(item);
    });

    return s;
  }

  function createClosureAction(stream, target, action, valuePath, actionArguments) {
    var closureAction = undefined;

    if (actionArguments.length > 0) {
      closureAction = function () {
        var args = actionArguments;

        for (var _len = arguments.length, passedArguments = Array(_len), _key = 0; _key < _len; _key++) {
          passedArguments[_key] = arguments[_key];
        }

        if (passedArguments.length > 0) {
          args = actionArguments.concat(passedArguments);
        }
        if (valuePath && args.length > 0) {
          args[0] = _emberMetalProperty_get.get(args[0], valuePath);
        }

        var payload = { target: target, args: args, label: _emberHtmlbarsStreamsUtils.labelFor(stream) };
        return _emberMetalInstrumentation.flaggedInstrument('interaction.ember-action', payload, function () {
          return _emberMetalRun_loop.default.join.apply(_emberMetalRun_loop.default, [target, action].concat(args));
        });
      };
    } else {
      closureAction = function () {
        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
          args[_key2] = arguments[_key2];
        }

        if (valuePath && args.length > 0) {
          args[0] = _emberMetalProperty_get.get(args[0], valuePath);
        }

        var payload = { target: target, args: args, label: _emberHtmlbarsStreamsUtils.labelFor(stream) };
        return _emberMetalInstrumentation.flaggedInstrument('interaction.ember-action', payload, function () {
          return _emberMetalRun_loop.default.join.apply(_emberMetalRun_loop.default, [target, action].concat(args));
        });
      };
    }

    closureAction[ACTION] = true;

    return closureAction;
  }
})(Em._e[99],Em._e[56],Em._e[66],Em._e[13],Em._e[30],Em._e[97],Em._e[31],Em._e[27],Em._e[98],Em._e[75]);
(function (exports, _emberMetalDebug, _emberMetalSymbol, _emberHtmlbarsStreamsProxyStream, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils, _emberViewsCompatAttrsProxy, _emberHtmlbarsKeywordsClosureAction) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  var _ProxyStream$extend;

  exports.default = mut;
  exports.privateMut = privateMut;
  var MUTABLE_REFERENCE = _emberMetalSymbol.default('MUTABLE_REFERENCE');

  exports.MUTABLE_REFERENCE = MUTABLE_REFERENCE;
  var MutStream = _emberHtmlbarsStreamsProxyStream.default.extend((_ProxyStream$extend = {
    init: function (stream) {
      this.label = '(mut ' + stream.label + ')';
      this.path = stream.path;
      this.sourceDep = this.addMutableDependency(stream);
      this[MUTABLE_REFERENCE] = true;
    },

    cell: function () {
      var source = this;
      var value = source.value();

      if (value && value[_emberHtmlbarsKeywordsClosureAction.ACTION]) {
        return value;
      }

      var val = {
        value: value,
        update: function (val) {
          source.setValue(val);
        }
      };

      val[_emberViewsCompatAttrsProxy.MUTABLE_CELL] = true;
      return val;
    }
  }, _ProxyStream$extend[_emberHtmlbarsKeywordsClosureAction.INVOKE] = function (val) {
    this.setValue(val);
  }, _ProxyStream$extend));

  /**
    The `mut` helper lets you __clearly specify__ that a child `Component` can update the
    (mutable) value passed to it, which will __change the value of the parent component__.
  
    This is very helpful for passing mutable values to a `Component` of any size, but
    critical to understanding the logic of a large/complex `Component`.
  
    To specify that a parameter is mutable, when invoking the child `Component`:
  
    ```handlebars
    {{my-child childClickCount=(mut totalClicks)}}
    ```
  
    The child `Component` can then modify the parent's value as needed:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.get('childClickCount').update(this.get('childClickCount').value + 1);
      }
    });
    ```
  
    Additionally, the `mut` helper can be combined with the `action` helper to
    mutate a value. For example:
  
    ```handlebars
    {{my-child childClickCount=totalClicks click-count-change=(action (mut totalClicks))}}
    ```
  
    The child `Component` would invoke the action with the new click value:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.get('clickCountChange')(this.get('childClickCount') + 1);
      }
    });
    ```
  
    The `mut` helper changes the `totalClicks` value to what was provided as the action argument.
  
    See a [2.0 blog post](http://emberjs.com/blog/2015/05/10/run-up-to-two-oh.html#toc_the-code-mut-code-helper) for
    additional information on using `{{mut}}`.
  
    @method mut
    @param {Object} [attr] the "two-way" attribute that can be modified.
    @for Ember.Templates.helpers
    @public
  */

  function mut(morph, env, scope, originalParams, hash, template, inverse) {
    // If `morph` is `null` the keyword is being invoked as a subexpression.
    if (morph === null) {
      var valueStream = originalParams[0];
      return mutParam(env.hooks.getValue, valueStream);
    }

    return true;
  }

  function privateMut(morph, env, scope, originalParams, hash, template, inverse) {
    // If `morph` is `null` the keyword is being invoked as a subexpression.
    if (morph === null) {
      var valueStream = originalParams[0];
      return mutParam(env.hooks.getValue, valueStream, true);
    }

    return true;
  }

  var LiteralStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (literal) {
      this.literal = literal;
      this.label = '(literal ' + literal + ')';
    },

    compute: function () {
      return this.literal;
    },

    setValue: function (val) {
      this.literal = val;
      this.notify();
    }
  });

  function mutParam(read, stream, internal) {
    if (internal) {
      if (!_emberHtmlbarsStreamsUtils.isStream(stream)) {
        var literal = stream;
        stream = new LiteralStream(literal);
      }
    } else {}

    if (stream[MUTABLE_REFERENCE]) {
      return stream;
    }

    return new MutStream(stream);
  }
})(Em._e[100],Em._e[0],Em._e[13],Em._e[78],Em._e[56],Em._e[66],Em._e[67],Em._e[99]);
(function (exports, _emberHtmlbarsStreamsUtils, _emberHtmlbarsKeywordsMut) {
  'use strict';

  exports.default = getCellOrValue;

  function getCellOrValue(ref) {
    if (ref && ref[_emberHtmlbarsKeywordsMut.MUTABLE_REFERENCE]) {
      // Reify the mutable reference into a mutable cell.
      return ref.cell();
    }

    // Get the value out of the reference.
    return _emberHtmlbarsStreamsUtils.read(ref);
  }
})(Em._e[101],Em._e[66],Em._e[100]);
(function (exports, _emberMetalInstrumentation) {
  'use strict';

  exports.instrument = instrument;

  /**
    Provides instrumentation for node managers.
  
    Wrap your node manager's render and re-render methods
    with this function.
  
    @param {Object} component Component or View instance (optional).
    @param {Function} callback The function to instrument.
    @param {Object} context The context to call the function with.
    @return {Object} Return value from the invoked callback.
    @private
  */

  function instrument(component, callback, context) {
    var instrumentName = undefined,
        val = undefined,
        details = undefined,
        end = undefined;
    // Only instrument if there's at least one subscriber.
    if (_emberMetalInstrumentation.subscribers.length) {
      if (component) {
        instrumentName = component.instrumentName;
      } else {
        instrumentName = 'node';
      }
      details = {};
      if (component) {
        component.instrumentDetails(details);
      }
      end = _emberMetalInstrumentation._instrumentStart('render.' + instrumentName, function viewInstrumentDetails() {
        return details;
      });
      val = callback.call(context);
      if (end) {
        end();
      }
      return val;
    } else {
      return callback.call(context);
    }
  }
})(Em._e[102],Em._e[98]);
(function (exports, _emberEnvironment, _emberMetalDebug, _emberMetalProperty_get, _emberMetalMixin, _emberMetalComputed) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  /**
  `Ember.TargetActionSupport` is a mixin that can be included in a class
  to add a `triggerAction` method with semantics similar to the Handlebars
  `{{action}}` helper. In normal Ember usage, the `{{action}}` helper is
  usually the best choice. This mixin is most often useful when you are
  doing more complex event handling in View objects.
  
  See also `Ember.ViewTargetActionSupport`, which has
  view-aware defaults for target and actionContext.
  
  @class TargetActionSupport
  @namespace Ember
  @extends Ember.Mixin
  @private
  */
  exports.default = _emberMetalMixin.Mixin.create({
    target: null,
    action: null,
    actionContext: null,

    actionContextObject: _emberMetalComputed.computed('actionContext', function () {
      var actionContext = _emberMetalProperty_get.get(this, 'actionContext');

      if (typeof actionContext === 'string') {
        var value = _emberMetalProperty_get.get(this, actionContext);
        if (value === undefined) {
          value = _emberMetalProperty_get.get(_emberEnvironment.context.lookup, actionContext);
        }
        return value;
      } else {
        return actionContext;
      }
    }),

    /**
    Send an `action` with an `actionContext` to a `target`. The action, actionContext
    and target will be retrieved from properties of the object. For example:
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: Ember.computed.alias('controller'),
      action: 'save',
      actionContext: Ember.computed.alias('context'),
      click() {
        this.triggerAction(); // Sends the `save` action, along with the current context
                              // to the current controller
      }
    });
    ```
     The `target`, `action`, and `actionContext` can be provided as properties of
    an optional object argument to `triggerAction` as well.
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      click() {
        this.triggerAction({
          action: 'save',
          target: this.get('controller'),
          actionContext: this.get('context')
        }); // Sends the `save` action, along with the current context
            // to the current controller
      }
    });
    ```
     The `actionContext` defaults to the object you are mixing `TargetActionSupport` into.
    But `target` and `action` must be specified either as properties or with the argument
    to `triggerAction`, or a combination:
     ```javascript
    App.SaveButtonView = Ember.View.extend(Ember.TargetActionSupport, {
      target: Ember.computed.alias('controller'),
      click() {
        this.triggerAction({
          action: 'save'
        }); // Sends the `save` action, along with a reference to `this`,
            // to the current controller
      }
    });
    ```
     @method triggerAction
    @param opts {Object} (optional, with the optional keys action, target and/or actionContext)
    @return {Boolean} true if the action was sent successfully and did not return false
    @private
    */
    triggerAction: function () {
      var opts = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

      var action = opts.action || _emberMetalProperty_get.get(this, 'action');
      var target = opts.target;

      if (!target) {
        target = getTarget(this);
      }

      var actionContext = opts.actionContext;

      function args(options, actionName) {
        var ret = [];
        if (actionName) {
          ret.push(actionName);
        }

        return ret.concat(options);
      }

      if (typeof actionContext === 'undefined') {
        actionContext = _emberMetalProperty_get.get(this, 'actionContextObject') || this;
      }

      if (target && action) {
        var ret = undefined;

        if (target.send) {
          ret = target.send.apply(target, args(actionContext, action));
        } else {
          ret = target[action].apply(target, args(actionContext));
        }

        if (ret !== false) {
          ret = true;
        }

        return ret;
      } else {
        return false;
      }
    }
  });

  function getTarget(instance) {
    // TODO: Deprecate specifying `targetObject`
    var target = _emberMetalProperty_get.get(instance, 'targetObject');

    // if a `targetObject` CP was provided, use it
    if (target) {
      return target;
    }

    // if _targetObject use it
    if (instance._targetObject) {
      return instance._targetObject;
    }

    target = _emberMetalProperty_get.get(instance, 'target');
    if (target) {
      if (typeof target === 'string') {
        var value = _emberMetalProperty_get.get(instance, target);
        if (value === undefined) {
          value = _emberMetalProperty_get.get(_emberEnvironment.context.lookup, target);
        }

        return value;
      } else {
        return target;
      }
    }

    return null;
  }
})(Em._e[103],Em._e[4],Em._e[0],Em._e[30],Em._e[61],Em._e[59]);
(function (exports, _emberMetalMixin, _emberMetalProperty_get, _emberMetalIs_none, _emberMetalDebug, _emberViewsCompatAttrsProxy, _emberMetalUtils) {
  'use strict';

  function validateAction(component, actionName) {
    if (actionName && actionName[_emberViewsCompatAttrsProxy.MUTABLE_CELL]) {
      actionName = actionName.value;
    }

    return actionName;
  }

  exports.default = _emberMetalMixin.Mixin.create({
    /**
      Calls an action passed to a component.
       For example a component for playing or pausing music may translate click events
      into action notifications of "play" or "stop" depending on some internal state
      of the component:
       ```javascript
      // app/components/play-button.js
      export default Ember.Component.extend({
        click() {
          if (this.get('isPlaying')) {
            this.sendAction('play');
          } else {
            this.sendAction('stop');
          }
        }
      });
      ```
       The actions "play" and "stop" must be passed to this `play-button` component:
       ```handlebars
      {{! app/templates/application.hbs }}
      {{play-button play=(action "musicStarted") stop=(action "musicStopped")}}
      ```
       When the component receives a browser `click` event it translate this
      interaction into application-specific semantics ("play" or "stop") and
      calls the specified action.
       ```javascript
      // app/controller/application.js
      export default Ember.Controller.extend({
        actions: {
          musicStarted() {
            // called when the play button is clicked
            // and the music started playing
          },
          musicStopped() {
            // called when the play button is clicked
            // and the music stopped playing
          }
        }
      });
      ```
       If no action is passed to `sendAction` a default name of "action"
      is assumed.
       ```javascript
      // app/components/next-button.js
      export default Ember.Component.extend({
        click() {
          this.sendAction();
        }
      });
      ```
       ```handlebars
      {{! app/templates/application.hbs }}
      {{next-button action=(action "playNextSongInAlbum")}}
      ```
       ```javascript
      // app/controllers/application.js
      App.ApplicationController = Ember.Controller.extend({
        actions: {
          playNextSongInAlbum() {
            ...
          }
        }
      });
      ```
       @method sendAction
      @param [action] {String} the action to call
      @param [params] {*} arguments for the action
      @public
    */
    sendAction: function (action) {
      for (var _len = arguments.length, contexts = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        contexts[_key - 1] = arguments[_key];
      }

      var actionName = undefined;

      // Send the default action
      if (action === undefined) {
        action = 'action';
      }
      actionName = _emberMetalProperty_get.get(this, 'attrs.' + action) || _emberMetalProperty_get.get(this, action);
      actionName = validateAction(this, actionName);

      // If no action name for that action could be found, just abort.
      if (actionName === undefined) {
        return;
      }

      if (typeof actionName === 'function') {
        actionName.apply(undefined, contexts);
      } else {
        this.triggerAction({
          action: actionName,
          actionContext: contexts
        });
      }
    },

    send: function (actionName) {
      for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      var target = undefined;
      var action = this.actions && this.actions[actionName];

      if (action) {
        var shouldBubble = action.apply(this, args) === true;
        if (!shouldBubble) {
          return;
        }
      }

      target = _emberMetalProperty_get.get(this, 'target') || _emberMetalProperty_get.get(this, '_targetObject');

      if (target) {
        var _target;

        (_target = target).send.apply(_target, arguments);
      } else {}
    }
  });
})(Em._e[104],Em._e[61],Em._e[30],Em._e[75],Em._e[0],Em._e[67],Em._e[7]);
(function (exports, _emberMetalRun_loop) {
  /**
  @module ember
  @submodule ember-views
  */

  'use strict';

  // Add a new named queue for rendering views that happens
  // after bindings have synced, and a queue for scheduling actions
  // that should occur after view rendering.
  _emberMetalRun_loop.default._addQueue('render', 'actions');
  _emberMetalRun_loop.default._addQueue('afterRender', 'render');
})(Em._e[105],Em._e[27]);
(function (exports, _emberMetalMixin, _emberMetalEvents) {
  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  /**
    This mixin allows for Ember objects to subscribe to and emit events.
  
    ```javascript
    App.Person = Ember.Object.extend(Ember.Evented, {
      greet: function() {
        // ...
        this.trigger('greet');
      }
    });
  
    var person = App.Person.create();
  
    person.on('greet', function() {
      console.log('Our person has greeted');
    });
  
    person.greet();
  
    // outputs: 'Our person has greeted'
    ```
  
    You can also chain multiple event subscriptions:
  
    ```javascript
    person.on('greet', function() {
      console.log('Our person has greeted');
    }).one('greet', function() {
      console.log('Offer one-time special');
    }).off('event', this, forgetThis);
    ```
  
    @class Evented
    @namespace Ember
    @public
   */
  exports.default = _emberMetalMixin.Mixin.create({

    /**
     Subscribes to a named event with given function.
      ```javascript
     person.on('didLoad', function() {
       // fired once the person has loaded
     });
     ```
      An optional target can be passed in as the 2nd argument that will
     be set as the "this" for the callback. This is a good way to give your
     function access to the object triggering the event. When the target
     parameter is used the callback becomes the third argument.
      @method on
     @param {String} name The name of the event
     @param {Object} [target] The "this" binding for the callback
     @param {Function} method The callback to execute
     @return this
     @public
    */
    on: function (name, target, method) {
      _emberMetalEvents.addListener(this, name, target, method);
      return this;
    },

    /**
      Subscribes a function to a named event and then cancels the subscription
      after the first time the event is triggered. It is good to use ``one`` when
      you only care about the first time an event has taken place.
       This function takes an optional 2nd argument that will become the "this"
      value for the callback. If this argument is passed then the 3rd argument
      becomes the function.
       @method one
      @param {String} name The name of the event
      @param {Object} [target] The "this" binding for the callback
      @param {Function} method The callback to execute
      @return this
      @public
    */
    one: function (name, target, method) {
      if (!method) {
        method = target;
        target = null;
      }

      _emberMetalEvents.addListener(this, name, target, method, true);
      return this;
    },

    /**
      Triggers a named event for the object. Any additional arguments
      will be passed as parameters to the functions that are subscribed to the
      event.
       ```javascript
      person.on('didEat', function(food) {
        console.log('person ate some ' + food);
      });
       person.trigger('didEat', 'broccoli');
       // outputs: person ate some broccoli
      ```
      @method trigger
      @param {String} name The name of the event
      @param {Object...} args Optional arguments to pass on
      @public
    */
    trigger: function (name) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      _emberMetalEvents.sendEvent(this, name, args);
    },

    /**
      Cancels subscription for given name, target, and method.
       @method off
      @param {String} name The name of the event
      @param {Object} target The target of the subscription
      @param {Function} method The function of the subscription
      @return this
      @public
    */
    off: function (name, target, method) {
      _emberMetalEvents.removeListener(this, name, target, method);
      return this;
    },

    /**
      Checks to see if object has any subscriptions for named event.
       @method has
      @param {String} name The name of the event
      @return {Boolean} does the object have a subscription for event
      @public
     */
    has: function (name) {
      return _emberMetalEvents.hasListeners(this, name);
    }
  });
})(Em._e[106],Em._e[61],Em._e[15]);
(function (exports, _emberMetalError, _emberMetalProperty_get, _emberViewsCompatAttrsProxy) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */
  exports.default = {
    // appendChild is only legal while rendering the buffer.
    appendChild: function () {
      throw new _emberMetalError.default('You can\'t use appendChild outside of the rendering process');
    },

    $: function () {
      return undefined;
    },

    getElement: function () {
      return null;
    },

    legacyPropertyDidChange: function (view, key) {
      var attrs = view.attrs;
      if (attrs && key in attrs) {
        var possibleCell = attrs[key];

        if (possibleCell && possibleCell[_emberViewsCompatAttrsProxy.MUTABLE_CELL]) {
          var value = _emberMetalProperty_get.get(view, key);
          if (value === possibleCell.value) {
            return;
          }
          possibleCell.update(value);
        }
      }
    },

    // Handle events from `Ember.EventDispatcher`
    handleEvent: function () {
      return true; // continue event propagation
    },

    destroy: function () {},

    rerender: function (view) {
      view.renderer.ensureViewNotRendering(view);
    }
  };
})(Em._e[107],Em._e[31],Em._e[30],Em._e[67]);
(function (exports, _emberViewsViewsStatesDefault, _emberMetalAssign) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */

  var preRender = Object.create(_emberViewsViewsStatesDefault.default);

  _emberMetalAssign.default(preRender, {
    legacyPropertyDidChange: function (view, key) {}
  });

  exports.default = preRender;
})(Em._e[108],Em._e[107],Em._e[8]);
(function (exports, _emberEnvironment) {
  'use strict';

  var jQuery = undefined;

  if (_emberEnvironment.environment.hasDOM) {
    jQuery = _emberEnvironment.context.imports.jQuery;

    if (jQuery) {
      if (jQuery.event.addProp) {
        jQuery.event.addProp('dataTransfer');
      } else {
        // http://www.whatwg.org/specs/web-apps/current-work/multipage/dnd.html#dndevents
        ['dragstart', 'drag', 'dragenter', 'dragleave', 'dragover', 'drop', 'dragend'].forEach(function (eventName) {
          jQuery.event.fixHooks[eventName] = {
            props: ['dataTransfer']
          };
        });
      }
    }
  }

  exports.default = jQuery;
})(Em._e[109],Em._e[4]);
(function (exports, _emberViewsViewsStatesDefault, _emberMetalAssign, _emberViewsSystemJquery, _emberMetalRun_loop, _emberMetalInstrumentation, _emberMetalProperty_get) {
  'use strict';

  var hasElement = Object.create(_emberViewsViewsStatesDefault.default);

  _emberMetalAssign.default(hasElement, {
    $: function (view, sel) {
      var elem = view.element;
      return sel ? _emberViewsSystemJquery.default(sel, elem) : _emberViewsSystemJquery.default(elem);
    },

    getElement: function (view) {
      var parent = _emberMetalProperty_get.get(view, 'parentView');
      if (parent) {
        parent = _emberMetalProperty_get.get(parent, 'element');
      }
      if (parent) {
        return view.findElementInParentElement(parent);
      }
      return _emberViewsSystemJquery.default('#' + _emberMetalProperty_get.get(view, 'elementId'))[0];
    },

    // once the view has been inserted into the DOM, rerendering is
    // deferred to allow bindings to synchronize.
    rerender: function (view) {
      view.renderer.ensureViewNotRendering(view);
      view.renderer.rerender(view);
    },

    destroy: function (view) {
      view.renderer.remove(view, true);
    },

    // Handle events from `Ember.EventDispatcher`
    handleEvent: function (view, eventName, event) {
      if (view.has(eventName)) {
        // Handler should be able to re-dispatch events, so we don't
        // preventDefault or stopPropagation.
        return _emberMetalInstrumentation.flaggedInstrument('interaction.' + eventName, { event: event, view: view }, function () {
          return _emberMetalRun_loop.default.join(view, view.trigger, eventName, event);
        });
      } else {
        return true; // continue event propagation
      }
    }
  });

  exports.default = hasElement;
})(Em._e[110],Em._e[107],Em._e[8],Em._e[109],Em._e[27],Em._e[98],Em._e[30]);
(function (exports, _emberMetalDebug, _emberMetalAssign, _emberMetalError, _emberMetalObserver, _emberViewsViewsStatesHas_element) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */

  var inDOM = Object.create(_emberViewsViewsStatesHas_element.default);

  _emberMetalAssign.default(inDOM, {
    enter: function (view) {
      // Register the view for event handling. This hash is used by
      // Ember.EventDispatcher to dispatch incoming events.
      if (view.tagName !== '') {
        view.renderer.register(view);
      }
    },

    exit: function (view) {
      if (view.tagName !== '') {
        view.renderer.unregister(view);
      }
    }
  });

  exports.default = inDOM;
})(Em._e[111],Em._e[0],Em._e[8],Em._e[31],Em._e[53],Em._e[110]);
(function (exports, _emberMetalAssign, _emberViewsViewsStatesDefault, _emberMetalError) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */

  var destroying = Object.create(_emberViewsViewsStatesDefault.default);

  _emberMetalAssign.default(destroying, {
    appendChild: function () {
      throw new _emberMetalError.default('You can\'t call appendChild on a view being destroyed');
    },
    rerender: function () {
      throw new _emberMetalError.default('You can\'t call rerender on a view being destroyed');
    }
  });

  exports.default = destroying;
})(Em._e[112],Em._e[8],Em._e[107],Em._e[31]);
(function (exports, _emberMetalAssign, _emberViewsViewsStatesDefault, _emberViewsViewsStatesPre_render, _emberViewsViewsStatesHas_element, _emberViewsViewsStatesIn_dom, _emberViewsViewsStatesDestroying) {
  'use strict';

  exports.cloneStates = cloneStates;

  function cloneStates(from) {
    var into = {};

    into._default = {};
    into.preRender = Object.create(into._default);
    into.destroying = Object.create(into._default);
    into.hasElement = Object.create(into._default);
    into.inDOM = Object.create(into.hasElement);

    for (var stateName in from) {
      if (!from.hasOwnProperty(stateName)) {
        continue;
      }
      _emberMetalAssign.default(into[stateName], from[stateName]);
    }

    return into;
  }

  var states = {
    _default: _emberViewsViewsStatesDefault.default,
    preRender: _emberViewsViewsStatesPre_render.default,
    inDOM: _emberViewsViewsStatesIn_dom.default,
    hasElement: _emberViewsViewsStatesHas_element.default,
    destroying: _emberViewsViewsStatesDestroying.default
  };
  exports.states = states;
})(Em._e[113],Em._e[8],Em._e[107],Em._e[108],Em._e[110],Em._e[111],Em._e[112]);
(function (exports, _emberMetalProperty_get, _emberRuntimeSystemObject, _emberRuntimeMixinsEvented, _emberRuntimeMixinsAction_handler, _emberRuntimeUtils, _emberViewsViewsStates, _require) {
  'use strict';

  // Normally, the renderer is injected by the container when the view is looked
  // up. However, if someone creates a view without looking it up via the
  // container (e.g. `Ember.View.create().append()`) then we create a fallback
  // DOM renderer that is shared. In general, this path should be avoided since
  // views created this way cannot run in a node environment.
  var renderer = undefined;

  /**
    `Ember.CoreView` is an abstract class that exists to give view-like behavior
    to both Ember's main view class `Ember.View` and other classes that don't need
    the fully functionaltiy of `Ember.View`.
  
    Unless you have specific needs for `CoreView`, you will use `Ember.View`
    in your applications.
  
    @class CoreView
    @namespace Ember
    @extends Ember.Object
    @deprecated Use `Ember.View` instead.
    @uses Ember.Evented
    @uses Ember.ActionHandler
    @private
  */
  var CoreView = _emberRuntimeSystemObject.default.extend(_emberRuntimeMixinsEvented.default, _emberRuntimeMixinsAction_handler.default, {
    isView: true,

    _states: _emberViewsViewsStates.cloneStates(_emberViewsViewsStates.states),

    init: function () {
      this._super.apply(this, arguments);
      this._state = 'preRender';
      this._currentState = this._states.preRender;
      this._willInsert = false;
      this._renderNode = null;
      this.lastResult = null;
      this._dispatching = null;
      this._destroyingSubtreeForView = null;
      this._isDispatchingAttrs = false;
      this._isVisible = false;
      this.element = null;
      this._env = null;
      this._isVisible = _emberMetalProperty_get.get(this, 'isVisible');

      // Fallback for legacy cases where the view was created directly
      // via `create()` instead of going through the container.
      if (!this.renderer) {
        renderer = renderer || htmlbarsRenderer();
        this.renderer = renderer;
      }
    },

    /**
      If the view is currently inserted into the DOM of a parent view, this
      property will point to the parent of the view.
       @property parentView
      @type Ember.View
      @default null
      @private
    */
    parentView: null,

    instrumentName: 'core_view',

    instrumentDetails: function (hash) {
      hash.object = this.toString();
      hash.containerKey = this._debugContainerKey;
      hash.view = this;
    },

    /**
      Override the default event firing from `Ember.Evented` to
      also call methods with the given name.
       @method trigger
      @param name {String}
      @private
    */
    trigger: function () {
      this._super.apply(this, arguments);
      var name = arguments[0];
      var method = this[name];
      if (method) {
        var args = new Array(arguments.length - 1);
        for (var i = 1; i < arguments.length; i++) {
          args[i - 1] = arguments[i];
        }
        return method.apply(this, args);
      }
    },

    has: function (name) {
      return _emberRuntimeUtils.typeOf(this[name]) === 'function' || this._super(name);
    }
  });

  _emberRuntimeMixinsAction_handler.deprecateUnderscoreActions(CoreView);

  CoreView.reopenClass({
    isViewFactory: true
  });

  var InteractiveRenderer = undefined,
      DOMHelper = undefined;
  function htmlbarsRenderer() {
    DOMHelper = DOMHelper || _require.default('ember-htmlbars/system/dom-helper').default;
    InteractiveRenderer = InteractiveRenderer || _require.default('ember-htmlbars/renderer').InteractiveRenderer;

    return InteractiveRenderer.create({ dom: new DOMHelper() });
  }

  exports.default = CoreView;
})(Em._e[114],Em._e[30],Em._e[77],Em._e[106],Em._e[63],Em._e[91],Em._e[113],Em.__loader.require);
(function (exports, _emberMetalMixin, _containerOwner) {
  /**
  @module ember
  @submodule ember-views
  */
  'use strict';

  exports.default = _emberMetalMixin.Mixin.create({
    init: function () {
      this._super.apply(this, arguments);

      /**
        Array of child views. You should never edit this array directly.
         @property childViews
        @type Array
        @default []
        @private
      */
      this.childViews = [];
      this.ownerView = this.ownerView || this;
    },

    appendChild: function (view) {
      this.linkChild(view);
      this.childViews.push(view);
    },

    destroyChild: function (view) {
      view.destroy();
    },

    /**
      Removes the child view from the parent view.
       @method removeChild
      @param {Ember.View} view
      @return {Ember.View} receiver
      @private
    */
    removeChild: function (view) {
      // If we're destroying, the entire subtree will be
      // freed, and the DOM will be handled separately,
      // so no need to mess with childViews.
      if (this.isDestroying) {
        return;
      }

      // update parent node
      this.unlinkChild(view);

      // remove view from childViews array.
      var childViews = this.childViews;

      var index = childViews.indexOf(view);
      if (index !== -1) {
        childViews.splice(index, 1);
      }

      return this;
    },

    linkChild: function (instance) {
      if (!instance[_containerOwner.OWNER]) {
        _containerOwner.setOwner(instance, _containerOwner.getOwner(this));
      }

      instance.parentView = this;
      instance.ownerView = this.ownerView;
    },

    unlinkChild: function (instance) {
      instance.parentView = null;
    }
  });
})(Em._e[115],Em._e[61],Em._e[70]);
(function (exports, _emberMetalMixin) {
  'use strict';

  exports.default = _emberMetalMixin.Mixin.create({
    _transitionTo: function (state) {
      var priorState = this._currentState;
      var currentState = this._currentState = this._states[state];
      this._state = state;

      if (priorState && priorState.exit) {
        priorState.exit(this);
      }
      if (currentState.enter) {
        currentState.enter(this);
      }
    }
  });
})(Em._e[116],Em._e[61]);
(function (exports) {
  "use strict";

  exports.default = replace;
  var splice = Array.prototype.splice;

  function replace(array, idx, amt, objects) {
    var args = [].concat(objects);
    var ret = [];
    // https://code.google.com/p/chromium/issues/detail?id=56588
    var size = 60000;
    var start = idx;
    var ends = amt;
    var count = undefined,
        chunk = undefined;

    while (args.length) {
      count = ends > size ? size : ends;
      if (count <= 0) {
        count = 0;
      }

      chunk = args.splice(0, size);
      chunk = [start, count].concat(chunk);

      start += size;
      ends -= count;

      ret = ret.concat(splice.apply(array, chunk));
    }
    return ret;
  }
})(Em._e[117]);
(function (exports, _emberRuntimeMixinsEnumerable, _emberMetalMixin, _emberMetalProperty_events) {
  'use strict';

  /**
  @module ember
  @submodule ember-runtime
  */

  /**
    This mixin defines the API for modifying generic enumerables. These methods
    can be applied to an object regardless of whether it is ordered or
    unordered.
  
    Note that an Enumerable can change even if it does not implement this mixin.
    For example, a MappedEnumerable cannot be directly modified but if its
    underlying enumerable changes, it will change also.
  
    ## Adding Objects
  
    To add an object to an enumerable, use the `addObject()` method. This
    method will only add the object to the enumerable if the object is not
    already present and is of a type supported by the enumerable.
  
    ```javascript
    set.addObject(contact);
    ```
  
    ## Removing Objects
  
    To remove an object from an enumerable, use the `removeObject()` method. This
    will only remove the object if it is present in the enumerable, otherwise
    this method has no effect.
  
    ```javascript
    set.removeObject(contact);
    ```
  
    ## Implementing In Your Own Code
  
    If you are implementing an object and want to support this API, just include
    this mixin in your class and implement the required methods. In your unit
    tests, be sure to apply the Ember.MutableEnumerableTests to your object.
  
    @class MutableEnumerable
    @namespace Ember
    @uses Ember.Enumerable
    @public
  */
  exports.default = _emberMetalMixin.Mixin.create(_emberRuntimeMixinsEnumerable.default, {

    /**
      __Required.__ You must implement this method to apply this mixin.
       Attempts to add the passed object to the receiver if the object is not
      already present in the collection. If the object is present, this method
      has no effect.
       If the passed object is of a type not supported by the receiver,
      then this method should raise an exception.
       @method addObject
      @param {Object} object The object to add to the enumerable.
      @return {Object} the passed object
      @public
    */
    addObject: null,

    /**
      Adds each object in the passed enumerable to the receiver.
       @method addObjects
      @param {Ember.Enumerable} objects the objects to add.
      @return {Object} receiver
      @public
    */
    addObjects: function (objects) {
      var _this = this;

      _emberMetalProperty_events.beginPropertyChanges(this);
      objects.forEach(function (obj) {
        return _this.addObject(obj);
      });
      _emberMetalProperty_events.endPropertyChanges(this);
      return this;
    },

    /**
      __Required.__ You must implement this method to apply this mixin.
       Attempts to remove the passed object from the receiver collection if the
      object is present in the collection. If the object is not present,
      this method has no effect.
       If the passed object is of a type not supported by the receiver,
      then this method should raise an exception.
       @method removeObject
      @param {Object} object The object to remove from the enumerable.
      @return {Object} the passed object
      @public
    */
    removeObject: null,

    /**
      Removes each object in the passed enumerable from the receiver.
       @method removeObjects
      @param {Ember.Enumerable} objects the objects to remove
      @return {Object} receiver
      @public
    */
    removeObjects: function (objects) {
      _emberMetalProperty_events.beginPropertyChanges(this);
      for (var i = objects.length - 1; i >= 0; i--) {
        this.removeObject(objects[i]);
      }
      _emberMetalProperty_events.endPropertyChanges(this);
      return this;
    }
  });
})(Em._e[118],Em._e[88],Em._e[61],Em._e[20]);
(function (exports, _emberMetalProperty_get, _emberMetalError, _emberMetalMixin, _emberRuntimeMixinsArray, _emberRuntimeMixinsMutable_enumerable, _emberRuntimeMixinsEnumerable, _emberMetalFeatures) {
  /**
  @module ember
  @submodule ember-runtime
  */

  //Em.__loader.require.default('ember-runtime/mixins/array');
  //Em.__loader.require.default('ember-runtime/mixins/mutable_enumerable');

  // ..........................................................
  // CONSTANTS
  //

  'use strict';

  exports.removeAt = removeAt;
  var OUT_OF_RANGE_EXCEPTION = 'Index out of range';
  var EMPTY = [];

  // ..........................................................
  // HELPERS
  //

  function removeAt(array, start, len) {
    if ('number' === typeof start) {
      if (start < 0 || start >= _emberMetalProperty_get.get(array, 'length')) {
        throw new _emberMetalError.default(OUT_OF_RANGE_EXCEPTION);
      }

      // fast case
      if (len === undefined) {
        len = 1;
      }

      array.replace(start, len, EMPTY);
    }

    return array;
  }

  /**
    This mixin defines the API for modifying array-like objects. These methods
    can be applied only to a collection that keeps its items in an ordered set.
    It builds upon the Array mixin and adds methods to modify the array.
    One concrete implementations of this class include ArrayProxy.
  
    It is important to use the methods in this class to modify arrays so that
    changes are observable. This allows the binding system in Ember to function
    correctly.
  
  
    Note that an Array can change even if it does not implement this mixin.
    For example, one might implement a SparseArray that cannot be directly
    modified, but if its underlying enumerable changes, it will change also.
  
    @class MutableArray
    @namespace Ember
    @uses Ember.Array
    @uses Ember.MutableEnumerable
    @public
  */
  exports.default = _emberMetalMixin.Mixin.create(_emberRuntimeMixinsArray.default, _emberRuntimeMixinsMutable_enumerable.default, {

    /**
      __Required.__ You must implement this method to apply this mixin.
       This is one of the primitives you must implement to support `Ember.Array`.
      You should replace amt objects started at idx with the objects in the
      passed array. You should also call `this.enumerableContentDidChange()`
       @method replace
      @param {Number} idx Starting index in the array to replace. If
        idx >= length, then append to the end of the array.
      @param {Number} amt Number of elements that should be removed from
        the array, starting at *idx*.
      @param {Array} objects An array of zero or more objects that should be
        inserted into the array at *idx*
      @public
    */
    replace: null,

    /**
      Remove all elements from the array. This is useful if you
      want to reuse an existing array without having to recreate it.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       color.length();   //  3
      colors.clear();   //  []
      colors.length();  //  0
      ```
       @method clear
      @return {Ember.Array} An empty Array.
      @public
    */
    clear: function () {
      var len = _emberMetalProperty_get.get(this, 'length');
      if (len === 0) {
        return this;
      }

      this.replace(0, len, EMPTY);
      return this;
    },

    /**
      This will use the primitive `replace()` method to insert an object at the
      specified index.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.insertAt(2, 'yellow');  // ['red', 'green', 'yellow', 'blue']
      colors.insertAt(5, 'orange');  // Error: Index out of range
      ```
       @method insertAt
      @param {Number} idx index of insert the object at.
      @param {Object} object object to insert
      @return {Ember.Array} receiver
      @public
    */
    insertAt: function (idx, object) {
      if (idx > _emberMetalProperty_get.get(this, 'length')) {
        throw new _emberMetalError.default(OUT_OF_RANGE_EXCEPTION);
      }

      this.replace(idx, 0, [object]);
      return this;
    },

    /**
      Remove an object at the specified index using the `replace()` primitive
      method. You can pass either a single index, or a start and a length.
       If you pass a start and length that is beyond the
      length this method will throw an `OUT_OF_RANGE_EXCEPTION`.
       ```javascript
      let colors = ['red', 'green', 'blue', 'yellow', 'orange'];
       colors.removeAt(0);     // ['green', 'blue', 'yellow', 'orange']
      colors.removeAt(2, 2);  // ['green', 'blue']
      colors.removeAt(4, 2);  // Error: Index out of range
      ```
       @method removeAt
      @param {Number} start index, start of range
      @param {Number} len length of passing range
      @return {Ember.Array} receiver
      @public
    */
    removeAt: function (start, len) {
      return removeAt(this, start, len);
    },

    /**
      Push the object onto the end of the array. Works just like `push()` but it
      is KVO-compliant.
       ```javascript
      let colors = ['red', 'green'];
       colors.pushObject('black');     // ['red', 'green', 'black']
      colors.pushObject(['yellow']);  // ['red', 'green', ['yellow']]
      ```
       @method pushObject
      @param {*} obj object to push
      @return object same object passed as a param
      @public
    */
    pushObject: function (obj) {
      this.insertAt(_emberMetalProperty_get.get(this, 'length'), obj);
      return obj;
    },

    /**
      Add the objects in the passed numerable to the end of the array. Defers
      notifying observers of the change until all objects are added.
       ```javascript
      let colors = ['red'];
       colors.pushObjects(['yellow', 'orange']);  // ['red', 'yellow', 'orange']
      ```
       @method pushObjects
      @param {Ember.Enumerable} objects the objects to add
      @return {Ember.Array} receiver
      @public
    */
    pushObjects: function (objects) {
      if (!(_emberRuntimeMixinsEnumerable.default.detect(objects) || Array.isArray(objects))) {
        throw new TypeError('Must pass Ember.Enumerable to Ember.MutableArray#pushObjects');
      }
      this.replace(_emberMetalProperty_get.get(this, 'length'), 0, objects);
      return this;
    },

    /**
      Pop object from array or nil if none are left. Works just like `pop()` but
      it is KVO-compliant.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.popObject();   // 'blue'
      console.log(colors);  // ['red', 'green']
      ```
       @method popObject
      @return object
      @public
    */
    popObject: function () {
      var len = _emberMetalProperty_get.get(this, 'length');
      if (len === 0) {
        return null;
      }

      var ret = _emberRuntimeMixinsArray.objectAt(this, len - 1);
      this.removeAt(len - 1, 1);
      return ret;
    },

    /**
      Shift an object from start of array or nil if none are left. Works just
      like `shift()` but it is KVO-compliant.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.shiftObject();  // 'red'
      console.log(colors);   // ['green', 'blue']
      ```
       @method shiftObject
      @return object
      @public
    */
    shiftObject: function () {
      if (_emberMetalProperty_get.get(this, 'length') === 0) {
        return null;
      }

      var ret = _emberRuntimeMixinsArray.objectAt(this, 0);
      this.removeAt(0);
      return ret;
    },

    /**
      Unshift an object to start of array. Works just like `unshift()` but it is
      KVO-compliant.
       ```javascript
      let colors = ['red'];
       colors.unshiftObject('yellow');    // ['yellow', 'red']
      colors.unshiftObject(['black']);   // [['black'], 'yellow', 'red']
      ```
       @method unshiftObject
      @param {*} obj object to unshift
      @return object same object passed as a param
      @public
    */
    unshiftObject: function (obj) {
      this.insertAt(0, obj);
      return obj;
    },

    /**
      Adds the named objects to the beginning of the array. Defers notifying
      observers until all objects have been added.
       ```javascript
      let colors = ['red'];
       colors.unshiftObjects(['black', 'white']);   // ['black', 'white', 'red']
      colors.unshiftObjects('yellow'); // Type Error: 'undefined' is not a function
      ```
       @method unshiftObjects
      @param {Ember.Enumerable} objects the objects to add
      @return {Ember.Array} receiver
      @public
    */
    unshiftObjects: function (objects) {
      this.replace(0, 0, objects);
      return this;
    },

    /**
      Reverse objects in the array. Works just like `reverse()` but it is
      KVO-compliant.
       @method reverseObjects
      @return {Ember.Array} receiver
       @public
    */
    reverseObjects: function () {
      var len = _emberMetalProperty_get.get(this, 'length');
      if (len === 0) {
        return this;
      }

      var objects = this.toArray().reverse();
      this.replace(0, len, objects);
      return this;
    },

    /**
      Replace all the receiver's content with content of the argument.
      If argument is an empty array receiver will be cleared.
       ```javascript
      let colors = ['red', 'green', 'blue'];
       colors.setObjects(['black', 'white']);  // ['black', 'white']
      colors.setObjects([]);                  // []
      ```
       @method setObjects
      @param {Ember.Array} objects array whose content will be used for replacing
          the content of the receiver
      @return {Ember.Array} receiver with the new content
      @public
    */
    setObjects: function (objects) {
      if (objects.length === 0) {
        return this.clear();
      }

      var len = _emberMetalProperty_get.get(this, 'length');
      this.replace(0, len, objects);
      return this;
    },

    // ..........................................................
    // IMPLEMENT Ember.MutableEnumerable
    //

    /**
      Remove all occurrences of an object in the array.
       ```javascript
      let cities = ['Chicago', 'Berlin', 'Lima', 'Chicago'];
       cities.removeObject('Chicago');  // ['Berlin', 'Lima']
      cities.removeObject('Lima');     // ['Berlin']
      cities.removeObject('Tokyo')     // ['Berlin']
      ```
       @method removeObject
      @param {*} obj object to remove
      @return {Ember.Array} receiver
      @public
    */
    removeObject: function (obj) {
      var loc = _emberMetalProperty_get.get(this, 'length') || 0;
      while (--loc >= 0) {
        var curObject = _emberRuntimeMixinsArray.objectAt(this, loc);

        if (curObject === obj) {
          this.removeAt(loc);
        }
      }
      return this;
    },

    /**
      Push the object onto the end of the array if it is not already
      present in the array.
       ```javascript
      let cities = ['Chicago', 'Berlin'];
       cities.addObject('Lima');    // ['Chicago', 'Berlin', 'Lima']
      cities.addObject('Berlin');  // ['Chicago', 'Berlin', 'Lima']
      ```
       @method addObject
      @param {*} obj object to add, if not already present
      @return {Ember.Array} receiver
      @public
    */
    addObject: function (obj) {
      var included = undefined;

      if (true) {
        included = this.includes(obj);
      } else {
        included = this.contains(obj);
      }

      if (!included) {
        this.pushObject(obj);
      }

      return this;
    }
  });
})(Em._e[119],Em._e[30],Em._e[31],Em._e[61],Em._e[90],Em._e[118],Em._e[88],Em._e[10]);
(function (exports, _emberMetalDebug, _emberMetalMixin, _emberMetalProperty_get, _emberMetalProperty_set) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  /**
    The `Ember.Freezable` mixin implements some basic methods for marking an
    object as frozen. Once an object is frozen it should be read only. No changes
    may be made the internal state of the object.
  
    ## Enforcement
  
    To fully support freezing in your subclass, you must include this mixin and
    override any method that might alter any property on the object to instead
    raise an exception. You can check the state of an object by checking the
    `isFrozen` property.
  
    Although future versions of JavaScript may support language-level freezing
    object objects, that is not the case today. Even if an object is freezable,
    it is still technically possible to modify the object, even though it could
    break other parts of your application that do not expect a frozen object to
    change. It is, therefore, very important that you always respect the
    `isFrozen` property on all freezable objects.
  
    ## Example Usage
  
    The example below shows a simple object that implement the `Ember.Freezable`
    protocol.
  
    ```javascript
    Contact = Ember.Object.extend(Ember.Freezable, {
      firstName: null,
      lastName: null,
  
      // swaps the names
      swapNames: function() {
        if (this.get('isFrozen')) throw Ember.FROZEN_ERROR;
        var tmp = this.get('firstName');
        this.set('firstName', this.get('lastName'));
        this.set('lastName', tmp);
        return this;
      }
  
    });
  
    c = Contact.create({ firstName: "John", lastName: "Doe" });
    c.swapNames();  // returns c
    c.freeze();
    c.swapNames();  // EXCEPTION
    ```
  
    ## Copying
  
    Usually the `Ember.Freezable` protocol is implemented in cooperation with the
    `Ember.Copyable` protocol, which defines a `frozenCopy()` method that will
    return a frozen object, if the object implements this method as well.
  
    @class Freezable
    @namespace Ember
    @since Ember 0.9
    @deprecated Use `Object.freeze` instead.
    @private
  */
  var Freezable = _emberMetalMixin.Mixin.create({

    init: function () {
      this._super.apply(this, arguments);
    },

    /**
      Set to `true` when the object is frozen. Use this property to detect
      whether your object is frozen or not.
       @property isFrozen
      @type Boolean
      @private
    */
    isFrozen: false,

    /**
      Freezes the object. Once this method has been called the object should
      no longer allow any properties to be edited.
       @method freeze
      @return {Object} receiver
      @private
    */
    freeze: function () {
      if (_emberMetalProperty_get.get(this, 'isFrozen')) {
        return this;
      }

      _emberMetalProperty_set.set(this, 'isFrozen', true);
      return this;
    }

  });

  exports.Freezable = Freezable;
  var FROZEN_ERROR = 'Frozen object cannot be modified.';
  exports.FROZEN_ERROR = FROZEN_ERROR;
})(Em._e[120],Em._e[0],Em._e[61],Em._e[30],Em._e[32]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalMixin, _emberRuntimeMixinsFreezable, _emberMetalError) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  /**
    Implements some standard methods for copying an object. Add this mixin to
    any object you create that can create a copy of itself. This mixin is
    added automatically to the built-in array.
  
    You should generally implement the `copy()` method to return a copy of the
    receiver.
  
    Note that `frozenCopy()` will only work if you also implement
    `Ember.Freezable`.
  
    @class Copyable
    @namespace Ember
    @since Ember 0.9
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create({
    /**
      __Required.__ You must implement this method to apply this mixin.
       Override to return a copy of the receiver. Default implementation raises
      an exception.
       @method copy
      @param {Boolean} deep if `true`, a deep copy of the object should be made
      @return {Object} copy of receiver
      @private
    */
    copy: null,

    /**
      If the object implements `Ember.Freezable`, then this will return a new
      copy if the object is not frozen and the receiver if the object is frozen.
       Raises an exception if you try to call this method on a object that does
      not support freezing.
       You should use this method whenever you want a copy of a freezable object
      since a freezable object can simply return itself without actually
      consuming more memory.
       @method frozenCopy
      @return {Object} copy of receiver or receiver
      @deprecated Use `Object.freeze` instead.
      @private
    */
    frozenCopy: function () {
      if (_emberRuntimeMixinsFreezable.Freezable && _emberRuntimeMixinsFreezable.Freezable.detect(this)) {
        return _emberMetalProperty_get.get(this, 'isFrozen') ? this : this.copy().freeze();
      } else {
        throw new _emberMetalError.default(this + ' does not support freezing');
      }
    }
  });
})(Em._e[121],Em._e[0],Em._e[30],Em._e[61],Em._e[120],Em._e[31]);
(function (exports, _emberMetalDebug, _emberRuntimeSystemObject, _emberRuntimeMixinsCopyable) {
  'use strict';

  exports.default = copy;

  function _copy(obj, deep, seen, copies) {
    var ret = undefined,
        loc = undefined,
        key = undefined;

    // primitive data types are immutable, just return them.
    if (typeof obj !== 'object' || obj === null) {
      return obj;
    }

    // avoid cyclical loops
    if (deep && (loc = seen.indexOf(obj)) >= 0) {
      return copies[loc];
    }

    // IMPORTANT: this specific test will detect a native array only. Any other
    // object will need to implement Copyable.
    if (Array.isArray(obj)) {
      ret = obj.slice();

      if (deep) {
        loc = ret.length;

        while (--loc >= 0) {
          ret[loc] = _copy(ret[loc], deep, seen, copies);
        }
      }
    } else if (_emberRuntimeMixinsCopyable.default && _emberRuntimeMixinsCopyable.default.detect(obj)) {
      ret = obj.copy(deep, seen, copies);
    } else if (obj instanceof Date) {
      ret = new Date(obj.getTime());
    } else {
      ret = {};

      for (key in obj) {
        // support Null prototype
        if (!Object.prototype.hasOwnProperty.call(obj, key)) {
          continue;
        }

        // Prevents browsers that don't respect non-enumerability from
        // copying internal Ember properties
        if (key.substring(0, 2) === '__') {
          continue;
        }

        ret[key] = deep ? _copy(obj[key], deep, seen, copies) : obj[key];
      }
    }

    if (deep) {
      seen.push(obj);
      copies.push(ret);
    }

    return ret;
  }

  /**
    Creates a shallow copy of the passed object. A deep copy of the object is
    returned if the optional `deep` argument is `true`.
  
    If the passed object implements the `Ember.Copyable` interface, then this
    function will delegate to the object's `copy()` method and return the
    result. See `Ember.Copyable` for further details.
  
    For primitive values (which are immutable in JavaScript), the passed object
    is simply returned.
  
    @method copy
    @for Ember
    @param {Object} obj The object to clone
    @param {Boolean} [deep=false] If true, a deep copy of the object is made.
    @return {Object} The copied object
    @public
  */

  function copy(obj, deep) {
    // fast paths
    if ('object' !== typeof obj || obj === null) {
      return obj; // can't copy primitives
    }

    if (_emberRuntimeMixinsCopyable.default && _emberRuntimeMixinsCopyable.default.detect(obj)) {
      return obj.copy(deep);
    }

    return _copy(obj, deep, deep ? [] : null, deep ? [] : null);
  }
})(Em._e[122],Em._e[0],Em._e[77],Em._e[121]);
(function (exports, _emberMetalCore, _emberEnvironment, _emberMetalReplace, _emberMetalProperty_get, _emberMetalMixin, _emberRuntimeMixinsArray, _emberRuntimeMixinsMutable_array, _emberRuntimeMixinsObservable, _emberRuntimeMixinsCopyable, _emberRuntimeMixinsFreezable, _emberRuntimeCopy) {
  /**
  @module ember
  @submodule ember-runtime
  */
  'use strict';

  // Add Ember.Array to Array.prototype. Remove methods with native
  // implementations and supply some more optimized versions of generic methods
  // because they are so common.

  /**
    The NativeArray mixin contains the properties needed to make the native
    Array support Ember.MutableArray and all of its dependent APIs. Unless you
    have `EmberENV.EXTEND_PROTOTYPES` or `EmberENV.EXTEND_PROTOTYPES.Array` set to
    false, this will be applied automatically. Otherwise you can apply the mixin
    at anytime by calling `Ember.NativeArray.apply(Array.prototype)`.
  
    @class NativeArray
    @namespace Ember
    @uses Ember.MutableArray
    @uses Ember.Observable
    @uses Ember.Copyable
    @public
  */
  var NativeArray = _emberMetalMixin.Mixin.create(_emberRuntimeMixinsMutable_array.default, _emberRuntimeMixinsObservable.default, _emberRuntimeMixinsCopyable.default, {

    // because length is a built-in property we need to know to just get the
    // original property.
    get: function (key) {
      if ('number' === typeof key) {
        return this[key];
      } else {
        return this._super(key);
      }
    },

    objectAt: function (idx) {
      return this[idx];
    },

    // primitive for array support.
    replace: function (idx, amt, objects) {
      if (this.isFrozen) {
        throw _emberRuntimeMixinsFreezable.FROZEN_ERROR;
      }

      // if we replaced exactly the same number of items, then pass only the
      // replaced range. Otherwise, pass the full remaining array length
      // since everything has shifted
      var len = objects ? _emberMetalProperty_get.get(objects, 'length') : 0;
      _emberRuntimeMixinsArray.arrayContentWillChange(this, idx, amt, len);

      if (len === 0) {
        this.splice(idx, amt);
      } else {
        _emberMetalReplace.default(this, idx, amt, objects);
      }

      _emberRuntimeMixinsArray.arrayContentDidChange(this, idx, amt, len);
      return this;
    },

    // If you ask for an unknown property, then try to collect the value
    // from member items.
    unknownProperty: function (key, value) {
      var ret = undefined; // = this.reducedProperty(key, value);
      if (value !== undefined && ret === undefined) {
        ret = this[key] = value;
      }
      return ret;
    },

    indexOf: Array.prototype.indexOf,
    lastIndexOf: Array.prototype.lastIndexOf,

    copy: function (deep) {
      if (deep) {
        return this.map(function (item) {
          return _emberRuntimeCopy.default(item, true);
        });
      }

      return this.slice();
    }
  });

  // Remove any methods implemented natively so we don't override them
  var ignore = ['length'];
  NativeArray.keys().forEach(function (methodName) {
    if (Array.prototype[methodName]) {
      ignore.push(methodName);
    }
  });

  exports.NativeArray // TODO: only use default export
   = NativeArray = NativeArray.without.apply(NativeArray, ignore);

  /**
    Creates an `Ember.NativeArray` from an Array like object.
    Does not modify the original object. Ember.A is not needed if
    `EmberENV.EXTEND_PROTOTYPES` is `true` (the default value). However,
    it is recommended that you use Ember.A when creating addons for
    ember or when you can not guarantee that `EmberENV.EXTEND_PROTOTYPES`
    will be `true`.
  
    Example
  
    ```js
    export default Ember.Component.extend({
      tagName: 'ul',
      classNames: ['pagination'],
  
      init() {
        this._super(...arguments);
  
        if (!this.get('content')) {
          this.set('content', Ember.A());
        }
      }
    });
    ```
  
    @method A
    @for Ember
    @return {Ember.NativeArray}
    @public
  */
  var A = undefined;

  if (_emberEnvironment.ENV.EXTEND_PROTOTYPES.Array) {
    NativeArray.apply(Array.prototype);
    exports. // ES6TODO: Setting A onto the object returned by ember-metal/core to avoid circles
    A = A = function (arr) {
      return arr || [];
    };
  } else {
    exports.A = A = function (arr) {
      if (!arr) {
        arr = [];
      }
      return _emberRuntimeMixinsArray.default.detect(arr) ? arr : NativeArray.apply(arr);
    };
  }

  _emberMetalCore.default.A = A;exports.A = A;
  exports.NativeArray = NativeArray;
  exports.default = NativeArray;
})(Em._e[123],Em._e[85],Em._e[4],Em._e[117],Em._e[30],Em._e[61],Em._e[90],Em._e[119],Em._e[76],Em._e[121],Em._e[120],Em._e[122]);
(function (exports, _emberMetalDebug, _emberMetalMixin, _emberRuntimeSystemNative_array) {
  /**
  @module ember
  @submodule ember-views
  */
  'use strict';

  var EMPTY_ARRAY = [];

  /**
    @class ClassNamesSupport
    @namespace Ember
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create({
    concatenatedProperties: ['classNames', 'classNameBindings'],

    init: function () {
      this._super.apply(this, arguments);

      this.classNameBindings = _emberRuntimeSystemNative_array.A(this.classNameBindings.slice());

      this.classNames = _emberRuntimeSystemNative_array.A(this.classNames.slice());
    },

    /**
      Standard CSS class names to apply to the view's outer element. This
      property automatically inherits any class names defined by the view's
      superclasses as well.
       @property classNames
      @type Array
      @default ['ember-view']
      @public
    */
    classNames: ['ember-view'],

    /**
      A list of properties of the view to apply as class names. If the property
      is a string value, the value of that string will be applied as a class
      name.
       ```javascript
      // Applies the 'high' class to the view element
      Ember.View.extend({
        classNameBindings: ['priority'],
        priority: 'high'
      });
      ```
       If the value of the property is a Boolean, the name of that property is
      added as a dasherized class name.
       ```javascript
      // Applies the 'is-urgent' class to the view element
      Ember.View.extend({
        classNameBindings: ['isUrgent'],
        isUrgent: true
      });
      ```
       If you would prefer to use a custom value instead of the dasherized
      property name, you can pass a binding like this:
       ```javascript
      // Applies the 'urgent' class to the view element
      Ember.View.extend({
        classNameBindings: ['isUrgent:urgent'],
        isUrgent: true
      });
      ```
       This list of properties is inherited from the view's superclasses as well.
       @property classNameBindings
      @type Array
      @default []
      @public
    */
    classNameBindings: EMPTY_ARRAY
  });
})(Em._e[124],Em._e[0],Em._e[61],Em._e[123]);
(function (exports, _emberMetalMixin, _emberMetalProperty_get) {
  /**
  @module ember
  @submodule ember-views
  */
  'use strict';

  /**
    @class InstrumentationSupport
    @namespace Ember
    @public
  */
  exports.default = _emberMetalMixin.Mixin.create({
    /**
      Used to identify this view during debugging
       @property instrumentDisplay
      @type String
      @public
    */
    instrumentDisplay: '',

    instrumentName: 'view',

    instrumentDetails: function (hash) {
      hash.template = _emberMetalProperty_get.get(this, 'templateName');
      this._super(hash);
    }
  });
})(Em._e[125],Em._e[61],Em._e[30]);
(function (exports, _emberMetalMixin) {
  /**
   @module ember
   @submodule ember-views
  */

  'use strict';

  /**
   @class AriaRoleSupport
   @namespace Ember
   @private
  */
  exports.default = _emberMetalMixin.Mixin.create({
    /**
     The WAI-ARIA role of the control represented by this view. For example, a
     button may have a role of type 'button', or a pane may have a role of
     type 'alertdialog'. This property is used by assistive software to help
     visually challenged users navigate rich web applications.
      The full list of valid WAI-ARIA roles is available at:
     [http://www.w3.org/TR/wai-aria/roles#roles_categorization](http://www.w3.org/TR/wai-aria/roles#roles_categorization)
      @property ariaRole
     @type String
     @default null
     @public
    */
    ariaRole: null
  });
})(Em._e[126],Em._e[61]);
(function (exports, _emberMetalMixin, _emberMetalProperty_get, _emberMetalRun_loop) {
  /**
   @module ember
   @submodule ember-views
  */
  'use strict';

  function K() {
    return this;
  }

  /**
   @class VisibilitySupport
   @namespace Ember
   @public
  */
  exports.default = _emberMetalMixin.Mixin.create({
    /**
      If `false`, the view will appear hidden in DOM.
       @property isVisible
      @type Boolean
      @default null
      @public
    */
    isVisible: true,

    becameVisible: K,
    becameHidden: K,

    /**
      When the view's `isVisible` property changes, toggle the visibility
      element of the actual DOM element.
       @method _isVisibleDidChange
      @private
    */
    _isVisibleDidChange: _emberMetalMixin.observer('isVisible', function () {
      if (this._isVisible === _emberMetalProperty_get.get(this, 'isVisible')) {
        return;
      }
      _emberMetalRun_loop.default.scheduleOnce('render', this, this._toggleVisibility);
    }),

    _toggleVisibility: function () {
      var $el = this.$();
      var isVisible = _emberMetalProperty_get.get(this, 'isVisible');

      if (this._isVisible === isVisible) {
        return;
      }

      // It's important to keep these in sync, even if we don't yet have
      // an element in the DOM to manipulate:
      this._isVisible = isVisible;

      if (!$el) {
        return;
      }

      $el.toggle(isVisible);

      if (this._isAncestorHidden()) {
        return;
      }

      if (isVisible) {
        this._notifyBecameVisible();
      } else {
        this._notifyBecameHidden();
      }
    },

    _notifyBecameVisible: function () {
      this.trigger('becameVisible');
      var childViews = this.childViews;
      for (var i = 0; i < childViews.length; i++) {
        var view = childViews[i];
        var isVisible = _emberMetalProperty_get.get(view, 'isVisible');
        if (isVisible || isVisible === null) {
          view._notifyBecameVisible();
        }
      }
    },

    _notifyBecameHidden: function () {
      this.trigger('becameHidden');
      var childViews = this.childViews;
      for (var i = 0; i < childViews.length; i++) {
        var view = childViews[i];
        var isVisible = _emberMetalProperty_get.get(view, 'isVisible');
        if (isVisible || isVisible === null) {
          view._notifyBecameHidden();
        }
      }
    },

    _isAncestorHidden: function () {
      var parent = this.parentView;
      while (parent) {
        if (_emberMetalProperty_get.get(parent, 'isVisible') === false) {
          return true;
        }
        parent = parent.parentView;
      }
      return false;
    }
  });
})(Em._e[127],Em._e[61],Em._e[30],Em._e[27]);
(function (exports) {
  /* globals Element */

  /**
  @module ember
  @submodule ember-views
  */

  'use strict';

  exports.isSimpleClick = isSimpleClick;
  exports.getViewClientRects = getViewClientRects;
  exports.getViewBoundingClientRect = getViewBoundingClientRect;
  exports.matches = matches;

  function isSimpleClick(event) {
    var modifier = event.shiftKey || event.metaKey || event.altKey || event.ctrlKey;
    var secondaryClick = event.which > 1; // IE9 may return undefined

    return !modifier && !secondaryClick;
  }

  var STYLE_WARNING = '' + 'Binding style attributes may introduce cross-site scripting vulnerabilities; ' + 'please ensure that values being bound are properly escaped. For more information, ' + 'including how to disable this warning, see ' + 'http://emberjs.com/deprecations/v1.x/#toc_binding-style-attributes.';

  exports.STYLE_WARNING = STYLE_WARNING;
  /**
    @private
    @method getViewRange
    @param {Ember.View} view
  */
  function getViewRange(view) {
    var range = document.createRange();
    range.setStartBefore(view._renderNode.firstNode);
    range.setEndAfter(view._renderNode.lastNode);
    return range;
  }

  /**
    `getViewClientRects` provides information about the position of the border
    box edges of a view relative to the viewport.
  
    It is only intended to be used by development tools like the Ember Inspector
    and may not work on older browsers.
  
    @private
    @method getViewClientRects
    @param {Ember.View} view
  */

  function getViewClientRects(view) {
    var range = getViewRange(view);
    return range.getClientRects();
  }

  /**
    `getViewBoundingClientRect` provides information about the position of the
    bounding border box edges of a view relative to the viewport.
  
    It is only intended to be used by development tools like the Ember Inpsector
    and may not work on older browsers.
  
    @private
    @method getViewBoundingClientRect
    @param {Ember.View} view
  */

  function getViewBoundingClientRect(view) {
    var range = getViewRange(view);
    return range.getBoundingClientRect();
  }

  /**
    Determines if the element matches the specified selector.
  
    @private
    @method matches
    @param {DOMElement} el
    @param {String} selector
  */
  var elMatches = typeof Element !== 'undefined' && (Element.prototype.matches || Element.prototype.matchesSelector || Element.prototype.mozMatchesSelector || Element.prototype.msMatchesSelector || Element.prototype.oMatchesSelector || Element.prototype.webkitMatchesSelector);

  exports.elMatches = elMatches;

  function matches(el, selector) {
    return elMatches.call(el, selector);
  }
})(Em._e[128]);
(function (exports, _emberMetalDebug, _emberMetalRun_loop, _emberMetalUtils, _emberMetalMixin, _emberRuntimeSystemCore_object, _emberMetalSymbol, _emberEnvironment, _emberViewsSystemUtils, _emberViewsSystemJquery) {
  'use strict';

  var _Mixin$create;

  var INIT_WAS_CALLED = _emberMetalSymbol.default('INIT_WAS_CALLED');

  function K() {
    return this;
  }

  exports.default = _emberMetalMixin.Mixin.create((_Mixin$create = {
    concatenatedProperties: ['attributeBindings'],

    // ..........................................................
    // TEMPLATE SUPPORT
    //

    /**
      Return the nearest ancestor that is an instance of the provided
      class or mixin.
       @method nearestOfType
      @param {Class,Mixin} klass Subclass of Ember.View (or Ember.View itself),
             or an instance of Ember.Mixin.
      @return Ember.View
      @deprecated use `yield` and contextual components for composition instead.
      @private
    */
    nearestOfType: function (klass) {
      var view = this.parentView;
      var isOfType = klass instanceof _emberMetalMixin.Mixin ? function (view) {
        return klass.detect(view);
      } : function (view) {
        return klass.detect(view.constructor);
      };

      while (view) {
        if (isOfType(view)) {
          return view;
        }
        view = view.parentView;
      }
    },

    /**
      Return the nearest ancestor that has a given property.
       @method nearestWithProperty
      @param {String} property A property name
      @return Ember.View
      @deprecated use `yield` and contextual components for composition instead.
      @private
    */
    nearestWithProperty: function (property) {
      var view = this.parentView;

      while (view) {
        if (property in view) {
          return view;
        }
        view = view.parentView;
      }
    },

    /**
      Renders the view again. This will work regardless of whether the
      view is already in the DOM or not. If the view is in the DOM, the
      rendering process will be deferred to give bindings a chance
      to synchronize.
       If children were added during the rendering process using `appendChild`,
      `rerender` will remove them, because they will be added again
      if needed by the next `render`.
       In general, if the display of your view changes, you should modify
      the DOM element directly instead of manually calling `rerender`, which can
      be slow.
       @method rerender
      @public
    */
    rerender: function () {
      return this._currentState.rerender(this);
    },

    // ..........................................................
    // ELEMENT SUPPORT
    //

    /**
      Returns the current DOM element for the view.
       @property element
      @type DOMElement
      @public
    */
    element: null,

    /**
      Returns a jQuery object for this view's element. If you pass in a selector
      string, this method will return a jQuery object, using the current element
      as its buffer.
       For example, calling `view.$('li')` will return a jQuery object containing
      all of the `li` elements inside the DOM element of this view.
       @method $
      @param {String} [selector] a jQuery-compatible selector string
      @return {jQuery} the jQuery object for the DOM node
      @public
    */
    $: function (sel) {
      return this._currentState.$(this, sel);
    },

    /**
      Appends the view's element to the specified parent element.
       Note that this method just schedules the view to be appended; the DOM
      element will not be appended to the given element until all bindings have
      finished synchronizing.
       This is not typically a function that you will need to call directly when
      building your application. If you do need to use `appendTo`, be sure that
      the target element you are providing is associated with an `Ember.Application`
      and does not have an ancestor element that is associated with an Ember view.
       @method appendTo
      @param {String|DOMElement|jQuery} A selector, element, HTML string, or jQuery object
      @return {Ember.View} receiver
      @private
    */
    appendTo: function (selector) {
      var env = this._environment || _emberEnvironment.environment;
      var target = undefined;

      if (env.hasDOM) {
        target = typeof selector === 'string' ? document.querySelector(selector) : selector;
      } else {
        target = selector;
      }

      this.renderer.appendTo(this, target);

      return this;
    },

    /**
      Creates a new DOM element, renders the view into it, then returns the
      element.
       By default, the element created and rendered into will be a `BODY` element,
      since this is the default context that views are rendered into when being
      inserted directly into the DOM.
       ```js
      let element = view.renderToElement();
      element.tagName; // => "BODY"
      ```
       You can override the kind of element rendered into and returned by
      specifying an optional tag name as the first argument.
       ```js
      let element = view.renderToElement('table');
      element.tagName; // => "TABLE"
      ```
       This method is useful if you want to render the view into an element that
      is not in the document's body. Instead, a new `body` element, detached from
      the DOM is returned. FastBoot uses this to serialize the rendered view into
      a string for transmission over the network.
       ```js
      app.visit('/').then(function(instance) {
        let element;
        Ember.run(function() {
          element = renderToElement(instance);
        });
         res.send(serialize(element));
      });
      ```
       @method renderToElement
      @param {String} tagName The tag of the element to create and render into. Defaults to "body".
      @return {HTMLBodyElement} element
      @private
    */
    renderToElement: function (tagName) {
      tagName = tagName || 'body';

      var element = this.renderer._dom.createElement(tagName);

      this.renderer.appendTo(this, element);
      return element;
    },

    /**
      Replaces the content of the specified parent element with this view's
      element. If the view does not have an HTML representation yet,
      the element will be generated automatically.
       Note that this method just schedules the view to be appended; the DOM
      element will not be appended to the given element until all bindings have
      finished synchronizing
       @method replaceIn
      @param {String|DOMElement|jQuery} target A selector, element, HTML string, or jQuery object
      @return {Ember.View} received
      @private
    */
    replaceIn: function (selector) {
      var target = _emberViewsSystemJquery.default(selector);

      this.renderer.replaceIn(this, target[0]);

      return this;
    },

    /**
      Appends the view's element to the document body. If the view does
      not have an HTML representation yet
      the element will be generated automatically.
       If your application uses the `rootElement` property, you must append
      the view within that element. Rendering views outside of the `rootElement`
      is not supported.
       Note that this method just schedules the view to be appended; the DOM
      element will not be appended to the document body until all bindings have
      finished synchronizing.
       @method append
      @return {Ember.View} receiver
      @private
    */
    append: function () {
      return this.appendTo(document.body);
    },

    /**
      The HTML `id` of the view's element in the DOM. You can provide this
      value yourself but it must be unique (just as in HTML):
       ```handlebars
        {{my-component elementId="a-really-cool-id"}}
      ```
       If not manually set a default value will be provided by the framework.
       Once rendered an element's `elementId` is considered immutable and you
      should never change it. If you need to compute a dynamic value for the
      `elementId`, you should do this when the component or element is being
      instantiated:
       ```javascript
        export default Ember.Component.extend({
          setElementId: Ember.on('init', function() {
            let index = this.get('index');
            this.set('elementId', 'component-id' + index);
          })
        });
      ```
       @property elementId
      @type String
      @public
    */
    elementId: null,

    /**
      Attempts to discover the element in the parent element. The default
      implementation looks for an element with an ID of `elementId` (or the
      view's guid if `elementId` is null). You can override this method to
      provide your own form of lookup. For example, if you want to discover your
      element using a CSS class name instead of an ID.
       @method findElementInParentElement
      @param {DOMElement} parentElement The parent's DOM element
      @return {DOMElement} The discovered element
      @private
    */
    findElementInParentElement: function (parentElem) {
      var id = '#' + this.elementId;
      return _emberViewsSystemJquery.default(id)[0] || _emberViewsSystemJquery.default(id, parentElem)[0];
    },

    /**
      Called when a view is going to insert an element into the DOM.
       @event willInsertElement
      @public
    */
    willInsertElement: K,

    /**
      Called when the element of the view has been inserted into the DOM
      or after the view was re-rendered. Override this function to do any
      set up that requires an element in the document body.
       When a view has children, didInsertElement will be called on the
      child view(s) first, bubbling upwards through the hierarchy.
       @event didInsertElement
      @public
    */
    didInsertElement: K,

    /**
      Called when the view is about to rerender, but before anything has
      been torn down. This is a good opportunity to tear down any manual
      observers you have installed based on the DOM state
       @event willClearRender
      @public
    */
    willClearRender: K,

    /**
      You must call `destroy` on a view to destroy the view (and all of its
      child views). This will remove the view from any parent node, then make
      sure that the DOM element managed by the view can be released by the
      memory manager.
       @method destroy
      @private
    */
    destroy: function () {
      this._super.apply(this, arguments);
      this._currentState.destroy(this);
    },

    /**
      Called when the element of the view is going to be destroyed. Override
      this function to do any teardown that requires an element, like removing
      event listeners.
       Please note: any property changes made during this event will have no
      effect on object observers.
       @event willDestroyElement
      @public
    */
    willDestroyElement: K,

    /**
      Called when the parentView property has changed.
       @event parentViewDidChange
      @private
    */
    parentViewDidChange: K,

    // ..........................................................
    // STANDARD RENDER PROPERTIES
    //

    /**
      Tag name for the view's outer element. The tag name is only used when an
      element is first created. If you change the `tagName` for an element, you
      must destroy and recreate the view element.
       By default, the render buffer will use a `<div>` tag for views.
       @property tagName
      @type String
      @default null
      @public
    */

    // We leave this null by default so we can tell the difference between
    // the default case and a user-specified tag.
    tagName: null,

    // .......................................................
    // CORE DISPLAY METHODS
    //

    /**
      Setup a view, but do not finish waking it up.
       * configure `childViews`
      * register the view with the global views hash, which is used for event
        dispatch
       @method init
      @private
    */
    init: function () {
      this._super.apply(this, arguments);

      if (!this.elementId && this.tagName !== '') {
        this.elementId = _emberMetalUtils.guidFor(this);
      }

      this.scheduledRevalidation = false;

      this[INIT_WAS_CALLED] = true;

      if (typeof this.didInitAttrs === 'function') {}
    }

  }, _Mixin$create[_emberRuntimeSystemCore_object.POST_INIT] = function () {
    this._super.apply(this, arguments);

    this.renderer.componentInitAttrs(this, this.attrs || {});
  }, _Mixin$create.__defineNonEnumerable = function (property) {
    this[property.name] = property.descriptor.value;
  }, _Mixin$create.revalidate = function () {
    this.renderer.revalidateTopLevelView(this);
    this.scheduledRevalidation = false;
  }, _Mixin$create.scheduleRevalidate = function (node, label, manualRerender) {
    if (node && !this._dispatching && this._env.renderedNodes.has(node)) {
      if (manualRerender) {} else {}
      _emberMetalRun_loop.default.scheduleOnce('render', this, this.revalidate);
      return;
    }

    if (!this.scheduledRevalidation || this._dispatching) {
      this.scheduledRevalidation = true;
      _emberMetalRun_loop.default.scheduleOnce('render', this, this.revalidate);
    }
  }, _Mixin$create.handleEvent = function (eventName, evt) {
    return this._currentState.handleEvent(this, eventName, evt);
  }, _Mixin$create));
})(Em._e[129],Em._e[0],Em._e[27],Em._e[7],Em._e[61],Em._e[73],Em._e[13],Em._e[4],Em._e[128],Em._e[109]);
(function (exports, _emberViewsSystemExt, _emberViewsViewsCore_view, _emberViewsMixinsChild_views_support, _emberViewsMixinsView_state_support, _emberViewsMixinsClass_names_support, _emberViewsMixinsInstrumentation_support, _emberViewsMixinsAria_role_support, _emberViewsMixinsVisibility_support, _emberViewsCompatAttrsProxy, _emberViewsMixinsView_support) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */

  /**
    `Ember.View` is the class in Ember responsible for encapsulating templates of
    HTML content, combining templates with data to render as sections of a page's
    DOM, and registering and responding to user-initiated events.
  
    ## HTML Tag
  
    The default HTML tag name used for a view's DOM representation is `div`. This
    can be customized by setting the `tagName` property. The following view
    class:
  
    ```javascript
    ParagraphView = Ember.View.extend({
      tagName: 'em'
    });
    ```
  
    Would result in instances with the following HTML:
  
    ```html
    <em id="ember1" class="ember-view"></em>
    ```
  
    ## HTML `class` Attribute
  
    The HTML `class` attribute of a view's tag can be set by providing a
    `classNames` property that is set to an array of strings:
  
    ```javascript
    MyView = Ember.View.extend({
      classNames: ['my-class', 'my-other-class']
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class"></div>
    ```
  
    `class` attribute values can also be set by providing a `classNameBindings`
    property set to an array of properties names for the view. The return value
    of these properties will be added as part of the value for the view's `class`
    attribute. These properties can be computed properties:
  
    ```javascript
    MyView = Ember.View.extend({
      classNameBindings: ['propertyA', 'propertyB'],
      propertyA: 'from-a',
      propertyB: Ember.computed(function() {
        if (someLogic) { return 'from-b'; }
      })
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view from-a from-b"></div>
    ```
  
    If the value of a class name binding returns a boolean the property name
    itself will be used as the class name if the property is true. The class name
    will not be added if the value is `false` or `undefined`.
  
    ```javascript
    MyView = Ember.View.extend({
      classNameBindings: ['hovered'],
      hovered: true
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view hovered"></div>
    ```
  
    When using boolean class name bindings you can supply a string value other
    than the property name for use as the `class` HTML attribute by appending the
    preferred value after a ":" character when defining the binding:
  
    ```javascript
    MyView = Ember.View.extend({
      classNameBindings: ['awesome:so-very-cool'],
      awesome: true
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view so-very-cool"></div>
    ```
  
    Boolean value class name bindings whose property names are in a
    camelCase-style format will be converted to a dasherized format:
  
    ```javascript
    MyView = Ember.View.extend({
      classNameBindings: ['isUrgent'],
      isUrgent: true
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view is-urgent"></div>
    ```
  
    Class name bindings can also refer to object values that are found by
    traversing a path relative to the view itself:
  
    ```javascript
    MyView = Ember.View.extend({
      classNameBindings: ['messages.empty']
      messages: Ember.Object.create({
        empty: true
      })
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view empty"></div>
    ```
  
    If you want to add a class name for a property which evaluates to true and
    and a different class name if it evaluates to false, you can pass a binding
    like this:
  
    ```javascript
    // Applies 'enabled' class when isEnabled is true and 'disabled' when isEnabled is false
    Ember.View.extend({
      classNameBindings: ['isEnabled:enabled:disabled']
      isEnabled: true
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view enabled"></div>
    ```
  
    When isEnabled is `false`, the resulting HTML representation looks like
    this:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    This syntax offers the convenience to add a class if a property is `false`:
  
    ```javascript
    // Applies no class when isEnabled is true and class 'disabled' when isEnabled is false
    Ember.View.extend({
      classNameBindings: ['isEnabled::disabled']
      isEnabled: true
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view"></div>
    ```
  
    When the `isEnabled` property on the view is set to `false`, it will result
    in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    Updates to the value of a class name binding will result in automatic
    update of the  HTML `class` attribute in the view's rendered HTML
    representation. If the value becomes `false` or `undefined` the class name
    will be removed.
  
    Both `classNames` and `classNameBindings` are concatenated properties. See
    [Ember.Object](/api/classes/Ember.Object.html) documentation for more
    information about concatenated properties.
  
    ## HTML Attributes
  
    The HTML attribute section of a view's tag can be set by providing an
    `attributeBindings` property set to an array of property names on the view.
    The return value of these properties will be used as the value of the view's
    HTML associated attribute:
  
    ```javascript
    AnchorView = Ember.View.extend({
      tagName: 'a',
      attributeBindings: ['href'],
      href: 'http://google.com'
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    One property can be mapped on to another by placing a ":" between
    the source property and the destination property:
  
    ```javascript
    AnchorView = Ember.View.extend({
      tagName: 'a',
      attributeBindings: ['url:href'],
      url: 'http://google.com'
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    Namespaced attributes (e.g. `xlink:href`) are supported, but have to be
    mapped, since `:` is not a valid character for properties in Javascript:
  
    ```javascript
    UseView = Ember.View.extend({
      tagName: 'use',
      attributeBindings: ['xlinkHref:xlink:href'],
      xlinkHref: '#triangle'
    });
    ```
    Will result in view instances with an HTML representation of:
  
    ```html
    <use xlink:href="#triangle"></use>
    ```
  
    If the return value of an `attributeBindings` monitored property is a boolean
    the property's value will be set as a coerced string:
  
    ```javascript
    MyTextInput = Ember.View.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
      disabled: false
    });
    ```
  
    Will result in a view instance with an HTML representation of:
  
    ```html
    <input id="ember1" class="ember-view" disabled="false" />
    ```
  
    `attributeBindings` can refer to computed properties:
  
    ```javascript
    MyTextInput = Ember.View.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
      disabled: Ember.computed(function() {
        if (someLogic) {
          return true;
        } else {
          return false;
        }
      })
    });
    ```
  
    To prevent setting an attribute altogether, use `null` or `undefined` as the
    return value of the `attributeBindings` monitored property:
  
    ```javascript
    MyTextInput = Ember.View.extend({
      tagName: 'form',
      attributeBindings: ['novalidate'],
      novalidate: null
    });
    ```
  
    Updates to the property of an attribute binding will result in automatic
    update of the  HTML attribute in the view's rendered HTML representation.
  
    `attributeBindings` is a concatenated property. See [Ember.Object](/api/classes/Ember.Object.html)
    documentation for more information about concatenated properties.
  
    ## Layouts
  
    Views can have a secondary template that wraps their main template. Like
    primary templates, layouts can be any function that  accepts an optional
    context parameter and returns a string of HTML that will be inserted inside
    view's tag. Views whose HTML element is self closing (e.g. `<input />`)
    cannot have a layout and this property will be ignored.
  
    Most typically in Ember a layout will be a compiled template.
  
    A view's layout can be set directly with the `layout` property or reference
    an existing template by name with the `layoutName` property.
  
    A template used as a layout must contain a single use of the
    `{{yield}}` helper. The HTML contents of a view's rendered `template` will be
    inserted at this location:
  
    ```javascript
    AViewWithLayout = Ember.View.extend({
      layout: Ember.HTMLBars.compile("<div class='my-decorative-class'>{{yield}}</div>"),
      template: Ember.HTMLBars.compile("I got wrapped")
    });
    ```
  
    Will result in view instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view">
      <div class="my-decorative-class">
        I got wrapped
      </div>
    </div>
    ```
  
    See [Ember.Templates.helpers.yield](/api/classes/Ember.Templates.helpers.html#method_yield)
    for more information.
  
    ## Responding to Browser Events
  
    Views can respond to user-initiated events in one of three ways: method
    implementation, through an event manager, and through `{{action}}` helper use
    in their template or layout.
  
    ### Method Implementation
  
    Views can respond to user-initiated events by implementing a method that
    matches the event name. A `jQuery.Event` object will be passed as the
    argument to this method.
  
    ```javascript
    AView = Ember.View.extend({
      click: function(event) {
        // will be called when an instance's
        // rendered element is clicked
      }
    });
    ```
  
    ### Event Managers
  
    Views can define an object as their `eventManager` property. This object can
    then implement methods that match the desired event names. Matching events
    that occur on the view's rendered HTML or the rendered HTML of any of its DOM
    descendants will trigger this method. A `jQuery.Event` object will be passed
    as the first argument to the method and an  `Ember.View` object as the
    second. The `Ember.View` will be the view whose rendered HTML was interacted
    with. This may be the view with the `eventManager` property or one of its
    descendant views.
  
    ```javascript
    AView = Ember.View.extend({
      eventManager: Ember.Object.create({
        doubleClick: function(event, view) {
          // will be called when an instance's
          // rendered element or any rendering
          // of this view's descendant
          // elements is clicked
        }
      })
    });
    ```
  
    An event defined for an event manager takes precedence over events of the
    same name handled through methods on the view.
  
    ```javascript
    AView = Ember.View.extend({
      mouseEnter: function(event) {
        // will never trigger.
      },
      eventManager: Ember.Object.create({
        mouseEnter: function(event, view) {
          // takes precedence over AView#mouseEnter
        }
      })
    });
    ```
  
    Similarly a view's event manager will take precedence for events of any views
    rendered as a descendant. A method name that matches an event name will not
    be called if the view instance was rendered inside the HTML representation of
    a view that has an `eventManager` property defined that handles events of the
    name. Events not handled by the event manager will still trigger method calls
    on the descendant.
  
    ```javascript
    var App = Ember.Application.create();
    App.OuterView = Ember.View.extend({
      template: Ember.HTMLBars.compile("outer {{#view 'inner'}}inner{{/view}} outer"),
      eventManager: Ember.Object.create({
        mouseEnter: function(event, view) {
          // view might be instance of either
          // OuterView or InnerView depending on
          // where on the page the user interaction occurred
        }
      })
    });
  
    App.InnerView = Ember.View.extend({
      click: function(event) {
        // will be called if rendered inside
        // an OuterView because OuterView's
        // eventManager doesn't handle click events
      },
      mouseEnter: function(event) {
        // will never be called if rendered inside
        // an OuterView.
      }
    });
    ```
  
    ### `{{action}}` Helper
  
    See [Ember.Templates.helpers.action](/api/classes/Ember.Templates.helpers.html#method_action).
  
    ### Event Names
  
    All of the event handling approaches described above respond to the same set
    of events. The names of the built-in events are listed below. (The hash of
    built-in events exists in `Ember.EventDispatcher`.) Additional, custom events
    can be registered by using `Ember.Application.customEvents`.
  
    Touch events:
  
    * `touchStart`
    * `touchMove`
    * `touchEnd`
    * `touchCancel`
  
    Keyboard events
  
    * `keyDown`
    * `keyUp`
    * `keyPress`
  
    Mouse events
  
    * `mouseDown`
    * `mouseUp`
    * `contextMenu`
    * `click`
    * `doubleClick`
    * `mouseMove`
    * `focusIn`
    * `focusOut`
    * `mouseEnter`
    * `mouseLeave`
  
    Form events:
  
    * `submit`
    * `change`
    * `focusIn`
    * `focusOut`
    * `input`
  
    HTML5 drag and drop events:
  
    * `dragStart`
    * `drag`
    * `dragEnter`
    * `dragLeave`
    * `dragOver`
    * `dragEnd`
    * `drop`
  
    @class View
    @namespace Ember
    @extends Ember.CoreView
    @deprecated See http://emberjs.com/deprecations/v1.x/#toc_ember-view
    @uses Ember.ViewSupport
    @uses Ember.ViewChildViewsSupport
    @uses Ember.ClassNamesSupport
    @uses Ember.AttributeBindingsSupport
    @uses Ember.InstrumentationSupport
    @uses Ember.VisibilitySupport
    @uses Ember.AriaRoleSupport
    @public
  */
  // jscs:disable validateIndentation
  var View = _emberViewsViewsCore_view.default.extend(_emberViewsMixinsChild_views_support.default, _emberViewsMixinsView_state_support.default, _emberViewsMixinsClass_names_support.default, _emberViewsMixinsInstrumentation_support.default, _emberViewsMixinsVisibility_support.default, _emberViewsCompatAttrsProxy.default, _emberViewsMixinsAria_role_support.default, _emberViewsMixinsView_support.default);

  // jscs:enable validateIndentation

  /*
    Describe how the specified actions should behave in the various
    states that a view can exist in. Possible states:
  
    * preRender: when a view is first instantiated, and after its
      element was destroyed, it is in the preRender state
    * inBuffer: once a view has been rendered, but before it has
      been inserted into the DOM, it is in the inBuffer state
    * hasElement: the DOM representation of the view is created,
      and is ready to be inserted
    * inDOM: once a view has been inserted into the DOM it is in
      the inDOM state. A view spends the vast majority of its
      existence in this state.
    * destroyed: once a view has been destroyed (using the destroy
      method), it is in this state. No further actions can be invoked
      on a destroyed view.
  */

  // in the destroyed state, everything is illegal

  // before rendering has begun, all legal manipulations are noops.

  // inside the buffer, legal manipulations are done on the buffer

  // once the view has been inserted into the DOM, legal manipulations
  // are done on the DOM element.

  exports.default = View;
  exports.ViewChildViewsSupport = _emberViewsMixinsChild_views_support.default;
  exports.ViewStateSupport = _emberViewsMixinsView_state_support.default;
  exports.ClassNamesSupport = _emberViewsMixinsClass_names_support.default;
})(Em._e[130],Em._e[105],Em._e[114],Em._e[115],Em._e[116],Em._e[124],Em._e[125],Em._e[126],Em._e[127],Em._e[67],Em._e[129]);
(function (exports, _emberMetalDebug, _emberMetalMixin, _emberEnvironment, _emberRuntimeMixinsTarget_action_support, _emberViewsMixinsAction_support, _emberViewsViewsView, _emberMetalComputed, _containerOwner, _emberMetalSymbol) {
  'use strict';

  var HAS_BLOCK = _emberMetalSymbol.default('HAS_BLOCK');

  exports.HAS_BLOCK = HAS_BLOCK;
  /**
  @module ember
  @submodule ember-views
  */

  /**
    An `Ember.Component` is a view that is completely
    isolated. Properties accessed in its templates go
    to the view object and actions are targeted at
    the view object. There is no access to the
    surrounding context or outer controller; all
    contextual information must be passed in.
  
    The easiest way to create an `Ember.Component` is via
    a template. If you name a template
    `components/my-foo`, you will be able to use
    `{{my-foo}}` in other templates, which will make
    an instance of the isolated component.
  
    ```handlebars
    {{app-profile person=currentUser}}
    ```
  
    ```handlebars
    <!-- app-profile template -->
    <h1>{{person.title}}</h1>
    <img src={{person.avatar}}>
    <p class='signature'>{{person.signature}}</p>
    ```
  
    You can use `yield` inside a template to
    include the **contents** of any block attached to
    the component. The block will be executed in the
    context of the surrounding context or outer controller:
  
    ```handlebars
    {{#app-profile person=currentUser}}
      <p>Admin mode</p>
      {{! Executed in the controller's context. }}
    {{/app-profile}}
    ```
  
    ```handlebars
    <!-- app-profile template -->
    <h1>{{person.title}}</h1>
    {{! Executed in the component's context. }}
    {{yield}} {{! block contents }}
    ```
  
    If you want to customize the component, in order to
    handle events or actions, you implement a subclass
    of `Ember.Component` named after the name of the
    component. Note that `Component` needs to be appended to the name of
    your subclass like `AppProfileComponent`.
  
    For example, you could implement the action
    `hello` for the `app-profile` component:
  
    ```javascript
    App.AppProfileComponent = Ember.Component.extend({
      actions: {
        hello: function(name) {
          console.log("Hello", name);
        }
      }
    });
    ```
  
    And then use it in the component's template:
  
    ```handlebars
    <!-- app-profile template -->
  
    <h1>{{person.title}}</h1>
    {{yield}} <!-- block contents -->
  
    <button {{action 'hello' person.name}}>
      Say Hello to {{person.name}}
    </button>
    ```
  
    Components must have a `-` in their name to avoid
    conflicts with built-in controls that wrap HTML
    elements. This is consistent with the same
    requirement in web components.
  
    @class Component
    @namespace Ember
    @extends Ember.View
    @uses Ember.ViewTargetActionSupport
    @public
  */
  var Component = _emberViewsViewsView.default.extend(_emberRuntimeMixinsTarget_action_support.default, _emberViewsMixinsAction_support.default, {
    isComponent: true,

    instrumentName: 'component',
    instrumentDisplay: _emberMetalComputed.computed(function () {
      if (this._debugContainerKey) {
        return '{{' + this._debugContainerKey.split(':')[1] + '}}';
      }
    }),

    init: function () {
      this._super.apply(this, arguments);

      // If a `defaultLayout` was specified move it to the `layout` prop.
      // `layout` is no longer a CP, so this just ensures that the `defaultLayout`
      // logic is supported with a deprecation
      if (this.defaultLayout && !this.layout) {

        this.layout = this.defaultLayout;
      }

      // If in a tagless component, assert that no event handlers are defined
    },

    // indicate that the assertion should be triggered
    template: null,
    layoutName: null,
    layout: null,

    /**
      Normally, Ember's component model is "write-only". The component takes a
      bunch of attributes that it got passed in, and uses them to render its
      template.
       One nice thing about this model is that if you try to set a value to the
      same thing as last time, Ember (through HTMLBars) will avoid doing any
      work on the DOM.
       This is not just a performance optimization. If an attribute has not
      changed, it is important not to clobber the element's "hidden state".
      For example, if you set an input's `value` to the same value as before,
      it will clobber selection state and cursor position. In other words,
      setting an attribute is not **always** idempotent.
       This method provides a way to read an element's attribute and also
      update the last value Ember knows about at the same time. This makes
      setting an attribute idempotent.
       In particular, what this means is that if you get an `<input>` element's
      `value` attribute and then re-render the template with the same value,
      it will avoid clobbering the cursor and selection position.
       Since most attribute sets are idempotent in the browser, you typically
      can get away with reading attributes using jQuery, but the most reliable
      way to do so is through this method.
       @method readDOMAttr
      @param {String} name the name of the attribute
      @return String
      @public
    */
    readDOMAttr: function (name) {
      var attr = this._renderNode.childNodes.filter(function (node) {
        return node.attrName === name;
      })[0];
      if (!attr) {
        return null;
      }
      return attr.getContent();
    },

    /**
      Returns true when the component was invoked with a block template.
       Example (`hasBlock` will be `false`):
       ```hbs
      {{! templates/application.hbs }}
       {{foo-bar}}
       {{! templates/components/foo-bar.hbs }}
      {{#if hasBlock}}
        This will not be printed, because no block was provided
      {{/if}}
      ```
       Example (`hasBlock` will be `true`):
       ```hbs
      {{! templates/application.hbs }}
       {{#foo-bar}}
        Hi!
      {{/foo-bar}}
       {{! templates/components/foo-bar.hbs }}
      {{#if hasBlock}}
        This will be printed because a block was provided
        {{yield}}
      {{/if}}
      ```
       This helper accepts an argument with the name of the block we want to check the presence of.
      This is useful for checking for the presence of the optional inverse block in components.
       ```hbs
      {{! templates/application.hbs }}
       {{#foo-bar}}
        Hi!
      {{else}}
        What's up?
      {{/foo-bar}}
       {{! templates/components/foo-bar.hbs }}
      {{yield}}
      {{#if (hasBlock "inverse")}}
        {{yield to="inverse"}}
      {{else}}
        How are you?
      {{/if}}
      ```
       @public
      @property hasBlock
      @param {String} [blockName="default"] The name of the block to check presence of.
      @returns Boolean
      @since 1.13.0
    */

    /**
      Returns true when the component was invoked with a block parameter
      supplied.
       Example (`hasBlockParams` will be `false`):
       ```hbs
      {{! templates/application.hbs }}
       {{#foo-bar}}
        No block parameter.
      {{/foo-bar}}
       {{! templates/components/foo-bar.hbs }}
      {{#if hasBlockParams}}
        This will not be printed, because no block was provided
        {{yield this}}
      {{/if}}
      ```
       Example (`hasBlockParams` will be `true`):
       ```hbs
      {{! templates/application.hbs }}
       {{#foo-bar as |foo|}}
        Hi!
      {{/foo-bar}}
       {{! templates/components/foo-bar.hbs }}
      {{#if hasBlockParams}}
        This will be printed because a block was provided
        {{yield this}}
      {{/if}}
      ```
      @public
      @property hasBlockParams
      @returns Boolean
      @since 1.13.0
    */

    /**
      Enables components to take a list of parameters as arguments.
       For example, a component that takes two parameters with the names
      `name` and `age`:
       ```javascript
      let MyComponent = Ember.Component.extend;
      MyComponent.reopenClass({
        positionalParams: ['name', 'age']
      });
      ```
       It can then be invoked like this:
       ```hbs
      {{my-component "John" 38}}
      ```
       The parameters can be referred to just like named parameters:
       ```hbs
      Name: {{attrs.name}}, Age: {{attrs.age}}.
      ```
       Using a string instead of an array allows for an arbitrary number of
      parameters:
       ```javascript
      let MyComponent = Ember.Component.extend;
      MyComponent.reopenClass({
        positionalParams: 'names'
      });
      ```
       It can then be invoked like this:
       ```hbs
      {{my-component "John" "Michael" "Scott"}}
      ```
       The parameters can then be referred to by enumerating over the list:
       ```hbs
      {{#each attrs.names as |name|}}{{name}}{{/each}}
      ```
       @static
      @public
      @property positionalParams
      @since 1.13.0
    */

    /**
      Called when the attributes passed into the component have been updated.
      Called both during the initial render of a container and during a rerender.
      Can be used in place of an observer; code placed here will be executed
      every time any attribute updates.
       @method didReceiveAttrs
      @public
      @since 1.13.0
    */
    didReceiveAttrs: function () {},

    /**
      Called when the attributes passed into the component have been updated.
      Called both during the initial render of a container and during a rerender.
      Can be used in place of an observer; code placed here will be executed
      every time any attribute updates.
       @event didReceiveAttrs
      @public
      @since 1.13.0
    */

    /**
      Called after a component has been rendered, both on initial render and
      in subsequent rerenders.
       @method didRender
      @public
      @since 1.13.0
    */
    didRender: function () {},

    /**
      Called after a component has been rendered, both on initial render and
      in subsequent rerenders.
       @event didRender
      @public
      @since 1.13.0
    */

    /**
      Called before a component has been rendered, both on initial render and
      in subsequent rerenders.
       @method willRender
      @public
      @since 1.13.0
    */
    willRender: function () {},

    /**
      Called before a component has been rendered, both on initial render and
      in subsequent rerenders.
       @event willRender
      @public
      @since 1.13.0
    */

    /**
      Called when the attributes passed into the component have been changed.
      Called only during a rerender, not during an initial render.
       @method didUpdateAttrs
      @public
      @since 1.13.0
    */
    didUpdateAttrs: function () {},

    /**
      Called when the attributes passed into the component have been changed.
      Called only during a rerender, not during an initial render.
       @event didUpdateAttrs
      @public
      @since 1.13.0
    */

    /**
      Called when the component is about to update and rerender itself.
      Called only during a rerender, not during an initial render.
       @method willUpdate
      @public
      @since 1.13.0
    */
    willUpdate: function () {},

    /**
      Called when the component is about to update and rerender itself.
      Called only during a rerender, not during an initial render.
       @event willUpdate
      @public
      @since 1.13.0
    */

    /**
      Called when the component has updated and rerendered itself.
      Called only during a rerender, not during an initial render.
       @method didUpdate
      @public
      @since 1.13.0
    */
    didUpdate: function () {}

    /**
      Called when the component has updated and rerendered itself.
      Called only during a rerender, not during an initial render.
       @event didUpdate
      @public
      @since 1.13.0
    */
  });

  Component[_emberMetalMixin.NAME_KEY] = 'Ember.Component';

  Component.reopenClass({
    isComponentFactory: true,
    positionalParams: []
  });

  exports.default = Component;
})(Em._e[131],Em._e[0],Em._e[61],Em._e[4],Em._e[103],Em._e[104],Em._e[130],Em._e[59],Em._e[70],Em._e[13]);
(function (exports, _emberMetalDebug, _emberHtmlbarsSystemBuildComponentTemplate, _emberHtmlbarsHooksGetCellOrValue, _emberMetalProperty_get, _emberViewsCompatAttrsProxy, _emberHtmlbarsSystemInstrumentationSupport, _emberHtmlbarsComponent, _emberHtmlbarsUtilsExtractPositionalParams, _containerOwner, _emberHtmlbarsHooksGetValue) {
  'use strict';

  exports.default = ComponentNodeManager;
  exports.createComponent = createComponent;
  exports.takeLegacySnapshot = takeLegacySnapshot;

  function ComponentNodeManager(component, scope, renderNode, attrs, block, expectElement) {
    this.component = component;
    this.scope = scope;
    this.renderNode = renderNode;
    this.attrs = attrs;
    this.block = block;
    this.expectElement = expectElement;
  }

  ComponentNodeManager.create = function ComponentNodeManager_create(renderNode, env, options) {
    var _createOptions;

    var tagName = options.tagName;
    var params = options.params;
    var _options$attrs = options.attrs;
    var attrs = _options$attrs === undefined ? {} : _options$attrs;
    var parentView = options.parentView;
    var parentScope = options.parentScope;
    var component = options.component;
    var layout = options.layout;
    var templates = options.templates;

    component = component || _emberHtmlbarsComponent.default;

    var createOptions = (_createOptions = {
      parentView: parentView
    }, _createOptions[_emberHtmlbarsComponent.HAS_BLOCK] = !!templates.default, _createOptions);

    configureTagName(attrs, tagName, component, createOptions);

    // Map passed attributes (e.g. <my-component id="foo">) to component
    // properties ({ id: "foo" }).
    configureCreateOptions(attrs, createOptions);

    // This allows the component to target actions sent via `sendAction` correctly.
    createOptions._targetObject = _emberHtmlbarsHooksGetValue.default(parentScope.getSelf());

    _emberHtmlbarsUtilsExtractPositionalParams.default(renderNode, component, params, attrs);

    // Instantiate the component
    component = createComponent(component, createOptions, renderNode, env, attrs);
    var layoutName = _emberMetalProperty_get.get(component, 'layoutName');

    // If the component specifies its layout via the `layout` property
    // instead of using the template looked up in the container, get it
    // now that we have the component instance.
    if (!layout) {
      layout = _emberMetalProperty_get.get(component, 'layout');
    }

    if (!layout && layoutName) {
      var owner = _containerOwner.getOwner(component);
      layout = owner.lookup('template:' + layoutName);
    }

    var results = _emberHtmlbarsSystemBuildComponentTemplate.default({ layout: layout, component: component }, attrs, { templates: templates, scope: parentScope });

    return new ComponentNodeManager(component, parentScope, renderNode, attrs, results.block, results.createdElement);
  };

  function configureTagName(attrs, tagName, component, createOptions) {
    if (attrs.tagName) {
      createOptions.tagName = _emberHtmlbarsHooksGetValue.default(attrs.tagName);
    }
  }

  function configureCreateOptions(attrs, createOptions) {
    // Some attrs are special and need to be set as properties on the component
    // instance. Make sure we use getValue() to get them from `attrs` since
    // they are still streams.
    if (attrs.id) {
      createOptions.elementId = _emberHtmlbarsHooksGetValue.default(attrs.id);
    }
  }

  ComponentNodeManager.prototype.render = function ComponentNodeManager_render(_env, visitor) {
    var component = this.component;

    return _emberHtmlbarsSystemInstrumentationSupport.instrument(component, function ComponentNodeManager_render_instrument() {
      var meta = this.block && this.block.template.meta;
      var env = _env.childWithView(component, meta);

      env.renderer.componentWillRender(component);
      env.renderedViews.push(component.elementId);

      if (this.block) {
        this.block.invoke(env, [], undefined, this.renderNode, this.scope, visitor);
      }

      var element = undefined;
      if (this.expectElement) {
        element = this.renderNode.firstNode;
      }

      // In environments like FastBoot, disable any hooks that would cause the component
      // to access the DOM directly.
      if (env.destinedForDOM) {
        env.renderer.didCreateElement(component, element);
        env.renderer.willInsertElement(component, element);

        env.lifecycleHooks.push({ type: 'didInsertElement', view: component });
      }
    }, this);
  };

  ComponentNodeManager.prototype.rerender = function ComponentNodeManager_rerender(_env, attrs, visitor) {
    var component = this.component;

    return _emberHtmlbarsSystemInstrumentationSupport.instrument(component, function ComponentNodeManager_rerender_instrument() {
      var env = _env.childWithView(component);

      var snapshot = takeSnapshot(attrs);

      if (component._renderNode.shouldReceiveAttrs) {
        if (component._propagateAttrsToThis) {
          component._propagateAttrsToThis(takeLegacySnapshot(attrs));
        }

        env.renderer.componentUpdateAttrs(component, snapshot);
        component._renderNode.shouldReceiveAttrs = false;
      }

      // Notify component that it has become dirty and is about to change.
      env.renderer.componentWillUpdate(component, snapshot);
      env.renderer.componentWillRender(component);

      env.renderedViews.push(component.elementId);

      if (this.block) {
        this.block.invoke(env, [], undefined, this.renderNode, this.scope, visitor);
      }

      env.lifecycleHooks.push({ type: 'didUpdate', view: component });

      return env;
    }, this);
  };

  ComponentNodeManager.prototype.destroy = function ComponentNodeManager_destroy() {
    var component = this.component;

    // Clear component's render node. Normally this gets cleared
    // during view destruction, but in this case we're re-assigning the
    // node to a different view and it will get cleaned up automatically.
    component._renderNode = null;
    component.destroy();
  };

  function createComponent(_component, props, renderNode, env) {
    var attrs = arguments.length <= 4 || arguments[4] === undefined ? {} : arguments[4];

    snapshotAndUpdateTarget(attrs, props);

    _containerOwner.setOwner(props, env.owner);
    props.renderer = props.parentView ? props.parentView.renderer : env.owner.lookup('renderer:-dom');

    var component = _component.create(props);

    if (props.parentView) {
      props.parentView.appendChild(component);
    }

    component._renderNode = renderNode;
    renderNode.emberView = component;
    renderNode.buildChildEnv = buildChildEnv;
    return component;
  }

  function takeSnapshot(attrs) {
    var hash = {};

    for (var prop in attrs) {
      hash[prop] = _emberHtmlbarsHooksGetCellOrValue.default(attrs[prop]);
    }

    return hash;
  }

  function takeLegacySnapshot(attrs) {
    var hash = {};

    for (var prop in attrs) {
      hash[prop] = _emberHtmlbarsHooksGetValue.default(attrs[prop]);
    }

    return hash;
  }

  function snapshotAndUpdateTarget(rawAttrs, target) {
    var attrs = {};

    for (var prop in rawAttrs) {
      var value = _emberHtmlbarsHooksGetCellOrValue.default(rawAttrs[prop]);
      attrs[prop] = value;

      // when `attrs` is an actual value being set in the
      // attrs hash (`{{foo-bar attrs="blah"}}`) we cannot
      // set `"blah"` to the root of the target because
      // that would replace all attrs with `attrs.attrs`
      if (prop === 'attrs') {
        continue;
      }

      if (value && value[_emberViewsCompatAttrsProxy.MUTABLE_CELL]) {
        value = value.value;
      }

      target[prop] = value;
    }

    return target.attrs = attrs;
  }

  function buildChildEnv(state, env) {
    return env.childWithView(this.emberView);
  }
})(Em._e[132],Em._e[0],Em._e[69],Em._e[101],Em._e[30],Em._e[67],Em._e[102],Em._e[131],Em._e[93],Em._e[70],Em._e[68]);
(function (exports, _emberMetalAssign, _emberMetalDebug, _emberHtmlbarsSystemBuildComponentTemplate, _emberMetalProperty_get, _emberMetalSet_properties, _emberViewsCompatAttrsProxy, _emberHtmlbarsHooksGetCellOrValue, _emberHtmlbarsSystemInstrumentationSupport, _emberHtmlbarsNodeManagersComponentNodeManager, _containerOwner, _emberHtmlbarsHooksGetValue) {
  'use strict';

  exports.default = ViewNodeManager;
  exports.createOrUpdateComponent = createOrUpdateComponent;

  function ViewNodeManager(component, scope, renderNode, block, expectElement) {
    this.component = component;
    this.scope = scope;
    this.renderNode = renderNode;
    this.block = block;
    this.expectElement = expectElement;
  }

  ViewNodeManager.create = function ViewNodeManager_create(renderNode, env, attrs, found, parentView, path, contentScope, contentTemplate) {

    var component = undefined;
    var componentInfo = { layout: found.layout };

    if (found.component) {
      var options = { parentView: parentView };

      if (attrs && attrs.id) {
        options.elementId = _emberHtmlbarsHooksGetValue.default(attrs.id);
      }
      if (attrs && attrs.tagName) {
        options.tagName = _emberHtmlbarsHooksGetValue.default(attrs.tagName);
      }

      component = componentInfo.component = createOrUpdateComponent(found.component, options, found.createOptions, renderNode, env, attrs);

      var layout = _emberMetalProperty_get.get(component, 'layout');
      if (layout) {
        componentInfo.layout = layout;
      } else {
        componentInfo.layout = getTemplate(component) || componentInfo.layout;
      }

      renderNode.emberView = component;
    }

    var results = _emberHtmlbarsSystemBuildComponentTemplate.default(componentInfo, attrs, {
      templates: { default: contentTemplate },
      scope: contentScope,
      self: found.self
    });

    return new ViewNodeManager(component, contentScope, renderNode, results.block, results.createdElement);
  };

  ViewNodeManager.prototype.render = function ViewNodeManager_render(env, attrs, visitor) {
    var component = this.component;

    return _emberHtmlbarsSystemInstrumentationSupport.instrument(component, function ViewNodeManager_render_instrument() {
      var newEnv = env;
      if (component) {
        newEnv = env.childWithView(component);
      } else {
        var meta = this.block && this.block.template.meta;

        newEnv = env.childWithMeta(meta);
      }

      if (component) {
        env.renderer.willRender(component);
        env.renderedViews.push(component.elementId);
      }

      if (this.block) {
        this.block.invoke(newEnv, [], undefined, this.renderNode, this.scope, visitor);
      }

      if (component) {
        var element = this.expectElement && this.renderNode.firstNode;

        // In environments like FastBoot, disable any hooks that would cause the component
        // to access the DOM directly.
        if (env.destinedForDOM) {
          env.renderer.didCreateElement(component, element);
          env.renderer.willInsertElement(component, element);
          env.lifecycleHooks.push({ type: 'didInsertElement', view: component });
        }
      }
    }, this);
  };

  ViewNodeManager.prototype.rerender = function ViewNodeManager_rerender(env, attrs, visitor) {
    var component = this.component;

    return _emberHtmlbarsSystemInstrumentationSupport.instrument(component, function ViewNodeManager_rerender_instrument() {
      var newEnv = env;
      if (component) {
        newEnv = env.childWithView(component);

        var snapshot = takeSnapshot(attrs);

        // Notify component that it has become dirty and is about to change.
        env.renderer.willUpdate(component, snapshot);

        if (component._renderNode.shouldReceiveAttrs) {
          if (component._propagateAttrsToThis) {
            component._propagateAttrsToThis(_emberHtmlbarsNodeManagersComponentNodeManager.takeLegacySnapshot(attrs));
          }

          env.renderer.componentUpdateAttrs(component, snapshot);
          component._renderNode.shouldReceiveAttrs = false;
        }

        env.renderer.willRender(component);

        env.renderedViews.push(component.elementId);
      } else {
        var meta = this.block && this.block.template.meta;

        newEnv = env.childWithMeta(meta);
      }

      if (this.block) {
        this.block.invoke(newEnv, [], undefined, this.renderNode, this.scope, visitor);
      }

      return newEnv;
    }, this);
  };

  ViewNodeManager.prototype.destroy = function ViewNodeManager_destroy() {
    if (this.component) {
      this.component.destroy();
      this.component = null;
    }
  };

  function getTemplate(componentOrView) {
    if (!componentOrView.isComponent) {
      return _emberMetalProperty_get.get(componentOrView, 'template');
    }

    return null;
  }

  function createOrUpdateComponent(component, options, createOptions, renderNode, env) {
    var attrs = arguments.length <= 5 || arguments[5] === undefined ? {} : arguments[5];

    var snapshot = takeSnapshot(attrs);
    var props = _emberMetalAssign.default({}, options);

    if (!props.ownerView && options.parentView) {
      props.ownerView = options.parentView.ownerView;
    }

    props.attrs = snapshot;
    if (component.create) {
      if (createOptions) {
        _emberMetalAssign.default(props, createOptions);
      }

      mergeBindings(props, snapshot);

      var owner = env.owner;

      _containerOwner.setOwner(props, owner);
      props.renderer = options.parentView ? options.parentView.renderer : owner && owner.lookup('renderer:-dom');

      component = component.create(props);
    } else {
      env.renderer.componentUpdateAttrs(component, snapshot);
      _emberMetalSet_properties.default(component, props);

      if (component._propagateAttrsToThis) {
        component._propagateAttrsToThis(_emberHtmlbarsNodeManagersComponentNodeManager.takeLegacySnapshot(attrs));
      }
    }

    if (options.parentView) {
      options.parentView.appendChild(component);
    }

    component._renderNode = renderNode;

    renderNode.emberView = component;
    return component;
  }

  function takeSnapshot(attrs) {
    var hash = {};

    for (var prop in attrs) {
      hash[prop] = _emberHtmlbarsHooksGetCellOrValue.default(attrs[prop]);
    }

    return hash;
  }

  function mergeBindings(target, attrs) {
    for (var prop in attrs) {
      if (!attrs.hasOwnProperty(prop)) {
        continue;
      }
      // when `attrs` is an actual value being set in the
      // attrs hash (`{{foo-bar attrs="blah"}}`) we cannot
      // set `"blah"` to the root of the target because
      // that would replace all attrs with `attrs.attrs`
      if (prop === 'attrs') {
        continue;
      }
      var value = attrs[prop];

      if (value && value[_emberViewsCompatAttrsProxy.MUTABLE_CELL]) {
        target[prop] = value.value;
      } else {
        target[prop] = value;
      }
    }

    return target;
  }
})(Em._e[133],Em._e[8],Em._e[0],Em._e[69],Em._e[30],Em._e[33],Em._e[67],Em._e[101],Em._e[102],Em._e[132],Em._e[70],Em._e[68]);
(function (exports, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = concat;

  var ConcatStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (array, separator) {
      this.array = array;
      this.separator = separator;

      // Used by angle bracket components to detect an attribute was provided
      // as a string literal.
      this.isConcat = true;
    },

    label: function () {
      var labels = _emberHtmlbarsStreamsUtils.labelsFor(this.array);
      return 'concat([' + labels.join(', ') + ']; separator=' + _emberHtmlbarsStreamsUtils.inspect(this.separator) + ')';
    },

    compute: function () {
      return concat(_emberHtmlbarsStreamsUtils.readArray(this.array), this.separator);
    }
  });

  /*
   Join an array, with any streams replaced by their current values.
  
   @private
   @for Ember.stream
   @function concat
   @param {Array} array An array containing zero or more stream objects and
                        zero or more non-stream objects.
   @param {String} separator String to be used to join array elements.
   @return {String} String with array elements concatenated and joined by the
                    provided separator, and any stream array members having been
                    replaced by the current value of the stream.
   */

  function concat(array, separator) {
    // TODO: Create subclass ConcatStream < Stream. Defer
    // subscribing to streams until the value() is called.
    var hasStream = _emberHtmlbarsStreamsUtils.scanArray(array);
    if (hasStream) {
      var stream = new ConcatStream(array, separator);

      for (var i = 0; i < array.length; i++) {
        _emberHtmlbarsStreamsUtils.addDependency(stream, array[i]);
      }

      return stream;
    } else {
      return array.join(separator);
    }
  }
})(Em._e[134],Em._e[56],Em._e[66]);
(function (exports, _emberHtmlbarsStreamsConcat) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = concat;

  function concat(env, parts) {
    return _emberHtmlbarsStreamsConcat.default(parts, '');
  }
})(Em._e[135],Em._e[134]);
(function (exports, _emberHtmlbarsStreamsProxyStream, _emberMetalEmpty_object) {
  'use strict';

  exports.default = createFreshScope;
  exports.createChildScope = createChildScope;

  /*
    Ember's implementation of HTMLBars creates an enriched scope.
  
    * self: same as HTMLBars, this field represents the dynamic lookup
      of root keys that are not special keywords or block arguments.
    * blocks: same as HTMLBars, a bundle of named blocks the layout
      can yield to.
    * component: indicates that the scope is the layout of a component,
      which is used to trigger lifecycle hooks for the component when
      one of the streams in its layout fires.
    * attrs: a map of key-value attributes sent in by the invoker of
      a template, and available in the component's layout.
    * locals: a map of locals, produced by block params (`as |a b|`)
    * localPresent: a map of available locals to avoid expensive
      `hasOwnProperty` checks.
  
    The `self` field has two special meanings:
  
    * If `self` is a view (`isView`), the actual HTMLBars `self` becomes
      the view's `context`. This is legacy semantics; components always
      use the component itself as the `this`.
    * If `self` is a view, two special locals are created: `view` and
      `controller`. These locals are legacy semantics.
  
    **IMPORTANT**: There are two places in Ember where the ambient
    controller is looked up. Both of those places use the presence
    of `scope.locals.view` to indicate that the controller lookup
    should be dynamic off of the ambient view. If `scope.locals.view`
    does not exist, the code assumes that it is inside of a top-level
    template (without a view) and uses the `self` itself as the
    controller. This means that if you remove `scope.locals.view`
    (perhaps because we are finally ready to shed the view keyword),
    there may be unexpected consequences on controller semantics.
    If this happens to you, I hope you find this comment. - YK & TD
  
    In practice, this means that with the exceptions of top-level
    view-less templates and the legacy `controller=foo` semantics,
    the controller hierarchy is managed dynamically by looking at
    the current view's `controller`.
  */

  function Scope(parent) {
    this._self = undefined;
    this._blocks = undefined;
    this._component = undefined;
    this._view = undefined;
    this._attrs = undefined;
    this._locals = undefined;
    this._localPresent = undefined;
    this.overrideController = undefined;
    this.parent = parent;
  }

  var proto = Scope.prototype;

  proto.getSelf = function () {
    return this._self || this.parent.getSelf();
  };

  proto.bindSelf = function (self) {
    this._self = self;
  };

  proto.updateSelf = function (self, key) {
    var existing = this._self;

    if (existing) {
      existing.setSource(self);
    } else {
      this._self = new _emberHtmlbarsStreamsProxyStream.default(self, key);
    }
  };

  proto.getBlock = function (name) {
    if (!this._blocks) {
      return this.parent.getBlock(name);
    }
    return this._blocks[name] || this.parent.getBlock(name);
  };

  proto.hasBlock = function (name) {
    if (!this._blocks) {
      return this.parent.hasBlock(name);
    }
    return !!(this._blocks[name] || this.parent.hasBlock(name));
  };

  proto.bindBlock = function (name, block) {
    if (!this._blocks) {
      this._blocks = new _emberMetalEmpty_object.default();
    }
    this._blocks[name] = block;
  };

  proto.getComponent = function () {
    return this._component || this.parent.getComponent();
  };

  proto.bindComponent = function (component) {
    this._component = component;
  };

  proto.getView = function () {
    return this._view || this.parent.getView();
  };

  proto.bindView = function (view) {
    this._view = view;
  };

  proto.getAttrs = function () {
    return this._attrs || this.parent.getAttrs();
  };

  proto.bindAttrs = function (attrs) {
    this._attrs = attrs;
  };

  proto.hasLocal = function (name) {
    if (!this._localPresent) {
      return this.parent.hasLocal(name);
    }
    return this._localPresent[name] || this.parent.hasLocal(name);
  };

  proto.hasOwnLocal = function (name) {
    return this._localPresent && this._localPresent[name];
  };

  proto.getLocal = function (name) {
    if (!this._localPresent) {
      return this.parent.getLocal(name);
    }
    return this._localPresent[name] ? this._locals[name] : this.parent.getLocal(name);
  };

  proto.bindLocal = function (name, value) {
    if (!this._localPresent) {
      this._localPresent = new _emberMetalEmpty_object.default();
      this._locals = new _emberMetalEmpty_object.default();
    }

    this._localPresent[name] = true;
    this._locals[name] = value;
  };

  var EMPTY = {
    _self: undefined,
    _blocks: undefined,
    _component: undefined,
    _view: undefined,
    _attrs: undefined,
    _locals: undefined,
    _localPresent: undefined,
    overrideController: undefined,

    getSelf: function () {
      return null;
    },
    bindSelf: function (self) {
      return null;
    },
    updateSelf: function (self, key) {
      return null;
    },
    getBlock: function (name) {
      return null;
    },
    bindBlock: function (name, block) {
      return null;
    },
    hasBlock: function (name) {
      return false;
    },
    getComponent: function () {
      return null;
    },
    bindComponent: function () {
      return null;
    },
    getView: function () {
      return null;
    },
    bindView: function (view) {
      return null;
    },
    getAttrs: function () {
      return null;
    },
    bindAttrs: function (attrs) {
      return null;
    },
    hasLocal: function (name) {
      return false;
    },
    hasOwnLocal: function (name) {
      return false;
    },
    getLocal: function (name) {
      return null;
    },
    bindLocal: function (name, value) {
      return null;
    }
  };

  function createFreshScope() {
    return new Scope(EMPTY);
  }

  function createChildScope(parent) {
    return new Scope(parent);
  }
})(Em._e[136],Em._e[78],Em._e[12]);
(function (exports, _emberHtmlbarsStreamsProxyStream) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = bindShadowScope;

  function bindShadowScope(env, parentScope, shadowScope, options) {
    if (!options) {
      return;
    }

    var view = options.view;
    if (view && !view.isComponent) {
      shadowScope.bindLocal('view', newStream(view, 'view'));

      if (view.isView) {
        shadowScope.bindSelf(newStream(shadowScope.getLocal('view').getKey('context'), ''));
      }
    }

    shadowScope.bindView(view);

    if (view && options.attrs) {
      shadowScope.bindComponent(view);
    }

    if ('attrs' in options) {
      shadowScope.bindAttrs(options.attrs);
    }

    return shadowScope;
  }

  function newStream(newValue, key) {
    return new _emberHtmlbarsStreamsProxyStream.default(newValue, key);
  }
})(Em._e[137],Em._e[78]);
(function (exports, _emberHtmlbarsStreamsProxyStream) {
  /**
  @module ember
  @submodule ember-htmlbars
  */
  'use strict';

  exports.default = bindSelf;

  function bindSelf(env, scope, self) {
    var selfStream = newStream(self, '');
    scope.bindSelf(selfStream);
  }

  function newStream(newValue, key) {
    return new _emberHtmlbarsStreamsProxyStream.default(newValue, key);
  }
})(Em._e[138],Em._e[78]);
(function (exports) {
  "use strict";

  exports.default = bindScope;

  function bindScope(env, scope) {}
})(Em._e[139]);
(function (exports, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsProxyStream) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = bindLocal;

  function bindLocal(env, scope, key, value) {
    // TODO: What is the cause of these cases?
    if (scope.hasOwnLocal(key)) {
      var existing = scope.getLocal(key);
      if (existing !== value) {
        existing.setSource(value);
      }
    } else {
      var newValue = _emberHtmlbarsStreamsStream.wrap(value, _emberHtmlbarsStreamsProxyStream.default, key);
      scope.bindLocal(key, newValue);
    }
  }
})(Em._e[140],Em._e[56],Em._e[78]);
(function (exports) {
  'use strict';

  exports.default = bindBlock;

  function bindBlock(env, scope, block) {
    var name = arguments.length <= 3 || arguments[3] === undefined ? 'default' : arguments[3];

    scope.bindBlock(name, block);
  }
})(Em._e[141]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = updateSelf;

  function updateSelf(env, scope, _self) {
    var self = _self;

    if (self && self.hasBoundController) {
      var _self2 = self;
      var controller = _self2.controller;

      self = self.self;

      scope.updateLocal('controller', controller || self);
    }

    if (self && self.isView) {
      scope.updateLocal('view', self);
      scope.updateSelf(_emberMetalProperty_get.get(self, 'context'), '');
      return;
    }

    scope.updateSelf(self);
  }
})(Em._e[142],Em._e[0],Em._e[30]);
(function (exports) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = getRoot;

  function getRoot(scope, key) {
    if (key === 'this') {
      return [scope.getSelf()];
    } else if (key === 'hasBlock') {
      return [!!scope.hasBlock('default')];
    } else if (key === 'hasBlockParams') {
      var block = scope.getBlock('default');
      return [!!block && !!block.arity];
    } else if (scope.hasLocal(key)) {
      return [scope.getLocal(key)];
    } else {
      return [getKey(scope, key)];
    }
  }

  function getKey(scope, key) {
    if (key === 'attrs') {
      var _attrs = scope.getAttrs();
      if (_attrs) {
        return _attrs;
      }
    }

    var self = scope.getSelf() || scope.getLocal('view');

    if (self) {
      return self.getKey(key);
    }

    var attrs = scope.getAttrs();
    if (attrs && key in attrs) {
      // TODO: attrs
      // deprecate("You accessed the `" + key + "` attribute directly. Please use `attrs." + key + "` instead.");
      return attrs[key];
    }
  }
})(Em._e[143]);
(function (exports, _emberHtmlbarsStreamsUtils) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = getChild;

  function getChild(parent, key) {
    if (_emberHtmlbarsStreamsUtils.isStream(parent)) {
      return parent.getKey(key);
    }

    // This should only happen when we are looking at an `attrs` hash.
    // That might change if it is possible to pass object literals
    // through the templating system.
    return parent[key];
  }
})(Em._e[144],Em._e[66]);
(function (exports) {
  "use strict";

  exports.default = getBlock;

  function getBlock(scope, key) {
    return scope.getBlock(key);
  }
})(Em._e[145]);
(function (exports) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  "use strict";

  exports.default = cleanupRenderNode;

  function cleanupRenderNode(renderNode) {
    if (renderNode.cleanup) {
      renderNode.cleanup();
    }
  }
})(Em._e[146]);
(function (exports) {
  /**
  @module ember
  @submodule ember-htmlbars
  */
  "use strict";

  exports.default = destroyRenderNode;

  function destroyRenderNode(renderNode) {
    var view = renderNode.emberView;
    if (view) {
      view.renderer.remove(view, true);
    }

    var streamUnsubscribers = renderNode.streamUnsubscribers;
    if (streamUnsubscribers) {
      for (var i = 0; i < streamUnsubscribers.length; i++) {
        streamUnsubscribers[i]();
      }
    }
  }
})(Em._e[147]);
(function (exports) {
  "use strict";

  exports.default = didRenderNode;

  function didRenderNode(morph, env) {
    env.renderedNodes.add(morph);
  }
})(Em._e[148]);
(function (exports) {
  "use strict";

  exports.default = willCleanupTree;

  function willCleanupTree(env) {
    var view = env.view;

    // When we go to clean up the render node and all of its children, we may
    // encounter views/components associated with those nodes along the way. In
    // those cases, we need to sever the link between the
    // existing view hierarchy and those views.
    //
    // However, we do *not* need to remove the child views of child views, since
    // severing the connection to their parent effectively severs them from the
    // view graph.
    //
    // For example, imagine the following view graph:
    //
    //    A
    //   / \
    //  B  C
    //    / \
    //   D  E
    //
    // If we are cleaning up the node for view C, we need to remove that view
    // from A's child views. However, we do not need to remove D and E from C's
    // child views, since removing C transitively removes D and E as well.
    //
    // To accomplish this, we track the nearest view to this render node on the
    // owner view, the root-most view in the graph (A in the example above). If
    // we detect a view that is a direct child of that view, we remove it from
    // the `childViews` array. Other parent/child view relationships are
    // untouched.  This view is then cleared once cleanup is complete in
    // `didCleanupTree`.
    view.ownerView._destroyingSubtreeForView = view;
  }
})(Em._e[149]);
(function (exports) {
  "use strict";

  exports.default = didCleanupTree;

  function didCleanupTree(env) {
    // Once we have finsihed cleaning up the render node and sub-nodes, reset
    // state tracking which view those render nodes belonged to.
    env.view.ownerView._destroyingSubtreeForView = null;
  }
})(Em._e[150]);
(function (exports, _emberHtmlbarsSystemLookupHelper, _emberHtmlbarsKeywordsClosureComponent, _emberHtmlbarsStreamsUtils) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = isComponent;

  function hasComponentOrTemplate(owner, path, options) {
    return owner.hasRegistration('component:' + path, options) || owner.hasRegistration('template:components/' + path, options);
  }

  /*
   Given a path name, returns whether or not a component with that
   name was found in the container.
  */

  function isComponent(env, scope, path) {
    var owner = env.owner;
    if (!owner) {
      return false;
    }
    if (typeof path === 'string') {
      if (_emberHtmlbarsSystemLookupHelper.CONTAINS_DOT_CACHE.get(path)) {
        var stream = env.hooks.get(env, scope, path);
        if (_emberHtmlbarsStreamsUtils.isStream(stream)) {
          var cell = stream.value();
          if (_emberHtmlbarsKeywordsClosureComponent.isComponentCell(cell)) {
            return true;
          }
        }
      }
      if (!_emberHtmlbarsSystemLookupHelper.CONTAINS_DASH_CACHE.get(path)) {
        return false;
      }

      if (hasComponentOrTemplate(owner, path)) {
        return true; // global component found
      } else {
          var moduleName = env.meta && env.meta.moduleName;

          if (!moduleName) {
            // Without a source moduleName, we can not perform local lookups.
            return false;
          }

          var options = { source: 'template:' + moduleName };

          return hasComponentOrTemplate(owner, path, options);
        }
    }
  }
})(Em._e[151],Em._e[79],Em._e[95],Em._e[66]);
(function (exports, _emberHtmlbarsUtilsIsComponent) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = classify;

  function classify(env, scope, path) {
    if (_emberHtmlbarsUtilsIsComponent.default(env, scope, path)) {
      return 'component';
    }

    return null;
  }
})(Em._e[152],Em._e[151]);
(function (exports, _emberMetalDebug, _emberHtmlbarsNodeManagersComponentNodeManager, _emberViewsUtilsLookupComponent, _emberMetalAssign, _emberMetalEmpty_object, _emberHtmlbarsSystemLookupHelper, _emberHtmlbarsUtilsExtractPositionalParams, _emberHtmlbarsKeywordsClosureComponent) {
  'use strict';

  exports.default = componentHook;

  function componentHook(renderNode, env, scope, _tagName, params, _attrs, templates, visitor) {
    var state = renderNode.getState();

    var tagName = _tagName;
    var attrs = _attrs;

    if (_emberHtmlbarsSystemLookupHelper.CONTAINS_DOT_CACHE.get(tagName)) {
      var stream = env.hooks.get(env, scope, tagName);
      var componentCell = stream.value();
      if (_emberHtmlbarsKeywordsClosureComponent.isComponentCell(componentCell)) {
        tagName = componentCell[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_PATH];

        /*
         * Processing positional params before merging into a hash must be done
         * here to avoid problems with rest positional parameters rendered using
         * the dot notation.
         *
         * Closure components (for the contextual component feature) do not
         * actually keep the positional params, but process them at each level.
         * Therefore, when rendering a closure component with the component
         * helper we process the parameters and attributes and then merge those
         * on top of the closure component attributes.
         *
         */
        var newAttrs = _emberMetalAssign.default(new _emberMetalEmpty_object.default(), attrs);
        _emberHtmlbarsKeywordsClosureComponent.processPositionalParamsFromCell(componentCell, params, newAttrs);
        attrs = _emberHtmlbarsKeywordsClosureComponent.mergeInNewHash(componentCell[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_HASH], newAttrs, componentCell[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_POSITIONAL_PARAMS], params);
        params = [];
      }
    }

    // Determine if this is an initial render or a re-render.
    if (state.manager) {
      var sm = state.manager;
      var templateMeta = null;
      if (sm.block) {
        templateMeta = sm.block.template.meta;
      } else if (sm.scope && sm.scope._view && sm.scope._view.template) {
        templateMeta = sm.scope._view.template.meta;
      }
      env.meta.moduleName = templateMeta && templateMeta.moduleName || env.meta && env.meta.moduleName;
      _emberHtmlbarsUtilsExtractPositionalParams.default(renderNode, sm.component.constructor, params, attrs, false);
      state.manager.rerender(env, attrs, visitor);
      return;
    }

    var parentView = env.view;
    var options = {};
    var moduleName = env.meta && env.meta.moduleName;
    if (moduleName) {
      options.source = 'template:' + moduleName;
    }

    var _lookupComponent = _emberViewsUtilsLookupComponent.default(env.owner, tagName, options);

    var component = _lookupComponent.component;
    var layout = _lookupComponent.layout;

    var manager = _emberHtmlbarsNodeManagersComponentNodeManager.default.create(renderNode, env, {
      tagName: tagName,
      params: params,
      attrs: attrs,
      parentView: parentView,
      templates: templates,
      component: component,
      layout: layout,
      parentScope: scope
    });

    state.manager = manager;
    manager.render(env, visitor);
  }
})(Em._e[153],Em._e[0],Em._e[132],Em._e[94],Em._e[8],Em._e[12],Em._e[79],Em._e[93],Em._e[95]);
(function (exports, _emberHtmlbarsSystemLookupHelper) {
  'use strict';

  exports.default = lookupHelperHook;

  function lookupHelperHook(env, scope, helperName) {
    return _emberHtmlbarsSystemLookupHelper.default(helperName, scope.getSelf(), env);
  }
})(Em._e[154],Em._e[79]);
(function (exports, _emberHtmlbarsSystemLookupHelper) {
  'use strict';

  exports.default = hasHelperHook;

  function hasHelperHook(env, scope, helperName) {
    if (env.helpers[helperName]) {
      return true;
    }

    var owner = env.owner;
    if (_emberHtmlbarsSystemLookupHelper.validateLazyHelperName(helperName, owner, env.hooks.keywords)) {
      var registrationName = 'helper:' + helperName;
      if (owner.hasRegistration(registrationName)) {
        return true;
      }

      var options = {};
      var moduleName = env.meta && env.meta.moduleName;
      if (moduleName) {
        options.source = 'template:' + moduleName;
      }

      if (owner.hasRegistration(registrationName, options)) {
        return true;
      }
    }

    return false;
  }
})(Em._e[155],Em._e[79]);
(function (exports, _emberHtmlbarsSystemInvokeHelper, _emberHtmlbarsUtilsSubscribe) {
  'use strict';

  exports.default = invokeHelper;

  function invokeHelper(morph, env, scope, visitor, params, hash, helper, templates, context) {
    var helperStream = _emberHtmlbarsSystemInvokeHelper.buildHelperStream(helper, params, hash, templates, env, scope);

    // Ember.Helper helpers are pure values, thus linkable.
    if (helperStream.linkable) {
      if (morph) {
        // When processing an inline expression, the params and hash have already
        // been linked. Thus, HTMLBars will not link the returned helperStream.
        // We subscribe the morph to the helperStream here, and also subscribe
        // the helperStream to any params.
        var addedDependency = false;
        for (var i = 0; i < params.length; i++) {
          addedDependency = true;
          helperStream.addDependency(params[i]);
        }
        for (var key in hash) {
          addedDependency = true;
          helperStream.addDependency(hash[key]);
        }
        if (addedDependency) {
          _emberHtmlbarsUtilsSubscribe.default(morph, env, scope, helperStream);
        }
      }

      return { link: true, value: helperStream };
    }

    // Built-in helpers are not linkable. They must run on every rerender.
    return { value: helperStream.value() };
  }
})(Em._e[156],Em._e[83],Em._e[84]);
(function (exports, _emberHtmlbarsSystemLookupHelper, _htmlbarsRuntimeHooks, _emberHtmlbarsSystemInvokeHelper) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = emberElement;

  function emberElement(morph, env, scope, path, params, hash, visitor) {
    if (_htmlbarsRuntimeHooks.handleRedirect(morph, env, scope, path, params, hash, null, null, visitor)) {
      return;
    }

    var result = undefined;
    var helper = _emberHtmlbarsSystemLookupHelper.findHelper(path, scope.getSelf(), env);
    if (helper) {
      var helperStream = _emberHtmlbarsSystemInvokeHelper.buildHelperStream(helper, params, hash, { element: morph.element }, env, scope, path);
      result = helperStream.value();
    } else {
      result = env.hooks.get(env, scope, path);
    }

    env.hooks.getValue(result);
  }
})(Em._e[157],Em._e[79],Em._e[46],Em._e[83]);
(function (exports, _emberMetalEmpty_object) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
   @private
   @property helpers
  */
  'use strict';

  exports.registerHelper = registerHelper;

  var helpers = new _emberMetalEmpty_object.default();

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    @private
    @method _registerHelper
    @for Ember.HTMLBars
    @param {String} name
    @param {Object|Function} helperFunc The helper function to add.
  */

  function registerHelper(name, helperFunc) {
    helpers[name] = helperFunc;
  }

  exports.default = helpers;
})(Em._e[158],Em._e[12]);
(function (exports, _htmlbarsRuntime) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.registerKeyword = registerKeyword;

  /**
   @private
   @property helpers
  */
  var keywords = Object.create(_htmlbarsRuntime.hooks.keywords);

  /**
  @module ember
  @submodule ember-htmlbars
  */

  /**
    @private
    @method _registerHelper
    @for Ember.HTMLBars
    @param {String} name
    @param {Object|Function} keyword The keyword to add.
  */

  function registerKeyword(name, keyword) {
    keywords[name] = keyword;
  }

  exports.default = keywords;
})(Em._e[159],Em._e[47]);
(function (exports) {
  /* jshint scripturl:true */

  'use strict';

  exports.sanitizeAttributeValue = sanitizeAttributeValue;
  var badProtocols = {
    'javascript:': true,
    'vbscript:': true
  };

  var badTags = {
    'A': true,
    'BODY': true,
    'LINK': true,
    'IMG': true,
    'IFRAME': true,
    'BASE': true,
    'FORM': true
  };

  var badTagsForDataURI = {
    'EMBED': true
  };

  var badAttributes = {
    'href': true,
    'src': true,
    'background': true,
    'action': true
  };

  exports.badAttributes = badAttributes;
  var badAttributesForDataURI = {
    'src': true
  };

  function sanitizeAttributeValue(dom, element, attribute, value) {
    var tagName;

    if (!element) {
      tagName = null;
    } else {
      tagName = element.tagName.toUpperCase();
    }

    if (value && value.toHTML) {
      return value.toHTML();
    }

    if ((tagName === null || badTags[tagName]) && badAttributes[attribute]) {
      var protocol = dom.protocolForURL(value);
      if (badProtocols[protocol] === true) {
        return 'unsafe:' + value;
      }
    }

    if (badTagsForDataURI[tagName] && badAttributesForDataURI[attribute]) {
      return 'unsafe:' + value;
    }

    return value;
  }
})(Em._e[160]);
(function (exports) {
  'use strict';

  exports.isAttrRemovalValue = isAttrRemovalValue;
  exports.normalizeProperty = normalizeProperty;

  function isAttrRemovalValue(value) {
    return value === null || value === undefined;
  }

  /*
   *
   * @method normalizeProperty
   * @param element {HTMLElement}
   * @param slotName {String}
   * @returns {Object} { name, type }
   */

  function normalizeProperty(element, slotName) {
    var type, normalized;

    if (slotName in element) {
      normalized = slotName;
      type = 'prop';
    } else {
      var lower = slotName.toLowerCase();
      if (lower in element) {
        type = 'prop';
        normalized = lower;
      } else {
        type = 'attr';
        normalized = slotName;
      }
    }

    if (type === 'prop' && (normalized.toLowerCase() === 'style' || preferAttr(element.tagName, normalized))) {
      type = 'attr';
    }

    return { normalized: normalized, type: type };
  }

  // properties that MUST be set as attributes, due to:
  // * browser bug
  // * strange spec outlier
  var ATTR_OVERRIDES = {

    // phantomjs < 2.0 lets you set it as a prop but won't reflect it
    // back to the attribute. button.getAttribute('type') === null
    BUTTON: { type: true, form: true },

    INPUT: {
      // TODO: remove when IE8 is droped
      // Some versions of IE (IE8) throw an exception when setting
      // `input.list = 'somestring'`:
      // https://github.com/emberjs/ember.js/issues/10908
      // https://github.com/emberjs/ember.js/issues/11364
      list: true,
      // Some version of IE (like IE9) actually throw an exception
      // if you set input.type = 'something-unknown'
      type: true,
      form: true,
      // Chrome 46.0.2464.0: 'autocorrect' in document.createElement('input') === false
      // Safari 8.0.7: 'autocorrect' in document.createElement('input') === false
      // Mobile Safari (iOS 8.4 simulator): 'autocorrect' in document.createElement('input') === true
      autocorrect: true
    },

    // element.form is actually a legitimate readOnly property, that is to be
    // mutated, but must be mutated by setAttribute...
    SELECT: { form: true },
    OPTION: { form: true },
    TEXTAREA: { form: true },
    LABEL: { form: true },
    FIELDSET: { form: true },
    LEGEND: { form: true },
    OBJECT: { form: true }
  };

  function preferAttr(tagName, propName) {
    var tag = ATTR_OVERRIDES[tagName.toUpperCase()];
    return tag && tag[propName.toLowerCase()] || false;
  }
})(Em._e[161]);
(function (exports) {
  /* global XMLSerializer:false */
  'use strict';

  var svgHTMLIntegrationPoints = { foreignObject: 1, desc: 1, title: 1 };
  exports.svgHTMLIntegrationPoints = svgHTMLIntegrationPoints;
  var svgNamespace = 'http://www.w3.org/2000/svg';

  exports.svgNamespace = svgNamespace;
  var doc = typeof document === 'undefined' ? false : document;

  // Safari does not like using innerHTML on SVG HTML integration
  // points (desc/title/foreignObject).
  var needsIntegrationPointFix = doc && (function (document) {
    if (document.createElementNS === undefined) {
      return;
    }
    // In FF title will not accept innerHTML.
    var testEl = document.createElementNS(svgNamespace, 'title');
    testEl.innerHTML = "<div></div>";
    return testEl.childNodes.length === 0 || testEl.childNodes[0].nodeType !== 1;
  })(doc);

  // Internet Explorer prior to 9 does not allow setting innerHTML if the first element
  // is a "zero-scope" element. This problem can be worked around by making
  // the first node an invisible text node. We, like Modernizr, use &shy;
  var needsShy = doc && (function (document) {
    var testEl = document.createElement('div');
    testEl.innerHTML = "<div></div>";
    testEl.firstChild.innerHTML = "<script><\/script>";
    return testEl.firstChild.innerHTML === '';
  })(doc);

  // IE 8 (and likely earlier) likes to move whitespace preceeding
  // a script tag to appear after it. This means that we can
  // accidentally remove whitespace when updating a morph.
  var movesWhitespace = doc && (function (document) {
    var testEl = document.createElement('div');
    testEl.innerHTML = "Test: <script type='text/x-placeholder'><\/script>Value";
    return testEl.childNodes[0].nodeValue === 'Test:' && testEl.childNodes[2].nodeValue === ' Value';
  })(doc);

  var tagNamesRequiringInnerHTMLFix = doc && (function (document) {
    var tagNamesRequiringInnerHTMLFix;
    // IE 9 and earlier don't allow us to set innerHTML on col, colgroup, frameset,
    // html, style, table, tbody, tfoot, thead, title, tr. Detect this and add
    // them to an initial list of corrected tags.
    //
    // Here we are only dealing with the ones which can have child nodes.
    //
    var tableNeedsInnerHTMLFix;
    var tableInnerHTMLTestElement = document.createElement('table');
    try {
      tableInnerHTMLTestElement.innerHTML = '<tbody></tbody>';
    } catch (e) {} finally {
      tableNeedsInnerHTMLFix = tableInnerHTMLTestElement.childNodes.length === 0;
    }
    if (tableNeedsInnerHTMLFix) {
      tagNamesRequiringInnerHTMLFix = {
        colgroup: ['table'],
        table: [],
        tbody: ['table'],
        tfoot: ['table'],
        thead: ['table'],
        tr: ['table', 'tbody']
      };
    }

    // IE 8 doesn't allow setting innerHTML on a select tag. Detect this and
    // add it to the list of corrected tags.
    //
    var selectInnerHTMLTestElement = document.createElement('select');
    selectInnerHTMLTestElement.innerHTML = '<option></option>';
    if (!selectInnerHTMLTestElement.childNodes[0]) {
      tagNamesRequiringInnerHTMLFix = tagNamesRequiringInnerHTMLFix || {};
      tagNamesRequiringInnerHTMLFix.select = [];
    }
    return tagNamesRequiringInnerHTMLFix;
  })(doc);

  function scriptSafeInnerHTML(element, html) {
    // without a leading text node, IE will drop a leading script tag.
    html = '&shy;' + html;

    element.innerHTML = html;

    var nodes = element.childNodes;

    // Look for &shy; to remove it.
    var shyElement = nodes[0];
    while (shyElement.nodeType === 1 && !shyElement.nodeName) {
      shyElement = shyElement.firstChild;
    }
    // At this point it's the actual unicode character.
    if (shyElement.nodeType === 3 && shyElement.nodeValue.charAt(0) === "\u00AD") {
      var newValue = shyElement.nodeValue.slice(1);
      if (newValue.length) {
        shyElement.nodeValue = shyElement.nodeValue.slice(1);
      } else {
        shyElement.parentNode.removeChild(shyElement);
      }
    }

    return nodes;
  }

  function buildDOMWithFix(html, contextualElement) {
    var tagName = contextualElement.tagName;

    // Firefox versions < 11 do not have support for element.outerHTML.
    var outerHTML = contextualElement.outerHTML || new XMLSerializer().serializeToString(contextualElement);
    if (!outerHTML) {
      throw "Can't set innerHTML on " + tagName + " in this browser";
    }

    html = fixSelect(html, contextualElement);

    var wrappingTags = tagNamesRequiringInnerHTMLFix[tagName.toLowerCase()];

    var startTag = outerHTML.match(new RegExp("<" + tagName + "([^>]*)>", 'i'))[0];
    var endTag = '</' + tagName + '>';

    var wrappedHTML = [startTag, html, endTag];

    var i = wrappingTags.length;
    var wrappedDepth = 1 + i;
    while (i--) {
      wrappedHTML.unshift('<' + wrappingTags[i] + '>');
      wrappedHTML.push('</' + wrappingTags[i] + '>');
    }

    var wrapper = document.createElement('div');
    scriptSafeInnerHTML(wrapper, wrappedHTML.join(''));
    var element = wrapper;
    while (wrappedDepth--) {
      element = element.firstChild;
      while (element && element.nodeType !== 1) {
        element = element.nextSibling;
      }
    }
    while (element && element.tagName !== tagName) {
      element = element.nextSibling;
    }
    return element ? element.childNodes : [];
  }

  var buildDOM;
  if (needsShy) {
    buildDOM = function buildDOM(html, contextualElement, dom) {
      html = fixSelect(html, contextualElement);

      contextualElement = dom.cloneNode(contextualElement, false);
      scriptSafeInnerHTML(contextualElement, html);
      return contextualElement.childNodes;
    };
  } else {
    buildDOM = function buildDOM(html, contextualElement, dom) {
      html = fixSelect(html, contextualElement);

      contextualElement = dom.cloneNode(contextualElement, false);
      contextualElement.innerHTML = html;
      return contextualElement.childNodes;
    };
  }

  function fixSelect(html, contextualElement) {
    if (contextualElement.tagName === 'SELECT') {
      html = "<option></option>" + html;
    }

    return html;
  }

  var buildIESafeDOM;
  if (tagNamesRequiringInnerHTMLFix || movesWhitespace) {
    buildIESafeDOM = function buildIESafeDOM(html, contextualElement, dom) {
      // Make a list of the leading text on script nodes. Include
      // script tags without any whitespace for easier processing later.
      var spacesBefore = [];
      var spacesAfter = [];
      if (typeof html === 'string') {
        html = html.replace(/(\s*)(<script)/g, function (match, spaces, tag) {
          spacesBefore.push(spaces);
          return tag;
        });

        html = html.replace(/(<\/script>)(\s*)/g, function (match, tag, spaces) {
          spacesAfter.push(spaces);
          return tag;
        });
      }

      // Fetch nodes
      var nodes;
      if (tagNamesRequiringInnerHTMLFix[contextualElement.tagName.toLowerCase()]) {
        // buildDOMWithFix uses string wrappers for problematic innerHTML.
        nodes = buildDOMWithFix(html, contextualElement);
      } else {
        nodes = buildDOM(html, contextualElement, dom);
      }

      // Build a list of script tags, the nodes themselves will be
      // mutated as we add test nodes.
      var i, j, node, nodeScriptNodes;
      var scriptNodes = [];
      for (i = 0; i < nodes.length; i++) {
        node = nodes[i];
        if (node.nodeType !== 1) {
          continue;
        }
        if (node.tagName === 'SCRIPT') {
          scriptNodes.push(node);
        } else {
          nodeScriptNodes = node.getElementsByTagName('script');
          for (j = 0; j < nodeScriptNodes.length; j++) {
            scriptNodes.push(nodeScriptNodes[j]);
          }
        }
      }

      // Walk the script tags and put back their leading text nodes.
      var scriptNode, textNode, spaceBefore, spaceAfter;
      for (i = 0; i < scriptNodes.length; i++) {
        scriptNode = scriptNodes[i];
        spaceBefore = spacesBefore[i];
        if (spaceBefore && spaceBefore.length > 0) {
          textNode = dom.document.createTextNode(spaceBefore);
          scriptNode.parentNode.insertBefore(textNode, scriptNode);
        }

        spaceAfter = spacesAfter[i];
        if (spaceAfter && spaceAfter.length > 0) {
          textNode = dom.document.createTextNode(spaceAfter);
          scriptNode.parentNode.insertBefore(textNode, scriptNode.nextSibling);
        }
      }

      return nodes;
    };
  } else {
    buildIESafeDOM = buildDOM;
  }

  var buildHTMLDOM;
  if (needsIntegrationPointFix) {
    exports.buildHTMLDOM = buildHTMLDOM = function buildHTMLDOM(html, contextualElement, dom) {
      if (svgHTMLIntegrationPoints[contextualElement.tagName]) {
        return buildIESafeDOM(html, document.createElement('div'), dom);
      } else {
        return buildIESafeDOM(html, contextualElement, dom);
      }
    };
  } else {
    exports.buildHTMLDOM = buildHTMLDOM = buildIESafeDOM;
  }

  exports.buildHTMLDOM = buildHTMLDOM;
})(Em._e[162]);
(function (exports) {
  // Build out our basic SafeString type
  'use strict';

  function SafeString(string) {
    this.string = string;
  }

  SafeString.prototype.toString = SafeString.prototype.toHTML = function () {
    return '' + this.string;
  };

  exports.default = SafeString;
})(Em._e[163]);
(function (exports, _htmlbarsUtilHandlebarsSafeString) {
  'use strict';

  exports.default = _htmlbarsUtilHandlebarsSafeString.default;
})(Em._e[164],Em._e[163]);
(function (exports) {
  'use strict';

  exports.extend = extend;
  exports.indexOf = indexOf;
  exports.escapeExpression = escapeExpression;
  exports.isEmpty = isEmpty;
  exports.blockParams = blockParams;
  exports.appendContextPath = appendContextPath;
  var escape = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    "'": '&#x27;',
    '`': '&#x60;'
  };

  var badChars = /[&<>"'`]/g,
      possible = /[&<>"'`]/;

  function escapeChar(chr) {
    return escape[chr];
  }

  function extend(obj /* , ...source */) {
    for (var i = 1; i < arguments.length; i++) {
      for (var key in arguments[i]) {
        if (Object.prototype.hasOwnProperty.call(arguments[i], key)) {
          obj[key] = arguments[i][key];
        }
      }
    }

    return obj;
  }

  var toString = Object.prototype.toString;

  exports.toString = toString;
  // Sourced from lodash
  // https://github.com/bestiejs/lodash/blob/master/LICENSE.txt
  /*eslint-disable func-style, no-var */
  var isFunction = function (value) {
    return typeof value === 'function';
  };
  // fallback for older versions of Chrome and Safari
  /* istanbul ignore next */
  if (isFunction(/x/)) {
    exports.isFunction = isFunction = function (value) {
      return typeof value === 'function' && toString.call(value) === '[object Function]';
    };
  }
  var isFunction;
  exports.isFunction = isFunction;
  /*eslint-enable func-style, no-var */

  /* istanbul ignore next */
  var isArray = Array.isArray || function (value) {
    return value && typeof value === 'object' ? toString.call(value) === '[object Array]' : false;
  };

  exports.isArray = isArray;
  // Older IE versions do not directly support indexOf so we must implement our own, sadly.

  function indexOf(array, value) {
    for (var i = 0, len = array.length; i < len; i++) {
      if (array[i] === value) {
        return i;
      }
    }
    return -1;
  }

  function escapeExpression(string) {
    if (typeof string !== 'string') {
      // don't escape SafeStrings, since they're already safe
      if (string && string.toHTML) {
        return string.toHTML();
      } else if (string == null) {
        return '';
      } else if (!string) {
        return string + '';
      }

      // Force a string conversion as this will be done by the append regardless and
      // the regex test will do this transparently behind the scenes, causing issues if
      // an object's to string has escaped characters in it.
      string = '' + string;
    }

    if (!possible.test(string)) {
      return string;
    }
    return string.replace(badChars, escapeChar);
  }

  function isEmpty(value) {
    if (!value && value !== 0) {
      return true;
    } else if (isArray(value) && value.length === 0) {
      return true;
    } else {
      return false;
    }
  }

  function blockParams(params, ids) {
    params.path = ids;
    return params;
  }

  function appendContextPath(contextPath, id) {
    return (contextPath ? contextPath + '.' : '') + id;
  }
})(Em._e[165]);
(function (exports) {
  // ref http://dev.w3.org/html5/spec-LC/namespaces.html
  'use strict';

  exports.getAttrNamespace = getAttrNamespace;
  var defaultNamespaces = {
    html: 'http://www.w3.org/1999/xhtml',
    mathml: 'http://www.w3.org/1998/Math/MathML',
    svg: 'http://www.w3.org/2000/svg',
    xlink: 'http://www.w3.org/1999/xlink',
    xml: 'http://www.w3.org/XML/1998/namespace'
  };

  function getAttrNamespace(attrName, detectedNamespace) {
    if (detectedNamespace) {
      return detectedNamespace;
    }

    var namespace;

    var colonIndex = attrName.indexOf(':');
    if (colonIndex !== -1) {
      var prefix = attrName.slice(0, colonIndex);
      namespace = defaultNamespaces[prefix];
    }

    return namespace || null;
  }
})(Em._e[166]);
(function (exports, _htmlbarsUtilSafeString, _htmlbarsUtilHandlebarsUtils, _htmlbarsUtilNamespaces, _htmlbarsUtilMorphUtils) {
  'use strict';

  exports.SafeString = _htmlbarsUtilSafeString.default;
  exports.escapeExpression = _htmlbarsUtilHandlebarsUtils.escapeExpression;
  exports.getAttrNamespace = _htmlbarsUtilNamespaces.getAttrNamespace;
  exports.validateChildMorphs = _htmlbarsUtilMorphUtils.validateChildMorphs;
  exports.linkParams = _htmlbarsUtilMorphUtils.linkParams;
  exports.dump = _htmlbarsUtilMorphUtils.dump;
})(Em._e[167],Em._e[164],Em._e[165],Em._e[166],Em._e[34]);
(function (exports, _morphAttrSanitizeAttributeValue, _domHelperProp, _domHelperBuildHtmlDom, _htmlbarsUtil) {
  "use strict";

  function getProperty() {
    return this.domHelper.getPropertyStrict(this.element, this.attrName);
  }

  function updateProperty(value) {
    if (this._renderedInitially === true || !_domHelperProp.isAttrRemovalValue(value)) {
      var element = this.element;
      var attrName = this.attrName;

      if (attrName === 'value' && element.tagName === 'INPUT' && element.value === value) {
        // Do nothing. Attempts to avoid accidently changing the input cursor location.
        // See https://github.com/tildeio/htmlbars/pull/447 for more details.
      } else {
          // do not render if initial value is undefined or null
          this.domHelper.setPropertyStrict(element, attrName, value);
        }
    }

    this._renderedInitially = true;
  }

  function getAttribute() {
    return this.domHelper.getAttribute(this.element, this.attrName);
  }

  // normalize to be more inline with updateProperty behavior
  function normalizeAttributeValue(value) {
    if (value === false || value === undefined || value === null) {
      return null;
    }
    if (value === true) {
      return '';
    }
    // onclick function etc in SSR
    if (typeof value === 'function') {
      return null;
    }
    return String(value);
  }

  function updateAttribute(_value) {
    var value = normalizeAttributeValue(_value);
    if (_domHelperProp.isAttrRemovalValue(value)) {
      this.domHelper.removeAttribute(this.element, this.attrName);
    } else {
      this.domHelper.setAttribute(this.element, this.attrName, value);
    }
  }

  function getAttributeNS() {
    return this.domHelper.getAttributeNS(this.element, this.namespace, this.attrName);
  }

  function updateAttributeNS(_value) {
    var value = normalizeAttributeValue(_value);
    if (_domHelperProp.isAttrRemovalValue(value)) {
      this.domHelper.removeAttribute(this.element, this.attrName);
    } else {
      this.domHelper.setAttributeNS(this.element, this.namespace, this.attrName, value);
    }
  }

  var UNSET = { unset: true };

  var guid = 1;

  AttrMorph.create = function (element, attrName, domHelper, namespace) {
    var ns = _htmlbarsUtil.getAttrNamespace(attrName, namespace);

    if (ns) {
      return new AttributeNSAttrMorph(element, attrName, domHelper, ns);
    } else {
      return createNonNamespacedAttrMorph(element, attrName, domHelper);
    }
  };

  function createNonNamespacedAttrMorph(element, attrName, domHelper) {
    var _normalizeProperty = _domHelperProp.normalizeProperty(element, attrName);

    var normalized = _normalizeProperty.normalized;
    var type = _normalizeProperty.type;

    if (element.namespaceURI === _domHelperBuildHtmlDom.svgNamespace || attrName === 'style' || type === 'attr') {
      return new AttributeAttrMorph(element, normalized, domHelper);
    } else {
      return new PropertyAttrMorph(element, normalized, domHelper);
    }
  }

  function AttrMorph(element, attrName, domHelper) {
    this.element = element;
    this.domHelper = domHelper;
    this.attrName = attrName;
    this._state = undefined;
    this.isDirty = false;
    this.isSubtreeDirty = false;
    this.escaped = true;
    this.lastValue = UNSET;
    this.lastResult = null;
    this.lastYielded = null;
    this.childNodes = null;
    this.linkedParams = null;
    this.linkedResult = null;
    this.guid = "attr" + guid++;
    this.seen = false;
    this.ownerNode = null;
    this.rendered = false;
    this._renderedInitially = false;
    this.namespace = undefined;
    this.didInit();
  }

  AttrMorph.prototype.getState = function () {
    if (!this._state) {
      this._state = {};
    }

    return this._state;
  };

  AttrMorph.prototype.setState = function (newState) {
    /*jshint -W093 */

    return this._state = newState;
  };

  AttrMorph.prototype.didInit = function () {};
  AttrMorph.prototype.willSetContent = function () {};

  AttrMorph.prototype.setContent = function (value) {
    this.willSetContent(value);

    if (this.lastValue === value) {
      return;
    }
    this.lastValue = value;

    if (this.escaped) {
      var sanitized = _morphAttrSanitizeAttributeValue.sanitizeAttributeValue(this.domHelper, this.element, this.attrName, value);
      this._update(sanitized, this.namespace);
    } else {
      this._update(value, this.namespace);
    }
  };

  AttrMorph.prototype.getContent = function () {
    var value = this.lastValue = this._get();
    return value;
  };

  // renderAndCleanup calls `clear` on all items in the morph map
  // just before calling `destroy` on the morph.
  //
  // As a future refactor this could be changed to set the property
  // back to its original/default value.
  AttrMorph.prototype.clear = function () {};

  AttrMorph.prototype.destroy = function () {
    this.element = null;
    this.domHelper = null;
  };

  AttrMorph.prototype._$superAttrMorph = AttrMorph;

  function PropertyAttrMorph(element, attrName, domHelper) {
    this._$superAttrMorph(element, attrName, domHelper);
  }

  PropertyAttrMorph.prototype = Object.create(AttrMorph.prototype);
  PropertyAttrMorph.prototype._update = updateProperty;
  PropertyAttrMorph.prototype._get = getProperty;

  function AttributeNSAttrMorph(element, attrName, domHelper, namespace) {
    this._$superAttrMorph(element, attrName, domHelper);
    this.namespace = namespace;
  }

  AttributeNSAttrMorph.prototype = Object.create(AttrMorph.prototype);
  AttributeNSAttrMorph.prototype._update = updateAttributeNS;
  AttributeNSAttrMorph.prototype._get = getAttributeNS;

  function AttributeAttrMorph(element, attrName, domHelper) {
    this._$superAttrMorph(element, attrName, domHelper);
  }

  AttributeAttrMorph.prototype = Object.create(AttrMorph.prototype);
  AttributeAttrMorph.prototype._update = updateAttribute;
  AttributeAttrMorph.prototype._get = getAttribute;

  exports.default = AttrMorph;
  exports.sanitizeAttributeValue = _morphAttrSanitizeAttributeValue.sanitizeAttributeValue;
})(Em._e[168],Em._e[160],Em._e[161],Em._e[162],Em._e[167]);
(function (exports) {
  'use strict';

  var doc = typeof document === 'undefined' ? false : document;

  // PhantomJS has a broken classList. See https://github.com/ariya/phantomjs/issues/12782
  var canClassList = doc && (function () {
    var d = document.createElement('div');
    if (!d.classList) {
      return false;
    }
    d.classList.add('boo');
    d.classList.add('boo', 'baz');
    return d.className === 'boo baz';
  })();

  function buildClassList(element) {
    var classString = element.getAttribute('class') || '';
    return classString !== '' && classString !== ' ' ? classString.split(' ') : [];
  }

  function intersect(containingArray, valuesArray) {
    var containingIndex = 0;
    var containingLength = containingArray.length;
    var valuesIndex = 0;
    var valuesLength = valuesArray.length;

    var intersection = new Array(valuesLength);

    // TODO: rewrite this loop in an optimal manner
    for (; containingIndex < containingLength; containingIndex++) {
      valuesIndex = 0;
      for (; valuesIndex < valuesLength; valuesIndex++) {
        if (valuesArray[valuesIndex] === containingArray[containingIndex]) {
          intersection[valuesIndex] = containingIndex;
          break;
        }
      }
    }

    return intersection;
  }

  function addClassesViaAttribute(element, classNames) {
    var existingClasses = buildClassList(element);

    var indexes = intersect(existingClasses, classNames);
    var didChange = false;

    for (var i = 0, l = classNames.length; i < l; i++) {
      if (indexes[i] === undefined) {
        didChange = true;
        existingClasses.push(classNames[i]);
      }
    }

    if (didChange) {
      element.setAttribute('class', existingClasses.length > 0 ? existingClasses.join(' ') : '');
    }
  }

  function removeClassesViaAttribute(element, classNames) {
    var existingClasses = buildClassList(element);

    var indexes = intersect(classNames, existingClasses);
    var didChange = false;
    var newClasses = [];

    for (var i = 0, l = existingClasses.length; i < l; i++) {
      if (indexes[i] === undefined) {
        newClasses.push(existingClasses[i]);
      } else {
        didChange = true;
      }
    }

    if (didChange) {
      element.setAttribute('class', newClasses.length > 0 ? newClasses.join(' ') : '');
    }
  }

  var addClasses, removeClasses;
  if (canClassList) {
    exports.addClasses = addClasses = function addClasses(element, classNames) {
      if (element.classList) {
        if (classNames.length === 1) {
          element.classList.add(classNames[0]);
        } else if (classNames.length === 2) {
          element.classList.add(classNames[0], classNames[1]);
        } else {
          element.classList.add.apply(element.classList, classNames);
        }
      } else {
        addClassesViaAttribute(element, classNames);
      }
    };
    exports.removeClasses = removeClasses = function removeClasses(element, classNames) {
      if (element.classList) {
        if (classNames.length === 1) {
          element.classList.remove(classNames[0]);
        } else if (classNames.length === 2) {
          element.classList.remove(classNames[0], classNames[1]);
        } else {
          element.classList.remove.apply(element.classList, classNames);
        }
      } else {
        removeClassesViaAttribute(element, classNames);
      }
    };
  } else {
    exports.addClasses = addClasses = addClassesViaAttribute;
    exports.removeClasses = removeClasses = removeClassesViaAttribute;
  }

  exports.addClasses = addClasses;
  exports.removeClasses = removeClasses;
})(Em._e[169]);
(function (exports, _htmlbarsRuntimeMorph, _morphAttr, _domHelperBuildHtmlDom, _domHelperClasses, _domHelperProp) {
  /*globals module, URL*/

  "use strict";

  var doc = typeof document === 'undefined' ? false : document;

  var deletesBlankTextNodes = doc && (function (document) {
    var element = document.createElement('div');
    element.appendChild(document.createTextNode(''));
    var clonedElement = element.cloneNode(true);
    return clonedElement.childNodes.length === 0;
  })(doc);

  var ignoresCheckedAttribute = doc && (function (document) {
    var element = document.createElement('input');
    element.setAttribute('checked', 'checked');
    var clonedElement = element.cloneNode(false);
    return !clonedElement.checked;
  })(doc);

  var canRemoveSvgViewBoxAttribute = doc && (doc.createElementNS ? (function (document) {
    var element = document.createElementNS(_domHelperBuildHtmlDom.svgNamespace, 'svg');
    element.setAttribute('viewBox', '0 0 100 100');
    element.removeAttribute('viewBox');
    return !element.getAttribute('viewBox');
  })(doc) : true);

  var canClone = doc && (function (document) {
    var element = document.createElement('div');
    element.appendChild(document.createTextNode(' '));
    element.appendChild(document.createTextNode(' '));
    var clonedElement = element.cloneNode(true);
    return clonedElement.childNodes[0].nodeValue === ' ';
  })(doc);

  // This is not the namespace of the element, but of
  // the elements inside that elements.
  function interiorNamespace(element) {
    if (element && element.namespaceURI === _domHelperBuildHtmlDom.svgNamespace && !_domHelperBuildHtmlDom.svgHTMLIntegrationPoints[element.tagName]) {
      return _domHelperBuildHtmlDom.svgNamespace;
    } else {
      return null;
    }
  }

  // The HTML spec allows for "omitted start tags". These tags are optional
  // when their intended child is the first thing in the parent tag. For
  // example, this is a tbody start tag:
  //
  // <table>
  //   <tbody>
  //     <tr>
  //
  // The tbody may be omitted, and the browser will accept and render:
  //
  // <table>
  //   <tr>
  //
  // However, the omitted start tag will still be added to the DOM. Here
  // we test the string and context to see if the browser is about to
  // perform this cleanup.
  //
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/syntax.html#optional-tags
  // describes which tags are omittable. The spec for tbody and colgroup
  // explains this behavior:
  //
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/tables.html#the-tbody-element
  // http://www.whatwg.org/specs/web-apps/current-work/multipage/tables.html#the-colgroup-element
  //

  var omittedStartTagChildTest = /<([\w:]+)/;
  function detectOmittedStartTag(string, contextualElement) {
    // Omitted start tags are only inside table tags.
    if (contextualElement.tagName === 'TABLE') {
      var omittedStartTagChildMatch = omittedStartTagChildTest.exec(string);
      if (omittedStartTagChildMatch) {
        var omittedStartTagChild = omittedStartTagChildMatch[1];
        // It is already asserted that the contextual element is a table
        // and not the proper start tag. Just see if a tag was omitted.
        return omittedStartTagChild === 'tr' || omittedStartTagChild === 'col';
      }
    }
  }

  function buildSVGDOM(html, dom) {
    var div = dom.document.createElement('div');
    div.innerHTML = '<svg>' + html + '</svg>';
    return div.firstChild.childNodes;
  }

  var guid = 1;

  function ElementMorph(element, dom, namespace) {
    this.element = element;
    this.dom = dom;
    this.namespace = namespace;
    this.guid = "element" + guid++;

    this._state = undefined;
    this.isDirty = true;
  }

  ElementMorph.prototype.getState = function () {
    if (!this._state) {
      this._state = {};
    }

    return this._state;
  };

  ElementMorph.prototype.setState = function (newState) {
    /*jshint -W093 */

    return this._state = newState;
  };

  // renderAndCleanup calls `clear` on all items in the morph map
  // just before calling `destroy` on the morph.
  //
  // As a future refactor this could be changed to set the property
  // back to its original/default value.
  ElementMorph.prototype.clear = function () {};

  ElementMorph.prototype.destroy = function () {
    this.element = null;
    this.dom = null;
  };

  /*
   * A class wrapping DOM functions to address environment compatibility,
   * namespaces, contextual elements for morph un-escaped content
   * insertion.
   *
   * When entering a template, a DOMHelper should be passed:
   *
   *   template(context, { hooks: hooks, dom: new DOMHelper() });
   *
   * TODO: support foreignObject as a passed contextual element. It has
   * a namespace (svg) that does not match its internal namespace
   * (xhtml).
   *
   * @class DOMHelper
   * @constructor
   * @param {HTMLDocument} _document The document DOM methods are proxied to
   */
  function DOMHelper(_document) {
    this.document = _document || document;
    if (!this.document) {
      throw new Error("A document object must be passed to the DOMHelper, or available on the global scope");
    }
    this.canClone = canClone;
    this.namespace = null;

    installEnvironmentSpecificMethods(this);
  }

  var prototype = DOMHelper.prototype;
  prototype.constructor = DOMHelper;

  prototype.getElementById = function (id, rootNode) {
    rootNode = rootNode || this.document;
    return rootNode.getElementById(id);
  };

  prototype.insertBefore = function (element, childElement, referenceChild) {
    return element.insertBefore(childElement, referenceChild);
  };

  prototype.appendChild = function (element, childElement) {
    return element.appendChild(childElement);
  };

  var itemAt;

  // It appears that sometimes, in yet to be itentified scenarios PhantomJS 2.0
  // crashes on childNodes.item(index), but works as expected with childNodes[index];
  //
  // Although it would be nice to move to childNodes[index] in all scenarios,
  // this would require SimpleDOM to maintain the childNodes array. This would be
  // quite costly, in both dev time and runtime.
  //
  // So instead, we choose the best possible method and call it a day.
  //
  /*global navigator */
  if (typeof navigator !== 'undefined' && navigator.userAgent.indexOf('PhantomJS')) {
    itemAt = function (nodes, index) {
      return nodes[index];
    };
  } else {
    itemAt = function (nodes, index) {
      return nodes.item(index);
    };
  }

  prototype.childAt = function (element, indices) {
    var child = element;

    for (var i = 0; i < indices.length; i++) {
      child = itemAt(child.childNodes, indices[i]);
    }

    return child;
  };

  // Note to a Fellow Implementor:
  // Ahh, accessing a child node at an index. Seems like it should be so simple,
  // doesn't it? Unfortunately, this particular method has caused us a surprising
  // amount of pain. As you'll note below, this method has been modified to walk
  // the linked list of child nodes rather than access the child by index
  // directly, even though there are two (2) APIs in the DOM that do this for us.
  // If you're thinking to yourself, "What an oversight! What an opportunity to
  // optimize this code!" then to you I say: stop! For I have a tale to tell.
  //
  // First, this code must be compatible with simple-dom for rendering on the
  // server where there is no real DOM. Previously, we accessed a child node
  // directly via `element.childNodes[index]`. While we *could* in theory do a
  // full-fidelity simulation of a live `childNodes` array, this is slow,
  // complicated and error-prone.
  //
  // "No problem," we thought, "we'll just use the similar
  // `childNodes.item(index)` API." Then, we could just implement our own `item`
  // method in simple-dom and walk the child node linked list there, allowing
  // us to retain the performance advantages of the (surely optimized) `item()`
  // API in the browser.
  //
  // Unfortunately, an enterprising soul named Samy Alzahrani discovered that in
  // IE8, accessing an item out-of-bounds via `item()` causes an exception where
  // other browsers return null. This necessitated a... check of
  // `childNodes.length`, bringing us back around to having to support a
  // full-fidelity `childNodes` array!
  //
  // Worst of all, Kris Selden investigated how browsers are actualy implemented
  // and discovered that they're all linked lists under the hood anyway. Accessing
  // `childNodes` requires them to allocate a new live collection backed by that
  // linked list, which is itself a rather expensive operation. Our assumed
  // optimization had backfired! That is the danger of magical thinking about
  // the performance of native implementations.
  //
  // And this, my friends, is why the following implementation just walks the
  // linked list, as surprised as that may make you. Please ensure you understand
  // the above before changing this and submitting a PR.
  //
  // Tom Dale, January 18th, 2015, Portland OR
  prototype.childAtIndex = function (element, index) {
    var node = element.firstChild;

    for (var idx = 0; node && idx < index; idx++) {
      node = node.nextSibling;
    }

    return node;
  };

  prototype.appendText = function (element, text) {
    return element.appendChild(this.document.createTextNode(text));
  };

  prototype.setAttribute = function (element, name, value) {
    element.setAttribute(name, String(value));
  };

  prototype.getAttribute = function (element, name) {
    return element.getAttribute(name);
  };

  prototype.setAttributeNS = function (element, namespace, name, value) {
    element.setAttributeNS(namespace, name, String(value));
  };

  prototype.getAttributeNS = function (element, namespace, name) {
    return element.getAttributeNS(namespace, name);
  };

  if (canRemoveSvgViewBoxAttribute) {
    prototype.removeAttribute = function (element, name) {
      element.removeAttribute(name);
    };
  } else {
    prototype.removeAttribute = function (element, name) {
      if (element.tagName === 'svg' && name === 'viewBox') {
        element.setAttribute(name, null);
      } else {
        element.removeAttribute(name);
      }
    };
  }

  prototype.setPropertyStrict = function (element, name, value) {
    if (value === undefined) {
      value = null;
    }

    if (value === null && (name === 'value' || name === 'type' || name === 'src')) {
      value = '';
    }

    element[name] = value;
  };

  prototype.getPropertyStrict = function (element, name) {
    return element[name];
  };

  prototype.setProperty = function (element, name, value, namespace) {
    if (element.namespaceURI === _domHelperBuildHtmlDom.svgNamespace) {
      if (_domHelperProp.isAttrRemovalValue(value)) {
        element.removeAttribute(name);
      } else {
        if (namespace) {
          element.setAttributeNS(namespace, name, value);
        } else {
          element.setAttribute(name, value);
        }
      }
    } else {
      var _normalizeProperty = _domHelperProp.normalizeProperty(element, name);

      var normalized = _normalizeProperty.normalized;
      var type = _normalizeProperty.type;

      if (type === 'prop') {
        element[normalized] = value;
      } else {
        if (_domHelperProp.isAttrRemovalValue(value)) {
          element.removeAttribute(name);
        } else {
          if (namespace && element.setAttributeNS) {
            element.setAttributeNS(namespace, name, value);
          } else {
            element.setAttribute(name, value);
          }
        }
      }
    }
  };

  if (doc && doc.createElementNS) {
    // Only opt into namespace detection if a contextualElement
    // is passed.
    prototype.createElement = function (tagName, contextualElement) {
      var namespace = this.namespace;
      if (contextualElement) {
        if (tagName === 'svg') {
          namespace = _domHelperBuildHtmlDom.svgNamespace;
        } else {
          namespace = interiorNamespace(contextualElement);
        }
      }
      if (namespace) {
        return this.document.createElementNS(namespace, tagName);
      } else {
        return this.document.createElement(tagName);
      }
    };
    prototype.setAttributeNS = function (element, namespace, name, value) {
      element.setAttributeNS(namespace, name, String(value));
    };
  } else {
    prototype.createElement = function (tagName) {
      return this.document.createElement(tagName);
    };
    prototype.setAttributeNS = function (element, namespace, name, value) {
      element.setAttribute(name, String(value));
    };
  }

  prototype.addClasses = _domHelperClasses.addClasses;
  prototype.removeClasses = _domHelperClasses.removeClasses;

  prototype.setNamespace = function (ns) {
    this.namespace = ns;
  };

  prototype.detectNamespace = function (element) {
    this.namespace = interiorNamespace(element);
  };

  prototype.createDocumentFragment = function () {
    return this.document.createDocumentFragment();
  };

  prototype.createTextNode = function (text) {
    return this.document.createTextNode(text);
  };

  prototype.createComment = function (text) {
    return this.document.createComment(text);
  };

  prototype.repairClonedNode = function (element, blankChildTextNodes, isChecked) {
    if (deletesBlankTextNodes && blankChildTextNodes.length > 0) {
      for (var i = 0, len = blankChildTextNodes.length; i < len; i++) {
        var textNode = this.document.createTextNode(''),
            offset = blankChildTextNodes[i],
            before = this.childAtIndex(element, offset);
        if (before) {
          element.insertBefore(textNode, before);
        } else {
          element.appendChild(textNode);
        }
      }
    }
    if (ignoresCheckedAttribute && isChecked) {
      element.setAttribute('checked', 'checked');
    }
  };

  prototype.cloneNode = function (element, deep) {
    var clone = element.cloneNode(!!deep);
    return clone;
  };

  prototype.AttrMorphClass = _morphAttr.default;

  prototype.createAttrMorph = function (element, attrName, namespace) {
    return this.AttrMorphClass.create(element, attrName, this, namespace);
  };

  prototype.ElementMorphClass = ElementMorph;

  prototype.createElementMorph = function (element, namespace) {
    return new this.ElementMorphClass(element, this, namespace);
  };

  prototype.createUnsafeAttrMorph = function (element, attrName, namespace) {
    var morph = this.createAttrMorph(element, attrName, namespace);
    morph.escaped = false;
    return morph;
  };

  prototype.MorphClass = _htmlbarsRuntimeMorph.default;

  prototype.createMorph = function (parent, start, end, contextualElement) {
    if (contextualElement && contextualElement.nodeType === 11) {
      throw new Error("Cannot pass a fragment as the contextual element to createMorph");
    }

    if (!contextualElement && parent && parent.nodeType === 1) {
      contextualElement = parent;
    }
    var morph = new this.MorphClass(this, contextualElement);
    morph.firstNode = start;
    morph.lastNode = end;
    return morph;
  };

  prototype.createFragmentMorph = function (contextualElement) {
    if (contextualElement && contextualElement.nodeType === 11) {
      throw new Error("Cannot pass a fragment as the contextual element to createMorph");
    }

    var fragment = this.createDocumentFragment();
    return _htmlbarsRuntimeMorph.default.create(this, contextualElement, fragment);
  };

  prototype.replaceContentWithMorph = function (element) {
    var firstChild = element.firstChild;

    if (!firstChild) {
      var comment = this.createComment('');
      this.appendChild(element, comment);
      return _htmlbarsRuntimeMorph.default.create(this, element, comment);
    } else {
      var morph = _htmlbarsRuntimeMorph.default.attach(this, element, firstChild, element.lastChild);
      morph.clear();
      return morph;
    }
  };

  prototype.createUnsafeMorph = function (parent, start, end, contextualElement) {
    var morph = this.createMorph(parent, start, end, contextualElement);
    morph.parseTextAsHTML = true;
    return morph;
  };

  // This helper is just to keep the templates good looking,
  // passing integers instead of element references.
  prototype.createMorphAt = function (parent, startIndex, endIndex, contextualElement) {
    var single = startIndex === endIndex;
    var start = this.childAtIndex(parent, startIndex);
    var end = single ? start : this.childAtIndex(parent, endIndex);
    return this.createMorph(parent, start, end, contextualElement);
  };

  prototype.createUnsafeMorphAt = function (parent, startIndex, endIndex, contextualElement) {
    var morph = this.createMorphAt(parent, startIndex, endIndex, contextualElement);
    morph.parseTextAsHTML = true;
    return morph;
  };

  prototype.insertMorphBefore = function (element, referenceChild, contextualElement) {
    var insertion = this.document.createComment('');
    element.insertBefore(insertion, referenceChild);
    return this.createMorph(element, insertion, insertion, contextualElement);
  };

  prototype.appendMorph = function (element, contextualElement) {
    var insertion = this.document.createComment('');
    element.appendChild(insertion);
    return this.createMorph(element, insertion, insertion, contextualElement);
  };

  prototype.insertBoundary = function (fragment, index) {
    // this will always be null or firstChild
    var child = index === null ? null : this.childAtIndex(fragment, index);
    this.insertBefore(fragment, this.createTextNode(''), child);
  };

  prototype.setMorphHTML = function (morph, html) {
    morph.setHTML(html);
  };

  prototype.parseHTML = function (html, contextualElement) {
    var childNodes;

    if (interiorNamespace(contextualElement) === _domHelperBuildHtmlDom.svgNamespace) {
      childNodes = buildSVGDOM(html, this);
    } else {
      var nodes = _domHelperBuildHtmlDom.buildHTMLDOM(html, contextualElement, this);
      if (detectOmittedStartTag(html, contextualElement)) {
        var node = nodes[0];
        while (node && node.nodeType !== 1) {
          node = node.nextSibling;
        }
        childNodes = node.childNodes;
      } else {
        childNodes = nodes;
      }
    }

    // Copy node list to a fragment.
    var fragment = this.document.createDocumentFragment();

    if (childNodes && childNodes.length > 0) {
      var currentNode = childNodes[0];

      // We prepend an <option> to <select> boxes to absorb any browser bugs
      // related to auto-select behavior. Skip past it.
      if (contextualElement.tagName === 'SELECT') {
        currentNode = currentNode.nextSibling;
      }

      while (currentNode) {
        var tempNode = currentNode;
        currentNode = currentNode.nextSibling;

        fragment.appendChild(tempNode);
      }
    }

    return fragment;
  };

  var nodeURL;
  var parsingNode;

  function installEnvironmentSpecificMethods(domHelper) {
    var protocol = browserProtocolForURL.call(domHelper, 'foobar:baz');

    // Test to see if our DOM implementation parses
    // and normalizes URLs.
    if (protocol === 'foobar:') {
      // Swap in the method that doesn't do this test now that
      // we know it works.
      domHelper.protocolForURL = browserProtocolForURL;
    } else if (typeof URL === 'object') {
      // URL globally provided, likely from FastBoot's sandbox
      nodeURL = URL;
      domHelper.protocolForURL = nodeProtocolForURL;
    } else if (typeof module === 'object' && typeof module.require === 'function') {
      // Otherwise, we need to fall back to our own URL parsing.
      // Global `require` is shadowed by Ember's loader so we have to use the fully
      // qualified `module.require`.
      nodeURL = module.require('url');
      domHelper.protocolForURL = nodeProtocolForURL;
    } else {
      throw new Error("DOM Helper could not find valid URL parsing mechanism");
    }

    // A SimpleDOM-specific extension that allows us to place HTML directly
    // into the DOM tree, for when the output target is always serialized HTML.
    if (domHelper.document.createRawHTMLSection) {
      domHelper.setMorphHTML = nodeSetMorphHTML;
    }
  }

  function nodeSetMorphHTML(morph, html) {
    var section = this.document.createRawHTMLSection(html);
    morph.setNode(section);
  }

  function browserProtocolForURL(url) {
    if (!parsingNode) {
      parsingNode = this.document.createElement('a');
    }

    parsingNode.href = url;
    return parsingNode.protocol;
  }

  function nodeProtocolForURL(url) {
    var protocol = null;
    if (typeof url === 'string') {
      protocol = nodeURL.parse(url).protocol;
    }
    return protocol === null ? ':' : protocol;
  }

  exports.default = DOMHelper;
})(Em._e[170],Em._e[39],Em._e[168],Em._e[162],Em._e[169],Em._e[161]);
(function (exports, _domHelper, _emberMetalDebug) {
  'use strict';

  exports.default = EmberMorph;

  var HTMLBarsMorph = _domHelper.default.prototype.MorphClass;
  var guid = 1;

  function EmberMorph(DOMHelper, contextualElement) {
    this.HTMLBarsMorph$constructor(DOMHelper, contextualElement);

    this.emberView = null;
    this.emberToDestroy = null;
    this.streamUnsubscribers = null;
    this.guid = guid++;

    // A component can become dirty either because one of its
    // attributes changed, or because it was re-rendered. If any part
    // of the component's template changes through observation, it has
    // re-rendered from the perpsective of the programming model. This
    // flag is set to true whenever a component becomes dirty because
    // one of its attributes changed, which also triggers the attribute
    // update flag (didUpdateAttrs).
    this.shouldReceiveAttrs = false;
  }

  var proto = EmberMorph.prototype = Object.create(HTMLBarsMorph.prototype);
  proto.HTMLBarsMorph$constructor = HTMLBarsMorph;
  proto.HTMLBarsMorph$clear = HTMLBarsMorph.prototype.clear;

  proto.addDestruction = function (toDestroy) {
    // called from Router.prototype._connectActiveComponentNode for {{render}}
    this.emberToDestroy = this.emberToDestroy || [];
    this.emberToDestroy.push(toDestroy);
  };

  proto.cleanup = function () {
    var toDestroy = this.emberToDestroy;

    if (toDestroy) {
      for (var i = 0; i < toDestroy.length; i++) {
        toDestroy[i].destroy();
      }

      this.emberToDestroy = null;
    }
  };

  proto.didRender = function (env, scope) {
    env.renderedNodes.add(this);
  };
})(Em._e[171],Em._e[170],Em._e[0]);
(function (exports, _emberMetalDebug, _domHelper, _emberMetalIs_none, _emberViewsSystemUtils) {
  'use strict';

  var HTMLBarsAttrMorph = _domHelper.default.prototype.AttrMorphClass;

  var proto = HTMLBarsAttrMorph.prototype;

  proto.didInit = function () {
    this.streamUnsubscribers = null;
  };

  function deprecateEscapedStyle(morph, value) {}

  proto.willSetContent = function (value) {
    deprecateEscapedStyle(this, value);
  };

  exports.default = HTMLBarsAttrMorph;
})(Em._e[172],Em._e[0],Em._e[170],Em._e[75],Em._e[128]);
(function (exports, _domHelper, _emberHtmlbarsMorphsMorph, _emberHtmlbarsMorphsAttrMorph) {
  'use strict';

  exports.default = EmberDOMHelper;

  function EmberDOMHelper(_document) {
    _domHelper.default.call(this, _document);
  }

  var proto = EmberDOMHelper.prototype = Object.create(_domHelper.default.prototype);
  proto.MorphClass = _emberHtmlbarsMorphsMorph.default;
  proto.AttrMorphClass = _emberHtmlbarsMorphsAttrMorph.default;
})(Em._e[173],Em._e[170],Em._e[171],Em._e[172]);
(function (exports, _emberMetalDebug) {
  /*jshint debug:true*/

  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = debuggerKeyword;

  /**
    Execute the `debugger` statement in the current template's context.
  
    ```handlebars
    {{debugger}}
    ```
  
    When using the debugger helper you will have access to a `get` function. This
    function retrieves values available in the context of the template.
    For example, if you're wondering why a value `{{foo}}` isn't rendering as
    expected within a template, you could place a `{{debugger}}` statement and,
    when the `debugger;` breakpoint is hit, you can attempt to retrieve this value:
  
    ```
    > get('foo')
    ```
  
    `get` is also aware of keywords. So in this situation
  
    ```handlebars
    {{#each items as |item|}}
      {{debugger}}
    {{/each}}
    ```
  
    You'll be able to get values from the current item:
  
    ```
    > get('item.name')
    ```
  
    You can also access the context of the view to make sure it is the object that
    you expect:
  
    ```
    > context
    ```
  
    @method debugger
    @for Ember.Templates.helpers
    @public
  */

  function debuggerKeyword(morph, env, scope) {
    /* jshint unused: false, debug: true */

    var view = env.hooks.getValue(scope.getLocal('view'));
    var context = env.hooks.getValue(scope.getSelf());

    function get(path) {
      return env.hooks.getValue(env.hooks.get(env, scope, path));
    }

    debugger;

    return true;
  }
})(Em._e[174],Em._e[0]);
(function (exports, _emberMetalDebug, _htmlbarsRuntime) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = {
    isStable: function () {
      return true;
    },

    isEmpty: function (state) {
      return false;
    },

    render: function (morph, env, scope, params, hash, template, inverse, visitor) {

      _htmlbarsRuntime.internal.continueBlock(morph, env, scope, 'with', params, hash, template, inverse, visitor);
    },

    rerender: function (morph, env, scope, params, hash, template, inverse, visitor) {
      _htmlbarsRuntime.internal.continueBlock(morph, env, scope, 'with', params, hash, template, inverse, visitor);
    }
  };
})(Em._e[175],Em._e[0],Em._e[47]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberRuntimeUtils, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  exports.default = shouldDisplay;

  var ShouldDisplayStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (predicate) {

      var isTruthy = predicate.get('isTruthy');

      this.init();
      this.predicate = predicate;
      this.isTruthy = isTruthy;
      this.lengthDep = null;

      this.addDependency(predicate);
      this.addDependency(isTruthy);
    },

    compute: function () {
      var truthy = _emberHtmlbarsStreamsUtils.read(this.isTruthy);

      if (typeof truthy === 'boolean') {
        return truthy;
      }

      if (this.lengthDep) {
        return this.lengthDep.getValue() !== 0;
      } else {
        return !!_emberHtmlbarsStreamsUtils.read(this.predicate);
      }
    },

    revalidate: function () {
      if (_emberRuntimeUtils.isArray(_emberHtmlbarsStreamsUtils.read(this.predicate))) {
        if (!this.lengthDep) {
          this.lengthDep = this.addMutableDependency(this.predicate.get('length'));
        }
      } else {
        if (this.lengthDep) {
          this.lengthDep.destroy();
          this.lengthDep = null;
        }
      }
    }
  });

  function shouldDisplay(predicate) {
    if (_emberHtmlbarsStreamsUtils.isStream(predicate)) {
      return new ShouldDisplayStream(predicate);
    }

    var type = typeof predicate;

    if (type === 'boolean') {
      return predicate;
    }

    if (type && type === 'object' && predicate !== null) {
      var isTruthy = _emberMetalProperty_get.get(predicate, 'isTruthy');
      if (typeof isTruthy === 'boolean') {
        return isTruthy;
      }
    }

    if (_emberRuntimeUtils.isArray(predicate)) {
      return _emberMetalProperty_get.get(predicate, 'length') !== 0;
    } else {
      return !!predicate;
    }
  }
})(Em._e[176],Em._e[0],Em._e[30],Em._e[91],Em._e[56],Em._e[66]);
(function (exports, _emberMetalDebug, _emberHtmlbarsStreamsShould_display) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  /**
    Use the `if` block helper to conditionally render a block depending on a
    property. If the property is "falsey", for example: `false`, `undefined`,
   `null`, `""`, `0`, `NaN` or an empty array, the block will not be rendered.
  
   ```handlebars
    {{! will not render if foo is falsey}}
    {{#if foo}}
      Welcome to the {{foo.bar}}
    {{/if}}
    ```
  
    You can also specify a template to show if the property is falsey by using
    the `else` helper.
  
    ```handlebars
    {{! is it raining outside?}}
    {{#if isRaining}}
      Yes, grab an umbrella!
    {{else}}
      No, it's lovely outside!
    {{/if}}
    ```
  
    You are also able to combine `else` and `if` helpers to create more complex
    conditional logic.
  
    ```handlebars
    {{#if isMorning}}
      Good morning
    {{else if isAfternoon}}
      Good afternoon
    {{else}}
      Good night
    {{/if}}
    ```
  
    You can use `if` inline to conditionally render a single property or string.
    This helper acts like a ternary operator. If the first property is truthy,
    the second argument will be displayed, if not, the third argument will be
    displayed
  
    ```handlebars
    {{if useLongGreeting "Hello" "Hi"}} Dave
    ```
  
    Finally, you can use the `if` helper inside another helper as a subexpression.
  
    ```handlebars
    {{some-component height=(if isBig "100" "10")}}
    ```
  
    @method if
    @for Ember.Templates.helpers
    @public
  */
  function ifHelper(params, hash, options) {

    return ifUnless(params, hash, options, _emberHtmlbarsStreamsShould_display.default(params[0]));
  }

  /**
    The `unless` helper is the inverse of the `if` helper. Its block will be
    rendered if the expression contains a falsey value.  All forms of the `if`
    helper can also be used with `unless`.
  
    @method unless
    @for Ember.Templates.helpers
    @public
  */
  function unlessHelper(params, hash, options) {

    return ifUnless(params, hash, options, !_emberHtmlbarsStreamsShould_display.default(params[0]));
  }

  function ifUnless(params, hash, options, truthy) {
    if (truthy) {
      if (options.template.yield) {
        options.template.yield();
      } else {
        return params[1];
      }
    } else {
      if (options.inverse.yield) {
        options.inverse.yield();
      } else {
        return params[2];
      }
    }
  }

  exports.ifHelper = ifHelper;
  exports.unlessHelper = unlessHelper;
})(Em._e[177],Em._e[0],Em._e[176]);
(function (exports, _emberHtmlbarsStreamsShould_display) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = withHelper;

  /**
    Use the `{{with}}` helper when you want to alias a property to a new name. This is helpful
    for semantic clarity as it allows you to retain default scope or to reference a property from another
    `{{with}}` block.
  
    If the aliased property is "falsey", for example: `false`, `undefined` `null`, `""`, `0`, NaN or
    an empty array, the block will not be rendered.
  
    ```handlebars
    {{! Will only render if user.posts contains items}}
    {{#with user.posts as |blogPosts|}}
      <div class="notice">
        There are {{blogPosts.length}} blog posts written by {{user.name}}.
      </div>
      {{#each blogPosts as |post|}}
        <li>{{post.title}}</li>
      {{/each}}
    {{/with}}
    ```
  
    Without the `as` operator, it would be impossible to reference `user.name` in the example above.
  
    NOTE: The alias should not reuse a name from the bound property path.
    For example: `{{#with foo.bar as |foo|}}` is not supported because it attempts to alias using
    the first part of the property path, `foo`. Instead, use `{{#with foo.bar as |baz|}}`.
  
    @method with
    @for Ember.Templates.helpers
    @param {Object} options
    @return {String} HTML string
    @public
  */

  function withHelper(params, hash, options) {
    if (_emberHtmlbarsStreamsShould_display.default(params[0])) {
      options.template.yield([params[0]]);
    } else if (options.inverse && options.inverse.yield) {
      options.inverse.yield([]);
    }
  }
})(Em._e[178],Em._e[176]);
(function (exports, _emberRuntimeSystemObject) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.helper = helper;

  /**
    Ember Helpers are functions that can compute values, and are used in templates.
    For example, this code calls a helper named `format-currency`:
  
    ```handlebars
    <div>{{format-currency cents currency="$"}}</div>
    ```
  
    Additionally, a helper can be called as a nested helper (sometimes called a
    subexpression). In this example, the computed value of a helper is passed
    to a component named `show-money`:
  
    ```handlebars
    {{show-money amount=(format-currency cents currency="$")}}
    ```
  
    Helpers defined using a class must provide a `compute` function. For example:
  
    ```js
    export default Ember.Helper.extend({
      compute(params, hash) {
        let cents = params[0];
        let currency = hash.currency;
        return `${currency}${cents * 0.01}`;
      }
    });
    ```
  
    Each time the input to a helper changes, the `compute` function will be
    called again.
  
    As instances, these helpers also have access to the container and will accept
    injected dependencies.
  
    Additionally, class helpers can call `recompute` to force a new computation.
  
    If the output of your helper is only dependent on the current input, then you
    can use the `Helper.helper` function.
    See [Ember.Helper.helper](/api/classes/Ember.Helper.html#method_helper).
  
    In this form the example above becomes:
  
    ```js
    export default Ember.Helper.helper((params, hash) => {
      let cents = params[0];
      let currency = hash.currency;
      return `${currency}${cents * 0.01}`;
    });
    ```
  
  
    @class Ember.Helper
    @public
    @since 1.13.0
  */
  var Helper = _emberRuntimeSystemObject.default.extend({
    isHelperInstance: true,

    /**
      On a class-based helper, it may be useful to force a recomputation of that
      helpers value. This is akin to `rerender` on a component.
       For example, this component will rerender when the `currentUser` on a
      session service changes:
       ```js
      // app/helpers/current-user-email.js
      export default Ember.Helper.extend({
        session: Ember.inject.service(),
        onNewUser: Ember.observer('session.currentUser', function() {
          this.recompute();
        }),
        compute() {
          return this.get('session.currentUser.email');
        }
      });
      ```
       @method recompute
      @public
      @since 1.13.0
    */
    recompute: function () {
      this._stream.notify();
    }

    /**
      Override this function when writing a class-based helper.
       @method compute
      @param {Array} params The positional arguments to the helper
      @param {Object} hash The named arguments to the helper
      @public
      @since 1.13.0
    */
  });

  Helper.reopenClass({
    isHelperFactory: true
  });

  /**
    In many cases, the ceremony of a full `Ember.Helper` class is not required.
    The `helper` method creates pure-function helpers without instances. For
    example:
  
    ```js
    // app/helpers/format-currency.js
    export function formatCurrency([cents], hash) {
      let currency = hash.currency;
      return `${currency}${cents * 0.01}`;
    });
  
    export default Ember.Helper.helper(formatCurrency);
  
    // tests/myhelper.js
    import { formatCurrency } from ..../helpers/myhelper
    // add some tests
    ```
  
    This form is more efficient at run time and results in smaller compiled js.
    It is also easier to test by using the following structure and importing the
    `formatCurrency` function into a test.
  
    @static
    @param {Function} helper The helper function
    @method helper
    @public
    @since 1.13.0
  */

  function helper(compute) {
    return {
      isHelperInstance: true,
      compute: compute
    };
  }

  exports.default = Helper;
})(Em._e[179],Em._e[77]);
(function (exports) {
  // STATE within a module is frowned apon, this exists
  // to support Ember.STRINGS but shield ember internals from this legacy global
  // API.
  "use strict";

  exports.setStrings = setStrings;
  exports.getStrings = getStrings;
  exports.get = get;
  var STRINGS = {};

  function setStrings(strings) {
    STRINGS = strings;
  }

  function getStrings() {
    return STRINGS;
  }

  function get(name) {
    return STRINGS[name];
  }
})(Em._e[180]);
(function (exports, _emberMetalDebug, _emberMetalUtils, _emberRuntimeUtils, _emberRuntimeString_registry, _emberMetalCache) {
  /**
  @module ember
  @submodule ember-runtime
  */
  'use strict';

  var STRING_DASHERIZE_REGEXP = /[ _]/g;

  var STRING_DASHERIZE_CACHE = new _emberMetalCache.default(1000, function (key) {
    return decamelize(key).replace(STRING_DASHERIZE_REGEXP, '-');
  });

  var STRING_CAMELIZE_REGEXP_1 = /(\-|\_|\.|\s)+(.)?/g;
  var STRING_CAMELIZE_REGEXP_2 = /(^|\/)([A-Z])/g;

  var CAMELIZE_CACHE = new _emberMetalCache.default(1000, function (key) {
    return key.replace(STRING_CAMELIZE_REGEXP_1, function (match, separator, chr) {
      return chr ? chr.toUpperCase() : '';
    }).replace(STRING_CAMELIZE_REGEXP_2, function (match, separator, chr) {
      return match.toLowerCase();
    });
  });

  var STRING_CLASSIFY_REGEXP_1 = /^(\-|_)+(.)?/;
  var STRING_CLASSIFY_REGEXP_2 = /(.)(\-|\_|\.|\s)+(.)?/g;
  var STRING_CLASSIFY_REGEXP_3 = /(^|\/|\.)([a-z])/g;

  var CLASSIFY_CACHE = new _emberMetalCache.default(1000, function (str) {
    var replace1 = function (match, separator, chr) {
      return chr ? '_' + chr.toUpperCase() : '';
    };
    var replace2 = function (match, initialChar, separator, chr) {
      return initialChar + (chr ? chr.toUpperCase() : '');
    };
    var parts = str.split('/');
    for (var i = 0; i < parts.length; i++) {
      parts[i] = parts[i].replace(STRING_CLASSIFY_REGEXP_1, replace1).replace(STRING_CLASSIFY_REGEXP_2, replace2);
    }
    return parts.join('/').replace(STRING_CLASSIFY_REGEXP_3, function (match, separator, chr) {
      return match.toUpperCase();
    });
  });

  var STRING_UNDERSCORE_REGEXP_1 = /([a-z\d])([A-Z]+)/g;
  var STRING_UNDERSCORE_REGEXP_2 = /\-|\s+/g;

  var UNDERSCORE_CACHE = new _emberMetalCache.default(1000, function (str) {
    return str.replace(STRING_UNDERSCORE_REGEXP_1, '$1_$2').replace(STRING_UNDERSCORE_REGEXP_2, '_').toLowerCase();
  });

  var STRING_CAPITALIZE_REGEXP = /(^|\/)([a-z])/g;

  var CAPITALIZE_CACHE = new _emberMetalCache.default(1000, function (str) {
    return str.replace(STRING_CAPITALIZE_REGEXP, function (match, separator, chr) {
      return match.toUpperCase();
    });
  });

  var STRING_DECAMELIZE_REGEXP = /([a-z\d])([A-Z])/g;

  var DECAMELIZE_CACHE = new _emberMetalCache.default(1000, function (str) {
    return str.replace(STRING_DECAMELIZE_REGEXP, '$1_$2').toLowerCase();
  });

  function _fmt(str, formats) {
    var cachedFormats = formats;

    if (!_emberRuntimeUtils.isArray(cachedFormats) || arguments.length > 2) {
      cachedFormats = new Array(arguments.length - 1);

      for (var i = 1; i < arguments.length; i++) {
        cachedFormats[i - 1] = arguments[i];
      }
    }

    // first, replace any ORDERED replacements.
    var idx = 0; // the current index for non-numerical replacements
    return str.replace(/%@([0-9]+)?/g, function (s, argIndex) {
      argIndex = argIndex ? parseInt(argIndex, 10) - 1 : idx++;
      s = cachedFormats[argIndex];
      return s === null ? '(null)' : s === undefined ? '' : _emberMetalUtils.inspect(s);
    });
  }

  function fmt(str, formats) {
    return _fmt.apply(undefined, arguments);
  }

  function loc(str, formats) {
    if (!_emberRuntimeUtils.isArray(formats) || arguments.length > 2) {
      formats = Array.prototype.slice.call(arguments, 1);
    }

    str = _emberRuntimeString_registry.get(str) || str;
    return _fmt(str, formats);
  }

  function w(str) {
    return str.split(/\s+/);
  }

  function decamelize(str) {
    return DECAMELIZE_CACHE.get(str);
  }

  function dasherize(str) {
    return STRING_DASHERIZE_CACHE.get(str);
  }

  function camelize(str) {
    return CAMELIZE_CACHE.get(str);
  }

  function classify(str) {
    return CLASSIFY_CACHE.get(str);
  }

  function underscore(str) {
    return UNDERSCORE_CACHE.get(str);
  }

  function capitalize(str) {
    return CAPITALIZE_CACHE.get(str);
  }

  /**
    Defines string helper methods including string formatting and localization.
    Unless `EmberENV.EXTEND_PROTOTYPES.String` is `false` these methods will also be
    added to the `String.prototype` as well.
  
    @class String
    @namespace Ember
    @static
    @public
  */
  exports.default = {
    /**
      Apply formatting options to the string. This will look for occurrences
      of "%@" in your string and substitute them with the arguments you pass into
      this method. If you want to control the specific order of replacement,
      you can add a number after the key as well to indicate which argument
      you want to insert.
       Ordered insertions are most useful when building loc strings where values
      you need to insert may appear in different orders.
       ```javascript
      "Hello %@ %@".fmt('John', 'Doe');     // "Hello John Doe"
      "Hello %@2, %@1".fmt('John', 'Doe');  // "Hello Doe, John"
      ```
       @method fmt
      @param {String} str The string to format
      @param {Array} formats An array of parameters to interpolate into string.
      @return {String} formatted string
      @public
      @deprecated Use ES6 template strings instead: http://babeljs.io/docs/learn-es2015/#template-strings
    */
    fmt: fmt,

    /**
      Formats the passed string, but first looks up the string in the localized
      strings hash. This is a convenient way to localize text. See
      `Ember.String.fmt()` for more information on formatting.
       Note that it is traditional but not required to prefix localized string
      keys with an underscore or other character so you can easily identify
      localized strings.
       ```javascript
      Ember.STRINGS = {
        '_Hello World': 'Bonjour le monde',
        '_Hello %@ %@': 'Bonjour %@ %@'
      };
       Ember.String.loc("_Hello World");  // 'Bonjour le monde';
      Ember.String.loc("_Hello %@ %@", ["John", "Smith"]);  // "Bonjour John Smith";
      ```
       @method loc
      @param {String} str The string to format
      @param {Array} formats Optional array of parameters to interpolate into string.
      @return {String} formatted string
      @public
    */
    loc: loc,

    /**
      Splits a string into separate units separated by spaces, eliminating any
      empty strings in the process. This is a convenience method for split that
      is mostly useful when applied to the `String.prototype`.
       ```javascript
      Ember.String.w("alpha beta gamma").forEach(function(key) {
        console.log(key);
      });
       // > alpha
      // > beta
      // > gamma
      ```
       @method w
      @param {String} str The string to split
      @return {Array} array containing the split strings
      @public
    */
    w: w,

    /**
      Converts a camelized string into all lower case separated by underscores.
       ```javascript
      'innerHTML'.decamelize();           // 'inner_html'
      'action_name'.decamelize();        // 'action_name'
      'css-class-name'.decamelize();     // 'css-class-name'
      'my favorite items'.decamelize();  // 'my favorite items'
      ```
       @method decamelize
      @param {String} str The string to decamelize.
      @return {String} the decamelized string.
      @public
    */
    decamelize: decamelize,

    /**
      Replaces underscores, spaces, or camelCase with dashes.
       ```javascript
      'innerHTML'.dasherize();          // 'inner-html'
      'action_name'.dasherize();        // 'action-name'
      'css-class-name'.dasherize();     // 'css-class-name'
      'my favorite items'.dasherize();  // 'my-favorite-items'
      'privateDocs/ownerInvoice'.dasherize(); // 'private-docs/owner-invoice'
      ```
       @method dasherize
      @param {String} str The string to dasherize.
      @return {String} the dasherized string.
      @public
    */
    dasherize: dasherize,

    /**
      Returns the lowerCamelCase form of a string.
       ```javascript
      'innerHTML'.camelize();          // 'innerHTML'
      'action_name'.camelize();        // 'actionName'
      'css-class-name'.camelize();     // 'cssClassName'
      'my favorite items'.camelize();  // 'myFavoriteItems'
      'My Favorite Items'.camelize();  // 'myFavoriteItems'
      'private-docs/owner-invoice'.camelize(); // 'privateDocs/ownerInvoice'
      ```
       @method camelize
      @param {String} str The string to camelize.
      @return {String} the camelized string.
      @public
    */
    camelize: camelize,

    /**
      Returns the UpperCamelCase form of a string.
       ```javascript
      'innerHTML'.classify();          // 'InnerHTML'
      'action_name'.classify();        // 'ActionName'
      'css-class-name'.classify();     // 'CssClassName'
      'my favorite items'.classify();  // 'MyFavoriteItems'
      'private-docs/owner-invoice'.classify(); // 'PrivateDocs/OwnerInvoice'
      ```
       @method classify
      @param {String} str the string to classify
      @return {String} the classified string
      @public
    */
    classify: classify,

    /**
      More general than decamelize. Returns the lower\_case\_and\_underscored
      form of a string.
       ```javascript
      'innerHTML'.underscore();          // 'inner_html'
      'action_name'.underscore();        // 'action_name'
      'css-class-name'.underscore();     // 'css_class_name'
      'my favorite items'.underscore();  // 'my_favorite_items'
      'privateDocs/ownerInvoice'.underscore(); // 'private_docs/owner_invoice'
      ```
       @method underscore
      @param {String} str The string to underscore.
      @return {String} the underscored string.
      @public
    */
    underscore: underscore,

    /**
      Returns the Capitalized form of a string
       ```javascript
      'innerHTML'.capitalize()         // 'InnerHTML'
      'action_name'.capitalize()       // 'Action_name'
      'css-class-name'.capitalize()    // 'Css-class-name'
      'my favorite items'.capitalize() // 'My favorite items'
      'privateDocs/ownerInvoice'.capitalize(); // 'PrivateDocs/ownerInvoice'
      ```
       @method capitalize
      @param {String} str The string to capitalize.
      @return {String} The capitalized string.
      @public
    */
    capitalize: capitalize
  };
  exports.fmt = fmt;
  exports.loc = loc;
  exports.w = w;
  exports.decamelize = decamelize;
  exports.dasherize = dasherize;
  exports.camelize = camelize;
  exports.classify = classify;
  exports.underscore = underscore;
  exports.capitalize = capitalize;
})(Em._e[181],Em._e[0],Em._e[7],Em._e[91],Em._e[180],Em._e[28]);
(function (exports, _emberHtmlbarsHelper, _emberRuntimeSystemString) {
  'use strict';

  /**
  @module ember
  @submodule ember-templates
  */

  /**
    Calls [Ember.String.loc](/api/classes/Ember.String.html#method_loc) with the
    provided string. This is a convenient way to localize text within a template.
    For example:
  
    ```javascript
    Ember.STRINGS = {
      '_welcome_': 'Bonjour'
    };
    ```
  
    ```handlebars
    <div class='message'>
      {{loc '_welcome_'}}
    </div>
    ```
  
    ```html
    <div class='message'>
      Bonjour
    </div>
    ```
  
    See [Ember.String.loc](/api/classes/Ember.String.html#method_loc) for how to
    set up localized string references.
  
    @method loc
    @for Ember.Templates.helpers
    @param {String} str The string to format.
    @see {Ember.String#loc}
    @public
  */
  function locHelper(params) {
    return _emberRuntimeSystemString.loc.apply(null, params);
  }

  exports.default = _emberHtmlbarsHelper.helper(locHelper);
})(Em._e[182],Em._e[179],Em._e[181]);
(function (exports, _emberConsole) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = logHelper;

  /**
    `log` allows you to output the value of variables in the current rendering
    context. `log` also accepts primitive types such as strings or numbers.
  
    ```handlebars
    {{log "myVariable:" myVariable }}
    ```
  
    @method log
    @for Ember.Templates.helpers
    @param {*} values
    @public
  */

  function logHelper(values) {
    _emberConsole.default.log.apply(null, values);
  }
})(Em._e[183],Em._e[5]);
(function (exports, _emberMetalProperty_get, _emberMetalUtils) {
  'use strict';

  exports.default = decodeEachKey;

  function identity(item) {
    var key = undefined;
    var type = typeof item;

    if (type === 'string' || type === 'number') {
      key = item;
    } else {
      key = _emberMetalUtils.guidFor(item);
    }

    return key;
  }

  function decodeEachKey(item, keyPath, index) {
    var key = undefined;

    switch (keyPath) {
      case '@index':
        key = index;
        break;
      case '@identity':
        key = identity(item);
        break;
      default:
        if (keyPath) {
          key = _emberMetalProperty_get.get(item, keyPath);
        } else {
          key = identity(item);
        }
    }

    if (typeof key === 'number') {
      key = String(key);
    }

    return key;
  }
})(Em._e[184],Em._e[30],Em._e[7]);
(function (exports, _emberHtmlbarsStreamsShould_display, _emberHtmlbarsUtilsDecodeEachKey) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = eachHelper;

  /**
    The `{{#each}}` helper loops over elements in a collection. It is an extension
    of the base Handlebars `{{#each}}` helper.
  
    The default behavior of `{{#each}}` is to yield its inner block once for every
    item in an array passing the item as the first block parameter.
  
    ```javascript
    var developers = [{ name: 'Yehuda' },{ name: 'Tom' }, { name: 'Paul' }];
    ```
  
    ```handlebars
    {{#each developers key="name" as |person|}}
      {{person.name}}
      {{! `this` is whatever it was outside the #each }}
    {{/each}}
    ```
  
    The same rules apply to arrays of primitives.
  
    ```javascript
    var developerNames = ['Yehuda', 'Tom', 'Paul']
    ```
  
    ```handlebars
    {{#each developerNames key="@index" as |name|}}
      {{name}}
    {{/each}}
    ```
  
    During iteration, the index of each item in the array is provided as a second block parameter.
  
    ```handlebars
    <ul>
      {{#each people as |person index|}}
        <li>Hello, {{person.name}}! You're number {{index}} in line</li>
      {{/each}}
    </ul>
    ```
  
    ### Specifying Keys
  
    The `key` option is used to tell Ember how to determine if the array being
    iterated over with `{{#each}}` has changed between renders. By helping Ember
    detect that some elements in the array are the same, DOM elements can be
    re-used, significantly improving rendering speed.
  
    For example, here's the `{{#each}}` helper with its `key` set to `id`:
  
    ```handlebars
    {{#each model key="id" as |item|}}
    {{/each}}
    ```
  
    When this `{{#each}}` re-renders, Ember will match up the previously rendered
    items (and reorder the generated DOM elements) based on each item's `id`
    property.
  
    By default the item's own reference is used.
  
    ### {{else}} condition
  
    `{{#each}}` can have a matching `{{else}}`. The contents of this block will render
    if the collection is empty.
  
    ```handlebars
    {{#each developers as |person|}}
      {{person.name}}
    {{else}}
      <p>Sorry, nobody is available for this task.</p>
    {{/each}}
    ```
  
    @method each
    @for Ember.Templates.helpers
    @public
  */

  function eachHelper(params, hash, blocks) {
    var list = params[0];
    var keyPath = hash.key;

    if (_emberHtmlbarsStreamsShould_display.default(list)) {
      forEach(list, function (item, i) {
        var key = _emberHtmlbarsUtilsDecodeEachKey.default(item, keyPath, i);

        blocks.template.yieldItem(key, [item, i]);
      });
    } else if (blocks.inverse.yield) {
      blocks.inverse.yield();
    }
  }

  function forEach(iterable, cb) {
    return iterable.forEach ? iterable.forEach(cb) : Array.prototype.forEach.call(iterable, cb);
  }
})(Em._e[185],Em._e[176],Em._e[184]);
(function (exports, _emberHtmlbarsStreamsShould_display) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = eachInHelper;

  /**
    The `{{each-in}}` helper loops over properties on an object. It is unbound,
    in that new (or removed) properties added to the target object will not be
    rendered.
  
    For example, given a `user` object that looks like:
  
    ```javascript
    {
      "name": "Shelly Sails",
      "age": 42
    }
    ```
  
    This template would display all properties on the `user`
    object in a list:
  
    ```handlebars
    <ul>
    {{#each-in user as |key value|}}
      <li>{{key}}: {{value}}</li>
    {{/each-in}}
    </ul>
    ```
  
    Outputting their name and age.
  
    @method each-in
    @for Ember.Templates.helpers
    @public
    @since 2.1.0
  */

  function eachInHelper(_ref, hash, blocks) {
    var object = _ref[0];

    var objKeys = undefined,
        prop = undefined;
    objKeys = object ? Object.keys(object) : [];
    if (_emberHtmlbarsStreamsShould_display.default(objKeys)) {
      for (var i = 0; i < objKeys.length; i++) {
        prop = objKeys[i];
        blocks.template.yieldItem(prop, [prop, object[prop]]);
      }
    } else if (blocks.inverse.yield) {
      blocks.inverse.yield();
    }
  }
})(Em._e[186],Em._e[176]);
(function (exports, _emberRuntimeSystemString, _emberMetalPath_cache) {
  'use strict';

  exports.default = normalizeClass;

  /*
    This private helper is used by ComponentNode to convert the classNameBindings
    microsyntax into a class name.
  
    When a component or view is created, we normalize class name bindings into a
    series of attribute nodes that use this helper.
  
    @private
  */

  function normalizeClass(params, hash) {
    var propName = params[0];
    var value = params[1];
    var activeClass = hash.activeClass;
    var inactiveClass = hash.inactiveClass;

    // When using the colon syntax, evaluate the truthiness or falsiness
    // of the value to determine which className to return.
    if (activeClass || inactiveClass) {
      if (!!value) {
        return activeClass;
      } else {
        return inactiveClass;
      }

      // If value is a Boolean and true, return the dasherized property
      // name.
    } else if (value === true) {
        // Only apply to last segment in the path.
        if (propName && _emberMetalPath_cache.isPath(propName)) {
          var segments = propName.split('.');
          propName = segments[segments.length - 1];
        }

        return _emberRuntimeSystemString.dasherize(propName);

        // If the value is not false, undefined, or null, return the current
        // value of the property.
      } else if (value !== false && value != null) {
          return value;

          // Nothing to display. Return null so that the old class is removed
          // but no new class is added.
        } else {
            return null;
          }
  }
})(Em._e[187],Em._e[181],Em._e[29]);
(function (exports) {
  /**
  @module ember
  @submodule ember-templates
  */

  /**
    Concatenates input params together.
    Example:
    ```handlebars
    {{some-component name=(concat firstName " " lastName)}}
    {{! would pass name="<first name value> <last name value>" to the component}}
    ```
    @public
    @method concat
    @for Ember.Templates.helpers
    @since 1.13.0
  */
  'use strict';

  exports.default = concat;

  function concat(params) {
    return params.join('');
  }
})(Em._e[188]);
(function (exports) {
  /*
    This private helper is used to join and compact a list of class names.
  
    @private
  */

  'use strict';

  exports.default = joinClasses;

  function joinClasses(classNames) {
    var result = [];

    for (var i = 0; i < classNames.length; i++) {
      var className = classNames[i];

      if (className) {
        result.push(className);
      }
    }

    return result.join(' ');
  }
})(Em._e[189]);
(function (exports, _htmlbarsUtilSafeString) {
  'use strict';

  exports.default = htmlSafeHelper;

  /**
   This private helper is used internally to handle `isVisible: false` for
   Ember.View and Ember.Component.
  
   @private
   */

  function htmlSafeHelper(_ref) {
    var value = _ref[0];

    return new _htmlbarsUtilSafeString.default(value);
  }
})(Em._e[190],Em._e[164]);
(function (exports) {
   /**
   @module ember
   @submodule ember-templates
   */

   /**
      Use the `{{hash}}` helper to create a hash to pass as an option to your
      components. This is specially useful for contextual components where you can
      just yield a hash:
      ```handlebars
      {{yield (hash
         name='Sarah'
         title=office
      )}}
      ```
      Would result in an object such as:
      ```js
      { name: 'Sarah', title: this.get('office') }
      ```
      Where the `title` is bound to updates of the `office` property.
      @method hash
      @for Ember.Templates.helpers
      @param {Object} options
      @return {Object} Hash
      @public
    */

   "use strict";

   exports.default = hashHelper;

   function hashHelper(params, hash, options) {
      return hash;
   }
})(Em._e[191]);
(function (exports, _emberRuntimeSystemObject) {
  'use strict';

  exports.default = _emberRuntimeSystemObject.default.extend({
    isQueryParams: true,
    values: null
  });
})(Em._e[192],Em._e[77]);
(function (exports, _emberMetalDebug, _emberRoutingSystemQuery_params) {
  /**
  @module ember
  @submodule ember-htmlbars
  */

  'use strict';

  exports.default = queryParamsHelper;

  /**
    This is a helper to be used in conjunction with the link-to helper.
    It will supply url query parameters to the target route.
  
    Example
  
    ```handlebars
    {{#link-to 'posts' (query-params direction="asc")}}Sort{{/link-to}}
    ```
  
    @method query-params
    @for Ember.Templates.helpers
    @param {Object} hash takes a hash of query parameters
    @return {Object} A `QueryParams` object for `{{link-to}}`
    @public
  */

  function queryParamsHelper(params, hash) {

    return _emberRoutingSystemQuery_params.default.create({
      values: hash
    });
  }
})(Em._e[193],Em._e[0],Em._e[192]);
(function (exports, _htmlbarsRuntimeHooks) {
  'use strict';

  exports.default = template;

  function template(templateSpec) {
    if (!templateSpec.render) {
      templateSpec = _htmlbarsRuntimeHooks.wrap(templateSpec);
    }

    templateSpec.isTop = true;
    templateSpec.isMethod = false;

    return templateSpec;
  }
})(Em._e[194],Em._e[46]);
(function (exports, _emberMetalCore, _emberHtmlbarsHelpers, _emberHtmlbarsHelpersIf_unless, _emberHtmlbarsHelpersWith, _emberHtmlbarsHelpersLoc, _emberHtmlbarsHelpersLog, _emberHtmlbarsHelpersEach, _emberHtmlbarsHelpersEachIn, _emberHtmlbarsHelpersNormalizeClass, _emberHtmlbarsHelpersConcat, _emberHtmlbarsHelpersJoinClasses, _emberHtmlbarsHelpersHtmlSafe, _emberHtmlbarsHelpersHash, _emberHtmlbarsHelpersQueryParams, _emberHtmlbarsSystemDomHelper, _emberHtmlbarsSystemTemplate) {
  /**
    Ember templates are executed by [HTMLBars](https://github.com/tildeio/htmlbars),
    an HTML-friendly version of [Handlebars](http://handlebarsjs.com/). Any valid Handlebars syntax is valid in an Ember template.
  
    ### Showing a property
  
    Templates manage the flow of an application's UI, and display state (through
    the DOM) to a user. For example, given a component with the property "name",
    that component's template can use the name in several ways:
  
    ```javascript
    // app/components/person.js
    export default Ember.Component.extend({
      name: 'Jill'
    });
    ```
  
    ```handlebars
    {{! app/components/person.hbs }}
    {{name}}
    <div>{{name}}</div>
    <span data-name={{name}}></span>
    ```
  
    Any time the "name" property on the component changes, the DOM will be
    updated.
  
    Properties can be chained as well:
  
    ```handlebars
    {{aUserModel.name}}
    <div>{{listOfUsers.firstObject.name}}</div>
    ```
  
    ### Using Ember helpers
  
    When content is passed in mustaches `{{}}`, Ember will first try to find a helper
    or component with that name. For example, the `if` helper:
  
    ```handlebars
    {{if name "I have a name" "I have no name"}}
    <span data-has-name={{if name true}}></span>
    ```
  
    The returned value is placed where the `{{}}` is called. The above style is
    called "inline". A second style of helper usage is called "block". For example:
  
    ```handlebars
    {{#if name}}
      I have a name
    {{else}}
      I have no name
    {{/if}}
    ```
  
    The block form of helpers allows you to control how the UI is created based
    on the values of properties.
  
    A third form of helper is called "nested". For example here the concat
    helper will add " Doe" to a displayed name if the person has no last name:
  
    ```handlebars
    <span data-name={{concat firstName (
     if lastName (concat " " lastName) "Doe"
    )}}></span>
    ```
  
    Ember's built-in helpers are described under the [Ember.Templates.helpers](/api/classes/Ember.Templates.helpers.html)
    namespace. Documentation on creating custom helpers can be found under
    [Ember.Helper](/api/classes/Ember.Helper.html).
  
    ### Invoking a Component
  
    Ember components represent state to the UI of an application. Further
    reading on components can be found under [Ember.Component](/api/classes/Ember.Component.html).
  
    @module ember
    @submodule ember-templates
    @main ember-templates
    @public
  */

  /**
  
    [HTMLBars](https://github.com/tildeio/htmlbars) is a [Handlebars](http://handlebarsjs.com/)
    compatible templating engine used by Ember.js. The classes and namespaces
    covered by this documentation attempt to focus on APIs for interacting
    with HTMLBars itself. For more general guidance on Ember.js templates and
    helpers, please see the [ember-templates](/api/modules/ember-templates.html)
    package.
  
    @module ember
    @submodule ember-htmlbars
    @main ember-htmlbars
    @public
  */
  'use strict';

  exports.template = _emberHtmlbarsSystemTemplate.default;

  _emberHtmlbarsHelpers.registerHelper('if', _emberHtmlbarsHelpersIf_unless.ifHelper);
  _emberHtmlbarsHelpers.registerHelper('unless', _emberHtmlbarsHelpersIf_unless.unlessHelper);
  _emberHtmlbarsHelpers.registerHelper('with', _emberHtmlbarsHelpersWith.default);
  _emberHtmlbarsHelpers.registerHelper('loc', _emberHtmlbarsHelpersLoc.default);
  _emberHtmlbarsHelpers.registerHelper('log', _emberHtmlbarsHelpersLog.default);
  _emberHtmlbarsHelpers.registerHelper('each', _emberHtmlbarsHelpersEach.default);
  _emberHtmlbarsHelpers.registerHelper('each-in', _emberHtmlbarsHelpersEachIn.default);
  _emberHtmlbarsHelpers.registerHelper('-normalize-class', _emberHtmlbarsHelpersNormalizeClass.default);
  _emberHtmlbarsHelpers.registerHelper('concat', _emberHtmlbarsHelpersConcat.default);
  _emberHtmlbarsHelpers.registerHelper('-join-classes', _emberHtmlbarsHelpersJoinClasses.default);
  _emberHtmlbarsHelpers.registerHelper('-html-safe', _emberHtmlbarsHelpersHtmlSafe.default);
  _emberHtmlbarsHelpers.registerHelper('hash', _emberHtmlbarsHelpersHash.default);
  _emberHtmlbarsHelpers.registerHelper('query-params', _emberHtmlbarsHelpersQueryParams.default);

  _emberMetalCore.default.HTMLBars = {
    DOMHelper: _emberHtmlbarsSystemDomHelper.default
  };
})(Em._e[195],Em._e[85],Em._e[158],Em._e[177],Em._e[178],Em._e[182],Em._e[183],Em._e[185],Em._e[186],Em._e[187],Em._e[188],Em._e[189],Em._e[190],Em._e[191],Em._e[193],Em._e[173],Em._e[194]);
(function (exports, _emberHtmlbars) {
  "use strict";

  exports.default = _emberHtmlbars.template((function () {
    return {
      meta: {},
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["content", "outlet", ["loc", [null, [1, 0], [1, 10]]], 0, 0, 0, 0]],
      locals: [],
      templates: []
    };
  })());
})(Em._e[196],Em._e[195]);
(function (exports) {
  "use strict";

  exports.default = "2.9.0-alpha+20de5413";
})(Em._e[197]);
(function (exports, _emberHtmlbarsNodeManagersViewNodeManager, _emberHtmlbarsTemplatesTopLevelView, _emberMetalFeatures, _emberVersion) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.isOutletStable = isOutletStable;

  if (!false) {
    _emberHtmlbarsTemplatesTopLevelView.default.meta.revision = 'Ember@' + _emberVersion.default;
  }

  /**
    The `{{outlet}}` helper lets you specify where a child route will render in
    your template. An important use of the `{{outlet}}` helper is in your
    application's `application.hbs` file:
  
    ```handlebars
    {{! app/templates/application.hbs }}
  
    <!-- header content goes here, and will always display -->
    {{my-header}}
  
    <div class="my-dynamic-content">
      <!-- this content will change based on the current route, which depends on the current URL -->
      {{outlet}}
    </div>
  
    <!-- footer content goes here, and will always display -->
    {{my-footer}}
    ```
  
    See [templates guide](http://emberjs.com/guides/templates/the-application-template/) for
    additional information on using `{{outlet}}` in `application.hbs`.
  
    You may also specify a name for the `{{outlet}}`, which is useful when using more than one
    `{{outlet}}` in a template:
  
    ```handlebars
    {{outlet "menu"}}
    {{outlet "sidebar"}}
    {{outlet "main"}}
    ```
  
    Your routes can then render into a specific one of these `outlet`s by specifying the `outlet`
    attribute in your `renderTemplate` function:
  
    ```javascript
    // app/routes/menu.js
  
    export default Ember.Route.extend({
      renderTemplate() {
        this.render({ outlet: 'menu' });
      }
    });
    ```
  
    See the [routing guide](http://emberjs.com/guides/routing/rendering-a-template/) for more
    information on how your `route` interacts with the `{{outlet}}` helper.
  
    Note: Your content __will not render__ if there isn't an `{{outlet}}` for it.
  
    @method outlet
    @param {String} [name]
    @for Ember.Templates.helpers
    @public
  */
  exports.default = {
    willRender: function (renderNode, env) {
      env.view.ownerView._outlets.push(renderNode);
    },

    setupState: function (state, env, scope, params, hash) {
      var outletState = env.outletState;
      var read = env.hooks.getValue;
      var outletName = read(params[0]) || 'main';
      var selectedOutletState = outletState[outletName];

      return {
        outletState: selectedOutletState,
        hasParentOutlet: env.hasParentOutlet,
        manager: state.manager
      };
    },

    childEnv: function (state, env) {
      var outletState = state.outletState;
      var toRender = outletState && outletState.render;
      var meta = toRender && toRender.template && toRender.template.meta;

      var childEnv = env.childWithOutletState(outletState && outletState.outlets, true, meta);

      if (true) {
        var owner = outletState && outletState.render && outletState.render.owner;
        if (owner && owner !== childEnv.owner) {
          childEnv.originalOwner = childEnv.owner;
          childEnv.owner = owner;
        }
      }

      return childEnv;
    },

    isStable: function (lastState, nextState) {
      return isOutletStable(lastState.outletState, nextState.outletState);
    },

    isEmpty: function (state) {
      return isOutletEmpty(state.outletState);
    },

    render: function (renderNode, env, scope, params, hash, _template, inverse, visitor) {
      var state = renderNode.getState();
      var owner = env.owner;
      var parentView = env.view;
      var outletState = state.outletState;
      var toRender = outletState.render;

      var ViewClass = outletState.render.ViewClass;

      if (true) {
        owner = env.originalOwner || owner;
      }

      if (!state.hasParentOutlet && !ViewClass) {
        ViewClass = owner._lookupFactory('view:toplevel');
      }

      var attrs = {};
      var options = {
        component: ViewClass,
        self: toRender.controller,
        createOptions: {
          controller: toRender.controller
        }
      };

      var template = _template || toRender.template && toRender.template.raw;

      if (state.manager) {
        state.manager.destroy();
        state.manager = null;
      }

      if (true) {
        // detect if we are crossing into an engine
        if (env.originalOwner) {
          // when this outlet represents an engine we must ensure that a `ViewClass` is present
          // even if the engine does not contain a `view:application`. We need a `ViewClass` to
          // ensure that an `ownerView` is set on the `env` created just above
          options.component = options.component || owner._lookupFactory('view:toplevel');
        }
      }

      var nodeManager = _emberHtmlbarsNodeManagersViewNodeManager.default.create(renderNode, env, attrs, options, parentView, null, null, template);
      state.manager = nodeManager;

      nodeManager.render(env, hash, visitor);
    }
  };

  function isOutletEmpty(outletState) {
    return !outletState || !outletState.render.ViewClass && !outletState.render.template;
  }

  function isOutletStable(a, b) {
    if (!a && !b) {
      return true;
    }
    if (!a || !b) {
      return false;
    }
    a = a.render;
    b = b.render;
    for (var key in a) {
      if (a.hasOwnProperty(key)) {
        // Name is only here for logging & debugging. If two different
        // names result in otherwise identical states, they're still
        // identical.
        if (a[key] !== b[key] && key !== 'name') {
          return false;
        }
      }
    }
    return true;
  }
})(Em._e[198],Em._e[133],Em._e[196],Em._e[10],Em._e[197]);
(function (exports, _emberMetalDebug, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = unbound;

  /**
    The `{{unbound}}` helper disconnects the one-way binding of a property,
    essentially freezing its value at the moment of rendering. For example,
    in this example the display of the variable `name` will not change even
    if it is set with a new value:
  
    ```handlebars
    {{unbound name}}
    ```
  
    Like any helper, the `unbound` helper can accept a nested helper expression.
    This allows for custom helpers to be rendered unbound:
  
    ```handlebars
    {{unbound (some-custom-helper)}}
    {{unbound (capitalize name)}}
    {{! You can use any helper, including unbound, in a nested expression }}
    {{capitalize (unbound name)}}
    ```
  
    The `unbound` helper only accepts a single argument, and it return an
    unbound value.
  
    @method unbound
    @for Ember.Templates.helpers
    @public
  */

  var VolatileStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (source) {
      this.label = '(volatile ' + source.label + ')';
      this.source = source;
      this.addDependency(source);
    },

    value: function () {
      return _emberHtmlbarsStreamsUtils.read(this.source);
    },

    notify: function () {}
  });

  function unbound(morph, env, scope, params, hash, template, inverse, visitor) {

    if (morph === null) {
      return new VolatileStream(params[0]);
    }

    var stream = undefined;
    if (morph.linkedResult) {
      stream = morph.linkedResult;
    } else {
      stream = new VolatileStream(params[0]);
      morph.linkedResult = stream;
    }
    env.hooks.range(morph, env, scope, null, stream, visitor);
    return true;
  }
})(Em._e[199],Em._e[0],Em._e[56],Em._e[66]);
(function (exports, _htmlbarsRuntimeHooks, _emberHtmlbarsKeywordsClosureComponent, _emberMetalEmpty_object, _emberMetalAssign) {
  /**
    @module ember
    @submodule ember-templates
    @public
  */
  'use strict';

  /**
    The `{{component}}` helper lets you add instances of `Ember.Component` to a
    template. See [Ember.Component](/api/classes/Ember.Component.html) for
    additional information on how a `Component` functions.
    `{{component}}`'s primary use is for cases where you want to dynamically
    change which type of component is rendered as the state of your application
    changes. The provided block will be applied as the template for the component.
    Given an empty `<body>` the following template:
  
    ```handlebars
    {{! application.hbs }}
    {{component infographicComponentName}}
    ```
  
    And the following application code:
  
    ```javascript
    export default Ember.Controller.extend({
      infographicComponentName: computed('isMarketOpen', {
        get() {
          if (this.get('isMarketOpen')) {
            return 'live-updating-chart';
          } else {
            return 'market-close-summary';
          }
        }
      })
    });
    ```
  
    The `live-updating-chart` component will be appended when `isMarketOpen` is
    `true`, and the `market-close-summary` component will be appended when
    `isMarketOpen` is `false`. If the value changes while the app is running,
    the component will be automatically swapped out accordingly.
    Note: You should not use this helper when you are consistently rendering the same
    component. In that case, use standard component syntax, for example:
  
    ```handlebars
    {{! application.hbs }}
    {{live-updating-chart}}
    ```
  
    ## Nested Usage
  
    The `component` helper can be used to package a component path with initial attrs.
    The included attrs can then be merged during the final invocation.
  
    For example, given a `person-form` component with the following template:
  
    ```handlebars
    {{yield (hash
        nameInput=(component "my-input-component" value=model.name placeholder="First Name"))}}
    ```
  
    The following snippet:
  
    ```
    {{#person-form as |form|}}
      {{component form.nameInput placeholder="Username"}}
    {{/person-form}}
    ```
  
    would output an input whose value is already bound to `model.name` and `placeholder`
    is "Username".
  
    @method component
    @since 1.11.0
    @for Ember.Templates.helpers
    @public
  */

  exports.default = function (morph, env, scope, params, hash, template, inverse, visitor) {
    if (!morph) {
      return _emberHtmlbarsKeywordsClosureComponent.default(env, params, hash);
    }

    var newHash = _emberMetalAssign.default(new _emberMetalEmpty_object.default(), hash);

    _htmlbarsRuntimeHooks.keyword('@element_component', morph, env, scope, params, newHash, template, inverse, visitor);
    return true;
  };
})(Em._e[200],Em._e[46],Em._e[95],Em._e[12],Em._e[8]);
(function (exports, _emberMetalAssign, _emberHtmlbarsKeywordsClosureComponent, _emberViewsUtilsLookupComponent, _emberHtmlbarsUtilsExtractPositionalParams) {
  'use strict';

  exports.default = {
    setupState: function (lastState, env, scope, params, hash) {
      var componentPath = getComponentPath(params[0], env);
      return _emberMetalAssign.default({}, lastState, {
        componentPath: componentPath,
        isComponentHelper: true
      });
    },

    render: function (morph) {
      var state = morph.getState();

      if (state.manager) {
        state.manager.destroy();
      }

      // Force the component hook to treat this as a first-time render,
      // because normal components (`<foo-bar>`) cannot change at runtime,
      // but the `{{component}}` helper can.
      state.manager = null;

      for (var _len = arguments.length, rest = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        rest[_key - 1] = arguments[_key];
      }

      render.apply(undefined, [morph].concat(rest));
    },

    rerender: render
  };

  function getComponentPath(param, env) {
    var path = env.hooks.getValue(param);
    if (_emberHtmlbarsKeywordsClosureComponent.isComponentCell(path)) {
      path = path[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_PATH];
    }
    return path;
  }

  function render(morph, env, scope, _ref, hash, template, inverse, visitor) {
    var path = _ref[0];

    var params = _ref.slice(1);

    var isRerender = arguments.length <= 8 || arguments[8] === undefined ? false : arguments[8];

    var _morph$getState = morph.getState();

    var componentPath = _morph$getState.componentPath;

    // If the value passed to the {{component}} helper is undefined or null,
    // don't create a new ComponentNode.
    if (componentPath === undefined || componentPath === null) {
      return;
    }

    path = env.hooks.getValue(path);

    if (isRerender) {
      var result = _emberViewsUtilsLookupComponent.default(env.owner, componentPath);
      var component = result.component;

      _emberHtmlbarsUtilsExtractPositionalParams.default(null, component, params, hash);
    }

    if (_emberHtmlbarsKeywordsClosureComponent.isComponentCell(path)) {
      var closureComponent = env.hooks.getValue(path);

      // This needs to be done in each nesting level to avoid raising assertions
      _emberHtmlbarsKeywordsClosureComponent.processPositionalParamsFromCell(closureComponent, params, hash);
      hash = _emberHtmlbarsKeywordsClosureComponent.mergeInNewHash(closureComponent[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_HASH], hash, closureComponent[_emberHtmlbarsKeywordsClosureComponent.COMPONENT_POSITIONAL_PARAMS], params);
      params = [];
    }

    var templates = { default: template, inverse: inverse };
    env.hooks.component(morph, env, scope, componentPath, params, hash, templates, visitor);
  }
})(Em._e[201],Em._e[8],Em._e[95],Em._e[94],Em._e[93]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get) {
  'use strict';

  exports.generateControllerFactory = generateControllerFactory;
  exports.default = generateController;

  /**
  @module ember
  @submodule ember-routing
  */

  /**
    Generates a controller factory
  
    @for Ember
    @method generateControllerFactory
    @private
  */

  function generateControllerFactory(owner, controllerName, context) {
    var Factory = owner._lookupFactory('controller:basic').extend({
      isGenerated: true,
      toString: function () {
        return '(generated ' + controllerName + ' controller)';
      }
    });

    var fullName = 'controller:' + controllerName;

    owner.register(fullName, Factory);

    return Factory;
  }

  /**
    Generates and instantiates a controller.
  
    The type of the generated controller factory is derived
    from the context. If the context is an array an array controller
    is generated, if an object, an object controller otherwise, a basic
    controller is generated.
  
    @for Ember
    @method generateController
    @private
    @since 1.3.0
  */

  function generateController(owner, controllerName, context) {
    generateControllerFactory(owner, controllerName, context);

    var fullName = 'controller:' + controllerName;
    var instance = owner.lookup(fullName);

    if (_emberMetalProperty_get.get(instance, 'namespace.LOG_ACTIVE_GENERATION')) {}

    return instance;
  }
})(Em._e[202],Em._e[0],Em._e[30]);
(function (exports, _emberMetalDebug, _emberMetalEmpty_object, _emberMetalError, _emberHtmlbarsStreamsUtils, _emberRoutingSystemGenerate_controller, _emberHtmlbarsNodeManagersViewNodeManager) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.childOutletState = childOutletState;

  /**
    Calling ``{{render}}`` from within a template will insert another
    template that matches the provided name. The inserted template will
    access its properties on its own controller (rather than the controller
    of the parent template).
    If a view class with the same name exists, the view class also will be used.
    Note: A given controller may only be used *once* in your app in this manner.
    A singleton instance of the controller will be created for you.
    Example:
  
    ```javascript
    App.NavigationController = Ember.Controller.extend({
      who: "world"
    });
    ```
  
    ```handlebars
    <!-- navigation.hbs -->
    Hello, {{who}}.
    ```
  
    ```handlebars
    <!-- application.hbs -->
    <h1>My great app</h1>
    {{render "navigation"}}
    ```
  
    ```html
    <h1>My great app</h1>
    <div class='ember-view'>
      Hello, world.
    </div>
    ```
  
    Optionally you may provide a second argument: a property path
    that will be bound to the `model` property of the controller.
    If a `model` property path is specified, then a new instance of the
    controller will be created and `{{render}}` can be used multiple times
    with the same name.
  
    For example if you had this `author` template.
  
    ```handlebars
    <div class="author">
      Written by {{firstName}} {{lastName}}.
      Total Posts: {{postCount}}
    </div>
    ```
  
    You could render it inside the `post` template using the `render` helper.
  
    ```handlebars
    <div class="post">
      <h1>{{title}}</h1>
      <div>{{body}}</div>
      {{render "author" author}}
    </div>
    ```
  
    @method render
    @for Ember.Templates.helpers
    @param {String} name
    @param {Object?} context
    @param {Hash} options
    @return {String} HTML string
    @public
  */
  exports.default = {
    willRender: function (renderNode, env) {
      if (env.view.ownerView._outlets) {
        // We make sure we will get dirtied when outlet state changes.
        env.view.ownerView._outlets.push(renderNode);
      }
    },

    setupState: function (prevState, env, scope, params, hash) {
      var name = params[0];

      return {
        parentView: env.view,
        manager: prevState.manager,
        controller: prevState.controller,
        childOutletState: childOutletState(name, env)
      };
    },

    childEnv: function (state, env) {
      return env.childWithOutletState(state.childOutletState);
    },

    isStable: function (lastState, nextState) {
      return isStable(lastState.childOutletState, nextState.childOutletState);
    },

    isEmpty: function (state) {
      return false;
    },

    render: function (node, env, scope, params, hash, template, inverse, visitor) {
      var state = node.getState();
      var name = params[0];
      var context = params[1];

      var owner = env.owner;

      var router = owner.lookup('router:main');

      if (params.length === 1) {} else if (params.length !== 2) {
        throw new _emberMetalError.default('You must pass a templateName to render');
      }

      var templateName = 'template:' + name;

      if (!template) {
        template = owner.lookup(templateName);
      }

      // provide controller override
      var controllerName = undefined;
      var controllerFullName = undefined;

      if (hash.controller) {
        controllerName = hash.controller;
        controllerFullName = 'controller:' + controllerName;
        delete hash.controller;
      } else {
        controllerName = name;
        controllerFullName = 'controller:' + controllerName;
      }

      var target = router;
      var controller = undefined;

      // choose name
      if (params.length > 1) {
        var factory = owner._lookupFactory(controllerFullName) || _emberRoutingSystemGenerate_controller.generateControllerFactory(owner, controllerName);

        controller = factory.create({
          model: _emberHtmlbarsStreamsUtils.read(context),
          target: target
        });

        node.addDestruction(controller);
      } else {
        controller = owner.lookup(controllerFullName) || _emberRoutingSystemGenerate_controller.default(owner, controllerName);

        controller.setProperties({
          target: target
        });
      }

      state.controller = controller;

      if (template && template.raw) {
        template = template.raw;
      }

      var options = {
        layout: null,
        self: controller
      };

      var nodeManager = _emberHtmlbarsNodeManagersViewNodeManager.default.create(node, env, hash, options, state.parentView, null, null, template);
      state.manager = nodeManager;

      if (router && params.length === 1) {
        router._connectActiveComponentNode(name, nodeManager);
      }

      nodeManager.render(env, hash, visitor);
    },

    rerender: function (node, env, scope, params, hash, template, inverse, visitor) {
      if (params.length > 1) {
        var model = _emberHtmlbarsStreamsUtils.read(params[1]);
        node.getState().controller.set('model', model);
      }
    }
  };

  function childOutletState(name, env) {
    var topLevel = env.view.ownerView;
    if (!topLevel || !topLevel.outletState) {
      return;
    }

    var outletState = topLevel.outletState;
    if (!outletState.main) {
      return;
    }

    var selectedOutletState = outletState.main.outlets['__ember_orphans__'];
    if (!selectedOutletState) {
      return;
    }
    var matched = selectedOutletState.outlets[name];
    if (matched) {
      var childState = new _emberMetalEmpty_object.default();
      childState[matched.render.outlet] = matched;
      matched.wasUsed = true;
      return childState;
    }
  }

  function isStable(a, b) {
    if (!a && !b) {
      return true;
    }
    if (!a || !b) {
      return false;
    }
    for (var outletName in a) {
      if (!isStableOutlet(a[outletName], b[outletName])) {
        return false;
      }
    }
    return true;
  }

  function isStableOutlet(a, b) {
    if (!a && !b) {
      return true;
    }
    if (!a || !b) {
      return false;
    }
    a = a.render;
    b = b.render;
    for (var key in a) {
      if (a.hasOwnProperty(key)) {
        // name is only here for logging & debugging. If two different
        // names result in otherwise identical states, they're still
        // identical.
        if (a[key] !== b[key] && key !== 'name') {
          return false;
        }
      }
    }
    return true;
  }
})(Em._e[203],Em._e[0],Em._e[12],Em._e[31],Em._e[66],Em._e[202],Em._e[133]);
(function (exports, _emberHtmlbarsNodeManagersViewNodeManager, _emberHtmlbarsSystemRenderEnv, _emberMetalDebug, _containerOwner, _emberHtmlbarsKeywordsOutlet, _emberHtmlbarsKeywordsRender) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  /**
    The `{{mount}}` helper lets you embed a routeless engine in a template.
  
    Mounting an engine will cause an instance to be booted and its `application`
    template to be rendered.
  
    For example, the following template mounts the `ember-chat` engine:
  
    ```handlebars
    {{! application.hbs }}
    {{mount "ember-chat"}}
    ```
  
    Currently, the engine name is the only argument that can be passed to
    `{{mount}}`.
  
    @method mount
    @for Ember.Templates.helpers
    @category ember-application-engines
    @public
  */
  exports.default = {
    setupState: function (prevState, env, scope, params /*, hash */) {
      var name = params[0];

      var engineInstance = env.owner.buildChildEngineInstance(name);

      engineInstance.boot();

      var state = {
        parentView: env.view,
        manager: prevState.manager,
        controller: lookupEngineController(engineInstance),
        childOutletState: _emberHtmlbarsKeywordsRender.childOutletState(name, env)
      };

      _containerOwner.setOwner(state, engineInstance);

      return state;
    },

    childEnv: function (state, env) {
      return buildEnvForEngine(_containerOwner.getOwner(state), env);
    },

    isStable: function (lastState, nextState) {
      return isStable(lastState.childOutletState, nextState.childOutletState);
    },

    isEmpty: function () /* state */{
      return false;
    },

    render: function (node, env, scope, params, hash, template, inverse, visitor) {
      var state = node.getState();

      var engineInstance = _containerOwner.getOwner(state);

      var engineController = lookupEngineController(engineInstance);

      var engineTemplate = lookupEngineTemplate(engineInstance);

      var options = {
        layout: null,
        self: engineController
      };

      var engineEnv = buildEnvForEngine(engineInstance, env);

      var nodeManager = _emberHtmlbarsNodeManagersViewNodeManager.default.create(node, engineEnv, hash, options, state.parentView, null, null, engineTemplate);

      state.manager = nodeManager;

      nodeManager.render(engineEnv, hash, visitor);
    }
  };

  function isStable(a, b) {
    if (!a && !b) {
      return true;
    }
    if (!a || !b) {
      return false;
    }
    for (var outletName in a) {
      if (!_emberHtmlbarsKeywordsOutlet.isOutletStable(a[outletName], b[outletName])) {
        return false;
      }
    }
    return true;
  }

  function lookupEngineController(engineInstance) {
    return engineInstance.lookup('controller:application');
  }

  function lookupEngineView(engineInstance, ownerView) {
    var engineView = engineInstance.lookup('view:toplevel');

    if (engineView.ownerView !== ownerView) {
      engineView.ownerView = ownerView;
    }

    return engineView;
  }

  function lookupEngineTemplate(engineInstance) {
    var engineTemplate = engineInstance.lookup('template:application');

    if (engineTemplate && engineTemplate.raw) {
      engineTemplate = engineTemplate.raw;
    }

    return engineTemplate;
  }

  function buildEnvForEngine(engineInstance, parentEnv) {
    var engineView = lookupEngineView(engineInstance, parentEnv.view.ownerView);

    var engineTemplate = lookupEngineTemplate(engineInstance);

    var engineEnv = _emberHtmlbarsSystemRenderEnv.default.build(engineView, engineTemplate.meta);

    return engineEnv;
  }
})(Em._e[204],Em._e[133],Em._e[216],Em._e[0],Em._e[70],Em._e[198],Em._e[203]);
(function (exports, _emberMetalDebug, _emberMetalError) {
  'use strict';

  exports.default = lookupPartial;
  exports.hasPartial = hasPartial;

  function parseUnderscoredName(templateName) {
    var nameParts = templateName.split('/');
    var lastPart = nameParts[nameParts.length - 1];

    nameParts[nameParts.length - 1] = '_' + lastPart;

    return nameParts.join('/');
  }

  function lookupPartial(env, templateName) {
    if (templateName == null) {
      return;
    }

    var template = templateFor(env, parseUnderscoredName(templateName), templateName);

    return template;
  }

  function hasPartial(env, name) {
    if (!env.owner) {
      throw new _emberMetalError.default('Container was not found when looking up a views template. ' + 'This is most likely due to manually instantiating an Ember.View. ' + 'See: http://git.io/EKPpnA');
    }

    return env.owner.hasRegistration('template:' + parseUnderscoredName(name)) || env.owner.hasRegistration('template:' + name);
  }

  function templateFor(env, underscored, name) {
    if (!name) {
      return;
    }

    if (!env.owner) {
      throw new _emberMetalError.default('Container was not found when looking up a views template. ' + 'This is most likely due to manually instantiating an Ember.View. ' + 'See: http://git.io/EKPpnA');
    }

    return env.owner.lookup('template:' + underscored) || env.owner.lookup('template:' + name);
  }
})(Em._e[205],Em._e[0],Em._e[31]);
(function (exports, _emberViewsSystemLookup_partial, _htmlbarsRuntime) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  /**
    The `partial` helper renders another template without
    changing the template context:
  
    ```handlebars
    {{foo}}
    {{partial "nav"}}
    ```
  
    The above example template will render a template named
    "_nav", which has the same context as the parent template
    it's rendered into, so if the "_nav" template also referenced
    `{{foo}}`, it would print the same thing as the `{{foo}}`
    in the above example.
  
    If a "_nav" template isn't found, the `partial` helper will
    fall back to a template named "nav".
  
    ### Bound template names
  
    The parameter supplied to `partial` can also be a path
    to a property containing a template name, e.g.:
  
    ```handlebars
    {{partial someTemplateName}}
    ```
  
    The above example will look up the value of `someTemplateName`
    on the template context (e.g. a controller) and use that
    value as the name of the template to render. If the resolved
    value is falsy, nothing will be rendered. If `someTemplateName`
    changes, the partial will be re-rendered using the new template
    name.
  
  
    @method partial
    @for Ember.Templates.helpers
    @param {String} partialName The name of the template to render minus the leading underscore.
    @public
  */

  exports.default = {
    setupState: function (state, env, scope, params, hash) {
      return { partialName: env.hooks.getValue(params[0]) };
    },

    render: function (renderNode, env, scope, params, hash, template, inverse, visitor) {
      var state = renderNode.getState();
      if (!state.partialName) {
        return true;
      }
      var found = _emberViewsSystemLookup_partial.default(env, state.partialName);
      if (!found) {
        return true;
      }

      _htmlbarsRuntime.internal.hostBlock(renderNode, env, scope, found.raw, null, null, visitor, function (options) {
        options.templates.template.yield();
      });
    }
  };
})(Em._e[206],Em._e[205],Em._e[47]);
(function (exports, _emberMetalDebug, _emberMetalAssign) {
  /**
  @module ember
  @submodule ember-templates
  */
  'use strict';

  /**
    The `{{input}}` helper lets you create an HTML `<input />` component.
    It causes an `Ember.TextField` component to be rendered.  For more info,
    see the [Ember.TextField](/api/classes/Ember.TextField.html) docs and
    the [templates guide](http://emberjs.com/guides/templates/input-helpers/).
  
    ```handlebars
    {{input value="987"}}
    ```
  
    renders as:
  
    ```HTML
    <input type="text" value="987" />
    ```
  
    ### Text field
  
    If no `type` option is specified, a default of type 'text' is used.
  
    Many of the standard HTML attributes may be passed to this helper.
  
    <table>
      <tr><td>`readonly`</td><td>`required`</td><td>`autofocus`</td></tr>
      <tr><td>`value`</td><td>`placeholder`</td><td>`disabled`</td></tr>
      <tr><td>`size`</td><td>`tabindex`</td><td>`maxlength`</td></tr>
      <tr><td>`name`</td><td>`min`</td><td>`max`</td></tr>
      <tr><td>`pattern`</td><td>`accept`</td><td>`autocomplete`</td></tr>
      <tr><td>`autosave`</td><td>`formaction`</td><td>`formenctype`</td></tr>
      <tr><td>`formmethod`</td><td>`formnovalidate`</td><td>`formtarget`</td></tr>
      <tr><td>`height`</td><td>`inputmode`</td><td>`multiple`</td></tr>
      <tr><td>`step`</td><td>`width`</td><td>`form`</td></tr>
      <tr><td>`selectionDirection`</td><td>`spellcheck`</td><td>&nbsp;</td></tr>
    </table>
  
  
    When set to a quoted string, these values will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).
  
  
    A very common use of this helper is to bind the `value` of an input to an Object's attribute:
  
    ```handlebars
    Search:
    {{input value=searchWord}}
    ```
  
    In this example, the inital value in the `<input />` will be set to the value of `searchWord`.
    If the user changes the text, the value of `searchWord` will also be updated.
  
    ### Actions
    The helper can send multiple actions based on user events.
    The action property defines the action which is sent when
    the user presses the return key.
  
    ```handlebars
    {{input action="submit"}}
    ```
  
    The helper allows some user events to send actions.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
    * `key-up`
  
  
    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.
  
    ```handlebars
    {{input focus-out="alertMessage"}}
    ```
  
    See more about [Text Support Actions](/api/classes/Ember.TextField.html)
  
  
    ### Extending `Ember.TextField`
  
    Internally, `{{input type="text"}}` creates an instance of `Ember.TextField`, passing
    arguments from the helper to `Ember.TextField`'s `create` method. You can extend the
    capabilities of text inputs in your applications by reopening this class. For example,
    if you are building a Bootstrap project where `data-*` attributes are used, you
    can add one to the `TextField`'s `attributeBindings` property:
  
  
    ```javascript
    Ember.TextField.reopen({
      attributeBindings: ['data-error']
    });
    ```
  
    Keep in mind when writing `Ember.TextField` subclasses that `Ember.TextField`
    itself extends `Ember.Component`. Expect isolated component semantics, not
    legacy 1.x view semantics (like `controller` being present).
  
    See more about [Ember components](/api/classes/Ember.Component.html)
  
  
    ### Checkbox
  
    Checkboxes are special forms of the `{{input}}` helper.  To create a `<checkbox />`:
  
    ```handlebars
    Emberize Everything:
    {{input type="checkbox" name="isEmberized" checked=isEmberized}}
    ```
  
    This will bind checked state of this checkbox to the value of `isEmberized`  -- if either one changes,
    it will be reflected in the other.
  
  
    The following HTML attributes can be set via the helper:
  
    * `checked`
    * `disabled`
    * `tabindex`
    * `indeterminate`
    * `name`
    * `autofocus`
    * `form`
  
  
    ### Extending `Ember.Checkbox`
  
    Internally, `{{input type="checkbox"}}` creates an instance of `Ember.Checkbox`, passing
    arguments from the helper to `Ember.Checkbox`'s `create` method. You can extend the
    capablilties of checkbox inputs in your applications by reopening this class. For example,
    if you wanted to add a css class to all checkboxes in your application:
  
    ```javascript
    Ember.Checkbox.reopen({
      classNames: ['my-app-checkbox']
    });
    ```
  
  
    @method input
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
  */
  exports.default = {
    setupState: function (lastState, env, scope, params, hash) {
      var type = env.hooks.getValue(hash.type);
      var componentName = componentNameMap[type] || defaultComponentName;

      return _emberMetalAssign.default({}, lastState, { componentName: componentName });
    },

    render: function (morph, env, scope, params, hash, template, inverse, visitor) {
      env.hooks.component(morph, env, scope, morph.getState().componentName, params, hash, { default: template, inverse: inverse }, visitor);
    },

    rerender: function () {
      this.render.apply(this, arguments);
    }
  };

  var defaultComponentName = '-text-field';

  var componentNameMap = {
    'checkbox': '-checkbox'
  };
})(Em._e[207],Em._e[0],Em._e[8]);
(function (exports) {
  /**
  @module ember
  @submodule ember-templates
  */

  /**
    `{{textarea}}` inserts a new instance of `<textarea>` tag into the template.
    The attributes of `{{textarea}}` match those of the native HTML tags as
    closely as possible.
  
    The following HTML attributes can be set:
  
      * `value`
      * `name`
      * `rows`
      * `cols`
      * `placeholder`
      * `disabled`
      * `maxlength`
      * `tabindex`
      * `selectionEnd`
      * `selectionStart`
      * `selectionDirection`
      * `wrap`
      * `readonly`
      * `autofocus`
      * `form`
      * `spellcheck`
      * `required`
  
    When set to a quoted string, these value will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).
  
    Unbound:
  
    ```handlebars
    {{textarea value="Lots of static text that ISN'T bound"}}
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of static text that ISN'T bound
    </textarea>
    ```
  
    Bound:
  
    In the following example, the `writtenWords` property on `App.ApplicationController`
    will be updated live as the user types 'Lots of text that IS bound' into
    the text area of their browser's window.
  
    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound"
    });
    ```
  
    ```handlebars
    {{textarea value=writtenWords}}
    ```
  
     Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```
  
    If you wanted a one way binding between the text area and a div tag
    somewhere else on your screen, you could use `Ember.computed.oneWay`:
  
    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound",
      outputWrittenWords: Ember.computed.oneWay("writtenWords")
    });
    ```
  
    ```handlebars
    {{textarea value=writtenWords}}
  
    <div>
      {{outputWrittenWords}}
    </div>
    ```
  
    Would result in the following HTML:
  
    ```html
    <textarea class="ember-text-area">
      Lots of text that IS bound
    </textarea>
  
    <-- the following div will be updated in real time as you type -->
  
    <div>
      Lots of text that IS bound
    </div>
    ```
  
    Finally, this example really shows the power and ease of Ember when two
    properties are bound to eachother via `Ember.computed.alias`. Type into
    either text area box and they'll both stay in sync. Note that
    `Ember.computed.alias` costs more in terms of performance, so only use it when
    your really binding in both directions:
  
    ```javascript
    App.ApplicationController = Ember.Controller.extend({
      writtenWords: "Lots of text that IS bound",
      twoWayWrittenWords: Ember.computed.alias("writtenWords")
    });
    ```
  
    ```handlebars
    {{textarea value=writtenWords}}
    {{textarea value=twoWayWrittenWords}}
    ```
  
    ```html
    <textarea id="ember1" class="ember-text-area">
      Lots of text that IS bound
    </textarea>
  
    <-- both updated in real time -->
  
    <textarea id="ember2" class="ember-text-area">
      Lots of text that IS bound
    </textarea>
    ```
  
    ### Actions
  
    The helper can send multiple actions based on user events.
  
    The action property defines the action which is send when
    the user presses the return key.
  
    ```handlebars
    {{input action="submit"}}
    ```
  
    The helper allows some user events to send actions.
  
  * `enter`
  * `insert-newline`
  * `escape-press`
  * `focus-in`
  * `focus-out`
  * `key-press`
  
    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.
  
    ```handlebars
    {{textarea focus-in="alertMessage"}}
    ```
  
    See more about [Text Support Actions](/api/classes/Ember.TextArea.html)
  
    ### Extension
  
    Internally, `{{textarea}}` creates an instance of `Ember.TextArea`, passing
    arguments from the helper to `Ember.TextArea`'s `create` method. You can
    extend the capabilities of text areas in your application by reopening this
    class. For example, if you are building a Bootstrap project where `data-*`
    attributes are used, you can globally add support for a `data-*` attribute
    on all `{{textarea}}`s' in your app by reopening `Ember.TextArea` or
    `Ember.TextSupport` and adding it to the `attributeBindings` concatenated
    property:
  
    ```javascript
    Ember.TextArea.reopen({
      attributeBindings: ['data-error']
    });
    ```
  
    Keep in mind when writing `Ember.TextArea` subclasses that `Ember.TextArea`
    itself extends `Ember.Component`. Expect isolated component semantics, not
    legacy 1.x view semantics (like `controller` being present).
  
    See more about [Ember components](/api/classes/Ember.Component.html)
  
    @method textarea
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
  */
  'use strict';

  exports.default = textarea;

  function textarea(morph, env, scope, originalParams, hash, template, inverse, visitor) {
    env.hooks.component(morph, env, scope, '-text-area', originalParams, hash, { default: template, inverse: inverse }, visitor);
    return true;
  }
})(Em._e[208]);
(function (exports) {
  'use strict';

  exports.default = yieldKeyword;

  function yieldKeyword(morph, env, scope, params, hash, template, inverse, visitor) {
    var to = env.hooks.getValue(hash.to) || 'default';
    var block = scope.getBlock(to);

    if (block) {
      block.invoke(env, params, hash.self, morph, scope, visitor);
    }

    return true;
  }
})(Em._e[209]);
(function (exports, _emberHtmlbarsKeywordsMut) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = readonly;

  function readonly(morph, env, scope, originalParams, hash, template, inverse) {
    // If `morph` is `null` the keyword is being invoked as a subexpression.
    if (morph === null) {
      var stream = originalParams[0];
      if (stream && stream[_emberHtmlbarsKeywordsMut.MUTABLE_REFERENCE]) {
        return stream.sourceDep.dependee;
      }
      return stream;
    }

    return true;
  }
})(Em._e[210],Em._e[100]);
(function (exports, _emberMetalDebug, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils, _emberHtmlbarsUtilsSubscribe, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalObserver) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  exports.default = getKeyword;

  function labelFor(source, key) {
    var sourceLabel = source.label ? source.label : '';
    var keyLabel = key.label ? key.label : '';
    return '(get ' + sourceLabel + ' ' + keyLabel + ')';
  }

  var DynamicKeyStream = _emberHtmlbarsStreamsStream.default.extend({
    init: function (source, keySource) {
      // Used to get the original path for debugging purposes.
      var label = labelFor(source, keySource);

      this.label = label;
      this.path = label;
      this.sourceDep = this.addMutableDependency(source);
      this.keyDep = this.addMutableDependency(keySource);
      this.observedObject = null;
      this.observedKey = null;
    },

    key: function () {
      var key = this.keyDep.getValue();
      if (typeof key === 'string') {
        return key;
      }
    },

    compute: function () {
      var object = this.sourceDep.getValue();
      var key = this.key();
      if (object && key) {
        return _emberMetalProperty_get.get(object, key);
      }
    },

    setValue: function (value) {
      var object = this.sourceDep.getValue();
      var key = this.key();
      if (object) {
        _emberMetalProperty_set.set(object, key, value);
      }
    },

    _super$revalidate: _emberHtmlbarsStreamsStream.default.prototype.revalidate,

    revalidate: function (value) {
      this._super$revalidate(value);

      var object = this.sourceDep.getValue();
      var key = this.key();
      if (object !== this.observedObject || key !== this.observedKey) {
        this._clearObservedObject();

        if (typeof object === 'object' && object && key) {
          _emberMetalObserver.addObserver(object, key, this, this.notify);
          this.observedObject = object;
          this.observedKey = key;
        }
      }
    },

    _clearObservedObject: function () {
      if (this.observedObject) {
        _emberMetalObserver.removeObserver(this.observedObject, this.observedKey, this, this.notify);
        this.observedObject = null;
        this.observedKey = null;
      }
    }
  });

  function buildStream(params) {
    var objRef = params[0];
    var pathRef = params[1];

    var stream = buildDynamicKeyStream(objRef, pathRef);

    return stream;
  }

  function buildDynamicKeyStream(source, keySource) {
    if (!_emberHtmlbarsStreamsUtils.isStream(keySource)) {
      return source.get(keySource);
    } else {
      return new DynamicKeyStream(source, keySource);
    }
  }

  /**
    Dynamically look up a property on an object. The second argument to `{{get}}`
    should have a string value, although it can be bound.
  
    For example, these two usages are equivilent:
  
    ```handlebars
    {{person.height}}
    {{get person "height"}}
    ```
  
    If there were several facts about a person, the `{{get}}` helper can dynamically
    pick one:
  
    ```handlebars
    {{get person factName}}
    ```
  
    For a more complex example, this template would allow the user to switch
    between showing the user's height and weight with a click:
  
    ```handlebars
    {{get person factName}}
    <button {{action (mut factName) "height"}}>Show height</button>
    <button {{action (mut factName) "weight"}}>Show weight</button>
    ```
  
    The `{{get}}` helper can also respect mutable values itself. For example:
  
    ```handlebars
    {{input value=(mut (get person factName)) type="text"}}
    <button {{action (mut factName) "height"}}>Show height</button>
    <button {{action (mut factName) "weight"}}>Show weight</button>
    ```
  
    Would allow the user to swap what fact is being displayed, and also edit
    that fact via a two-way mutable binding.
  
    @public
    @method get
    @for Ember.Templates.helpers
    @since 2.1.0
  */

  function getKeyword(morph, env, scope, params, hash, template, inverse, visitor) {
    if (morph === null) {
      return buildStream(params);
    } else {
      var stream = undefined;
      if (morph.linkedResult) {
        stream = morph.linkedResult;
      } else {
        stream = buildStream(params);

        _emberHtmlbarsUtilsSubscribe.default(morph, env, scope, stream);
        env.hooks.linkRenderNode(morph, env, scope, null, params, hash);

        morph.linkedResult = stream;
      }
      env.hooks.range(morph, env, scope, null, stream, visitor);
    }

    return true;
  }
})(Em._e[211],Em._e[0],Em._e[56],Em._e[66],Em._e[84],Em._e[30],Em._e[32],Em._e[53]);
(function (exports, _htmlbarsRuntimeHooks, _emberHtmlbarsKeywordsClosureAction) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  /**
    The `{{action}}` helper provides a way to pass triggers for behavior (usually
    just a function) between components, and into components from controllers.
  
    ### Passing functions with the action helper
  
    There are three contexts an action helper can be used in. The first two
    contexts to discuss are attribute context, and Handlebars value context.
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    {{! Examples of Handlebars value context }}
    {{input on-input=(action "save")}}
    {{yield (action "refreshData") andAnotherParam}}
    ```
  
    In these contexts,
    the helper is called a "closure action" helper. Its behavior is simple:
    If passed a function name, read that function off the `actions` property
    of the current context. Once that function is read (or if a function was
    passed), create a closure over that function and any arguments.
  
    The resulting value of an action helper used this way is simply a function.
    For example, in the attribute context:
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    ```
  
    The resulting template render logic would be:
  
    ```js
    var div = document.createElement('div');
    var actionFunction = (function(context){
      return function() {
        return context.actions.save.apply(context, arguments);
      };
    })(context);
    div.onclick = actionFunction;
    ```
  
    Thus when the div is clicked, the action on that context is called.
    Because the `actionFunction` is just a function, closure actions can be
    passed between components and still execute in the correct context.
  
    Here is an example action handler on a component:
  
    ```js
    export default Ember.Component.extend({
      actions: {
        save() {
          this.get('model').save();
        }
      }
    });
    ```
  
    Actions are always looked up on the `actions` property of the current context.
    This avoids collisions in the naming of common actions, such as `destroy`.
  
    Two options can be passed to the `action` helper when it is used in this way.
  
    * `target=someProperty` will look to `someProperty` instead of the current
      context for the `actions` hash. This can be useful when targetting a
      service for actions.
    * `value="target.value"` will read the path `target.value` off the first
      argument to the action when it is called and rewrite the first argument
      to be that value. This is useful when attaching actions to event listeners.
  
    ### Invoking an action
  
    Closure actions curry both their scope and any arguments. When invoked, any
    additional arguments are added to the already curried list.
  
    Actions should be invoked using the [sendAction](/api/classes/Ember.Component.html#method_sendAction)
    method. The first argument to `sendAction` is the action to be called, and
    additional arguments are passed to the action function. This has interesting
    properties combined with currying of arguments. For example:
  
    ```js
    export default Ember.Component.extend({
      actions: {
        // Usage {{input on-input=(action (action 'setName' model) value="target.value")}}
        setName(model, name) {
          model.set('name', name);
        }
      }
    });
    ```
  
    The first argument (`model`) was curried over, and the run-time argument (`event`)
    becomes a second argument. Action calls can be nested this way because each simply
    returns a function. Any function can be passed to the `{{action}}` helper, including
    other actions.
  
    Actions invoked with `sendAction` have the same currying behavior as demonstrated
    with `on-input` above. For example:
  
    ```js
    export default Ember.Component.extend({
      actions: {
        setName(model, name) {
          model.set('name', name);
        }
      }
    });
    ```
  
    ```handlebars
    {{my-input submit=(action 'setName' model)}}
    ```
  
    ```js
    // app/components/my-component.js
    export default Ember.Component.extend({
      click() {
        // Note that model is not passed, it was curried in the template
        this.sendAction('submit', 'bob');
      }
    });
    ```
  
    ### Attaching actions to DOM elements
  
    The third context of the `{{action}}` helper can be called "element space".
    For example:
  
    ```handlebars
    {{! An example of element space }}
    <div {{action "save"}}></div>
    ```
  
    Used this way, the `{{action}}` helper provides a useful shortcut for
    registering an HTML element in a template for a single DOM event and
    forwarding that interaction to the template's context (controller or component).
  
    If the context of a template is a controller, actions used this way will
    bubble to routes when the controller does not implement the specified action.
    Once an action hits a route, it will bubble through the route hierarchy.
  
    ### Event Propagation
  
    `{{action}}` helpers called in element space can control event bubbling. Note
    that the closure style actions cannot.
  
    Events triggered through the action helper will automatically have
    `.preventDefault()` called on them. You do not need to do so in your event
    handlers. If you need to allow event propagation (to handle file inputs for
    example) you can supply the `preventDefault=false` option to the `{{action}}` helper:
  
    ```handlebars
    <div {{action "sayHello" preventDefault=false}}>
      <input type="file" />
      <input type="checkbox" />
    </div>
    ```
  
    To disable bubbling, pass `bubbles=false` to the helper:
  
    ```handlebars
    <button {{action 'edit' post bubbles=false}}>Edit</button>
    ```
  
    To disable bubbling with closure style actions you must create your own
    wrapper helper that makes use of `event.stopPropagation()`:
  
    ```handlebars
    <div onclick={{disable-bubbling (action "sayHello")}}>Hello</div>
    ```
  
    ```js
    // app/helpers/disable-bubbling.js
    import Ember from 'ember';
  
    export function disableBubbling([action]) {
      return function(event) {
        event.stopPropagation();
  
        return action(event);
      };
    }
  
    export default Ember.Helper.helper(disableBubbling);
    ```
  
    If you need the default handler to trigger you should either register your
    own event handler, or use event methods on your view class. See
    ["Responding to Browser Events"](/api/classes/Ember.View.html#toc_responding-to-browser-events)
    in the documentation for Ember.View for more information.
  
    ### Specifying DOM event type
  
    `{{action}}` helpers called in element space can specify an event type.
  
    By default the `{{action}}` helper registers for DOM `click` events. You can
    supply an `on` option to the helper to specify a different DOM event name:
  
    ```handlebars
    <div {{action "anActionName" on="doubleClick"}}>
      click me
    </div>
    ```
  
    See ["Event Names"](/api/classes/Ember.View.html#toc_event-names) for a list of
    acceptable DOM event names.
  
    ### Specifying whitelisted modifier keys
  
    `{{action}}` helpers called in element space can specify modifier keys.
  
    By default the `{{action}}` helper will ignore click events with pressed modifier
    keys. You can supply an `allowedKeys` option to specify which keys should not be ignored.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="alt"}}>
      click me
    </div>
    ```
  
    This way the action will fire when clicking with the alt key pressed down.
  
    Alternatively, supply "any" to the `allowedKeys` option to accept any combination of modifier keys.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="any"}}>
      click me with any key pressed
    </div>
    ```
  
    ### Specifying a Target
  
    A `target` option can be provided to the helper to change
    which object will receive the method call. This option must be a path
    to an object, accessible in the current context:
  
    ```handlebars
    {{! app/templates/application.hbs }}
    <div {{action "anActionName" target=someService}}>
      click me
    </div>
    ```
  
    ```javascript
    // app/controllers/application.js
    export default Ember.Controller.extend({
      someService: Ember.inject.service()
    });
    ```
  
    @method action
    @for Ember.Templates.helpers
    @public
  */

  exports.default = function (morph, env, scope, params, hash, template, inverse, visitor) {
    if (morph) {
      _htmlbarsRuntimeHooks.keyword('@element_action', morph, env, scope, params, hash, template, inverse, visitor);
      return true;
    }

    return _emberHtmlbarsKeywordsClosureAction.default(morph, env, scope, params, hash, template, inverse, visitor);
  };
})(Em._e[212],Em._e[46],Em._e[99]);
(function (exports) {
  /**
  @module ember
  @submodule ember-views
  */

  "use strict";

  exports.default = ActionManager;

  function ActionManager() {}

  /**
    Global action id hash.
  
    @private
    @property registeredActions
    @type Object
  */
  ActionManager.registeredActions = {};
})(Em._e[213]);
(function (exports, _emberMetalDebug, _emberMetalUtils, _emberHtmlbarsStreamsUtils, _emberMetalRun_loop, _emberViewsSystemUtils, _emberViewsSystemAction_manager, _emberMetalInstrumentation) {
  'use strict';

  exports.default = {
    setupState: function (state, env, scope, params, hash) {
      var getStream = env.hooks.get;
      var read = env.hooks.getValue;

      var actionName = read(params[0]);

      var actionArgs = [];
      for (var i = 1; i < params.length; i++) {
        actionArgs.push(_emberHtmlbarsStreamsUtils.readUnwrappedModel(params[i]));
      }

      var target = undefined;
      if (hash.target) {
        if (typeof hash.target === 'string') {
          target = read(getStream(env, scope, hash.target));
        } else {
          target = read(hash.target);
        }
      } else {
        target = read(scope.getLocal('controller')) || read(scope.getSelf());
      }

      return { actionName: actionName, actionArgs: actionArgs, target: target };
    },

    isStable: function (state, env, scope, params, hash) {
      return true;
    },

    render: function (node, env, scope, params, hash, template, inverse, visitor) {
      var actionId = env.dom.getAttribute(node.element, 'data-ember-action') || _emberMetalUtils.uuid();

      ActionHelper.registerAction({
        actionId: actionId,
        node: node,
        eventName: hash.on || 'click',
        bubbles: hash.bubbles,
        preventDefault: hash.preventDefault,
        withKeyCode: hash.withKeyCode,
        allowedKeys: hash.allowedKeys
      });

      node.cleanup = function () {
        return ActionHelper.unregisterAction(actionId);
      };

      env.dom.setAttribute(node.element, 'data-ember-action', actionId);
    }
  };
  var ActionHelper = {};

  exports.ActionHelper = ActionHelper;
  // registeredActions is re-exported for compatibility with older plugins
  // that were using this undocumented API.
  ActionHelper.registeredActions = _emberViewsSystemAction_manager.default.registeredActions;

  ActionHelper.registerAction = function (_ref) {
    var actionId = _ref.actionId;
    var node = _ref.node;
    var eventName = _ref.eventName;
    var preventDefault = _ref.preventDefault;
    var bubbles = _ref.bubbles;
    var allowedKeys = _ref.allowedKeys;

    var actions = _emberViewsSystemAction_manager.default.registeredActions[actionId];

    if (!actions) {
      actions = _emberViewsSystemAction_manager.default.registeredActions[actionId] = [];
    }

    actions.push({
      eventName: eventName,
      handler: function (event) {
        if (!isAllowedEvent(event, _emberHtmlbarsStreamsUtils.read(allowedKeys))) {
          return true;
        }

        if (_emberHtmlbarsStreamsUtils.read(preventDefault) !== false) {
          event.preventDefault();
        }

        if (_emberHtmlbarsStreamsUtils.read(bubbles) === false) {
          event.stopPropagation();
        }

        var _node$getState = node.getState();

        var target = _node$getState.target;
        var actionName = _node$getState.actionName;
        var actionArgs = _node$getState.actionArgs;

        _emberMetalRun_loop.default(function runRegisteredAction() {
          var payload = {
            target: target,
            args: actionArgs
          };
          if (typeof actionName === 'function') {
            _emberMetalInstrumentation.flaggedInstrument('interaction.ember-action', payload, function () {
              actionName.apply(target, actionArgs);
            });
            return;
          }
          payload.name = actionName;
          if (target.send) {
            _emberMetalInstrumentation.flaggedInstrument('interaction.ember-action', payload, function () {
              target.send.apply(target, [actionName].concat(actionArgs));
            });
          } else {
            _emberMetalInstrumentation.flaggedInstrument('interaction.ember-action', payload, function () {
              target[actionName].apply(target, actionArgs);
            });
          }
        });
      }
    });

    return actionId;
  };

  ActionHelper.unregisterAction = function (actionId) {
    return delete _emberViewsSystemAction_manager.default.registeredActions[actionId];
  };

  var MODIFIERS = ['alt', 'shift', 'meta', 'ctrl'];
  var POINTER_EVENT_TYPE_REGEX = /^click|mouse|touch/;

  function isAllowedEvent(event, allowedKeys) {
    if (typeof allowedKeys === 'undefined') {
      if (POINTER_EVENT_TYPE_REGEX.test(event.type)) {
        return _emberViewsSystemUtils.isSimpleClick(event);
      } else {
        allowedKeys = '';
      }
    }

    if (allowedKeys.indexOf('any') >= 0) {
      return true;
    }

    for (var i = 0; i < MODIFIERS.length; i++) {
      if (event[MODIFIERS[i] + 'Key'] && allowedKeys.indexOf(MODIFIERS[i]) === -1) {
        return false;
      }
    }

    return true;
  }
})(Em._e[214],Em._e[0],Em._e[7],Em._e[66],Em._e[27],Em._e[128],Em._e[213],Em._e[98]);
(function (exports, _emberEnvironment, _htmlbarsRuntime, _emberMetalAssign, _emberMetalFeatures, _emberHtmlbarsHooksSubexpr, _emberHtmlbarsHooksConcat, _emberHtmlbarsHooksLinkRenderNode, _emberHtmlbarsHooksCreateFreshScope, _emberHtmlbarsHooksBindShadowScope, _emberHtmlbarsHooksBindSelf, _emberHtmlbarsHooksBindScope, _emberHtmlbarsHooksBindLocal, _emberHtmlbarsHooksBindBlock, _emberHtmlbarsHooksUpdateSelf, _emberHtmlbarsHooksGetRoot, _emberHtmlbarsHooksGetChild, _emberHtmlbarsHooksGetBlock, _emberHtmlbarsHooksGetValue, _emberHtmlbarsHooksGetCellOrValue, _emberHtmlbarsHooksCleanupRenderNode, _emberHtmlbarsHooksDestroyRenderNode, _emberHtmlbarsHooksDidRenderNode, _emberHtmlbarsHooksWillCleanupTree, _emberHtmlbarsHooksDidCleanupTree, _emberHtmlbarsHooksClassify, _emberHtmlbarsHooksComponent, _emberHtmlbarsHooksLookupHelper, _emberHtmlbarsHooksHasHelper, _emberHtmlbarsHooksInvokeHelper, _emberHtmlbarsHooksElement, _emberHtmlbarsHelpers, _emberHtmlbarsKeywords, _emberHtmlbarsSystemDomHelper, _emberHtmlbarsKeywordsDebugger, _emberHtmlbarsKeywordsWith, _emberHtmlbarsKeywordsOutlet, _emberHtmlbarsKeywordsUnbound, _emberHtmlbarsKeywordsComponent, _emberHtmlbarsKeywordsElementComponent, _emberHtmlbarsKeywordsMount, _emberHtmlbarsKeywordsPartial, _emberHtmlbarsKeywordsInput, _emberHtmlbarsKeywordsTextarea, _emberHtmlbarsKeywordsYield, _emberHtmlbarsKeywordsMut, _emberHtmlbarsKeywordsReadonly, _emberHtmlbarsKeywordsGet, _emberHtmlbarsKeywordsAction, _emberHtmlbarsKeywordsRender, _emberHtmlbarsKeywordsElementAction) {
  'use strict';

  var emberHooks = _emberMetalAssign.default({}, _htmlbarsRuntime.hooks);
  emberHooks.keywords = _emberHtmlbarsKeywords.default;

  _emberMetalAssign.default(emberHooks, {
    linkRenderNode: _emberHtmlbarsHooksLinkRenderNode.default,
    createFreshScope: _emberHtmlbarsHooksCreateFreshScope.default,
    createChildScope: _emberHtmlbarsHooksCreateFreshScope.createChildScope,
    bindShadowScope: _emberHtmlbarsHooksBindShadowScope.default,
    bindSelf: _emberHtmlbarsHooksBindSelf.default,
    bindScope: _emberHtmlbarsHooksBindScope.default,
    bindLocal: _emberHtmlbarsHooksBindLocal.default,
    bindBlock: _emberHtmlbarsHooksBindBlock.default,
    updateSelf: _emberHtmlbarsHooksUpdateSelf.default,
    getBlock: _emberHtmlbarsHooksGetBlock.default,
    getRoot: _emberHtmlbarsHooksGetRoot.default,
    getChild: _emberHtmlbarsHooksGetChild.default,
    getValue: _emberHtmlbarsHooksGetValue.default,
    getCellOrValue: _emberHtmlbarsHooksGetCellOrValue.default,
    subexpr: _emberHtmlbarsHooksSubexpr.default,
    concat: _emberHtmlbarsHooksConcat.default,
    cleanupRenderNode: _emberHtmlbarsHooksCleanupRenderNode.default,
    destroyRenderNode: _emberHtmlbarsHooksDestroyRenderNode.default,
    willCleanupTree: _emberHtmlbarsHooksWillCleanupTree.default,
    didCleanupTree: _emberHtmlbarsHooksDidCleanupTree.default,
    didRenderNode: _emberHtmlbarsHooksDidRenderNode.default,
    classify: _emberHtmlbarsHooksClassify.default,
    component: _emberHtmlbarsHooksComponent.default,
    lookupHelper: _emberHtmlbarsHooksLookupHelper.default,
    hasHelper: _emberHtmlbarsHooksHasHelper.default,
    invokeHelper: _emberHtmlbarsHooksInvokeHelper.default,
    element: _emberHtmlbarsHooksElement.default
  });

  _emberHtmlbarsKeywords.registerKeyword('debugger', _emberHtmlbarsKeywordsDebugger.default);
  _emberHtmlbarsKeywords.registerKeyword('with', _emberHtmlbarsKeywordsWith.default);
  _emberHtmlbarsKeywords.registerKeyword('outlet', _emberHtmlbarsKeywordsOutlet.default);
  _emberHtmlbarsKeywords.registerKeyword('unbound', _emberHtmlbarsKeywordsUnbound.default);
  _emberHtmlbarsKeywords.registerKeyword('component', _emberHtmlbarsKeywordsComponent.default);
  _emberHtmlbarsKeywords.registerKeyword('@element_component', _emberHtmlbarsKeywordsElementComponent.default);
  if (true) {
    _emberHtmlbarsKeywords.registerKeyword('mount', _emberHtmlbarsKeywordsMount.default);
  }
  _emberHtmlbarsKeywords.registerKeyword('partial', _emberHtmlbarsKeywordsPartial.default);
  _emberHtmlbarsKeywords.registerKeyword('input', _emberHtmlbarsKeywordsInput.default);
  _emberHtmlbarsKeywords.registerKeyword('textarea', _emberHtmlbarsKeywordsTextarea.default);
  _emberHtmlbarsKeywords.registerKeyword('yield', _emberHtmlbarsKeywordsYield.default);
  _emberHtmlbarsKeywords.registerKeyword('mut', _emberHtmlbarsKeywordsMut.default);
  _emberHtmlbarsKeywords.registerKeyword('@mut', _emberHtmlbarsKeywordsMut.privateMut);
  _emberHtmlbarsKeywords.registerKeyword('readonly', _emberHtmlbarsKeywordsReadonly.default);
  _emberHtmlbarsKeywords.registerKeyword('get', _emberHtmlbarsKeywordsGet.default);
  _emberHtmlbarsKeywords.registerKeyword('action', _emberHtmlbarsKeywordsAction.default);
  _emberHtmlbarsKeywords.registerKeyword('render', _emberHtmlbarsKeywordsRender.default);
  _emberHtmlbarsKeywords.registerKeyword('@element_action', _emberHtmlbarsKeywordsElementAction.default);

  exports.default = {
    hooks: emberHooks,
    helpers: _emberHtmlbarsHelpers.default,
    useFragmentCache: true
  };

  var domHelper = _emberEnvironment.environment.hasDOM ? new _emberHtmlbarsSystemDomHelper.default() : null;

  exports.domHelper = domHelper;
})(Em._e[215],Em._e[4],Em._e[47],Em._e[8],Em._e[10],Em._e[97],Em._e[135],Em._e[96],Em._e[136],Em._e[137],Em._e[138],Em._e[139],Em._e[140],Em._e[141],Em._e[142],Em._e[143],Em._e[144],Em._e[145],Em._e[68],Em._e[101],Em._e[146],Em._e[147],Em._e[148],Em._e[149],Em._e[150],Em._e[152],Em._e[153],Em._e[154],Em._e[155],Em._e[156],Em._e[157],Em._e[158],Em._e[159],Em._e[173],Em._e[174],Em._e[175],Em._e[198],Em._e[199],Em._e[200],Em._e[201],Em._e[204],Em._e[206],Em._e[207],Em._e[208],Em._e[209],Em._e[100],Em._e[210],Em._e[211],Em._e[212],Em._e[203],Em._e[214]);
(function (exports, _emberHtmlbarsEnv, _emberHtmlbarsRenderer, _containerOwner) {
  'use strict';

  exports.default = RenderEnv;

  function RenderEnv(options) {
    this.lifecycleHooks = options.lifecycleHooks || [];
    this.renderedViews = options.renderedViews || [];
    this.renderedNodes = options.renderedNodes || new _emberHtmlbarsRenderer.MorphSet();
    this.hasParentOutlet = options.hasParentOutlet || false;

    this.view = options.view;
    this.outletState = options.outletState;
    this.owner = options.owner;
    this.renderer = options.renderer;
    this.dom = options.dom;
    this.meta = options.meta;

    this.hooks = _emberHtmlbarsEnv.default.hooks;
    this.helpers = _emberHtmlbarsEnv.default.helpers;
    this.useFragmentCache = _emberHtmlbarsEnv.default.useFragmentCache;
    this.destinedForDOM = this.renderer._destinedForDOM;
  }

  RenderEnv.build = function (view, meta) {
    return new RenderEnv({
      view: view,
      outletState: view.outletState,
      owner: _containerOwner.getOwner(view),
      renderer: view.renderer,
      dom: view.renderer._dom,
      meta: meta
    });
  };

  RenderEnv.prototype.childWithMeta = function (meta) {
    return new RenderEnv({
      view: this.view,
      outletState: this.outletState,
      owner: this.owner,
      renderer: this.renderer,
      dom: this.dom,
      lifecycleHooks: this.lifecycleHooks,
      renderedViews: this.renderedViews,
      renderedNodes: this.renderedNodes,
      hasParentOutlet: this.hasParentOutlet,
      meta: meta
    });
  };

  RenderEnv.prototype.childWithView = function (view) {
    var meta = arguments.length <= 1 || arguments[1] === undefined ? this.meta : arguments[1];

    return new RenderEnv({
      view: view,
      outletState: this.outletState,
      owner: this.owner,
      renderer: this.renderer,
      dom: this.dom,
      lifecycleHooks: this.lifecycleHooks,
      renderedViews: this.renderedViews,
      renderedNodes: this.renderedNodes,
      hasParentOutlet: this.hasParentOutlet,
      meta: meta
    });
  };

  RenderEnv.prototype.childWithOutletState = function (outletState) {
    var hasParentOutlet = arguments.length <= 1 || arguments[1] === undefined ? this.hasParentOutlet : arguments[1];
    var meta = arguments.length <= 2 || arguments[2] === undefined ? this.meta : arguments[2];

    return new RenderEnv({
      view: this.view,
      outletState: outletState,
      owner: this.owner,
      renderer: this.renderer,
      dom: this.dom,
      lifecycleHooks: this.lifecycleHooks,
      renderedViews: this.renderedViews,
      renderedNodes: this.renderedNodes,
      hasParentOutlet: hasParentOutlet,
      meta: meta
    });
  };
})(Em._e[216],Em._e[215],Em._e[220],Em._e[70]);
(function (exports, _emberHtmlbarsNodeManagersViewNodeManager, _emberHtmlbarsSystemRenderEnv) {
  'use strict';

  exports.renderHTMLBarsBlock = renderHTMLBarsBlock;

  // This function only gets called once per render of a "root view" (`appendTo`). Otherwise,
  // HTMLBars propagates the existing env and renders templates for a given render node.

  function renderHTMLBarsBlock(view, block, renderNode) {
    var meta = block && block.template && block.template.meta;
    var env = _emberHtmlbarsSystemRenderEnv.default.build(view, meta);

    view._env = env;
    _emberHtmlbarsNodeManagersViewNodeManager.createOrUpdateComponent(view, {}, null, renderNode, env);
    var nodeManager = new _emberHtmlbarsNodeManagersViewNodeManager.default(view, null, renderNode, block, view.tagName !== '');

    nodeManager.render(env, {});
  }
})(Em._e[217],Em._e[133],Em._e[216]);
(function (exports, _emberMetalEmpty_object) {
  'use strict';

  exports.default = makeDictionary;

  // the delete is meant to hint at runtimes that this object should remain in
  // dictionary mode. This is clearly a runtime specific hack, but currently it
  // appears worthwhile in some usecases. Please note, these deletes do increase
  // the cost of creation dramatically over a plain Object.create. And as this
  // only makes sense for long-lived dictionaries that aren't instantiated often.

  function makeDictionary(parent) {
    var dict = undefined;
    if (parent === null) {
      dict = new _emberMetalEmpty_object.default();
    } else {
      dict = Object.create(parent);
    }
    dict['_dict'] = null;
    delete dict['_dict'];
    return dict;
  }
})(Em._e[218],Em._e[12]);
(function (exports, _emberMetalDictionary) {
  'use strict';

  exports.default = _emberMetalDictionary.default(null);
})(Em._e[219],Em._e[218]);
(function (exports, _emberMetalRun_loop, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalAssign, _emberMetalSet_properties, _emberHtmlbarsSystemBuildComponentTemplate, _emberEnvironment, _htmlbarsRuntime, _emberHtmlbarsSystemRenderView, _emberViewsCompatFallbackViewRegistry, _emberMetalDebug) {
  'use strict';

  exports.Renderer = Renderer;
  exports.MorphSet = MorphSet;

  function Renderer(domHelper) {
    var _ref = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    var destinedForDOM = _ref.destinedForDOM;
    var _viewRegistry = _ref._viewRegistry;

    this._dom = domHelper;

    // This flag indicates whether the resulting rendered element will be
    // inserted into the DOM. This should be set to `false` if the rendered
    // element is going to be serialized to HTML without being inserted into
    // the DOM (e.g., in FastBoot mode). By default, this flag is the same
    // as whether we are running in an environment with DOM, but may be
    // overridden.
    this._destinedForDOM = destinedForDOM === undefined ? _emberEnvironment.environment.hasDOM : destinedForDOM;

    this._viewRegistry = _viewRegistry || _emberViewsCompatFallbackViewRegistry.default;
  }

  Renderer.prototype.prerenderTopLevelView = function Renderer_prerenderTopLevelView(view, renderNode) {
    if (view._state === 'inDOM') {
      throw new Error('You cannot insert a View that has already been rendered');
    }
    view.ownerView = renderNode.emberView = view;
    view._renderNode = renderNode;

    var layout = _emberMetalProperty_get.get(view, 'layout');
    var template = _emberMetalProperty_get.get(view, 'template');

    var componentInfo = { component: view, layout: layout };

    var block = _emberHtmlbarsSystemBuildComponentTemplate.default(componentInfo, {}, {
      self: view,
      templates: template ? { default: template.raw } : undefined
    }).block;

    _emberHtmlbarsSystemRenderView.renderHTMLBarsBlock(view, block, renderNode);
    view.lastResult = renderNode.lastResult;
    this.clearRenderedViews(view._env);
  };

  Renderer.prototype.renderTopLevelView = function Renderer_renderTopLevelView(view, renderNode) {
    // Check to see if insertion has been canceled.
    if (view._willInsert) {
      view._willInsert = false;
      this.prerenderTopLevelView(view, renderNode);
      this.dispatchLifecycleHooks(view._env);
    }
  };

  Renderer.prototype.revalidateTopLevelView = function Renderer_revalidateTopLevelView(view) {
    // This guard prevents revalidation on an already-destroyed view.
    if (view._renderNode.lastResult) {
      view._renderNode.lastResult.revalidate(view._env);
      this.dispatchLifecycleHooks(view._env);
      this.clearRenderedViews(view._env);
    }
  };

  Renderer.prototype.dispatchLifecycleHooks = function Renderer_dispatchLifecycleHooks(env) {
    var ownerView = env.view;

    var lifecycleHooks = env.lifecycleHooks;
    var i = undefined,
        hook = undefined;

    for (i = 0; i < lifecycleHooks.length; i++) {
      hook = lifecycleHooks[i];
      ownerView._dispatching = hook.type;

      switch (hook.type) {
        case 'didInsertElement':
          this.didInsertElement(hook.view);break;
        case 'didUpdate':
          this.didUpdate(hook.view);break;
      }

      this.didRender(hook.view);
    }

    ownerView._dispatching = null;
    env.lifecycleHooks.length = 0;
  };

  Renderer.prototype.ensureViewNotRendering = function Renderer_ensureViewNotRendering(view) {
    var env = view.ownerView._env;
    if (env && env.renderedViews.indexOf(view.elementId) !== -1) {
      throw new Error('Something you did caused a view to re-render after it rendered but before it was inserted into the DOM.');
    }
  };

  function MorphSet() {
    this.morphs = [];
  }

  MorphSet.prototype.add = function (morph) {
    this.morphs.push(morph);
    morph.seen = true;
  };

  MorphSet.prototype.has = function (morph) {
    return morph.seen;
  };

  MorphSet.prototype.clear = function () {
    var morphs = this.morphs;
    for (var i = 0; i < morphs.length; i++) {
      morphs[i].seen = false;
    }

    this.morphs = [];
  };

  Renderer.prototype.clearRenderedViews = function Renderer_clearRenderedViews(env) {
    env.renderedNodes.clear();
    env.renderedViews.length = 0;
  };

  // This entry point is called from top-level `view.appendTo`.
  Renderer.prototype.appendTo = function Renderer_appendTo(view, target) {
    var morph = this._dom.appendMorph(target);
    morph.ownerNode = morph;
    view._willInsert = true;
    _emberMetalRun_loop.default.schedule('render', this, this.renderTopLevelView, view, morph);
  };

  Renderer.prototype.replaceIn = function Renderer_replaceIn(view, target) {
    var morph = this._dom.replaceContentWithMorph(target);
    morph.ownerNode = morph;
    view._willInsert = true;
    _emberMetalRun_loop.default.scheduleOnce('render', this, this.renderTopLevelView, view, morph);
  };

  Renderer.prototype.didCreateElement = function (view, element) {
    if (element) {
      view.element = element;
    }

    if (view._transitionTo) {
      view._transitionTo('hasElement');
    }
  }; // hasElement

  Renderer.prototype.willInsertElement = function (view) {
    if (view.trigger) {
      view.trigger('willInsertElement');
    }
  }; // Will place into DOM.

  Renderer.prototype.componentInitAttrs = function (component, attrs) {
    component.trigger('didInitAttrs', { attrs: attrs });
    component.trigger('didReceiveAttrs', { newAttrs: attrs });
  }; // Set attrs the first time.

  Renderer.prototype.didInsertElement = function (view) {
    if (view._transitionTo) {
      view._transitionTo('inDOM');
    }

    if (view.trigger) {
      view.trigger('didInsertElement');
    }
  }; // inDOM // Placed into DOM.

  Renderer.prototype.didUpdate = function (view) {
    if (view.trigger) {
      view.trigger('didUpdate');
    }
  };

  Renderer.prototype.didRender = function (view) {
    if (view.trigger) {
      view.trigger('didRender');
    }
  };

  Renderer.prototype.componentUpdateAttrs = function (component, newAttrs) {
    var oldAttrs = null;

    if (component.attrs) {
      oldAttrs = _emberMetalAssign.default({}, component.attrs);
      _emberMetalSet_properties.default(component.attrs, newAttrs);
    } else {
      _emberMetalProperty_set.set(component, 'attrs', newAttrs);
    }

    component.trigger('didUpdateAttrs', { oldAttrs: oldAttrs, newAttrs: newAttrs });
    component.trigger('didReceiveAttrs', { oldAttrs: oldAttrs, newAttrs: newAttrs });
  };

  Renderer.prototype.willUpdate = function (view, attrs) {
    if (view._willUpdate) {
      view._willUpdate(attrs);
    }
  };

  Renderer.prototype.componentWillUpdate = function (component) {
    component.trigger('willUpdate');
  };

  Renderer.prototype.willRender = function (view) {
    if (view._willRender) {
      view._willRender();
    }
  };

  Renderer.prototype.componentWillRender = function (component) {
    component.trigger('willRender');
  };

  Renderer.prototype.rerender = function (view) {
    var renderNode = view._renderNode;

    renderNode.isDirty = true;
    _htmlbarsRuntime.internal.visitChildren(renderNode.childNodes, function (node) {
      if (node.getState().manager) {
        node.shouldReceiveAttrs = true;
      }
      node.isDirty = true;
    });

    renderNode.ownerNode.emberView.scheduleRevalidate(renderNode, view.toString(), 'rerendering');
  };

  Renderer.prototype.remove = function (view, shouldDestroy) {
    var renderNode = view._renderNode;
    view._renderNode = null;
    if (renderNode) {
      renderNode.emberView = null;
      this.willDestroyElement(view);
      view._transitionTo('destroying');

      view._renderNode = null;
      var _lastResult = renderNode.lastResult;
      if (_lastResult) {
        _htmlbarsRuntime.internal.clearMorph(renderNode, _lastResult.env, shouldDestroy !== false);
      }
      if (!shouldDestroy) {
        view._transitionTo('preRender');
      }
      this.didDestroyElement(view);
    }

    // toplevel view removed, remove insertion point
    var lastResult = view.lastResult;
    if (lastResult) {
      view.lastResult = null;
      lastResult.destroy();
    }

    if (shouldDestroy && !view.isDestroying) {
      view.destroy();
    }
  };

  Renderer.prototype.willDestroyElement = function (view) {
    if (view.trigger) {
      view.trigger('willDestroyElement');
      view.trigger('willClearRender');
    }
  };

  Renderer.prototype.didDestroyElement = function (view) {
    view.element = null;

    if (view.trigger) {
      view.trigger('didDestroyElement');
    }
  };

  Renderer.prototype.register = function Renderer_register(view) {
    this._viewRegistry[view.elementId] = view;
  };

  Renderer.prototype.unregister = function Renderer_unregister(view) {
    delete this._viewRegistry[this.elementId];
  };

  var InertRenderer = {
    create: function (_ref2) {
      var dom = _ref2.dom;
      var _viewRegistry = _ref2._viewRegistry;

      return new Renderer(dom, { destinedForDOM: false, _viewRegistry: _viewRegistry });
    }
  };

  exports.InertRenderer = InertRenderer;
  var InteractiveRenderer = {
    create: function (_ref3) {
      var dom = _ref3.dom;
      var _viewRegistry = _ref3._viewRegistry;

      return new Renderer(dom, { destinedForDOM: true, _viewRegistry: _viewRegistry });
    }
  };
  exports.InteractiveRenderer = InteractiveRenderer;
})(Em._e[220],Em._e[27],Em._e[30],Em._e[32],Em._e[8],Em._e[33],Em._e[69],Em._e[4],Em._e[47],Em._e[217],Em._e[219],Em._e[0]);
(function (exports, _emberMetalProperty_get, _emberMetalProperty_set, _emberHtmlbarsComponent) {
  'use strict';

  /**
  @module ember
  @submodule ember-views
  */

  /**
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `checkbox`.
  
    See [Ember.Templates.helpers.input](/api/classes/Ember.Templates.helpers.html#method_input)  for usage details.
  
    ## Direct manipulation of `checked`
  
    The `checked` attribute of an `Ember.Checkbox` object should always be set
    through the Ember object or by interacting with its rendered element
    representation via the mouse, keyboard, or touch. Updating the value of the
    checkbox via jQuery will result in the checked value of the object and its
    element losing synchronization.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
    layout section for more information.
  
    @class Checkbox
    @namespace Ember
    @extends Ember.Component
    @public
  */
  exports.default = _emberHtmlbarsComponent.default.extend({
    instrumentDisplay: '{{input type="checkbox"}}',

    classNames: ['ember-checkbox'],

    tagName: 'input',

    attributeBindings: ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form'],

    type: 'checkbox',
    checked: false,
    disabled: false,
    indeterminate: false,

    didInsertElement: function () {
      this._super.apply(this, arguments);
      _emberMetalProperty_get.get(this, 'element').indeterminate = !!_emberMetalProperty_get.get(this, 'indeterminate');
    },

    change: function () {
      _emberMetalProperty_set.set(this, 'checked', this.$().prop('checked'));
    }
  });
})(Em._e[221],Em._e[30],Em._e[32],Em._e[131]);
(function (exports, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalMixin, _emberRuntimeMixinsTarget_action_support) {
  /**
  @module ember
  @submodule ember-views
  */

  'use strict';

  var KEY_EVENTS = {
    13: 'insertNewline',
    27: 'cancel'
  };

  /**
    `TextSupport` is a shared mixin used by both `Ember.TextField` and
    `Ember.TextArea`. `TextSupport` adds a number of methods that allow you to
    specify a controller action to invoke when a certain event is fired on your
    text field or textarea. The specifed controller action would get the current
    value of the field passed in as the only argument unless the value of
    the field is empty. In that case, the instance of the field itself is passed
    in as the only argument.
  
    Let's use the pressing of the escape key as an example. If you wanted to
    invoke a controller action when a user presses the escape key while on your
    field, you would use the `escape-press` attribute on your field like so:
  
    ```handlebars
      {{! application.hbs}}
  
      {{input escape-press='alertUser'}}
    ```
  
    ```javascript
        App = Ember.Application.create();
  
        App.ApplicationController = Ember.Controller.extend({
          actions: {
            alertUser: function ( currentValue ) {
              alert( 'escape pressed, current value: ' + currentValue );
            }
          }
        });
    ```
  
    The following chart is a visual representation of what takes place when the
    escape key is pressed in this scenario:
  
    ```
    The Template
    +---------------------------+
    |                           |
    | escape-press='alertUser'  |
    |                           |          TextSupport Mixin
    +----+----------------------+          +-------------------------------+
         |                                 | cancel method                 |
         |      escape button pressed      |                               |
         +-------------------------------> | checks for the `escape-press` |
                                           | attribute and pulls out the   |
         +-------------------------------+ | `alertUser` value             |
         |     action name 'alertUser'     +-------------------------------+
         |     sent to controller
         v
    Controller
    +------------------------------------------ +
    |                                           |
    |  actions: {                               |
    |     alertUser: function( currentValue ){  |
    |       alert( 'the esc key was pressed!' ) |
    |     }                                     |
    |  }                                        |
    |                                           |
    +-------------------------------------------+
    ```
  
    Here are the events that we currently support along with the name of the
    attribute you would need to use on your field. To reiterate, you would use the
    attribute name like so:
  
    ```handlebars
      {{input attribute-name='controllerAction'}}
    ```
  
    ```
    +--------------------+----------------+
    |                    |                |
    | event              | attribute name |
    +--------------------+----------------+
    | new line inserted  | insert-newline |
    |                    |                |
    | enter key pressed  | insert-newline |
    |                    |                |
    | cancel key pressed | escape-press   |
    |                    |                |
    | focusin            | focus-in       |
    |                    |                |
    | focusout           | focus-out      |
    |                    |                |
    | keypress           | key-press      |
    |                    |                |
    | keyup              | key-up         |
    |                    |                |
    | keydown            | key-down       |
    +--------------------+----------------+
    ```
  
    @class TextSupport
    @namespace Ember
    @uses Ember.TargetActionSupport
    @extends Ember.Mixin
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create(_emberRuntimeMixinsTarget_action_support.default, {
    value: '',

    attributeBindings: ['autocapitalize', 'autocorrect', 'autofocus', 'disabled', 'form', 'maxlength', 'placeholder', 'readonly', 'required', 'selectionDirection', 'spellcheck', 'tabindex', 'title'],
    placeholder: null,
    disabled: false,
    maxlength: null,

    init: function () {
      this._super.apply(this, arguments);
      this.on('paste', this, this._elementValueDidChange);
      this.on('cut', this, this._elementValueDidChange);
      this.on('input', this, this._elementValueDidChange);
    },

    /**
      The action to be sent when the user presses the return key.
       This is similar to the `{{action}}` helper, but is fired when
      the user presses the return key when editing a text field, and sends
      the value of the field as the context.
       @property action
      @type String
      @default null
      @private
    */
    action: null,

    /**
      The event that should send the action.
       Options are:
       * `enter`: the user pressed enter
      * `keyPress`: the user pressed a key
       @property onEvent
      @type String
      @default enter
      @private
    */
    onEvent: 'enter',

    /**
      Whether the `keyUp` event that triggers an `action` to be sent continues
      propagating to other views.
       By default, when the user presses the return key on their keyboard and
      the text field has an `action` set, the action will be sent to the view's
      controller and the key event will stop propagating.
       If you would like parent views to receive the `keyUp` event even after an
      action has been dispatched, set `bubbles` to true.
       @property bubbles
      @type Boolean
      @default false
      @private
    */
    bubbles: false,

    interpretKeyEvents: function (event) {
      var map = KEY_EVENTS;
      var method = map[event.keyCode];

      this._elementValueDidChange();
      if (method) {
        return this[method](event);
      }
    },

    _elementValueDidChange: function () {
      _emberMetalProperty_set.set(this, 'value', this.element.value);
    },

    change: function (event) {
      this._elementValueDidChange(event);
    },

    /**
      Allows you to specify a controller action to invoke when either the `enter`
      key is pressed or, in the case of the field being a textarea, when a newline
      is inserted. To use this method, give your field an `insert-newline`
      attribute. The value of that attribute should be the name of the action
      in your controller that you wish to invoke.
       For an example on how to use the `insert-newline` attribute, please
      reference the example near the top of this file.
       @method insertNewline
      @param {Event} event
      @private
    */
    insertNewline: function (event) {
      sendAction('enter', this, event);
      sendAction('insert-newline', this, event);
    },

    /**
      Allows you to specify a controller action to invoke when the escape button
      is pressed. To use this method, give your field an `escape-press`
      attribute. The value of that attribute should be the name of the action
      in your controller that you wish to invoke.
       For an example on how to use the `escape-press` attribute, please reference
      the example near the top of this file.
       @method cancel
      @param {Event} event
      @private
    */
    cancel: function (event) {
      sendAction('escape-press', this, event);
    },

    /**
      Allows you to specify a controller action to invoke when a field receives
      focus. To use this method, give your field a `focus-in` attribute. The value
      of that attribute should be the name of the action in your controller
      that you wish to invoke.
       For an example on how to use the `focus-in` attribute, please reference the
      example near the top of this file.
       @method focusIn
      @param {Event} event
      @private
    */
    focusIn: function (event) {
      sendAction('focus-in', this, event);
    },

    /**
      Allows you to specify a controller action to invoke when a field loses
      focus. To use this method, give your field a `focus-out` attribute. The value
      of that attribute should be the name of the action in your controller
      that you wish to invoke.
       For an example on how to use the `focus-out` attribute, please reference the
      example near the top of this file.
       @method focusOut
      @param {Event} event
      @private
    */
    focusOut: function (event) {
      this._elementValueDidChange(event);
      sendAction('focus-out', this, event);
    },

    /**
      Allows you to specify a controller action to invoke when a key is pressed.
      To use this method, give your field a `key-press` attribute. The value of
      that attribute should be the name of the action in your controller you
      that wish to invoke.
       For an example on how to use the `key-press` attribute, please reference the
      example near the top of this file.
       @method keyPress
      @param {Event} event
      @private
    */
    keyPress: function (event) {
      sendAction('key-press', this, event);
    },

    /**
      Allows you to specify a controller action to invoke when a key-up event is
      fired. To use this method, give your field a `key-up` attribute. The value
      of that attribute should be the name of the action in your controller
      that you wish to invoke.
       For an example on how to use the `key-up` attribute, please reference the
      example near the top of this file.
       @method keyUp
      @param {Event} event
      @private
    */
    keyUp: function (event) {
      this.interpretKeyEvents(event);

      this.sendAction('key-up', _emberMetalProperty_get.get(this, 'value'), event);
    },

    /**
      Allows you to specify a controller action to invoke when a key-down event is
      fired. To use this method, give your field a `key-down` attribute. The value
      of that attribute should be the name of the action in your controller that
      you wish to invoke.
       For an example on how to use the `key-down` attribute, please reference the
      example near the top of this file.
       @method keyDown
      @param {Event} event
      @private
    */
    keyDown: function (event) {
      this.sendAction('key-down', _emberMetalProperty_get.get(this, 'value'), event);
    }
  });

  // In principle, this shouldn't be necessary, but the legacy
  // sendAction semantics for TextField are different from
  // the component semantics so this method normalizes them.
  function sendAction(eventName, view, event) {
    var action = _emberMetalProperty_get.get(view, 'attrs.' + eventName) || _emberMetalProperty_get.get(view, eventName);
    var on = _emberMetalProperty_get.get(view, 'onEvent');
    var value = _emberMetalProperty_get.get(view, 'value');

    // back-compat support for keyPress as an event name even though
    // it's also a method name that consumes the event (and therefore
    // incompatible with sendAction semantics).
    if (on === eventName || on === 'keyPress' && eventName === 'key-press') {
      view.sendAction('action', value);
    }

    view.sendAction(eventName, value);

    if (action || on === eventName) {
      if (!_emberMetalProperty_get.get(view, 'bubbles')) {
        event.stopPropagation();
      }
    }
  }
})(Em._e[222],Em._e[30],Em._e[32],Em._e[61],Em._e[103]);
(function (exports, _emberMetalComputed, _emberEnvironment, _emberHtmlbarsComponent, _emberViewsMixinsText_support, _emberMetalEmpty_object) {
  /**
  @module ember
  @submodule ember-views
  */
  'use strict';

  var inputTypeTestElement = undefined;
  var inputTypes = new _emberMetalEmpty_object.default();
  function canSetTypeOfInput(type) {
    if (type in inputTypes) {
      return inputTypes[type];
    }

    // if running in outside of a browser always return the
    // original type
    if (!_emberEnvironment.environment.hasDOM) {
      inputTypes[type] = type;

      return type;
    }

    if (!inputTypeTestElement) {
      inputTypeTestElement = document.createElement('input');
    }

    try {
      inputTypeTestElement.type = type;
    } catch (e) {}

    return inputTypes[type] = inputTypeTestElement.type === type;
  }

  /**
  
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `text`.
  
    See [Ember.Templates.helpers.input](/api/classes/Ember.Templates.helpers.html#method_input)  for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
    layout section for more information.
  
    @class TextField
    @namespace Ember
    @extends Ember.Component
    @uses Ember.TextSupport
    @public
  */
  exports.default = _emberHtmlbarsComponent.default.extend(_emberViewsMixinsText_support.default, {
    instrumentDisplay: '{{input type="text"}}',

    classNames: ['ember-text-field'],
    tagName: 'input',
    attributeBindings: ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'type', 'value', 'width'],

    defaultLayout: null,

    /**
      The `value` attribute of the input element. As the user inputs text, this
      property is updated live.
       @property value
      @type String
      @default ""
      @public
    */
    value: '',

    /**
      The `type` attribute of the input element.
       @property type
      @type String
      @default "text"
      @public
    */
    type: _emberMetalComputed.computed({
      get: function () {
        return 'text';
      },

      set: function (key, value) {
        var type = 'text';

        if (canSetTypeOfInput(value)) {
          type = value;
        }

        return type;
      }
    }),

    /**
      The `size` of the text field in characters.
       @property size
      @type String
      @default null
      @public
    */
    size: null,

    /**
      The `pattern` attribute of input element.
       @property pattern
      @type String
      @default null
      @public
    */
    pattern: null,

    /**
      The `min` attribute of input element used with `type="number"` or `type="range"`.
       @property min
      @type String
      @default null
      @since 1.4.0
      @public
    */
    min: null,

    /**
      The `max` attribute of input element used with `type="number"` or `type="range"`.
       @property max
      @type String
      @default null
      @since 1.4.0
      @public
    */
    max: null
  });
})(Em._e[223],Em._e[59],Em._e[4],Em._e[131],Em._e[222],Em._e[12]);
(function (exports, _emberHtmlbarsComponent, _emberViewsMixinsText_support) {
  /**
  @module ember
  @submodule ember-views
  */
  'use strict';

  /**
    The internal class used to create textarea element when the `{{textarea}}`
    helper is used.
  
    See [Ember.Templates.helpers.textarea](/api/classes/Ember.Templates.helpers.html#method_textarea)  for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `textarea` elements do not contain inner HTML the `layout` and
    `layoutName` properties will not be applied. See [Ember.View](/api/classes/Ember.View.html)'s
    layout section for more information.
  
    @class TextArea
    @namespace Ember
    @extends Ember.Component
    @uses Ember.TextSupport
    @public
  */
  exports.default = _emberHtmlbarsComponent.default.extend(_emberViewsMixinsText_support.default, {
    instrumentDisplay: '{{textarea}}',

    classNames: ['ember-text-area'],

    tagName: 'textarea',
    attributeBindings: ['rows', 'cols', 'name', 'selectionEnd', 'selectionStart', 'wrap', 'lang', 'dir', 'value'],
    rows: null,
    cols: null
  });
})(Em._e[224],Em._e[131],Em._e[222]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalComputed, _emberMetalIs_empty, _emberMetalIs_none, _emberMetalAlias, _emberMetalExpand_properties) {
  'use strict';

  exports.empty = empty;
  exports.notEmpty = notEmpty;
  exports.none = none;
  exports.not = not;
  exports.bool = bool;
  exports.match = match;
  exports.equal = equal;
  exports.gt = gt;
  exports.gte = gte;
  exports.lt = lt;
  exports.lte = lte;
  exports.oneWay = oneWay;
  exports.readOnly = readOnly;
  exports.deprecatingAlias = deprecatingAlias;

  /**
  @module ember
  @submodule ember-metal
  */

  function expandPropertiesToArray(predicateName, properties) {
    var expandedProperties = [];

    function extractProperty(entry) {
      expandedProperties.push(entry);
    }

    for (var i = 0; i < properties.length; i++) {
      var property = properties[i];

      _emberMetalExpand_properties.default(property, extractProperty);
    }

    return expandedProperties;
  }

  function generateComputedWithPredicate(name, predicate) {
    return function () {
      for (var _len = arguments.length, properties = Array(_len), _key = 0; _key < _len; _key++) {
        properties[_key] = arguments[_key];
      }

      var expandedProperties = expandPropertiesToArray(name, properties);

      var computedFunc = _emberMetalComputed.computed(function () {
        var lastIdx = expandedProperties.length - 1;

        for (var i = 0; i < lastIdx; i++) {
          var value = _emberMetalProperty_get.get(this, expandedProperties[i]);
          if (!predicate(value)) {
            return value;
          }
        }

        return _emberMetalProperty_get.get(this, expandedProperties[lastIdx]);
      });

      return computedFunc.property.apply(computedFunc, expandedProperties);
    };
  }

  /**
    A computed property that returns true if the value of the dependent
    property is null, an empty string, empty array, or empty function.
  
    Example
  
    ```javascript
    let ToDoList = Ember.Object.extend({
      isDone: Ember.computed.empty('todos')
    });
  
    let todoList = ToDoList.create({
      todos: ['Unit Test', 'Documentation', 'Release']
    });
  
    todoList.get('isDone'); // false
    todoList.get('todos').clear();
    todoList.get('isDone'); // true
    ```
  
    @since 1.6.0
    @method empty
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which negate
    the original value for property
    @public
  */

  function empty(dependentKey) {
    return _emberMetalComputed.computed(dependentKey + '.length', function () {
      return _emberMetalIs_empty.default(_emberMetalProperty_get.get(this, dependentKey));
    });
  }

  /**
    A computed property that returns true if the value of the dependent
    property is NOT null, an empty string, empty array, or empty function.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      hasStuff: Ember.computed.notEmpty('backpack')
    });
  
    let hamster = Hamster.create({ backpack: ['Food', 'Sleeping Bag', 'Tent'] });
  
    hamster.get('hasStuff');         // true
    hamster.get('backpack').clear(); // []
    hamster.get('hasStuff');         // false
    ```
  
    @method notEmpty
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which returns true if
    original value for property is not empty.
    @public
  */

  function notEmpty(dependentKey) {
    return _emberMetalComputed.computed(dependentKey + '.length', function () {
      return !_emberMetalIs_empty.default(_emberMetalProperty_get.get(this, dependentKey));
    });
  }

  /**
    A computed property that returns true if the value of the dependent
    property is null or undefined. This avoids errors from JSLint complaining
    about use of ==, which can be technically confusing.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      isHungry: Ember.computed.none('food')
    });
  
    let hamster = Hamster.create();
  
    hamster.get('isHungry'); // true
    hamster.set('food', 'Banana');
    hamster.get('isHungry'); // false
    hamster.set('food', null);
    hamster.get('isHungry'); // true
    ```
  
    @method none
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which
    returns true if original value for property is null or undefined.
    @public
  */

  function none(dependentKey) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return _emberMetalIs_none.default(_emberMetalProperty_get.get(this, dependentKey));
    });
  }

  /**
    A computed property that returns the inverse boolean value
    of the original value for the dependent property.
  
    Example
  
    ```javascript
    let User = Ember.Object.extend({
      isAnonymous: Ember.computed.not('loggedIn')
    });
  
    let user = User.create({loggedIn: false});
  
    user.get('isAnonymous'); // true
    user.set('loggedIn', true);
    user.get('isAnonymous'); // false
    ```
  
    @method not
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which returns
    inverse of the original value for property
    @public
  */

  function not(dependentKey) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return !_emberMetalProperty_get.get(this, dependentKey);
    });
  }

  /**
    A computed property that converts the provided dependent property
    into a boolean value.
  
    ```javascript
    let Hamster = Ember.Object.extend({
      hasBananas: Ember.computed.bool('numBananas')
    });
  
    let hamster = Hamster.create();
  
    hamster.get('hasBananas'); // false
    hamster.set('numBananas', 0);
    hamster.get('hasBananas'); // false
    hamster.set('numBananas', 1);
    hamster.get('hasBananas'); // true
    hamster.set('numBananas', null);
    hamster.get('hasBananas'); // false
    ```
  
    @method bool
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which converts
    to boolean the original value for property
    @public
  */

  function bool(dependentKey) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return !!_emberMetalProperty_get.get(this, dependentKey);
    });
  }

  /**
    A computed property which matches the original value for the
    dependent property against a given RegExp, returning `true`
    if the value matches the RegExp and `false` if it does not.
  
    Example
  
    ```javascript
    let User = Ember.Object.extend({
      hasValidEmail: Ember.computed.match('email', /^.+@.+\..+$/)
    });
  
    let user = User.create({loggedIn: false});
  
    user.get('hasValidEmail'); // false
    user.set('email', '');
    user.get('hasValidEmail'); // false
    user.set('email', 'ember_hamster@example.com');
    user.get('hasValidEmail'); // true
    ```
  
    @method match
    @for Ember.computed
    @param {String} dependentKey
    @param {RegExp} regexp
    @return {Ember.ComputedProperty} computed property which match
    the original value for property against a given RegExp
    @public
  */

  function match(dependentKey, regexp) {
    return _emberMetalComputed.computed(dependentKey, function () {
      var value = _emberMetalProperty_get.get(this, dependentKey);

      return typeof value === 'string' ? regexp.test(value) : false;
    });
  }

  /**
    A computed property that returns true if the provided dependent property
    is equal to the given value.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      napTime: Ember.computed.equal('state', 'sleepy')
    });
  
    let hamster = Hamster.create();
  
    hamster.get('napTime'); // false
    hamster.set('state', 'sleepy');
    hamster.get('napTime'); // true
    hamster.set('state', 'hungry');
    hamster.get('napTime'); // false
    ```
  
    @method equal
    @for Ember.computed
    @param {String} dependentKey
    @param {String|Number|Object} value
    @return {Ember.ComputedProperty} computed property which returns true if
    the original value for property is equal to the given value.
    @public
  */

  function equal(dependentKey, value) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return _emberMetalProperty_get.get(this, dependentKey) === value;
    });
  }

  /**
    A computed property that returns true if the provided dependent property
    is greater than the provided value.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      hasTooManyBananas: Ember.computed.gt('numBananas', 10)
    });
  
    let hamster = Hamster.create();
  
    hamster.get('hasTooManyBananas'); // false
    hamster.set('numBananas', 3);
    hamster.get('hasTooManyBananas'); // false
    hamster.set('numBananas', 11);
    hamster.get('hasTooManyBananas'); // true
    ```
  
    @method gt
    @for Ember.computed
    @param {String} dependentKey
    @param {Number} value
    @return {Ember.ComputedProperty} computed property which returns true if
    the original value for property is greater than given value.
    @public
  */

  function gt(dependentKey, value) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return _emberMetalProperty_get.get(this, dependentKey) > value;
    });
  }

  /**
    A computed property that returns true if the provided dependent property
    is greater than or equal to the provided value.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      hasTooManyBananas: Ember.computed.gte('numBananas', 10)
    });
  
    let hamster = Hamster.create();
  
    hamster.get('hasTooManyBananas'); // false
    hamster.set('numBananas', 3);
    hamster.get('hasTooManyBananas'); // false
    hamster.set('numBananas', 10);
    hamster.get('hasTooManyBananas'); // true
    ```
  
    @method gte
    @for Ember.computed
    @param {String} dependentKey
    @param {Number} value
    @return {Ember.ComputedProperty} computed property which returns true if
    the original value for property is greater or equal then given value.
    @public
  */

  function gte(dependentKey, value) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return _emberMetalProperty_get.get(this, dependentKey) >= value;
    });
  }

  /**
    A computed property that returns true if the provided dependent property
    is less than the provided value.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      needsMoreBananas: Ember.computed.lt('numBananas', 3)
    });
  
    let hamster = Hamster.create();
  
    hamster.get('needsMoreBananas'); // true
    hamster.set('numBananas', 3);
    hamster.get('needsMoreBananas'); // false
    hamster.set('numBananas', 2);
    hamster.get('needsMoreBananas'); // true
    ```
  
    @method lt
    @for Ember.computed
    @param {String} dependentKey
    @param {Number} value
    @return {Ember.ComputedProperty} computed property which returns true if
    the original value for property is less then given value.
    @public
  */

  function lt(dependentKey, value) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return _emberMetalProperty_get.get(this, dependentKey) < value;
    });
  }

  /**
    A computed property that returns true if the provided dependent property
    is less than or equal to the provided value.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      needsMoreBananas: Ember.computed.lte('numBananas', 3)
    });
  
    let hamster = Hamster.create();
  
    hamster.get('needsMoreBananas'); // true
    hamster.set('numBananas', 5);
    hamster.get('needsMoreBananas'); // false
    hamster.set('numBananas', 3);
    hamster.get('needsMoreBananas'); // true
    ```
  
    @method lte
    @for Ember.computed
    @param {String} dependentKey
    @param {Number} value
    @return {Ember.ComputedProperty} computed property which returns true if
    the original value for property is less or equal than given value.
    @public
  */

  function lte(dependentKey, value) {
    return _emberMetalComputed.computed(dependentKey, function () {
      return _emberMetalProperty_get.get(this, dependentKey) <= value;
    });
  }

  /**
    A computed property that performs a logical `and` on the
    original values for the provided dependent properties.
  
    You may pass in more than two properties and even use
    property brace expansion.  The computed property will
    return the first falsy value or last truthy value
    just like JavaScript's `&&` operator.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      readyForCamp: Ember.computed.and('hasTent', 'hasBackpack'),
      readyForHike: Ember.computed.and('hasWalkingStick', 'hasBackpack')
    });
  
    let tomster = Hamster.create();
  
    tomster.get('readyForCamp'); // false
    tomster.set('hasTent', true);
    tomster.get('readyForCamp'); // false
    tomster.set('hasBackpack', true);
    tomster.get('readyForCamp'); // true
    tomster.set('hasBackpack', 'Yes');
    tomster.get('readyForCamp'); // 'Yes'
    tomster.set('hasWalkingStick', null);
    tomster.get('readyForHike'); // null
    ```
  
    @method and
    @for Ember.computed
    @param {String} dependentKey*
    @return {Ember.ComputedProperty} computed property which performs
    a logical `and` on the values of all the original values for properties.
    @public
  */
  var and = generateComputedWithPredicate('and', function (value) {
    return value;
  });

  exports.and = and;
  /**
    A computed property which performs a logical `or` on the
    original values for the provided dependent properties.
  
    You may pass in more than two properties and even use
    property brace expansion.  The computed property will
    return the first truthy value or last falsy value just
    like JavaScript's `||` operator.
  
    Example
  
    ```javascript
    let Hamster = Ember.Object.extend({
      readyForRain: Ember.computed.or('hasJacket', 'hasUmbrella'),
      readyForBeach: Ember.computed.or('{hasSunscreen,hasUmbrella}')
    });
  
    let tomster = Hamster.create();
  
    tomster.get('readyForRain'); // undefined
    tomster.set('hasUmbrella', true);
    tomster.get('readyForRain'); // true
    tomster.set('hasJacket', 'Yes');
    tomster.get('readyForRain'); // 'Yes'
    tomster.set('hasSunscreen', 'Check');
    tomster.get('readyForBeach'); // 'Check'
    ```
  
    @method or
    @for Ember.computed
    @param {String} dependentKey*
    @return {Ember.ComputedProperty} computed property which performs
    a logical `or` on the values of all the original values for properties.
    @public
  */
  var or = generateComputedWithPredicate('or', function (value) {
    return !value;
  });

  exports.or = or;
  /**
    Creates a new property that is an alias for another property
    on an object. Calls to `get` or `set` this property behave as
    though they were called on the original property.
  
    ```javascript
    let Person = Ember.Object.extend({
      name: 'Alex Matchneer',
      nomen: Ember.computed.alias('name')
    });
  
    let alex = Person.create();
  
    alex.get('nomen'); // 'Alex Matchneer'
    alex.get('name');  // 'Alex Matchneer'
  
    alex.set('nomen', '@machty');
    alex.get('name');  // '@machty'
    ```
  
    @method alias
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which creates an
    alias to the original value for property.
    @public
  */

  /**
    Where `computed.alias` aliases `get` and `set`, and allows for bidirectional
    data flow, `computed.oneWay` only provides an aliased `get`. The `set` will
    not mutate the upstream property, rather causes the current property to
    become the value set. This causes the downstream property to permanently
    diverge from the upstream property.
  
    Example
  
    ```javascript
    let User = Ember.Object.extend({
      firstName: null,
      lastName: null,
      nickName: Ember.computed.oneWay('firstName')
    });
  
    let teddy = User.create({
      firstName: 'Teddy',
      lastName:  'Zeenny'
    });
  
    teddy.get('nickName');              // 'Teddy'
    teddy.set('nickName', 'TeddyBear'); // 'TeddyBear'
    teddy.get('firstName');             // 'Teddy'
    ```
  
    @method oneWay
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which creates a
    one way computed property to the original value for property.
    @public
  */

  function oneWay(dependentKey) {
    return _emberMetalAlias.default(dependentKey).oneWay();
  }

  /**
    This is a more semantically meaningful alias of `computed.oneWay`,
    whose name is somewhat ambiguous as to which direction the data flows.
  
    @method reads
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which creates a
      one way computed property to the original value for property.
    @public
   */

  /**
    Where `computed.oneWay` provides oneWay bindings, `computed.readOnly` provides
    a readOnly one way binding. Very often when using `computed.oneWay` one does
    not also want changes to propagate back up, as they will replace the value.
  
    This prevents the reverse flow, and also throws an exception when it occurs.
  
    Example
  
    ```javascript
    let User = Ember.Object.extend({
      firstName: null,
      lastName: null,
      nickName: Ember.computed.readOnly('firstName')
    });
  
    let teddy = User.create({
      firstName: 'Teddy',
      lastName:  'Zeenny'
    });
  
    teddy.get('nickName');              // 'Teddy'
    teddy.set('nickName', 'TeddyBear'); // throws Exception
    // throw new Ember.Error('Cannot Set: nickName on: <User:ember27288>' );`
    teddy.get('firstName');             // 'Teddy'
    ```
  
    @method readOnly
    @for Ember.computed
    @param {String} dependentKey
    @return {Ember.ComputedProperty} computed property which creates a
    one way computed property to the original value for property.
    @since 1.5.0
    @public
  */

  function readOnly(dependentKey) {
    return _emberMetalAlias.default(dependentKey).readOnly();
  }

  /**
    Creates a new property that is an alias for another property
    on an object. Calls to `get` or `set` this property behave as
    though they were called on the original property, but also
    print a deprecation warning.
  
    ```javascript
    let Hamster = Ember.Object.extend({
      bananaCount: Ember.computed.deprecatingAlias('cavendishCount', {
        id: 'hamster.deprecate-banana',
        until: '3.0.0'
      })
    });
  
    let hamster = Hamster.create();
  
    hamster.set('bananaCount', 5); // Prints a deprecation warning.
    hamster.get('cavendishCount'); // 5
    ```
  
    @method deprecatingAlias
    @for Ember.computed
    @param {String} dependentKey
    @param {Object} options Options for `Ember.deprecate`.
    @return {Ember.ComputedProperty} computed property which creates an
    alias with a deprecation to the original value for property.
    @since 1.7.0
    @public
  */

  function deprecatingAlias(dependentKey, options) {
    return _emberMetalComputed.computed(dependentKey, {
      get: function (key) {
        return _emberMetalProperty_get.get(this, dependentKey);
      },
      set: function (key, value) {
        _emberMetalProperty_set.set(this, dependentKey, value);
        return value;
      }
    });
  }
})(Em._e[225],Em._e[0],Em._e[30],Em._e[32],Em._e[59],Em._e[92],Em._e[75],Em._e[62],Em._e[57]);
(function (exports, _emberRuntimeSystemObject, _emberRuntimeInject) {
  'use strict';

  /**
    Creates a property that lazily looks up a service in the container. There
    are no restrictions as to what objects a service can be injected into.
  
    Example:
  
    ```javascript
    App.ApplicationRoute = Ember.Route.extend({
      authManager: Ember.inject.service('auth'),
  
      model: function() {
        return this.get('authManager').findCurrentUser();
      }
    });
    ```
  
    This example will create an `authManager` property on the application route
    that looks up the `auth` service in the container, making it easily
    accessible in the `model` hook.
  
    @method service
    @since 1.10.0
    @for Ember.inject
    @param {String} name (optional) name of the service to inject, defaults to
           the property's name
    @return {Ember.InjectedProperty} injection descriptor instance
    @public
  */
  _emberRuntimeInject.createInjectionHelper('service');

  /**
    @class Service
    @namespace Ember
    @extends Ember.Object
    @since 1.10.0
    @public
  */
  var Service = _emberRuntimeSystemObject.default.extend();

  Service.reopenClass({
    isServiceFactory: true
  });

  exports.default = Service;
})(Em._e[226],Em._e[77],Em._e[72]);
(function (exports, _emberHtmlbars) {
  "use strict";

  exports.default = _emberHtmlbars.template((function () {
    var child0 = (function () {
      return {
        meta: {},
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["content", "linkTitle", ["loc", [null, [1, 17], [1, 30]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    var child1 = (function () {
      return {
        meta: {},
        isEmpty: false,
        arity: 0,
        cachedFragment: null,
        hasRendered: false,
        buildFragment: function buildFragment(dom) {
          var el0 = dom.createDocumentFragment();
          var el1 = dom.createComment("");
          dom.appendChild(el0, el1);
          return el0;
        },
        buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
          var morphs = new Array(1);
          morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
          dom.insertBoundary(fragment, 0);
          dom.insertBoundary(fragment, null);
          return morphs;
        },
        statements: [["content", "yield", ["loc", [null, [1, 38], [1, 47]]], 0, 0, 0, 0]],
        locals: [],
        templates: []
      };
    })();
    return {
      meta: {},
      isEmpty: false,
      arity: 0,
      cachedFragment: null,
      hasRendered: false,
      buildFragment: function buildFragment(dom) {
        var el0 = dom.createDocumentFragment();
        var el1 = dom.createComment("");
        dom.appendChild(el0, el1);
        return el0;
      },
      buildRenderNodes: function buildRenderNodes(dom, fragment, contextualElement) {
        var morphs = new Array(1);
        morphs[0] = dom.createMorphAt(fragment, 0, 0, contextualElement);
        dom.insertBoundary(fragment, 0);
        dom.insertBoundary(fragment, null);
        return morphs;
      },
      statements: [["block", "if", [["get", "linkTitle", ["loc", [null, [1, 6], [1, 15]]], 0, 0, 0, 0]], [], 0, 1, ["loc", [null, [1, 0], [1, 54]]]]],
      locals: [],
      templates: [child0, child1]
    };
  })());
})(Em._e[227],Em._e[195]);
(function (exports, _emberConsole, _emberMetalDebug, _emberMetalProperty_get, _emberMetalComputed, _emberRuntimeComputedComputed_macros, _emberViewsSystemUtils, _emberRuntimeInject, _emberRuntimeSystemService, _emberRuntimeMixinsController, _emberHtmlbarsTemplatesLinkTo, _emberHtmlbarsComponent, _emberMetalInstrumentation) {
  /**
  @module ember
  @submodule ember-templates
  */

  /**
    The `{{link-to}}` component renders a link to the supplied
    `routeName` passing an optionally supplied model to the
    route as its `model` context of the route. The block
    for `{{link-to}}` becomes the innerHTML of the rendered
    element:
  
    ```handlebars
    {{#link-to 'photoGallery'}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    You can also use an inline form of `{{link-to}}` component by
    passing the link text as the first argument
    to the component:
  
    ```handlebars
    {{link-to 'Great Hamster Photos' 'photoGallery'}}
    ```
  
    Both will result in:
  
    ```html
    <a href="/hamster-photos">
      Great Hamster Photos
    </a>
    ```
  
    ### Supplying a tagName
    By default `{{link-to}}` renders an `<a>` element. This can
    be overridden for a single use of `{{link-to}}` by supplying
    a `tagName` option:
  
    ```handlebars
    {{#link-to 'photoGallery' tagName="li"}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    ```html
    <li>
      Great Hamster Photos
    </li>
    ```
  
    To override this option for your entire application, see
    "Overriding Application-wide Defaults".
  
    ### Disabling the `link-to` component
    By default `{{link-to}}` is enabled.
    any passed value to the `disabled` component property will disable
    the `link-to` component.
  
    static use: the `disabled` option:
  
    ```handlebars
    {{#link-to 'photoGallery' disabled=true}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    dynamic use: the `disabledWhen` option:
  
    ```handlebars
    {{#link-to 'photoGallery' disabledWhen=controller.someProperty}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    any passed value to `disabled` will disable it except `undefined`.
    to ensure that only `true` disable the `link-to` component you can
    override the global behaviour of `Ember.LinkComponent`.
  
    ```javascript
    Ember.LinkComponent.reopen({
      disabled: Ember.computed(function(key, value) {
        if (value !== undefined) {
          this.set('_isDisabled', value === true);
        }
        return value === true ? get(this, 'disabledClass') : false;
      })
    });
    ```
  
    see "Overriding Application-wide Defaults" for more.
  
    ### Handling `href`
    `{{link-to}}` will use your application's Router to
    fill the element's `href` property with a url that
    matches the path to the supplied `routeName` for your
    router's configured `Location` scheme, which defaults
    to Ember.HashLocation.
  
    ### Handling current route
    `{{link-to}}` will apply a CSS class name of 'active'
    when the application's current route matches
    the supplied routeName. For example, if the application's
    current route is 'photoGallery.recent' the following
    use of `{{link-to}}`:
  
    ```handlebars
    {{#link-to 'photoGallery.recent'}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    will result in
  
    ```html
    <a href="/hamster-photos/this-week" class="active">
      Great Hamster Photos
    </a>
    ```
  
    The CSS class name used for active classes can be customized
    for a single use of `{{link-to}}` by passing an `activeClass`
    option:
  
    ```handlebars
    {{#link-to 'photoGallery.recent' activeClass="current-url"}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/this-week" class="current-url">
      Great Hamster Photos
    </a>
    ```
  
    To override this option for your entire application, see
    "Overriding Application-wide Defaults".
  
    ### Keeping a link active for other routes
  
    If you need a link to be 'active' even when it doesn't match
    the current route, you can use the `current-when` argument.
  
    ```handlebars
    {{#link-to 'photoGallery' current-when='photos'}}
      Photo Gallery
    {{/link-to}}
    ```
  
    This may be helpful for keeping links active for:
  
    * non-nested routes that are logically related
    * some secondary menu approaches
    * 'top navigation' with 'sub navigation' scenarios
  
    A link will be active if `current-when` is `true` or the current
    route is the route this link would transition to.
  
    To match multiple routes 'space-separate' the routes:
  
    ```handlebars
    {{#link-to 'gallery' current-when='photos drawings paintings'}}
      Art Gallery
    {{/link-to}}
    ```
  
    ### Supplying a model
    An optional model argument can be used for routes whose
    paths contain dynamic segments. This argument will become
    the model context of the linked route:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", {path: "hamster-photos/:photo_id"});
    });
    ```
  
    ```handlebars
    {{#link-to 'photoGallery' aPhoto}}
      {{aPhoto.title}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    ### Supplying multiple models
    For deep-linking to route paths that contain multiple
    dynamic segments, multiple model arguments can be used.
    As the router transitions through the route path, each
    supplied model argument will become the context for the
    route with the dynamic segments:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" }, function() {
        this.route("comment", {path: "comments/:comment_id"});
      });
    });
    ```
    This argument will become the model context of the linked route:
  
    ```handlebars
    {{#link-to 'photoGallery.comment' aPhoto comment}}
      {{comment.body}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42/comments/718">
      A+++ would snuggle again.
    </a>
    ```
  
    ### Supplying an explicit dynamic segment value
    If you don't have a model object available to pass to `{{link-to}}`,
    an optional string or integer argument can be passed for routes whose
    paths contain dynamic segments. This argument will become the value
    of the dynamic segment:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" });
    });
    ```
  
    ```handlebars
    {{#link-to 'photoGallery' aPhotoId}}
      {{aPhoto.title}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    When transitioning into the linked route, the `model` hook will
    be triggered with parameters including this passed identifier.
  
    ### Allowing Default Action
  
   By default the `{{link-to}}` component prevents the default browser action
   by calling `preventDefault()` as this sort of action bubbling is normally
   handled internally and we do not want to take the browser to a new URL (for
   example).
  
   If you need to override this behavior specify `preventDefault=false` in
   your template:
  
    ```handlebars
    {{#link-to 'photoGallery' aPhotoId preventDefault=false}}
      {{aPhotoId.title}}
    {{/link-to}}
    ```
  
    ### Overriding attributes
    You can override any given property of the `Ember.LinkComponent`
    that is generated by the `{{link-to}}` component by passing
    key/value pairs, like so:
  
    ```handlebars
    {{#link-to  aPhoto tagName='li' title='Following this link will change your life' classNames='pic sweet'}}
      Uh-mazing!
    {{/link-to}}
    ```
  
    See [Ember.LinkComponent](/api/classes/Ember.LinkComponent.html) for a
    complete list of overrideable properties. Be sure to also
    check out inherited properties of `LinkComponent`.
  
    ### Overriding Application-wide Defaults
    ``{{link-to}}`` creates an instance of `Ember.LinkComponent`
    for rendering. To override options for your entire
    application, reopen `Ember.LinkComponent` and supply the
    desired values:
  
    ``` javascript
    Ember.LinkComponent.reopen({
      activeClass: "is-active",
      tagName: 'li'
    })
    ```
  
    It is also possible to override the default event in
    this manner:
  
    ``` javascript
    Ember.LinkComponent.reopen({
      eventName: 'customEventName'
    });
    ```
  
    @method link-to
    @for Ember.Templates.helpers
    @param {String} routeName
    @param {Object} [context]*
    @param [options] {Object} Handlebars key/value pairs of options, you can override any property of Ember.LinkComponent
    @return {String} HTML string
    @see {Ember.LinkComponent}
    @public
  */

  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  /**
    `Ember.LinkComponent` renders an element whose `click` event triggers a
    transition of the application's instance of `Ember.Router` to
    a supplied route by name.
  
    `Ember.LinkComponent` components are invoked with {{#link-to}}. Properties
    of this class can be overridden with `reopen` to customize application-wide
    behavior.
  
    @class LinkComponent
    @namespace Ember
    @extends Ember.Component
    @see {Ember.Templates.helpers.link-to}
    @private
  **/
  var LinkComponent = _emberHtmlbarsComponent.default.extend({
    layout: _emberHtmlbarsTemplatesLinkTo.default,

    tagName: 'a',

    /**
      @deprecated Use current-when instead.
      @property currentWhen
      @private
    */
    currentWhen: _emberRuntimeComputedComputed_macros.deprecatingAlias('current-when', { id: 'ember-routing-view.deprecated-current-when', until: '3.0.0' }),

    /**
      Used to determine when this `LinkComponent` is active.
       @property currentWhen
      @public
    */
    'current-when': null,

    /**
      Sets the `title` attribute of the `LinkComponent`'s HTML element.
       @property title
      @default null
      @public
    **/
    title: null,

    /**
      Sets the `rel` attribute of the `LinkComponent`'s HTML element.
       @property rel
      @default null
      @public
    **/
    rel: null,

    /**
      Sets the `tabindex` attribute of the `LinkComponent`'s HTML element.
       @property tabindex
      @default null
      @public
    **/
    tabindex: null,

    /**
      Sets the `target` attribute of the `LinkComponent`'s HTML element.
       @since 1.8.0
      @property target
      @default null
      @public
    **/
    target: null,

    /**
      The CSS class to apply to `LinkComponent`'s element when its `active`
      property is `true`.
       @property activeClass
      @type String
      @default active
      @private
    **/
    activeClass: 'active',

    /**
      The CSS class to apply to `LinkComponent`'s element when its `loading`
      property is `true`.
       @property loadingClass
      @type String
      @default loading
      @private
    **/
    loadingClass: 'loading',

    /**
      The CSS class to apply to a `LinkComponent`'s element when its `disabled`
      property is `true`.
       @property disabledClass
      @type String
      @default disabled
      @private
    **/
    disabledClass: 'disabled',
    _isDisabled: false,

    /**
      Determines whether the `LinkComponent` will trigger routing via
      the `replaceWith` routing strategy.
       @property replace
      @type Boolean
      @default false
      @public
    **/
    replace: false,

    /**
      By default the `{{link-to}}` component will bind to the `href` and
      `title` attributes. It's discouraged that you override these defaults,
      however you can push onto the array if needed.
       @property attributeBindings
      @type Array | String
      @default ['title', 'rel', 'tabindex', 'target']
      @public
    */
    attributeBindings: ['href', 'title', 'rel', 'tabindex', 'target'],

    /**
      By default the `{{link-to}}` component will bind to the `active`, `loading`,
      and `disabled` classes. It is discouraged to override these directly.
       @property classNameBindings
      @type Array
      @default ['active', 'loading', 'disabled', 'ember-transitioning-in', 'ember-transitioning-out']
      @public
    */
    classNameBindings: ['active', 'loading', 'disabled', 'transitioningIn', 'transitioningOut'],

    /**
      By default the `{{link-to}}` component responds to the `click` event. You
      can override this globally by setting this property to your custom
      event name.
       This is particularly useful on mobile when one wants to avoid the 300ms
      click delay using some sort of custom `tap` event.
       @property eventName
      @type String
      @default click
      @private
    */
    eventName: 'click',

    // this is doc'ed here so it shows up in the events
    // section of the API documentation, which is where
    // people will likely go looking for it.
    /**
      Triggers the `LinkComponent`'s routing behavior. If
      `eventName` is changed to a value other than `click`
      the routing behavior will trigger on that custom event
      instead.
       @event click
      @private
    */

    /**
      An overridable method called when `LinkComponent` objects are instantiated.
       Example:
       ```javascript
      App.MyLinkComponent = Ember.LinkComponent.extend({
        init: function() {
          this._super(...arguments);
          Ember.Logger.log('Event is ' + this.get('eventName'));
        }
      });
      ```
       NOTE: If you do override `init` for a framework class like `Ember.View`,
      be sure to call `this._super(...arguments)` in your
      `init` declaration! If you don't, Ember may not have an opportunity to
      do important setup work, and you'll see strange behavior in your
      application.
       @method init
      @private
    */
    init: function () {
      this._super.apply(this, arguments);

      // Map desired event name to invoke function
      var eventName = _emberMetalProperty_get.get(this, 'eventName');
      this.on(eventName, this, this._invoke);
    },

    _routing: _emberRuntimeInject.default.service('-routing'),

    /**
      Accessed as a classname binding to apply the `LinkComponent`'s `disabledClass`
      CSS `class` to the element when the link is disabled.
       When `true` interactions with the element will not trigger route changes.
      @property disabled
      @private
    */
    disabled: _emberMetalComputed.computed({
      get: function (key, value) {
        return false;
      },
      set: function (key, value) {
        if (value !== undefined) {
          this.set('_isDisabled', value);
        }

        return value ? _emberMetalProperty_get.get(this, 'disabledClass') : false;
      }
    }),

    _computeActive: function (routerState) {
      if (_emberMetalProperty_get.get(this, 'loading')) {
        return false;
      }

      var routing = _emberMetalProperty_get.get(this, '_routing');
      var models = _emberMetalProperty_get.get(this, 'models');
      var resolvedQueryParams = _emberMetalProperty_get.get(this, 'resolvedQueryParams');

      var currentWhen = _emberMetalProperty_get.get(this, 'current-when');
      var isCurrentWhenSpecified = !!currentWhen;
      currentWhen = currentWhen || _emberMetalProperty_get.get(this, 'qualifiedRouteName');
      currentWhen = currentWhen.split(' ');

      for (var i = 0; i < currentWhen.length; i++) {
        if (routing.isActiveForRoute(models, resolvedQueryParams, currentWhen[i], routerState, isCurrentWhenSpecified)) {
          return _emberMetalProperty_get.get(this, 'activeClass');
        }
      }

      return false;
    },

    /**
      Accessed as a classname binding to apply the `LinkComponent`'s `activeClass`
      CSS `class` to the element when the link is active.
       A `LinkComponent` is considered active when its `currentWhen` property is `true`
      or the application's current route is the route the `LinkComponent` would trigger
      transitions into.
       The `currentWhen` property can match against multiple routes by separating
      route names using the ` ` (space) character.
       @property active
      @private
    */
    active: _emberMetalComputed.computed('attrs.params', '_routing.currentState', function computeLinkToComponentActive() {
      var currentState = _emberMetalProperty_get.get(this, '_routing.currentState');
      if (!currentState) {
        return false;
      }

      return this._computeActive(currentState);
    }),

    willBeActive: _emberMetalComputed.computed('_routing.targetState', function computeLinkToComponentWillBeActive() {
      var routing = _emberMetalProperty_get.get(this, '_routing');
      var targetState = _emberMetalProperty_get.get(routing, 'targetState');
      if (_emberMetalProperty_get.get(routing, 'currentState') === targetState) {
        return;
      }

      return !!this._computeActive(targetState);
    }),

    transitioningIn: _emberMetalComputed.computed('active', 'willBeActive', function computeLinkToComponentTransitioningIn() {
      var willBeActive = _emberMetalProperty_get.get(this, 'willBeActive');
      if (typeof willBeActive === 'undefined') {
        return false;
      }

      return !_emberMetalProperty_get.get(this, 'active') && willBeActive && 'ember-transitioning-in';
    }),

    transitioningOut: _emberMetalComputed.computed('active', 'willBeActive', function computeLinkToComponentTransitioningOut() {
      var willBeActive = _emberMetalProperty_get.get(this, 'willBeActive');
      if (typeof willBeActive === 'undefined') {
        return false;
      }

      return _emberMetalProperty_get.get(this, 'active') && !willBeActive && 'ember-transitioning-out';
    }),

    /**
      Event handler that invokes the link, activating the associated route.
       @method _invoke
      @param {Event} event
      @private
    */
    _invoke: function (event) {
      if (!_emberViewsSystemUtils.isSimpleClick(event)) {
        return true;
      }

      var preventDefault = _emberMetalProperty_get.get(this, 'preventDefault');
      var targetAttribute = _emberMetalProperty_get.get(this, 'target');

      if (preventDefault !== false) {
        if (!targetAttribute || targetAttribute === '_self') {
          event.preventDefault();
        }
      }

      if (_emberMetalProperty_get.get(this, 'bubbles') === false) {
        event.stopPropagation();
      }

      if (_emberMetalProperty_get.get(this, '_isDisabled')) {
        return false;
      }

      if (_emberMetalProperty_get.get(this, 'loading')) {
        _emberConsole.default.warn('This link-to is in an inactive loading state because at least one of its parameters presently has a null/undefined value, or the provided route name is invalid.');
        return false;
      }

      if (targetAttribute && targetAttribute !== '_self') {
        return false;
      }

      var qualifiedRouteName = _emberMetalProperty_get.get(this, 'qualifiedRouteName');
      var models = _emberMetalProperty_get.get(this, 'models');
      var queryParams = _emberMetalProperty_get.get(this, 'queryParams.values');
      var shouldReplace = _emberMetalProperty_get.get(this, 'replace');

      var payload = {
        queryParams: queryParams,
        routeName: qualifiedRouteName
      };

      _emberMetalInstrumentation.flaggedInstrument('interaction.link-to', payload, this._generateTransition(payload, qualifiedRouteName, models, queryParams, shouldReplace));
    },

    _generateTransition: function (payload, qualifiedRouteName, models, queryParams, shouldReplace) {
      var routing = _emberMetalProperty_get.get(this, '_routing');
      return function () {
        payload.transition = routing.transitionTo(qualifiedRouteName, models, queryParams, shouldReplace);
      };
    },

    queryParams: null,

    qualifiedRouteName: _emberMetalComputed.computed('targetRouteName', '_routing.currentState', function computeLinkToComponentQualifiedRouteName() {
      var params = _emberMetalProperty_get.get(this, 'params').slice();
      var lastParam = params[params.length - 1];
      if (lastParam && lastParam.isQueryParams) {
        params.pop();
      }
      var onlyQueryParamsSupplied = this[_emberHtmlbarsComponent.HAS_BLOCK] ? params.length === 0 : params.length === 1;
      if (onlyQueryParamsSupplied) {
        return _emberMetalProperty_get.get(this, '_routing.currentRouteName');
      }
      return _emberMetalProperty_get.get(this, 'targetRouteName');
    }),

    resolvedQueryParams: _emberMetalComputed.computed('queryParams', function computeLinkToComponentResolvedQueryParams() {
      var resolvedQueryParams = {};
      var queryParams = _emberMetalProperty_get.get(this, 'queryParams');

      if (!queryParams) {
        return resolvedQueryParams;
      }

      var values = queryParams.values;
      for (var key in values) {
        if (!values.hasOwnProperty(key)) {
          continue;
        }
        resolvedQueryParams[key] = values[key];
      }

      return resolvedQueryParams;
    }),

    /**
      Sets the element's `href` attribute to the url for
      the `LinkComponent`'s targeted route.
       If the `LinkComponent`'s `tagName` is changed to a value other
      than `a`, this property will be ignored.
       @property href
      @private
    */
    href: _emberMetalComputed.computed('models', 'qualifiedRouteName', function computeLinkToComponentHref() {
      if (_emberMetalProperty_get.get(this, 'tagName') !== 'a') {
        return;
      }

      var qualifiedRouteName = _emberMetalProperty_get.get(this, 'qualifiedRouteName');
      var models = _emberMetalProperty_get.get(this, 'models');

      if (_emberMetalProperty_get.get(this, 'loading')) {
        return _emberMetalProperty_get.get(this, 'loadingHref');
      }

      var routing = _emberMetalProperty_get.get(this, '_routing');
      var queryParams = _emberMetalProperty_get.get(this, 'queryParams.values');
      return routing.generateURL(qualifiedRouteName, models, queryParams);
    }),

    loading: _emberMetalComputed.computed('_modelsAreLoaded', 'qualifiedRouteName', function computeLinkToComponentLoading() {
      var qualifiedRouteName = _emberMetalProperty_get.get(this, 'qualifiedRouteName');
      var modelsAreLoaded = _emberMetalProperty_get.get(this, '_modelsAreLoaded');

      if (!modelsAreLoaded || qualifiedRouteName == null) {
        return _emberMetalProperty_get.get(this, 'loadingClass');
      }
    }),

    _modelsAreLoaded: _emberMetalComputed.computed('models', function computeLinkToComponentModelsAreLoaded() {
      var models = _emberMetalProperty_get.get(this, 'models');
      for (var i = 0; i < models.length; i++) {
        if (models[i] == null) {
          return false;
        }
      }

      return true;
    }),

    _getModels: function (params) {
      var modelCount = params.length - 1;
      var models = new Array(modelCount);

      for (var i = 0; i < modelCount; i++) {
        var value = params[i + 1];

        while (_emberRuntimeMixinsController.default.detect(value)) {
          value = value.get('model');
        }

        models[i] = value;
      }

      return models;
    },

    /**
      The default href value to use while a link-to is loading.
      Only applies when tagName is 'a'
       @property loadingHref
      @type String
      @default #
      @private
    */
    loadingHref: '#',

    willRender: function () {
      var queryParams = undefined;

      var params = _emberMetalProperty_get.get(this, 'params');

      if (params) {
        // Do not mutate params in place
        params = params.slice();
      }

      var disabledWhen = _emberMetalProperty_get.get(this, 'disabledWhen');
      if (disabledWhen !== undefined) {
        this.set('disabled', disabledWhen);
      }

      // Process the positional arguments, in order.
      // 1. Inline link title comes first, if present.
      if (!this[_emberHtmlbarsComponent.HAS_BLOCK]) {
        this.set('linkTitle', params.shift());
      }

      // 2. `targetRouteName` is now always at index 0.
      this.set('targetRouteName', params[0]);

      // 3. The last argument (if still remaining) is the `queryParams` object.
      var lastParam = params[params.length - 1];

      if (lastParam && lastParam.isQueryParams) {
        queryParams = params.pop();
      } else {
        queryParams = {};
      }
      this.set('queryParams', queryParams);

      // 4. Any remaining indices (excepting `targetRouteName` at 0) are `models`.
      if (params.length > 1) {
        this.set('models', this._getModels(params));
      } else {
        this.set('models', []);
      }
    }
  });

  LinkComponent.toString = function () {
    return 'LinkComponent';
  };

  LinkComponent.reopenClass({
    positionalParams: 'params'
  });

  exports.default = LinkComponent;
})(Em._e[228],Em._e[5],Em._e[0],Em._e[30],Em._e[59],Em._e[225],Em._e[128],Em._e[72],Em._e[226],Em._e[65],Em._e[227],Em._e[131],Em._e[98]);
(function (exports, _emberMetalFeatures, _emberMetalDebug) {
  /**
  @module ember
  @submodule ember-glimmer
  */

  'use strict';

  exports.getSafeString = getSafeString;
  exports.escapeExpression = escapeExpression;
  exports.htmlSafe = htmlSafe;
  exports.isHTMLSafe = isHTMLSafe;

  function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

  var SafeString = (function () {
    function SafeString(string) {
      _classCallCheck(this, SafeString);

      this.string = string;
    }

    SafeString.prototype.toString = function toString() {
      return '' + this.string;
    };

    SafeString.prototype.toHTML = function toHTML() {
      return this.toString();
    };

    return SafeString;
  })();

  exports.SafeString = SafeString;

  function getSafeString() {

    return SafeString;
  }

  var escape = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    // jscs:disable
    "'": '&#x27;',
    // jscs:enable
    '`': '&#x60;',
    '=': '&#x3D;'
  };

  var possible = /[&<>"'`=]/;
  var badChars = /[&<>"'`=]/g;

  function escapeChar(chr) {
    return escape[chr];
  }

  function escapeExpression(string) {
    if (typeof string !== 'string') {
      // don't escape SafeStrings, since they're already safe
      if (string && string.toHTML) {
        return string.toHTML();
      } else if (string == null) {
        return '';
      } else if (!string) {
        return string + '';
      }

      // Force a string conversion as this will be done by the append regardless and
      // the regex test will do this transparently behind the scenes, causing issues if
      // an object's to string has escaped characters in it.
      string = '' + string;
    }

    if (!possible.test(string)) {
      return string;
    }
    return string.replace(badChars, escapeChar);
  }

  /**
    Mark a string as safe for unescaped output with Ember templates. If you
    return HTML from a helper, use this function to
    ensure Ember's rendering layer does not escape the HTML.
  
    ```javascript
    Ember.String.htmlSafe('<div>someString</div>')
    ```
  
    @method htmlSafe
    @for Ember.String
    @static
    @return {Handlebars.SafeString} A string that will not be HTML escaped by Handlebars.
    @public
  */

  function htmlSafe(str) {
    if (str === null || str === undefined) {
      str = '';
    } else if (typeof str !== 'string') {
      str = '' + str;
    }
    return new SafeString(str);
  }

  /**
    Detects if a string was decorated using `Ember.String.htmlSafe`.
  
    ```javascript
    var plainString = 'plain string',
        safeString = Ember.String.htmlSafe('<div>someValue</div>');
  
    Ember.String.isHTMLSafe(plainString); // false
    Ember.String.isHTMLSafe(safeString);  // true
    ```
  
    @method isHTMLSafe
    @for Ember.String
    @static
    @return {Boolean} `true` if the string was decorated with `htmlSafe`, `false` otherwise.
    @public
  */

  function isHTMLSafe(str) {
    return str && typeof str.toHTML === 'function';
  }
})(Em._e[229],Em._e[10],Em._e[0]);
(function (exports, _emberMetalDebug, _emberHtmlbarsHelper) {
  /**
  @module ember
  @submodule ember-templates
  */
  'use strict';

  exports.default = makeBoundHelper;

  /**
    Create a bound helper. Accepts a function that receives the ordered and hash parameters
    from the template. If a bound property was provided in the template, it will be resolved to its
    value and any changes to the bound property cause the helper function to be re-run with the updated
    values.
  
    * `params` - An array of resolved ordered parameters.
    * `hash` - An object containing the hash parameters.
  
    For example:
  
    * With an unquoted ordered parameter:
  
      ```javascript
      {{x-capitalize foo}}
      ```
  
      Assuming `foo` was set to `"bar"`, the bound helper would receive `["bar"]` as its first argument, and
      an empty hash as its second.
  
    * With a quoted ordered parameter:
  
      ```javascript
      {{x-capitalize "foo"}}
      ```
  
      The bound helper would receive `["foo"]` as its first argument, and an empty hash as its second.
  
    * With an unquoted hash parameter:
  
      ```javascript
      {{x-repeat "foo" count=repeatCount}}
      ```
  
      Assuming that `repeatCount` resolved to 2, the bound helper would receive `["foo"]` as its first argument,
      and { count: 2 } as its second.
  
    @private
    @method makeBoundHelper
    @for Ember.HTMLBars
    @param {Function} fn
    @since 1.10.0
  */

  function makeBoundHelper(fn) {
    return _emberHtmlbarsHelper.helper(fn);
  }
})(Em._e[230],Em._e[0],Em._e[179]);
(function (exports, _emberMetalError, _emberMetalComputed, _containerOwner, _emberMetalMixin, _emberMetalProperty_get, _emberMetalDebug) {
  'use strict';

  exports.default = _emberMetalMixin.Mixin.create({
    /**
      @property isView
      @type Boolean
      @default true
      @static
      @private
    */
    isView: true,

    // ..........................................................
    // TEMPLATE SUPPORT
    //

    /**
      The name of the template to lookup if no template is provided.
       By default `Ember.View` will lookup a template with this name in
      `Ember.TEMPLATES` (a shared global object).
       @property templateName
      @type String
      @default null
      @private
    */
    templateName: null,

    /**
      The name of the layout to lookup if no layout is provided.
       By default `Ember.View` will lookup a template with this name in
      `Ember.TEMPLATES` (a shared global object).
       @property layoutName
      @type String
      @default null
      @private
    */
    layoutName: null,

    /**
      The template used to render the view. This should be a function that
      accepts an optional context parameter and returns a string of HTML that
      will be inserted into the DOM relative to its parent view.
       In general, you should set the `templateName` property instead of setting
      the template yourself.
       @property template
      @type Function
      @private
    */
    template: _emberMetalComputed.computed({
      get: function () {
        var templateName = _emberMetalProperty_get.get(this, 'templateName');
        var template = this.templateForName(templateName, 'template');

        return template || _emberMetalProperty_get.get(this, 'defaultTemplate');
      },
      set: function (key, value) {
        if (value !== undefined) {
          return value;
        }
        return _emberMetalProperty_get.get(this, key);
      }
    }),

    /**
      A view may contain a layout. A layout is a regular template but
      supersedes the `template` property during rendering. It is the
      responsibility of the layout template to retrieve the `template`
      property from the view (or alternatively, call `Handlebars.helpers.yield`,
      `{{yield}}`) to render it in the correct location.
       This is useful for a view that has a shared wrapper, but which delegates
      the rendering of the contents of the wrapper to the `template` property
      on a subclass.
       @property layout
      @type Function
      @private
    */
    layout: _emberMetalComputed.computed({
      get: function (key) {
        var layoutName = _emberMetalProperty_get.get(this, 'layoutName');
        var layout = this.templateForName(layoutName, 'layout');

        return layout || _emberMetalProperty_get.get(this, 'defaultLayout');
      },

      set: function (key, value) {
        return value;
      }
    }),

    templateForName: function (name, type) {
      if (!name) {
        return;
      }

      var owner = _containerOwner.getOwner(this);

      if (!owner) {
        throw new _emberMetalError.default('Container was not found when looking up a views template. ' + 'This is most likely due to manually instantiating an Ember.View. ' + 'See: http://git.io/EKPpnA');
      }

      return owner.lookup('template:' + name);
    }
  });
})(Em._e[231],Em._e[31],Em._e[59],Em._e[70],Em._e[61],Em._e[30],Em._e[0]);
(function (exports, _emberViewsViewsView, _emberHtmlbarsTemplatesTopLevelView, _emberViewsMixinsTemplate_support) {
  /**
  @module ember
  @submodule ember-templates
  */

  'use strict';

  var CoreOutletView = _emberViewsViewsView.default.extend(_emberViewsMixinsTemplate_support.default, {
    defaultTemplate: _emberHtmlbarsTemplatesTopLevelView.default,

    init: function () {
      this._super();
      this._outlets = [];
    },

    setOutletState: function (state) {
      this.outletState = { main: state };

      if (this._env) {
        this._env.outletState = this.outletState;
      }

      if (this.lastResult) {
        this.dirtyOutlets();
        this._outlets = [];

        this.scheduleRevalidate(null, null);
      }
    },

    dirtyOutlets: function () {
      // Dirty any render nodes that correspond to outlets
      for (var i = 0; i < this._outlets.length; i++) {
        this._outlets[i].isDirty = true;
      }
    }
  });

  exports.CoreOutletView = CoreOutletView;
  var OutletView = CoreOutletView.extend({ tagName: '' });
  exports.OutletView = OutletView;
})(Em._e[232],Em._e[130],Em._e[196],Em._e[231]);
(function (exports, _emberHtmlbarsRenderer, _emberHtmlbarsSystemDomHelper, _emberHtmlbarsTemplatesTopLevelView, _emberHtmlbarsViewsOutlet, _emberViewsViewsView, _emberHtmlbarsComponentsText_field, _emberHtmlbarsComponentsText_area, _emberHtmlbarsComponentsCheckbox, _emberHtmlbarsComponentsLinkTo, _emberViewsMixinsTemplate_support) {
  'use strict';

  exports.setupApplicationRegistry = setupApplicationRegistry;
  exports.setupEngineRegistry = setupEngineRegistry;

  function setupApplicationRegistry(registry) {
    registry.register('renderer:-dom', _emberHtmlbarsRenderer.InteractiveRenderer);
    registry.register('renderer:-inert', _emberHtmlbarsRenderer.InertRenderer);

    registry.register('service:-dom-helper', {
      create: function (_ref) {
        var document = _ref.document;
        return new _emberHtmlbarsSystemDomHelper.default(document);
      }
    });
  }

  function setupEngineRegistry(registry) {
    registry.optionsForType('template', { instantiate: false });
    registry.register('view:-outlet', _emberHtmlbarsViewsOutlet.OutletView);

    registry.register('template:-outlet', _emberHtmlbarsTemplatesTopLevelView.default);
    registry.register('view:toplevel', _emberViewsViewsView.default.extend(_emberViewsMixinsTemplate_support.default));

    registry.register('component:-text-field', _emberHtmlbarsComponentsText_field.default);
    registry.register('component:-text-area', _emberHtmlbarsComponentsText_area.default);
    registry.register('component:-checkbox', _emberHtmlbarsComponentsCheckbox.default);
    registry.register('component:link-to', _emberHtmlbarsComponentsLinkTo.default);
  }
})(Em._e[233],Em._e[220],Em._e[173],Em._e[196],Em._e[232],Em._e[130],Em._e[223],Em._e[224],Em._e[221],Em._e[228],Em._e[231]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalObserver, _emberHtmlbarsStreamsStream, _emberHtmlbarsStreamsUtils) {
  'use strict';

  function labelFor(source, key) {
    return source.label ? source.label + '.' + key : key;
  }

  exports.default = _emberHtmlbarsStreamsStream.default.extend({
    init: function (source, key) {
      // TODO: This isn't necessary.

      var label = labelFor(source, key);

      this.path = label;
      this.observedObject = null;
      this.key = key;
      this.sourceDep = this.addMutableDependency(source);
      this.label = label;
    },

    compute: function () {
      var object = this.sourceDep.getValue();
      var type = typeof object;

      if (!object || type === 'boolean') {
        return;
      }

      if (type === 'object') {
        return _emberMetalProperty_get.get(object, this.key);
      }

      return object[this.key];
    },

    setValue: function (value) {
      var object = this.sourceDep.getValue();
      if (object) {
        _emberMetalProperty_set.set(object, this.key, value);
      }
    },

    setSource: function (source) {
      this.sourceDep.replace(source);
      this.notify();
    },

    _super$revalidate: _emberHtmlbarsStreamsStream.default.prototype.revalidate,

    revalidate: function (value) {
      this._super$revalidate(value);

      var object = this.sourceDep.getValue();
      if (object !== this.observedObject) {
        this._clearObservedObject();

        if (typeof object === 'object' && object) {
          _emberMetalObserver.addObserver(object, this.key, this, this.notify);
          this.observedObject = object;
        }
      }
    },

    _super$deactivate: _emberHtmlbarsStreamsStream.default.prototype.deactivate,

    _clearObservedObject: function () {
      if (this.observedObject) {
        _emberMetalObserver.removeObserver(this.observedObject, this.key, this, this.notify);
        this.observedObject = null;
      }
    },

    deactivate: function () {
      this._super$deactivate();
      this._clearObservedObject();
    }
  });
})(Em._e[234],Em._e[0],Em._e[30],Em._e[32],Em._e[53],Em._e[56],Em._e[66]);
(function (exports, _emberMetalDebug, _emberMetalProperty_get, _emberMetalProperty_set, _emberMetalMeta, _emberMetalObserver, _emberMetalProperty_events, _emberRuntimeComputedComputed_macros, _emberMetalProperties, _emberMetalMixin, _emberMetalSymbol) {
  /**
  @module ember
  @submodule ember-runtime
  */

  'use strict';

  var _Mixin$create;

  exports.isProxy = isProxy;

  var IS_PROXY = _emberMetalSymbol.default('IS_PROXY');

  function isProxy(value) {
    return value && value[IS_PROXY];
  }

  function contentPropertyWillChange(content, contentKey) {
    var key = contentKey.slice(8); // remove "content."
    if (key in this) {
      return;
    } // if shadowed in proxy
    _emberMetalProperty_events.propertyWillChange(this, key);
  }

  function contentPropertyDidChange(content, contentKey) {
    var key = contentKey.slice(8); // remove "content."
    if (key in this) {
      return;
    } // if shadowed in proxy
    _emberMetalProperty_events.propertyDidChange(this, key);
  }

  /**
    `Ember.ProxyMixin` forwards all properties not defined by the proxy itself
    to a proxied `content` object.  See Ember.ObjectProxy for more details.
  
    @class ProxyMixin
    @namespace Ember
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create((_Mixin$create = {}, _Mixin$create[IS_PROXY] = true, _Mixin$create.content = null, _Mixin$create._contentDidChange = _emberMetalMixin.observer('content', function () {}), _Mixin$create.isTruthy = _emberRuntimeComputedComputed_macros.bool('content'), _Mixin$create._debugContainerKey = null, _Mixin$create.willWatchProperty = function (key) {
    var contentKey = 'content.' + key;
    _emberMetalObserver._addBeforeObserver(this, contentKey, null, contentPropertyWillChange);
    _emberMetalObserver.addObserver(this, contentKey, null, contentPropertyDidChange);
  }, _Mixin$create.didUnwatchProperty = function (key) {
    var contentKey = 'content.' + key;
    _emberMetalObserver._removeBeforeObserver(this, contentKey, null, contentPropertyWillChange);
    _emberMetalObserver.removeObserver(this, contentKey, null, contentPropertyDidChange);
  }, _Mixin$create.unknownProperty = function (key) {
    var content = _emberMetalProperty_get.get(this, 'content');
    if (content) {
      return _emberMetalProperty_get.get(content, key);
    }
  }, _Mixin$create.setUnknownProperty = function (key, value) {
    var m = _emberMetalMeta.meta(this);
    if (m.proto === this) {
      // if marked as prototype then just defineProperty
      // rather than delegate
      _emberMetalProperties.defineProperty(this, key, null, value);
      return value;
    }

    var content = _emberMetalProperty_get.get(this, 'content');

    return _emberMetalProperty_set.set(content, key, value);
  }, _Mixin$create));
})(Em._e[235],Em._e[0],Em._e[30],Em._e[32],Em._e[14],Em._e[53],Em._e[20],Em._e[225],Em._e[48],Em._e[61],Em._e[13]);
(function (exports) {
  /**
    Merge the contents of two objects together into the first object.
  
    ```javascript
    Ember.merge({ first: 'Tom' }, { last: 'Dale' }); // { first: 'Tom', last: 'Dale' }
    var a = { first: 'Yehuda' };
    var b = { last: 'Katz' };
    Ember.merge(a, b); // a == { first: 'Yehuda', last: 'Katz' }, b == { last: 'Katz' }
    ```
  
    @method merge
    @for Ember
    @param {Object} original The object to merge into
    @param {Object} updates The object to copy properties from
    @return {Object}
    @public
  */
  'use strict';

  exports.default = merge;

  function merge(original, updates) {
    if (!updates || typeof updates !== 'object') {
      return original;
    }

    var props = Object.keys(updates);
    var prop = undefined;

    for (var i = 0; i < props.length; i++) {
      prop = props[i];
      original[prop] = updates[prop];
    }

    return original;
  }
})(Em._e[236]);
(function (exports, _emberMetalUtils, _emberMetalMeta) {
  'use strict';

  exports.default = WeakMap;

  var id = 0;
  function UNDEFINED() {}

  // Returns whether Type(value) is Object according to the terminology in the spec
  function isObject(value) {
    return typeof value === 'object' && value !== null || typeof value === 'function';
  }

  /*
   * @class Ember.WeakMap
   * @public
   * @category ember-metal-weakmap
   *
   * A partial polyfill for [WeakMap](http://www.ecma-international.org/ecma-262/6.0/#sec-weakmap-objects).
   *
   * There is a small but important caveat. This implementation assumes that the
   * weak map will live longer (in the sense of garbage collection) than all of its
   * keys, otherwise it is possible to leak the values stored in the weak map. In
   * practice, most use cases satisfy this limitation which is why it is included
   * in ember-metal.
   */

  function WeakMap(iterable) {
    if (!(this instanceof WeakMap)) {
      throw new TypeError('Constructor WeakMap requires \'new\'');
    }

    this._id = _emberMetalUtils.GUID_KEY + id++;

    if (iterable === null || iterable === undefined) {
      return;
    } else if (Array.isArray(iterable)) {
      for (var i = 0; i < iterable.length; i++) {
        var _iterable$i = iterable[i];
        var key = _iterable$i[0];
        var value = _iterable$i[1];

        this.set(key, value);
      }
    } else {
      throw new TypeError('The weak map constructor polyfill only supports an array argument');
    }
  }

  /*
   * @method get
   * @param key {Object | Function}
   * @return {Any} stored value
   */
  WeakMap.prototype.get = function (obj) {
    if (!isObject(obj)) {
      return undefined;
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    if (meta) {
      var map = meta.readableWeak();
      if (map) {
        if (map[this._id] === UNDEFINED) {
          return undefined;
        }

        return map[this._id];
      }
    }
  };

  /*
   * @method set
   * @param key {Object | Function}
   * @param value {Any}
   * @return {WeakMap} the weak map
   */
  WeakMap.prototype.set = function (obj, value) {
    if (!isObject(obj)) {
      throw new TypeError('Invalid value used as weak map key');
    }

    if (value === undefined) {
      value = UNDEFINED;
    }

    _emberMetalMeta.meta(obj).writableWeak()[this._id] = value;

    return this;
  };

  /*
   * @method has
   * @param key {Object | Function}
   * @return {boolean} if the key exists
   */
  WeakMap.prototype.has = function (obj) {
    if (!isObject(obj)) {
      return false;
    }

    var meta = _emberMetalMeta.peekMeta(obj);
    if (meta) {
      var map = meta.readableWeak();
      if (map) {
        return map[this._id] !== undefined;
      }
    }

    return false;
  };

  /*
   * @method delete
   * @param key {Object | Function}
   * @return {boolean} if the key was deleted
   */
  WeakMap.prototype.delete = function (obj) {
    if (this.has(obj)) {
      delete _emberMetalMeta.meta(obj).writableWeak()[this._id];
      return true;
    } else {
      return false;
    }
  };

  /*
   * @method toString
   * @return {String}
   */
  WeakMap.prototype.toString = function () {
    return '[object WeakMap]';
  };
})(Em._e[237],Em._e[7],Em._e[14]);
(function (exports, _emberMetalUtils, _emberMetalEmpty_object) {
  /**
  @module ember
  @submodule ember-metal
  */

  /*
    JavaScript (before ES6) does not have a Map implementation. Objects,
    which are often used as dictionaries, may only have Strings as keys.
  
    Because Ember has a way to get a unique identifier for every object
    via `Ember.guidFor`, we can implement a performant Map with arbitrary
    keys. Because it is commonly used in low-level bookkeeping, Map is
    implemented as a pure JavaScript object for performance.
  
    This implementation follows the current iteration of the ES6 proposal for
    maps (http://wiki.ecmascript.org/doku.php?id=harmony:simple_maps_and_sets),
    with one exception:  as we do not have the luxury of in-VM iteration, we implement a
    forEach method for iteration.
  
    Map is mocked out to look like an Ember object, so you can do
    `Ember.Map.create()` for symmetry with other Ember classes.
  */
  'use strict';

  function missingFunction(fn) {
    throw new TypeError(Object.prototype.toString.call(fn) + ' is not a function');
  }

  function missingNew(name) {
    throw new TypeError('Constructor ' + name + ' requires \'new\'');
  }

  function copyNull(obj) {
    var output = new _emberMetalEmpty_object.default();

    for (var prop in obj) {
      // hasOwnPropery is not needed because obj is new EmptyObject();
      output[prop] = obj[prop];
    }

    return output;
  }

  function copyMap(original, newObject) {
    var keys = original._keys.copy();
    var values = copyNull(original._values);

    newObject._keys = keys;
    newObject._values = values;
    newObject.size = original.size;

    return newObject;
  }

  /**
    This class is used internally by Ember and Ember Data.
    Please do not use it at this time. We plan to clean it up
    and add many tests soon.
  
    @class OrderedSet
    @namespace Ember
    @constructor
    @private
  */
  function OrderedSet() {
    if (this instanceof OrderedSet) {
      this.clear();
      this._silenceRemoveDeprecation = false;
    } else {
      missingNew('OrderedSet');
    }
  }

  /**
    @method create
    @static
    @return {Ember.OrderedSet}
    @private
  */
  OrderedSet.create = function () {
    var Constructor = this;

    return new Constructor();
  };

  OrderedSet.prototype = {
    constructor: OrderedSet,
    /**
      @method clear
      @private
    */
    clear: function () {
      this.presenceSet = new _emberMetalEmpty_object.default();
      this.list = [];
      this.size = 0;
    },

    /**
      @method add
      @param obj
      @param guid (optional, and for internal use)
      @return {Ember.OrderedSet}
      @private
    */
    add: function (obj, _guid) {
      var guid = _guid || _emberMetalUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] !== true) {
        presenceSet[guid] = true;
        this.size = list.push(obj);
      }

      return this;
    },

    /**
      @since 1.8.0
      @method delete
      @param obj
      @param _guid (optional and for internal use only)
      @return {Boolean}
      @private
    */
    delete: function (obj, _guid) {
      var guid = _guid || _emberMetalUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] === true) {
        delete presenceSet[guid];
        var index = list.indexOf(obj);
        if (index > -1) {
          list.splice(index, 1);
        }
        this.size = list.length;
        return true;
      } else {
        return false;
      }
    },

    /**
      @method isEmpty
      @return {Boolean}
      @private
    */
    isEmpty: function () {
      return this.size === 0;
    },

    /**
      @method has
      @param obj
      @return {Boolean}
      @private
    */
    has: function (obj) {
      if (this.size === 0) {
        return false;
      }

      var guid = _emberMetalUtils.guidFor(obj);
      var presenceSet = this.presenceSet;

      return presenceSet[guid] === true;
    },

    /**
      @method forEach
      @param {Function} fn
      @param self
      @private
    */
    forEach: function (fn /*, ...thisArg*/) {
      if (typeof fn !== 'function') {
        missingFunction(fn);
      }

      if (this.size === 0) {
        return;
      }

      var list = this.list;

      if (arguments.length === 2) {
        for (var i = 0; i < list.length; i++) {
          fn.call(arguments[1], list[i]);
        }
      } else {
        for (var i = 0; i < list.length; i++) {
          fn(list[i]);
        }
      }
    },

    /**
      @method toArray
      @return {Array}
      @private
    */
    toArray: function () {
      return this.list.slice();
    },

    /**
      @method copy
      @return {Ember.OrderedSet}
      @private
    */
    copy: function () {
      var Constructor = this.constructor;
      var set = new Constructor();

      set._silenceRemoveDeprecation = this._silenceRemoveDeprecation;
      set.presenceSet = copyNull(this.presenceSet);
      set.list = this.toArray();
      set.size = this.size;

      return set;
    }
  };

  /**
    A Map stores values indexed by keys. Unlike JavaScript's
    default Objects, the keys of a Map can be any JavaScript
    object.
  
    Internally, a Map has two data structures:
  
    1. `keys`: an OrderedSet of all of the existing keys
    2. `values`: a JavaScript Object indexed by the `Ember.guidFor(key)`
  
    When a key/value pair is added for the first time, we
    add the key to the `keys` OrderedSet, and create or
    replace an entry in `values`. When an entry is deleted,
    we delete its entry in `keys` and `values`.
  
    @class Map
    @namespace Ember
    @private
    @constructor
  */
  function Map() {
    if (this instanceof Map) {
      this._keys = OrderedSet.create();
      this._keys._silenceRemoveDeprecation = true;
      this._values = new _emberMetalEmpty_object.default();
      this.size = 0;
    } else {
      missingNew('Map');
    }
  }

  /**
    @method create
    @static
    @private
  */
  Map.create = function () {
    var Constructor = this;
    return new Constructor();
  };

  Map.prototype = {
    constructor: Map,

    /**
      This property will change as the number of objects in the map changes.
       @since 1.8.0
      @property size
      @type number
      @default 0
      @private
    */
    size: 0,

    /**
      Retrieve the value associated with a given key.
       @method get
      @param {*} key
      @return {*} the value associated with the key, or `undefined`
      @private
    */
    get: function (key) {
      if (this.size === 0) {
        return;
      }

      var values = this._values;
      var guid = _emberMetalUtils.guidFor(key);

      return values[guid];
    },

    /**
      Adds a value to the map. If a value for the given key has already been
      provided, the new value will replace the old value.
       @method set
      @param {*} key
      @param {*} value
      @return {Ember.Map}
      @private
    */
    set: function (key, value) {
      var keys = this._keys;
      var values = this._values;
      var guid = _emberMetalUtils.guidFor(key);

      // ensure we don't store -0
      var k = key === -0 ? 0 : key;

      keys.add(k, guid);

      values[guid] = value;

      this.size = keys.size;

      return this;
    },

    /**
      Removes a value from the map for an associated key.
       @since 1.8.0
      @method delete
      @param {*} key
      @return {Boolean} true if an item was removed, false otherwise
      @private
    */
    delete: function (key) {
      if (this.size === 0) {
        return false;
      }
      // don't use ES6 "delete" because it will be annoying
      // to use in browsers that are not ES6 friendly;
      var keys = this._keys;
      var values = this._values;
      var guid = _emberMetalUtils.guidFor(key);

      if (keys.delete(key, guid)) {
        delete values[guid];
        this.size = keys.size;
        return true;
      } else {
        return false;
      }
    },

    /**
      Check whether a key is present.
       @method has
      @param {*} key
      @return {Boolean} true if the item was present, false otherwise
      @private
    */
    has: function (key) {
      return this._keys.has(key);
    },

    /**
      Iterate over all the keys and values. Calls the function once
      for each key, passing in value, key, and the map being iterated over,
      in that order.
       The keys are guaranteed to be iterated over in insertion order.
       @method forEach
      @param {Function} callback
      @param {*} self if passed, the `this` value inside the
        callback. By default, `this` is the map.
      @private
    */
    forEach: function (callback /*, ...thisArg*/) {
      if (typeof callback !== 'function') {
        missingFunction(callback);
      }

      if (this.size === 0) {
        return;
      }

      var map = this;
      var cb = undefined,
          thisArg = undefined;

      if (arguments.length === 2) {
        thisArg = arguments[1];
        cb = function (key) {
          return callback.call(thisArg, map.get(key), key, map);
        };
      } else {
        cb = function (key) {
          return callback(map.get(key), key, map);
        };
      }

      this._keys.forEach(cb);
    },

    /**
      @method clear
      @private
    */
    clear: function () {
      this._keys.clear();
      this._values = new _emberMetalEmpty_object.default();
      this.size = 0;
    },

    /**
      @method copy
      @return {Ember.Map}
      @private
    */
    copy: function () {
      return copyMap(this, new Map());
    }
  };

  /**
    @class MapWithDefault
    @namespace Ember
    @extends Ember.Map
    @private
    @constructor
    @param [options]
      @param {*} [options.defaultValue]
  */
  function MapWithDefault(options) {
    this._super$constructor();
    this.defaultValue = options.defaultValue;
  }

  /**
    @method create
    @static
    @param [options]
      @param {*} [options.defaultValue]
    @return {Ember.MapWithDefault|Ember.Map} If options are passed, returns
      `Ember.MapWithDefault` otherwise returns `Ember.Map`
    @private
  */
  MapWithDefault.create = function (options) {
    if (options) {
      return new MapWithDefault(options);
    } else {
      return new Map();
    }
  };

  MapWithDefault.prototype = Object.create(Map.prototype);
  MapWithDefault.prototype.constructor = MapWithDefault;
  MapWithDefault.prototype._super$constructor = Map;
  MapWithDefault.prototype._super$get = Map.prototype.get;

  /**
    Retrieve the value associated with a given key.
  
    @method get
    @param {*} key
    @return {*} the value associated with the key, or the default value
    @private
  */
  MapWithDefault.prototype.get = function (key) {
    var hasValue = this.has(key);

    if (hasValue) {
      return this._super$get(key);
    } else {
      var defaultValue = this.defaultValue(key);
      this.set(key, defaultValue);
      return defaultValue;
    }
  };

  /**
    @method copy
    @return {Ember.MapWithDefault}
    @private
  */
  MapWithDefault.prototype.copy = function () {
    var Constructor = this.constructor;
    return copyMap(this, new Constructor({
      defaultValue: this.defaultValue
    }));
  };

  exports.default = Map;
  exports.OrderedSet = OrderedSet;
  exports.Map = Map;
  exports.MapWithDefault = MapWithDefault;
})(Em._e[238],Em._e[7],Em._e[12]);
(function (exports, _emberMetalDebug, _emberMetalFeatures) {
  'use strict';

  exports.Libraries = Libraries;

  /**
    Helper class that allows you to register your library with Ember.
  
    Singleton created at `Ember.libraries`.
  
    @class Libraries
    @constructor
    @private
  */

  function Libraries() {
    this._registry = [];
    this._coreLibIndex = 0;
  }

  Libraries.prototype = {
    constructor: Libraries,

    _getLibraryByName: function (name) {
      var libs = this._registry;
      var count = libs.length;

      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }
    },

    register: function (name, version, isCoreLibrary) {
      var index = this._registry.length;

      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }
        this._registry.splice(index, 0, { name: name, version: version });
      } else {}
    },

    registerCoreLibrary: function (name, version) {
      this.register(name, version, true);
    },

    deRegister: function (name) {
      var lib = this._getLibraryByName(name);
      var index = undefined;

      if (lib) {
        index = this._registry.indexOf(lib);
        this._registry.splice(index, 1);
      }
    }
  };

  if (false) {
    Libraries.prototype.isRegistered = function (name) {
      return !!this._getLibraryByName(name);
    };
  }

  exports.default = new Libraries();
})(Em._e[239],Em._e[0],Em._e[10]);
(function (exports, _emberMetalIs_empty) {
  'use strict';

  exports.default = isBlank;

  /**
    A value is blank if it is empty or a whitespace string.
  
    ```javascript
    Ember.isBlank();                // true
    Ember.isBlank(null);            // true
    Ember.isBlank(undefined);       // true
    Ember.isBlank('');              // true
    Ember.isBlank([]);              // true
    Ember.isBlank('\n\t');          // true
    Ember.isBlank('  ');            // true
    Ember.isBlank({});              // false
    Ember.isBlank('\n\t Hello');    // false
    Ember.isBlank('Hello world');   // false
    Ember.isBlank([1,2,3]);         // false
    ```
  
    @method isBlank
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    @public
  */

  function isBlank(obj) {
    return _emberMetalIs_empty.default(obj) || typeof obj === 'string' && obj.match(/\S/) === null;
  }
})(Em._e[240],Em._e[92]);
(function (exports, _emberMetalIs_blank) {
  'use strict';

  exports.default = isPresent;

  /**
    A value is present if it not `isBlank`.
  
    ```javascript
    Ember.isPresent();                // false
    Ember.isPresent(null);            // false
    Ember.isPresent(undefined);       // false
    Ember.isPresent('');              // false
    Ember.isPresent('  ');            // false
    Ember.isPresent('\n\t');          // false
    Ember.isPresent([]);              // false
    Ember.isPresent({ length: 0 })    // false
    Ember.isPresent(false);           // true
    Ember.isPresent(true);            // true
    Ember.isPresent('string');        // true
    Ember.isPresent(0);               // true
    Ember.isPresent(function() {})    // true
    Ember.isPresent({});              // true
    Ember.isPresent(false);           // true
    Ember.isPresent('\n\t Hello');    // true
    Ember.isPresent([1,2,3]);         // true
    ```
  
    @method isPresent
    @for Ember
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    @public
  */

  function isPresent(obj) {
    return !_emberMetalIs_blank.default(obj);
  }
})(Em._e[241],Em._e[240]);
(function (exports, _require, _emberEnvironment, _emberVersion, _emberMetalCore, _emberMetalDebug, _emberMetalFeatures, _emberMetalAssign, _emberMetalMerge, _emberMetalInstrumentation, _emberMetalUtils, _emberMetalMeta, _emberMetalError, _emberMetalCache, _emberConsole, _emberMetalProperty_get, _emberMetalEvents, _emberMetalObserver_set, _emberMetalProperty_events, _emberMetalProperties, _emberMetalProperty_set, _emberMetalWeak_map, _emberMetalMap, _emberMetalGet_properties, _emberMetalSet_properties, _emberMetalWatch_key, _emberMetalChains, _emberMetalWatch_path, _emberMetalWatching, _emberMetalExpand_properties, _emberMetalComputed, _emberMetalAlias, _emberMetalObserver, _emberMetalMixin, _emberMetalBinding, _emberMetalPath_cache, _emberMetalTesting, _emberMetalError_handler, _emberMetalRun_loop, _emberMetalLibraries, _emberMetalIs_none, _emberMetalIs_empty, _emberMetalIs_blank, _emberMetalIs_present, _backburner) {
  /**
  @module ember
  @submodule ember-metal
  */

  // BEGIN IMPORTS
  'use strict';

  _emberMetalComputed.computed.alias = _emberMetalAlias.default;

  // END IMPORTS

  // BEGIN EXPORTS
  var EmberInstrumentation = _emberMetalCore.default.Instrumentation = {};
  EmberInstrumentation.instrument = _emberMetalInstrumentation.instrument;
  EmberInstrumentation.subscribe = _emberMetalInstrumentation.subscribe;
  EmberInstrumentation.unsubscribe = _emberMetalInstrumentation.unsubscribe;
  EmberInstrumentation.reset = _emberMetalInstrumentation.reset;

  _emberMetalCore.default.instrument = _emberMetalInstrumentation.instrument;
  _emberMetalCore.default.subscribe = _emberMetalInstrumentation.subscribe;

  _emberMetalCore.default._Cache = _emberMetalCache.default;

  _emberMetalCore.default.generateGuid = _emberMetalUtils.generateGuid;
  _emberMetalCore.default.GUID_KEY = _emberMetalUtils.GUID_KEY;
  _emberMetalCore.default.NAME_KEY = _emberMetalMixin.NAME_KEY;
  _emberMetalCore.default.platform = {
    defineProperty: true,
    hasPropertyAccessors: true
  };

  _emberMetalCore.default.Error = _emberMetalError.default;
  _emberMetalCore.default.guidFor = _emberMetalUtils.guidFor;
  _emberMetalCore.default.META_DESC = _emberMetalMeta.META_DESC;
  _emberMetalCore.default.meta = _emberMetalMeta.meta;
  _emberMetalCore.default.inspect = _emberMetalUtils.inspect;

  _emberMetalCore.default.tryCatchFinally = _emberMetalUtils.deprecatedTryCatchFinally;
  _emberMetalCore.default.makeArray = _emberMetalUtils.makeArray;
  _emberMetalCore.default.canInvoke = _emberMetalUtils.canInvoke;
  _emberMetalCore.default.tryInvoke = _emberMetalUtils.tryInvoke;
  _emberMetalCore.default.wrap = _emberMetalUtils.wrap;
  _emberMetalCore.default.apply = _emberMetalUtils.apply;
  _emberMetalCore.default.applyStr = _emberMetalUtils.applyStr;
  _emberMetalCore.default.uuid = _emberMetalUtils.uuid;

  _emberMetalCore.default.Logger = _emberConsole.default;

  _emberMetalCore.default.get = _emberMetalProperty_get.get;
  _emberMetalCore.default.getWithDefault = _emberMetalProperty_get.getWithDefault;
  _emberMetalCore.default._getPath = _emberMetalProperty_get._getPath;

  _emberMetalCore.default.on = _emberMetalEvents.on;
  _emberMetalCore.default.addListener = _emberMetalEvents.addListener;
  _emberMetalCore.default.removeListener = _emberMetalEvents.removeListener;
  _emberMetalCore.default._suspendListener = _emberMetalEvents.suspendListener;
  _emberMetalCore.default._suspendListeners = _emberMetalEvents.suspendListeners;
  _emberMetalCore.default.sendEvent = _emberMetalEvents.sendEvent;
  _emberMetalCore.default.hasListeners = _emberMetalEvents.hasListeners;
  _emberMetalCore.default.watchedEvents = _emberMetalEvents.watchedEvents;
  _emberMetalCore.default.listenersFor = _emberMetalEvents.listenersFor;
  _emberMetalCore.default.accumulateListeners = _emberMetalEvents.accumulateListeners;

  _emberMetalCore.default._ObserverSet = _emberMetalObserver_set.default;

  _emberMetalCore.default.propertyWillChange = _emberMetalProperty_events.propertyWillChange;
  _emberMetalCore.default.propertyDidChange = _emberMetalProperty_events.propertyDidChange;
  _emberMetalCore.default.overrideChains = _emberMetalProperty_events.overrideChains;
  _emberMetalCore.default.beginPropertyChanges = _emberMetalProperty_events.beginPropertyChanges;
  _emberMetalCore.default.endPropertyChanges = _emberMetalProperty_events.endPropertyChanges;
  _emberMetalCore.default.changeProperties = _emberMetalProperty_events.changeProperties;

  _emberMetalCore.default.defineProperty = _emberMetalProperties.defineProperty;

  _emberMetalCore.default.set = _emberMetalProperty_set.set;
  _emberMetalCore.default.trySet = _emberMetalProperty_set.trySet;

  if (false) {
    _emberMetalCore.default.WeakMap = _emberMetalWeak_map.default;
  }
  _emberMetalCore.default.OrderedSet = _emberMetalMap.OrderedSet;
  _emberMetalCore.default.Map = _emberMetalMap.Map;
  _emberMetalCore.default.MapWithDefault = _emberMetalMap.MapWithDefault;

  _emberMetalCore.default.getProperties = _emberMetalGet_properties.default;
  _emberMetalCore.default.setProperties = _emberMetalSet_properties.default;

  _emberMetalCore.default.watchKey = _emberMetalWatch_key.watchKey;
  _emberMetalCore.default.unwatchKey = _emberMetalWatch_key.unwatchKey;

  _emberMetalCore.default.removeChainWatcher = _emberMetalChains.removeChainWatcher;
  _emberMetalCore.default._ChainNode = _emberMetalChains.ChainNode;
  _emberMetalCore.default.finishChains = _emberMetalChains.finishChains;

  _emberMetalCore.default.watchPath = _emberMetalWatch_path.watchPath;
  _emberMetalCore.default.unwatchPath = _emberMetalWatch_path.unwatchPath;

  _emberMetalCore.default.watch = _emberMetalWatching.watch;
  _emberMetalCore.default.isWatching = _emberMetalWatching.isWatching;
  _emberMetalCore.default.unwatch = _emberMetalWatching.unwatch;
  _emberMetalCore.default.rewatch = _emberMetalWatching.rewatch;
  _emberMetalCore.default.destroy = _emberMetalWatching.destroy;

  _emberMetalCore.default.expandProperties = _emberMetalExpand_properties.default;

  _emberMetalCore.default.ComputedProperty = _emberMetalComputed.ComputedProperty;
  _emberMetalCore.default.computed = _emberMetalComputed.computed;
  _emberMetalCore.default.cacheFor = _emberMetalComputed.cacheFor;

  _emberMetalCore.default.addObserver = _emberMetalObserver.addObserver;
  _emberMetalCore.default.observersFor = _emberMetalObserver.observersFor;
  _emberMetalCore.default.removeObserver = _emberMetalObserver.removeObserver;
  _emberMetalCore.default._suspendObserver = _emberMetalObserver._suspendObserver;
  _emberMetalCore.default._suspendObservers = _emberMetalObserver._suspendObservers;

  _emberMetalCore.default.required = _emberMetalMixin.required;
  _emberMetalCore.default.aliasMethod = _emberMetalMixin.aliasMethod;
  _emberMetalCore.default.observer = _emberMetalMixin.observer;
  _emberMetalCore.default.immediateObserver = _emberMetalMixin._immediateObserver;
  _emberMetalCore.default.mixin = _emberMetalMixin.mixin;
  _emberMetalCore.default.Mixin = _emberMetalMixin.Mixin;

  _emberMetalCore.default.bind = _emberMetalBinding.bind;
  _emberMetalCore.default.Binding = _emberMetalBinding.Binding;
  _emberMetalCore.default.isGlobalPath = _emberMetalPath_cache.isGlobalPath;

  _emberMetalCore.default.run = _emberMetalRun_loop.default;

  /**
  @class Backburner
  @for Ember
  @private
  */
  _emberMetalCore.default.Backburner = function () {

    function BackburnerAlias(args) {
      return _backburner.default.apply(this, args);
    }

    BackburnerAlias.prototype = _backburner.default.prototype;

    return new BackburnerAlias(arguments);
  };

  _emberMetalCore.default._Backburner = _backburner.default;

  /**
    The semantic version
    @property VERSION
    @type String
    @public
   */
  _emberMetalCore.default.VERSION = _emberVersion.default;

  _emberMetalCore.default.libraries = _emberMetalLibraries.default;

  _emberMetalLibraries.default.registerCoreLibrary('Ember', _emberMetalCore.default.VERSION);

  _emberMetalCore.default.isNone = _emberMetalIs_none.default;
  _emberMetalCore.default.isEmpty = _emberMetalIs_empty.default;
  _emberMetalCore.default.isBlank = _emberMetalIs_blank.default;
  _emberMetalCore.default.isPresent = _emberMetalIs_present.default;

  _emberMetalCore.default.assign = Object.assign || _emberMetalAssign.default;
  _emberMetalCore.default.merge = _emberMetalMerge.default;

  _emberMetalCore.default.FEATURES = _emberMetalFeatures.FEATURES;
  _emberMetalCore.default.FEATURES.isEnabled = _emberMetalFeatures.default;

  _emberMetalCore.default.EXTEND_PROTOTYPES = _emberEnvironment.ENV.EXTEND_PROTOTYPES;

  // BACKWARDS COMPAT ACCESSORS FOR ENV FLAGS
  Object.defineProperty(_emberMetalCore.default, 'LOG_STACKTRACE_ON_DEPRECATION', {
    get: function () {
      return _emberEnvironment.ENV.LOG_STACKTRACE_ON_DEPRECATION;
    },
    set: function (value) {
      _emberEnvironment.ENV.LOG_STACKTRACE_ON_DEPRECATION = !!value;
    },
    enumerable: false
  });

  Object.defineProperty(_emberMetalCore.default, 'LOG_VERSION', {
    get: function () {
      return _emberEnvironment.ENV.LOG_VERSION;
    },
    set: function (value) {
      _emberEnvironment.ENV.LOG_VERSION = !!value;
    },
    enumerable: false
  });

  Object.defineProperty(_emberMetalCore.default, 'MODEL_FACTORY_INJECTIONS', {
    get: function () {
      return _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS;
    },
    set: function (value) {
      _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = !!value;
    },
    enumerable: false
  });

  Object.defineProperty(_emberMetalCore.default, 'LOG_BINDINGS', {
    get: function () {
      return _emberEnvironment.ENV.LOG_BINDINGS;
    },
    set: function (value) {
      _emberEnvironment.ENV.LOG_BINDINGS = !!value;
    },
    enumerable: false
  });

  Object.defineProperty(_emberMetalCore.default, 'ENV', {
    get: function () {
      return _emberEnvironment.ENV;
    },
    enumerable: false
  });

  /**
    The context that Ember searches for namespace instances on.
  
    @private
   */
  Object.defineProperty(_emberMetalCore.default, 'lookup', {
    get: function () {
      return _emberEnvironment.context.lookup;
    },
    set: function (value) {
      _emberEnvironment.context.lookup = value;
    },
    enumerable: false
  });

  Object.defineProperty(_emberMetalCore.default, 'testing', {
    get: _emberMetalTesting.isTesting,
    set: _emberMetalTesting.setTesting,
    enumerable: false
  });

  /**
    A function may be assigned to `Ember.onerror` to be called when Ember
    internals encounter an error. This is useful for specialized error handling
    and reporting code.
  
    ```javascript
    Ember.onerror = function(error) {
      Em.$.ajax('/report-error', 'POST', {
        stack: error.stack,
        otherInformation: 'whatever app state you want to provide'
      });
    };
    ```
  
    Internally, `Ember.onerror` is used as Backburner's error handler.
  
    @event onerror
    @for Ember
    @param {Exception} error the error object
    @public
  */
  Object.defineProperty(_emberMetalCore.default, 'onerror', {
    get: _emberMetalError_handler.getOnerror,
    set: _emberMetalError_handler.setOnerror,
    enumerable: false
  });

  /**
    An empty function useful for some operations. Always returns `this`.
  
    @method K
    @return {Object}
    @public
  */
  _emberMetalCore.default.K = function K() {
    return this;
  };

  // The debug functions are exported to globals with `require` to
  // prevent babel-plugin-filter-imports from removing them.
  var debugModule = _require.default('ember-metal/debug');
  _emberMetalCore.default.assert = debugModule.assert;
  _emberMetalCore.default.warn = debugModule.warn;
  _emberMetalCore.default.debug = debugModule.debug;
  _emberMetalCore.default.deprecate = debugModule.deprecate;
  _emberMetalCore.default.deprecateFunc = debugModule.deprecateFunc;
  _emberMetalCore.default.runInDebug = debugModule.runInDebug;
  // END EXPORTS

  // do this for side-effects of updating Ember.assert, warn, etc when
  // ember-debug is present
  // This needs to be called before any deprecateFunc
  if (_require.has('ember-debug')) {
    _require.default('ember-debug');
  } else {
    _emberMetalCore.default.Debug = {};
    _emberMetalCore.default.Debug.registerDeprecationHandler = function () {};
    _emberMetalCore.default.Debug.registerWarnHandler = function () {};
  }

  _emberMetalCore.default.create = _emberMetalDebug.deprecateFunc('Ember.create is deprecated in favor of Object.create', { id: 'ember-metal.ember-create', until: '3.0.0' }, Object.create);
  _emberMetalCore.default.keys = _emberMetalDebug.deprecateFunc('Ember.keys is deprecated in favor of Object.keys', { id: 'ember-metal.ember.keys', until: '3.0.0' }, Object.keys);

  /* globals module */
  if (typeof module === 'object' && module.exports) {
    module.exports = _emberMetalCore.default;
  } else {
    _emberEnvironment.context.exports.Ember = _emberEnvironment.context.exports.Em = _emberMetalCore.default;
  }

  exports.default = _emberMetalCore.default;
})(Em._e[242],Em.__loader.require,Em._e[4],Em._e[197],Em._e[85],Em._e[0],Em._e[10],Em._e[8],Em._e[236],Em._e[98],Em._e[7],Em._e[14],Em._e[31],Em._e[28],Em._e[5],Em._e[30],Em._e[15],Em._e[18],Em._e[20],Em._e[48],Em._e[32],Em._e[237],Em._e[238],Em._e[74],Em._e[33],Em._e[49],Em._e[51],Em._e[50],Em._e[52],Em._e[57],Em._e[59],Em._e[62],Em._e[53],Em._e[61],Em._e[60],Em._e[29],Em._e[1],Em._e[6],Em._e[27],Em._e[239],Em._e[75],Em._e[92],Em._e[240],Em._e[241],Em._e[26]);
(function (exports) {
  /**
    Compares two objects, returning true if they are equal.
  
    ```javascript
    Ember.isEqual('hello', 'hello');                   // true
    Ember.isEqual(1, 2);                               // false
    ```
  
    `isEqual` is a more specific comparison than a triple equal comparison.
    It will call the `isEqual` instance method on the objects being
    compared, allowing finer control over when objects should be considered
    equal to each other.
  
    ```javascript
    let Person = Ember.Object.extend({
      isEqual(other) { return this.ssn == other.ssn; }
    });
  
    let personA = Person.create({name: 'Muhammad Ali', ssn: '123-45-6789'});
    let personB = Person.create({name: 'Cassius Clay', ssn: '123-45-6789'});
  
    Ember.isEqual(personA, personB); // true
    ```
  
    Due to the expense of array comparisons, collections will never be equal to
    each other even if each of their items are equal to each other.
  
    ```javascript
    Ember.isEqual([4, 2], [4, 2]);                     // false
    ```
  
    @method isEqual
    @for Ember
    @param {Object} a first object to compare
    @param {Object} b second object to compare
    @return {Boolean}
    @public
  */
  'use strict';

  exports.default = isEqual;

  function isEqual(a, b) {
    if (a && typeof a.isEqual === 'function') {
      return a.isEqual(b);
    }

    if (a instanceof Date && b instanceof Date) {
      return a.getTime() === b.getTime();
    }

    return a === b;
  }
})(Em._e[243]);
(function (exports, _emberMetalCore, _emberEnvironment, _emberMetalProperty_get, _emberMetalUtils, _emberMetalMixin, _emberRuntimeSystemObject) {
  /**
  @module ember
  @submodule ember-runtime
  */
  'use strict';

  exports.isSearchDisabled = isSearchDisabled;
  exports.setSearchDisabled = setSearchDisabled;

  var searchDisabled = false;

  function isSearchDisabled() {
    return searchDisabled;
  }

  function setSearchDisabled(flag) {
    searchDisabled = !!flag;
  }

  /**
    A Namespace is an object usually used to contain other objects or methods
    such as an application or framework. Create a namespace anytime you want
    to define one of these new containers.
  
    # Example Usage
  
    ```javascript
    MyFramework = Ember.Namespace.create({
      VERSION: '1.0.0'
    });
    ```
  
    @class Namespace
    @namespace Ember
    @extends Ember.Object
    @public
  */
  var Namespace = _emberRuntimeSystemObject.default.extend({
    isNamespace: true,

    init: function () {
      Namespace.NAMESPACES.push(this);
      Namespace.PROCESSED = false;
    },

    toString: function () {
      var name = _emberMetalProperty_get.get(this, 'name') || _emberMetalProperty_get.get(this, 'modulePrefix');
      if (name) {
        return name;
      }

      findNamespaces();
      return this[_emberMetalMixin.NAME_KEY];
    },

    nameClasses: function () {
      processNamespace([this.toString()], this, {});
    },

    destroy: function () {
      var namespaces = Namespace.NAMESPACES;
      var toString = this.toString();

      if (toString) {
        _emberEnvironment.context.lookup[toString] = undefined;
        delete Namespace.NAMESPACES_BY_ID[toString];
      }
      namespaces.splice(namespaces.indexOf(this), 1);
      this._super.apply(this, arguments);
    }
  });

  Namespace.reopenClass({
    NAMESPACES: [_emberMetalCore.default],
    NAMESPACES_BY_ID: {
      Ember: _emberMetalCore.default
    },
    PROCESSED: false,
    processAll: processAllNamespaces,
    byName: function (name) {
      if (!searchDisabled) {
        processAllNamespaces();
      }

      return NAMESPACES_BY_ID[name];
    }
  });

  var NAMESPACES_BY_ID = Namespace.NAMESPACES_BY_ID;

  var hasOwnProp = ({}).hasOwnProperty;

  function processNamespace(paths, root, seen) {
    var idx = paths.length;

    NAMESPACES_BY_ID[paths.join('.')] = root;

    // Loop over all of the keys in the namespace, looking for classes
    for (var key in root) {
      if (!hasOwnProp.call(root, key)) {
        continue;
      }
      var obj = root[key];

      // If we are processing the `Ember` namespace, for example, the
      // `paths` will start with `["Ember"]`. Every iteration through
      // the loop will update the **second** element of this list with
      // the key, so processing `Ember.View` will make the Array
      // `['Ember', 'View']`.
      paths[idx] = key;

      // If we have found an unprocessed class
      if (obj && obj.toString === classToString && !obj[_emberMetalMixin.NAME_KEY]) {
        // Replace the class' `toString` with the dot-separated path
        // and set its `NAME_KEY`
        obj[_emberMetalMixin.NAME_KEY] = paths.join('.');

        // Support nested namespaces
      } else if (obj && obj.isNamespace) {
          // Skip aliased namespaces
          if (seen[_emberMetalUtils.guidFor(obj)]) {
            continue;
          }
          seen[_emberMetalUtils.guidFor(obj)] = true;

          // Process the child namespace
          processNamespace(paths, obj, seen);
        }
    }

    paths.length = idx; // cut out last item
  }

  function isUppercase(code) {
    return code >= 65 && // A
    code <= 90; // Z
  }

  function tryIsNamespace(lookup, prop) {
    try {
      var obj = lookup[prop];
      return obj && obj.isNamespace && obj;
    } catch (e) {
      // continue
    }
  }

  function findNamespaces() {
    if (Namespace.PROCESSED) {
      return;
    }
    var lookup = _emberEnvironment.context.lookup;
    var keys = Object.keys(lookup);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      // Only process entities that start with uppercase A-Z
      if (!isUppercase(key.charCodeAt(0))) {
        continue;
      }
      var obj = tryIsNamespace(lookup, key);
      if (obj) {
        obj[_emberMetalMixin.NAME_KEY] = key;
      }
    }
  }

  function superClassString(mixin) {
    var superclass = mixin.superclass;
    if (superclass) {
      if (superclass[_emberMetalMixin.NAME_KEY]) {
        return superclass[_emberMetalMixin.NAME_KEY];
      }
      return superClassString(superclass);
    }
  }

  function classToString() {
    if (!searchDisabled && !this[_emberMetalMixin.NAME_KEY]) {
      processAllNamespaces();
    }

    var ret = undefined;

    if (this[_emberMetalMixin.NAME_KEY]) {
      ret = this[_emberMetalMixin.NAME_KEY];
    } else if (this._toString) {
      ret = this._toString;
    } else {
      var str = superClassString(this);
      if (str) {
        ret = '(subclass of ' + str + ')';
      } else {
        ret = '(unknown mixin)';
      }
      this.toString = makeToString(ret);
    }

    return ret;
  }

  function processAllNamespaces() {
    var unprocessedNamespaces = !Namespace.PROCESSED;
    var unprocessedMixins = _emberMetalMixin.hasUnprocessedMixins();

    if (unprocessedNamespaces) {
      findNamespaces();
      Namespace.PROCESSED = true;
    }

    if (unprocessedNamespaces || unprocessedMixins) {
      var namespaces = Namespace.NAMESPACES;
      var namespace = undefined;

      for (var i = 0; i < namespaces.length; i++) {
        namespace = namespaces[i];
        processNamespace([namespace.toString()], namespace, {});
      }

      _emberMetalMixin.clearUnprocessedMixins();
    }
  }

  function makeToString(ret) {
    return function () {
      return ret;
    };
  }

  _emberMetalMixin.Mixin.prototype.toString = classToString; // ES6TODO: altering imported objects. SBB.

  exports.default = Namespace;
})(Em._e[244],Em._e[85],Em._e[4],Em._e[30],Em._e[7],Em._e[61],Em._e[77]);
(function (exports, _emberMetalRun_loop, _emberMetalDebug, _emberMetalMixin) {
  /**
  @module ember
  @submodule ember-runtime
  */
  'use strict';

  exports.buildFakeContainerWithDeprecations = buildFakeContainerWithDeprecations;

  /**
    ContainerProxyMixin is used to provide public access to specific
    container functionality.
  
    @class ContainerProxyMixin
    @private
  */
  exports.default = _emberMetalMixin.Mixin.create({
    /**
     The container stores state.
      @private
     @property {Ember.Container} __container__
     */
    __container__: null,

    /**
     Returns an object that can be used to provide an owner to a
     manually created instance.
      Example:
      ```
     let owner = Ember.getOwner(this);
      User.create(
       owner.ownerInjection(),
       { username: 'rwjblue' }
     )
     ```
      @public
     @method ownerInjection
     @return {Object}
    */
    ownerInjection: function () {
      return this.__container__.ownerInjection();
    },

    /**
     Given a fullName return a corresponding instance.
      The default behaviour is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @public
     @method lookup
     @param {String} fullName
     @param {Object} options
     @return {any}
     */
    lookup: function (fullName, options) {
      return this.__container__.lookup(fullName, options);
    },

    /**
     Given a fullName return the corresponding factory.
      @private
     @method _lookupFactory
     @param {String} fullName
     @return {any}
     */
    _lookupFactory: function (fullName, options) {
      return this.__container__.lookupFactory(fullName, options);
    },

    /**
     Given a name and a source path, resolve the fullName
      @private
     @method _resolveLocalLookupName
     @param {String} fullName
     @param {String} source
     @return {String}
     */
    _resolveLocalLookupName: function (name, source) {
      return this.__container__.registry.expandLocalLookup('component:' + name, {
        source: source
      });
    },

    /**
     @private
     */
    willDestroy: function () {
      this._super.apply(this, arguments);

      if (this.__container__) {
        _emberMetalRun_loop.default(this.__container__, 'destroy');
      }
    }
  });

  function buildFakeContainerWithDeprecations(container) {
    var fakeContainer = {};
    var propertyMappings = {
      lookup: 'lookup',
      lookupFactory: '_lookupFactory'
    };

    for (var containerProperty in propertyMappings) {
      fakeContainer[containerProperty] = buildFakeContainerFunction(container, containerProperty, propertyMappings[containerProperty]);
    }

    return fakeContainer;
  }

  function buildFakeContainerFunction(container, containerProperty, ownerProperty) {
    return function () {
      return container[containerProperty].apply(container, arguments);
    };
  }
})(Em._e[245],Em._e[27],Em._e[0],Em._e[61]);
(function (exports, _emberEnvironment, _emberMetalDebug, _emberMetalDictionary, _containerOwner, _emberRuntimeMixinsContainer_proxy, _emberMetalSymbol) {
  'use strict';

  exports.default = Container;

  var CONTAINER_OVERRIDE = _emberMetalSymbol.default('CONTAINER_OVERRIDE');

  /**
   A container used to instantiate and cache objects.
  
   Every `Container` must be associated with a `Registry`, which is referenced
   to determine the factory and options that should be used to instantiate
   objects.
  
   The public API for `Container` is still in flux and should not be considered
   stable.
  
   @private
   @class Container
   */

  function Container(registry, options) {
    this.registry = registry;
    this.owner = options && options.owner ? options.owner : null;
    this.cache = _emberMetalDictionary.default(options && options.cache ? options.cache : null);
    this.factoryCache = _emberMetalDictionary.default(options && options.factoryCache ? options.factoryCache : null);
    this.validationCache = _emberMetalDictionary.default(options && options.validationCache ? options.validationCache : null);
    this._fakeContainerToInject = _emberRuntimeMixinsContainer_proxy.buildFakeContainerWithDeprecations(this);
    this[CONTAINER_OVERRIDE] = undefined;
    this.isDestroyed = false;
  }

  Container.prototype = {
    /**
     @private
     @property owner
     @type Object
     */
    owner: null,

    /**
     @private
     @property registry
     @type Registry
     @since 1.11.0
     */
    registry: null,

    /**
     @private
     @property cache
     @type InheritingDict
     */
    cache: null,

    /**
     @private
     @property factoryCache
     @type InheritingDict
     */
    factoryCache: null,

    /**
     @private
     @property validationCache
     @type InheritingDict
     */
    validationCache: null,

    /**
     Given a fullName return a corresponding instance.
      The default behaviour is for lookup to return a singleton instance.
     The singleton is scoped to the container, allowing multiple containers
     to all have their own locally scoped singletons.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter');
      twitter instanceof Twitter; // => true
      // by default the container will return singletons
     let twitter2 = container.lookup('api:twitter');
     twitter2 instanceof Twitter; // => true
      twitter === twitter2; //=> true
     ```
      If singletons are not wanted, an optional flag can be provided at lookup.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      registry.register('api:twitter', Twitter);
      let twitter = container.lookup('api:twitter', { singleton: false });
     let twitter2 = container.lookup('api:twitter', { singleton: false });
      twitter === twitter2; //=> false
     ```
      @private
     @method lookup
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */
    lookup: function (fullName, options) {
      return lookup(this, this.registry.normalize(fullName), options);
    },

    /**
     Given a fullName, return the corresponding factory.
      @private
     @method lookupFactory
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] The fullname of the request source (used for local lookup)
     @return {any}
     */
    lookupFactory: function (fullName, options) {
      return factoryFor(this, this.registry.normalize(fullName), options);
    },

    /**
     A depth first traversal, destroying the container, its descendant containers and all
     their managed objects.
      @private
     @method destroy
     */
    destroy: function () {
      eachDestroyable(this, function (item) {
        if (item.destroy) {
          item.destroy();
        }
      });

      this.isDestroyed = true;
    },

    /**
     Clear either the entire cache or just the cache for a particular key.
      @private
     @method reset
     @param {String} fullName optional key to reset; if missing, resets everything
     */
    reset: function (fullName) {
      if (arguments.length > 0) {
        resetMember(this, this.registry.normalize(fullName));
      } else {
        resetCache(this);
      }
    },

    /**
     Returns an object that can be used to provide an owner to a
     manually created instance.
      @private
     @method ownerInjection
     @returns { Object }
    */
    ownerInjection: function () {
      var _ref;

      return _ref = {}, _ref[_containerOwner.OWNER] = this.owner, _ref;
    }
  };

  function isSingleton(container, fullName) {
    return container.registry.getOption(fullName, 'singleton') !== false;
  }

  function lookup(container, fullName) {
    var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    if (options.source) {
      fullName = container.registry.expandLocalLookup(fullName, options);

      // if expandLocalLookup returns falsey, we do not support local lookup
      if (!fullName) {
        return;
      }
    }

    if (container.cache[fullName] !== undefined && options.singleton !== false) {
      return container.cache[fullName];
    }

    var value = instantiate(container, fullName);

    if (value === undefined) {
      return;
    }

    if (isSingleton(container, fullName) && options.singleton !== false) {
      container.cache[fullName] = value;
    }

    return value;
  }

  function markInjectionsAsDynamic(injections) {
    injections._dynamic = true;
  }

  function areInjectionsDynamic(injections) {
    return !!injections._dynamic;
  }

  function buildInjections() /* container, ...injections */{
    var hash = {};

    if (arguments.length > 1) {
      var container = arguments[0];
      var injections = [];
      var injection = undefined;

      for (var i = 1; i < arguments.length; i++) {
        if (arguments[i]) {
          injections = injections.concat(arguments[i]);
        }
      }

      container.registry.validateInjections(injections);

      for (var i = 0; i < injections.length; i++) {
        injection = injections[i];
        hash[injection.property] = lookup(container, injection.fullName);
        if (!isSingleton(container, injection.fullName)) {
          markInjectionsAsDynamic(hash);
        }
      }
    }

    return hash;
  }

  function factoryFor(container, fullName) {
    var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var registry = container.registry;

    if (options.source) {
      fullName = registry.expandLocalLookup(fullName, options);

      // if expandLocalLookup returns falsey, we do not support local lookup
      if (!fullName) {
        return;
      }
    }

    var cache = container.factoryCache;
    if (cache[fullName]) {
      return cache[fullName];
    }
    var factory = registry.resolve(fullName);
    if (factory === undefined) {
      return;
    }

    var type = fullName.split(':')[0];
    if (!factory || typeof factory.extend !== 'function' || !_emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS && type === 'model') {
      if (factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      // TODO: think about a 'safe' merge style extension
      // for now just fallback to create time injection
      cache[fullName] = factory;
      return factory;
    } else {
      var injections = injectionsFor(container, fullName);
      var factoryInjections = factoryInjectionsFor(container, fullName);
      var cacheable = !areInjectionsDynamic(injections) && !areInjectionsDynamic(factoryInjections);

      factoryInjections._toString = registry.makeToString(factory, fullName);

      var injectedFactory = factory.extend(injections);

      // TODO - remove all `container` injections when Ember reaches v3.0.0
      injectDeprecatedContainer(injectedFactory.prototype, container);
      injectedFactory.reopenClass(factoryInjections);

      if (factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      if (cacheable) {
        cache[fullName] = injectedFactory;
      }

      return injectedFactory;
    }
  }

  function injectionsFor(container, fullName) {
    var registry = container.registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    var injections = buildInjections(container, registry.getTypeInjections(type), registry.getInjections(fullName));
    injections._debugContainerKey = fullName;

    _containerOwner.setOwner(injections, container.owner);

    return injections;
  }

  function factoryInjectionsFor(container, fullName) {
    var registry = container.registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    var factoryInjections = buildInjections(container, registry.getFactoryTypeInjections(type), registry.getFactoryInjections(fullName));
    factoryInjections._debugContainerKey = fullName;

    return factoryInjections;
  }

  function instantiate(container, fullName) {
    var factory = factoryFor(container, fullName);
    var lazyInjections = undefined,
        validationCache = undefined;

    if (container.registry.getOption(fullName, 'instantiate') === false) {
      return factory;
    }

    if (factory) {
      if (typeof factory.create !== 'function') {
        throw new Error('Failed to create an instance of \'' + fullName + '\'. Most likely an improperly defined class or' + ' an invalid module export.');
      }

      validationCache = container.validationCache;

      validationCache[fullName] = true;

      var obj = undefined;

      if (typeof factory.extend === 'function') {
        // assume the factory was extendable and is already injected
        obj = factory.create();
      } else {
        // assume the factory was extendable
        // to create time injections
        // TODO: support new'ing for instantiation and merge injections for pure JS Functions
        var injections = injectionsFor(container, fullName);

        // Ensure that a container is available to an object during instantiation.
        // TODO - remove when Ember reaches v3.0.0
        // This "fake" container will be replaced after instantiation with a
        // property that raises deprecations every time it is accessed.
        injections.container = container._fakeContainerToInject;
        obj = factory.create(injections);

        // TODO - remove when Ember reaches v3.0.0
        if (!Object.isFrozen(obj) && 'container' in obj) {
          injectDeprecatedContainer(obj, container);
        }
      }

      return obj;
    }
  }

  // TODO - remove when Ember reaches v3.0.0
  function injectDeprecatedContainer(object, container) {
    Object.defineProperty(object, 'container', {
      configurable: true,
      enumerable: false,
      get: function () {
        return this[CONTAINER_OVERRIDE] || container;
      },

      set: function (value) {

        this[CONTAINER_OVERRIDE] = value;

        return value;
      }
    });
  }

  function eachDestroyable(container, callback) {
    var cache = container.cache;
    var keys = Object.keys(cache);

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = cache[key];

      if (container.registry.getOption(key, 'instantiate') !== false) {
        callback(value);
      }
    }
  }

  function resetCache(container) {
    eachDestroyable(container, function (value) {
      if (value.destroy) {
        value.destroy();
      }
    });

    container.cache.dict = _emberMetalDictionary.default(null);
  }

  function resetMember(container, fullName) {
    var member = container.cache[fullName];

    delete container.factoryCache[fullName];

    if (member) {
      delete container.cache[fullName];

      if (member.destroy) {
        member.destroy();
      }
    }
  }
})(Em._e[246],Em._e[4],Em._e[0],Em._e[218],Em._e[70],Em._e[245],Em._e[13]);
(function (exports, _emberMetalDebug, _emberMetalDictionary, _emberMetalEmpty_object, _emberMetalAssign, _containerContainer, _emberMetalUtils) {
  'use strict';

  exports.default = Registry;
  exports.privatize = privatize;

  var VALID_FULL_NAME_REGEXP = /^[^:]+:[^:]+$/;

  /**
   A registry used to store factory and option information keyed
   by type.
  
   A `Registry` stores the factory and option information needed by a
   `Container` to instantiate and cache objects.
  
   The API for `Registry` is still in flux and should not be considered stable.
  
   @private
   @class Registry
   @since 1.11.0
  */

  function Registry(options) {
    this.fallback = options && options.fallback ? options.fallback : null;

    if (options && options.resolver) {
      this.resolver = options.resolver;

      if (typeof this.resolver === 'function') {
        deprecateResolverFunction(this);
      }
    }

    this.registrations = _emberMetalDictionary.default(options && options.registrations ? options.registrations : null);

    this._typeInjections = _emberMetalDictionary.default(null);
    this._injections = _emberMetalDictionary.default(null);
    this._factoryTypeInjections = _emberMetalDictionary.default(null);
    this._factoryInjections = _emberMetalDictionary.default(null);

    this._localLookupCache = new _emberMetalEmpty_object.default();
    this._normalizeCache = _emberMetalDictionary.default(null);
    this._resolveCache = _emberMetalDictionary.default(null);
    this._failCache = _emberMetalDictionary.default(null);

    this._options = _emberMetalDictionary.default(null);
    this._typeOptions = _emberMetalDictionary.default(null);
  }

  Registry.prototype = {
    /**
     A backup registry for resolving registrations when no matches can be found.
      @private
     @property fallback
     @type Registry
     */
    fallback: null,

    /**
     An object that has a `resolve` method that resolves a name.
      @private
     @property resolver
     @type Resolver
     */
    resolver: null,

    /**
     @private
     @property registrations
     @type InheritingDict
     */
    registrations: null,

    /**
     @private
      @property _typeInjections
     @type InheritingDict
     */
    _typeInjections: null,

    /**
     @private
      @property _injections
     @type InheritingDict
     */
    _injections: null,

    /**
     @private
      @property _factoryTypeInjections
     @type InheritingDict
     */
    _factoryTypeInjections: null,

    /**
     @private
      @property _factoryInjections
     @type InheritingDict
     */
    _factoryInjections: null,

    /**
     @private
      @property _normalizeCache
     @type InheritingDict
     */
    _normalizeCache: null,

    /**
     @private
      @property _resolveCache
     @type InheritingDict
     */
    _resolveCache: null,

    /**
     @private
      @property _options
     @type InheritingDict
     */
    _options: null,

    /**
     @private
      @property _typeOptions
     @type InheritingDict
     */
    _typeOptions: null,

    /**
     Creates a container based on this registry.
      @private
     @method container
     @param {Object} options
     @return {Container} created container
     */
    container: function (options) {
      return new _containerContainer.default(this, options);
    },

    /**
     Registers a factory for later injection.
      Example:
      ```javascript
     let registry = new Registry();
      registry.register('model:user', Person, {singleton: false });
     registry.register('fruit:favorite', Orange);
     registry.register('communication:main', Email, {singleton: false});
     ```
      @private
     @method register
     @param {String} fullName
     @param {Function} factory
     @param {Object} options
     */
    register: function (fullName, factory) {
      var options = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

      if (factory === undefined) {
        throw new TypeError('Attempting to register an unknown factory: \'' + fullName + '\'');
      }

      var normalizedName = this.normalize(fullName);

      if (this._resolveCache[normalizedName]) {
        throw new Error('Cannot re-register: \'' + fullName + '\', as it has already been resolved.');
      }

      delete this._failCache[normalizedName];
      this.registrations[normalizedName] = factory;
      this._options[normalizedName] = options;
    },

    /**
     Unregister a fullName
      ```javascript
     let registry = new Registry();
     registry.register('model:user', User);
      registry.resolve('model:user').create() instanceof User //=> true
      registry.unregister('model:user')
     registry.resolve('model:user') === undefined //=> true
     ```
      @private
     @method unregister
     @param {String} fullName
     */
    unregister: function (fullName) {

      var normalizedName = this.normalize(fullName);

      this._localLookupCache = new _emberMetalEmpty_object.default();

      delete this.registrations[normalizedName];
      delete this._resolveCache[normalizedName];
      delete this._failCache[normalizedName];
      delete this._options[normalizedName];
    },

    /**
     Given a fullName return the corresponding factory.
      By default `resolve` will retrieve the factory from
     the registry.
      ```javascript
     let registry = new Registry();
     registry.register('api:twitter', Twitter);
      registry.resolve('api:twitter') // => Twitter
     ```
      Optionally the registry can be provided with a custom resolver.
     If provided, `resolve` will first provide the custom resolver
     the opportunity to resolve the fullName, otherwise it will fallback
     to the registry.
      ```javascript
     let registry = new Registry();
     registry.resolver = function(fullName) {
        // lookup via the module system of choice
      };
      // the twitter factory is added to the module system
     registry.resolve('api:twitter') // => Twitter
     ```
      @private
     @method resolve
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Function} fullName's factory
     */
    resolve: function (fullName, options) {
      var factory = resolve(this, this.normalize(fullName), options);
      if (factory === undefined && this.fallback) {
        var _fallback;

        factory = (_fallback = this.fallback).resolve.apply(_fallback, arguments);
      }
      return factory;
    },

    /**
     A hook that can be used to describe how the resolver will
     attempt to find the factory.
      For example, the default Ember `.describe` returns the full
     class name (including namespace) where Ember's resolver expects
     to find the `fullName`.
      @private
     @method describe
     @param {String} fullName
     @return {string} described fullName
     */
    describe: function (fullName) {
      if (this.resolver && this.resolver.lookupDescription) {
        return this.resolver.lookupDescription(fullName);
      } else if (this.fallback) {
        return this.fallback.describe(fullName);
      } else {
        return fullName;
      }
    },

    /**
     A hook to enable custom fullName normalization behaviour
      @private
     @method normalizeFullName
     @param {String} fullName
     @return {string} normalized fullName
     */
    normalizeFullName: function (fullName) {
      if (this.resolver && this.resolver.normalize) {
        return this.resolver.normalize(fullName);
      } else if (this.fallback) {
        return this.fallback.normalizeFullName(fullName);
      } else {
        return fullName;
      }
    },

    /**
     Normalize a fullName based on the application's conventions
      @private
     @method normalize
     @param {String} fullName
     @return {string} normalized fullName
     */
    normalize: function (fullName) {
      return this._normalizeCache[fullName] || (this._normalizeCache[fullName] = this.normalizeFullName(fullName));
    },

    /**
     @method makeToString
      @private
     @param {any} factory
     @param {string} fullName
     @return {function} toString function
     */
    makeToString: function (factory, fullName) {
      if (this.resolver && this.resolver.makeToString) {
        return this.resolver.makeToString(factory, fullName);
      } else if (this.fallback) {
        return this.fallback.makeToString(factory, fullName);
      } else {
        return factory.toString();
      }
    },

    /**
     Given a fullName check if the container is aware of its factory
     or singleton instance.
      @private
     @method has
     @param {String} fullName
     @param {Object} [options]
     @param {String} [options.source] the fullname of the request source (used for local lookups)
     @return {Boolean}
     */
    has: function (fullName, options) {
      if (!this.isValidFullName(fullName)) {
        return false;
      }

      var source = options && options.source && this.normalize(options.source);

      return has(this, this.normalize(fullName), source);
    },

    /**
     Allow registering options for all factories of a type.
      ```javascript
     let registry = new Registry();
     let container = registry.container();
      // if all of type `connection` must not be singletons
     registry.optionsForType('connection', { singleton: false });
      registry.register('connection:twitter', TwitterConnection);
     registry.register('connection:facebook', FacebookConnection);
      let twitter = container.lookup('connection:twitter');
     let twitter2 = container.lookup('connection:twitter');
      twitter === twitter2; // => false
      let facebook = container.lookup('connection:facebook');
     let facebook2 = container.lookup('connection:facebook');
      facebook === facebook2; // => false
     ```
      @private
     @method optionsForType
     @param {String} type
     @param {Object} options
     */
    optionsForType: function (type, options) {
      this._typeOptions[type] = options;
    },

    getOptionsForType: function (type) {
      var optionsForType = this._typeOptions[type];
      if (optionsForType === undefined && this.fallback) {
        optionsForType = this.fallback.getOptionsForType(type);
      }
      return optionsForType;
    },

    /**
     @private
     @method options
     @param {String} fullName
     @param {Object} options
     */
    options: function (fullName) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var normalizedName = this.normalize(fullName);
      this._options[normalizedName] = options;
    },

    getOptions: function (fullName) {
      var normalizedName = this.normalize(fullName);
      var options = this._options[normalizedName];

      if (options === undefined && this.fallback) {
        options = this.fallback.getOptions(fullName);
      }
      return options;
    },

    getOption: function (fullName, optionName) {
      var options = this._options[fullName];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      }

      var type = fullName.split(':')[0];
      options = this._typeOptions[type];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      } else if (this.fallback) {
        return this.fallback.getOption(fullName, optionName);
      }
    },

    /**
     Used only via `injection`.
      Provides a specialized form of injection, specifically enabling
     all objects of one type to be injected with a reference to another
     object.
      For example, provided each object 