import React from 'react';
import ReactDOM from 'react-dom';
import ApolloClient from 'apollo-client'
import { InMemoryCache } from 'apollo-cache-inmemory';
import { HttpLink } from 'apollo-link-http';
import { BrowserRouter, Route } from 'react-router-dom'
import { ApolloProvider } from 'react-apollo'
import './index.css';
import App from './App';
import HomePage from './home-page';
import registerServiceWorker from './registerServiceWorker';

const cache = new InMemoryCache();

const apolloClient = new ApolloClient({
  link: new HttpLink({
    uri: 'https://manners-dsk.aka.amazon.com:8143/gql'
  }),
  cache
})

ReactDOM.render((
  <ApolloProvider client={apolloClient}>
    <BrowserRouter>
      <Route path='/' component={HomePage} />
    </BrowserRouter>
  </ApolloProvider>
  ),
  document.getElementById('root')
)
registerServiceWorker();