[Deployment status]

### Overview

Prime Tools is a Slack slash-command that provides Twitch Prime related operational utilities.

```
/sam [ command ] [ ...arguments ]
```

### Development

#### Requirements

install Node v8.10. npm install.

#### Scripts

```sh
$ npm run dev           # Build and deploy for quick testing on slack.
$ npm run prod          # Build and deploy to production.
$ npm run build         # Build the application.
$ npm run deploy        # Deploy to the development Lambda.
$ npm run clean         # Delete build artifacts.
$ npm test              # Test commands locally (requires connection to Twitch network).
```

The `dev` script enables rapid development by directly uploading to a Beta version of the Lambda. You can immediately test your changes in the Twitch slack workspace with `/samd`.

To use the `dev` script, you need to set up an AWS profile on your computer with the samus-gateway AWS account.

1. Install the AWS CLI via brew or pip. [Pip is recommended for whatever reason](https://docs.aws.amazon.com/cli/latest/userguide/installing.html).
2. Create an IAM user via Isengard or the IAM dashboard in the AWS console for samus-gateway. Attach the appropriate policies (lambda...).
3. Navigate to the IAM dashboard, go to **Users** and find your newly created user. Go to the **Security Credentials** tab and create an access key. Save the key ID and Secret for the next step.
4. Run the following command:

```sh
$ aws configure --profile gateway # The following lines are interactive outputs from this command.
AWS Access Key ID [None]: AK***********CA
AWS Secret Access Key [None]: 6M********************Ta
Default region name [None]: us-west-2
Default output format [None]:
```

### Structure

```
PrimeTools/
├── authorizer/         # Lambda authorizer
├── scripts/            # NPM scripts
├── lambda/             # Source code
│   ├── commands/           # Commands
│   ├── services/           # External services & resources
│   ├── util/               # Utility functions
│   ├── prototypes/         # Shared types
│   ├── . . .
│   └── index.js            # Entry point
├── . . .
└── index.js            # Lambda entry point.
```

### Architecture

GitHub, lambda, api gateway, code deploy, slack app page,
