var moment = require('moment')
var SamusGateway = require('../services/SamusGateway')
var Subscriptions = require('../services/Subscriptions')
var getUserId = require('../getUserId')

const TWITCH_PRIME_PRODUCT_ID = '12658'

/**
 * Return the user's active Twitch Prime subsciption.
 */
async function prime(user) {
  // todo handle kraken can't find user id
  const userId = await getUserId(user)

  // Execute steps in parallel.
  const diagnoses = await Promise.all([
    SamusGateway.GetSubscriptionCreditBalance(userId),
    Subscriptions.ListUserSubscriptions(userId)
  ])

  const balance = diagnoses[0].subscriptionCreditBalance
  const primeSubs = diagnoses[1].results.filter(
    sub => sub.subscription.is_prime && sub.subscription.product_id !== TWITCH_PRIME_PRODUCT_ID
  )
  const ids = primeSubs.map(sub => sub.subscription.product_id)  

  const getProductsByIDsResponse = await Subscriptions.GetProductsByIDs(ids)
  const products = getProductsByIDsResponse.products

  const output = products.map(p => {
    return {
      name: p.short_name,
      owner_id: p.owner_id,
      display: p.display_name,
      tier: p.tier,
      start: primeSubs.find(s => s.subscription.product_id === p.id).subscription.benefit_start
    }
  })

  const markdown = output.map(o => `
    *${ o.display }*
    · Short Name: ${o.name}
    · Owner ID: ${o.owner_id}
    · Tier: ${o.tier}
    · Start Time: ${ o.start && moment(o.start).toString() }
  `).join('\n')
  
  return `
    Twitch Prime Subscription Credit Balance: ${ balance }
 
    Active Prime Subscriptions:
    ${ markdown }
  `

}

module.exports = prime
