var moment = require('moment')
var Subscriptions = require('../services/Subscriptions')
var getUserId = require('../getUserId')

/**
 * Return the given user's active subscriptions.
 */
async function subs(user) {
  const userId = await getUserId(user)

  const listUserSubscriptionsResponse = await Subscriptions.ListUserSubscriptions(userId)
  const subs = listUserSubscriptionsResponse.results
  const ids = subs.map(sub => sub.subscription.product_id)  

  const getProductsByIDsResponse = await Subscriptions.GetProductsByIDs(ids)
  const products = getProductsByIDsResponse.products

  const output = products.map(p => {
    const sub = subs.find(s => s.subscription.product_id === p.id).subscription
    return {
      name: p.short_name,
      owner_id: p.owner_id,
      display: p.display_name,
      is_prime: sub.is_prime,
      platform: sub.platform,
      tier: p.tier,
      start: sub.benefit_start
    }
  })

  const markdown = output.map(o => `
    *${ o.display }*
    · Short Name: ${ o.name }
    · Owner ID: ${ o.owner_id || 'TURBO_TYPE' }
    · Is Prime: ${ o.is_prime }
    · Tier: ${ o.tier }
    · Platform: ${ o.platform }
    · Start Time: ${ o.start && moment(o.start).toString() }
  `).join('\n')

  return `
    *${ user }'s Subscriptions*
    ${ markdown }
  `
}

module.exports = subs
