var axios = require('axios')

function configureSlackResponder(responseUrl) {
  return async function sendResponse(message) {
    return axios({
      method: 'POST',
      url: responseUrl,
      headers: {
        'Content-Type': 'application/json'
      },
      data: {
        response_type: process.env.NODE_ENV === 'production' ? 'in_channel' : 'ephemeral',
        text: message
      }
    })
  }
}

module.exports = configureSlackResponder
