const crypto = require('crypto')

const signing_secret = '6830080808f29ee3cab20b2e5f462de3'
const ver_num = 'v0'

function validateSlackRequest({ timestamp, body, signature }) {

  console.log(`
    Validating Slack Request
    timestamp:\t${ timestamp }
    body:\t${ body }
    signature:\t${ signature }
  `)

  // Check if timestamp is more than five minutes from local time.
  if (new Date().getTime() - (timestamp * 1000) > 1000 * 60 * 5) {
    let error = 'Request timestamp is more than five minutes from the current time.'
    console.error(error)
    throw new Error(error)
  }

  // Concatenate the version number, the timestamp, and the body of the request to form a basestring.
  const sig_basestring = [ ver_num, timestamp, body ].join(':')

  // 3.
  const computed_signature = `${ ver_num }=${ crypto.createHmac('sha256', signing_secret).update(sig_basestring).digest('hex') }`

  // if bad throw new Error('lol')
  // !crypto.timingSafeEqual(computed_signature, signature)
  if (computed_signature !== signature) {
    let error = 'Invalid reqeust signature.'
    console.error(error)
    throw new Error(error)
  }

  console.log('Validated slack request.')
}

module.exports = validateSlackRequest
