var fs = require('fs')
var AWS = require('aws-sdk')

/**
 * Deploy the application to Beta Lambda.
 */
;(function main () {
  console.log('Deploying to AWS Lambda...')

  AWS.config.update({
    region: 'us-west-2'
  })

  var lambda = new AWS.Lambda()

  lambda.updateFunctionCode({
    FunctionName: process.env.NODE_ENV === 'production' ? 'PrimeTools-Prod' : 'PrimeTools-Beta',
    Publish: true,
    DryRun: false,
    ZipFile: fs.readFileSync('primetools.zip'),
  }, err => err ?
    console.error(`Deploy failed: ${ err.message }`)
  : console.log('Success.')
  )

})()
