# Core UI

Twitch Core UI is a front-end library that provides:
* React (and non-react) components
* CSS variables and utilities for theming, color, spacing, and typography
* and, an icon library

The goal of Core UI is to ensure usability, accessibility, and performance across the Twitch platform while making it easier for designs and developers to build scalable solutions.

**Visit our [Design System Site](https://git-aws.internal.justin.tv/pages/core-ui/core-ui/) for more information on designing and building interfaces at Twitch.**

---

* [Getting Started](#getting-started)
  * [Running Core UI Locally](#running-core-ui-locally)
  * [Structure](#structure)
* [Structure & Conventions](#structure-conventions)
  * [Page Title & Path](#page-title-path)
  * [Changing the Order of Pages in the Navigation](#changing-the-order-of-pages-in-the-navigation)
  * [Page Tabs](#page-tabs)
  * [Component Pages](#component-pages)
  * [Redirects](#redirects)
* [Markdown](#markdown)
* [Code Blocks & Previews](#code-blocks--previews)
* [Custom Markdown Blocks](#custom-markdown-blocks)
  * [Links](#links)
  * [Columns](#columns)
  * [Guidelines](#guidelines)
* [Deployment](#deployment)


## Getting Started

### Running Core UI Locally

To develop Core UI components, you'll need to run Core UI locally. To do this, install the dependencies:

```
yarn
```

then run the development server.

```
yarn start
```

Point your browser to [http://localhost:8090](http://localhost:8090).

### Structure
```
.
├── /data                            // all documentation content
├── /src                             // documentation specific files
│   ├── /components                  // documentation components
│   ├── /layouts                     // gatsby layouts
│   ├── /pages                       // gastby pages (homepage)
│   ├── /sass                        // documentation sass
│   ├── /templates                   // gatsby templates
│   ├── /utils                       // documentation utilities (path helper)
│   ├── declarations.ts              // module declarations
│   ├── graphql-types.d.ts           // type definitions for graphql objects
│   └── store.ts                     // Redux store
├── .editorconfig                    // shared VSCode configuration
├── .env                             // (unversioned) for github api call
├── gatsby-browser.js                // gatsby browser file
├── gatsby-config.js                 // gatsby (documentation) config
├── gatsby-node.js                   // documentation content bootstrapping
├── gatsby-ssr.js                    // gatsby ssr file
├── html.tsx                         // gatsby (documentation) html scaffolding
├── package.json                     //
├── settings.js                      // documentation settings
├── tsconfig.json                    // typescript config
├── tslint.json                      // typescript linting config
└── yarn.lock                        //
```

---

The Twitch Design System Site is a static website built on [GatsbyJS](https://www.gatsbyjs.org/) — the site provides information about our Design System and core-ui documentation. To view the documentation on your machine, see (Running Core-UI Locally)(#running-core-ui-locally).

## Structure & Conventions

All of the content for the site is made up of markdown files located in `/data`. Every directory must contain an `index.md` file for it to be generated into a page. If the page simply redirects to a child page, see [#Redirects].

```
.
├── /data
    └── /2-user-interface
        ├── /1-guidelines
        ├── /2-principles
        └── /3-components
            └── /avatar
                └── index.md
```

### Page Title & Path
The page title and path are generated automatically by the directory structure: the `index.md` file in the `/avatar` directory will create a page with the title `Avatar` located at `/user-interface/components/avatar`.

The page title can be overwritten by adding a `title` key in the frontmatter of the page's `index.md` file, ie:

```
# 2-user-interface/index.md

---
title: Getting Started with Core UI
---
```

### Changing the Order of Pages in the Navigation

By default, the site navigation will list pages alphabetically; but, the ordering can be overwritten by prefixing directory names with a number (ie. `/components` to `/3-components`). __These numbers are stripped from the URL pathname.__


### Page Tabs

Additional tabs can be added to a page (ie. a "Usage" tab can be added to a component page) by adding additional markdown files to a page's directory. To add a "Usage" tab to `/user-interface/components/animation`, create a file called `usage.md` in the `animation` directory.

Avoid naming tabs `properties.md`, `changelog.md`, and `playground.md`, as these are automatically created for component pages.

```
Note: page settings are only read from the frontmatter in the index.md of the same directory.
```


### Component Pages

A page can be linked to an individual component – to pull in that components properties and commit history – using the `component` key in the frontmatter of the page's `index.md` file, ie:

```
# 2-user-interface/3-components/avatar/index.md

---
component:
  id: components/avatar
---
```

### Redirects

Pages can redirect to a child page. This can be done by setting the `redirect` key in the `index.md` file.

```
# 2-user-interface/index.md

redirect: getting-started
```

This example will redirect the `/user-interface` page to `/user-interface/getting-started`.


## Markdown

Markdown is a simple way of writing content that can be converted into HTML markup. Becaue our titles are automatically generated, there is no need to write a title (`#` or `h1`) inside the markdown content.

```
## Heading 2
### Heading 3
#### Heading 4
```

Read more from the Markdown [cheat sheet](https://www.markdownguide.org/cheat-sheet/).

## Code Blocks & Previews

Code blocks can be written in markdown using three backticks (` ``` `). We have built in some more functionality to make code blocks even more useful. The language of the code block can be set to display syntax highlighting; and, for `jsx` snippets, the code is rendered in a preview.

```
```jsx
```

Additional classes can be added to the code block to customize the display of the editor and preview.

```
```jsx hide-code
```

| Class | Description |
|-------|-------------|
| `hide-code` | Hide the code editor. |
| `hide-preview` | For code snippets with the language set to `jsx`, hide the preview. |
| `no-copy` | Hide the `Copy Code` button.

<br />

## Custom Markdown Blocks

These blocks create a richer formatting for markdown editing. They allow us to specify data to be rendered in components within the markdown – such as resource links, columns, and guidelines. The data is accepted in `yaml` format and can be implemented through a code block, e.g.:

```
```yml block-columns
```

### Links

Render 1-2 resource link tiles.

![](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/images/markdown-block-link.png)


```
```yml block-links
```

```
-
  title: Logo Assets
  body: PNG and SVG versions of the Twitch logo, Glitch logo, and combination logo.
  url: https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/downloads/Twitch-Logos.zip
  thumbnailSrc: https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch-Logos-Download-Preview.png
  download: true
```


| Key | Type | Description |
|-----|------|-------------|
| `title` | `string` | The title of the link. |
| `body` | `string` | Description text. |
| `url` | `string` | Destination/source of the link. |
| `thumbnailSrc` | `string` | Source for the thumbnail image. |
| `download` | `boolean` | Add the `download` attribute to the link. |

<br />

### Columns

Render multiple columns of markdown content.

![](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/images/markdown-block-columns.png)

```
```yml block-columns
```

```
-
  cols: 4
  body: |
    ![Twitch Logo](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Combo---Logotype-16x9.png)
-
  cols: 4
  body: |
    ![Twitch Logo](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Glitch---Brand-Mark-16x9.png)
-
  cols: 4
  body: |
    ![Twitch Logo](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch---Logotype-16x9.png)
```

| Key | Type | Description |
|-----|------|-------------|
| `cols` | `number` | Number of columns to span. |
| `body` | `string` | Markdown content. |

<br />

### Guidelines

Render 1-2 guideline blocks with images and markdown content.

![](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/images/markdown-block-guidelines.png)

```
```yml block-guidelines
```

```
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Combo---Application---Color-and-Contrast---Dark-4x3.png'
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Combo---Application---Color-and-Contrast---Background-4x3.png'
```

| Key | Type | Description |
|-----|------|-------------|
| `type` | `do`, `dont` | Render as a ✅ or 🚫 guidelines. |
| `mediaSrc` | `string` | The source of the main image or video. |
| `caption` | `string` | A caption to display below the media. |
| `body` | `string` | Markdown content. |

<br />

### Media

Renders some media with a frame, drop shadow, and optional caption.

```
```yml block-media
```

```
mediaSrc: 'https://www.twitch.tv/example.jpg'
caption: 'Hello World!'
```

| Key | Type | Description |
|-----|------|-------------|
| `mediaSrc` | `string` | The source of the main image or video. |
| `caption` | `string` | A caption to display below the media. |

---

<br>

## Deployment

```


NOTE: THE FOLLOWING INSTRUCTIONS ARE FOR CORE DESIGN TEAM MEMBERS ONLY.


```

### Pre-requisites

#### Add a remote `core-ui`
```
git remote add core-ui git@git-aws.internal.justin.tv:core-ui/core-ui.git
```

#### GitHub Personal Access Token

We access the GitHub API to pull data like the commit history for components and user avatars. In order to access the API, you have to obtain and set a GitHub Personal Access Token as an environment variable.

To obtain a token, visit [https://git-aws.internal.justin.tv/settings/tokens](https://git-aws.internal.justin.tv/settings/tokens) and click `Generate New Token`. Add a description for the token, check `repo` under "Select scopes" and click `Generate Token`.

Copy the token and paste it in a file called `.env` in the project root, ie:

```
GITHUB_ACCESS_TOKEN=generated_access_token
```

#### Set Up the AWS CLI

To deploy docs, you'll need to be able to run the `aws` command on your machine and have permission to access our s3 bucket and Cloudfront distribution.


### Commands

All of the deploy commands will:
* checkout and pull the `master`.
* clear out `node_modules`
* run tests
* build this site.

To deploy the site to both GitHub pages and AWS, run:
```
yarn deploy
```

To deploy the site to only GitHub (https://git-aws.internal.justin.tv/pages/core-ui/core-ui/), run:
```
yarn deploy:gh-pages
```

To deploy the site to only AWS (https://design.internal.justin.tv/), run:
```
yarn deploy:aws
```
