"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var lodash_1 = require("lodash");
var visit = require("unist-util-visit");
function gatsbyRemarkCodeClassnames(_a, _b) {
    var markdownAST = _a.markdownAST;
    visit(markdownAST, 'code', function (node) {
        var language = node.lang;
        node.type = 'html';
        node.value = "<div>\n      <pre data-language=\"" + language + "\"><code data-language=\"" + language + "\">" + lodash_1.escape(node.value) + "</code></pre>\n    </div>";
    });
}
module.exports = gatsbyRemarkCodeClassnames;
