"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var crypto = require("crypto");
var glob = require("glob");
var Octokat = require("octokat");
var _1 = require("./");
exports.sourceNodes = function (_a, // tslint:disable-line no-any
_b) {
    var boundActionCreators = _a.boundActionCreators, reporter = _a.reporter;
    var user = _b.user, repository = _b.repository, token = _b.token, rootURL = _b.rootURL, cwd = _b.cwd, pattern = _b.pattern;
    var createNode = boundActionCreators.createNode;
    var octo;
    var repo = undefined;
    var logged = false;
    if (!user || !repository || !rootURL || !cwd || !pattern) {
        throw 'gatsby-source-github-enterprise is missing configuration options.';
    }
    // Throw an error (to stop build) if running `gatsby build` without specifically setting
    // GATSBY_ENV variable to `ci`.
    if (!token && process.env.GATSBY_ENV !== 'ci' && process.env.NODE_ENV === 'production') {
        throw 'gatsby-source-github-enterprise is missing a Github personal access token.';
    }
    if (token) {
        octo = new Octokat({ token: token, rootURL: rootURL });
        repo = octo.repos(user, repository);
    }
    else {
        reporter.info('could not fetch GitHub data – set your access token');
    }
    glob.sync("" + pattern, { cwd: cwd }).forEach(function (path) {
        // Gatsby needs at least one data point in order to build the GraphQL
        // structure; and without it, the GQL queries will fail on the front-end.
        // To get around this issue when this plugin fails to create real data
        // (due to a missing token or connection issues), we supply a "dummy" node.
        //
        // Note: the site will not build for deployment wihout real data.
        createNode(getProcessedNode(path, [_1.dummyCommit]));
        if (!repo) {
            return;
        }
        // For each component, create a GithubFile node.
        repo.commits.fetch({ path: path }).then(function (result) {
            if (!logged) {
                reporter.success('fetch GitHub data');
                logged = true;
            }
            // Create the GithubFile node for the component.
            createNode(getProcessedNode(path, result.items || []));
        }).catch(function (error) {
            // If run during build, stop the build.
            if (process.env.NODE_ENV === 'production') {
                throw error;
            }
            if (!logged) {
                reporter.info("could not fetch GitHub data \u2013 " + error.message);
                logged = true;
            }
        });
    });
    return;
};
var getProcessedNode = function (component, commits) {
    return {
        items: commits,
        id: "Github " + component,
        component: component.replace('src/', '').replace(/\/$/, ''),
        parent: null,
        children: [],
        internal: {
            type: 'GithubFile',
            contentDigest: crypto
                .createHash('md5')
                .update(JSON.stringify(commits))
                .digest('hex'),
        },
    };
};
