---
description: The Twitch and Glitch logos are the simplest and clearest ways for us to leave our mark as a brand.
---

```yml block-links
-
  title: Logo Assets
  body: PNG and SVG versions of the Twitch logo, Glitch logo, and combination logo.
  url: https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/downloads/Twitch-Logos.zip
  thumbnailSrc: https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch-Logos-Download-Preview.png
  download: true
```

## Variations

```yml block-columns
-
  cols: 4
  body: |
    ![Twitch Logo](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Combo---Logotype-16x9.png)
-
  cols: 4
  body: |
    ![Twitch Logo](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Glitch---Brand-Mark-16x9.png)
-
  cols: 4
  body: |
    ![Twitch Logo](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch---Logotype-16x9.png)
```

## Application

### Contrast

When applying the Twitch logo, it should contrast with whatever background it’s placed upon.
The three supplied color options (black, white, and purple) should provide a usable asset for any situation.

```yml block-guidelines
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Combo---Application---Color-and-Contrast---Dark-4x3.png'
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Combo---Application---Color-and-Contrast---Background-4x3.png'
```

### Spacing and Orientation
The Twitch logo likes a little room to breathe. Make sure it’s not crowded by or linked to other elements.

```yml block-guidelines
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch---Application---Placing-and-Spacing---Clearance-4x3.png'
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch---Application---Placing-and-Spacing---Align-4x3.png'
```



#### Examples of incorrect application due to improper spacing and/or orientation:

```yml block-guidelines
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch---Application---Placing-and-Spacing---Rotation-4x3.png'
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/brand/images/Twitch---Application---Placing-and-Spacing---Overlap-4x3.png'
```
