---
title: Getting Started
description: The Twitch Design System addresses a number of our common design objectives — visual design, accessibility, and performance — so that more complex and impactful product solutions can be designed and built.
---

## Core UI Kit
The Core UI kit provides Symbols for all of the components available in the core design system. Building with these symbols ensures that engineers will be able to easily implement designs into production-ready code. See the Twitch Design repo for more information on using the Core UI Kit.

![Sketch Kit Screenshot](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/sketch-screenshot.png)

For more information on the Core UI Kit, how to use it as a Library in the Sketch Beta, and how to contribute to it, see the Twitch-Playbook repo.


## Building Interfaces

When our core guidelines are considered at the beginning of the design process, it should be possible to build new features entirely with core components. If you come across difficulties implementing designs, read through the common questions about core-ui – or reach out to the core design team in #design-ui.

### Using the Components

#### 1. Import the component(s) and necessary type(s) at the head of the file:
```jsx hide-preview
import { Button, ButtonType } from 'carbon-components-prototype';
```

#### 2. Call the component in JSX:

```jsx
<Button type={ButtonType.Success}>Following</Button>
```

## Common Questions

### Can I add a className to core components? How do I modify core components?

Class names can not be added to core components and they cannot be modified outside of core-ui. This ensures that the components can be effectively maintained and help up to our standards of accessiblity, performance, and scalability.

If a core component is not meeting the requirements of your feature – reach out to the core design team in #design-ui.

### What do I do if I can’t find a core component that does what I’m trying to achieve?

Reach out to your team's designer(s) to see if the solution can be redefined to work within our guidelines and with the availabe core components — if not, or if you have questions, reach out to the core design team in #design-ui.

### How can I contribute to Core UI?

Core UI is a collaborative initiative that thrives on the contributions from developers across the organization. Contributions to Core UI include hotfixes, updates to existing components, and adding new components.

For more information about working with and contributing to core-ui, see our Contribution Guidelines.
