---
description: We want everyone to help solve common problems so that we can all benefit from shared re-usable code and improvements to existing patterns. Step one is to make our interface consistent; step two is to improve it system wide.
---

**There are multiple repositories:**

<a class="tw-button tw-button--hollow" href="https://git-aws.internal.justin.tv/core-ui/core-ui"><span class="tw-button__text">Core UI</span></a> &nbsp; <a class="tw-button tw-button--hollow" href="https://git-aws.internal.justin.tv/core-ui/core-ui-docs"><span class="tw-button__text">Core UI Docs</span></a> &nbsp; <a class="tw-button tw-button--hollow" href="https://git-aws.internal.justin.tv/core-ui/ui-prototype-tool"><span class="tw-button__text">UI Prototype Tool</span></a>

## Developing with Core UI

### Linking to a project

In order to preview changes, the main Core UI package must be linked to another project such as the [UI Prototype Tool](https://git-aws.internal.justin.tv/core-ui/ui-prototype-tool) or [Twilight](https://git-aws.internal.justin.tv/twilight/twilight) (there is no preview mechanism in the main repository at this time).

```shell
# Clone the main Core UI repository
git clone git@git-aws.internal.justin.tv:core-ui/core-ui.git

# Enable local linking
cd core-ui
yarn link
```

Next, we'll set up the [UI Prototype Tool](https://git-aws.internal.justin.tv/core-ui/ui-prototype-tool); these same steps will work the same way with other projects:

```shell
git clone git@git-aws.internal.justin.tv:core-ui/ui-prototype-tool.git

# Link to the main Core UI package you cloned earlier
cd ui-prototype-tool
yarn link twitch-core-ui

# Start the UI Prototyping Tool project
yarn start
```

In the Core UI Prototype Tool, Webpack will now build with your local version of `Core UI` files and watch for changes in that directory. If you look in the `node_modules` folder, you will see that a symlink has been created for the `twitch-core-ui` package, and will remain in effect until you manually unlink it.

### Staging Feature Branches

Core UI is published as an NPM package; anything you can do with a versioned package will work here. By changing the branch in the package.json file, your staging environment can deploy with any published branch of Core UI. Be sure to revert this before merging to the `master` branch of your project.

```shell
# Replace the repository URL and branch name with your own:
yarn add twitch-core-ui@git+ssh://git@git-aws.internal.justin.tv/core-ui/core-ui.git#your-branch-name
```

### Pull Requests for Core UI (main package)

#### Step 1: Submit Your PR for Review
Please fill out the PR template to the best of your ability, tag one or more Core UI team members for review.

#### Step 2: Merge and Release a Core UI version
Once your PR is approved by Core UI team, your branch will be merged by Core UI team who will also handle the release process.

#### Step 3: For Twilight Users, Coordinate a Core UI Package Upgrade
An integration PR for `twilight` will be completed by the Twilight team in order to upgrade the version of Core UI in `twilight/master`. You can test and develop with new versions of Core UI ahead of time by using `yarn link` with your local version of Core UI, or by temporarily upgrading the Core UI version of your project branch.

## Documentation

Usage guidelines and examples are maintained in [a separate repository, `core-ui-docs`,](https://git-aws.internal.justin.tv/core-ui/core-ui-docs) from the Core UI component library.

Core UI uses [typedoc](https://github.com/TypeStrong/typedoc) to provide generated documentation of component properties. Please annotate component `interfaces` in a way that provides clarity to users consumsing Core UI components. Also include:

- Description of how and when to use the component
- Code examples illustrating how to compose the component into complex layouts
- Responsive examples (if applicable)

## Creating New Components
New components can be generated with the following command, and a component folder will be created under `/src/components/`.
```shell
yarn gen -- component ComponentName
```

Some components are located within a parent group (ie. `Checkbox` under the parent group `form`). To generate a component within a parent group, and a component folder will be created under `/src/components/group-name/`.
```shell
yarn gen -- component ComponentName --pg group-name
```

Component properties and markup are defined in the component folder's `component.tsx` and component styles are located in that folders `styles.scss`.
