---
description: In organizing our design system, we’ve come up with a taxonomy and shared language to identify what each part of the system belongs to. The Core-UI taxonomy suggests a purpose for each component in the system, and also illustrates how you’re meant to use each component.
---

_It’s important to note that the word **“component”** is **not defined** in our taxonomy because a component can mean something different to every consumer. Because our pattern library is built using React.js, and in React.js anything can be a component, we’ve chosen to stay away from that word in defining our UI elements._


## Components

**Components** are the building blocks of the design system. They are small, single-purpose components that can be used to build larger components. Some examples of components include button, input, and progress bar.

![Illustration of a Twitch design primitive](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/taxonomy-primitive.png)


## Patterns

**Patterns** are composed of two or more components. These tend to be combinations of components that you’d likely use more than once. A few examples of patterns are card, form, and modal.

![Illustration of a Twitch design pattern](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/taxonomy-pattern.png)


## Principles

**Principles** are higher level concepts around how to use our components and patterns in common user flows. We will utilize them to document Twitch Design and Core-UI’s position on specific UX methods. A sampling of principles we plan to create include chat guidelines, navigation flows, and data display best practices.

![Illustration of a Twitch design principle](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/taxonomy-principle.png)
