---
description: Twitch should be accessible to anyone, anywhere. We strive to provide a clean, balanced look to better serve those with disabilities. Carefully consider font sizes, contrast, translations, and ergonomic UI when making decisions.
---

## Why is this important?

15% of the world's population lives with some form of disability, and 1 in 5 American adults have at least one kind of disability. Of those living with a form of disability; 9.4% are vision, 10.6% are cognitive, and 15.3% are associated with hearing.


## Let's Build Inclusive Experiences

### All the Right Pieces
Choose from interdependent components of Core UI to assure accessibility for all. Implementing common components across Twitch means that we can constantly improve the accessibility, usability, and aesthetic quality of UI in a single consumable, versioned, dependency. Themes are designed around our palettes and accessibility guidelines to accommodate our users.

![Twitch Light and Dark Theme Preview](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/principles/Core-UI.png)

### Alternative Text for Images

All images must have an alt attribute. Images that accompany or replace text associated with an action, such as icons in links or buttons or a logo that links to the home page, should have alt="" because it's alternative text will be the content of that link or button.

All other images must have alternative text. This text should be an accurate representation of the content of the image. It should be concise and not redundant. It also should not use the phrases: "image of ...", "picture of ...", etc. WebAIM has a [great article on how to structure alternative text](http://webaim.org/techniques/alttext/).

Any image that isn't used as a supplement to an action – link or button – must have an effective alt tag.

```jsx
<img alt='Dragon breathing fire in video game cinematics.' src='https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/principles/Accessibility-Dragon.jpg' />
```

### Color Choice

#### Contrast
People with visual and cognitive disabilities may have difficulty reading text that does not contrast strongly against it's background. Differences in display technology can compound this issue by not rendering shades with full integrity. The Contrast Checker in Colors will define which SASS color variables are accessible used on any given background.


```yml block-guidelines
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/principles/Accessibility-Contrast--Do.svg'
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/principles/Accessibility-Contrast--Dont.svg'
```


#### Communicating Meaning
For users who have difficulty distinguishing between certain colors – color blindness – it is important to consider alternative or accompanying methods of communicating interface states.

```yml block-guidelines
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/principles/Communicate-Meaning--Do.png'
  body: When communicating meaning with color, use an accompanying element, such as a label or icon, to enforce the message.
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/principles/Communicate-Meaning--Dont.png'
  body: 'Use only color to communicate a state because color blind users may not be able to interpret the meaning.'
```


### Clearly Caption Audio in Video
Use subtitles for voiceover audio and to accompany animations. They also help non-native English speakers understand the video and make it possible to search for content.

### Plan for Your Platform
Include specialized coverage for mobile and web or print projects. Follow platform guidelines to quickly develop a product using existing elements, allowing you focus on its features without having to create everything from scratch.


## Resources

### Reading
* [Material Guidelines](https://material.io/guidelines/usability/accessibility.html)
* [Facebook Accessibility Guidelines](https://code.facebook.com/accessibility)
* [HIKE](https://teachaccess.github.io/tutorial/)
* [WebAIM](http://webaim.org/)

### Tools
* [tota11y](http://khan.github.io/tota11y/)
* [Color Blindness Simulator](https://michelf.ca/projects/sim-daltonism/)
* [Color Contrast Analyser for Sketch](https://github.com/getflourish/Sketch-Color-Contrast-Analyser)
* [Accessibility Developer Tools](https://chrome.google.com/webstore/detail/accessibility-developer-t/fpkknkljclfencbdbgkenhalefipecmb?hl=e)
