---
description: Icons are used to quickly add more context and meaning to user actions that otherwise wouldn’t be possible with a simple label.
---

![A grid of icons from our Core Icons kit](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-icons-general.png)

## Icon Principles
Twitch icons should be playful and easily interpreted to their intended meaning. They shouldn’t be overly complex or used to convey complex actions or ideas.

Twitch as a product has many unique features and abstract concepts that are hard to distill into a single visual representation. Therefore, it is important that we deeply scrutinize the usage of icons in the product as a whole and any new additions to the icon library.

### Purpose
Icons are not decorative. They are carefully selected visual symbols that communicate an idea, concept, or function simply and clearly. Are you sure we need an icon at all, or does a text-only string need an anchor?

Communication comes first. Icons-only should not be used as a get out clause to save space in tight layout situations. Icons alone rarely fix a structurally broken design or usability concerns. Is a stand-alone icon with no other context providing clear call-to-action and/or wayfinding?

### Universal
Few icons are truly universal. However, for those that are (i.e. trash can = delete/destroy) much deeper scrutinization and rationale is needed for any deviation or re-representation.

### Memorable
Icons set expectation. They enable a user to predict what’s going to happen if they see, click or tap. When we can’t predict, we’re reticent to act. Is the metaphor clear and has it been tested?

### Important
Think holistically. Icons are used to help guide attention. Using too many icons across the entire product or page, dilutes their effectiveness overall. Is the icon as important as others, or does it just add visual noise?

### Obvious
Few icons work alone. Any icon that forces a user to think about what it might mean is a candidate for labelling, or even removal. Would adding a text label improve comprehension?

Strong shape and form are paramount. Icons can often be used for state management – on their own, or within larger UI components. Color alone should never inform context or interactive state. Does the icon work without color?

## Grid, Proportion & Size
All of our icons are built it work in a cohesive manner with each other. The shapes, proportions and sizes should be unified across the icon system.

**It is imperative that icons are snapped to the pixel grid and never scaled.**

### Icon Grid
Our icons are built within a 20dp viewbox. This size fits with our current measurement system built on on factors of 5dp. To achieve a cohesive sense balance and size we use a 16dp weighted center for strong square like icons.

![Twitch icons set inside their 20dp viewboxes](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-icons-grid.png)

### Content Area
**Corners, Caps & Strokes**<br />
Whenever creating a new icon, ensure you are using rounded caps and rounded corners.

All icons should have a 2px border spacing except for circular or unproportional icons.

For icons with overlapping stokes, there should be a 2px space between strokes.

![Twitch icons showing rounded end caps, 2dp spacing and 2dp corners](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-icons-details.png)

### Optical Sizing
The icons use an 18dp area space for optical adjustments on circular or simpler shape items.

## Icon Types
### Stateful Icons
Any permanent state change function, like following a channel, will always indicate whether the state is toggled on or off with a fill change. This state persists on a page refresh.

![Default buttons showing stateful icons](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-icons-stateful.png)

**You should never use a hollow and default button style to denote statefulness. Only a stateful icon should denote state of a feature or function.**

### Menu Icons
If a click on the icon will bring up a menu or modal, the icon typically becomes shadowed out (desaturated). A hover state may be used in some cases. Any temporary states (hover, clicked) will not persist on a page refresh.

![Various menu icon states with a bubble](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-icons-menu.png)
