## Theming

The Twitch platform supports multiple themes – most notably the default light theme and the dark theme. To achieve this, we have to think about color differently. Instead of thinking about the actual color choice, we reference what the color is doing in the interface.

## How to Implement Theming

All of the Core UI components are themed _out of the box_ – for feature work, theming should be used to declare every "style" property including color, borders, and shadows. It can be implemented using the `theme` sass mixin or by simply using the `StyledLayout` and `CoreText` components.

```scss
.element {
  @include theme {
    background: token('color-background-body');
    color: token('color-background-alt');
    border: token('border-width') solid token('color-border');
  }
}
```

Only use tokens that logically apply to the element being styled. For example, use only `text` tokens to style text elements and `background` tokens to style backgrounds; and, only use `button` tokens to style button elements.

If you are unsure about whether it acceptable to use a token for your use case, or you think you have a need for a token that does not yet exist, feel free to ping the @coreuiteam in #prime-carbon-support.

### Switching Between Themes

All of the CSS provided by `core-ui` follows the light theme by default. Toggling between light and dark is as simple as adding and removing the theme class to the root element of your app – we recommend the `html` element so that the `body` can adopt theme declarations:

```html
<html class="tw-root--theme-dark">
```

Handling this dynamically in javascript may look something like this:

```js
// Enable the dark theme.
document.documentElement.classList.add('tw-root--theme-dark');

// Disable the dark theme.
document.documentElement.classList.remove('tw-root--theme-dark');
```

## Theme Token Mapping

### Background Color
| Token Name | Light Theme | Dark Theme |
|------------|------------:|------------:|
| `color-background-body` | `$hinted-grey-15` | `$twitch-purple-2` |
| `color-background-base` | `$white` | `$twitch-purple-3` |
| `color-background-alt` | `$hinted-grey-15` | `$twitch-purple-2` |
| `color-background-alt-2` | `$hinted-grey-14` | `$twitch-purple-1` |
| `color-background-accent` | `$twitch-purple-7` | `$twitch-purple-7` |
| `color-background-accent-alt` | `$twitch-purple-8` | `$twitch-purple-5` |
| `color-background-accent-alt-2` | `$twitch-purple-5` | `$twitch-purple-4` |
| `color-background-overlay` | `$opac-b-9` | ` $opac-b-9` |
| `color-background-live`| `$red` | `$red` |
| `color-background-prime` | `$prime-blue` | `$prime-blue` |

### Text Color
| Token Name | Light Theme | Dark Theme |
|------------|------------:|------------:|
| `color-text` | `$hinted-grey-2` | `$hinted-grey-12` |
| `color-text-alt` | `$hinted-grey-4` | `$hinted-grey-10` |
| `color-text-alt-2` | `$hinted-grey-7` | `$hinted-grey-8` |
| `color-text-link` | `$twitch-purple-7` | `$twitch-purple-10` |
| `color-text-overlay` | `$hinted-grey-15` | `$hinted-grey-15` |
| `color-text-overlay-alt` | `$hinted-grey-12` | `$hinted-grey-12` |
| `color-text-overlay-link` | `$twitch-purple-10` | `$twitch-purple-10`
| `color-text-live` | `$red` | `$red` |
| `color-text-alert` | `$red` | `$red` |
| `color-text-prime` | `$prime-blue` | `$prime-blue` |

### Border Color
| Token Name | Light Theme | Dark Theme |
|------------|------------:|------------:|
| `color-border` | `$hinted-grey-12` | `$twitch-purple-4` |
| `color-border-overlay` | `$opac-w-5` | `$opac-w-5` |
| `color-border-brand` | `$twitch-purple-7` | `$twitch-purple-7` |
| `color-border-alert` | `$red` | `$red` |
| `color-border-error` | `$red`  | `$red` |

### Fill Color
| Token Name | Light Theme | Dark Theme |
|------------|------------:|------------:|
| `color-fill` | `$hinted-grey-2` | `$hinted-grey-15` |
| `color-fill-current` | `currentColor` | `currentColor` |
| `color-fill-alt` | `$hinted-grey-4` | `$hinted-grey-11` |
| `color-fill-alt-2` | `$hinted-grey-7` | `$hinted-grey-8` |
| `color-fill-brand` | `$twitch-purple-7` | `$twitch-purple-8` |
| `color-fill-offline` | `$hinted-grey-9` | `$hinted-grey-7` |
| `color-fill-hosting` | `$yellow` | `$yellow` |
| `color-fill-live` | `$red` | `$red` |
| `color-fill-warn` | `$warn` | `$warn` |
| `color-fill-alert` | `$red` | `$red` |
| `color-fill-success` | `$green` | `$green` |
| `color-fill-prime` | `$prime-blue` | `$prime-blue` |

### Social Color
| Token Name | Light Theme | Dark Theme |
|------------|------------:|------------:|
| `color-social-twitter` | `$color-twitter` | `$color-twitter` |
| `color-social-facebook` | `$color-facebook` | `$color-facebook` |
| `color-social-reddit` | `$color-reddit` | `$color-reddit` |
| `color-social-snapchat` | `$color-snapchat` | `$color-snapchat` |
| `color-social-instagram` | `$color-instagram` | `$color-instagram` |
| `color-social-youtube` | `$color-youtube` | `$color-youtube` |
| `color-social-paypal` | `$color-paypal` | `$color-paypal` |
| `color-social-vk` | `$color-vk` | `$color-vk` |


### Border Settings
| Token Name | Light Theme | Dark Theme |
|------------|------------:|------------:|
| `border-width` | `1px` | `1px` |
| `border-width-marked` | `3px` | `3px` |
| `border-radius-none` | `none` | `none` |
| `border-radius-small` | `2px` | `2px` |
| `border-radius-medium` | `2px` | `2px` |
| `border-radius-large` | `4px` | `4px` |
| `border-radius-rounded` | `50%` | `50%` |

Visit the source for a [full reference of available tokens](https://git-aws.internal.justin.tv/core-ui/core-ui/blob/master/src/scss/themes/theme-light.scss).
