---
title: Colors and Theming on Web
description: Our color usage defines the Twitch experience and revolves around the Twitch brand. Color is one of the basic building blocks of our overall style and user experience.
---

## Color Palette

We use Twitch purples and hinted greys with subtle incremental steps at the ends of both light and dark while taking larger steps at the midpoint. This gives designers the range and flexibility they desire and keeps consistency and accessibility in mind.

![Twitch Color pallet](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-pallette.png)

## Accessibility and Legibility
Background colors have been checked for a minimum WCAG readability contrast ratio of 4.5:1 for text sizes lower than 18px. This requirement is known as AA.

## The Light Curve
The following graphs show the actual lightness curve of our Twitch purples along with a degree of change at each step.

Twitch supports interfaces on both light and dark backgrounds and as a result uses an inversed lightness curve to support both. Lightness values changes are smaller and closer together as it reaches each end of the spectrum to facilitate the subtle changes needed at these ends.

The following values are used for lightness (using [HSL color] (http://www.css3.info/preview/hsl/)) in our range of 15 purples and greys.

![Twitch Color HSL Lightness Curve](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-lightness.png)

Lightness Values: [6, 8, 10, 14, 23, 34, 55, 65, 74, 83, 90, 94, 96, 98]


#### Twitch Purple

Twitch has long used Twitch Purple as the basis for creating both dark and light themes in our products, and uses it to unite the brand between product and marketing. We bleed purple into 15 different shades.

| Name |  |
|------|----------:|
| Twitch Purple 1 | `$twitch-purple-1` |
| Twitch Purple 2 | `$twitch-purple-2` |
| Twitch Purple 3 | `$twitch-purple-3` |
| Twitch Purple 4 | `$twitch-purple-4` |
| Twitch Purple 5 | `$twitch-purple-5` |
| Twitch Purple 6 | `$twitch-purple-6` |
| Twitch Purple 7 | `$twitch-purple-7` |
| Twitch Purple 8 | `$twitch-purple-8` |
| Twitch Purple 9 | `$twitch-purple-9` |
| Twitch Purple 10 | `$twitch-purple-10` |
| Twitch Purple 11 | `$twitch-purple-11` |
| Twitch Purple 12 | `$twitch-purple-12` |
| Twitch Purple 13 | `$twitch-purple-13` |
| Twitch Purple 14 | `$twitch-purple-14` |
| Twitch Purple 15 | `$twitch-purple-15` |

### Hinted Grey

Twitch uses purple as its primary color and we want that to be subtly reflected in all we do. Our greys use a purple light source to achieve a very subtle purple ambiance throughout our design. Many of our greys were already using a slight saturation and this has been normalized throughout our greys.

| Name |    |
|------|------------:|
| Hinted Grey 1 | `$hinted-grey-1` |
| Hinted Grey 2 | `$hinted-grey-2` |
| Hinted Grey 3 | `$hinted-grey-3` |
| Hinted Grey 4 | `$hinted-grey-4` |
| Hinted Grey 5 | `$hinted-grey-5` |
| Hinted Grey 6 | `$hinted-grey-6` |
| Hinted Grey 7 | `$hinted-grey-7` |
| Hinted Grey 8 | `$hinted-grey-8` |
| Hinted Grey 9 | `$hinted-grey-9` |
| Hinted Grey 10 | `$hinted-grey-10` |
| Hinted Grey 11 | `$hinted-grey-11` |
| Hinted Grey 12 | `$hinted-grey-12` |
| Hinted Grey 13 | `$hinted-grey-13` |
| Hinted Grey 14 | `$hinted-grey-14` |
| Hinted Grey 15 | `$hinted-grey-15` |

#### Utility Colors

Convey meaning through various contextual colors that we’ve introduced. For example, using $twitch-red is great for conveying attention and alerting the user when something went wrong, while $twitch-green is great conveying that something positive or successful has happened.

| Name |  |
|------|----------:|
| White | `$white` |
| Black | `$black` |
| Red (Alert) | `$red` |
| Orange | `$orange` |
| Yellow | `$yellow` |
| Green (Success) | `$green` |
| Blue (Prime) | `$blue` |

## Using Color

### Color Hierarchy

Color usage should convey a sense of visual and navigational hierarchy to your design. Use color to segment your layout and UX into sections or draw a users eye to a specific area or task. Color can also indicate which objects the user can interact with, how they relate to other elements and their level of prominence.

Our theme tokens are build on a system of hirarchy. Typically, you should build your interface following this. Start with the page Body background, then move up to a Base layer and then Alt and Alt 2 for things like toolbars or navigation bars on top of that.

#### Light Theme Hirarchy
![Light Theme Token Hirarchy](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-usage-light-theme.png)

#### Dark Theme Hirarchy
![Dark Theme Token Hirarchy](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-usage-dark-theme.png)

#### Hirarchy in Use
When using the color system, think of how your content will be interacted with in your UI. What's stationary? What scrolls? Is there enough contrast between your text content and background color?

```yml block-guidelines
-
  type: 'do'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-do.png'
  body: |
    Build on the order of the theme hirarchy– Body (Page Background), Base (Window Bakcground) and Alt (Top Bar).
-
  type: 'dont'
  mediaSrc: 'https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-dont.png'
  body: |
    Choose color tokens at random eventhough they provide contrast with other elements.
```

### Theme and Color Tokens

Twitch uses a series of tokens to represent colors in our themes. The theme tokens have intent behind their body, base and alt colors to ensure accessibility, legibility and general navigational and page layout hirarchy.

For example, our color pallet tokens **_$hinted-grey-15_** in our light theme and **_$twitch-purple-2_** in our dark theme map to the theme token **_color-background-alt_** which would be used as tertiary pieces inside of the base theme color ($white in the light theme or $twitch-purple-3 in our dark theme).

![Diagram of how color tokens map to theme tokens](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-theme-token-mapping.png)
Choose your colors based on intent and the appropriate token rather than by the way they appear in the page. If your design or layout looks strange with the existing tokens/system, consider revising it to work with the existing tokens and hierarchy.


[Learn more about Theme Mapping and Usage](/user-interface/principles/colors-and-theming/usage)

#### Light Theme

![Mapping of Color Tokens on Light Theme](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-light-theme.png)

#### Dark Theme

![Mapping of Color Tokens on Light Theme](https://s3-us-west-2.amazonaws.com/web-design-int-production/assets/ui/images/principle-color-dark-theme.png)


# Resources

* [Original 'New Color' Proposal](https://docs.google.com/a/justin.tv/document/d/16ldjLjI3tt0pPTXEJce0kIlxeH78HQQrJBjlkk0R8PA/edit?usp=sharing)
